#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=openclip_evaluate_original
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

# BIT=None
# W_QUANT=None
# A_QUANT=None

BIT=8
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=2 python -m open_clip_train.main_search \
    --ms-coco /data/COCO/coco_data/val2017 \
    --ms-coco-annot /data/COCO/coco_data/annotations/captions_val2017.json \
    --model ViT-B-16 \
    --pretrained laion2b_s34b_b88k \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name openclip \
    --batch-size 64 \
    --bit 32 \
    --baseline original \
    \
    --eval-only \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --prefix-number 12 \
    --global-prefix-rank 4 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    --token-delete \
    --token-delete-block "[6]" \
    --token-delete-number 0 \

