#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=openclip_evaluate_original
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=8
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=6 python -m open_clip_train.main_search \
    --imagenet-val /home/user/data/ILSVRC2012/train_sample_50_per_class \
    --model ViT-B-16 \
    --pretrained laion2b_s34b_b88k \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name openclip \
    --batch-size 64 \
    --bit ${BIT} \
    --baseline original \
    \
    --prefix-add \
    --cache-option KV_Cache \
    --max-global-prefix-rank 20 \
    --target-block 6 \
    --target-layer ffn_fc2 \
    --prefix-search-mode \

