#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=siglip2_evaluate_awq
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=None
W_QUANT=None
A_QUANT=None

CUDA_VISIBLE_DEVICES=2 python -m open_clip_train.main_search \
    --ms-coco /data/COCO/coco_data/val2017 \
    --ms-coco-annot /data/COCO/coco_data/annotations/captions_val2017.json \
    --model ViT-B-16-SigLIP2 \
    --pretrained webli \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name siglip2 \
    --batch-size 64 \
    --bit 6 \
    --baseline awq \
    \
    --eval-only \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[3,4,5,6,7,8,9,10,11]" \
    --prefix-number 1 \
    --global-prefix-rank 15 \
    --target-block 3 \
    --target-layer ffn_fc2 \
    # --token-delete \
    # --token-delete-block "[5]" \
    # --token-delete-number 0 \
    # > ${RESULT_FILE} 2>&1
    # --token-delete-previous-layer 0 \
    # --token-delete-method value \
    # --head-index-for-score 2 \