#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=siglip2_prefix_search_awq
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=None
W_QUANT=None
A_QUANT=None

CUDA_VISIBLE_DEVICES=2 python -m open_clip_train.main_search_awq \
    --imagenet-val /home/user/data/ILSVRC2012/train_sample_50_per_class \
    --model ViT-B-16-SigLIP2 \
    --pretrained webli \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name siglip2 \
    --batch-size 64 \
    --bit 6 \
    --baseline awq \
    \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[3,4,5,6,7,8,9,10,11]" \
    --max-prefix-number 10 \
    --global-prefix-rank 15 \
    --target-block 3 \
    --target-layer ffn_fc2 \
    --prefix-num-search-mode \
