#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=siglip2_prefix_search_original
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=8
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=4 python -m open_clip_train.main_search \
    --imagenet-val /home/user/data/ILSVRC2012/train_sample_50_per_class \
    --model ViT-B-16-SigLIP2 \
    --pretrained webli \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name siglip2 \
    --batch-size 64 \
    --bit ${BIT} \
    --baseline original \
    \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --max-prefix-number 10 \
    --global-prefix-rank 10 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    --prefix-num-search-mode \
