import numpy as np
import torch as t
import torch.nn as nn
import torch.nn.functional as F

class PIDController:
    def __init__(self,Kp,Ki,Kd,target):
        self.Kp = Kp
        self.Ki = Ki
        self.Kd = Kd
        self.target = target
        self.cumulate = np.ones(24) * 0.5
        self.integral = 0
        self.prev_error = 0
    def update(self, current_value):
        error = self.target - current_value
        self.integral = self.integral + error
        for i in range(23):
            self.cumulate[i] = self.cumulate[i+1]
        self.cumulate[-1] = error
        derivative = (error - self.prev_error)
        output = self.Kp * error + self.Ki * np.mean(self.cumulate) + self.Kd * derivative
        self.prev_error = error
        return output

class Generator():
    
    def __init__(self, args):
        self.args = args
        
    def generate_uniform(self, low, high):
        num_instances = self.args.num_sample_train
        num_agent = self.args.num_agent
        sample_val = np.random.uniform(low,high,[num_instances,num_agent])
        return sample_val

    def generate_uniform2(self, low, high):
        num_instances = self.args.num_sample_train
        num_agent = self.args.num_agent
        sample_val = np.random.uniform(low,high,[num_instances,num_agent])
        sample_val[:,0] = np.random.uniform(0,1,[num_instances])
        return sample_val

    
    def generate_ctr(self,low,high):
        num_instances = self.args.num_sample_train
        sample_val = np.random.uniform(low,high,[num_instances])
        return sample_val
        
    def generate_ctr2(self,low,high):
        num_instances = self.args.num_sample_train
        num_agent = self.args.num_agent
        sample_val = np.random.uniform(low,high,[num_instances,num_agent])
        return sample_val

class Generator2():
    
    def __init__(self, args):
        self.args = args
        
    def generate_uniform(self, low, high):
        num_instances = self.args.num_sample_train
        num_agent = self.args.num_agent
        sample_val = np.random.uniform(low,high,[num_instances,num_agent])
        return sample_val

    def generate_uniform2(self, low, high):
        num_instances = self.args.num_sample_train
        num_agent = self.args.num_agent
        sample_val = np.random.uniform(low,high,[num_instances,num_agent])
        sample_val[:,0] = np.random.uniform(0,1,[num_instances])
        return sample_val    
    
    def generate_ctr(self,low,high):
        num_instances = self.args.num_sample_train
        num_agent = self.args.num_agent
        sample_val = np.random.uniform(low,high,[num_instances,num_agent])
        return sample_val

class MLP(nn.Module):
    def __init__(self, layers, activation):
        super(MLP, self).__init__()
        self.layers_list = nn.ModuleList([nn.Linear(layers[i], layers[i+1]) for i in range(len(layers) - 1)])
        self.activation = activation

    def forward(self, x):
        for j, layer in enumerate(self.layers_list):
            if j == len(self.layers_list)-1:
                x = 5 * t.tanh(layer(x))
            else:
                x = self.activation(layer(x))
        return x

class CustomMLP(nn.Module):
    def __init__(self, input_size, output_size):
        super(CustomMLP, self).__init__()
        self.fc = nn.Linear(input_size, output_size)  

    def forward(self, x, given_weights, given_biases):
        x = t.matmul(x,given_weights.view(-1,given_biases.shape[0]))
        x = x + given_biases
        return x 

def calculate_t(t):
    t0 = t % 24
    if t0 <= 5:
        return np.max([(1. + 0.5 * (t0 / 5) + 0.1 * np.random.normal()),0.5])
    elif t0 > 5 and t0 <= 17:
        return np.max([(1.5 - (t0 - 5) / 12 + 0.1 * np.random.normal()),0.5])
    else:
        return np.max([(0.5 + 0.5 * (t0 - 17) /6 + 0.1 * np.random.normal()),0.5])


class Args():
    
    def __init__(self,args):
        self.num_agent = args[0]
        self.num_item = args[1]
        self.distribution_type = args[2]
        self.num_linear = args[3]
        self.num_max = args[4]
        self.num_sample_train = args[5]
        self.num_sample_test = args[6]
        self.seed_val = args[7]
        

def cumulative_average(arr):

    cum_avg = np.zeros(len(arr))
    

    for k in range(1, len(arr) + 1):
        cum_avg[k - 1] = np.mean(arr[:k])
    
    return cum_avg

def filter_pairs(x, y):

    x = np.array(list(x))
    y = np.array(list(y))
    to_keep = np.ones(len(x), dtype=bool)

    for i in range(len(x)):
        if x[i] < 0 or y[i] < 0:
            to_keep[i] = False
            continue
        for j in range(len(x)):
            if i != j and x[j] > x[i] and y[j] > y[i]:
                to_keep[i] = False
                break

    x_filtered = x[to_keep]
    y_filtered = y[to_keep]
    
    return x_filtered, y_filtered
 

