#!/user/bin/bash
source .venv/bin/activate 


export HF_HOME="/infinite/common/openpi_checkpoints"
export HF_LEROBOT_HOME="/infinite/common/openpi0-dataset"

CONFIG_NAME=pi0_lora_r1_multi
NUM_EPISODES=1
REPO_ID=task_all_test

EXP_NAME=task_all_test


python examples/r1/convert_r1_data_to_lerobot_multi_with_base.py \
    --raw_dirs \
    "/infinite/common/r1-dataset/task1_1_no_depth" \
    "/infinite/common/r1-dataset/task1_2_no_depth" \
    "/infinite/common/r1-dataset/task2_1_1" \
    "/infinite/common/r1-dataset/task2_1_2" \
    "/infinite/common/r1-dataset/task2_2_1" \
    "/infinite/common/r1-dataset/task2_2_2" \
    "/infinite/common/r1-dataset/task2_2_3_no_depth"\
    "/infinite/common/r1-dataset/task2_3_no_depth" \
    --tasks \
    "pick the pen and put it into the box" \
    "pick the cup and put it into the coaster" \
    "move to the whiteboard and clean the whiteboard" \
    "move to the whiteboard and clean the whiteboard" \
    "move to the storage box, pick up the storage box and place it on the table, then put the pen on the table into the box" \
    "move to the storage box, pick up the storage box and place it on the table, then put the pen on the table into the box" \
    "move to the storage box, pick up the storage box and place it on the table, then put the pen on the table into the box" \
    "Open the trash bin, turn around, pick up the trash on the chair and put it into the bin, then close the bin." \
    --num_episodes ${NUM_EPISODES} \
    --repo_id ${REPO_ID} \
    --no_push_to_hub  \
    --success_only

python scripts/compute_norm_stats.py --config-name ${CONFIG_NAME}

# XLA_PYTHON_CLIENT_MEM_FRACTION=0.95 uv run scripts/train.py \
#     ${CONFIG_NAME} \
#     data.repo_id=${REPO_ID} \
#     data.default_prompt="pick the pen and put it into the box" \
#     --exp_name ${EXP_NAME} \
#     --overwrite 