import matplotlib.pyplot as plt

X_AIXS_LABEL=[25, 50, 100, 200]

PERFORMANCE_DICT={
    'Pick pen':{
        '$\pi_0$ (Whole-body)':[0.12, 0.4,  0.68, 0.76],
        '$\pi_0$ (Right-arm)': [0.52, 0.78, 0.84, 0.82],
        'WB-VIMA (Whole-body)':[0.04, 0.22, 0.34, 0.43],
        'WB-VIMA (Right-arm)': [0.16, 0.24, 0.44, 0.50],
    },
    'Put Cup':{
        '$\pi_0$ (Whole-body)':[0.12, 0.4,  0.68, 0.76],
        '$\pi_0$ (Right-arm)': [0.52, 0.78, 0.84, 0.82],
        'WB-VIMA (Whole-body)':[0.04, 0.22, 0.34, 0.43],
        'WB-VIMA (Right-arm)': [0.16, 0.24, 0.44, 0.50],
    },
    'Erase Whiteboard':{
        '$\pi_0$ (Whole-body)':[0.12, 0.4,  0.68, 0.76],
        '$\pi_0$ (Right-arm)': [0.52, 0.78, 0.84, 0.82],
        'WB-VIMA (Whole-body)':[0.04, 0.22, 0.34, 0.43],
        'WB-VIMA (Right-arm)': [0.16, 0.24, 0.44, 0.50],
    } 
}

STANDARD_SIZE=18

if __name__ == '__main__':
    # 创建图形和子图
    fig, axes = plt.subplots(1, 3, figsize=(15, 5))
    
    colors = ['#1E3A8A', '#1E3A8A', '#F97316', '#F97316'] 
    linestyles = ['-', '--', '-', '--'] 
    markers = ['o', 'o', 'o', 'o']
    
    # 为每个task绘制子图
    for i, task in enumerate(PERFORMANCE_DICT.keys()):
        ax = axes[i]
        
        # 绘制每个方法的数据
        for j, (method, data) in enumerate(PERFORMANCE_DICT[task].items()):
            ax.plot(X_AIXS_LABEL, data, 
                   color=colors[j], marker=markers[j], linestyle=linestyles[j],
                   linewidth=2, markersize=8, label=method)
        
        # 设置子图标题和标签
        ax.set_title(task, fontsize=STANDARD_SIZE+2)
        if i == 0:  # 只在第一个子图显示y轴标签
            ax.set_ylabel('Success Rate', fontsize=STANDARD_SIZE)
        
        # 设置网格
        ax.grid(True, alpha=0.3)
        
        # 设置x轴刻度
        ax.set_xticks(X_AIXS_LABEL)
        ax.set_xticklabels([str(x) for x in X_AIXS_LABEL], fontsize=STANDARD_SIZE-2)
        ax.set_xlabel("Number of Training Demos", fontsize=STANDARD_SIZE)

        # 设置y轴刻度
        ax.tick_params(axis='y', labelsize=STANDARD_SIZE-2)
        
        # 设置y轴范围
        ax.set_ylim(0, 1)
        
        # 移除外圈框
        ax.spines['top'].set_visible(False)
        ax.spines['right'].set_visible(False)

    handles, labels = axes[0].get_legend_handles_labels()

    fig.legend(handles, labels, loc='upper center', 
              bbox_to_anchor=(0.5, 0.01), ncol=4, fontsize=STANDARD_SIZE)

    # fig.text(0.5, 0.04, 'Demonstration Size', ha='center', va='center', fontsize=STANDARD_SIZE)
    
    # 调整子图间距
    plt.tight_layout()
    plt.subplots_adjust(bottom=0.15)
    
    # 保存图片
    plt.savefig('figure2.pdf', dpi=300, bbox_inches='tight')
    plt.show()
