#!/user/bin/bash
source .venv/bin/activate 

export HF_HOME="/infinite/common/openpi_checkpoints"
export HF_LEROBOT_HOME="/infinite/common/openpi0-dataset"
export https_proxy=http://127.0.0.1:7890 http_proxy=http://127.0.0.1:7890 all_proxy=socks5://127.0.0.1:7890

CONFIG_NAME=iql_r1
METHOD=expectile
NETWORK_TYPE=hierarchical_q

# wandb login 1157a7f53156dceb78a02d7dafdc7a6a58154c68

# CUDA_VISIBLE_DEVICES=0 python scripts/compute_rl_norm_stats.py --config-name ${CONFIG_NAME}

XLA_PYTHON_CLIENT_MEM_FRACTION=0.8 python scripts/train_iql.py \
    ${CONFIG_NAME} \
    --exp_name debug \
    --model.method ${METHOD} \
    --model.network_type ${NETWORK_TYPE} \
    --fsdp_devices 1\
    --batch_size 1 \
    --overwrite 