import importlib
from torch.utils.data import DataLoader



def instantiate_from_config(config):
    if not "target" in config:
        if config == '__is_first_stage__':
            return None
        elif config == "__is_unconditional__":
            return None
        raise KeyError("Expected key `target` to instantiate.")
    return get_obj_from_str(config["target"])(**config.get("params", dict()))


def get_obj_from_str(string, reload=False):
    module, cls = string.rsplit(".", 1)
    if reload:
        module_imp = importlib.import_module(module)
        importlib.reload(module_imp)
    return getattr(importlib.import_module(module, package=None), cls)

def get_dataloaders(config):
    train_loader = DataLoader(instantiate_from_config(config.train), batch_size=config.batch_size, shuffle=False)
    val_loader = DataLoader(instantiate_from_config(config.validation))
    return train_loader, val_loader


