#!/usr/bin/env python3
import sys
sys.path.append('/projects/colosseum/SAM2Act/sam2Act_COLOSSEUM')
import torch  # import torch and sklearn at the very beginning to avoid possible incompatible errors
# import sklearn

from slowfast.config.defaults import assert_and_infer_cfg
from slowfast.utils.misc import launch_job
from slowfast.utils.parser import load_config, parse_args

# from tools.test_gaze_net import test
from GLC.tools.train_gaze_net import train


def main():
    """
    Main function to spawn the train and test process.
    """
    import os
    os.environ['NCCL_DEBUG'] = 'INFO'
    os.environ['NCCL_SOCKET_IFNAME'] = 'eth0'  # 根据实际网卡调整
    os.environ['NCCL_IB_DISABLE'] = '1'  # 如果使用以太网
    os.environ['CUDA_LAUNCH_BLOCKING'] = '1'  # 调试用
    args = parse_args()
    cfg = load_config(args)
    cfg = assert_and_infer_cfg(cfg)

    # Perform training.
    launch_job(cfg=cfg, init_method=args.init_method, func=train)


if __name__ == "__main__":
    main()


# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 \
#  python pretrain_GLC.py \
#  --init_method tcp://localhost:9877 \
#  --cfg configs/MVIT_B_16x4_CONV.yaml \
#  TRAIN.BATCH_SIZE 16 \
#  TEST.ENABLE False \
#  NUM_GPUS 8 \
#  TRAIN.CHECKPOINT_FILE_PATH checkpoints/MViT_Ego4D_ckpt.pyth \
#  OUTPUT_DIR checkpoints 


# torchrun \
#     --nnodes=1 \
#     --nproc_per_node=8 \
#     --master_addr=127.0.0.1 \
#     --master_port=29500 \
#     pretrain_GLC.py \
#     --cfg configs/MVIT_B_16x4_CONV.yaml \
#     TRAIN.BATCH_SIZE 16 \
#     TEST.ENABLE False \
#     NUM_GPUS 8 \
#     TRAIN.CHECKPOINT_FILE_PATH checkpoints/MViT_Ego4D_ckpt.pyth \
#     OUTPUT_DIR checkpoints