## Trading Information between Latents in Hierarchical Variational Autoencoders (Code)

### Environment: 

Python 3.8.11;
Other dependencies are in `requirements.txt`


### Training

Example training command:
```bash
python train.py \
--vae_type HVAE \
--dataset CIFAR10 \
--px_y_family_ll GaussianFixedSigma \
--sigma 0.71 \
--qz_family DiagonalGaussian \
--num_epochs 500 \
--batch_size 256 \
--conv_channels 32 \
--z_dims 32 \
--beta_y 1. \
--beta_z 1. \
--run_name <run_name> \
--run_batch_name <run_batch_name> \
```

### Evaluation
Involve 4 separate steps (also need to train classifier for measuring inception score):

#### 1.
```bash
python eval_beta_grid.py --run_batch_name <run_batch_name> --exclude_mi --with_classifier
```

#### 2.
Execute for all model in `<run_batch_name>`
```bash
python eval_beta_single.py \
--run_path <run_path_for_single_model> 
```

#### 3.
```bash
python eval_beta_grid.py --get_mi_cal_acc --cpu_n <num_cpu> --run_batch_name <run_batch_name> 
```

#### 4.
```bash
python eval_beta_grid.py --run_batch_name <run_batch_name> --recons_acc
```
