
#define NOPE_HEAD_DIM 128    
#define ROPE_HEAD_DIM 64    
#define HEAD_DIM (ROPE_HEAD_DIM + NOPE_HEAD_DIM) 
#define MLA_HEAD_DIM (KV_LORA_RANK + ROPE_HEAD_DIM)
#define KV_LORA_RANK 512    
#define HEAD_NUM 16     
#define HIDDEN_DIM 2048 
#define SEQ_LEN 4096   

#define NUM_WARPS 4 // 4 8 16 32
#define WARP_SIZE 32
#define BLOCK_SIZE (NUM_WARPS * WARP_SIZE) 
#define CLUSTER_SIZE 4 // 2 4 8 16
#define NUM_PER_THREAD 8
#define NUM_ROW_PER_WARP (NOPE_HEAD_DIM / NUM_WARPS) 
#define NUM_THREAD_PER_ROW (WARP_SIZE / NUM_ROW_PER_WARP) 
#define NUM_PER_ROW (NUM_PER_THREAD * NUM_THREAD_PER_ROW) 
#define DIM_PER_BLOCK (HIDDEN_DIM / CLUSTER_SIZE)
#define KV_DIM_PER_BLOCK (SEQ_LEN / CLUSTER_SIZE) 

#define TMA_LOAD_ONCE 64 // 8 16 32 64 128 256
#define TMA_LOAD_ONCE_NUM (TMA_LOAD_ONCE * NOPE_HEAD_DIM)
#define TMA_LOAD_ONCE_SIZE (TMA_LOAD_ONCE_NUM * sizeof(half))
#define TMA_LOAD_ONCE_ATTN (TMA_LOAD_ONCE / 4) 
#define TMA_LOAD_ONCE_NUM_ATTN (TMA_LOAD_ONCE_ATTN * KV_LORA_RANK) 
#define TMA_LOAD_ONCE_SIZE_ATTN (TMA_LOAD_ONCE_NUM_ATTN * sizeof(half))

#define NUM_ROW_PER_WARP_2 (TMA_LOAD_ONCE / NUM_WARPS) 
#define NUM_THREAD_PER_ROW_2 (WARP_SIZE / NUM_ROW_PER_WARP_2) 
#define NUM_PER_ROW_2 (NUM_PER_THREAD * NUM_THREAD_PER_ROW_2) 
#define NUM_THREAD_PER_ROW_3 (KV_LORA_RANK / NUM_PER_THREAD) 
#define NUM_ROW_PER_BLOCK (BLOCK_SIZE / NUM_THREAD_PER_ROW_3) 
#define DEC_TILE (TMA_LOAD_ONCE_ATTN / NUM_ROW_PER_BLOCK) 