# What does this PR do?

Add one-line overview of what this PR aims to achieve or accomplish. 

# ChangeLog:

- Add specific changes and high-level design in this PR.

# Usage

- You can add one use example below.

```python
# Add code snippet or script demonstrating how to use this 
```
- For algorithm implementation and new model support, you can add training curve plots and evaluatuion results below. 

## Before submitting

- [ ] Did you read the [Contribute Guide](https://github.com/volcengine/verl?tab=readme-ov-file#contribution-guide) and finish the [code format check](https://github.com/volcengine/verl?tab=readme-ov-file#code-linting-and-formatting)? 
- [ ] Did you make sure to update the documentations with your changes in the [docs](https://github.com/volcengine/verl/tree/main/docs) especially for breaking config etc?
- [ ] Did you write any test cases if neccessary? Please add CI tests to your new feature.  

# Additional Info: 
- **Issue Number**: Fixes issue # or discussion # if any. 
- **Training**: [Note which backend this PR will affect: FSDP, Megatron, both, or none]
- **Inference**: [Note which backend this PR will affect: vLLM, SGLang, both, or none]
