import streamlit as st
from utils import add_navigation, add_instruction_text

def render():
    add_navigation("conclusion", None)

    add_instruction_text(
        """
        'Rashomon Effect' was first introduced in AI by <a href="https://projecteuclid.org/journals/statistical-science/volume-16/issue-3/Statistical-Modeling--The-Two-Cultures-with-comments-and-a/10.1214/ss/1009213726.full" target="_blank">Breiman (2001)</a>. More recently, 'Predictive Multiplicity' was formally defined by <a href="https://proceedings.mlr.press/v119/marx20a.html" target="_blank">Marx et al. (2020)</a><br><br>
        The language on 'multiverse' is borrowed from <a href="https://dl.acm.org/doi/abs/10.1145/3630106.3658974" target="_blank">Simson et al. (2024)</a><br><br>
        The intention-convention-arbitrariness (ICA) framework was proposed by <a href="https://arxiv.org/abs/2501.14959" target="_blank">Ganesh et al. (2025)</a>
        """
    )

    add_instruction_text(
        """
        We recently did a tutorial on multiplicity at FAccT 2025. You can find the recorded video, slides, and other material <a href="https://prakharg24.github.io/multiplicity-tutorial/" target="_blank">here.</a><br><br>
        Want to dig even deeper? We also wrote a <a href="https://arxiv.org/abs/2501.14959" target="_blank">systematic survey on multiplicity.</a>
        """
    )

    ref_list = """
        <ul>
          <li>Breiman, Leo. "Statistical modeling: The two cultures (with comments and a rejoinder by the author)." Statistical science 16, no. 3 (2001): 199-231.</li>
          <li>Marx, Charles, Flavio Calmon, and Berk Ustun. "Predictive multiplicity in classification." In International conference on machine learning, pp. 6765-6774. PMLR, 2020.</li>
          <li>Simson, Jan, Florian Pfisterer, and Christoph Kern. "One model many scores: Using multiverse analysis to prevent fairness hacking and evaluate the influence of model design decisions." In Proceedings of the 2024 ACM Conference on Fairness, Accountability, and Transparency, pp. 1305-1320. 2024.</li>
          <li>Ganesh, Prakhar, Afaf Taik, and Golnoosh Farnadi. "Systemizing Multiplicity: The Curious Case of Arbitrariness in Machine Learning." In Proceedings of the AAAI/ACM Conference on AI, Ethics, and Society. 2025.</li>
          <li>Multiplicity Tutorial Website - https://prakharg24.github.io/multiplicity-tutorial/</li>
          <li>Multiplicity Systematic Survey - Ganesh et al. (2025) above</li>
        </ul> 
    """
    st.markdown(f"<div style='text-align: left; font-size:14px; color:gray;'>{ref_list}</div>", unsafe_allow_html=True)

    st.markdown("---")