# pipeline_app.py
import streamlit as st
from utils import add_navigation, add_instruction_text
from utils import pipeline_data

def render():
    add_navigation("txt_developer_decisions", "txt_ica")

    add_instruction_text(
        """
        Developers make a huge number of decisions when designing ML models. <br>
        Dive into some examples below to get a feel of how model design works.
        """
    )
    
    if "active_stage" not in st.session_state:
        st.session_state.active_stage = None
    if "active_substage" not in st.session_state:
        st.session_state.active_substage = None

    # Level 1: Stages
    cols = st.columns(len(pipeline_data))
    for idx, stage in enumerate(pipeline_data.keys()):
        with cols[idx]:
            if st.session_state.active_stage==stage:
                button_click_s = st.button(stage, type="primary")
            else:
                button_click_s = st.button(stage)
            if button_click_s:
                st.session_state.active_stage = stage
                st.session_state.active_substage = None
                st.rerun()

    # Level 2: Sub-stages
    if st.session_state.active_stage:
        st.markdown(pipeline_data[st.session_state.active_stage]["explain_text"])
        st.markdown("---")
        sub_stages = pipeline_data[st.session_state.active_stage]
        sub_cols = st.columns(len(sub_stages)-1)
        for idx, sub in enumerate(set(sub_stages.keys()) - {"explain_text"}):
            with sub_cols[idx]:
                if st.session_state.active_substage==sub:
                    button_click_ss = st.button(sub, type="primary")
                else:
                    button_click_ss = st.button(sub)
                if button_click_ss:
                    st.session_state.active_substage = sub
                    st.rerun()

    # Questions
    if st.session_state.active_substage:
        st.markdown(pipeline_data[st.session_state.active_stage][st.session_state.active_substage]["explain_text"])
        st.markdown("---")
        questions = pipeline_data[st.session_state.active_stage][st.session_state.active_substage]["sub_decisions"]
        for q in questions:
            st.write(f"- {q}")