import pandas as pd
import streamlit as st
from utils import add_navigation, add_instruction_text, add_red_text

ALL_FEATURES = [
    ("Liquid Assets", ["Liquid Assets"], 
     "Great choice! With access to bank accounts, a measure of all liquid assets can really help make a decision about loan approval."), 
    ("Illiquid Assets", ["Property appraisals", "Insurance valuations"], 
     "Oops, it is not possible to precisely calculate the value of illiquid assets! We will use some approximate alternatives instead."),
    ("Debt Obligations", ["Credit Card Debts", "Bank Loans", "Self-reported Debts"], 
     "Oops, it is not possible to precisely measure all debt obligations! We will use credit card debts, bank loans, and other self-reported debts as approximate alternatives instead."),
    ("Income Stability", ["Past Income Stability"],
     "Sorry, it is not possible to know precisely how stable someone's income will be in future. Until someone invents a time machine (we're hopeful!), we can instead approximate with past income stability."),
    ("Health Trajectory", ["Current Health Indicators"], 
     "Sorry, it is not possible to know precisely how will someone's health change in the future. Until someone invents a time machine (we're hopeful!), we can instead approximate with current health indicators."),
    ("Financial Discipline", ["Credit Score"], 
     "Oops, financial discipline is not a directly measurable quality. We will use credit score as an approximation instead.")
]

def render():
    add_navigation("txt_information_loss", "txt_rashomon_effect")

    add_instruction_text(
        """
        Consider the automation of loan approval using AI models. <br>
        Select the features below that you would like to collect to train your AI model. <br>
        Notice that, in trying to capture data from the real world, you loose information.
        """
    )
    
    #### Setup Button Colors and Theme
    sec_bg = st.get_option("theme.secondaryBackgroundColor")
    text = st.get_option("theme.textColor")
    
    css = f"""
    <style>
    button[kind="tertiary"] {{
        background-color: {sec_bg} !important;
        color: {text} !important;
        border: 1px solid {sec_bg} !important;
        opacity: 0.2 !important;       /* faded look */
        cursor: not-allowed !important;  /* shows it's inactive */
        pointer-events: none !important; /* disable clicking */
    }}
    </style>
    """
    st.markdown(css, unsafe_allow_html=True)

    
    #### Add the icon and buttons at the top
    if "selected_features" not in st.session_state:
        st.session_state.selected_features = []

    cols_list = st.columns([1, 1, 1, 1])

    with cols_list[0]:
        st.image(
            "loan.png",
            width=100,
        )

    for ite, feature in enumerate(ALL_FEATURES.copy()):
        with cols_list[ite%3 + 1]:
            if feature in st.session_state.selected_features:
                _ = st.button(feature[0], type="tertiary")
            else:
                if st.button(feature[0]):
                    st.session_state.selected_features.append(feature)
                    st.session_state.show_message = feature[2]
                    st.rerun()

    if "show_message" in st.session_state:
        add_red_text(st.session_state.show_message)
        del st.session_state.show_message

    #### Selected features shown at the bottom
    display_features_list = []
    for ele in st.session_state.selected_features:
        display_features_list.extend(ele[1])
    
    st.markdown("---")
    st.markdown("**Set of Selected Features:**")
    cols_list = st.columns(3)
    for i, item in enumerate(display_features_list):
        cols_list[i%3].markdown(f"- {item}")