import streamlit as st
from utils import add_navigation, add_fadein_text

def render():

    if st.session_state.page=="txt_information_loss":
        add_navigation("landing", "information_loss")
        
        paragraphs = [
            ("A problem central to AI is the 'prediction problem', i.e., "
             "being able to anticipate outcomes based on the information we already have.", 0),
            ("Unfortunately, translating the nuances of real world into 'data' can result in information loss. "
             "This makes the prediction problem <b><i>imperfect</i></b>.", 3),
            ("<br><br>Click 'Next' to create data for a real-world problem and notice this information loss.", 8)
        ]
    
        add_fadein_text(paragraphs)

    elif st.session_state.page=="txt_rashomon_effect":
        add_navigation("information_loss", "rashomon_effect")
        
        paragraphs = [
            ("The missing information leaves room for multiple possible ways to fill the gap.", 0),
            ("Multiple equally correct interpretations of data (i.e., AI models), "
             "with no evidence to elevate one over another, "
             "is known as the <b><i>Rashomon effect</i></b> (Named after Kurosawa's "
             "1950 masterpiece 'Rashomon'... any movie buffs here?)", 3),
            ("As these models represent different interpretations of data, they might disagree with each other, "
             "and produce varying predictions for the same input, known as <b><i>predictive multiplicity.</i></b>", 9),
            ("<br><br>Click 'Next' to observe the Rashomon effect and predictive multiplicity on an actual dataset.", 13)
        ]
    
        add_fadein_text(paragraphs)

    elif st.session_state.page=="txt_rashomon_developer":
        add_navigation("rashomon_effect", "rashomon_developer")
        
        paragraphs = [
            ("With the existence of numerous interpretations, the choice to pick one falls on the developer.", 0),
            ("In reality, developers do not simply choose models after training them all, "
             "but instead make implicit choices throughout the model development pipeline that impact the resulting model.", 3),
            ("<br><br>Click 'Next' to observe how choices during model development results in the same Rashomon effect as seen before.", 7)
        ]
    
        add_fadein_text(paragraphs)

    elif st.session_state.page=="txt_developer_decisions":
        add_navigation("rashomon_developer", "developer_decisions")
        
        paragraphs = [
            ("But a developer makes countless decisions when designing the model that will impact the eventual interpretation being chosen.", 0),
            ("<br><br>Click 'Next' and take just a tiny glimpse into various choices a developer makes when designing an AI model.", 4)
        ]
    
        add_fadein_text(paragraphs)

    elif st.session_state.page=="txt_ica":
        add_navigation("developer_decisions", "ica")
        
        paragraphs = [
            ("With so many decisions to take, it is not possible to make sure each decision is deliberate and appropriately chosen.", 0),
            ("We use the <b><i>intention-convention-arbitrariness (ICA)</b></i> framework to better understand these decisions.", 3),
            ("Intentional decisions are taken with an understanding of how they will impact the resulting model.", 6),
            ("Conventional decisions simply follow existing trends or conventions, without studying their impact in the context.", 9),
            ("Arbitrary decisions force randomness in model design without any conventional bias or intentional understanding of their impact.", 12),
            ("<br><br>Click 'Next' to discover how various developer decisions fit into the ICA framework.", 15)
        ]
    
        add_fadein_text(paragraphs)

    elif st.session_state.page=="txt_multiverse":
        add_navigation("ica", "multiverse")
        
        paragraphs = [
            # ("Intentional decisions have risk of <b><i>hacking</b></i>, i.e., finding a really good model just for the given data. "
            #  "Hacking can result in regulatory-washing, creating problems in governing these systems.", 0),
            ("Conventional decisions can lead to <b><i>homogenization</b></i>, as different models start to converge to similar behaviour. "
             "Homogenization create concerns of systemic bias and reduced diversity.", 0),
            ("Arbitrary decisions can lead to <b><i>conflicting predictions</b></i> between different models. "
             "Conflicting predictions create capriciousness, i.e., a 'lack of justification' for which model was chosen.", 5),
            ("Let's get into the role of a developer to understand these concerns and more importantly, <b><i>why and when they matter</b></i>.", 10),
            ("<br><br>Click 'Next' to train your own models to traverse the multiverse.", 12)
        ]
    
        add_fadein_text(paragraphs)

    elif st.session_state.page=="txt_conclusion":
        add_navigation("multiverse", "conclusion")
        
        paragraphs = [
            ("AI prediction problems will rarely <i>(read 'never')</i> have just one solution, thus creating multiplicity.", 0),
            ("Depending on context and values of the stakeholders, one might lean towards higher or lower multiplicity.", 2),
            ("Navigating the multiplicity of models is a critical problem in AI, "
             "as it directly impacts individuals and the decisions they receive.", 5),
            ("<br><br>The field of multiplicity in AI is quite young, and we are excited to see what's next!", 9),
        ]
    
        add_fadein_text(paragraphs)