# Copyright 2022 The Mixed Fl Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#!/bin/bash
set -e
set -x

virtualenv -p python3 pip_env
source pip_env/bin/activate

pip install tensorflow
pip install -r mixed_fl/requirements.txt
python -m mixed_fl.experiments.mixing --client_batch_size=5 --limit_num_batches=2 --dataset=celeba --client_restriction=only_smiling --datacenter_restriction=no_smiling --mixing_mode=grad_transfer --grad_transfer_batch_size_multiplier=5
