from util_real import *
from Optimizer import *
import pandas as pd
from Competitor import *
import argparse
parser = argparse.ArgumentParser()
parser.add_argument('--network_typ', type=str, default='circle')
parser.add_argument('--attack_typ', type=str, default='featureatt')
args = parser.parse_args()
 
## Set hyperparameters
n_workers = 50
# network_typs = ['circle','er']
q_degrees = [0.06,0.6] if args.network_typ == 'circle' else [0.2,0.6]
byz_ratios = [0.15,0.25,0.35]
# attack_typs = ['labelatt','featureatt']
network_typs = [args.network_typ]
attack_typs = [args.attack_typ]
random_state = 2025
data_name = 'cifar'

## Other parameters
device = 'cuda'
n_classes = 10
save2hd = False # Whether to save Byzantine data to disk
output_dir = f'output_{data_name}' # Output path for accuracy, etc.
os.makedirs(output_dir, exist_ok=True)
model_type = 'logistic' if data_name == 'cifar' else 'lenet5' # lenet5
print_freq = 1

## Load data
data = np.load(f'{data_name}_train.npz')
X_train,y_train = data['images'],data['labels']
data = np.load(f'{data_name}_test.npz')
X_test,y_test = data['images'],data['labels']
X_test = torch.from_numpy(X_test).to(device)
y_test = torch.from_numpy(y_test).to(device)
input_dim=np.prod(X_train.shape[1:])

for byz_ratio in byz_ratios:
    for ii,attack_typ in enumerate(attack_typs):
        data_path = f'data_{data_name}_{byz_ratio}_{attack_typ}'
        
        ## Generate poisoned data
        Xs_all, ys_all, X_oracle_tensor, y_oracle_tensor,byz_labels = attack_and_save(save2hd=save2hd,
                n_workers=n_workers,byz_ratio=byz_ratio, attack_typ=attack_typ, 
                random_state=random_state, X_train=X_train, y_train=y_train, 
                    data_path=data_path, data_name=data_name, device=device)
        
        
        for network_typ in network_typs:
            for q_degree in q_degrees:
                print(f'\n byz_raio:{byz_ratio} attack_typ:{attack_typ} network_typ:{network_typ} q_degree:{q_degree}')

                W = generate_network(n_workers, typ=network_typ,
                                 q=q_degree, seed=random_state)
                neighbors = get_neighbors(W, include_diag=False)
                
                ## Median aggregation
                bg_med = RobustOptimizer(neighbors, lr_constant=1,model_type=model_type,   
                                    n_workers=n_workers,
                                 device=device,random_state=random_state,pretrained=False,
                              custom_init=True,agg_method='median',byz_ratio=byz_ratio,
                                        input_dim=input_dim)

                bg_med.epochs = 100
                bg_med.fit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)

                bg_med.epochs = 4900
                bg_med.set_learning_rates([0.5]*n_workers)
                bg_med.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                bg_med.epochs = 3000
                bg_med.set_learning_rates([0.2]*n_workers)
                bg_med.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                bg_med.epochs = 1000
                bg_med.set_learning_rates([0.1]*n_workers)
                bg_med.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)

                param_dfl = bg_med.get_parameters()
                torch.save(param_dfl,f'{output_dir}/param_bgmed_{byz_ratio}_{attack_typ}_{network_typ}_{q_degree}.pth')
                acc,loss = bg_med.save_history(save_path=f'{output_dir}/metric_bgmed_{byz_ratio}_{attack_typ}_{network_typ}_{q_degree}')

                
                ## Trimmed mean aggregation
                bg_trimmed = RobustOptimizer(neighbors, lr_constant=1,model_type=model_type,   
                                    n_workers=n_workers,
                                 device=device,random_state=random_state,pretrained=False,
                              custom_init=True,agg_method='trimmed_mean',byz_ratio=byz_ratio,
                                            input_dim=input_dim)
                bg_trimmed.epochs = 100
                bg_trimmed.fit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)

                bg_trimmed.epochs = 4900
                bg_trimmed.set_learning_rates([0.5]*n_workers)
                bg_trimmed.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                bg_trimmed.epochs = 3000
                bg_trimmed.set_learning_rates([0.2]*n_workers)
                bg_trimmed.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                bg_trimmed.epochs = 1000
                bg_trimmed.set_learning_rates([0.1]*n_workers)
                bg_trimmed.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                
                param_dfl = bg_trimmed.get_parameters()
                torch.save(param_dfl,f'{output_dir}/param_bgtrimmed_{byz_ratio}_{attack_typ}_{network_typ}_{q_degree}.pth')
                acc,loss = bg_trimmed.save_history(save_path=f'{output_dir}/metric_bgtrimmed_{byz_ratio}_{attack_typ}_{network_typ}_{q_degree}')
                
                
                ## Clipped Gossip
                clipped = ClippedGossip(neighbors, lr_constant=1,model_type=model_type,   
                                    n_workers=n_workers,
                                 device=device,random_state=random_state,pretrained=False,
                              custom_init=True,byz_ratio=byz_ratio,
                                            input_dim=input_dim)
                clipped.epochs = 100
                clipped.fit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                clipped.epochs = 4900
                clipped.set_learning_rates([0.5]*n_workers)
                clipped.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                clipped.epochs = 3000
                clipped.set_learning_rates([0.2]*n_workers)
                clipped.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                clipped.epochs = 1000
                clipped.set_learning_rates([0.1]*n_workers)
                clipped.refit(Xs_all, ys_all, X_test, y_test, print_freq=print_freq)
                param_dfl = clipped.get_parameters()
                torch.save(param_dfl,f'{output_dir}/param_clipped_{byz_ratio}_{attack_typ}_{network_typ}_{q_degree}.pth')
                acc,loss = clipped.save_history(save_path=f'{output_dir}/metric_clipped_{byz_ratio}_{attack_typ}_{network_typ}_{q_degree}')

