# Adaptive Decentralized Federated Learning for Robust Optimization

Code for real data experiments in “Adaptive Decentralized Federated Learning for Robust Optimization”.
 
## Workflow Overview

1. Initial Setup
```bash
# Navigate to the working directory 
cd heterogeneous/cifar #for example
#Directory structure is as follows:
heterogeneous/cifar/
├── comp_cifar.py # Computes Bridge & Clipped Gossip estimators 
├── comp_gt_cifar.py # Ground truth comparisons 
├── Competitor.py # Competitor algorithm implementations 
├── main_cifar.py # Main estimators: Oracle, DFL, aDFL 
├── mobilenetv2.py # MobileNetV2 model implementation 
├── Optimizer.py # Optimization algorithms 
├── plot.py # Plotting utilities 
├── run_cifar.sh # Execution script 
├── save_cifar.py # Dataset download/saving 
├── select_cn_cifar.py # λ parameter selection 
└── util_real.py # Utility functions 
```
2. **Data Preparation**:
   - If you don't have `train.npz` and `test.npz` files in your directory:
     - Run `save_cifar.py` to download and prepare the CIFAR dataset
     - Or run `save_mnist.py` for the MNIST dataset

3. **Execution**:
   - Give execution permission to the run script:  
     `chmod +x run_cifar.sh` (or `run_mnist.sh` for MNIST)
   - Execute the appropriate script:  
     `./run_cifar.sh` or `./run_mnist.sh`

## Configuration Options

To generate different experimental results, you can modify the following parameters in `run_cifar.sh` (or `run_mnist.sh`):

- `NETWORK_TYP`: Network topology type
  - Options: `circle` (Direct circle network) or `er` (Erdős-Rényi random network)
  
- `ATTACK_TYP`: Type of attack to simulate
  - Options: `featureatt` (feature attack) or `labelatt` (label attack)

## Script Functions

The implementation consists of several specialized scripts:

1. **Parameter Selection**:
   - `select_cn_cifar.py` / `select_cn_mnist.py`:  
     Responsible for selecting the optimal λ parameter

2. **Estimation Calculation**:
   - `main_cifar.py` / `main_mnist.py`:  
     Computes three key estimators:
     - Oracle estimator
     - DFL estimator
     - aDFL (adaptive DFL) estimator

3. **Comparative Methods**:
   - `comp_cifar.py` / `comp_mnist.py`:  
     Implements and evaluates two additional methods:
     - Bridge estimator
     - Clipped Gossip estimator

4. **SLBRN Methods**:
   - `slbrn_cifar.py` / `slbrn_mnist.py`:  
     Computes two variants of the SLBRN estimator:
     - SLBRN-M
     - SLBRN-T

## Output

The scripts will generate the plots and results shown in the associated paper. The specific output will vary based on the selected network type and attack configuration.