from .swin_transformer import build_swin
from .vision_transformer import build_vit
from .simmim import build_simmim
from .comm import build_comm
from .ResNet import resnet18
from .ResNet import resnet50


def build_model(config, is_pretrain=True):
    if is_pretrain:
        model = build_simmim(config)
    else:
        model_type = config.MODEL.TYPE
        if model_type == 'swin':
            model = build_swin(config)
        elif model_type == 'vit':
            model = build_vit(config)
        elif model_type == 'resnet18':
            model = resnet18()
        elif model_type == 'resnet50':
            model = resnet50()
        else:
            raise NotImplementedError(f"Unknown fine-tune model: {model_type}")

    return model

def build_CoMM_model(config, is_pretrain=True):
    if is_pretrain:
        raise NotImplementedError(f"is_pretrain=True is not implemented")
    else:
        model = build_comm(config)
        # model_type = config.MODEL.TYPE
        # if model_type == 'swin':
        #     model = build_swin(config)
        # elif model_type == 'vit':
        #     model = build_vit(config)
        # elif model_type == 'resnet18':
        #     model = resnet18()
        # elif model_type == 'resnet50':
        #     model = resnet50()
        # else:
            # raise NotImplementedError(f"Unknown CoMM Fine-tune model: {model_type}")
        # raise NotImplementedError(f"Unknown CoMM Fine-tune model: {model_type}")
    return model
