# Get the layout from command line argument or use default
LAYOUT=${1:-"random1"} # random1, random0, random0_medium, random3
ROLLOUTS=${2:-"200"}
SEED_TYPE=${3:-"train"} # train, eval, mep
SKILL_LEVEL=${4:-"final"} # final, mid
NOISE_TYPE=${5:-"none"} # none, mid, small
AGENT_TYPE=${6:-"hsp"} # hsp, mep
MIX_TYPE=${7:-"none"} # none, mid, small

if [[ "$SEED_TYPE" == "mep" ]]; then
    AGENT_TYPE="mep"
fi

# Set variables based on layout
if [[ "$LAYOUT" == "random1" || "$LAYOUT" == "random0" || "$LAYOUT" == "random0_medium" || "$LAYOUT" == "random3" ]]; then
    OVERCOOKED_VERSION="old"
    W0="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1"
    W1="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1"    
elif [[ "$LAYOUT" == "random1_m" || "$LAYOUT" == "random0_m" ]]; then
    OVERCOOKED_VERSION="new"
    W0="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1"
    W1="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1"
else
    echo "Unsupported layout: $LAYOUT"
    exit 1
fi

MIX_ARGS=""
if [[ "$MIX_TYPE" == "mid" ]]; then
    MIX_ARGS="--mix_policy --mix_rate 0.6"
elif [[ "$MIX_TYPE" == "small" ]]; then
    MIX_ARGS="--mix_policy --mix_rate 0.3"
elif [[ "$MIX_TYPE" == "none" ]]; then
    MIX_ARGS=""
fi

NOISE_ARGS=""
if [[ "$NOISE_TYPE" == "mid" ]]; then
    NOISE_ARGS="--add_noise --noise_rate 0.25"
elif [[ "$NOISE_TYPE" == "small" ]]; then
    NOISE_ARGS="--add_noise --noise_rate 0.15"
elif [[ "$NOISE_TYPE" == "none" ]]; then
    NOISE_ARGS=""
fi

# Display the configuration
echo "Running with configuration:"
echo "Layout: $LAYOUT"
echo "Overcooked Version: $OVERCOOKED_VERSION"
echo "Rollout Episodes: $ROLLOUTS"
echo "Seed Type: $SEED_TYPE"
echo "Skill Level: $SKILL_LEVEL"

# Run the Python script with the specified arguments
python zsceval/zsceval/scripts/render/render_overcooked.py \
--env_name Overcooked \
--algorithm_name mappo \
--experiment_name ${AGENT_TYPE}_${SKILL_LEVEL}_${NOISE_TYPE}_${ROLLOUTS} \
--layout_name $LAYOUT \
--num_agents 2 \
--seed 1 \
--n_training_threads 1 \
--n_rollout_threads 1 \
--dummy_batch_size 1 \
--num_mini_batch 1 \
--episode_length 200 \
--num_env_steps 1e7 \
--reward_shaping_horizon 1e7 \
--overcooked_version $OVERCOOKED_VERSION \
--ppo_epoch 15 \
--entropy_coefs 0.2 0.05 0.001 \
--entropy_coef_horizons 0 6e6 1e7 \
--use_hsp \
--w0 $W0 \
--w1 $W1 \
--share_policy \
--cnn_layers_params "32,3,1,1 64,3,1,1 32,3,1,1" \
--use_recurrent_policy \
--use_proper_time_limits \
--save_interval 20 \
--log_interval 5 \
--use_eval \
--n_eval_rollout_threads 1 \
--eval_episodes 1 \
--wandb_name "wandb_name" \
--use_wandb \
--model_seed_start 0 \
--model_seed_end 20 \
--rollout_episodes $ROLLOUTS \
--store_traj \
--seed_type $SEED_TYPE \
--skill_level $SKILL_LEVEL \
$NOISE_ARGS \
