
#!/bin/bash
env="Overcooked"

layout=$1
population_size=$2

if [[ "${layout}" == "random0" || "${layout}" == "random0_medium" || "${layout}" == "random1" || "${layout}" == "random3" || "${layout}" == "small_corridor" || "${layout}" == "unident_s" ]]; then
    version="old"
else
    version="new"
fi

# echo pop_size ${population_size}

if [[ ${population_size} == 12 ]]; then
    entropy_coefs="0.2 0.05 0.01"
    entropy_coef_horizons="0 2.5e7 5e7"
    if [[ "${layout}" == "small_corridor" ]]; then
        entropy_coefs="0.2 0.05 0.01"
        entropy_coef_horizons="0 4e7 5e7"
    fi
    reward_shaping_horizon="5e7"
    num_env_steps="5e7"
    pop="mep-S1-s5"
    mep_prioritized_alpha=0.5
elif [[ ${population_size} == 24 ]]; then
    entropy_coefs="0.2 0.05 0.01"
    entropy_coef_horizons="0 4e7 8e7"
    if [[ "${layout}" == "small_corridor" ]]; then
        entropy_coefs="0.2 0.05 0.01"
        entropy_coef_horizons="0 6.4e7 8e7"
    fi
    reward_shaping_horizon="0"
    num_env_steps="8e7"
    pop="mep-S1-s10"
    mep_prioritized_alpha=1.0
elif [[ ${population_size} == 36 ]]; then
    entropy_coefs="0.2 0.05 0.01"
    entropy_coef_horizons="0 5e7 1e8"
    if [[ "${layout}" == "small_corridor" ]]; then
        entropy_coefs="0.2 0.05 0.01"
        entropy_coef_horizons="0 8e7 1e8"
    fi
    reward_shaping_horizon="0"
    num_env_steps="1e8"
    pop="mep-S1-s15"
    mep_prioritized_alpha=1.5
fi


num_agents=2
algo="mep"
exp="mep-sparse0430-S2-s${population_size}"
stage="S2"
seed_begin=1
seed_max=2
path=../../policy_pool_pretrained

export POLICY_POOL=${path}
n_training_threads=72

ulimit -n 65536

echo "env is ${env}, layout is ${layout}, algo is ${algo}, pop is ${pop}, exp is ${exp}, seed from ${seed_begin} to ${seed_max}, stage is ${stage}"
for seed in $(seq ${seed_begin} ${seed_max});
do
    python train/train_adaptive.py --env_name ${env} --algorithm_name ${algo} --experiment_name "${exp}" --layout_name ${layout} --num_agents ${num_agents} \
    --seed ${seed} --n_training_threads 1 --num_mini_batch 1 --episode_length 200 --num_env_steps ${num_env_steps} --reward_shaping_horizon ${reward_shaping_horizon} \
    --overcooked_version ${version} \
    --n_rollout_threads ${n_training_threads} --dummy_batch_size 1 \
    --ppo_epoch 15 --entropy_coefs ${entropy_coefs} --entropy_coef_horizons ${entropy_coef_horizons} \
    --stage 2 --mep_use_prioritized_sampling --mep_prioritized_alpha ${mep_prioritized_alpha} \
    --save_interval 100 --log_interval 50 --use_eval --eval_interval 100 --n_eval_rollout_threads $((population_size * 2)) --eval_episodes 5 \
    --population_yaml_path ${path}/${layout}/mep/s2/train-s${population_size}-${pop}-${seed}.yml \
    --population_size ${population_size} --adaptive_agent_name mep_adaptive --use_agent_policy_id \
    --use_proper_time_limits \
    --wandb_name "" 
done
