from scipy.io import loadmat
import numpy as np
from sklearn import datasets
from sklearn.decomposition import PCA
from sklearn.preprocessing import MinMaxScaler, RobustScaler

'''
Reference
Zhang, Yunhe, et al.
"Deep Orthogonal Hypersphere Compression for Anomaly Detection." 
The Twelfth International Conference on Learning Representations. 2023.
https://openreview.net/forum?id=cJs4oE4m9Q -> Supplementary Material
'''
def loadData(datasetname, scaler_flag):
    dataset = None
    dataset=np.load('./adbench/'+datasetname+'.npz')  


    features=dataset['X']

    labels = dataset['y']

    normal_data = features[np.where(labels==0)[0]][:]

    normal_labels = labels[np.where(labels==0)[0]]

    n_train = int(normal_data.shape[0]*0.5)
    ixs = np.arange(normal_data.shape[0])
    np.random.shuffle(ixs)
    normal_data_test = normal_data[ixs[n_train:]]
    normal_labels_test = normal_labels[ixs[n_train:]]

    train_x = normal_data[ixs[:n_train]]
    train_y = normal_labels[ixs[:n_train]]
    anomalous_data = features[np.where(labels==1)[0]][:]
    anomalous_labels = labels[np.where(labels==1)[0]]
    test_x = np.concatenate((normal_data_test, anomalous_data), axis=0)
    test_y = np.concatenate((normal_labels_test, anomalous_labels), axis=0)


    if scaler_flag == True:
        scaler = RobustScaler()
        train_x = scaler.fit_transform(train_x)
        test_x = scaler.transform(test_x)
        normal_data_test = scaler.transform(normal_data_test)
        anomalous_data = scaler.transform(anomalous_data)

    return train_x, train_y, test_x, test_y, normal_data_test, normal_labels_test, anomalous_data, anomalous_labels