# Paths for Agents and MLLM configs
LM_CONFIGS = "config/lm_configs.yaml"
AGENTS_CONFIG_DIR = "config/agent_config"

# Paths for outputs
DEFAULT_RESULTS_DIR = "./results"
RESULT_DIR_TEMPLATE = "{results_dir}/{model}/{domain}_{annotation}"
HTMLS_SUBDIR = "htmls"  # If '', saves HTML files directly to args.result_dir
LM_LOGS_SUBDIR = "lm_data"  # If '', saves LM call logs directly to args.result_dir

# (V)WA specific
GOOGLE_FUZZY_MATCH_MODEL = "gemini-2.0-flash-001"
OPEN_AI_FUZZY_MATCH_MODEL = "gpt-4o-2024-08-06"
HF_FUZZY_MATCH_MODEL = "meta-llama/Meta-Llama-3-8B-Instruct"
TEST_CONFIG_BASE_DIR = "config_files/vwa_not_vague/test_shopping"
SET_ENV_VARIABLES_SCRIPT = "scripts/environments/set_env_variables.sh"
RESET_ENV_SCRIPT = "scripts/environments/start_reset_envs.sh"
AUTOLOGIN_COOKIE_SCRIPT = "scripts/environments/autologin_cookies.sh"

# Captioner
CAPTIONER_HOST_SCRIPT = "vwa_utils/host_captioner.py"
CAPTIONER_PORT = 9555
CAPTIONER_ENDPOINT = f"http://localhost:{CAPTIONER_PORT}/caption/"
CAPTIONER_SUPPORTED_MODELS = ["Salesforce/blip2-flan-t5-xl"]
CAPTIONER_DEFAULT_IMAGE_FORMAT = "PNG"
