from flask import Flask, render_template
import os
import argparse

app = Flask(__name__)

# Parse command-line arguments
parser = argparse.ArgumentParser(description="Run Flask app with custom port and base URL")
parser.add_argument("--port", type=int, default=4399, help="Port to run the Flask app on")
parser.add_argument("--base-url", type=str, default="localhost", help="Base URL for the Flask app")
args = parser.parse_args()

PORT = args.port
BASE_URL = args.base_url
URL_FILE = "./config/webarena_urls/homepage_url.txt"


@app.route("/")
def index() -> str:
    return render_template("index.html")


@app.route("/scratchpad.html")
def scratchpad() -> str:
    return render_template("scratchpad.html")


@app.route("/calculator.html")
def calculator() -> str:
    return render_template("calculator.html")


@app.route("/password.html")
def password() -> str:
    return render_template("password.html")


if __name__ == "__main__":
    # Save the URL to a file
    os.makedirs(os.path.dirname(URL_FILE), exist_ok=True)
    with open(URL_FILE, "w") as f:
        f.write(f"http://{BASE_URL}:{PORT}")
    app.run(host="0.0.0.0", port=PORT)
