import socket
import subprocess

SERVER_PYTHON_FILE = 'evaluation_harness/host_model.py'
PORT = 9555
device = 'cpu'
dtype = 'float32'
model_name = 'Salesforce/blip2-flan-t5-xl'


subprocess.Popen([
                    "python", SERVER_PYTHON_FILE,
                    "--model_name", model_name,
                    "--device", device,
                    "--dtype", dtype,
                    "--port", str(PORT)
                ])

server_url = f"http://localhost:{PORT}"
print(f"Deploying captioner on {server_url}")


def is_server_running(port):
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as sock:
        result = sock.connect_ex(('localhost', port))
        return result == 0


# Check if server is running
if not is_server_running(PORT):
    print(f"Server is not running on port {PORT}. Please start the server first.")
    exit(1)

# Test the server
test_image_path = 'path/to/test/image.jpg'
test_image = Image.open(test_image_path)

