import os
from pathlib import Path
import sys

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "../..")))
from utils.file_utils import SanityChecker, count_dirs_duplicates, copy_move

dir_1 = "/home/mashalimay/webarena/experiments/gemini-2.0-flash-001"
dir_2 = "results/google/gemini-2.0-flash-001"


sanity_checker = SanityChecker(num_processes=8)

sanity_checker.set_original_hashes(dir_1)
sanity_checker.set_new_hashes(dir_2)

sanity_checker.sanity_check()


# num_duplicates, hash_files_1, hash_files_2 = count_dirs_duplicates(dir_1, dir_2, ignore_dir_struct=True)

# print(f"Number of duplicates: {num_duplicates}")


copy_move(dir_2, dir_1, "move", merge_dirs=True, copy_move_only_new=True, exclude_strs=["consolidated_"])


for file in Path(dir_1).rglob("*"):
    if file.is_file():
        # check if file is empty
        if file.stat().st_size == 0:
            print(f"File {file} is empty")
            # delete file
            file.unlink()
