# ---- Client Manager ----
MAX_API_KEY_RETRY = 3
MAX_KEY_PROCESS_COUNT = 1
API_VERSION = "v1alpha"
DEFAULT_REQUEST_TIMEOUT: int | None = 5 * 60 * 1000

# ---- Prompter ----
ROLE_MAPPINGS = {"assistant": "model", "user": "user", "system": "system"}
UPLOAD_IMAGES = False  # By default, images are not uploaded to the cloud.
MAX_PAYLOAD_SIZE = 20 * 1024 * 1024 * 0.9  # If prompt larger than this, upload parts of the payload to the cloud.

# --- google_utils.py ---
MAX_GENERATION_PER_BATCH = 8  # When `num_generations` > 1, istributed into `n/MAX_GENERATION_PER_BATCH` calls
MAX_REQUESTS_PER_MINUTE = 5  # Used in batch generation; limits to X concurrent calls per minute
# https://ai.google.dev/gemini-api/docs/rate-limits#free-tier

THINKING_MODELS_STRS = ["2.5", "thinking"]
MAX_THINKING_BUDGETS = {
    "gemini-2.5": 24576,
}


UPLOAD_ALL = True
