# ===============================================
# LINK: System Prompt parts
# ===============================================
from .common_prompts import common_prompts

# fmt:off

sys_prompt_critic_base = f"""You are an intelligent agent tasked with supervising an assistant utilizing a computer to accomplish computer-based tasks. Your job is to evaluate the assistant's work, and provide feedback so it can progress towards the objective.
\n
## Here's the information you'll have:
### The objective: This is the task the assistant is trying to complete.
### Screenshots: These are visual captures of the computer screen taken at specific states of the navigation process.{{annotation_info}}
{{trace_info}}{{summ_info}}{{k_info}}
\n
## Assistant's capabilities: To effectively analyze the assistant's work, consider the actions it can perform. These actions fall into the following categories:
### Mouse Actions:
- click(start_box='<|box_start|>(x1,y1)<|box_end|>'): Left clicks at the (x1,y1) coordinates.
- left_double(start_box='<|box_start|>(x1,y1)<|box_end|>'): Left double click at the (x1,y1) coordinates.
- right_single(start_box='<|box_start|>(x1,y1)<|box_end|>'): Right click at the (x1,y1) coordinates.
- drag(start_box='<|box_start|>(x1,y1)<|box_end|>', end_box='<|box_start|>(x3,y3)<|box_end|>'): Drags the element at the (x1,y1) coordinates to the (x3,y3) coordinates.
- scroll(start_box='<|box_start|>(x1,y1)<|box_end|>', direction='down or up or right or left'): Scrolls the mouse wheel in the specified direction.

### Keyboard Actions:
- hotkey(key=''): Press a specific key.
- type(content=''): Types the string following `content`. If followed by "\n", it means the input is submitted.
- wait(): Pauses for 5s and takes a new screenshot to check for any changes.

### Completion Action:
- finished(content='<|content|>'): This action is issued when the task is believed to be complete. `<content>` is optional, and is used to provide a reason why the task is complete.{{privileged_hint}}
\n
## To be successful, it is **very important** to follow the following rules:
{{rule}}
"""

annotation_info = "The red markers, if present, indicates the destination of mouse actions taken at the corresponding state."
trace_info_no_assistant = "\n### The execution trace: This is a sequence of screenshots of the computer screen, detailing the computer navigation so far."
trace_info_utt = "\n### The execution trace: This is a sequence of screenshots of the computer screen paired with the assistant's responses, detailing the computer navigation so far."
trace_info_actions = "\n### The execution trace: This is a sequence of screenshots of the computer screen paired with the assistant's actions, detailing the computer navigation so far."

summ_info = "\n### Summary of the execution trace: This is a textual summary of the navigation so far."

k_info = "\n### General Computer Knowledge: This is a general description of how tasks like this are typically accomplished on a computer."

k_rule_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Come up with a general description of how tasks like this are typically accomplished on computers.
4. Use this General Computer Knowledge as a guide, but also consider the context of the specific task given to you."""

rule_efficiency_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now."""

k_rule_efficiency_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
3. Come up with a general description of how tasks like this are typically accomplished on computers.
4. Use this General Computer Knowledge as a guide, but also consider the context of the specific task given to you."""

k_rule_efficiency_1p_vision = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
5. Come up with a general description of how tasks like this are typically accomplished on computers.
6. Use this General Computer Knowledge as a guide, but also consider the context of the specific task given to you."""


k_rule = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Use the General Computer Knowledge as a guide, but also consider the context of the specific task given to you.
"""

k_rule_efficiency = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Use the General Computer Knowledge as a guide, but also consider the context of the specific task given to you."""

k_rule_efficiency_vision = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
4. Your evaluation should be based on task completion; don't worry about efficiency for now.
5. Use the General Computer Knowledge as a guide, but also consider the context of the specific task given to you.
"""

rule_new = """
1. Your evaluation must be neutral and based on the **hard evidence** provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
5. Use the General Computer Knowledge as a guide, but also consider the context of the specific task given to you."""

# ===============================================
# LINK: Evaluation Criterias
# ===============================================
eval_criteria_tri = """
SUCCESS: The assistant executed **all of** what's necessary to complete the objective. The task is fully accomplished.
PARTIAL SUCCESS: The assistant executed **most of** what's necessary to complete the objective. The task is partially accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed.
"""


eval_criteria_bin = """
SUCCESS: The assistant executed **all of** what's necessary to complete the objective. The task is fully accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed.
"""


eval_criteria_quad = """
SUCCESS: The assistant executed **all of** what's necessary to complete the objective. The task is fully accomplished.
PARTIAL SUCCESS: The assistant executed **most of** what's necessary to complete the objective. The task is partially accomplished.
PARTIAL FAILURE: The assistant executed **part of** what's necessary to complete the objective. The task is partially accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed.
"""

# ===============================================
# LINK: CoT formats
# ===============================================
no_cot = ""

cot_phrase = common_prompts["reasoning_v2"]


basic_cot = f"""REASONING: {cot_phrase}"""


desc_cot = f"""
EXECUTION TRACE DESCRIPTION: [Carefully understand and describe the assistant's work]
REASONING: {cot_phrase}
"""

desc_cot_v2 = f"""
EXECUTION TRACE UNDERSTANDING: [Carefully understand the assistant's work and comprehensively describe the navigation so far]
REASONING: {cot_phrase}
"""


desc_ss = f"""
IMAGE UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
"""

desc_cot_screenshot = f"""
SCREENSHOT UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
REASONING: {common_prompts["reasoning_v2"]}
"""

desc_cot_ss = f"""
IMAGE UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
REASONING: {cot_phrase}
"""

desc_cot_ss_trace = f"""
IMAGE UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
EXECUTION TRACE DESCRIPTION: [Comprehensively describe the navigation so far and carefully understand the assistant's work]
REASONING: {cot_phrase}
"""

compare = f"""
COMPARISON: [Compare the assistant's work with the general computer knowledge. Make a step by step comparison of what the assistant did and what is expected]
RELEVANCE: [Which of the steps missing are relevant in this context? If the steps are not relevant, explain why]
REASONING: {cot_phrase}
"""

desc_compare = """
EXECUTION TRACE DESCRIPTION: [Comprehensively describe the navigation so far and carefully understand the assistant's work]
COMPARISON: [Compare the assistant's work with the general computer knowledge. Make a step by step comparison of what the assistant did and what is expected]
RELEVANCE: [Which of the steps missing are relevant in this context? If the steps are not relevant, explain why]
CONCLUSION: [Based on the assistant's work, comparison to general computer knowledge, and the objective, what are your conclusions?]
"""

desc_compare_v2 = f"""
EXECUTION TRACE UNDERSTANDING: [Comprehensively describe the navigation so far and carefully understand the assistant's work]
COMPARISON: [Compare the assistant's work with the general computer knowledge. Make a step by step comparison of what the assistant did and what is expected]
RELEVANCE: [Which of the steps missing, if any, are relevant in this context? If the steps are not relevant, explain why]
REASONING: {cot_phrase}
"""

# ===============================================
# LINK: Evaluation request
# ===============================================

response_format = f"""
{{k_retrieval_step}}
{{cot_parts}}
EVALUATION: [Your evaluation following the evaluation criteria]
FEEDBACK: [Feedback so the assistant can progress towards the objective]"""

eval_prompt_template = f"""Now please provide your response.
\n
## Here is the evaluation criteria:
{{eval_criteria}}
\n
## Provide your response as follows:
{{response_format}}
"""

# ===============================================
# LINK: K retrieval request
# ===============================================
sys_prompt_k_expert = f"""You are an intelligent and helpful assistant expert on computer navigation. Your job is to provide a **detailed** description of how tasks like the ones provided to you are typically accomplished on computers.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task, possibly accompanied by images that provide more context on what must be accomplished.
### Screenshots: These are screenshots of the computer screen to give you context on the state of the computer for the task at hand.
"""

sys_prompt_k_expert_v2 = """You are an intelligent and helpful assistant expert on computer systems. Your job is to provide a **detailed** description of how tasks like the ones provided to you are typically accomplished using computers.
\n
## Here's the information you'll have:
### Objective: This is an english description of a computer-based task.
### Screenshots: These are screenshots of the computer screen, giving you context to further understand what must be accomplished.

## To be successful, it is **very important** to follow the following rules:
1. Carefully understand what must be accomplished to come up with your response.
2. Connect the dots between the information provided and typical computer-based workflows.
3. You must be **comprehensive**, detailed, and thorough in your description.
4. You must be **parsimonious**; make sure your description applies to a wide range of situations.
5. Your description must be well-structured.
"""


sys_prompt_k_expert_v4 = f"""You are an intelligent and helpful assistant with deep knowledge in computer-based workflows. 
Your job is to provide a general, comprehensive, and detailed description of how tasks like the ones provided to you are typically accomplished on computers.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task that must be accomplished.
### Screenshots: These are screenshots of the computer screen, giving you context to further understand what must be accomplished."""

# K retrieval
phrase = "Description of how tasks such as this are typically accomplished on computers."
k_retrieval_1p = f"""GENERAL COMPUTER KNOWLEDGE: <{phrase}>"""

k_retrieval_2p = f"""Please first provide the following: 
[{phrase}]"""

k_retrieval_expert = f"""Now please provide your response:
[{phrase}]"""

k_retrieval_expert_v2 = f"""Now please provide your response as follows:
[Description of how tasks such as this are typically accomplished on computers]"""


k_retrieval_2p_look_for = """Please first provide the following: 
[What would you specifically look for to identify that a computer task such as this is accomplished?]"""


# K injection
k_injection = """## General Computer Knowledge:
{k}"""

k_injection_look_for = """## Typical signals of a successful execution for a task like this:
{k}"""

# ===============================================
# Prompt mappings
# ===============================================

eval_criterias = {
    "bin": eval_criteria_bin,
    "tri": eval_criteria_tri,
    "quad": eval_criteria_quad,
}

cot_parts = {
    "no_cot": no_cot,
    "basic_cot": basic_cot,
    "desc_cot": desc_cot,
    "desc_cot_v2": desc_cot_v2,
    "compare": compare,
    "desc_compare": desc_compare,
    "desc_cot_screenshot": desc_cot_ss,
    "desc_cot_ss_trace": desc_cot_ss_trace,
    "desc_ss": desc_ss,
    "desc_compare_v2": desc_compare_v2,
}

trace_infos = {
    "no_assistant": trace_info_no_assistant,
    "utt": trace_info_utt,
    "actions": trace_info_actions,
    "actions_last_u": trace_info_actions,
}

k_retrieval_queries = {
    "k_1p": k_retrieval_1p,
    "look_for": k_retrieval_2p_look_for,
    "k_2p": k_retrieval_2p,
    "k_2p_expert": k_retrieval_expert,
    "k_2p_expert_v2": k_retrieval_expert_v2,
    "k_2p_expert_v3": k_retrieval_expert_v2,
    "k_2p_expert_v4": k_retrieval_expert_v2,
}

k_injections = {
    "k": k_injection,
    "k_2p": k_injection,
    "k_2p_expert": k_injection,
    "k_2p_expert_v2": k_injection,
    "k_2p_expert_v3": k_injection,
    "k_2p_expert_v4": k_injection,
    "look_for": k_injection_look_for,
}

sys_prompts_expert = {
    "k_2p_expert": sys_prompt_k_expert,
    "k_2p_expert_v2": sys_prompt_k_expert_v2,
    # "k_2p_expert_v3": sys_prompt_k_expert_v3,
    "k_2p_expert_v4": sys_prompt_k_expert_v4,
}

prompts_osw = {
    "sys_prompts_critic": {"base": sys_prompt_critic_base},
    "sys_prompts_expert": sys_prompts_expert,
    "eval_criterias": eval_criterias,
    "cot_parts": cot_parts,
    "trace_infos": trace_infos,
    "k_retrieval_queries": k_retrieval_queries,
    "k_injections": k_injections,
    "response_format": response_format,
    "eval_prompt_template": eval_prompt_template,
    "summ_info": summ_info,
    "k_info": k_info,
    "k_rule": k_rule,
    "k_rule_1p": k_rule_1p,
    "k_rule_efficiency": k_rule_efficiency,
    "k_rule_efficiency_1p": k_rule_efficiency_1p,
    "rule_efficiency_1p": rule_efficiency_1p,
    "annotation_info": annotation_info,
    "desc_cot_screenshot": desc_cot_screenshot,
    "k_rule_efficiency_1p_vision": k_rule_efficiency_1p_vision,
    "sys_prompt_k_expert_v4": sys_prompt_k_expert_v4,
    "k_rule_efficiency_vision": k_rule_efficiency_vision,
    "rule_new": rule_new,
}



# Add all uppercase (constant) variables to prompts_osw, except built-ins and imported modules
import sys

_current_module = sys.modules[__name__]
for _var, _val in list(vars(_current_module).items()):
    if (
        not _var.startswith("_")
        and _var.isidentifier()
        and _var.islower() is False  # Only uppercase or mixed-case (convention: constants)
        and _var not in {"common_prompts", "sys", "prompts_osw"}  # Exclude imports and self
        and not callable(_val)
        and not isinstance(_val, dict)  # Avoid double-adding the main dicts
    ):
        prompts_osw[_var] = _val

del _current_module, _var, _val  # Clean up namespace
