#!/bin/bash

URL_FILE="./config/webarena_urls/urls.txt"

if [[ ! -f $URL_FILE ]]; then
  echo "URL file does not exist: $URL_FILE"
  exit 1
fi

echo "Checking if websites are reachable..."

while IFS= read -r line; do
  site=$(echo "$line" | cut -d ' ' -f 1)
  url=$(echo "$line" | cut -d ' ' -f 2)

  if curl -s --head "$url" | head -n 1 | grep "HTTP/1.[01] [23].." > /dev/null; then
    printf "%-15s %-10s %s\n" "$site" "UP" "URL: $url"
  else
    printf "%-15s %-10s %s\n" "$site" "DOWN" "URL: $url"
  fi
done < "$URL_FILE"

echo "Check complete."
