#!/bin/bash
# This script loads the environment images into Docker. Needs to run only once for each image.

# Function to check if a site is in the command input list
is_site_in_list() {
  local site="$1"
  for s in "${sites[@]}"; do
    if [[ "$s" == "$site" ]]; then
      return 0
    fi
  done
  return 1
}

# Directory where docker images are saved
docker_img_folders='/data1/webgui/vwebarena/docker_imgs'

sites=("$@")  # sites=('shopping' 'admin' 'reddit' 'gitlab' 'classifieds')
# Usage: ./load_docker_images.sh shopping admin reddit gitlab

# Load Image for Shopping Website (OneStopShop)  [WebArena & VWebArena]
if is_site_in_list "shopping"; then
    docker load --input "$docker_img_folders/shopping_final_0712.tar"
fi

# Load Image for Shopping Admin Website [WebArena]
if is_site_in_list "admin"; then
    docker load --input "$docker_img_folders/shopping_admin_final_0719.tar"
fi

# Load Social Forum Website (Reddit) [WebArena & VWebArena]
if is_site_in_list "reddit"; then
    docker load --input "$docker_img_folders/postmill-populated-exposed-withimg.tar"
fi

# Gitlab Website [WebArena]
if is_site_in_list "gitlab"; then
    docker load --input "$docker_img_folders/gitlab-populated-final-port8023.tar"
fi

# Classifieds [VWebArena] 
# Can take long time if running for the first time; it will download image before loading into Docker.
if is_site_in_list "classifieds"; then
    docker pull jykoh/classifieds:latest
    docker pull mysql:8.1
fi
