"""Replace the website placeholders with website domains from env_config
Generate the test data"""
import json
import os

from browser_env.env_config import *

inp_paths = [
    "config_files/vwa/test_classifieds.raw.json", "config_files/vwa/test_shopping.raw.json", "config_files/vwa/test_reddit.raw.json",
    "config_files/wa/test_webarena.raw.json",  # Uncomment to generate test files for WebArena,
    "config_files/vwa_not_vague/test_classifieds.raw.json",
    "config_files/vwa_not_vague/test_shopping.raw.json",
    "config_files/vwa_not_vague/test_reddit.raw.json",
]


def main(inp_paths=inp_paths) -> None:
    replace_map = {
        "__REDDIT__": REDDIT,
        "__SHOPPING__": SHOPPING,
        "__SHOPPING_ADMIN__": SHOPPING_ADMIN,
        "__GITLAB__": GITLAB,
        "__WIKIPEDIA__": WIKIPEDIA,
        "__MAP__": MAP,
        "__CLASSIFIEDS__": CLASSIFIEDS
    }

    for inp_path in inp_paths:
        output_dir = inp_path.replace('.raw.json', '')
        os.makedirs(output_dir, exist_ok=True)
        with open(inp_path, "r") as f:
            raw = f.read()
        for k, v in replace_map.items():
            raw = raw.replace(k, v)

        with open(inp_path.replace(".raw", ""), "w") as f:
            f.write(raw)
        data = json.loads(raw)

        for idx, item in enumerate(data):
            with open(os.path.join(output_dir, f"{idx}.json"), "w") as f:
                json.dump(item, f, indent=2)


if __name__ == "__main__":
    main()
