
import os
import re
import shutil

# get all directories in experiments/GPT4o_base_stateaware/results_shopping/
experiments_dir = 'experiments/GPT4o_base_stateless/results_shopping/'

# Create 'failed_trajectories' folder if it doesn't exist
failed_trajectories_dir = os.path.join(experiments_dir, 'failed_trajectories')
os.makedirs(failed_trajectories_dir, exist_ok=True)

# Get all directories in the experiments directory
results_directories = [os.path.join(experiments_dir, d) for d in os.listdir(experiments_dir) if os.path.isdir(os.path.join(experiments_dir, d))]

# Read the failed_tasks.txt file
for result_dir in results_directories:
    try:
        with open(result_dir + '/failed_tasks.txt', 'r') as f:
            failed_ids = [line.strip() for line in f if line.strip()]

        # Compile regex patterns for matching files
        render_pattern = re.compile(r'render_(\d+)\.html')
        conversation_pattern = re.compile(r'conversations_(\d+)\.txt')

        # Iterate through files in the directory
        for filename in os.listdir(result_dir):
            render_match = render_pattern.match(filename)
            conversation_match = conversation_pattern.match(filename)
            
            if render_match and render_match.group(1) in failed_ids:
                os.remove(os.path.join(result_dir, filename))  
                # shutil.move(os.path.join(result_dir, filename), os.path.join(failed_trajectories_dir, filename))
                # print(f"Moved: {filename}")
            elif conversation_match and conversation_match.group(1) in failed_ids:
                os.remove(os.path.join(result_dir, filename))   
                # shutil.move(os.path.join(result_dir, filename), os.path.join(failed_trajectories_dir, filename))
                # print(f"Moved: {filename}")

        print(f"Moving for {result_dir} complete.")
    except Exception as e:
        print(f"Error processing {result_dir}: {e}")