# autopep8: off
# fmt: off

#===============================================
# Base system prompt
#===============================================
sys_prompt_base = """You are an intelligent agent tasked with supervising an assistant navigating a web browser to accomplish a web-based task. Your job is to evaluate the assistant's work, and provide feedback so it can progress towards the objective.
\n
## Here's the information you'll have:
### The objective: This is the task the assistant is trying to complete.
### Webpage screenshots: These are screenshots of the webpage, with each interactable element assigned a unique numerical id. Each bounding box and its respective id shares the same color.
### The execution trace: This is a sequence of webpage screenshots paired with the assistant's responses, detailing the web navigation so far.{web_knowledge_info}
\n
## Assistant's capabilities: To effectively analyze the assistant's work, consider the actions it can perform. These actions fall into the following categories:
### Page Operation Actions:
```click [id]```: Click on an element with a specific id on the webpage.
```type [id] [content] [enter_after]```: Type the content into the field with id. If `enter_after` is 0, the "Enter" key is not pressed after typing; otherwise, the "Enter" key is automatically pressed.
```hover [id]```: Hover over an element with id.
```press [key_comb]```: Press a keyboard key or key combination (e.g., delete, ctrl+a).
```scroll [down]``` or ```scroll [up]```: Scroll the webpage up or down.

### Tab Management Actions:
```new_tab```: Open a new, empty browser tab.
```tab_focus [tab_index]```: Switch the browser's focus to a specific tab using its index.
```close_tab```: Close the currently active tab.

### URL Navigation Actions:
```goto [url]```: Navigate to a specific URL.
```go_back```: Navigate to the previously viewed page.
```go_forward```: Navigate to the next page (if a previous 'go_back' action was performed).

### Completion Action:
```stop [answer]```: This action is issued when the task is believed to be complete. If the task requires a text-based answer, the answer is provided within the brackets. If the task is deemed impossible, this action is issued optionally with a reason why.
\n
## To be successful, it is very important to follow the following rules:
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.{web_knowledge_rule}
"""

web_knowledge_info = "\n### General web knowledge: This is a general description of how tasks like this are typically accomplished on the web."
web_knowledge_rule = "\n3. Use the General web knowledge as a guide, but also consider the context of the specific task given to you."

sys_prompt_k_expert = f"""You are an expert on web navigation. Your job is to provide a general description of how tasks like the ones provided to you are typically accomplished on the web.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task, possibly accompanied by images that provide more context on what must be accomplished.
### Screenshots: These are screenshots of the webpage, giving you context of the current state of the navigation process."""

#===============================================
# Evaluation criteria
#===============================================
eval_criteria = """Now please provide your response.
\n
## Here is the evaluation criteria:
SUCCESS: The assistant executed **all** that's necessary to complete the objective. The task is fully accomplished.
PARTIAL SUCCESS: The assistant executed **part of** what's necessary to complete the objective. The task is partially accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed."""

eval_criteria_binary = """Now please provide your response.
\n
## Here is the evaluation criteria:
SUCCESS: The assistant executed **all** that's necessary to complete the objective. The task is fully accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed."""


# Response formats/queries
response_format_basicCoT = """## Provide your response as follows:
REASONING: [Your reasoning to come up with your evaluation and feedback]
EVALUATION: [Your evaluation following the evaluation criteria]
FEEDBACK: [Feedback so the assistant can progress towards the objective]"""

response_format_compare = """## Provide your response as follows:
EXECUTION TRACE DESCRIPTION: [Understand and describe the assistant's work]
COMPARISON: [Compare the assistant's work with the general web knowledge. Make a step by step comparison of what the assistant did and what is expected.]
RELEVANCE: [Which of the steps missing are relevant in this context. If the steps are not relevant, explain why.]
CONCLUSION: [Based on the assistant's work, comparison to general web knowledge, and the objective, what are your conclusions?]
EVALUATION: [Your evaluation following the evaluation criteria]
FEEDBACK: [Feedback so the assistant can progress towards the objective]"""

response_format_compare_objective = """## Provide your response as follows:
OBJECTIVE: [Reestate the objective the assistant is trying to accomplish]
EXECUTION TRACE DESCRIPTION: [Understand and describe the assistant's work]
COMPARISON: [Compare the assistant's work with the general web knowledge. Make a step by step comparison of what the assistant did and what is expected.]
RELEVANCE: [Which of the steps missing are relevant in this context. If the steps are not relevant, explain why.]
CONCLUSION: [Based on the assistant's work, comparison to general web knowledge, and the objective, what are your conclusions?]
EVALUATION: [Your evaluation following the evaluation criteria]
FEEDBACK: [Feedback so the assistant can progress towards the objective]"""


# Prompt dictionary given at runtime
prompt = {

#===============================================
# System prompts
#===============================================
"system_prompt_two_pass": sys_prompt_base.format(web_knowledge_info=web_knowledge_info, web_knowledge_rule=web_knowledge_rule),
"system_prompt_one_pass": sys_prompt_base.format(web_knowledge_info="", web_knowledge_rule=""),


#===============================================
# Evaluation prompts
#===============================================
"eval_prompt_two_pass": f"""{eval_criteria}
\n
{response_format_compare}""",


"eval_prompt_one_pass": f"""{eval_criteria}
\n
{response_format_basicCoT}""",


#===============================================
# Execution history
#===============================================
"intro_execution_history":
"""## Here is the trace of execution so far:
""",

#===============================================
# Objective
#===============================================
"objective_template":
"""## OBJECTIVE:
{objective}""",


#===============================================
# Knowledge retrieval prompt
#===============================================
"knowledge_retrieval_prompt":
"""Please first provide the following: 
[Description of how tasks such as this are typically accomplished on the web]
""",

"k_retrieval_expert":
"""Now please provide your response:
[Description of how tasks such as this are typically accomplished on the web.]""",

#===============================================
# Knowledge injection prompt
#===============================================
"knowledge_injection_prompt":"""## General Web Knowledge:
{knowledge_retrieval_response}""",


# Text to prepend before each observation in the history
# Text to prepend before each observation in the history
"intro_img_obs_history": """STATE `t-{t}` SCREENSHOT:""",

'parsing_error_msg_template':
"""\n\n## ERROR: Your previous response was:\n{response}.\nHowever, the format is incorrect. Please make sure to answer as requested above.""",


# Metadata
"meta_data": {
    "prompt_constructor": "CritiquePromptConstructor",
    "use_text_observation": False,
    "use_img_observation": True,
    "use_assistant_utterance": False,          # TODO: change this to  a history type meta_data
    "use_low_level_actions_env_parsed": True,  # TODO: change this to a history type meta_data
    "splitters_first_pass": [""],
    "splitters_second_pass": ["EXECUTION TRACE DESCRIPTION:", "COMPARISON:", "RELEVANCE:", "CONCLUSION:", "EVALUATION:", "FEEDBACK:"],
    "eval_scores":["SUCCESS", "PARTIAL SUCCESS", "FAILURE"],
    "eval_key": "EVALUATION",
    "feedback_key": "FEEDBACK",
    "success_keyword": "SUCCESS",
    "parsing_error_msg_key": "critique_parsing_error",
    "required_splitters": ["EVALUATION", "FEEDBACK"],
    },
}
