# websites domain
import os

# websites domain

# VWA
REDDIT = os.environ.get("REDDIT", "")
SHOPPING = os.environ.get("SHOPPING", "")
WIKIPEDIA = os.environ.get("WIKIPEDIA", "")
HOMEPAGE = os.environ.get("HOMEPAGE", "")
CLASSIFIEDS = os.environ.get("CLASSIFIEDS", "")
CLASSIFIEDS_RESET_TOKEN = os.environ.get("CLASSIFIEDS_RESET_TOKEN", "")
REDDIT_RESET_URL = os.environ.get("REDDIT_RESET_URL", "")

# WebArena
SHOPPING_ADMIN = os.environ.get("SHOPPING_ADMIN", "")
GITLAB = os.environ.get("GITLAB", "")
MAP = os.environ.get("MAP", "")

assert (
    len(REDDIT) > 0
    and len(SHOPPING) > 0
    and len(WIKIPEDIA) > 0
    and len(HOMEPAGE) > 0
    and len(CLASSIFIEDS) > 0
    and len(CLASSIFIEDS_RESET_TOKEN) > 0
    and len(SHOPPING_ADMIN) > 0
    and len(GITLAB) > 0
    and len(MAP) > 0
), (
    f"Please setup the URLs and tokens to each site. Current: "
    + f"Reddit: {REDDIT}"
    # + f"  Reddit reset url: {REDDIT_RESET_URL}"
    + f"Shopping: {SHOPPING}"
    + f"Wikipedia: {WIKIPEDIA}"
    + f"Homepage: {HOMEPAGE}"
    + f"Classifieds: {CLASSIFIEDS}"
    + f"  Classifieds reset token: {CLASSIFIEDS_RESET_TOKEN}"
)


ACCOUNTS = {
    "reddit": {"username": "MarvelsGrantMan136", "password": "test1234"},
    "shopping": {
        "username": "emma.lopez@gmail.com",
        "password": "Password.123",
    },
    "classifieds": {
        "username": "blake.sullivan@gmail.com",
        "password": "Password.123",
    },
    "shopping_site_admin": {"username": "admin", "password": "admin1234"},
    "shopping_admin": {"username": "admin", "password": "admin1234"},
    "gitlab": {"username": "byteblaze", "password": "hello1234"},
}

URL_MAPPINGS = {
    # VWA:
    SHOPPING: "http://onestopmarket.com",
    WIKIPEDIA: "http://wikipedia.org",
    HOMEPAGE: "http://homepage.com",
    CLASSIFIEDS: "http://classifieds.com",
    REDDIT: "http://reddit.com",
}

LOCAL_URLS_NORM = {
    WIKIPEDIA: f"{WIKIPEDIA}/wikipedia_en_all_maxi_2022-05",
    REDDIT: REDDIT,
    SHOPPING: SHOPPING,
    HOMEPAGE: HOMEPAGE,
    CLASSIFIEDS: CLASSIFIEDS,
}

PAGE_NAME_NORMALIZATIONS = {
    WIKIPEDIA: ("User:The other Kiwix guy/Landing", "Welcome to Wikipedia"),
}

SITE_NAMES = {
    REDDIT: ["Reddit"],
    SHOPPING: ["One Stop Market", "shopping"],
    HOMEPAGE: ["Homepage"],
    CLASSIFIEDS: ["Classifieds"],
    GITLAB: ["GitLab"],
    MAP: ["Map"],
}

# WebArena:
if SHOPPING_ADMIN:
    URL_MAPPINGS[SHOPPING_ADMIN] = "http://luma.com/admin"
    LOCAL_URLS_NORM[SHOPPING_ADMIN] = SHOPPING_ADMIN
if GITLAB:
    URL_MAPPINGS[GITLAB] = "http://gitlab.com"
    LOCAL_URLS_NORM[GITLAB] = GITLAB
if MAP:
    URL_MAPPINGS[MAP] = "http://openstreetmap.org"
    LOCAL_URLS_NORM[MAP] = MAP
