# ===============================================
# LINK: System Prompt parts
# ===============================================
# fmt:off
from .common_prompts import common_prompts

sys_prompt_critic_base = f"""You are an intelligent agent tasked with supervising an assistant navigating a web browser to accomplish a web-based task. Your job is to evaluate the assistant's work, and provide feedback so it can progress towards the objective.
\n
## Here's the information you'll have:
### The objective: This is the task the assistant is trying to complete.
### Webpage screenshots: These are screenshots of the webpage, with each interactable element assigned a unique numerical id. Each bounding box and its respective id shares the same color.
{{trace_info}}{{summ_info}}{{k_info}}
\n
## Assistant's capabilities: To effectively analyze the assistant's work, consider the actions it can perform. These actions fall into the following categories:
### Page Operation Actions:
```click [id]```: Click on an element with a specific id on the webpage.
```type [id] [content] [enter_after]```: Type the content into the field with id. If `enter_after` is 0, the "Enter" key is not pressed after typing; otherwise, the "Enter" key is automatically pressed.
```hover [id]```: Hover over an element with id.
```press [key_comb]```: Press a keyboard key or key combination (e.g., delete, ctrl+a).
```scroll [down]``` or ```scroll [up]```: Scroll the webpage up or down.

### Tab Management Actions:
```new_tab```: Open a new, empty browser tab.
```tab_focus [tab_index]```: Switch the browser's focus to a specific tab using its index.
```close_tab```: Close the currently active tab.

### URL Navigation Actions:
```goto [url]```: Navigate to a specific URL.
```go_back```: Navigate to the previously viewed page.
```go_forward```: Navigate to the next page (if a previous 'go_back' action was performed).

### Completion Action:
```stop [answer]```: This action is issued when the task is believed to be complete. If the task requires a text-based answer, the answer is provided within the brackets. If the task is deemed impossible, this action is issued optionally with a reason why.

{{privileged_hint}}\n
## To be successful, it is very important to follow the following rules:
{{rule}}
"""


trace_info_no_assistant = "\n### The execution trace: This is a sequence of webpage screenshots, detailing the web navigation so far."
trace_info_utt = "\n### The execution trace: This is a sequence of webpage screenshots paired with the assistant's responses, detailing the web navigation so far."
trace_info_actions = "\n### The execution trace: This is a sequence of webpage screenshots paired with the assistant's actions, detailing the web navigation so far."

summ_info = "\n### Summary of the execution trace: This is a textual summary of the navigation so far."

k_info = "\n### General web knowledge: This is a general description of how tasks like this are typically accomplished on the web."
# k_info = "\n### General web knowledge: This is a general description of how tasks like this are typically accomplished on the web, offering supporting information for your evaluation."

### Rule 1p
rule_efficiency_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now."""

rule_efficiency_vision_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace."""

k_rule_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. You should come up with a detailed description of how tasks like this are typically accomplished on the web.
4. Use this general web knowledge as a guide, but also consider the context of the specific task given to you."""

k_rule_efficiency_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. You should come up with a detailed description of how tasks like this are typically accomplished on the web.
5. Use this General Web Knowledge as a guide, but also consider the context of the specific task given to you."""



k_rule_efficiency_vision_1p = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
5. You should come up with a detailed description of how tasks like this are typically accomplished on the web.
6. Use this General Web Knowledge as a guide, but also consider the context of the specific task given to you."""

### Rule 2p
k_rule = "3. Use the General web knowledge as a guide, but also consider the context of the specific task given to you."
k_rule_efficiency = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Use the General web knowledge as a guide, but also consider the context of the specific task given to you."""

k_rule_efficiency_vision = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
5. Use the General web knowledge as a guide, but also consider the context of the specific task given to you."""

k_rule_efficiency_v3 = """
1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
2. You must connect the dots between the objective and the information provided.
3. Base your evaluation on task completion. Give less importance to efficiency or other aspects for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
5. Use the General web knowledge as a guide, but also consider the context of the specific task given to you."""

# k_rule_efficiency_v4 = """
# 1. You must not not assume the assistant's work is correct or incorrect beforehand. You should come up with your own opinion based on the information provided.
# 2. You must connect the dots between the objective and the information provided.
# 3. Your evaluation should be based on task completion; don't worry about efficiency for now.
# 4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
# 5. Use the General web knowledge as a guide with parsimony, also considering the context of the specific task given to you."""

rule_new = """
1. You must strive to be neutral and base your evaluation on the hard evidence provided.
2. You must connect the dots between the objective and the information provided.
3. Your evaluation should be based on task completion; don't worry about efficiency for now.
4. Give utmost importance to the visual information provided, especially the screenshots in the execution trace.
5. Use the General web knowledge as a guide, but also consider the context of the specific task given to you."""


# ===============================================
# LINK: first pass prompts
# ===============================================
sys_prompt_k_expert = f"""You are an expert on web navigation. Your job is to provide a general description of how tasks like the ones provided to you are typically accomplished on the web.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task, possibly accompanied by images that provide more context on what must be accomplished.
### Screenshots: These are screenshots of the webpage, giving you context of the current state of the navigation process."""


sys_prompt_k_expert_v2 = """You are an intelligent and helpful assistant with deep expertise in web navigation. 
You will be given web tasks, and your job is to provide a **detailed description** of how tasks like these are typically accomplished on the web.

## Here's the information you'll have:
### Objective: This is the web task, described in english and possibly accompanied by images that provide context on what must be accomplished.
### Screenshots: These are screenshots of the webpage, giving you context to further understand what must be accomplished.

## To be successful, it is **very important** to follow the following rules:
1. Carefully understand what must be accomplished to come up with your response.
2. Connect the dots between the information provided and typical web navigation workflows.
3. You must be **comprehensive**, detailed, and thorough in your description.
4. You must be **parsimonious**; make sure your description applies to a wide range of situations.
5. Your description must be well-structured.
"""

sys_prompt_k_expert_v3 = f"""You are an expert on web navigation. Your job is to provide a general and **detailed** description of how tasks like the ones provided to you are typically accomplished on the web.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task, possibly accompanied by images that provide more context on what must be accomplished.
### Screenshots: These are screenshots of the webpage, giving you context of the state of the navigation for the task at hand.

## To be successful, it is very important to follow the following rules:
1. You must carefully understand what must be accomplished from the information provided and connect the dots to typical web navigation workflows.
2. You must strive to be comprehensive, thorough, and parsimonious in your description.
"""

sys_prompt_k_expert_v4 = f"""You are an expert on web navigation. Your job is to provide a comprehensive and **detailed** description of how tasks like the ones provided to you are typically accomplished on the web.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task, possibly accompanied by images that provide more context on what must be accomplished.
### Screenshots: These are screenshots of the webpage, giving you context of the state of the navigation for the task at hand.
"""

sys_prompt_k_expert_v5 = f"""You are a helpful assistant with deep expertise in web navigation. Your job is to provide a **comprehensive** and **detailed** description of how tasks like the ones provided to you are typically accomplished on the web.
\n
## Here's the information you'll have:
### Objective: This is an english description of the task, possibly accompanied by images that provide more context on what must be accomplished.
### Screenshots: These are screenshots of the webpage, giving you context of the state of the navigation for the task at hand.
"""


# ===============================================
# LINK: Evaluation Criterias
# ===============================================
eval_criteria_tri = """
SUCCESS: The assistant executed **all of** what's necessary to complete the objective. The task is fully accomplished.
PARTIAL SUCCESS: The assistant executed **most of** what's necessary to complete the objective. The task is partially accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed.
"""


eval_criteria_bin = """
SUCCESS: The assistant executed **all of** what's necessary to complete the objective. The task is fully accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed.
"""


eval_criteria_quad = """
SUCCESS: The assistant executed **all of** what's necessary to complete the objective. The task is fully accomplished.
PARTIAL SUCCESS: The assistant executed **most of** what's necessary to complete the objective. The task is partially accomplished.
PARTIAL FAILURE: The assistant executed **part of** what's necessary to complete the objective. The task is partially accomplished.
FAILURE: The assistant executed **mostly incorrect** steps. The task is not accomplished, and major revisions are needed.
"""

# ===============================================
# LINK: CoT formats
# ===============================================
no_cot = ""

cot_phrase = common_prompts["reasoning_v2"]
basic_cot = f"""
REASONING: {cot_phrase}
"""
desc_trace = f"""
EXECUTION TRACE DESCRIPTION: [Carefully understand and describe the assistant's work]
"""

desc_cot = f"""
EXECUTION TRACE DESCRIPTION: [Carefully understand and describe the assistant's work]
REASONING: {cot_phrase}
"""

desc_cot_v2 = f"""
EXECUTION TRACE UNDERSTANDING: [Carefully understand the assistant's work and comprehensively describe the navigation so far]
REASONING: {cot_phrase}
"""

desc_ss = f"""
IMAGE UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
"""

desc_cot_ss = f"""
IMAGE UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
REASONING: {cot_phrase}
"""

desc_cot_ss_trace = f"""
IMAGE UNDERSTANDING: [Meticulously analyze the screenshots, identifying and describing the elements most pertinent for the task at hand]
EXECUTION TRACE DESCRIPTION: [Carefully understand and describe the assistant's work]
REASONING: {cot_phrase}
"""

compare = f"""
COMPARISON: [Compare the assistant's work with the general web knowledge. Make a step by step comparison of what the assistant did and what is expected]
RELEVANCE: [Which of the steps missing are relevant in this context? If the steps are not relevant, explain why]
REASONING: {cot_phrase}
"""

desc_compare = """
EXECUTION TRACE DESCRIPTION: [Carefully understand and describe the assistant's work]
COMPARISON: [Compare the assistant's work with the general web knowledge. Make a step by step comparison of what the assistant did and what is expected]
RELEVANCE: [Which of the steps missing are relevant in this context? If the steps are not relevant, explain why]
CONCLUSION: [Based on the assistant's work, comparison to general web knowledge, and the objective, what are your conclusions?]
"""

desc_compare_v2 = """
EXECUTION TRACE UNDERSTANDING: [Comprehensively describe the navigation so far and carefully understand the assistant's work]
COMPARISON: [Compare the assistant's work with the general web knowledge. Make a step by step comparison of what the assistant did and what is expected]
RELEVANCE: [Which of the steps missing, if any, are relevant in this context? If the steps are not relevant, explain why]
REASONING: {cot_phrase}
"""


# ===============================================
# LINK: Evaluation request
# ===============================================

response_format = f"""
{{k_retrieval_step}}
{{cot_parts}}
EVALUATION: [Your evaluation following the evaluation criteria]
FEEDBACK: [Feedback so the assistant can progress towards the objective]"""

eval_prompt_template = f"""Now please provide your response.
\n
## Here is the evaluation criteria:
{{eval_criteria}}
\n
## Provide your response as follows:
{{response_format}}
"""

# ===============================================
# LINK: K retrieval request
# ===============================================
# K retrieval

k_retrieval_1p = """GENERAL WEB KNOWLEDGE: [Description of how tasks such as this are typically accomplished on the web]"""

k_retrieval_2p = """Please first provide the following: 
<Description of how tasks such as this are typically accomplished on the web>"""

k_retrieval_expert = """Now please provide your response:
<Description of how tasks such as this are typically accomplished on the web>"""

k_retrieval_expert_v2 = """Now please provide your response:
<General description of how tasks like this are typically accomplished on the web>"""

k_retrieval_expert_v3 = """Now please provide your response as follows:
<Description of how tasks such as this are typically accomplished on the web>"""

# k_retrieval_expert_v4 = k_retrieval_expert_v3
k_retrieval_expert_v4 = """Now please provide your response: how tasks like these are typically accomplished on the web?"""
# k_retrieval_expert_v4 = ""


k_retrieval_2p_look_for = """Please first provide the following: 
[What would you specifically look for to identify that a web task such as this is accomplished?]"""


# K injection
k_injection = """## General web knowledge:
{k}"""

k_injection_look_for = """## Typical signals of a successful execution for a task like this:
{k}"""

# ===============================================
# Prompt mappings
# ===============================================

eval_criterias = {
    "bin": eval_criteria_bin,
    "tri": eval_criteria_tri,
    "quad": eval_criteria_quad,
}

cot_parts = {
    "no_cot": no_cot,
    "basic_cot": basic_cot,
    "desc_cot": desc_cot,
    "desc_cot_v2": desc_cot_v2,
    "compare": compare,
    "desc_compare": desc_compare,
    "desc_cot_screenshot": desc_cot_ss,
    "desc_cot_ss_trace": desc_cot_ss_trace,
    "desc_trace": desc_trace,
    "desc_ss": desc_ss,
    "desc_compare_v2": desc_compare_v2,
}

trace_infos = {
    "no_assistant": trace_info_no_assistant,
    "utt": trace_info_utt,
    "actions": trace_info_actions,
    "actions_last_u": trace_info_actions,
}

k_retrieval_queries = {
    "k_1p": k_retrieval_1p,
    "look_for": k_retrieval_2p_look_for,
    "k_2p": k_retrieval_2p,
    "k_2p_expert": k_retrieval_expert,
    "k_2p_expert_v2": k_retrieval_expert_v2,
    "k_2p_expert_v3": k_retrieval_expert_v3,
    "k_2p_expert_v4": k_retrieval_expert_v4,
}

k_injections = {
    "k": k_injection,
    "k_2p": k_injection,
    "k_2p_expert": k_injection,
    "k_2p_expert_v2": k_injection,
    "k_2p_expert_v3": k_injection,
    "k_2p_expert_v4": k_injection,
    "look_for": k_injection_look_for,
}


prompts_vwa = {
    "sys_prompts_critic": {"base": sys_prompt_critic_base},
    "sys_prompts_expert": {"k_2p_expert": sys_prompt_k_expert, "k_2p_expert_v2": sys_prompt_k_expert_v2, "k_2p_expert_v3": sys_prompt_k_expert_v3, "k_2p_expert_v4": sys_prompt_k_expert_v4},
    "eval_criterias": eval_criterias,
    "cot_parts": cot_parts,
    "trace_infos": trace_infos,
    "k_retrieval_queries": k_retrieval_queries,
    "k_injections": k_injections,
    "response_format": response_format,
    "eval_prompt_template": eval_prompt_template,
    "summ_info": summ_info,
    "k_info": k_info,

    # 1p, K
    # "k_rule_1p": k_rule_1p,
    # "k_rule_efficiency_1p": k_rule_efficiency_1p,
    "k_rule_efficiency_vision_1p": k_rule_efficiency_vision_1p,
    "rule_efficiency_vision_1p": rule_efficiency_vision_1p,
    # 1p, no K
    # "rule_efficiency_1p": rule_efficiency_1p,
    "rule_efficiency_1p_v2": rule_efficiency_vision_1p,

    # 2p, K
    "k_rule": k_rule,
    # "k_rule_efficiency": k_rule_efficiency,
    # "k_rule_efficiency_v3": k_rule_efficiency_v3,
    # "k_rule_efficiency_v4": k_rule_efficiency_v3,
    "k_rule_efficiency_vision": k_rule_efficiency_vision,

    "rule_new": rule_new,
}




# Add all uppercase (constant) variables to prompts_osw, except built-ins and imported modules
import sys

_current_module = sys.modules[__name__]
for _var, _val in list(vars(_current_module).items()):
    if (
        not _var.startswith("_")
        and _var.isidentifier()
        and _var.islower() is False  # Only uppercase or mixed-case (convention: constants)
        and _var not in {"common_prompts", "sys", "prompts_osw"}  # Exclude imports and self
        and not callable(_val)
        and not isinstance(_val, dict)  # Avoid double-adding the main dicts
    ):
        prompts_vwa[_var] = _val

del _current_module, _var, _val  # Clean up namespace
