#!/bin/bash

# Set default values
export GOOGLE_API_KEY='<key>'
export OPENAI_API_KEY='<key>'
export HF_TOKEN='<key>'


# Check if API_KEY is provided
if [ "${API_KEY+set}" = "set" ]; then
    # Check if API_KEY is blank. In that case, do nothing.
    if [ -z "$API_KEY" ]; then
        :
    else
        # API_KEY is provided and non-blank, so override the default values
        # based on the API key pattern.
        if [[ "$API_KEY" == "AIzaSy"* ]]; then
            export GOOGLE_API_KEY="$API_KEY"
        elif [[ "$API_KEY" == "sk-"* ]]; then
            export OPENAI_API_KEY="$API_KEY"
        elif [[ "$API_KEY" == "hf_"* ]]; then
            export HF_TOKEN="$API_KEY"
        else
            echo "Error: Unable to infer API provider from API_KEY pattern."
            exit 1
        fi
    fi
fi