yaml_file="./config/model_repo.yaml" 

model_name='blip2'
num_shard=1

# Extracting configuration
hf_endpoint=$(yq e ".models.$model_name.model_path" $yaml_file)
quant=$(yq e ".models.$model_name.quant" $yaml_file)
hf_models_location=$(yq e ".general.hf_models_location" $yaml_file)

cd $hf_models_location

if [ -z "$quant" ]; then
    text-generation-launcher --model-id $hf_endpoint --num-shard $num_shard \
        --port 9555 --master-port 9555 --master-addr localhost
else
    text-generation-launcher --model-id $hf_endpoint --num-shard $num_shard \
        --port 9555 --master-port 9555 --master-addr localhost
fi