from datasets import load_dataset, DatasetDict, concatenate_datasets, load_from_disk
from transformers import AutoTokenizer, AutoModelForCausalLM, set_seed
import torch
import os
import numpy as np
import random
import time
import argparse

###############
# Load datasets
###############
# parser = H4ArgumentParser((ModelArguments, DataArguments, RDPOConfig))
# model_args, data_args, training_args = parser.parse()

parser = argparse.ArgumentParser()

parser.add_argument("--dataset", type=str)

args = parser.parse_args()

dataset_dir = args.dataset


if __name__ == "__main__":

    train_dataset = load_from_disk(dataset_dir)
    pi0 = train_dataset["logpiref0"]
    pi1 = train_dataset["logpiref1"]
    result = np.abs(np.array(pi0) - np.array(pi1))
    print(result[:50])
    print("mean:", np.mean(result))
    print("std:", np.std(result))
