#!/usr/bin/env python3
# -*- coding: utf-8 -*-


def get_file_name(
    dataset: str,
    sampling: str,
    n_iter: int,
    n_SGD: int,
    batch_size: int,
    lr_global: float,
    lr_local: float,
    n_sampled: float,
    mu: float,
    importances: bool,
    decay: float,
    seed: int,
):
    """
    file name used to save the different experiments results
    """

    file_name = (
        f"{dataset}_{sampling}_{importances}_T{n_iter}_E{n_SGD}"
        f"_B{batch_size}_lr_g{lr_global}_lr_l{lr_local}"
    )

    if sampling != "Full":
        file_name += f"_m{n_sampled}_s{seed}"

    if mu > 0.0:
        file_name += f"_mu{mu}"

    if decay < 1.0:
        file_name += f"_d{decay}"

    return file_name

import os

def find_previous_simulations(
    dataset: str,
    sampling: str,
    n_SGD: int,
    batch_size: int,
    lr_global: float,
    lr_local: float,
    n_sampled: float,
    mu: float,
    importances: bool,
    decay: float,
    seed: int):

    part_1 = f"{dataset}_{sampling}_{importances}_T"

    part_2 = f"_E{n_SGD}_B{batch_size}_lr_g{lr_global}_lr_l{lr_local}"
    if sampling != "Full":
        part_2 += f"_m{n_sampled}_s{seed}"

    if mu > 0.0:
        part_2 += f"_mu{mu}"

    if decay < 1.0:
        part_2 += f"_d{decay}"

    part_2 += ".pth"

    list_models = os.listdir("saved_exp_info/final_model")
    print(len(list_models))

    list_models = [m[len(part_1):] for m in list_models if m[:len(part_1)] == part_1]
    list_models = [m[:-len(part_2)] for m in list_models if m[-len(part_2):] == part_2]
    list_models = [int(s) for s in list_models]

    if len(list_models)>0:

        n_iter = max(list_models)

        return get_file_name(
        dataset,
        sampling,
        n_iter,
        n_SGD,
        batch_size,
        lr_global,
        lr_local,
        n_sampled,
        mu,
        importances,
        decay,
        seed)
    else:
        return ""