# Shaping latent representations using Self-Organizing Maps with Relevance Learning

This repository is the official implementation of Shaping latent representations using Self-Organizing Maps with Relevance Learning

![DC-SOMRL Framework](images/autoencoder_som.png?raw=true)

Recent work indicates that Deep Clustering (DC) methods are a viable option for unsupervised representations learning of visual features. By combining representation learning and clustering, traditional approaches have been shown to build latent representations that capture essential features of the data while preserving topological characteristics. In this sense, models based on Self-Organizing Maps models with relevance learning (SOMRL) were considered as they perform well in clustering besides being able to create a map that learns the relevance of each input dimension for each cluster, preserving the original relations and topology of the data. We hypothesize that this type of model can produce a more intuitive and disentangled representation in the latent space by promoting smoother transitions between cluster points over time. This work proposes a representation learning framework that combines a new gradient-based SOMRL model and autoencoders. The SOMRL learns the relevance weights for each input dimension of each cluster. It creates a tendency to separate the information into subspaces. To achieve this, we designed a new loss function term that weighs these learned relevances and provides an estimated unsupervised error to be used in combination with a reconstruction loss. The model is evaluated in terms of clustering performance and quality of the learned representations and then compared with start-of-the-art models, showing competitive results.


## Requirements

    Python 3.6+
    CUDA 10.0+
    Pytorch 1.3.1+
    Pandas
    Scipy
    Scikit-Learn
    Munkres
    Matplotlib
    pyDOE2
    h5py
    Loss-Landscapes
    Weights and Biases (wandb)


### Setup of  Conda Environment (.yml file)

    conda env create -f environment.yml
    conda activate deepsom
    ## Now you can run the scripts

### Manually Setup of  Conda Environment

    conda create -n deepsom python=3.7 -y
    conda activate deepsom (or source activate deepsom)
    conda install pytorch torchvision cudatoolkit=10.2 -c pytorch -y
    conda install pandas -y
    conda install scipy -y
    conda install scikit-learn -y
    conda install -c omnia munkres -y
    conda install matplotlib -y
    conda install -c conda-forge pydoe2 -y
    conda install seaborn -y
    conda install jupyter -y
    conda install tqdm -y
    conda install h5py -y
    pip install --upgrade loss-landscapes
    pip install --upgrade wandb


## Training

To train the model(s) in the paper, run this command:

```train
python main.py --dataset mnist --eval --autoencoder --combined --params-file arguments/iclr22_mnist.lhs --out-folder results/iclr22_mnist --batch-size 256 --save --epochs 30 --cuda
```

## Results

Our model achieves the following performance on :

### Clustering Metrics on MNIST and Fashion-MNIST

| Dataset            |     Purity      |      NMI       |
| ------------------ |---------------- | -------------- |
| MNIST              |     0.884 +- 0.014     |   0.521 +- 0.007      |
| Fashion MNIST        |   0.679 +- 0.009     |   0.404 +- 0.005      |

<br></br>

| Method | MNIST Purity | MNIST NMI| Fashion-MNIST Purity | Fashion-MNIST NMI|
| ------------------ |---------------- | -------------- | -------------- | -------------- |
| k-means|0.791 +- 0.005|0.537 +- 0.001|0.703 +- 0.002|0.492 +- 0.001
|SOM-VAE|   0.868 +- 0.003     |   0.595 +- 0.002      |0.739 +- 0.002| 0.520 +- 0.002|
|DE-SOM|  0.939      | 0.657       | 0.752  |  0.538      |
| DCSOM-RL              |     0.884 +- 0.014     |   0.521 +- 0.007      |   0.679 +- 0.009     |   0.404 +- 0.005      |
