import argparse
import torch


def argument_parser():
    parser = argparse.ArgumentParser(description='Self Organizing Map')
    parser.add_argument('--cuda', action='store_true', help='enables cuda')
    parser.add_argument('--workers', type=int,  default=0, help='number of data loading workers')
    parser.add_argument('--ngpu', type=int, default=1, help='number of GPUs to use')

    parser.add_argument('--root', type=str, default='raw-datasets/', help='Dataset Root folder')
    parser.add_argument('--out-folder', type=str, default='results/', help='Folder to output results')
    parser.add_argument('--dataset', type=str, default='mnist', help='Dataset Name')
    parser.add_argument('--debug', action='store_true', help='Enables debug mode')
    parser.add_argument('--n-samples', type=int, default=100, help='Dataset Number of Samples')
    parser.add_argument('--load', action='store_true', help='Load Model')
    parser.add_argument('--model', type=str, default=None, help='Model Path')

    ## Eval Autoencoder Model n topk
    parser.add_argument('--topk', type=int, default=10, help='Topk Closest Samples of each prototype to visulize')

    ## Composition Flag (union or inter)
    parser.add_argument('--comp-flag', type=str, default='union', help='Cluster Composition (union/inter)')
    parser.add_argument('--cluster-list', nargs='+', default=[0,2], help='List of clusters to be used in composition')

    args = parser.parse_args()

    if torch.cuda.is_available() and not args.cuda:
        print("WARNING: You have a CUDA device, so you should probably run with --cuda")

    return args
