import argparse
import torch


def argument_parser():
    parser = argparse.ArgumentParser(description='Self Organizing Map')
    parser.add_argument('--cuda', action='store_true', help='enables cuda')
    parser.add_argument('--workers', type=int,  default=0, help='number of data loading workers')
    parser.add_argument('--ngpu', type=int, default=1, help='number of GPUs to use')
    parser.add_argument('--log-interval', type=int, default=32, help='Log Interval')
    parser.add_argument('--eval', action='store_true', help='enables evaluation')
    parser.add_argument('--landscape', action='store_true', help='enables evaluation loss landscape')
    parser.add_argument('--eval-interval', type=int, default=32, help='Evaluation Interval')
    parser.add_argument('--start-idx', help='Start Index', type=int, required=False, default=0)
    parser.add_argument('--stop-idx', help='Stop Index', type=int, required=False, default=-1)

    parser.add_argument('--save', action='store_true', help='Save Model')
    parser.add_argument('--load', action='store_true', help='Load Model')
    parser.add_argument('--model', type=str, default=None, help='Model Path')

    parser.add_argument('--tensorboard', action='store_true', help='Enables Tensorboard')
    parser.add_argument('--tensorboard-root', type=str, default='tensorboard/', help='Tensorboard Root folder')

    parser.add_argument('--wandb', action='store_true', help='Enables Weights and Biases')
    parser.add_argument('--wandb-project', type=str, default=None, help='wandb project name')

    parser.add_argument('--root', type=str, default='raw-datasets/', help='Dataset Root folder')
    parser.add_argument('--test-root', type=str, default=None, help='Dataset Test Root folder')
    parser.add_argument('--dataset', type=str, default='mnist', help='Dataset Name')
    parser.add_argument('--norm-type', type=str, default=None, help='Norm type')

    parser.add_argument('--out-folder', type=str, default='results/', help='Folder to output results')

    parser.add_argument('--train-paths', default=None, help='Train Paths')
    parser.add_argument('--test-paths', default=None, help='Test Paths')

    parser.add_argument('--lhs', action='store_true', help='enables lhs sampling before run')
    parser.add_argument('--lhs-samples', type=int, default=250, help='Number of Sets to be Sampled using LHS')
    parser.add_argument('--params-file', default=None, help='Parameters')

    parser.add_argument('--som-only', action='store_true', help='Som-Only Mode')
    parser.add_argument('--combined', action='store_true', help='Combined Mode')
    parser.add_argument('--autoencoder', action='store_true', help='Autoencoder Mode')

    parser.add_argument('--complement', action='store_true', help='Enable loss complement')
    parser.add_argument('--act-loss', action='store_true', help='Enable using Activations to compose the loss')
    parser.add_argument('--debug', action='store_true', help='Enables debug mode')
    parser.add_argument('--coil20-unprocessed', action='store_true', help='Loads COIL-20 Unprocessed')
    parser.add_argument('--n-samples', type=int, default=100, help='Dataset Number of Samples')
    parser.add_argument('--print', action='store_true', help='Print time')
    parser.add_argument('--extract', action='store_true', help='enables evaluation')

    parser.add_argument('--semi', action='store_true', help='Run Semi-Supervised (default: Unsupervised)')
    parser.add_argument('--labels-sampling', type=str, default='load', help='Label Sampling Type: fixed, perc or load')
    parser.add_argument('--balanced', action='store_true', help='Enables a Balanced Sampling of Labels')
    parser.add_argument('--n-labels', type=float, default=None, help='Fixed number or percentage of labeled samples')

    parser.add_argument('--batch-size', type=int, default=None, help='input batch size')
    parser.add_argument('--nmax', type=int, default=None, help='number of nodes')
    parser.add_argument('--alpha', type=float, default=None, help='Alpha Loss Component')
    parser.add_argument('--beta', type=float, default=None, help='Beta Loss Component')
    parser.add_argument('--lr-decay', type=float, default=None, help='SOM Learning decay')
    parser.add_argument('--lr-cnn', type=float, default=None, help='Learning Rate of CNN Model')
    parser.add_argument('--seed', type=int, default=None, help='Dataset Number of Samples')
    parser.add_argument('--epochs', type=int, default=None, help='Number of epochs to train the model')
    parser.add_argument('--som-in', type=int, default=None, help='Number of input dimensions of the SOM')

    args = parser.parse_args()

    if torch.cuda.is_available() and not args.cuda:
        print("WARNING: You have a CUDA device, so you should probably run with --cuda")

    return args
