#!/bin/bash

# Define the datapath and outputpath values

bz=$1

datapath_base="../experiments/wikitext-103/$bz"
# outputpath_base="../experiments/wikitext-103-res-byte/$bz"
outputpath_base="../experiments/wikitext-103-res-subword/$bz"
num_paths=5

datapaths=()
outputpaths=()

for i in $(seq 1 $num_paths); do
    datapath="$datapath_base/$i"
    outputpath="$outputpath_base/$i"
    datapaths+=("$datapath")
    outputpaths+=("$outputpath")
done

# Loop through each datapath and outputpath value
for i in "${!datapaths[@]}"; do
    datapath="${datapaths[$i]}"
    outputpath="${outputpaths[$i]}"
    
    
    # Run the cargo command with the current datapath and outputpath values
    echo "this is the $i th bathc of batch size $bz"
    cargo run --release -- --datapath "$datapath" --outputpath "$outputpath" --num-beamgroups 8
done


# datapath_base="../experiments/wikitext-103/$bz"
# outputpath_base="../experiments/wikitext-103-res/$bz"
# num_paths=20

# datapaths=()
# outputpaths=()

# for i in $(seq 1 $num_paths); do
#     datapath="$datapath_base/datapath$i"
#     outputpath="$outputpath_base/outputpath$i"
#     datapaths+=("$datapath")
#     outputpaths+=("$outputpath")
# done