# x = [1, 4, 16, 32, 64, 128]

# byte_r1 = [0.348, 0.351, 0.436, 0.365, 0.337, 0.351]
# byte_r2 = [0.086, 0.107, 0.166, 0.183, 0.127, 0.162]
# byte_rl = [0.288, 0.270, 0.364, 0.305, 0.292,  0.305]

# sub_r1 = [0.932, 0.743, 0.451, 0.329, 0.396, 0.410]
# sub_r2 = [0.618, 0.349, 0.189, 0.151, 0.162, 0.172]
# sub_rl = [0.798, 0.562, 0.355, 0.329, 0.321, 0.323]



# import matplotlib.pyplot as plt

# x = [1, 2, 4, 8]
# label_font = 24
# legend_font = 20

# byte_r1 = [0.348, 0.351, 0.436, 0.365]
# byte_r2 = [0.086, 0.107, 0.166, 0.183]
# byte_rl = [0.288, 0.270, 0.364, 0.305]

# sub_r1 = [0.932, 0.743, 0.451, 0.329]
# sub_r2 = [0.618, 0.349, 0.189, 0.151]
# sub_rl = [0.798, 0.562, 0.355, 0.329]

# fig, axs = plt.subplots(1, 3, figsize=(15, 5))


# for ax in axs:
#     ax.set_xticks(x)

# for ax in axs:
#     ax.spines['top'].set_visible(False)
#     ax.spines['right'].set_visible(False)
#     ax.tick_params(axis='both', length=0)
    
# axs[0].plot(x, byte_r1, label='byte_r1')
# axs[0].plot(x, sub_r1, label='sub_r1')
# axs[0].set_xlabel('Batch Size', fontsize=label_font)
# axs[0].set_ylabel('ROUGE-1', fontsize=label_font)
# axs[0].set_ylim([0, 1])

# axs[1].plot(x, byte_r2, label='byte_r2')
# axs[1].plot(x, sub_r2, label='sub_r2')
# axs[1].set_xlabel('Batch Size', fontsize=label_font)
# axs[1].set_ylabel('ROUGE-2', fontsize=label_font)
# axs[1].set_ylim([0, 1])

# axs[2].plot(x, byte_rl, label='byte_rl')
# axs[2].plot(x, sub_rl, label='sub_rl')
# axs[2].set_xlabel('Batch Size', fontsize=label_font)
# axs[2].set_ylabel('ROUGE-L', fontsize=label_font)
# axs[2].set_ylim([0, 1])

# fig.legend(loc='upper right', bbox_to_anchor=(1.1, 1), fontsize=legend_font)

# plt.show()

import matplotlib.pyplot as plt

x = [1, 2, 4, 8]
label_font = 20
legend_font = 16
tick_font = 20

byte_r1 = [0.230, 0.181, 0.289, 0.300]
byte_r2 = [0.000, 0.107, 0.052, 0.190]
byte_rl = [0.230, 0.181, 0.238, 0.300]

sub_r1 = [1.000, 0.743, 0.621, 0.435]
sub_r2 = [0.615, 0.228, 0.214, 0.348]
sub_rl = [0.846, 0.560, 0.621, 0.364]

fig, axs = plt.subplots(1, 3, figsize=(16, 3))

# fig.subplots_adjust(hspace=3)


for ax in axs:
    ax.set_xticks(x)

for ax in axs:
    ax.spines['top'].set_visible(False)
    ax.spines['right'].set_visible(False)
    ax.tick_params(axis='both', length=2)
    ax.tick_params(axis='x', labelsize=tick_font)
    ax.tick_params(axis='y', labelsize=tick_font)

axs[0].plot(x, byte_r1)
axs[0].plot(x, sub_r1)
axs[0].set_xlabel('Batch Size', fontsize=label_font)
axs[0].set_ylabel('ROUGE-1', fontsize=label_font)
axs[0].set_ylim([0, 1])

axs[1].plot(x, byte_r2)
axs[1].plot(x, sub_r2)
axs[1].set_xlabel('Batch Size', fontsize=label_font)
axs[1].set_ylabel('ROUGE-2', fontsize=label_font)
axs[1].set_ylim([0, 1])

axs[2].plot(x, byte_rl, label='BSE (Ours)')
axs[2].plot(x, sub_rl, label='FILM')
axs[2].set_xlabel('Batch Size', fontsize=label_font)
axs[2].set_ylabel('ROUGE-L', fontsize=label_font)
axs[2].set_ylim([0, 1])

fig.legend(loc='lower center', ncol = 2, bbox_to_anchor=(0.5, -0.13), fontsize=legend_font)
fig.tight_layout(pad=1.0)
# fig.subplots_adjust(bottom=0.5)
# plt.show()s
plt.savefig('rouge_socre.pdf', bbox_inches="tight")