# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

import sys
import pickle
import os

from .racetrack import RaceTrack

# ====== Racetracks ======

Belgium = RaceTrack(
	name='Belgium',
	xy = [[117.91060180664063,280.5566802978516],[117.55629272460938,280.8065093994141],[117.20198364257813,281.05633850097655],[116.84766082763672,281.30616760253906],[116.49335174560547,281.5560241699219],[116.13872680664063,281.8054138183594],[115.78410186767579,282.0547760009766],[115.42947692871094,282.3041656494141],[115.07484512329101,282.5535552978516],[114.71991806030273,282.80250549316406],[114.3649772644043,283.05145568847655],[114.01003646850586,283.3003784179688],[113.65509567260743,283.54932861328126],[113.29985961914063,283.79783935546874],[112.94460983276367,284.0463500976563],[112.58936004638672,284.2948333740234],[112.23411026000977,284.54334411621096],[111.8785789489746,284.79144287109375],[111.52302703857423,285.0395141601563],[111.16747512817383,285.2875579833985],[110.81193008422852,285.53562927246094],[110.45609664916992,285.7833160400391],[110.1002426147461,286.0309204101563],[109.74438171386718,286.27855224609374],[109.38852767944336,286.52618408203125],[109.03240585327148,286.7734313964844],[108.6762565612793,287.0206237792969],[108.32010040283204,287.2678436279297],[107.96395111083984,287.5150360107422],[107.60754089355468,287.7618713378906],[107.25109634399415,288.00865173339844],[106.8946517944336,288.25543212890625],[106.53820724487305,288.50221252441406],[106.18139877319337,288.74847106933595],[105.8245216369629,288.9946197509766],[105.4676513671875,289.2407958984375],[105.11077423095703,289.48694458007816],[104.75389709472657,289.73309326171875],[104.39702682495117,289.9792694091797],[104.0401496887207,290.2254180908203],[103.68327255249024,290.47156677246096],[103.32604522705078,290.71722106933595],[102.96874237060547,290.9627655029297],[102.61143951416015,291.20830993652345],[102.25413665771485,291.4538269042969],[101.89661407470703,291.6990417480469],[101.53903656005859,291.944174194336],[101.18145904541016,292.18930664062503],[100.82388153076172,292.43446655273436],[100.4659812927246,292.67913208007815],[100.1079917907715,292.9236602783203],[99.75000228881837,293.16818847656253],[99.39201278686524,293.4127166748047],[99.03401641845703,293.65724487304686],[98.67602691650391,293.9017730712891],[98.31803741455079,294.14630126953125],[97.96004791259766,294.39085693359374],[97.60166015625,294.6348083496094],[97.24313507080079,294.8785400390625],[96.88460998535156,295.12229919433594],[96.52608489990234,295.36603088378905],[96.16755981445313,295.6097900390625],[95.80903472900391,295.8535491943359],[95.4505096435547,296.0972808837891],[95.09198455810547,296.34104003906253],[94.73309555053712,296.5842498779297],[94.37404861450196,296.82721252441405],[94.0150016784668,297.07020263671876],[93.65595474243165,297.3131927490235],[93.29690780639649,297.5561553955078],[92.93786087036133,297.7991455078125],[92.57881393432618,298.0421356201172],[92.2197738647461,298.28509826660155],[91.8603904724121,298.52759399414066],[91.50084228515625,298.7698150634766],[91.14128723144532,299.01206359863284],[90.78174591064453,299.25428466796876],[90.4221908569336,299.496533203125],[90.06264266967774,299.73875427246094],[89.70309448242188,299.9810028076172],[89.34354629516602,300.22325134277344],[88.98368225097657,300.4650054931641],[88.62363967895509,300.7065124511719],[88.2635971069336,300.9479919433594],[87.90355453491212,301.1894989013672],[87.54351196289063,301.43100585937503],[87.18346252441407,301.6725128173828],[86.82341995239258,301.91399230957035],[86.4633773803711,302.15549926757814],[86.10304641723633,302.396566772461],[85.74252319335938,302.6373596191406],[85.38199996948242,302.87815246582034],[85.02148361206055,303.1189178466797],[84.6609603881836,303.3597106933594],[84.30043716430664,303.6005035400391],[83.93991394042969,303.8412689208985],[83.57939071655274,304.0820617675781],[83.21861343383789,304.3224700927735],[82.85762329101563,304.562548828125],[82.49664001464843,304.80262756347656],[82.13564987182617,305.04273376464846],[81.77466659545898,305.28281250000003],[81.41367645263672,305.52289123535155],[81.05269317626953,305.7629699707031],[80.69170303344727,306.003076171875],[80.33047943115234,306.2427978515625],[79.96904296875,306.4822174072266],[79.60760650634766,306.7216369628906],[79.2461769104004,306.9610290527344],[78.88474044799806,307.20044860839846],[78.5233039855957,307.4398681640625],[78.16186752319337,307.6792877197266],[77.8004379272461,307.91867980957034],[77.43878860473633,308.15776977539065],[77.07691268920898,308.3965301513672],[76.71503677368165,308.63526306152346],[76.3531608581543,308.8740234375],[75.99129180908203,309.1127563476563],[75.6294158935547,309.3515167236328],[75.26753997802734,309.5902770996094],[74.90566406250001,309.8290100097656],[74.54360275268554,310.0674682617188],[74.18130798339844,310.3055694580078],[73.81901321411134,310.5436981201172],[73.45671844482422,310.78179931640625],[73.09441680908203,311.0199005126953],[72.73212203979493,311.2580017089844],[72.36982727050781,311.4961303710938],[72.00753250122071,311.73423156738284],[71.64506607055664,311.9720855712891],[71.28235931396485,312.209555053711],[70.91964569091797,312.4470245361328],[70.55693893432617,312.6844940185547],[70.19423217773438,312.9219909667969],[69.83152542114259,313.1594604492188],[69.4688117980957,313.3969299316406],[69.10610504150391,313.6344268798828],[68.7432472229004,313.8716766357422],[68.38014907836914,314.1085418701172],[68.01704406738281,314.34543457031253],[67.65393905639648,314.5822998046875],[67.29084091186523,314.8191650390625],[66.92772903442383,315.0560577392578],[66.56463088989258,315.2929229736328],[66.20152587890625,315.5297882080078],[65.8383041381836,315.76648864746096],[65.4748146057129,316.0027770996094],[65.11133193969727,316.2390380859375],[64.74784240722657,316.47532653808594],[64.38435974121094,316.7116149902344],[64.02087020874023,316.9479034423828],[63.65738067626953,317.18419189453124],[63.293898010253905,317.4204803466797],[62.93029861450196,317.65660400390624],[62.566445159912114,317.89231567382814],[62.20259170532227,318.12802734375003],[61.838738250732426,318.3637390136719],[61.47487106323242,318.5994506835938],[61.11101760864258,318.8351623535156],[60.74716415405273,319.0708740234375],[60.383303833007815,319.3066131591797],[60.019354248046874,319.5421875],[59.65514373779297,319.77732238769534],[59.29092636108398,320.0124847412109],[58.926708984375004,320.2476470947266],[58.56249847412109,320.4828094482422],[58.198281097412114,320.7179718017578],[57.8340705871582,320.95313415527346],[57.46984977722168,321.18829650878905],[57.105560302734375,321.42334899902346],[56.74100303649902,321.6579620361328],[56.3764389038086,321.8926025390625],[56.01188163757325,322.1272430419922],[55.647324371337895,322.3618560791016],[55.28276710510254,322.59649658203125],[54.91820297241211,322.83110961914065],[54.55364570617676,323.0657501220703],[54.18902664184571,323.30028076171874],[53.82413291931152,323.53439941406253],[53.45924263000489,323.76849060058595],[53.094352340698244,324.0026092529297],[52.7294620513916,324.23670043945316],[52.36456489562988,324.4708190917969],[51.99967460632325,324.70493774414064],[51.6347843170166,324.9390563964844],[51.269845962524414,325.1730926513672],[50.90463981628418,325.40671691894534],[50.53943367004395,325.64031372070315],[50.174227523803715,325.8739379882813],[49.80901794433594,326.10756225585936],[49.4438117980957,326.3411865234375],[49.07860565185547,326.5747833251953],[48.713399505615236,326.80840759277345],[48.34815216064453,327.04197692871094],[47.98264045715332,327.2751068115235],[47.617125320434575,327.50823669433595],[47.251606750488286,327.74139404296875],[46.88609504699707,327.9745239257813],[46.52057991027832,328.20765380859376],[46.155068206787114,328.44078369140624],[45.789546203613284,328.6739410400391],[45.4240104675293,328.90704345703125],[45.058206939697264,329.13970642089845],[44.69239311218262,329.372396850586],[44.326586151123045,329.6050598144531],[43.96077919006348,329.8377227783203],[43.59497222900391,330.07041320800784],[43.22915840148926,330.30307617187503],[42.86335144042969,330.5357666015625],[42.4975341796875,330.7684295654297],[42.13144569396973,331.0006530761719],[41.765350341796875,331.2328765869141],[41.3992618560791,331.4651275634766],[41.03317337036133,331.6973510742188],[40.66707801818848,331.92957458496096],[40.3009895324707,332.1618255615235],[39.934901046752934,332.39404907226566],[39.56881256103516,332.62627258300785],[39.2024528503418,332.85808410644535],[38.83609657287598,333.08989562988285],[38.469740295410155,333.32170715332035],[38.103380584716795,333.55351867675785],[37.73702430725098,333.78533020019535],[37.37066802978516,334.01714172363285],[37.00431175231934,334.24895324707035],[36.63794860839844,334.48076477050785],[36.271348571777345,334.7121917724609],[35.90473823547364,334.94359130859374],[35.53812446594238,335.17499084472655],[35.17150726318359,335.40639038085936],[34.804896926879884,335.6377899169922],[34.438286590576176,335.869189453125],[34.07166938781739,336.1006164550781],[33.70505561828613,336.33201599121094],[33.338222122192384,336.5630584716797],[32.97136459350586,336.79407348632816],[32.6045036315918,337.0251159667969],[32.237649536132814,337.2561309814453],[31.870795440673827,337.4871459960938],[31.503934478759767,337.7181610107422],[31.137076950073244,337.9491760253906],[30.770222854614257,338.18019104003906],[30.40316619873047,338.41090393066406],[30.03607521057129,338.64153442382815],[29.66898765563965,338.8721923828125],[29.301900100708007,339.1028503417969],[28.934815979003908,339.33350830078126],[28.567723274230957,339.56413879394535],[28.200637435913087,339.7947967529297],[27.833549880981447,340.02545471191405],[27.466273498535156,340.255810546875],[27.098967933654787,340.4861114501953],[26.731662368774415,340.71641235351564],[26.364356803894044,340.94671325683595],[25.997046089172365,341.17701416015626],[25.629740524291993,341.4073150634766],[25.26243495941162,341.6376159667969],[24.895124244689942,341.8679168701172],[24.52851734161377,342.09934387207034],[24.16376781463623,342.3336547851563],[23.80100955963135,342.5710418701172],[23.439887237548827,342.8109558105469],[23.08026695251465,343.0530670166016],[22.722019958496094,343.2972106933594],[22.36488189697266,343.54297485351566],[22.00858840942383,343.7900024414063],[21.652966117858888,344.0379638671875],[21.29785194396973,344.28663940429686],[20.943101692199708,344.53586425781253],[20.58834972381592,344.7850616455078],[20.23329906463623,345.0338470458984],[19.878219223022462,345.28260498046876],[19.52266902923584,345.53064880371096],[19.166318893432617,345.77756652832034],[18.809124183654784,346.02324829101565],[18.45073127746582,346.267172241211],[18.091016578674317,346.50917358398436],[17.72981357574463,346.7489501953125],[17.366923141479493,346.98614501953125],[17.002067184448244,347.22031860351564],[16.63524227142334,347.4513610839844],[16.266199493408205,347.6788604736328],[15.894648742675782,347.90223999023436],[15.520634651184082,348.1214996337891],[15.143994140625,348.33619995117186],[14.764334106445313,348.5454895019531],[14.38192663192749,348.7497253417969],[13.996366596221923,348.9479461669922],[13.607665157318115,349.1399322509766],[13.215797424316406,349.3253540039063],[12.82059087753296,349.5035797119141],[12.422146797180176,349.67444458007816],[12.020416259765625,349.8373992919922],[11.615411281585693,349.9920318603516],[11.207240867614747,350.13812255859375],[10.795887851715088,350.274984741211],[10.382595920562744,350.4059143066406],[9.968851661682129,350.53538818359374],[9.553783893585205,350.6605499267578],[9.136623573303224,350.77857055664066],[8.716703796386719,350.88629150390625],[8.293519878387452,350.98033447265624],[7.866858959197998,351.0569641113281],[7.436903858184815,351.11211547851565],[7.004381132125855,351.1403778076172],[6.570989370346069,351.1361755371094],[6.139758825302124,351.09319152832035],[5.715515756607056,351.0050811767578],[5.304866123199463,350.8670104980469],[4.915656995773316,350.67680969238285],[4.556090354919434,350.43519287109376],[4.229881811141968,350.15004272460936],[3.9378737926483156,349.8298736572266],[3.6790380477905273,349.4822937011719],[3.4523300170898437,349.1129058837891],[3.256286287307739,348.72637939453125],[3.089749002456665,348.32622985839845],[2.952321410179138,347.91514892578124],[2.8440745353698733,347.495443725586],[2.765798234939575,347.06914672851565],[2.719184231758118,346.63823547363285],[2.7008634567260743,346.205126953125],[2.7066325664520265,345.77171630859374],[2.7343799114227294,345.3391021728516],[2.7820996284484862,344.9082458496094],[2.847894859313965,344.4797790527344],[2.9300140142440796,344.0541137695313],[3.0268417596817017,343.6315521240235],[3.1369342088699343,343.2122314453125],[3.2589811563491824,342.7962615966797],[3.3918007135391237,342.3835876464844],[3.5343586206436157,341.97418212890625],[3.685721254348755,341.56793518066405],[3.845219135284424,341.1648193359375],[4.011717796325684,340.7645599365234],[4.184707832336426,340.3670196533203],[4.363532209396363,339.9720886230469],[4.547598695755005,339.57957458496094],[4.736325359344483,339.1892852783203],[4.929194211959839,338.80100097656253],[5.1256615161895756,338.41455688476566],[5.325271511077881,338.0297058105469],[5.527303218841553,337.6461181640625],[5.731248092651367,337.2635467529297],[5.93648042678833,336.8816619873047],[6.142242336273194,336.5000793457031],[6.3476725101470945,336.11830444335936],[6.5517877578735355,335.7358428955078],[6.752992057800293,335.35181579589846],[6.9491945743560795,334.9652069091797],[7.137055206298828,334.5745056152344],[7.319017124176026,334.1810028076172],[7.500978183746338,333.7875],[7.682939243316651,333.39402465820314],[7.864901161193848,333.0005218505859],[8.046084594726564,332.6066619873047],[8.226974487304688,332.2126373291016],[8.407859230041504,331.8186401367188],[8.588743972778321,331.424642944336],[8.769190979003907,331.03045349121095],[8.94909725189209,330.6360168457031],[9.129002666473388,330.24155273437503],[9.308908081054687,329.8471160888672],[9.488631534576417,329.4525970458985],[9.667674350738526,329.05774841308596],[9.846717166900635,328.6629272460938],[10.025759983062745,328.26807861328126],[10.204792499542236,327.87322998046875],[10.383084297180176,327.4780517578125],[10.561376094818115,327.08287353515624],[10.739673900604249,326.6876953125],[10.917965698242188,326.2925170898438],[11.09571418762207,325.8970916748047],[11.273370838165283,325.50163879394535],[11.451027488708496,325.10618591308594],[11.628684139251709,324.71070556640626],[11.805832672119141,324.3150329589844],[11.982788944244385,323.91925048828125],[12.159751224517823,323.5234680175781],[12.336707496643067,323.127685546875],[12.51366376876831,322.7319030761719],[12.690620040893554,322.3361480712891],[12.867577171325683,321.94036560058595],[13.044533443450929,321.5445831298828],[13.221211624145509,321.14869079589846],[13.397683811187745,320.7526885986328],[13.574149990081787,320.3566864013672],[13.750617027282715,319.96071166992186],[13.927083206176759,319.56470947265626],[14.103549385070801,319.16870727539066],[14.280015563964843,318.772705078125],[14.456481742858887,318.3767303466797],[14.632954788208009,317.98072814941406],[14.809420967102051,317.58472595214846],[14.985887145996093,317.1887237548828],[15.162353324890137,316.7927215576172],[15.33881950378418,316.39674682617186],[15.515285682678224,316.00074462890626],[15.691751861572266,315.60474243164066],[15.868224906921387,315.208740234375],[16.04502239227295,314.8129028320313],[16.222094535827637,314.41717529296875],[16.399166679382326,314.0214477539063],[16.57624053955078,313.62572021484374],[16.75331268310547,313.22999267578126],[16.930384826660156,312.8342651367188],[17.107463836669922,312.43853759765625],[17.28453598022461,312.0428100585938],[17.462131690979003,311.6473297119141],[17.640000343322754,311.25195922851566],[17.817867279052734,310.8565887451172],[17.995735931396485,310.46124572753905],[18.174148750305175,310.06609497070315],[18.35274181365967,309.6710540771484],[18.53134002685547,309.27601318359376],[18.709934806823732,308.8809722900391],[18.889255714416503,308.48626098632815],[19.06871395111084,308.09160461425785],[19.248173904418945,307.6969482421875],[19.427632141113282,307.3023193359375],[19.60804138183594,306.9081024169922],[19.78851070404053,306.5139129638672],[19.96897659301758,306.1197235107422],[20.14951457977295,305.72556152343753],[20.331134033203124,305.33192138671876],[20.5127534866333,304.9382537841797],[20.694372940063477,304.5445861816406],[20.876172637939455,304.1510284423828],[21.05875339508057,303.75780029296874],[21.241498947143555,303.3646545410156],[21.424750900268556,302.9717559814453],[21.608231163024904,302.57896728515624],[21.792202377319338,302.1863983154297],[21.976455116271975,301.7939666748047],[22.161164474487304,301.4017547607422],[22.34623603820801,301.0096801757813],[22.53172817230225,300.6178253173828],[22.71764259338379,300.2261901855469],[22.903956985473634,299.8347473144531],[23.09077262878418,299.4435241699219],[23.277940177917483,299.05246582031253],[23.465675926208498,298.66168212890625],[23.653720664978028,298.2710357666016],[23.842410850524903,297.88074645996096],[24.031360244750978,297.49053955078125],[24.221059799194336,297.10071716308596],[24.41096019744873,296.7109771728516],[24.60168800354004,296.3216491699219],[24.792563438415527,295.9324035644531],[24.984360694885254,295.5435699462891],[25.17623691558838,295.1548187255859],[25.36912422180176,294.7665618896485],[25.56207504272461,294.3783325195313],[25.756050682067873,293.990625],[25.950122451782228,293.6029449462891],[26.14519500732422,293.2157867431641],[26.340434074401855,292.8286834716797],[26.536625862121582,292.44207458496095],[26.733042526245118,292.05560302734375],[26.93038444519043,291.66957092285156],[27.128013038635256,291.2837310791016],[27.32651710510254,290.89830322265624],[27.525383377075197,290.51306762695316],[27.725090789794923,290.1282440185547],[27.925217056274416,289.74366760253906],[28.126153564453126,289.35950317382816],[28.327563858032228,288.9756134033203],[28.529743194580078,288.5921081542969],[28.73244438171387,288.20887756347656],[28.935890579223635,287.82605895996096],[29.1399169921875,287.4435150146484],[29.34466438293457,287.0613555908203],[29.550022888183594,286.67955322265624],[29.756074905395508,286.29810791015626],[29.962782669067384,285.91704711914065],[30.170170211791994,285.5363433837891],[30.378244400024414,285.1559967041016],[30.586984634399414,284.7760345458984],[30.796222686767578,284.3963195800781],[31.00591049194336,284.01685180664066],[31.215914154052737,283.6375762939453],[31.426189041137697,283.2584655761719],[31.63686218261719,282.8795471191406],[31.847820281982422,282.50079345703125],[32.05923500061035,282.122314453125],[32.270969009399415,281.74400024414064],[32.48324203491211,281.3659881591797],[32.695844650268555,280.98814086914064],[32.90907211303711,280.610678100586],[33.122636032104495,280.23338012695314],[33.336903762817386,279.8565216064453],[33.5515251159668,279.4798278808594],[33.766946411132814,279.1036010742188],[33.98272132873535,278.7275665283203],[34.19937171936035,278.3520538330078],[34.41637916564942,277.9767333984375],[34.63436851501465,277.6020172119141],[34.852721786499025,277.2274658203125],[35.072156524658205,276.85357360839845],[35.29193115234375,276.47987365722656],[35.51289367675781,276.1068603515625],[35.734178924560545,275.7340393066406],[35.95642547607422,275.36182250976566],[36.179585266113286,274.99012756347656],[36.403603363037114,274.61895446777345],[36.62848663330078,274.2483306884766],[36.85427970886231,273.87822875976565],[37.08099632263184,273.50867614746096],[37.308650207519534,273.1397277832031],[37.53725509643555,272.7713562011719],[37.76685562133789,272.40361633300785],[37.99748611450195,272.03650817871096],[38.229143142700195,271.67005920410156],[38.461861038208006,271.30429687500003],[38.69565696716309,270.93919372558594],[38.930554962158205,270.57480468750003],[39.166572189331056,270.2111297607422],[39.40374984741211,269.84825134277344],[39.64208450317383,269.4860870361328],[39.88162422180176,269.1247467041016],[40.1223690032959,268.7642028808594],[40.3643497467041,268.40448303222655],[40.60759735107422,268.0456146240235],[40.852101516723636,267.68759765625003],[41.097903442382815,267.3304870605469],[41.34502029418945,266.9742828369141],[41.59346923828125,266.6190124511719],[41.84328117370605,266.2646759033203],[42.0944766998291,265.911328125],[42.34706954956055,265.55896911621096],[42.60106315612793,265.20762634277344],[42.85650215148926,264.8573272705078],[43.113383102417,264.5081268310547],[43.37176780700684,264.15997009277345],[43.631601333618164,263.812939453125],[43.89299011230469,263.4670349121094],[44.155875778198244,263.1223114013672],[44.42032012939453,262.7787689208985],[44.6863094329834,262.4364349365234],[44.95388488769532,262.0953094482422],[45.223070526123045,261.7554473876953],[45.493783950805664,261.41684875488284],[45.76611442565918,261.0795135498047],[46.04002075195313,260.7434967041016],[46.31550979614258,260.4087158203125],[46.59234123229981,260.0751159667969],[46.87084121704102,259.74280700683596],[47.15065956115723,259.4116516113281],[47.43182373046875,259.0817047119141],[47.714477920532225,258.7529663085938],[47.99836120605469,258.42529907226566],[48.28364181518555,258.0988677978516],[48.57017555236816,257.77353515625003],[48.85791435241699,257.4492462158203],[49.146971511840825,257.12611083984376],[49.43711700439453,256.8039916992188],[49.728495025634764,256.48297119140625],[50.020988845825194,256.1629669189453],[50.31454010009766,255.84392395019532],[50.609409713745116,255.5261444091797],[50.90514793395996,255.20913391113282],[51.201737594604495,254.89289245605468],[51.49954948425293,254.5778594970703],[51.798319244384764,254.26370544433595],[52.09782371520996,253.95026550292968],[52.398340988159184,253.63778686523438],[52.69988136291504,253.32629699707033],[53.002108383178715,253.01546630859374],[53.30511474609375,252.70540466308594],[53.609161376953125,252.3963592529297],[53.91385688781738,252.08794555664062],[54.219129180908205,251.78013610839844],[54.52544174194336,251.47331542968752],[54.8323413848877,251.16709899902344],[55.139780044555664,250.86143188476564],[55.448018646240236,250.55653381347656],[55.75685806274414,250.25232238769533],[56.06620559692383,249.94857788085938],[56.37615394592285,249.64546508789064],[56.68677177429199,249.34301147460937],[56.9977912902832,249.0409698486328],[57.3092845916748,248.7394226074219],[57.62139587402344,248.43856201171874],[57.93388824462891,248.13803100585938],[58.246717071533205,247.83788452148437],[58.56007461547852,247.53831481933594],[58.87379608154297,247.23904724121095],[59.18781280517578,246.9401641845703],[59.502454376220705,246.64188537597656],[59.81706848144531,246.34363403320313],[60.13188858032227,246.0455749511719],[60.44729919433594,245.7481201171875],[60.762689208984376,245.45069274902343],[61.07832641601563,245.15345764160156],[61.394293212890624,244.85663452148438],[61.71028060913086,244.55978393554688],[62.02642593383789,244.26315307617188],[62.34280471801758,243.96674194335938],[62.65919036865235,243.6703308105469],[62.97567901611328,243.37402954101563],[63.29227066040039,243.07783813476564],[63.60884170532227,242.78164672851562],[63.92543334960938,242.48545532226564],[64.24201126098633,242.18929138183594],[64.55860290527345,241.89307250976563],[64.87504348754884,241.59674377441408],[65.19143600463867,241.3003875732422],[65.50784912109376,241.00397644042968],[65.82391204833985,240.70726318359377],[66.13996124267578,240.4104949951172],[66.45599670410157,240.11372680664064],[66.77147598266602,239.8163269042969],[67.08695526123047,239.51895446777345],[67.40231781005859,239.22152709960938],[67.71704177856445,238.92333068847657],[68.03174514770508,238.62516174316406],[68.34631805419922,238.3268280029297],[68.66032791137695,238.02794494628907],[68.97397384643556,237.72859497070314],[69.28729705810547,237.42894287109377],[69.60021514892578,237.12890625],[69.91261138916016,236.8282653808594],[70.22459564208985,236.527294921875],[70.53623657226562,236.22588500976562],[70.8471290588379,235.92376098632812],[71.1576301574707,235.6211700439453],[71.46769180297852,235.3181396484375],[71.77698440551758,235.01436767578124],[72.08570709228516,234.70999145507812],[72.39392852783203,234.40512084960938],[72.70144271850586,234.0995086669922],[73.00816040039062,233.79315490722658],[73.31434936523438,233.4862243652344],[73.61984481811524,233.17857971191407],[73.92472915649414,232.8703857421875],[74.22955169677735,232.56208190917968],[74.5343605041504,232.2538055419922],[74.8391830444336,231.94550170898438],[75.14398498535157,231.6372253417969],[75.44880752563476,231.32894897460938],[75.75363006591797,231.02064514160156],[76.05843887329102,230.71236877441407],[76.36326141357422,230.40406494140626],[76.66806335449219,230.09578857421874],[76.97288589477539,229.7874984741211],[77.27769470214844,229.4792221069336],[77.58251724243165,229.1709182739258],[77.88733978271485,228.86262817382814],[78.19214172363282,228.55435180664062],[78.49696426391601,228.2460479736328],[78.80177307128906,227.93777160644532],[79.10659561157227,227.62948150634767],[79.41139755249024,227.32120513916016],[79.71622009277344,227.0129150390625],[80.02104949951172,226.7046112060547],[80.32560424804687,226.39610137939454],[80.6301658630371,226.08755035400392],[80.93470687866211,225.77901306152344],[81.23926162719727,225.47044830322267],[81.54380264282227,225.1619110107422],[81.8483642578125,224.85335998535157],[82.15291900634766,224.5447952270508],[82.45746002197266,224.23625793457032],[82.7620216369629,223.9277069091797],[83.06656265258789,223.61916961669922],[83.3710075378418,223.3105224609375],[83.67530822753906,223.0017517089844],[83.97962951660156,222.69295349121094],[84.28393020629883,222.38418273925782],[84.58825149536133,222.07538452148438],[84.89257278442383,221.7666000366211],[85.19687347412109,221.45782928466798],[85.50119476318359,221.14903106689454],[85.80549545288086,220.84026031494142],[86.10981674194336,220.53146209716797],[86.41411743164063,220.22269134521486],[86.71818466186524,219.91363220214845],[87.02221755981445,219.60455932617188],[87.32622985839843,219.29550018310547],[87.63026962280274,218.9864273071289],[87.93428192138673,218.6773681640625],[88.23831481933594,218.36829528808593],[88.542333984375,218.0592498779297],[88.84636688232422,217.75017700195312],[89.15039978027345,217.44109039306642],[89.4544189453125,217.13204498291017],[89.75830764770508,216.82282104492188],[90.06199035644532,216.51343231201173],[90.36569366455079,216.20404357910158],[90.66937637329102,215.8946548461914],[90.97307968139648,215.5852523803711],[91.27678298950195,215.27584991455078],[91.5804656982422,214.9664749145508],[91.88416900634766,214.65707244873047],[92.18785171508789,214.3476974487305],[92.49155502319336,214.03829498291017],[92.7952377319336,213.72890625],[93.09857711791993,213.41916046142578],[93.40189590454102,213.10938720703126],[93.70520095825195,212.79962768554688],[94.00852661132812,212.48985443115234],[94.31182479858398,212.18010864257812],[94.61515045166016,211.8703353881836],[94.9184555053711,211.56057586669922],[95.22177429199219,211.25080261230468],[95.52509994506836,210.94102935791017],[95.8284049987793,210.63128356933595],[96.13152465820313,210.32130432128906],[96.43440399169923,210.01114654541016],[96.73729705810547,209.7009475708008],[97.04017639160156,209.39077606201172],[97.34306945800782,209.0805908203125],[97.64596252441406,208.77039184570313],[97.94884185791015,208.46023406982422],[98.25173492431641,208.15003509521486],[98.5546142578125,207.8398635864258],[98.85750732421876,207.52967834472656],[99.16038665771485,207.2195068359375],[99.46366424560547,206.9096923828125],[99.76808853149414,206.60099029541016],[100.07354278564453,206.293359375],[100.38000640869141,205.9866897583008],[100.6873764038086,205.6809814453125],[100.99564590454102,205.37613830566406],[101.30469131469727,205.07210540771484],[101.61469116210938,204.7690200805664],[101.92500686645508,204.46625061035158],[102.23623580932617,204.16445617675782],[102.54765701293945,203.8628402709961],[102.8599365234375,203.5621307373047],[103.17235336303712,203.26155853271484],[103.48530578613281,202.9615493774414],[103.79850540161134,202.66174621582033],[104.11207580566406,202.36235504150392],[104.42562561035156,202.06297760009767],[104.7391960144043,201.76358642578126],[105.05282135009766,201.46429138183595],[105.36650161743164,201.16499633789064],[105.68016128540039,200.8657424926758],[105.99382095336914,200.56643371582032],[106.30706176757813,200.26669921875],[106.62015838623047,199.96685485839845],[106.93283615112306,199.66652984619142],[107.24518432617188,199.3659164428711],[107.55708618164063,199.06478118896484],[107.86842498779298,198.7630828857422],[108.17933807373048,198.46091766357424],[108.4895851135254,198.15814819335938],[108.79909057617188,197.85455474853515],[109.10784759521485,197.55017852783203],[109.41569137573242,197.2449508666992],[109.72263565063477,196.93877563476562],[110.02860488891602,196.6316665649414],[110.33356475830078,196.32351379394532],[110.63741912841797,196.01427612304687],[110.94011306762695,195.70391235351562],[111.24157791137695,195.39232635498047],[111.54173126220704,195.07950439453126],[111.84052505493165,194.7653778076172],[112.13784942626954,194.44987792968752],[112.433642578125,194.13288116455078],[112.72772598266602,193.8143737792969],[113.02014083862305,193.49430084228516],[113.31081848144531,193.17263488769532],[113.59966278076172,192.84934844970704],[113.88660507202148,192.52435913085938],[114.17156295776367,192.1976531982422],[114.45460510253906,191.8692581176758],[114.73532638549806,191.53888549804688],[115.01384353637695,191.20664520263674],[115.29004669189453,190.87246856689453],[115.56378479003907,190.53628692626953],[115.83505096435547,190.1980728149414],[116.1037353515625,189.85788116455078],[116.36981048583985,189.5156021118164],[116.63315277099609,189.17120819091798],[116.89314422607423,188.82428741455078],[117.14788970947266,188.47348022460938],[117.39721069335938,188.11881408691406],[117.64132690429688,187.7605224609375],[117.88040313720704,187.39890747070314],[118.11474151611328,187.03414764404297],[118.34456176757813,186.66655883789062],[118.57008361816406,186.29629211425782],[118.79160919189454,185.9236083984375],[119.00920715332032,185.5486587524414],[119.22364654541016,185.17186889648437],[119.43465270996094,184.79317016601564],[119.64292602539062,184.4129196166992],[119.8484115600586,184.03121337890624],[120.05167236328126,183.64824371337892],[120.25277709960938,183.2641616821289],[120.45215148925782,182.87921447753908],[120.64982299804687,182.49334716796875],[120.8466293334961,182.10708160400392],[121.04236450195313,181.7202392578125],[121.23745422363281,181.33309478759767],[121.43236541748047,180.94581298828126],[121.62719421386718,180.5585174560547],[121.82200927734375,180.17123565673828],[122.01759338378906,179.78431091308593],[122.21397399902344,179.3978256225586],[122.41121978759766,179.0117385864258],[122.6099624633789,178.6264617919922],[122.81050415039063,178.24209136962892],[123.01288604736328,177.85869598388672],[123.21768493652344,177.47659149169922],[123.42481842041016,177.09570922851563],[123.6349868774414,176.71654357910157],[123.8479705810547,176.33892974853515],[124.06467590332032,175.96345825195314],[124.28464965820312,175.5898681640625],[124.50872955322266,175.21873626708984],[124.73697052001954,174.85015869140625],[124.96966094970703,174.4843276977539],[125.2069793701172,174.12154541015624],[125.44921417236328,173.76199035644532],[125.69658508300782,173.4059783935547],[125.94892730712891,173.05342712402344],[126.20243682861329,172.70171356201172],[126.45645446777344,172.350439453125],[126.7115707397461,171.99989318847656],[126.96771697998047,171.6501434326172],[127.22508544921875,171.3012451171875],[127.4838134765625,170.9533905029297],[127.74410705566406,170.60667572021484],[128.0060760498047,170.26126556396486],[128.26973419189454,169.91711883544923],[128.53558959960938,169.5746612548828],[128.80360107421876,169.2339065551758],[129.073974609375,168.8949920654297],[129.3467788696289,168.5580551147461],[129.622233581543,168.22327423095703],[129.9004623413086,167.89081420898438],[130.18164367675783,167.5608123779297],[130.46588745117188,167.23344726562502],[130.7533172607422,166.90893859863283],[131.0441390991211,166.58739624023437],[131.33840789794922,166.2690673828125],[131.63634338378907,165.95408935546877],[131.93797302246094,165.64273681640626],[132.2435028076172,165.33514709472658],[132.55301513671876,165.03155364990235],[132.86659240722656,164.73221740722656],[133.18435821533203,164.4373031616211],[133.50640869140625,164.14708557128907],[133.83282623291015,163.86175689697265],[134.1636520385742,163.5816192626953],[134.49903717041016,163.30687866210937],[134.8389678955078,163.03775482177736],[135.1828811645508,162.7738220214844],[135.53028259277343,162.51446228027345],[135.88102111816406,162.25967559814453],[136.23505554199218,162.0094207763672],[136.59211120605468,161.7635467529297],[136.95218811035156,161.522135925293],[137.31508026123046,161.28489990234377],[137.68059539794922,161.05181121826172],[138.04877471923828,160.82286987304687],[138.4194808959961,160.59814453125],[138.79253540039062,160.37727813720704],[139.1678009033203,160.16021575927735],[139.54527740478517,159.9469436645508],[139.9248825073242,159.7375442504883],[140.30641021728516,159.5316879272461],[140.6897918701172,159.32925109863282],[141.07495880126953,159.13026123046876],[141.46188354492188,158.93471832275392],[141.8503875732422,158.74236145019532],[142.2404296875,158.55306701660157],[142.63194122314454,158.36683502197266],[143.0248809814453,158.18367919921874],[143.4191116333008,158.0032974243164],[143.81455078125,157.82562103271485],[144.21121215820312,157.65065002441406],[144.60899963378907,157.47832946777345],[145.00787200927735,157.3083709716797],[145.4076919555664,157.14076080322266],[145.80848693847656,156.97547149658203],[146.21018829345704,156.81239318847656],[146.61269989013672,156.6513885498047],[147.01599426269533,156.49229278564454],[147.4200164794922,156.33514709472658],[147.82483520507813,156.17989654541017],[148.2302444458008,156.0262664794922],[148.6362030029297,155.87420196533205],[149.04299926757812,155.72421112060547],[149.4519790649414,155.58048248291016],[149.8632797241211,155.44338684082032],[150.2765853881836,155.31264953613282],[150.69178619384766,155.1878173828125],[151.10864868164063,155.06868438720704],[151.52700805664062,154.9550994873047],[151.94674072265624,154.84656829833986],[152.36766815185547,154.74278869628907],[152.78970794677736,154.6435546875],[153.2126678466797,154.54852294921875],[153.6365478515625,154.45746002197265],[154.06108703613282,154.36954193115236],[154.48631286621094,154.28522186279298],[154.91211547851563,154.20359344482424],[155.3383575439453,154.12442321777345],[155.76505279541016,154.04776611328126],[156.1920639038086,153.97289428710937],[156.61937713623047,153.89960174560548],[157.0468963623047,153.8278060913086],[157.47459411621094,153.75679321289064],[157.9024429321289,153.6866180419922],[158.33026428222658,153.61663513183595],[158.75812683105468,153.5466522216797],[159.18590698242187,153.47635345458986],[159.61363220214844,153.4055603027344],[160.04120635986328,153.3340255737305],[160.46858825683594,153.26117248535158],[160.89570922851564,153.18669891357422],[161.3224594116211,153.1104949951172],[161.74883880615235,153.03197021484377],[162.17473754882812,152.9509735107422],[162.6001419067383,152.86736755371095],[163.02481842041016,152.7803146362305],[163.44889068603516,152.69008941650392],[163.87209777832032,152.59600524902345],[164.29430236816407,152.49771881103516],[164.71551818847658,152.3950378417969],[165.13552551269532,152.28763275146486],[165.55422821044922,152.17517395019533],[165.97140655517578,152.0572494506836],[166.38699188232422,151.9337356567383],[166.80075073242188,151.80430297851564],[167.21243591308595,151.66845703125],[167.62193756103517,151.5261016845703],[168.02899475097658,151.37698974609376],[168.43342895507814,151.2208465576172],[168.83496551513673,151.05742492675782],[169.23401641845703,150.88797454833986],[169.63080139160158,150.71325073242187],[170.02519683837892,150.53326721191408],[170.41740875244142,150.3485321044922],[170.8073684692383,150.15914154052734],[171.19504852294924,149.96509552001953],[171.5804626464844,149.76662750244142],[171.96377563476562,149.56405334472657],[172.34498748779296,149.35757904052736],[172.7240432739258,149.14720458984377],[173.10106658935547,148.9331771850586],[173.47616729736328,148.71582641601563],[173.84942779541015,148.49528961181642],[174.2208206176758,148.27167663574218],[174.5904968261719,148.0451385498047],[174.9585388183594,147.8159912109375],[175.32501525878908,147.58444061279297],[175.69004974365234,147.35050048828126],[176.05365600585938,147.11444549560548],[176.4160400390625,146.87646789550783],[176.7771194458008,146.63655395507814],[177.1373062133789,146.39522552490234],[177.49654541015624,146.1525375366211],[177.85494689941407,145.90862731933595],[178.2126480102539,145.66363220214845],[178.56966247558594,145.4177032470703],[178.92618255615236,145.17099151611328],[179.28216705322265,144.9236068725586],[179.63809661865236,144.67605743408203],[179.99388885498047,144.42831573486328],[180.34954376220705,144.18042297363283],[180.70530853271484,143.93266754150392],[181.06133422851562,143.68529663085937],[181.41737365722656,143.43792572021485],[181.7740447998047,143.19146118164062],[182.13126525878906,142.94580688476563],[182.48855438232422,142.70022125244142],[182.84522552490236,142.45379791259765],[183.20108642578126,142.20615234375],[183.55612335205078,141.95738067626954],[183.91039123535157,141.7074691772461],[184.2638900756836,141.45648651123048],[184.61663360595705,141.2044464111328],[184.96863555908203,140.95137634277344],[185.3199234008789,140.69733123779298],[185.67052459716797,140.44229736328126],[186.02045288085938,140.1863571166992],[186.36970825195314,139.92951049804688],[186.71833190917968,139.6717987060547],[187.06635131835938,139.413249206543],[187.4137390136719,139.1539306640625],[187.76057739257814,138.89380187988283],[188.10686645507812,138.63294525146486],[188.45257873535158,138.37137451171876],[188.79765930175782,138.1089111328125],[189.1424102783203,137.84606323242187],[189.48665313720704,137.58248748779297],[189.83047027587892,137.31841735839845],[190.17382049560547,137.05370178222657],[190.5167999267578,136.78851928710938],[190.85933990478517,136.5228012084961],[191.20156402587892,136.25662994384766],[191.54338989257812,135.99000549316406],[191.88494110107422,135.72295532226562],[192.22613525390625,135.45554809570314],[192.56709594726564,135.18775634765626],[192.9078094482422,134.91963500976564],[193.24824829101564,134.65122528076174],[193.58841247558595,134.38245849609376],[193.92828826904298,134.11334838867188],[194.26819152832033,133.84422454833984],[194.60808105468752,133.575114440918],[194.94776458740236,133.30571594238282],[195.2872283935547,133.0360290527344],[195.6266647338867,132.7663558959961],[195.96611480712892,132.49666900634767],[196.3055374145508,132.22694091796876],[196.6449188232422,131.95715789794923],[196.98428649902345,131.68740234375],[197.32366790771485,131.41761932373046],[197.66317291259767,131.14800109863282],[198.00281524658203,130.87858886718752],[198.3424850463867,130.6091766357422],[198.68214111328126,130.33977813720705],[199.02200317382812,130.07058563232422],[199.36209869384766,129.80175018310547],[199.70237274169924,129.53310699462892],[200.0429214477539,129.2647933959961],[200.3836624145508,128.9967269897461],[200.7247055053711,128.72905883789062],[201.06595458984376,128.4616928100586],[201.4076156616211,128.19479370117188],[201.74948272705078,127.92822418212891],[202.09183044433595,127.66220397949219],[202.43443908691407,127.39654083251953],[202.7775421142578,127.13155059814453],[203.12096099853517,126.86691741943359],[203.4649154663086,126.60303955078125],[203.8091995239258,126.33955993652344],[204.1541290283203,126.07693176269531],[204.4991683959961,125.81441345214844],[204.84441375732422,125.55218353271485],[205.18964538574218,125.2899673461914],[205.53490447998047,125.02773742675781],[205.8801223754883,124.76552124023438],[206.22538146972656,124.50329132080078],[206.57061309814455,124.24107513427735],[206.91585845947267,123.97884521484376],[207.2611038208008,123.7166015625],[207.6061569213867,123.45416564941407],[207.95122375488282,123.19170227050782],[208.29627685546876,122.92925262451172],[208.64134368896484,122.66677551269531],[208.98639678955078,122.40432586669922],[209.3314636230469,122.14184875488282],[209.67653045654296,121.87938537597657],[210.0215835571289,121.61693572998047],[210.36673278808595,121.35455474853516],[210.71189575195314,121.09226989746094],[211.05709991455078,120.82997131347656],[211.402262878418,120.56767272949219],[211.74746704101562,120.30537414550781],[212.0926300048828,120.04307556152344],[212.43783416748047,119.78077697753906],[212.78302459716798,119.51846466064454],[213.12828369140627,119.2562759399414],[213.47376251220703,118.9943344116211],[213.8192138671875,118.7324203491211],[214.1646926879883,118.47049255371094],[214.51019897460938,118.20857849121094],[214.8559524536133,117.94704895019531],[215.2017059326172,117.68551940917969],[215.5474868774414,117.42396240234375],[215.89324035644532,117.16243286132813],[216.23930969238282,116.90135650634765],[216.58543395996094,116.6403076171875],[216.93158569335938,116.37923126220703],[217.27769622802734,116.11818237304688],[217.62415008544923,115.85757293701172],[217.97074127197266,115.59708709716797],[218.3173049926758,115.33662872314453],[218.66385498046876,115.07616348266602],[219.01067962646485,114.81611709594726],[219.3578063964844,114.55631103515626],[219.7048782348633,114.29653930664062],[220.05195007324218,114.03677444458008],[220.3993103027344,113.7772705078125],[220.74697265625,113.51829528808594],[221.09463500976562,113.25932006835937],[221.44229736328126,113.00033798217774],[221.79012451171874,112.74145889282227],[222.13828125,112.48313598632812],[222.4864929199219,112.22486801147461],[222.8350341796875,111.96699142456055],[223.18353424072265,111.70919036865234],[223.53240509033205,111.45184936523438],[223.88127593994142,111.19450149536134],[224.23057250976564,110.93761367797852],[224.57982788085937,110.68078765869141],[224.9294403076172,110.42443542480468],[225.2791488647461,110.16813125610352],[225.62915954589843,109.91229400634766],[225.97923889160157,109.65660095214844],[226.32960662841796,109.40134735107422],[226.68018035888673,109.14622421264649],[227.0310012817383,108.89149932861328],[227.38198699951172,108.63703536987305],[227.73323364257814,108.38280487060547],[228.0845901489258,108.12886276245118],[228.4359603881836,107.87492752075195],[228.78731689453124,107.62099227905274],[229.13872833251955,107.36702270507813],[229.49009857177734,107.1130874633789],[229.84146881103516,106.85922775268556],[230.19322357177734,106.60575256347657],[230.54493713378906,106.35229797363282],[230.89666442871095,106.09885025024414],[231.24872131347658,105.84584884643554],[231.6008056640625,105.59285430908203],[231.95289001464843,105.33988723754884],[232.3052764892578,105.08734588623047],[232.65782775878907,104.83495559692383],[233.01032409667968,104.58259963989258],[233.36306762695312,104.33064880371094],[233.7160858154297,104.07901382446289],[234.06913146972656,103.82735137939453],[234.42236938476563,103.57599105834962],[234.77599182128907,103.32521438598633],[235.12966918945312,103.07441024780273],[235.4833740234375,102.8237777709961],[235.83768310546876,102.57397613525391],[236.1919921875,102.32417449951173],[236.54635620117188,102.07433853149415],[236.90140686035156,101.82555313110352],[237.2565124511719,101.57685012817383],[237.6116180419922,101.32811279296875],[237.96719055175782,101.08006210327149],[238.32295532226564,100.83235473632813],[238.67913208007812,100.58521041870118],[239.03561096191407,100.3383888244629],[239.39222717285156,100.09190368652344],[239.7493103027344,99.84609146118164],[240.1066680908203,99.60053329467773],[240.46427307128906,99.3554901123047],[240.82231750488282,99.11101684570313],[241.18049926757814,98.86689376831055],[241.5392578125,98.62340240478515],[241.89826354980468,98.38037796020508],[242.25751647949218,98.13773803710937],[242.61740112304688,97.89590148925781],[242.97747802734375,97.65444946289062],[243.3379119873047,97.41358108520508],[243.69884033203127,97.17340621948243],[244.06004333496094,96.93358840942383],[244.42176818847656,96.69462890625],[244.78385009765626,96.45620498657227],[245.1462615966797,96.21819305419922],[245.50922241210938,95.98124542236329],[245.87248535156252,95.74464111328125],[246.23613281250002,95.50861358642578],[246.5998077392578,95.27256546020509],[246.96370239257814,95.03690185546876],[247.3279541015625,94.80182189941407],[247.69275512695313,94.56757278442383],[248.05791320800782,94.3339210510254],[248.42351074218752,94.1009147644043],[248.78993225097656,93.86924057006836],[249.15693054199218,93.6383903503418],[249.52445068359376,93.4083984375],[249.89293212890627,93.1800750732422],[250.26226501464845,92.95296707153321],[250.63244934082033,92.72732849121094],[251.00367736816406,92.50343399047851],[251.37583923339844,92.28112564086915],[251.74918212890626,92.06058197021484],[252.12362365722657,91.84215316772462],[252.4991638183594,91.6255989074707],[252.8760772705078,91.4112419128418],[253.2542266845703,91.19927444458008],[253.6336395263672,90.98951797485351],[254.0144805908203,90.7824806213379],[254.39685974121093,90.57801132202148],[254.78044738769532,90.37600021362304],[255.16485900878908,90.17552032470704],[255.54998474121095,89.97653045654297],[255.93590698242187,89.77894134521485],[256.3225433349609,89.58281478881837],[256.7098663330078,89.38809585571289],[257.09795837402345,89.19479827880859],[257.48679199218753,89.00303192138672],[257.87622985839846,88.81263885498048],[258.2663269042969,88.62358474731445],[258.65716552734375,88.43578720092773],[259.0484985351563,88.24934234619141],[259.4405181884766,88.06414031982422],[259.8330871582031,87.8802085876465],[260.2262878417969,87.69749908447265],[260.61998291015624,87.51603927612305],[261.01433715820315,87.33593902587891],[261.40924072265625,87.1570198059082],[261.80466613769534,86.97924728393555],[262.2005584716797,86.8026351928711],[262.59702758789064,86.62710800170899],[262.99388122558594,86.45272064208984],[263.3912567138672,86.27938385009766],[263.78907165527346,86.10712509155273],[264.18743591308595,85.93586196899415],[264.5861846923828,85.76577301025391],[264.9853729248047,85.59670715332031],[265.38502807617186,85.42859573364258],[265.78501281738284,85.2614730834961],[266.18543701171876,85.09527053833008],[266.58619079589846,84.93000869750976],[266.98741149902344,84.76560516357422],[267.38893432617186,84.60210800170898],[267.79078674316406,84.43948287963867],[268.19305114746095,84.27771606445313],[268.5956176757813,84.11683502197266],[268.99859619140625,83.95696334838867],[269.4018218994141,83.79779891967773],[269.8054595947266,83.63950653076172],[270.20953674316405,83.48238830566406],[270.61383361816405,83.32598419189453],[271.0185150146485,83.17035598754883],[271.4236083984375,83.01590194702149],[271.82892150878905,82.86210021972657],[272.23450927734376,82.70899200439453],[272.6405914306641,82.55703735351562],[273.04681091308595,82.40570755004883],[273.4532775878906,82.25497512817383],[273.86021118164064,82.10534133911133],[274.2673370361328,81.95627746582032],[274.6746276855469,81.8078109741211],[275.0823028564453,81.66032638549805],[275.4902252197266,81.5134048461914],[275.89825744628905,81.36703948974609],[276.30664672851566,81.22153930664062],[276.715283203125,81.07659530639648],[277.12402954101566,80.93215942382812],[277.5330505371094,80.78847885131836],[277.9422912597656,80.64537506103515],[278.3517242431641,80.5026969909668],[278.7613220214844,80.36068496704102],[279.1711120605469,80.21924285888672],[279.5811218261719,80.07825393676758],[279.9913787841797,79.93811645507813],[280.4016082763672,79.79797897338868],[280.81194763183595,79.65823287963867],[281.2226989746094,79.51939315795899],[281.6333953857422,79.38057403564453],[282.0442565917969,79.2421257019043],[282.4553924560547,79.10444641113281],[282.86647338867186,78.96678771972657],[283.2776641845703,78.82951354980469],[283.68907470703124,78.69285736083985],[284.10056762695314,78.55618743896484],[284.5120880126953,78.41990203857422],[284.9237731933594,78.28410415649414],[285.3355407714844,78.14828567504883],[285.74736328125,78.01279678344727],[286.1592956542969,77.87769241333008],[286.57122802734375,77.74258117675781],[286.9832702636719,77.60774459838868],[287.39536743164064,77.47316207885743],[287.8074645996094,77.33857955932618],[288.2197540283203,77.20424423217774],[288.63201599121095,77.07015609741211],[289.0442779541016,76.93606109619141],[289.4565399169922,76.80197296142579],[289.8688568115235,76.66786422729493],[290.2811187744141,76.53376922607423],[290.6933807373047,76.39975662231446],[291.10572509765626,76.26576461791993],[291.51804199218753,76.13178634643555],[291.9303314208984,75.99780807495118],[292.3426208496094,75.86383666992188],[292.754965209961,75.72984466552735],[293.1671447753906,75.59548873901367],[293.5792694091797,75.46100234985352],[293.9914489746094,75.32648849487305],[294.40357360839846,75.19200210571289],[294.81572570800785,75.05750885009766],[295.2278503417969,74.92301559448242],[295.6398101806641,74.7878631591797],[296.05168762207035,74.65258712768555],[296.46356506347655,74.5173110961914],[296.87530517578125,74.38138275146484],[297.2869354248047,74.24537200927735],[297.6985656738281,74.10936126708985],[298.10992126464845,73.97254028320313],[298.52130432128905,73.8356300354004],[298.93263244628906,73.69873352050782],[299.34368591308595,73.5608139038086],[299.7547119140625,73.42285308837891],[300.16565551757816,73.28491287231445],[300.5762420654297,73.14576416015625],[300.98682861328126,73.00662231445312],[301.39744262695314,72.86738433837891],[301.8075622558594,72.72686920166016],[302.2176818847656,72.5863540649414],[302.6278289794922,72.44571533203126],[303.0375640869141,72.30408096313477],[303.4471069335938,72.16196594238282],[303.8565124511719,72.01941833496095],[304.26572570800784,71.87614288330079],[304.67469177246096,71.73229751586915],[305.0835205078125,71.58798522949219],[305.4921020507813,71.44292449951172],[305.9003814697266,71.29721145629883],[306.30852355957035,71.15096969604492],[306.71636352539065,71.00397262573243],[307.12395629882815,70.85617904663086],[307.5313293457031,70.70793228149414],[307.93848266601566,70.55906753540039],[308.34569091796874,70.41017532348633],[308.7528442382813,70.26131057739258],[309.1599975585938,70.11243896484375],[309.56715087890626,69.96357421875],[309.97424926757816,69.81431121826172],[310.3811828613281,69.66483535766602],[310.7881164550781,69.51536636352539],[311.1951049804688,69.36586990356446],[311.60203857421874,69.21639404296876],[312.00897216796875,69.06692504882812],[312.4157958984375,68.91696853637696],[312.82256469726565,68.76690902709962],[313.22930603027345,68.6168701171875],[313.6360198974609,68.46682434082031],[314.0428161621094,68.31676483154297],[314.4495300292969,68.16672592163086],[314.8560516357422,68.01622009277344],[315.2625732421875,67.86565246582032],[315.66917724609374,67.71507110595704],[316.07569885253906,67.5645034790039],[316.4822479248047,67.41393585205078],[316.88876953125003,67.26337509155273],[317.2952362060547,67.1123405456543],[317.7015655517578,66.96128540039062],[318.10792236328126,66.81023025512695],[318.51433410644535,66.65915451049806],[318.9206909179688,66.50809936523437],[319.3270477294922,66.3570442199707],[319.7332397460938,66.20563201904297],[320.13945922851565,66.05409622192383],[320.5456512451172,65.90258102416992],[320.95184326171875,65.75106582641602],[321.3580627441406,65.5995231628418],[321.7642547607422,65.4480079650879],[322.1703369140625,65.29624557495117],[322.5763641357422,65.14429092407227],[322.9824188232422,64.99232254028321],[323.38844604492186,64.84037475585937],[323.7944732666016,64.68842697143555],[324.2005279541016,64.53645172119141],[324.60650024414065,64.38440780639648],[325.0123626708984,64.23205490112305],[325.4182525634766,64.07970199584962],[325.824169921875,63.927328491210936],[326.23003234863285,63.774975585937504],[326.6358947753906,63.622622680664065],[327.04181213378905,63.47024917602539],[327.4474822998047,63.31741561889648],[327.85312500000003,63.16449966430664],[328.25879516601566,63.011583709716795],[328.66449279785155,62.8586540222168],[329.0701629638672,62.70573806762695],[329.47580566406253,62.55282211303711],[329.88153076171875,62.39988555908203],[330.28717346191405,62.246969604492186],[330.6928436279297,62.09405364990234],[331.09848632812503,61.9411376953125],[331.5041839599609,61.7882080078125],[331.90985412597655,61.635292053222656],[332.3154968261719,61.48237609863281],[332.72100219726565,61.32887649536133],[333.12639770507815,61.17528076171875],[333.53179321289065,61.02168502807617],[333.93718872070315,60.868096160888676],[334.34263916015624,60.71447982788086],[334.74803466796874,60.56088409423828],[335.15343017578124,60.40729522705078],[335.5589080810547,60.25367889404297],[335.9643035888672,60.10009002685547],[336.3696990966797,59.94649429321289],[336.7750946044922,59.79289855957031],[337.1805450439453,59.63928909301758],[337.5859405517578,59.485693359375],[337.9912811279297,59.331747436523436],[338.396484375,59.17753372192383],[338.80166015625,59.02333374023438],[339.2068359375,58.869133758544926],[339.61201171875,58.71494064331055],[340.0172149658203,58.56072006225586],[340.4223907470703,58.40652008056641],[340.82756652832035,58.25232696533203],[341.23279724121096,58.098106384277344],[341.63794555664066,57.94390640258789],[342.0431213378906,57.789713287353514],[342.44829711914065,57.63551330566406],[342.85352783203126,57.481296157836915],[343.25864868164064,57.32708930969238],[343.6636047363281,57.172350311279295],[344.06861572265626,57.01759071350098],[344.4735992431641,56.86285171508789],[344.87855529785156,56.708109283447264],[345.28351135253905,56.553370285034184],[345.6885223388672,56.39861068725586],[346.093505859375,56.24386825561523],[346.4984619140625,56.08912925720215],[346.9034729003906,55.93436965942383],[347.3084289550781,55.7796272277832],[347.7134124755859,55.62488822937012],[348.1183685302735,55.470149230957034],[348.52337951660155,55.31538963317871],[348.9282531738281,55.16048583984375],[349.3330444335938,55.00525932312012],[349.7378631591797,54.85001220703125],[350.1426544189453,54.69478569030762],[350.54741821289065,54.53955917358399],[350.9521820068359,54.38433265686035],[351.3570281982422,54.229085540771486],[351.7617919921875,54.073855590820315],[352.1665832519531,53.91862907409668],[352.5714019775391,53.76338195800781],[352.9761932373047,53.60815544128418],[353.38095703125003,53.452928924560545],[353.78574829101564,53.297702407836915],[354.19056701660156,53.14245529174805],[354.59527587890625,52.986981582641604],[354.99990234375,52.83131217956543],[355.40455627441406,52.67562561035157],[355.8091552734375,52.51995620727539],[356.21375427246096,52.36429023742676],[356.6183807373047,52.20862083435059],[357.0230346679688,52.05293426513672],[357.4276336669922,51.897264862060545],[357.8322326660156,51.74159889221192],[358.23691406250003,51.58590888977051],[358.6415130615234,51.430242919921874],[359.0461120605469,51.274573516845706],[359.45073852539065,51.11890411376953],[359.8553924560547,50.96321754455567],[360.2599090576172,50.807294082641604],[360.66437072753905,50.65122985839844],[361.06885986328126,50.49514503479004],[361.47332153320315,50.339080810546875],[361.87778320312503,50.183016586303715],[362.2822174072266,50.02695236206055],[362.6867340087891,49.87086753845215],[363.09119567871096,49.714803314208986],[363.49565734863285,49.558735656738286],[363.900146484375,49.40265426635742],[364.3046081542969,49.24658660888672],[364.7090698242188,49.090522384643556],[365.11353149414066,48.93445816040039],[365.5180206298828,48.778373336791994],[365.92234497070314,48.62206878662109],[366.32666931152346,48.46564407348633],[366.73102111816405,48.30919876098633],[367.1353454589844,48.152777481079106],[367.5396697998047,47.99635276794434],[367.943994140625,47.83992805480957],[368.3483459472656,47.68348617553711],[368.75267028808594,47.527061462402344],[369.15699462890626,47.370640182495116],[369.5613464355469,47.21419486999512],[369.9656707763672,47.05777015686035],[370.3699951171875,46.90134887695313],[370.7742919921875,46.74492416381836],[371.1786712646485,46.5884822845459],[371.5828857421875,46.431796646118165],[371.98707275390626,46.27504920959473],[372.3913146972656,46.11828117370606],[372.7955291748047,45.96153373718262],[373.19971618652346,45.80478630065918],[373.6039031982422,45.64804229736328],[374.0081451416016,45.49127426147461],[374.41233215332034,45.334526824951176],[374.8165191650391,45.17777938842774],[375.22076110839845,45.02101135253906],[375.6249481201172,44.864267349243164],[376.02916259765624,44.707519912719725],[376.433349609375,44.55077247619629],[376.8375915527344,44.39400444030762],[377.2416687011719,44.23697204589844],[377.6457458496094,44.07993278503418],[378.0498779296875,43.922872924804686],[378.45395507812503,43.76583023071289],[378.8580322265625,43.608790969848634],[379.262109375,43.451748275756835],[379.66624145507814,43.29468841552735],[380.07031860351566,43.13764915466309],[380.4743957519531,42.98060646057129],[380.87847290039065,42.823567199707036],[381.28260498046876,42.66650733947754],[381.6866821289063,42.50946464538574],[382.09075927734375,42.35242538452149],[382.4948638916016,42.19527969360352],[382.8987762451172,42.03785934448242],[383.30271606445314,41.88043899536133],[383.7066558837891,41.723022079467775],[384.1106231689453,41.56558113098145],[384.5145629882813,41.40816078186035],[384.91847534179686,41.250740432739256],[385.3224700927735,41.09330291748047],[385.7264099121094,40.935882568359375],[386.130322265625,40.778462219238286],[386.534262084961,40.62104187011719],[386.9382293701172,40.463600921630864],[387.34216918945316,40.30618057250977],[387.74610900878906,40.14876365661621],[388.15007629394535,39.991322708129886],[388.55401611328125,39.83390235900879],[388.9579284667969,39.6764820098877],[389.36186828613285,39.5190616607666],[389.7658355712891,39.36162414550781],[390.16977539062503,39.20420379638672],[390.57371520996094,39.046783447265625],[390.9776824951172,38.8893424987793],[391.3816223144531,38.731925582885744],[391.78553466796876,38.57450523376465],[392.1894744873047,38.41708488464356],[392.59344177246095,38.259643936157225],[392.9973815917969,38.102223587036136],[393.4012390136719,37.94470710754395],[393.80506896972656,37.786847305297854],[394.2088165283203,37.629008102417],[394.6125915527344,37.47116889953613],[395.01633911132814,37.31332969665527],[395.4201690673828,37.15546989440918],[395.8239440917969,36.99763069152832],[396.2276916503906,36.839791488647464],[396.63152160644535,36.68193168640137],[397.03529663085936,36.52409248352051],[397.4390441894531,36.36625328063965],[397.8428192138672,36.20841407775879],[398.2466217041016,36.050554275512695],[398.65039672851566,35.89271507263184],[399.0541717529297,35.73487586975098],[399.4579742431641,35.577016067504886],[399.86174926757815,35.41917686462403],[400.2655242919922,35.26133766174316],[400.669271850586,35.103498458862305],[401.07310180664064,34.94563865661621],[401.4768493652344,34.78779945373535],[401.88062438964846,34.629960250854495],[402.2844543457031,34.4721004486084],[402.6882019042969,34.31426124572754],[403.09197692871095,34.15642204284668],[403.495751953125,33.99858283996582],[403.8995269775391,33.84060974121094],[404.30316467285155,33.682454681396486],[404.7068298339844,33.52429618835449],[405.1105224609375,33.36612052917481],[405.51416015625,33.20796203613281],[405.9177978515625,33.04980697631836],[406.321435546875,32.89164848327637],[406.7251281738281,32.73347282409668],[407.12876586914064,32.57531433105469],[407.53240356445315,32.41715927124024],[407.93609619140625,32.25898361206055],[408.33973388671876,32.10082511901856],[408.7433715820313,31.9426700592041],[409.14703674316405,31.78451156616211],[409.5507293701172,31.626335906982423],[409.9543670654297,31.46817741394043],[410.3580047607422,31.310022354125977],[410.76169738769534,31.15184326171875],[411.16533508300785,30.9936882019043],[411.5689727783203,30.835529708862307],[411.9726104736328,30.677374649047852],[412.376303100586,30.519198989868165],[412.7799407958984,30.361040496826174],[413.18360595703126,30.20288543701172],[413.58729858398436,30.044706344604492],[413.99082641601564,29.886352157592775],[414.3943542480469,29.72793960571289],[414.79790954589845,29.56952362060547],[415.2014923095703,29.411087036132812],[415.6050476074219,29.252674484252932],[416.0085754394531,29.094258499145507],[416.412158203125,28.93582534790039],[416.8157135009766,28.77740936279297],[417.2192413330078,28.618996810913085],[417.6227966308594,28.460580825805664],[418.02637939453126,28.302147674560548],[418.4299346923828,28.143731689453126],[418.8334625244141,27.985317420959472],[419.23704528808594,27.826882553100585],[419.64060058593753,27.668468284606934],[420.04412841796875,27.510054016113283],[420.44768371582035,27.35163974761963],[420.8512664794922,27.193204879760742],[421.25482177734375,27.03479061126709],[421.658349609375,26.876376342773437],[422.0619323730469,26.71794147491455],[422.4654876708984,26.5595272064209],[422.8690155029297,26.401111221313478],[423.27257080078124,26.242696952819824],[423.67615356445316,26.084262084960937],[424.0796813964844,25.925847816467286],[424.483236694336,25.767433547973635],[424.88681945800784,25.60899868011475],[425.2903747558594,25.450584411621094],[425.69390258789065,25.292170143127443],[426.0974578857422,25.13375587463379],[426.50104064941405,24.9753210067749],[426.9045684814453,24.81690673828125],[427.30812377929686,24.65849075317383],[427.7117065429688,24.500057601928713],[428.1152618408203,24.34164161682129],[428.5187896728516,24.183227348327637],[428.92234497070314,24.024813079833987],[429.325927734375,23.8663782119751],[429.7294555664063,23.707963943481445],[430.1330108642578,23.549549674987794],[430.5365936279297,23.391114807128908],[430.9401489257813,23.232700538635253],[431.34373168945314,23.074275970458984],[431.7472595214844,22.915873718261718],[432.1508697509766,22.75745258331299],[432.5543975830078,22.599050331115723],[432.9579528808594,22.440649795532227],[433.3615631103516,22.28222694396973],[433.7650909423828,22.123826408386233],[434.1686462402344,21.965424156188966],[434.5721740722656,21.80702362060547],[434.9757843017578,21.648600769042968],[435.3793395996094,21.490200233459472],[435.7828674316406,21.33179798126221],[436.1864776611328,21.173376846313477],[436.5900054931641,21.01497459411621],[436.9935607910156,20.856574058532715],[437.3971160888672,20.69817180633545],[437.8006988525391,20.53975067138672],[438.2042541503906,20.381348419189454],[438.6078369140625,20.22308692932129],[439.01152954101565,20.064966201782227],[439.4151947021484,19.9068660736084],[439.81885986328126,19.74876766204834],[440.2225250244141,19.590667533874512],[440.6262451171875,19.43254680633545],[441.0299102783203,19.27444839477539],[441.43357543945314,19.116348266601562],[441.83729553222656,18.958227539062502],[442.2409606933594,18.800127410888674],[442.6446258544922,18.642028999328613],[443.048291015625,18.483928871154784],[443.4519836425781,18.325808143615724],[443.85564880371095,18.167709732055666],[444.2593139648438,18.009609603881838],[444.66306152343753,17.851667404174805],[445.06694641113285,17.694039344787598],[445.47080383300784,17.536430168151856],[445.8746612548828,17.378822708129885],[446.27857360839846,17.221192932128908],[446.68243103027345,17.063585472106933],[447.08628845214844,16.90597629547119],[447.4903930664063,16.74891300201416],[447.8945251464844,16.59184627532959],[448.2985748291016,16.434798431396484],[448.70265197753906,16.27775058746338],[449.1067840576172,16.120683860778808],[449.5110534667969,15.964106369018555],[449.91546020507815,15.807951164245607],[450.3198944091797,15.651795959472656],[450.7243560791016,15.495621871948243],[451.12879028320316,15.339468383789063],[451.53355407714844,15.184355163574219],[451.9385101318359,15.029288291931152],[452.3437133789063,14.875182723999023],[452.7489440917969,14.721078872680664],[453.1540100097656,14.566714096069337],[453.55877380371095,14.411309051513673],[453.96287841796874,14.254359912872316],[454.3669830322266,14.097409057617188],[454.77064819335936,13.93905658721924],[455.1739837646484,13.780141925811767],[455.577099609375,13.620675373077393],[455.9797760009766,13.460079288482666],[456.38250732421875,13.29946174621582],[456.7846618652344,13.137518119812013],[457.1867889404297,12.97553415298462],[457.5886688232422,12.812861824035645],[457.9903564453125,12.649760341644287],[458.39190673828125,12.486408233642578],[458.7931274414063,12.32220983505249],[459.1944030761719,12.157989978790283],[459.5956237792969,11.993791580200195],[459.99684448242186,11.829592323303222],[460.39801025390625,11.665110683441162],[460.7990386962891,11.500384426116943],[461.20001220703125,11.335658168792724],[461.60101318359375,11.170931911468506],[462.0020690917969,11.006185054779053],[462.4032897949219,10.841900825500488],[462.8045104980469,10.677763366699219],[463.2058410644531,10.51360445022583],[463.60706176757816,10.349466991424562],[464.00828247070314,10.185344982147218],[464.4099975585938,10.022345638275146],[464.811767578125,9.859324836730957],[465.2138122558594,9.697051620483398],[465.615966796875,9.53520154953003],[466.0183410644531,9.373721408843995],[466.421044921875,9.213285827636719],[466.8238037109375,9.052850246429443],[467.2271667480469,8.893937301635743],[467.6306396484375,8.735193443298341],[468.0343322753906,8.577263259887696],[468.43846435546874,8.420369052886963],[468.8429809570313,8.264346027374268],[469.2478271484375,8.109299755096435],[469.6531677246094,7.955407047271729],[470.058837890625,7.802603530883789],[470.4650024414063,7.6508814811706545],[470.8715515136719,7.500321578979492],[471.27854003906253,7.350957298278809],[471.68596801757815,7.202809238433838],[472.0939453125,7.056150341033936],[472.5024719238281,6.910963439941407],[472.91143798828125,6.767206907272339],[473.3209533691406,6.624885034561157],[473.73101806640625,6.484077215194702],[474.1415222167969,6.344855117797851],[474.552685546875,6.207229042053223],[474.9645080566406,6.07163372039795],[475.3768249511719,5.937794494628906],[475.78969116210936,5.805744409561157],[476.203271484375,5.675507497787476],[476.6174011230469,5.547168302536011],[477.0320251464844,5.420774459838867],[477.4474731445313,5.296577453613281],[477.8634704589844,5.174688005447388],[478.28012695312503,5.054924583435059],[478.6973876953125,4.937315082550049],[479.1153076171875,4.821931171417236],[479.5337768554688,4.708827352523804],[479.9529052734375,4.598044395446777],[480.37285766601565,4.490071535110474],[480.793359375,4.384629392623902],[481.21441040039065,4.281311130523682],[481.6361755371094,4.180955314636231],[482.05859985351566,4.083307886123658],[482.48157348632816,3.988337516784668],[482.9051513671875,3.8961575031280518],[483.32944335937503,3.806951951980591],[483.7541748046875,3.7200329303741455],[484.1792907714844,3.6349657058715823],[484.6049011230469,3.552628326416016],[485.03139038085936,3.474568319320679],[485.4587036132813,3.4018866777420045],[485.8871704101563,3.3358240842819216],[486.316845703125,3.277648258209229],[486.747509765625,3.228404402732849],[487.17932739257816,3.190041518211365],[487.61207885742186,3.1637487888336184],[488.0453796386719,3.151008725166321],[488.47890014648436,3.153359842300415],[488.9119812011719,3.172344732284546],[489.3439086914063,3.2094828128814696],[489.7736389160156,3.266223978996277],[490.2000732421875,3.3438799381256104],[490.6227172851563,3.4403701543807985],[491.0422302246094,3.549772524833679],[491.45822753906253,3.6716321468353272],[491.87054443359375,3.8055310249328613],[492.2789611816406,3.951072835922241],[492.6831481933594,4.107629728317261],[493.0832153320313,4.274683713912964],[493.47888793945316,4.451738691329957],[493.8703308105469,4.638252210617066],[494.25721435546876,4.833678817749024],[494.6398132324219,5.037564039230347],[495.01812744140625,5.249333667755127],[495.3921569824219,5.468557691574097],[495.7619567871094,5.694767045974731],[496.12774658203125,5.927452325820923],[496.4896911621094,6.166209697723389],[496.84779052734376,6.410492849349976],[497.20220947265625,6.660121536254883],[497.5533874511719,6.9143962383270265],[497.9012145996094,7.173121690750122],[498.2461853027344,7.435671329498291],[498.58818969726565,7.7021284103393555],[498.92607421875,7.973800563812256],[499.25462036132814,8.256628131866455],[499.5738830566406,8.549775981903077],[499.8844665527344,8.852366924285889],[500.1865905761719,9.163215637207031],[500.48096923828126,9.481445789337158],[500.76820678710936,9.806107234954835],[501.0492370605469,10.136267852783204],[501.3245544433594,10.471117401123047],[501.59558715820316,10.809511756896972],[501.86277465820314,11.150990009307861],[502.1272705078125,11.494382286071778],[502.38989868164066,11.839349555969239],[502.6519226074219,12.184705638885498],[502.91416625976564,12.529972457885743],[503.17723388671874,12.87455348968506],[503.4427734375,13.217226505279541],[503.71116943359374,13.557755470275879],[503.9836853027344,13.894906997680664],[504.2611450195313,14.227994441986084],[504.5444274902344,14.556126022338868],[504.8344665527344,14.87841510772705],[505.12587890625,15.199389266967774],[505.4117431640625,15.525281524658203],[505.69480590820314,15.85367660522461],[505.9773742675781,16.182530021667482],[506.26219482421874,16.509354400634766],[506.552783203125,16.83098773956299],[506.85210571289065,17.144621658325196],[507.1627990722656,17.446936225891115],[507.48760986328125,17.733957481384277],[507.82813110351566,18.002092552185058],[508.18507690429686,18.248119354248047],[508.55278930664065,18.477673530578613],[508.9282470703125,18.694396018981934],[509.3109558105469,18.898127174377443],[509.70020141601566,19.088909912109376],[510.0955444335938,19.26679058074951],[510.49627075195315,19.432090187072756],[510.90199584960936,19.584807014465333],[511.312060546875,19.725490379333497],[511.7258605957031,19.854596900939942],[512.1431213378906,19.972536849975587],[512.5632385253906,20.079226112365724],[512.9858825683594,20.175677490234374],[513.4106689453125,20.262373352050783],[513.8372680664063,20.33953857421875],[514.2661743164062,20.402687644958498],[514.6972229003907,20.448277473449707],[515.1298095703125,20.47682304382324],[515.5631652832031,20.488974952697756],[515.996630859375,20.485498809814455],[516.4297119140625,20.467084693908692],[516.8621337890626,20.435037231445314],[517.2932373046875,20.38988513946533],[517.7229675292969,20.333075523376465],[518.1512145996094,20.26494312286377],[518.5776489257813,20.187144470214843],[519.0023254394531,20.100064086914063],[519.4252441406251,20.005101013183594],[519.8466247558594,19.902773666381837],[520.2660827636719,19.793511199951173],[520.6837829589844,19.677461242675783],[521.0997253417969,19.554987716674805],[521.5138000488281,19.426744651794433],[521.9260070800782,19.29244194030762],[522.3364562988281,19.153003120422365],[522.7450927734375,19.00806770324707],[523.1520263671875,18.858607292175293],[523.5572021484376,18.704323196411135],[523.96083984375,18.54605484008789],[524.3627746582032,18.38361339569092],[524.76328125,18.217783355712893],[525.1623046875001,18.04830551147461],[525.5601745605469,17.876021003723146],[525.9566711425781,17.70069122314453],[526.3521240234376,17.523098945617676],[526.7464782714844,17.342811584472656],[527.1399536132812,17.160847091674807],[527.53271484375,16.977413177490234],[527.9248718261719,16.792583656311034],[528.3163696289063,16.606197166442872],[528.7074279785156,16.419125747680663],[529.0982666015625,16.231444931030275],[529.4888305664062,16.04322338104248],[529.87939453125,15.85502758026123],[530.270068359375,15.667176818847656],[530.6609069824219,15.479611015319824],[531.0518005371094,15.292021179199219],[531.4432983398438,15.105890464782716],[531.8354003906251,14.920839500427247],[532.2280517578125,14.736972999572755],[532.6215270996094,14.555001640319825],[533.015771484375,14.374798393249511],[533.4111694335937,14.196991539001464],[533.807666015625,14.02151927947998],[534.20537109375,13.848970413208008],[534.6042846679687,13.679302883148194],[535.004736328125,13.513126945495605],[535.4065612792969,13.350334453582764],[535.8100341796875,13.191748523712159],[536.2149353027344,13.036973476409912],[536.6213745117187,12.88602819442749],[537.0278686523437,12.735293197631837],[537.433758544922,12.583060455322267],[537.8395385742188,12.430166816711425],[538.2448791503906,12.27643117904663],[538.6502197265626,12.122695541381836],[539.0555053710938,11.968983936309815],[539.4611755371094,11.81594867706299],[539.8670654296875,11.663643836975098],[540.27333984375,11.512302017211914],[540.6802185058594,11.362512016296387],[541.0878662109375,11.214963054656982],[541.4962829589844,11.069587326049804],[541.9055786132812,10.926755619049073],[542.3160278320313,10.786958026885987],[542.7275756835937,10.650808238983155],[543.1403320312501,10.518282222747803],[543.5544067382813,10.389710426330566],[543.9697998046876,10.265825843811035],[544.3867309570313,10.146940898895265],[544.8051452636719,10.033456420898437],[545.22509765625,9.925638484954835],[545.646533203125,9.824090480804443],[546.0695068359375,9.728939437866211],[546.4940185546875,9.640951824188233],[546.9199035644532,9.560052967071533],[547.3466674804688,9.483646488189697],[547.7735961914062,9.408675956726075],[548.2009643554687,9.335238361358643],[548.6287170410156,9.265038299560548],[549.0570739746094,9.19817533493042],[549.4861450195312,9.136062240600586],[549.9158752441407,9.078802871704102],[550.3463745117188,9.027570533752442],[550.777587890625,8.982895660400391],[551.2095153808594,8.945907783508302],[551.6421569824219,8.917471218109132],[552.0752380371094,8.898373889923096],[552.5087036132812,8.889485263824463],[552.9421691894531,8.891716861724854],[553.3754150390625,8.906035995483398],[553.8081115722656,8.933582496643067],[554.239599609375,8.975034427642823],[554.6694396972656,9.031252670288087],[555.0969177246094,9.10307664871216],[555.5213745117188,9.191559505462648],[555.942919921875,9.292670631408692],[556.3620483398438,9.403325271606446],[556.7785949707031,9.523546600341797],[557.19228515625,9.653316593170166],[557.6027893066406,9.792650699615479],[558.0098327636719,9.941616725921632],[558.4133056640625,10.100360584259034],[558.8127136230469,10.26892776489258],[559.2077819824219,10.447406673431397],[559.5980712890625,10.635964679718018],[559.9834167480469,10.834787178039551],[560.3631042480469,11.043984031677246],[560.7367492675781,11.263742351531983],[561.1039123535156,11.4942458152771],[561.4639892578125,11.7356858253479],[561.8164306640625,11.98807954788208],[562.1604675292969,12.251813220977784],[562.49560546875,12.52690486907959],[562.82080078125,12.813529586791992],[563.1354492187501,13.111671924591064],[563.4388916015625,13.421348190307617],[563.7370056152344,13.736108207702637],[564.0350646972656,14.050868225097657],[564.332684326172,14.366122627258301],[564.6301391601563,14.68154697418213],[564.9271545410156,14.997309494018555],[565.2236755371094,15.313549232482911],[565.5202514648438,15.629787254333497],[565.8168273925781,15.94606647491455],[566.1133483886719,16.262304496765136],[566.408935546875,16.579412841796877],[566.7043029785157,16.896800994873047],[566.9996704101562,17.214147949218752],[567.2950378417969,17.531494903564454],[567.5902954101563,17.848929405212402],[567.8845642089844,18.167344093322754],[568.1787780761719,18.485717582702637],[568.473046875,18.80409107208252],[568.7673156738282,19.122505760192873],[569.061199951172,19.44118824005127],[569.3543701171875,19.760533332824707],[569.6475952148438,20.079880142211916],[569.9408203125,20.39926643371582],[570.2339904785157,20.71861152648926],[570.5266662597656,21.0384578704834],[570.81884765625,21.358757400512697],[571.111083984375,21.679015731811525],[571.4032653808594,21.999275779724123],[571.6954467773438,22.31953411102295],[571.9869689941406,22.640437889099122],[572.2782714843751,22.961544227600097],[572.5695190429688,23.282650566101076],[572.8608215332032,23.60379810333252],[573.1520690917969,23.924904441833498],[573.442547607422,24.246697425842285],[573.7329711914062,24.568595123291015],[574.0233947753907,24.890534019470216],[574.3137634277344,25.212430000305176],[574.6041320800781,25.534327697753906],[574.8937316894531,25.856966972351074],[575.1832763671875,26.17961139678955],[575.4728759765625,26.50225410461426],[575.7624206542969,26.824898529052735],[576.0519653320313,27.14762535095215],[576.340740966797,27.470963287353516],[576.6295166015625,27.794299507141115],[576.9183471679688,28.11767864227295],[577.2071228027344,28.44101486206055],[577.4958435058594,28.764431762695313],[577.7839050292969,29.088411712646487],[578.0719665527344,29.412432861328124],[578.360028076172,29.736412811279298],[578.6480895996094,30.06039276123047],[578.9360961914062,30.384503173828126],[579.2234985351563,30.709073638916017],[579.5109008789062,31.033640670776368],[579.7983032226563,31.35821113586426],[580.0857055664063,31.682819366455078],[580.3729980468751,32.00745162963867],[580.6597412109376,32.33257827758789],[580.9465393066406,32.65774612426758],[581.2333374023438,32.9828727722168],[581.5200805664062,33.30799942016602],[581.8067687988281,33.63318099975586],[582.0929626464844,33.95885353088379],[582.3791564941406,34.28448829650879],[582.6653503417969,34.610119628906254],[582.9515991210938,34.93579559326172],[583.2377380371094,35.26149215698242],[583.5233825683594,35.58759384155274],[583.8090270996094,35.91369209289551],[584.0947265625,36.23983497619629],[584.38037109375,36.5659366607666],[584.666015625,36.892076110839845],[584.951220703125,37.21864128112793],[585.2363708496094,37.54516868591309],[585.5215759277344,37.871696090698244],[585.8067260742188,38.198220062255864],[586.0919311523438,38.52478866577149],[586.3764221191407,38.85185165405274],[586.6609680175782,39.17893524169922],[586.9455139160157,39.50606346130371],[587.2300598144532,39.833150482177736],[587.5146057128907,40.16023406982422],[587.7990966796875,40.487321090698245],[588.083642578125,40.814445877075194],[588.3681884765625,41.14153289794922],[588.652734375,41.4686164855957],[588.9372802734375,41.7957447052002],[589.2212219238281,42.12336730957031],[589.5050537109375,42.45106887817383],[589.7888305664063,42.778773880004884],[590.0727172851563,43.10651664733887],[590.356494140625,43.43422164916992],[590.6403259277344,43.761923217773436],[590.9241577148438,44.089669418334964],[591.2079895019532,44.41737098693848],[591.4918212890625,44.745072555541995],[591.7755981445313,45.07277755737305],[592.0591003417969,45.400825881958006],[592.3423828125,45.728997802734376],[592.6256652832031,46.057166290283206],[592.9089477539063,46.38537940979004],[593.1922302246094,46.71355133056641],[593.4755126953125,47.04172325134277],[593.7587951660156,47.36989517211914],[594.0420776367188,47.69810829162598],[594.325360107422,48.02628021240235],[594.608642578125,48.35445213317871],[594.8917602539062,48.682826614379884],[595.174658203125,49.011324691772465],[595.4575561523437,49.33982276916504],[595.7404541015625,49.66832084655762],[596.0234069824219,49.996860122680665],[596.3063049316406,50.32535820007325],[596.5891479492187,50.65385284423828],[596.8721008300781,50.98239212036133],[597.1549987792969,51.310890197753906],[597.4378967285156,51.63938827514649],[597.7206848144532,51.96792068481445],[598.00341796875,52.29666252136231],[598.2860412597656,52.62536315917969],[598.5687194824219,52.95406379699707],[598.8513977050782,53.282805633544925],[599.1340759277344,53.61150283813477],[599.4167541503906,53.94020347595215],[599.6993774414062,54.26890411376953],[599.9821105957031,54.597645950317386],[600.2647338867188,54.92634658813477],[600.547412109375,55.255043792724614],[600.8300903320313,55.58378562927246],[601.1127685546875,55.91248626708985],[601.3953918457031,56.24118690490723],[601.6780700683594,56.56988754272461],[601.9607482910156,56.898629379272464],[602.2434265136719,57.22732658386231],[602.5261047363282,57.55602722167969],[602.8087829589844,57.884765625],[603.0914611816406,58.213469696044925],[603.3741394042969,58.54219436645508],[603.6570373535156,58.87068557739258],[603.939990234375,59.19921798706055],[604.2228881835938,59.52770919799805],[604.5057861328125,59.85620040893555],[604.7886840820313,60.184732818603514],[605.07158203125,60.513224029541014],[605.3545349121094,60.841715240478514],[605.6374328613282,61.170206451416014],[605.920330810547,61.498738861083986],[606.2032287597657,61.827230072021486],[606.4861267089844,62.155721282958986],[606.7690795898437,62.48426055908203],[607.0519775390625,62.81275177001953],[607.3348754882812,63.14124298095703],[607.6177734375,63.46973419189453],[607.9007263183594,63.7982666015625],[608.1836242675781,64.1267578125],[608.4665222167969,64.4552490234375],[608.7494750976563,64.78378143310547],[609.032373046875,65.11227264404297],[609.3161499023438,65.43996734619141],[609.6000366210938,65.76764144897462],[609.8840881347656,66.09518508911133],[610.1689086914063,66.42202835083008],[610.4537292480469,66.74887161254883],[610.7388793945313,67.0753646850586],[611.0245239257813,67.40154876708985],[611.3101684570313,67.72768478393554],[611.5957580566406,68.05382766723633],[611.8814025878906,68.38001174926758],[612.1669921875,68.70614776611329],[612.45263671875,69.03229751586915],[612.7382263183594,69.35844039916992],[613.0238708496094,69.68463134765625],[613.3094604492188,70.01077423095704],[613.5950500488282,70.3369239807129],[613.8803100585938,70.66347885131836],[614.1650756835937,70.99034957885742],[614.4498413085938,71.3172203063965],[614.7339477539062,71.64483261108398],[615.017724609375,71.97255477905274],[615.3014465332031,72.30024948120118],[615.583905029297,72.62909774780273],[615.8664184570313,72.9579460144043],[616.1483825683594,73.28718566894531],[616.4293029785157,73.61752395629883],[616.7101684570313,73.94778671264649],[616.9902099609375,74.27872924804687],[617.2694824218751,74.61042709350586],[617.5477661132812,74.94282531738281],[617.825115966797,75.27594451904297],[618.1016967773438,75.60975036621095],[618.3776184082031,75.94435958862304],[618.6521118164063,76.2798683166504],[618.9256713867188,76.61613235473634],[619.1983520507813,76.9532066345215],[619.4699340820313,77.2910774230957],[619.7400329589844,77.63020477294923],[620.009033203125,77.97018356323242],[620.2769897460938,78.31106872558594],[620.5435729980469,78.65296325683595],[620.8084533691407,78.99609375],[621.0721801757812,79.34023361206054],[621.3349182128907,79.68501205444336],[621.5982055664062,80.02945404052734],[621.8638000488281,80.37206954956055],[622.1308776855469,80.71381301879883],[622.3978454589844,81.05535736083985],[622.6643188476563,81.39727249145508],[622.9293090820313,81.74039611816407],[623.1923217773438,82.08497543334961],[623.4517639160157,82.43229446411134],[623.7067565917969,82.78281326293946],[623.956640625,83.13727340698243],[624.20009765625,83.4959083557129],[624.4364685058594,83.85940475463867],[624.6639404296875,84.22838745117188],[624.8817993164063,84.60322036743165],[625.0885070800781,84.98417129516602],[625.2829650878906,85.37160415649414],[625.4640747070313,85.76562194824218],[625.6340881347656,86.16438446044923],[625.8004211425781,86.56478805541992],[625.9627990722656,86.96669540405274],[626.1205078125,87.37045669555664],[626.2735473632813,87.7760856628418],[626.4204895019532,88.18398742675781],[626.5620483398437,88.59386672973633],[626.6965759277344,89.00588836669922],[626.8236877441407,89.4203269958496],[626.9428894042969,89.83716888427735],[627.0535217285156,90.25631103515626],[627.1549255371094,90.67784957885742],[627.2461669921876,91.1015853881836],[627.3266967773437,91.52765579223633],[627.3955810546876,91.95565567016602],[627.45205078125,92.38549575805665],[627.4951721191406,92.81685333251953],[627.5242309570312,93.24936447143556],[627.5382934570313,93.68259658813477],[627.5367004394532,94.11612396240234],[627.5185729980469,94.5493148803711],[627.4831420898438,94.98133850097656],[627.4284851074219,95.41132965087891],[627.3537780761719,95.83836822509765],[627.2604492187501,96.26171951293945],[627.1498168945312,96.68079299926758],[627.022705078125,97.09524536132812],[626.8802673339844,97.50471267700196],[626.723876953125,97.90901641845703],[626.5543579101562,98.30803298950195],[626.3727539062501,98.70164566040039],[626.1800537109375,99.09000549316407],[625.9769165039063,99.47293395996094],[625.7643310546875,99.8507194519043],[625.5429565429688,100.22354049682617],[625.3131774902344,100.59129409790039],[625.0760375976563,100.95415878295898],[624.8320861816406,101.3124366760254],[624.5816528320313,101.66637496948242],[624.3242980957032,102.01528701782227],[624.0564514160156,102.35612411499024],[623.7781127929687,102.68859786987305],[623.4900512695312,103.01245422363282],[623.1926513671875,103.32796783447266],[622.8861328125,103.63439025878907],[622.5709350585938,103.93198928833009],[622.2476623535157,104.2208953857422],[621.9160949707032,104.5001953125],[621.5770568847656,104.77043838500977],[621.230712890625,105.03123321533204],[620.8774475097656,105.28231887817383],[620.5170410156251,105.5232765197754],[620.1501525878906,105.75424346923829],[619.777001953125,105.97484893798828],[619.3976989746094,106.1846809387207],[619.0115844726563,106.38207092285157],[618.6197570800781,106.56738967895508],[618.2224365234375,106.74099426269531],[617.8204467773438,106.903125],[617.4140625,107.05404281616211],[617.0038330078125,107.19415969848633],[616.5901977539063,107.32380523681641],[616.1734313964844,107.44331588745118],[615.7539184570313,107.55299377441406],[615.3322082519531,107.65305862426759],[614.9082458496094,107.7438949584961],[614.4825256347657,107.82573623657227],[614.0552673339844,107.89884338378907],[613.6265808105469,107.9634635925293],[613.1965759277344,108.01948013305665],[612.7655822753907,108.06641921997071],[612.3337097167969,108.10370407104493],[611.9010131835938,108.13058624267579],[611.4678771972657,108.14694213867188],[611.0343566894531,108.15149459838868],[610.6009460449219,108.14440155029297],[610.1678100585938,108.1243034362793],[609.7356079101563,108.09106979370118],[609.3047241210937,108.04371185302735],[608.8757080078125,107.98174896240235],[608.4491638183594,107.90414428710938],[608.0259704589844,107.81038284301758],[607.6067321777344,107.7000732421875],[607.1913391113281,107.57573547363282],[606.7801208496094,107.43852310180664],[606.3731872558594,107.2890609741211],[605.9708129882813,107.12789840698242],[605.5729431152344,106.95566024780274],[605.179852294922,106.77292327880859],[604.791650390625,106.5800033569336],[604.4081176757812,106.37774505615235],[604.0295288085938,106.16652603149414],[603.6558288574219,105.94679260253906],[603.2870727539063,105.71897048950196],[602.9231506347656,105.48343048095704],[602.5640075683594,105.24059143066407],[602.2097534179687,104.99077606201172],[601.8601135253906,104.73424530029297],[601.5154174804687,104.4714111328125],[601.1772583007813,104.20015869140626],[600.8460754394531,103.9203712463379],[600.521649169922,103.63286590576172],[600.2038146972657,103.33804092407227],[599.8921875,103.03664474487304],[599.5862731933594,102.72934341430664],[599.2858520507813,102.41684417724609],[598.9907043457032,102.09935989379883],[598.6996765136719,101.77805786132812],[598.41298828125,101.45283508300781],[598.1298706054688,101.12457733154297],[597.849609375,100.79373092651367],[597.5723693847657,100.46040573120118],[597.2970520019531,100.12544631958008],[597.0237121582031,99.7890106201172],[596.7510314941406,99.45190887451172],[596.4791198730469,99.11426467895508],[596.2073181152344,98.77661361694337],[595.9350769042969,98.4392921447754],[595.6621215820313,98.10225906372071],[595.3875183105469,97.76686019897461],[595.1110473632813,97.43286895751953],[594.83232421875,97.10083465576172],[594.5529968261719,96.76929473876953],[594.2748779296875,96.43678665161133],[593.9976379394532,96.10346832275391],[593.7212219238281,95.76937408447266],[593.4457946777344,95.4346206665039],[593.1714111328125,95.09892654418945],[592.8977966308594,94.7626350402832],[592.6250061035156,94.42576675415039],[592.3528747558594,94.08828048706054],[592.0816772460938,93.75002517700196],[591.8113037109375,93.41098022460938],[591.5415344238281,93.07161941528321],[591.2717651367187,92.73226547241211],[591.0034790039062,92.3917236328125],[590.7354125976562,92.05103073120118],[590.4675659179687,91.71020736694337],[590.2009826660156,91.36835403442383],[589.9342895507813,91.02641143798829],[589.6681457519531,90.68417358398438],[589.4028259277344,90.34132461547851],[589.1375061035156,89.99846878051758],[588.872900390625,89.65513916015625],[588.6086791992187,89.31141815185548],[588.3445129394531,88.96769714355469],[588.0809509277344,88.62327575683594],[587.8177185058594,88.27881317138672],[587.554541015625,87.93435058593751],[587.2924072265625,87.58909149169922],[587.0303283691406,87.24375],[586.7683044433594,86.89841537475586],[586.5062255859375,86.55308074951172],[586.2440917968751,86.20764999389648],[585.982342529297,85.86207504272461],[585.7213073730469,85.51597137451172],[585.4602172851563,85.16986083984375],[585.1991821289063,84.82375717163086],[584.9381469726562,84.47764663696289],[584.6770568847656,84.13154296875],[584.4161865234375,83.78506164550781],[584.1555358886719,83.43864212036134],[583.8948852539063,83.09222259521485],[583.6342895507813,82.74580307006836],[583.3736389160157,82.39939041137696],[583.1129882812501,82.05304641723633],[582.8521179199219,81.70677795410157],[582.5912475585938,81.36042022705078],[582.3303771972656,81.01414489746094],[582.0695617675782,80.66787643432617],[581.8087463378906,80.32160797119141],[581.547216796875,79.97574462890626],[581.2855224609375,79.63010787963867],[581.023828125,79.2844711303711],[580.7621337890625,78.93874511718751],[580.5004394531251,78.59310836791992],[580.2383056640625,78.24790420532227],[579.9755126953125,77.90308456420898],[579.7127746582031,77.55827178955079],[579.4491577148438,77.214111328125],[579.1854309082031,76.87004013061524],[578.9212097167969,76.52628479003907],[578.6562194824219,76.18305816650391],[578.3912841796875,75.8399139404297],[578.1250305175781,75.49779968261718],[577.8586669921875,75.15578842163086],[577.5914245605469,74.81440200805665],[577.3233032226562,74.47370910644531],[577.0550720214844,74.1332633972168],[576.7853576660157,73.7936279296875],[576.5147094726562,73.45495376586915],[576.2430725097656,73.11717224121094],[575.9702819824219,72.78021469116212],[575.6962829589844,72.44427337646485],[575.4209655761719,72.10941696166992],[575.1441101074219,71.77576217651368],[574.8656616210938,71.44341201782227],[574.5854553222656,71.1126205444336],[574.303271484375,70.78344268798828],[574.0189453125,70.45615310668946],[573.7322570800782,70.13101959228516],[573.4428222656251,69.80827560424805],[573.1502014160156,69.48840866088868],[572.8430236816406,69.18243255615235],[572.5152465820313,68.89883422851562],[572.1697814941407,68.63709182739258],[571.8094848632812,68.39620971679688],[571.4368835449219,68.17471160888672],[571.053955078125,67.97151260375976],[570.6626770019532,67.78513641357422],[570.2643127441406,67.6139419555664],[569.8601806640626,67.45706405639649],[569.4513244628906,67.31290283203126],[569.0385681152344,67.18028411865235],[568.6225708007813,67.05827407836914],[568.2039367675782,66.94584274291992],[567.7829956054687,66.84193267822266],[567.3601318359375,66.7458984375],[566.9360595703125,66.65629806518555],[566.5105590820312,66.57298736572265],[566.0841796875001,66.49482650756836],[565.6569763183594,66.42099838256836],[565.2283996582031,66.35637817382813],[564.797900390625,66.30464630126953],[564.3660827636719,66.26517105102539],[563.93349609375,66.23761596679688],[563.5003051757812,66.22177505493164],[563.0667846679688,66.21703033447265],[562.6333190917969,66.22310028076173],[562.2001831054688,66.2396827697754],[561.7673767089844,66.2662353515625],[561.3353393554688,66.30264129638672],[560.9042358398438,66.34854354858399],[560.4742309570313,66.40320053100587],[560.0454895019532,66.46703796386718],[559.6179565429687,66.53930740356445],[559.1920715332031,66.6196792602539],[558.7676147460937,66.70797500610352],[558.3446960449219,66.80400924682617],[557.9238647460937,66.90797424316406],[557.5053955078125,67.02128448486329],[557.0895629882813,67.14363098144531],[556.6762573242188,67.27451934814454],[556.2656433105469,67.41348266601562],[555.857666015625,67.56000595092773],[555.4521057128907,67.7136703491211],[555.0493469238281,67.8738166809082],[554.6489501953125,68.04005355834961],[554.2509155273438,68.21185913085938],[553.8551879882813,68.3887321472168],[553.4614379882813,68.57034301757812],[553.0697204589844,68.7560806274414],[552.6797607421876,68.94553298950196],[552.2914489746094,69.13832931518554],[551.9045104980469,69.33378982543945],[551.5187255859375,69.531591796875],[551.1339843750001,69.73133697509766],[550.7500122070313,69.93255844116212],[550.36669921875,70.13503646850586],[549.9835510253906,70.33809127807618],[549.6005126953125,70.5411735534668],[549.217529296875,70.7443244934082],[548.8343811035156,70.94709777832031],[548.4505737304688,71.14886169433593],[548.066162109375,71.34927291870117],[547.6808715820313,71.54790573120117],[547.2944274902344,71.74444427490235],[546.9066650390625,71.9384147644043],[546.5173645019531,72.12924728393556],[546.1264709472656,72.31650924682617],[545.733544921875,72.49984359741211],[545.3386413574219,72.67877655029297],[544.9415954589844,72.85277252197265],[544.542626953125,73.02274475097657],[544.143603515625,73.19215393066406],[543.7445251464844,73.36156311035157],[543.3448974609375,73.52943420410156],[542.9451049804687,73.69705810546876],[542.5452575683594,73.86467514038087],[542.1449157714844,74.03078155517578],[541.7442993164062,74.19681243896484],[541.34384765625,74.36280212402345],[540.9426818847656,74.52735671997071],[540.5415710449219,74.69185638427734],[540.1405151367188,74.85627365112305],[539.7388549804688,75.01944122314454],[539.3372497558594,75.18260879516602],[538.9353698730469,75.34570770263672],[538.5332153320313,75.50768051147462],[538.1311157226563,75.6696533203125],[537.7289611816407,75.83141326904297],[537.3264221191406,75.99233551025391],[536.9238830566406,76.15325775146485],[536.5211791992188,76.31397399902345],[536.1182006835937,76.4740379333496],[535.7152770996094,76.63406753540039],[535.3122436523438,76.7937744140625],[534.908935546875,76.95274658203125],[534.5055725097657,77.11171875000001],[534.1022644042969,77.27069091796875],[533.6989562988282,77.4296630859375],[533.2955383300781,77.58867645263672],[532.8921203613281,77.74722290039062],[532.488427734375,77.90529556274414],[532.0847900390626,78.06336822509766],[531.6810974121094,78.22144088745118],[531.2774047851562,78.37950668334962],[530.8737670898438,78.53757934570312],[530.4699096679688,78.69561767578125],[530.066162109375,78.8535255432129],[529.6624694824219,79.01144027709961],[529.2587219238281,79.16935501098634],[528.8549743652344,79.32726974487305],[528.4512268066406,79.48518447875976],[528.0474792480469,79.64309921264649],[527.6436767578125,79.80105514526367],[527.2399291992188,79.95896987915039],[526.836181640625,80.11688461303712],[526.4324340820312,80.27479934692383],[526.0287414550781,80.43271408081056],[525.6253784179688,80.59149398803712],[525.2220703125,80.75047302246094],[524.81865234375,80.90949325561523],[524.4155090332032,81.06897354125977],[524.0125305175782,81.2289207458496],[523.6096069335938,81.38886795043946],[523.2067382812501,81.54897994995117],[522.8041442871094,81.70975112915039],[522.4015502929688,81.8705223083496],[521.9988464355469,82.0313346862793],[521.5962524414062,82.19210586547852],[521.193603515625,82.35287017822266],[520.7910095214844,82.51364135742188],[520.3884704589844,82.67446746826172],[519.9858764648437,82.83533477783203],[519.5832824707031,82.99620208740235],[519.1806335449219,83.15711059570313],[518.7780944824219,83.31797790527344],[518.3755004882813,83.47884521484376],[517.9729064941406,83.63971252441407],[517.5700927734375,83.79994125366211],[517.1672241210938,83.96013565063477],[516.7644104003906,84.12032318115234],[516.3612121582031,84.2800163269043],[515.9580688476562,84.43936614990234],[515.5548706054688,84.5987159729004],[515.1515625000001,84.75766067504883],[514.7479248046875,84.9158432006836],[514.3443420410157,85.07403259277343],[513.940594482422,85.23219451904298],[513.536297607422,85.38896255493164],[513.1321105957031,85.54568939208984],[512.7279235839844,85.70241622924804],[512.323406982422,85.85818862915039],[511.9186157226563,86.0135971069336],[511.5135498046875,86.16806488037109],[511.10837402343753,86.32210693359376],[510.70281372070315,86.47559280395508],[510.2970336914063,86.62819290161133],[509.89108886718753,86.78040847778321],[509.48475952148436,86.93155288696289],[509.07826538085936,87.08211364746094],[508.67149658203124,87.2319808959961],[508.26428833007816,87.3807975769043],[507.85691528320314,87.52914733886719],[507.44910278320316,87.67624740600586],[507.041015625,87.82264022827148],[506.6326538085938,87.96824340820312],[506.22385253906253,88.112548828125],[505.81483154296876,88.25629806518555],[505.40537109375003,88.39864654541016],[504.9955261230469,88.54013671875],[504.58546142578126,88.68076858520509],[504.1748474121094,88.82004089355469],[503.76428833007816,88.95899047851563],[503.3531799316406,89.0966423034668],[502.9420166015625,89.23395767211915],[502.53046875,89.3702980041504],[502.1186462402344,89.50609588623047],[501.7066589355469,89.6411247253418],[501.29445190429686,89.775350189209],[500.882080078125,89.9091293334961],[500.46943359375,90.04185791015625],[500.05662231445314,90.17435302734376],[499.64353637695314,90.30571517944337],[499.23017578125,90.43683013916016],[498.81670532226565,90.56704559326172],[498.40296020507816,90.69680786132812],[497.9891052246094,90.82592468261718],[497.57508544921876,90.9543342590332],[497.16090087890626,91.082373046875],[496.74644165039064,91.20956039428711],[496.3318725585938,91.33656234741211],[495.9170837402344,91.46257553100587],[495.5022399902344,91.58836212158204],[495.0871215820313,91.71341400146484],[494.6718383789063,91.83810882568359],[494.25644531250003,91.96224746704102],[493.8409423828125,92.08555526733399],[493.42510986328125,92.20842361450195],[493.00933227539065,92.33126449584961],[492.5935546875,92.45408477783204],[492.1773376464844,92.57531204223633],[491.76112060546876,92.69654617309571],[491.34490356445315,92.81777343750001],[490.928466796875,92.93841018676758],[490.51170043945314,93.05822296142578],[490.0950439453125,93.1780014038086],[489.6783874511719,93.29777297973634],[489.2615112304688,93.41649398803712],[488.84447021484374,93.53496780395508],[488.42742919921875,93.65344161987305],[488.01038818359376,93.77167510986328],[487.5929626464844,93.8890365600586],[487.17564697265624,94.0063705444336],[486.75827636718753,94.12369766235352],[486.3407409667969,94.24044799804688],[485.923095703125,94.35678634643556],[485.50550537109376,94.47312469482422],[485.0878601074219,94.58946304321289],[484.6698852539063,94.70501174926758],[484.2520202636719,94.8205192565918],[483.83421020507814,94.93601989746094],[483.41623535156253,95.05115661621095],[482.99815063476564,95.1657096862793],[482.58001098632815,95.28026962280273],[482.16192626953125,95.3948226928711],[481.7436767578125,95.50941009521485],[481.3255920410156,95.6239631652832],[480.90745239257814,95.73852310180665],[480.48931274414065,95.8528221130371],[480.0708435058594,95.96599502563477],[479.6523742675781,96.07916107177735],[479.2338500976563,96.19232711791993],[478.81483154296876,96.30408554077148],[478.3958679199219,96.41549377441406],[477.97690429687503,96.52689514160157],[477.5578308105469,96.63748626708984],[477.138427734375,96.74725341796875],[476.7190246582031,96.85702743530274],[476.29956665039066,96.9665885925293],[475.8796691894531,97.07486572265626],[475.4598815917969,97.18312225341798],[475.04009399414065,97.29137878417968],[474.61997680664064,97.39852981567383],[474.19980468750003,97.50537872314453],[473.7796325683594,97.61222076416016],[473.3594604492188,97.71847915649414],[472.93884887695316,97.82407150268556],[472.5184020996094,97.92964324951173],[472.097900390625,98.0350845336914],[471.6771240234375,98.1394889831543],[471.25634765625,98.24389343261718],[470.83562622070315,98.34829788208008],[470.4146301269531,98.45190582275391],[469.9935241699219,98.55528030395509],[469.5724731445313,98.65863418579102],[469.1513671875,98.76161041259766],[468.7300964355469,98.86403732299804],[468.3088806152344,98.96646423339844],[467.88755493164064,99.06884994506837],[467.46611938476565,99.17047348022462],[467.04457397460936,99.27213134765626],[466.6231384277344,99.37376174926759],[466.2015380859375,99.47468490600586],[465.7798278808594,99.5753402709961],[465.35817260742186,99.6760025024414],[464.9365173339844,99.77665786743164],[464.5148071289063,99.87732009887695],[464.0930419921875,99.9780029296875],[463.67138671875,100.07861709594727],[463.24951171875,100.17838668823242],[462.82763671875,100.27815628051758],[462.40576171875,100.37791900634765],[461.98388671875,100.47768859863281],[461.5619567871094,100.5774513244629],[461.1399719238281,100.67724151611328],[460.7180969238281,100.7768669128418],[460.2961120605469,100.87622451782227],[459.87412719726564,100.97558898925782],[459.4521423339844,101.07494659423828],[459.03015747070316,101.17430419921875],[458.60817260742186,101.27366180419922],[458.1861053466797,101.373046875],[457.76414794921874,101.47245254516602],[457.3421905517578,101.57188568115235],[456.9202056884766,101.6713119506836],[456.4982482910156,101.77074508666992],[456.0762908935547,101.87017135620117],[455.6543334960938,101.9696044921875],[455.2323486328125,102.06903762817383],[454.8104187011719,102.16902008056641],[454.3885986328125,102.26900939941406],[453.96677856445314,102.36899185180664],[453.54493103027346,102.4689811706543],[453.12311096191405,102.56896362304688],[452.7012634277344,102.66895294189453],[452.27947082519535,102.76913452148438],[451.8577056884766,102.86985855102539],[451.43605041503906,102.97056198120117],[451.0143676757813,103.07125854492188],[450.592822265625,103.17255935668946],[450.1713317871094,103.2739013671875],[449.74981384277345,103.37524337768555],[449.3284057617188,103.47702484130859],[448.90697021484374,103.57914962768555],[448.48564453125,103.68124008178711],[448.06431884765624,103.78356399536133],[447.643212890625,103.8865333557129],[447.2220794677734,103.98950958251953],[446.8009735107422,104.09248580932618],[446.3801696777344,104.19632720947266],[445.9592010498047,104.30031967163086],[445.53831481933594,104.40429153442383],[445.11753845214844,104.50889511108399],[444.69695434570315,104.61397933959961],[444.27634277343753,104.71907043457031],[443.85589599609375,104.82439498901367],[443.4356140136719,104.93072204589843],[443.0152221679688,105.03706970214844],[442.5949401855469,105.14339675903321],[442.1749603271484,105.25088424682617],[441.7550079345703,105.35855712890626],[441.3350830078125,105.4662368774414],[440.9153503417969,105.57466506958008],[440.4958099365235,105.68382110595704],[440.0761322021485,105.79299774169922],[439.65667419433595,105.90242156982423],[439.2375183105469,106.01316375732422],[438.8183898925781,106.1239128112793],[438.3992614746094,106.2346549987793],[437.9804626464844,106.34681854248048],[437.56177368164066,106.45927734375],[437.14300231933595,106.57175674438477],[436.7244506835938,106.6848747253418],[436.3061187744141,106.79868621826172],[435.88811645507815,106.91323242187501],[435.4700866699219,107.02791595458984],[435.0517822265625,107.14208450317383],[434.63312072753905,107.25459136962891],[434.2139099121094,107.36553955078125],[433.79478149414064,107.47613067626953],[433.3752410888672,107.58530044555664],[432.95570068359376,107.69429168701173],[432.5359130859375,107.80264434814454],[432.11607055664064,107.91103820800781],[431.696337890625,108.0194938659668],[431.2765777587891,108.12821044921876],[430.85711975097655,108.23770294189454],[430.4377716064453,108.3475112915039],[430.0186981201172,108.45867233276367],[429.6000640869141,108.57109680175782],[429.1817321777344,108.68506622314453],[428.7640319824219,108.80075225830079],[428.34666137695314,108.91847763061524],[427.93003234863284,109.0384002685547],[427.5141998291016,109.16076049804688],[427.09905395507815,109.28583984375],[426.68486938476565,109.4138168334961],[426.27153625488285,109.54467086791992],[425.8594665527344,109.67916412353516],[425.4484130859375,109.81731033325195],[425.0388153076172,109.95927429199219],[424.6306457519531,110.10528259277343],[424.22401428222656,110.25558929443359],[423.8190582275391,110.41039352416992],[423.4159149169922,110.56993560791015],[423.01477661132816,110.73439407348633],[422.61569824218753,110.9040023803711],[422.2190368652344,111.07879486083985],[421.82374877929686,111.2567527770996],[421.4300811767578,111.43824691772461],[421.0378692626953,111.62302322387696],[420.6472503662109,111.81099243164063],[420.2584167480469,112.00271072387696],[419.87131347656253,112.1980339050293],[419.48602294921875,112.39678344726563],[419.10276489257814,112.5994743347168],[418.72162170410155,112.80603103637695],[418.34253845214846,113.01626815795899],[417.96567993164064,113.23064575195313],[417.5913757324219,113.44921188354492],[417.2192413330078,113.67178802490234],[416.8496887207031,113.89848403930664],[416.4829376220703,114.12964324951172],[416.1189880371094,114.36528625488282],[415.7580047607422,114.6052619934082],[415.40009765625,114.84989318847657],[415.0454040527344,115.09913177490235],[414.6938690185547,115.35306701660157],[414.3460144042969,115.61179504394532],[414.00181274414064,115.8753158569336],[413.66126403808596,116.14361572265625],[413.32483520507816,116.41692810058593],[412.99090576171875,116.69342651367188],[412.659750366211,116.97308349609375],[412.33095703125,117.25587158203125],[412.00562438964846,117.54232635498047],[411.68345031738284,117.8324203491211],[411.3650665283203,118.12670288085938],[411.0507476806641,118.4252426147461],[410.7406860351563,118.72821807861328],[410.4355682373047,119.0360824584961],[410.13547668457034,119.34917907714843],[409.84112548828125,119.66739807128907],[409.55287170410156,119.9912612915039],[409.2712371826172,120.32078247070312],[408.9966613769531,120.65622253417969],[408.729638671875,120.99773254394532],[408.47071838378906,121.34535369873048],[408.22039489746095,121.69949798583984],[407.9794647216797,122.05982208251953],[407.7483673095703,122.42665557861328],[407.5278717041016,122.79986114501953],[407.3181427001953,123.17931518554688],[407.1183288574219,123.56391906738281],[406.92796325683594,123.9534393310547],[406.74704589843753,124.34747772216797],[406.5749725341797,124.745361328125],[406.4116882324219,125.14698028564453],[406.2565612792969,125.55177154541016],[406.10950927734376,125.95961151123048],[405.96979064941405,126.36993713378907],[405.83737792968753,126.78277587890625],[405.711474609375,127.19771575927734],[405.59205322265626,127.6144271850586],[405.47837219238284,128.03274536132812],[405.37034912109374,128.45260162353517],[405.26718750000003,128.8736801147461],[405.16907958984376,129.2960220336914],[405.074789428711,129.71911926269533],[404.9846466064453,130.14330139160157],[404.8979919433594,130.56801910400392],[404.8142486572266,130.99339599609377],[404.7331146240235,131.41928100585938],[404.6544525146484,131.84555053710938],[404.5778778076172,132.27223205566406],[404.50245666503906,132.69913330078126],[404.4282165527344,133.12644653320314],[404.3546905517578,133.55367736816407],[404.28577880859376,133.98164978027344],[404.2234313964844,134.41073455810547],[404.1674835205078,134.84054718017578],[404.1173858642578,135.27119750976564],[404.0729461669922,135.70238342285157],[404.03375244140625,136.13426971435547],[403.99903564453126,136.56638946533204],[403.96929016113285,136.99886627197267],[403.94341735839845,137.43157653808595],[403.9213073730469,137.8645477294922],[403.9028228759766,138.29771118164064],[403.8871673583985,138.73097076416016],[403.87445068359375,139.16439514160157],[403.8639587402344,139.59776458740234],[403.8558563232422,140.03123016357424],[403.84885253906253,140.4646408081055],[403.8432220458985,140.89812011718752],[403.83904724121095,141.3317092895508],[403.835009765625,141.76520233154298],[403.8309997558594,142.19876403808595],[403.82715454101566,142.63227081298828],[403.8227874755859,143.0657913208008],[403.817953491211,143.49927062988283],[403.81251525878906,143.932763671875],[403.80710449218753,144.36624298095703],[403.80169372558595,144.79973602294922],[403.79680480957035,145.23333892822265],[403.7921905517578,145.66681823730468],[403.7886199951172,146.10032501220704],[403.78565368652346,146.53380432128907],[403.7837585449219,146.96732482910156],[403.7832366943359,147.4008316040039],[403.78342895507814,147.8343521118164],[403.78565368652346,148.26798248291016],[403.78960876464845,148.70157165527345],[403.7954315185547,149.135009765625],[403.8032592773438,149.56846160888674],[403.8132568359375,150.00189971923828],[403.8256439208985,150.4352554321289],[403.84080505371094,150.86844635009766],[403.8586853027344,151.30171966552734],[403.87944946289065,151.7347869873047],[403.90320739746096,152.16763458251953],[403.93015136718753,152.60024871826172],[403.9607208251953,153.03275299072266],[403.9950256347656,153.46485900878906],[404.0330383300781,153.89674530029296],[404.0749237060547,154.328288269043],[404.1208465576172,154.75936431884767],[404.1709716796875,155.1900146484375],[404.2243377685547,155.6202392578125],[404.27943420410156,156.05029907226563],[404.33628845214844,156.4800018310547],[404.3950103759766,156.90953979492187],[404.45562744140625,157.33887176513673],[404.51816711425784,157.76792907714844],[404.58273925781253,158.19661560058594],[404.6493713378906,158.62494506835938],[404.7181732177734,159.05301361083986],[404.789144897461,159.48067016601564],[404.8623413085938,159.9079559326172],[404.9378997802734,160.33496704101563],[405.0158203125,160.76134643554687],[405.0961853027344,161.18743743896485],[405.1790222167969,161.6129104614258],[405.26441345214846,162.03793029785157],[405.35246887207035,162.46246948242188],[405.4431610107422,162.88636322021486],[405.5366546630859,163.3097900390625],[405.63294982910156,163.73240661621094],[405.7321014404297,164.154460144043],[405.8341918945313,164.5758270263672],[405.9392486572266,164.99646606445313],[406.0474090576172,165.41617126464845],[406.1587829589844,165.8352035522461],[406.2733428955078,166.25338439941407],[406.3911437988281,166.6705764770508],[406.5122406005859,167.08682098388672],[406.6366882324219,167.5021179199219],[406.7645690917969,167.91638488769533],[406.89593811035155,168.3295120239258],[407.03082275390625,168.7415542602539],[407.1693328857422,169.15247039794923],[407.3113037109375,169.56209564208984],[407.45549926757815,169.9709655761719],[407.60194702148436,170.3789291381836],[407.7511413574219,170.78601379394533],[407.90297241210936,171.19208221435548],[408.0574676513672,171.59707946777345],[408.21490173339845,172.0011428833008],[408.3752746582031,172.4039291381836],[408.5387237548828,172.80541076660157],[408.7054138183594,173.20561523437502],[408.8755645751953,173.60433654785157],[409.04945068359376,174.00149230957032],[409.2266876220703,174.39705505371094],[409.40785217285156,174.79102478027343],[409.5929718017578,175.18308563232424],[409.78212890625,175.57316894531252],[409.97540588378905,175.96119232177736],[410.1728851318359,176.34712829589844],[410.37489624023436,176.73072967529296],[410.5814117431641,177.11180419921877],[410.7926513671875,177.49055786132814],[411.0084503173828,177.86648254394532],[411.229330444336,178.23949584960937],[411.45518188476564,178.6095977783203],[411.6860046386719,178.97655487060547],[411.9220733642578,179.3401336669922],[412.16355285644534,179.70018310546877],[412.41038818359374,180.0567169189453],[412.6629089355469,180.40911712646485],[412.9236694335938,180.75543365478515],[413.19272460937503,181.09528198242188],[413.4696075439453,181.42892303466797],[413.753466796875,181.75650787353516],[414.04416503906253,182.0782012939453],[414.3408233642578,182.3943878173828],[414.6432220458984,182.70508117675783],[414.9503997802735,183.01092681884765],[415.26202697753905,183.31221313476564],[415.5781585693359,183.6088851928711],[415.89788818359375,183.9017120361328],[416.22080383300784,184.1909957885742],[416.54685058593753,184.47687377929688],[416.8753143310547,184.75979919433595],[417.20586547851565,185.0401840209961],[417.53831176757814,185.31842651367188],[417.87232360839846,185.59482879638674],[418.20737915039064,185.86988525390626],[418.5436706542969,186.1434310913086],[418.88364257812503,186.41267852783204],[419.2266357421875,186.6778060913086],[419.5731170654297,186.9382781982422],[419.92234497070314,187.19512481689455],[420.2745391845703,187.4480163574219],[420.6291229248047,187.69739227294923],[420.9860412597656,187.94344482421874],[421.3452392578125,188.18636627197267],[421.7061401367188,188.42644500732422],[422.0690460205078,188.66368103027344],[422.4332977294922,188.8986373901367],[422.7991149902344,189.1312454223633],[423.1663330078125,189.3617660522461],[423.5343475341797,189.59080352783204],[423.9034057617188,189.81859130859377],[424.2731506347656,190.0449645996094],[424.6434997558594,190.27015686035156],[425.014453125,190.49463500976563],[425.3855712890625,190.71868743896485],[425.75668945312503,190.94275360107423],[426.12769775390626,191.16699829101563],[426.4988159179688,191.39129791259765],[426.86987915039066,191.6155563354492],[427.2409698486328,191.83969116210938],[427.6123352050781,192.0632080078125],[427.9841674804688,192.28625793457033],[428.35663146972655,192.5080993652344],[428.72986450195316,192.72848510742188],[429.1038391113281,192.94793701171875],[429.4790771484375,193.1652053833008],[429.85535888671876,193.38049621582033],[430.23309631347655,193.5930953979492],[430.6123443603516,193.80327758789062],[430.99304809570316,194.0105758666992],[431.3757019042969,194.21435852050783],[431.7600036621094,194.4148178100586],[432.1464752197266,194.61148681640626],[432.5350616455078,194.8038299560547],[432.9255706787109,194.99197082519532],[433.31846923828124,195.17534637451172],[433.7135375976563,195.35354461669922],[434.11121520996096,195.52642822265625],[434.51117248535155,195.69344787597657],[434.913656616211,195.85507049560547],[435.3170471191406,196.0138916015625],[435.72128906250003,196.1704330444336],[436.126547241211,196.32451629638672],[436.53235473632816,196.4768829345703],[436.9388763427734,196.6273956298828],[437.3463592529297,196.77532653808595],[437.75474853515624,196.92137603759767],[438.16354980468753,197.06564025878907],[438.57292785644535,197.2081741333008],[438.9832397460938,197.34815368652343],[439.39401855468753,197.48648529052736],[439.80548400878905,197.62325134277344],[440.2174438476563,197.75828704833984],[440.6302001953125,197.89112548828126],[441.0432861328125,198.02242584228517],[441.4570037841797,198.15232543945314],[441.8711334228516,198.28050842285157],[442.28578491210936,198.4067825317383],[442.70090332031253,198.53173828125],[443.11643371582034,198.65537567138674],[443.5325408935547,198.77740631103515],[443.9489776611328,198.89785766601562],[444.3657989501953,199.0170867919922],[444.7829498291016,199.13516235351562],[445.2005126953125,199.2516860961914],[445.6183776855469,199.36690521240234],[446.03662719726566,199.4811218261719],[446.45517883300784,199.59430847167968],[446.8740600585938,199.70602569580078],[447.29318847656253,199.81675415039064],[447.7125640869141,199.92657623291015],[448.1321594238281,200.03550567626954],[448.55211181640624,200.14317169189454],[448.9722839355469,200.25006866455078],[449.39275817871095,200.3561004638672],[449.8134246826172,200.46086883544922],[450.2340911865235,200.5656509399414],[450.6550598144531,200.66937561035158],[451.0761932373047,200.77222137451173],[451.4973541259766,200.87506713867188],[451.9187896728516,200.97655334472657],[452.3404174804688,201.07779235839845],[452.76201782226565,201.1788803100586],[453.18389282226565,201.2787872314453],[453.6057403564453,201.37869415283203],[454.027670288086,201.47823028564454],[454.4497375488281,201.57716217041016],[454.87183227539066,201.67609405517578],[455.29411926269535,201.77447662353515],[455.71640625000003,201.8725570678711],[456.1386932373047,201.97063751220705],[456.5609527587891,202.06871795654297],[456.9832397460938,202.16679840087892],[457.4055541992188,202.26487884521484],[457.8278411865235,202.362890625],[458.2502655029297,202.46092987060547],[458.6725524902344,202.55894165039064],[459.0948394775391,202.65695343017578],[459.51715393066405,202.75496520996094],[459.93922119140626,202.8535400390625],[460.36134338378906,202.9522933959961],[460.78354797363284,203.05112915039064],[461.2055603027344,203.15081634521485],[461.627490234375,203.25047607421877],[462.04920043945316,203.3505615234375],[462.4708557128906,203.4514572143555],[462.8924560546875,203.55235290527344],[463.3138366699219,203.65422363281252],[463.7350524902344,203.75667114257814],[464.15643310546875,203.85914611816406],[464.5772644042969,203.96331024169922],[464.998095703125,204.0676254272461],[465.41870727539066,204.1722427368164],[465.83909912109374,204.27813720703125],[466.25921630859375,204.38502044677736],[466.6791687011719,204.4927001953125],[467.09901123046876,204.6012176513672],[467.51841430664064,204.7108612060547],[467.9375427246094,204.8215759277344],[468.35650634765625,204.933251953125],[468.7751403808594,205.04586181640624],[469.19333496093753,205.15996856689455],[469.61130981445314,205.27521514892578],[470.02906494140626,205.39156036376954],[470.4463806152344,205.50897674560548],[470.86309204101565,205.62817840576173],[471.2796936035156,205.74813537597657],[471.6961303710938,205.8685317993164],[472.1126220703125,205.98892822265626],[472.52905883789066,206.1093246459961],[472.94566040039064,206.22976226806642],[473.3621520996094,206.35015869140625],[473.7785888671875,206.4705551147461],[474.194970703125,206.59113006591798],[474.6112976074219,206.7120346069336],[475.0276245117188,206.83295288085938],[475.443896484375,206.953857421875],[475.86033325195314,207.07478942871094],[476.27666015625,207.19570770263672],[476.6929870605469,207.31661224365234],[477.10931396484375,207.4375991821289],[477.5254211425781,207.5590805053711],[477.94158325195315,207.68054809570313],[478.3577453613281,207.80202941894532],[478.7740173339844,207.9235382080078],[479.1901794433594,208.04501953125],[479.60634155273436,208.1665008544922],[480.02244873046874,208.28796844482423],[480.4385559082031,208.41004028320313],[480.85449829101566,208.53213958740236],[481.27049560546874,208.6542526245117],[481.6865478515625,208.77639312744142],[482.10254516601566,208.89850616455078],[482.51848754882815,209.02060546875],[482.93442993164064,209.1427185058594],[483.35020751953124,209.26522979736328],[483.7659851074219,209.38802947998047],[484.1817626953125,209.5108154296875],[484.59759521484375,209.633642578125],[485.0133728027344,209.7564422607422],[485.429150390625,209.8792282104492],[485.8449279785156,210.0020278930664],[486.2606506347656,210.12512969970703],[486.67620849609375,210.24867095947266],[487.0917663574219,210.3722122192383],[487.50743408203124,210.49578094482422],[487.9229370117188,210.61932220458985],[488.3384948730469,210.74286346435548],[488.754052734375,210.8664047241211],[489.1695556640625,210.99006958007814],[489.5848388671875,211.11440734863282],[490.00017700195315,211.23875885009767],[490.4155700683594,211.3631378173828],[490.83090820312503,211.48747558593752],[491.24619140625003,211.6118133544922],[491.66147460937503,211.73616485595704],[492.0768127441406,211.86050262451172],[492.4918212890625,211.98560943603516],[492.906884765625,212.1108123779297],[493.32200317382814,212.2360565185547],[493.73706665039066,212.36125946044922],[494.1521301269531,212.48646240234376],[494.56719360351565,212.61166534423828],[494.9822021484375,212.73688201904298],[495.39710083007816,212.8626892089844],[495.8118896484375,212.9888122558594],[496.22678833007814,213.11497650146484],[496.6415222167969,213.24109954833986],[497.0563110351563,213.36722259521486],[497.4710998535156,213.49334564208985],[497.8858337402344,213.61946868896484],[498.30040283203124,213.74596252441407],[498.71486206054686,213.87306060791016],[499.1294311523438,214.0001998901367],[499.5438903808594,214.1272979736328],[499.9584045410156,214.2543960571289],[500.37286376953125,214.38150787353516],[500.7873229980469,214.50860595703125],[501.2017822265625,214.63589630126953],[501.615966796875,214.7640380859375],[502.03020629882815,214.89219360351564],[502.44439086914065,215.0203353881836],[502.8585205078125,215.14847717285156],[503.2726501464844,215.27660522460937],[503.6868347167969,215.40474700927734],[504.10096435546876,215.53287506103516],[504.5148193359375,215.66201934814453],[504.92872924804686,215.79127349853516],[505.342529296875,215.92050018310547],[505.75632934570314,216.04974060058595],[506.17018432617186,216.17896728515626],[506.583984375,216.30819396972657],[506.99778442382814,216.4374206542969],[507.41130981445315,216.56741638183595],[507.82489013671875,216.69782409667968],[508.2383605957031,216.82820434570314],[508.6517761230469,216.95858459472657],[509.06524658203125,217.08896484375],[509.4787170410156,217.21934509277344],[509.8921325683594,217.34972534179687],[510.3053833007813,217.48059997558593],[510.7185791015625,217.61221618652345],[511.13161010742186,217.74380493164062],[511.54469604492186,217.87539367675782],[511.95778198242186,218.00696868896486],[512.3708129882813,218.13855743408203],[512.7838989257813,218.27014617919923],[513.1969848632813,218.40191345214845],[513.6098510742188,218.53447723388672],[514.022607421875,218.66699981689453],[514.4353637695312,218.79952239990234],[514.8480102539063,218.9324157714844],[515.260546875,219.06558380126953],[515.6731384277344,219.19876556396486],[516.0856750488282,219.33194732666016],[516.4981567382813,219.4657745361328],[516.9105285644531,219.59961547851563],[517.3228454589844,219.7334426879883],[517.7351623535156,219.86748962402345],[518.1472595214844,220.00198974609376],[518.5594116210938,220.13650360107422],[518.9715087890626,220.2710174560547],[519.383935546875,220.4048583984375],[519.7967468261719,220.53733978271484],[520.210107421875,220.66802215576172],[520.624072265625,220.79680938720705],[521.0385314941407,220.92397613525392],[521.4532653808594,221.0499481201172],[521.8684936523438,221.17493133544923],[522.2839416503906,221.2990219116211],[522.6997192382813,221.4218765258789],[523.1154418945313,221.54471740722656],[523.5313293457032,221.6672836303711],[523.9472167968751,221.7895065307617],[524.3631591796875,221.91172943115234],[524.7788818359376,222.03452911376954],[525.1947692871094,222.15743865966797],[525.6103271484375,222.28073272705078],[526.0257202148438,222.40497436523438],[526.440673828125,222.5303970336914],[526.8552978515626,222.65704193115235],[527.2694824218751,222.78497772216798],[527.6832275390625,222.91434173583986],[528.096533203125,223.04551849365234],[528.5090148925782,223.1789749145508],[528.9208923339844,223.31449127197266],[529.3320556640625,223.45183410644532],[529.74228515625,223.59204711914063],[530.1514709472657,223.7350616455078],[530.55966796875,223.88094635009767],[530.9668762207032,224.029948425293],[531.3728210449219,224.18235626220704],[531.7774475097657,224.3379364013672],[532.1805358886719,224.49759521484376],[532.5821411132813,224.66078338623046],[532.9820434570313,224.82818756103515],[533.3801330566406,224.99969787597658],[533.77646484375,225.1755615234375],[534.1705993652344,225.35610809326172],[534.5627014160157,225.54102172851563],[534.9522766113281,225.73126373291015],[535.3395446777344,225.92616119384766],[535.7240112304688,226.12634582519533],[536.1057861328126,226.33162536621094],[536.4850341796875,226.5420684814453],[536.8610961914063,226.75775756835938],[537.233807373047,226.97903594970703],[537.6033874511719,227.20575256347658],[537.9694519042969,227.43800354003906],[538.3315063476563,227.67629699707032],[538.6896057128906,227.9206329345703],[539.0436401367188,228.17101135253907],[539.3931701660157,228.42752838134766],[539.7375915527344,228.69076080322267],[540.0770141601563,228.96036529541016],[540.4111633300781,229.23650665283205],[540.7395446777344,229.5194869995117],[541.0618286132812,229.80955352783204],[541.3776306152344,230.10658264160156],[541.6866760253906,230.41068420410156],[541.9883605957032,230.72192687988283],[542.2825744628907,231.04042053222656],[542.570965576172,231.36402282714843],[542.8539184570312,231.69248657226564],[543.1308837890625,232.02600402832033],[543.4021911621094,232.36424560546877],[543.667236328125,232.70726623535157],[543.9255798339844,233.05547790527345],[544.1774963378906,233.4082214355469],[544.4221618652344,233.76610107421877],[544.6593566894531,234.12889709472657],[544.8888610839844,234.49677429199218],[545.1102355957031,234.86956787109375],[545.323095703125,235.24725036621095],[545.5270568847657,235.62979431152345],[545.7217346191406,236.01703491210938],[545.9065795898438,236.40921936035156],[546.0812622070313,236.805908203125],[546.2453979492187,237.20712890625],[546.3981628417969,237.6129364013672],[546.5394470214844,238.02283630371093],[546.6694702148437,238.43641662597656],[546.7881774902344,238.85326538085937],[546.8961730957031,239.27310791015626],[546.9936767578125,239.69550476074218],[547.0807983398438,240.12015380859376],[547.1578125,240.54694519042968],[547.2249389648438,240.9752197265625],[547.2823974609375,241.40492248535156],[547.3304077148438,241.83569641113283],[547.3694641113282,242.26745910644533],[547.3991821289063,242.69996337890626],[547.420166015625,243.13298950195312],[547.4326354980469,243.56645507812502],[547.4365356445313,243.9999206542969],[547.4323608398438,244.43335876464843],[547.4197814941407,244.86671447753906],[547.39951171875,245.29976806640624],[547.3710571289063,245.73238220214844],[547.3355712890625,246.1644470214844],[547.2916259765625,246.59577026367188],[547.2374633789062,247.02588500976563],[547.1728088378907,247.45457153320314],[547.0982116699219,247.8816650390625],[547.0146057128907,248.3070281982422],[546.9222106933594,248.73057861328127],[546.8228393554688,249.1525085449219],[546.7159973144531,249.5726531982422],[546.6034973144532,249.9914520263672],[546.4852294921875,250.4084930419922],[546.3625671386719,250.82427062988282],[546.2358947753906,251.23889465332033],[546.1060363769532,251.65255737304688],[545.9735412597656,252.06534118652345],[545.8396728515626,252.4776580810547],[545.7046508789062,252.8896728515625],[545.5695739746094,253.30160522460938],[545.4345520019532,253.71356506347658],[545.3005187988282,254.1258544921875],[545.1680786132813,254.5386932373047],[545.0384399414063,254.95235595703124],[544.9078125,255.36568908691407],[544.7716369628906,255.77745666503907],[544.6304077148437,256.18727416992186],[544.4844543457032,256.59544372558594],[544.3341064453125,257.0021026611328],[544.1799133300782,257.40727844238285],[544.0220397949219,257.81105346679686],[543.8616394042969,258.21375732421876],[543.6988220214844,258.6156372070313],[543.5339172363282,259.01661071777346],[543.3674194335938,259.4168426513672],[543.1991638183594,259.81638793945314],[543.030908203125,260.2159332275391],[542.8622131347656,260.61528625488285],[542.6933532714844,261.01458435058595],[542.5250427246094,261.41423950195315],[542.3577209472656,261.81414184570315],[542.1918273925781,262.2146209716797],[542.02763671875,262.6158142089844],[541.865643310547,263.01799621582035],[541.7061767578125,263.4211120605469],[541.5500061035157,263.8254638671875],[541.3972961425782,264.2314086914063],[541.2488159179687,264.638671875],[541.10478515625,265.04750061035156],[540.9657531738281,265.4581695556641],[540.8321044921876,265.8705139160156],[540.7044982910156,266.2848358154297],[540.5832092285157,266.7010528564453],[540.4691162109375,267.11943969726565],[540.3626586914063,267.5396392822266],[540.2640563964844,267.9617614746094],[540.1738037109375,268.38580627441405],[540.0925048828125,268.81158142089845],[540.0205444335937,269.23911437988284],[539.9572082519531,269.66791076660155],[539.9005187988281,270.0978057861328],[539.8516296386719,270.5286346435547],[539.8097717285157,270.96001281738285],[539.7751647949219,271.3922149658203],[539.7481384277344,271.8248016357422],[539.7280334472656,272.25791015625003],[539.7161682128907,272.6912384033203],[539.7111145019531,273.12489624023436],[539.7139709472657,273.55836181640626],[539.7245727539063,273.9916900634766],[539.7430297851563,274.4248809814453],[539.7693969726563,274.85760498046875],[539.8036743164063,275.28972473144535],[539.8460266113282,275.7211029052734],[539.8965637207032,276.1517669677734],[539.9553405761719,276.58135986328125],[540.0225769042969,277.0096069335938],[540.0982727050781,277.4364807128906],[540.1825927734375,277.8617340087891],[540.275537109375,278.2851470947266],[540.3762268066406,278.70680236816406],[540.4842224121094,279.12672729492186],[540.5994689941407,279.5446746826172],[540.7219665527344,279.96050720214845],[540.8516052246094,280.37419738769535],[540.9882751464844,280.7856079101563],[541.1321411132812,281.19446411132816],[541.283203125,281.6009033203125],[541.4414611816406,282.00456848144535],[541.6067504882812,282.40537719726564],[541.7791259765626,282.80308227539064],[541.9586975097657,283.19768371582035],[542.1452453613282,283.5889892578125],[542.3389892578125,283.9767791748047],[542.5398193359375,284.36102600097655],[542.7477905273438,284.7414276123047],[542.9630676269531,285.1178192138672],[543.1854858398438,285.4898986816406],[543.4151550292969,285.8575836181641],[543.6519653320313,286.220654296875],[543.8960266113281,286.5789459228516],[544.14755859375,286.93199157714844],[544.4154602050781,287.2728698730469],[544.701708984375,287.5984222412109],[545.0034484863281,287.90960998535155],[545.3181518554687,288.2076416015625],[545.6435668945313,288.49419250488285],[545.9775512695313,288.7704986572266],[546.3182373046875,289.03851013183595],[546.6642517089844,289.3000396728516],[547.0133422851562,289.5569549560547],[547.3647399902344,289.8107116699219],[547.7172912597656,290.06312255859376],[548.0708312988281,290.3139953613281],[548.4254150390625,290.5633575439453],[548.7810424804687,290.81129150390626],[549.1377136230469,291.0578247070313],[549.4953735351563,291.3028472900391],[549.8540222167969,291.54644165039065],[550.2136047363282,291.78858032226566],[550.57412109375,292.0292633056641],[550.9356262207032,292.2685455322266],[551.2981201171875,292.5065093994141],[551.6615478515625,292.7430450439453],[552.0257446289063,292.9781799316406],[552.3908203125001,293.2118865966797],[552.7568298339844,293.4443023681641],[553.1236083984376,293.6752899169922],[553.4912658691406,293.90495910644535],[553.8598022460938,294.1332550048828],[554.2293273925782,294.3603424072266],[554.5994567871094,294.5859741210938],[554.9703552246094,294.81028747558594],[555.3421325683594,295.0333648681641],[555.7146240234375,295.2551239013672],[556.087939453125,295.4756195068359],[556.4619140625,295.69482421875],[556.8368225097656,295.9126281738281],[557.2124450683594,296.1290588378906],[557.5883972167969,296.3449676513672],[557.9652832031251,296.5591735839844],[558.3429931640625,296.77203369140625],[558.7214172363282,296.98357543945315],[559.1001708984376,297.1944305419922],[559.4800231933594,297.4036102294922],[559.8601501464844,297.6121307373047],[560.2411560058594,297.8189208984375],[560.6224914550781,298.0251068115235],[561.0047607421875,298.22958984375003],[561.3873596191406,298.43349609375],[561.7708374023438,298.6356994628906],[562.15458984375,298.837353515625],[562.5392211914062,299.03733215332034],[562.9241821289063,299.23681640625],[563.3099670410156,299.43462524414065],[563.6959716796875,299.63193969726564],[564.0828552246094,299.82757873535155],[564.4699035644531,300.02272338867186],[564.8578857421875,300.2163299560547],[565.2460327148438,300.40944213867186],[565.6350036621094,300.60093383789064],[566.0241394042969,300.7920135498047],[566.4140991210937,300.98150024414065],[566.8042236328125,301.1705749511719],[567.1951171875,301.35808410644535],[567.5861755371094,301.5452087402344],[567.9780029296875,301.730795288086],[568.3700500488281,301.91602478027346],[568.7627014160156,302.0996887207031],[569.155517578125,302.2829956054688],[569.5490478515625,302.4648468017578],[569.9427978515625,302.6463134765625],[570.3372619628907,302.8263793945313],[570.7317260742187,303.00603332519535],[571.1269042968751,303.18431396484374],[571.5221923828125,303.3622100830078],[571.9181945800782,303.5387329101563],[572.3141418457031,303.7152557373047],[572.7104187011719,303.8909545898438],[573.1071899414063,304.0659942626953],[573.5037963867188,304.24097900390626],[573.9008972167969,304.4149475097656],[574.2980529785157,304.58872375488284],[574.6953186035156,304.7624176025391],[575.0929138183594,304.9352600097656],[575.4904541015625,305.10812988281253],[575.8882141113281,305.28078002929686],[576.2860839843751,305.452963256836],[576.6839538574219,305.625146484375],[577.0818237304687,305.7973297119141],[577.4796936035157,305.9695129394531],[577.8775634765625,306.1416961669922],[578.2753234863281,306.31401672363285],[578.673193359375,306.4863647460938],[579.0710083007813,306.6587127685547],[579.4688232421876,306.83103332519534],[579.8665832519531,307.00335388183595],[580.2642333984376,307.1761138916016],[580.6616638183594,307.3493133544922],[581.0590942382813,307.5225402832031],[581.4563049316406,307.69650878906253],[581.8532409667969,307.8707244873047],[582.2502319335938,308.04494018554686],[582.6465637207032,308.2203643798828],[583.0429504394532,308.3958984375],[583.4392272949219,308.5717346191406],[583.8348999023438,308.74888916015624],[584.2306823730469,308.92612609863284],[584.6259704589844,309.1040496826172],[585.0207641601563,309.283154296875],[585.4155578613281,309.4622314453125],[585.8099670410156,309.64235229492186],[586.2038269042969,309.82335205078124],[586.5973022460938,310.0052856445313],[586.9904479980469,310.1883453369141],[587.3830993652344,310.37217407226564],[587.775311279297,310.5567993164063],[588.1669189453125,310.7427978515625],[588.5580322265625,310.92978515625003],[588.9487060546875,311.1177062988281],[589.3388305664063,311.3067535400391],[589.7283508300782,311.4973114013672],[590.1172668457032,311.6888854980469],[590.5055786132813,311.8815032958984],[590.8931762695313,312.0756866455078],[591.2801147460938,312.2712707519531],[591.6663940429688,312.46803588867186],[592.0520690917969,312.6660095214844],[592.436865234375,312.866015625],[592.8207824707032,313.0672302246094],[593.204150390625,313.26979064941406],[593.5865295410157,313.4740814208985],[593.967919921875,313.6801300048828],[594.3485412597656,313.88763427734375],[594.7283935546875,314.0965118408203],[595.1070922851562,314.30775146484376],[595.4848022460938,314.5205841064453],[595.8615783691406,314.73487243652346],[596.2373657226562,314.95105590820316],[596.6118347167969,315.16962890625],[596.9852600097656,315.38971252441405],[597.3577514648438,315.6114715576172],[597.728924560547,315.8356475830078],[598.0987243652344,316.0619384765625],[598.4674255371094,316.2899597167969],[598.8350280761719,316.51979370117186],[599.2009826660156,316.7522369384766],[599.5656188964844,316.9866027832031],[599.9287719726562,317.2233856201172],[600.2906616210938,317.46233825683595],[600.6509033203125,317.70354309082035],[601.0095520019531,317.94700012207034],[601.3667175292969,318.1927917480469],[601.7221252441407,318.44097290039065],[602.0759399414063,318.6914337158203],[602.4279968261719,318.94453125],[602.7784606933594,319.19988098144535],[603.1268371582031,319.4579223632813],[603.4734558105469,319.7181884765625],[603.8180419921875,319.9812286376953],[604.1608154296875,320.2466583251953],[604.5015014648437,320.51475219726564],[604.8401550292969,320.7854278564453],[605.176611328125,321.0588775634766],[605.509442138672,321.3367492675781],[605.837548828125,321.6201141357422],[606.1607666015625,321.90894470214846],[606.4788757324219,322.2034881591797],[606.7919860839844,322.5032501220703],[607.09921875,322.8090545654297],[607.4013977050781,323.1201599121094],[607.6972045898438,323.4370330810547],[607.9868041992188,323.75953674316406],[608.2700866699219,324.08775329589844],[608.5465576171875,324.42168273925785],[608.8158874511719,324.7612976074219],[609.0779113769531,325.10670776367186],[609.3322448730469,325.4579681396485],[609.5783935546875,325.8147766113281],[609.8161376953125,326.1772155761719],[610.0449829101562,326.54542236328126],[610.2645996093751,326.91917724609374],[610.4746032714844,327.2984252929688],[610.6744995117188,327.68311157226566],[610.864013671875,328.07309875488284],[611.0433654785156,328.4677276611328],[611.2128845214844,328.86675109863285],[611.3726257324219,329.26978454589846],[611.522314453125,329.6766632080078],[611.661785888672,330.0870574951172],[611.7907104492188,330.50099487304686],[611.9091430664063,330.9180908203125],[612.0163146972657,331.3380981445313],[612.1125000000001,331.76085205078124],[612.1968200683594,332.18602294921874],[612.2694396972656,332.6134735107422],[612.3295349121094,333.0427642822266],[612.3769958496094,333.4736755371094],[612.4112182617188,333.9058776855469],[612.431982421875,334.33884887695314],[612.43857421875,334.7722869873047],[612.4307739257813,335.20569763183596],[612.4079223632813,335.6386413574219],[612.3702392578125,336.07048645019535],[612.3191528320312,336.5009307861328],[612.2547729492188,336.9298095703125],[612.1779235839844,337.3564086914063],[612.089208984375,337.7806732177734],[611.9891235351563,338.20249328613284],[611.878271484375,338.6216766357422],[611.7569274902344,339.0377563476563],[611.626025390625,339.45106201171876],[611.486004638672,339.86145629882816],[611.3373596191407,340.26866455078124],[611.1803100585938,340.6727966308594],[611.0156799316406,341.0737976074219],[610.8438537597657,341.47177734375003],[610.6652709960938,341.8667907714844],[610.4799316406251,342.2587005615234],[610.2888793945312,342.6478637695313],[610.0920043945313,343.03419799804686],[609.8902404785157,343.41795043945314],[609.683203125,343.7987915039063],[609.4717163085937,344.1772155761719],[609.2561645507812,344.55333251953124],[609.0362731933594,344.9269226074219],[608.8133056640626,345.2987274169922],[608.589404296875,345.6700927734375],[608.3656127929688,346.0413757324219],[608.141766357422,346.41265869140625],[607.9179748535156,346.78391418457034],[607.6938537597656,347.1549774169922],[607.468798828125,347.52549133300784],[607.2437438964844,347.8960327148438],[607.0180847167969,348.26624450683596],[606.7920959472657,348.63623657226566],[606.5661071777344,349.00620117187503],[606.3391845703126,349.37558898925784],[606.1122619628907,349.74497680664064],[605.8848999023438,350.11411743164064],[605.6569335937501,350.48284606933595],[605.4289123535157,350.8517120361328],[605.2000122070312,351.219808959961],[604.970947265625,351.58787841796874],[604.7414978027344,351.95567321777344],[604.5112243652344,352.3230285644531],[604.281005859375,352.6903564453125],[604.0497436523438,353.05713500976566],[603.8182067871094,353.4237762451172],[603.5863403320312,353.7900604248047],[603.3535949707032,354.15576782226566],[603.1207946777344,354.5214752197266],[602.8869506835938,354.8864959716797],[602.6527770996094,355.25135192871096],[602.4182189941406,355.6159332275391],[602.1825622558594,355.9799377441406],[601.9469604492188,356.343832397461],[601.7101501464844,356.7069580078125],[601.4731201171875,357.0699188232422],[601.2355407714844,357.4325225830078],[600.9969177246094,357.7944671630859],[600.7582946777344,358.1564117431641],[600.5181884765625,358.51758728027346],[600.2779724121094,358.8784606933594],[600.0370422363281,359.2388946533203],[599.7951782226563,359.5986694335938],[599.5532592773437,359.9584442138672],[599.3098022460938,360.3170928955078],[599.0662353515626,360.6757415771485],[598.8217895507813,361.0338409423828],[598.57646484375,361.3912811279297],[598.3310302734375,361.7486938476563],[598.0839477539063,362.1049255371094],[597.8368652343751,362.4611297607422],[597.5887390136719,362.81659240722655],[597.3397888183594,363.1715057373047],[597.0906188964844,363.5263916015625],[596.8398559570313,363.88001403808596],[596.5890930175782,364.2336639404297],[596.3371215820313,364.5863800048828],[596.0844909667969,364.93865661621095],[595.8314758300781,365.2906860351563],[595.5769226074219,365.64161682128906],[595.322314453125,365.9926025390625],[595.0663879394532,366.34254455566406],[594.809912109375,366.69207458496095],[594.5529418945313,367.04127502441406],[594.2945434570313,367.3893493652344],[594.0360900878907,367.7374237060547],[593.7763183593751,368.0843719482422],[593.5158874511719,368.4311004638672],[593.2550720214844,368.7773895263672],[592.9927185058594,369.1225524902344],[592.7304199218751,369.4676879882813],[592.4666931152344,369.8117248535156],[592.2024169921875,370.15537719726564],[591.9377014160157,370.4988098144531],[591.6713378906251,370.84100646972655],[591.4050842285156,371.18312072753906],[591.1375671386719,371.52427368164064],[590.8693908691406,371.86484985351564],[590.6011047363281,372.2052886962891],[590.3308959960938,372.54432678222656],[590.0607421875001,372.88336486816405],[589.7895446777344,373.2217987060547],[589.5174133300782,373.5592712402344],[589.245281982422,373.89674377441406],[588.9700744628907,374.231689453125],[588.689208984375,374.5619384765625],[588.4027404785156,374.88721618652346],[588.1108337402344,375.20776977539066],[587.8137634277344,375.5236541748047],[587.5115844726563,375.8345123291016],[587.2044616699219,376.1404266357422],[586.8925048828125,376.4415618896484],[586.5758239746094,376.7375885009766],[586.2544189453125,377.02850646972655],[585.9288391113281,377.3147827148438],[585.5987548828125,377.59584045410156],[585.2643310546875,377.8718170166016],[584.9258972167969,378.14271240234376],[584.5833984375,378.4083618164063],[584.2368347167969,378.66893005371094],[583.8863159179688,378.9239776611328],[583.5324462890625,379.1743560791016],[583.1744018554688,379.41904907226564],[582.8130065917969,379.6583587646484],[582.4482604980469,379.8926696777344],[582.079833984375,380.1212127685547],[581.7081665039062,380.3442626953125],[581.3333679199219,380.5622589111328],[580.9549438476563,380.7736358642578],[580.5731140136719,380.9793273925781],[580.1877685546875,381.1778778076172],[579.7994018554688,381.37046813964844],[579.4075744628907,381.5558349609375],[579.0128906250001,381.7350769042969],[578.6149658203125,381.90723266601566],[578.2143493652344,382.0729888916016],[577.8108764648438,382.2317687988281],[577.4048767089844,382.38376464843753],[576.9964599609375,382.5289764404297],[576.5855163574219,382.667074584961],[576.1724853515625,382.7986083984375],[575.7570373535157,382.9227264404297],[575.3398315429688,383.0403625488281],[574.9204284667969,383.15044555664065],[574.499432373047,383.2539916992188],[574.0767333984376,383.3501220703125],[573.6525512695313,383.43946838378906],[573.2269409179688,383.5217559814453],[572.8000671386719,383.5970397949219],[572.3719848632812,383.6656768798828],[571.9428588867188,383.7280242919922],[571.5129638671875,383.78419189453126],[571.0824096679688,383.8341796875],[570.6511413574219,383.8782073974609],[570.2192687988281,383.91643981933595],[569.7870666503907,383.9490692138672],[569.3543151855469,383.97617797851564],[568.9212890625,383.99790344238284],[568.4880981445312,384.01435546875],[568.0546325683594,384.0255340576172],[567.6212768554688,384.0319061279297],[567.1877563476563,384.03358154296876],[566.7542358398438,384.0306701660156],[566.3207153320312,384.0233642578125],[565.8873596191406,384.01182861328124],[565.4540588378907,383.9961730957031],[565.0209228515625,383.976644897461],[564.5881164550782,383.9533264160156],[564.155419921875,383.92640991210936],[563.7229431152344,383.8959503173828],[563.2907958984375,383.8620300292969],[562.8587036132812,383.82500610351565],[562.42705078125,383.7850708007813],[561.9956726074219,383.7423065185547],[561.5645141601562,383.6969329833984],[561.1336853027344,383.6490875244141],[560.7030212402344,383.59885253906253],[560.2726867675782,383.5464752197266],[559.8425720214844,383.4919006347656],[559.4127319335938,383.4349365234375],[558.9833312988281,383.37530822753905],[558.5543151855469,383.3133453369141],[558.1255187988281,383.2490478515625],[557.6972717285156,383.18247070312503],[557.2691345214844,383.1135589599609],[556.8413818359376,383.0424499511719],[556.4141235351562,382.9691986083985],[555.9873046875,382.89369506835936],[555.5607055664062,382.8158843994141],[555.1347106933594,382.73606872558594],[554.7089355468751,382.6541656494141],[554.2835998535156,382.5703125],[553.8585388183594,382.48442687988285],[553.4340270996094,382.3966735839844],[553.0098999023438,382.3069976806641],[552.5861572265625,382.21534423828126],[552.1627990722657,382.1217956542969],[551.7399353027344,382.0265167236328],[551.3174560546876,381.9294799804688],[550.895361328125,381.8302459716797],[550.4735412597656,381.7300506591797],[550.0522705078125,381.62757568359376],[549.6312744140625,381.5244415283203],[549.2108825683594,381.418505859375],[548.7906555175781,381.3119384765625],[548.3709777832031,381.2032836914063],[547.9514099121094,381.09339294433596],[547.5324462890625,380.98218383789066],[547.1138671875,380.86924438476564],[546.6955627441406,380.7555358886719],[546.2778625488281,380.63965759277346],[545.8602172851563,380.5232299804688],[545.4431213378906,380.4048797607422],[545.0261901855469,380.2856781005859],[544.6097534179688,380.16521301269535],[544.193701171875,380.0434844970703],[543.7778686523437,379.92090454101566],[543.3625305175782,379.79673156738284],[542.9473571777344,379.6721466064453],[542.5326782226563,379.54583129882815],[542.1179443359375,379.4189666748047],[541.703759765625,379.2908935546875],[541.289794921875,379.16199645996096],[540.8761596679688,379.03233032226564],[540.4629089355469,378.9015380859375],[540.0497131347656,378.7703338623047],[539.6369567871094,378.63775634765625],[539.2242004394532,378.50482177734375],[538.8118835449219,378.3708709716797],[538.3996765136719,378.2363983154297],[537.9877990722656,378.1012390136719],[537.5763061523438,377.9650360107422],[537.1649230957031,377.82822875976564],[536.7535400390625,377.6914489746094],[536.3421569824219,377.55444946289066],[535.9313232421875,377.41602172851566],[535.5207092285157,377.27696228027344],[535.1103149414063,377.13721618652346],[534.7003051757813,376.99623413085936],[534.2905700683594,376.85478515625],[533.8812194824219,376.7121551513672],[533.4720336914063,376.56861877441406],[533.0631774902344,376.4244781494141],[532.6548156738281,376.2787719726563],[532.246728515625,376.1324890136719],[531.8390258789062,375.9850524902344],[531.4318176269531,375.83648986816405],[531.0247741699219,375.6872955322266],[530.6183349609375,375.5362884521484],[530.2121704101563,375.38462219238284],[529.8064453125,375.23182983398436],[529.40126953125,375.0775817871094],[528.9964233398438,374.9226745605469],[528.5922363281251,374.7659545898438],[528.18837890625,374.60830078125],[527.7848510742188,374.44952087402345],[527.3821472167969,374.28903808593753],[526.9797180175782,374.12778625488284],[526.5780578613281,373.96477661132815],[526.1768371582032,373.8005310058594],[525.7760559082031,373.63526916503906],[525.3760986328125,373.4678924560547],[524.976416015625,373.2996368408203],[524.577557373047,373.1297332763672],[524.1794128417969,372.9583190917969],[523.7815979003907,372.785971069336],[523.3848815917969,372.6112060546875],[522.9886047363282,372.43553466796874],[522.5930419921875,372.25818786621096],[522.1981933593751,372.0789459228516],[521.8038940429688,371.8988525390625],[521.410693359375,371.7162322998047],[521.0180419921875,371.53245849609374],[520.6261596679688,371.34714660644534],[520.2352661132812,371.1595825195313],[519.8449218750001,370.971029663086],[519.45556640625,370.7800323486328],[519.0669250488281,370.5879364013672],[518.6793273925781,370.3938354492188],[518.2926635742188,370.1978393554688],[517.9069335937501,369.9999206542969],[517.522137451172,369.80027160644534],[517.1382751464844,369.5987823486328],[516.7552368164063,369.3954254150391],[516.3735168457032,369.1900360107422],[515.99267578125,368.9827789306641],[515.6129333496094,368.7736541748047],[515.2342895507812,368.56255187988285],[514.8565246582032,368.3499389648438],[514.479638671875,368.13576049804686],[514.1034667968751,367.9199615478516],[513.7283386230469,367.7027618408203],[513.3539794921875,367.48402404785156],[512.9805541992188,367.2638305664063],[512.6079528808594,367.0421813964844],[512.23623046875,366.81910400390626],[511.8653869628906,366.5945983886719],[511.49536743164066,366.36858215332035],[511.126171875,366.1413024902344],[510.75791015625003,365.91264953613285],[510.39036254882814,365.68267822265625],[510.02369384765626,365.4514434814453],[509.6577941894531,365.2189178466797],[509.2927185058594,364.9851287841797],[508.92835693359376,364.750048828125],[508.5648193359375,364.5138427734375],[508.20205078125,364.2764007568359],[507.8400512695313,364.0378326416016],[507.4788757324219,363.79811096191406],[507.11841430664066,363.5573181152344],[506.75877685546874,363.31528930664064],[506.3996887207031,363.07207946777345],[506.0415344238281,362.827880859375],[505.68431396484374,362.5821990966797],[505.32736816406253,362.33616027832034],[504.97141113281253,362.0888305664063],[504.6160034179688,361.84059448242186],[504.2611999511719,361.5914794921875],[503.90716552734375,361.34112854003905],[503.553515625,361.0902557373047],[503.2009643554688,360.8379821777344],[502.8485778808594,360.5854888916016],[502.4973449707031,360.3313201904297],[502.1461669921875,360.0771514892578],[501.79619750976565,359.8212524414063],[501.446337890625,359.56524353027345],[501.09746704101565,359.3078887939453],[500.7488159179688,359.05017700195316],[500.40098876953124,358.7914764404297],[500.05360107421876,358.5321716308594],[499.70665283203124,358.2720977783203],[499.3604187011719,358.0111999511719],[499.01451416015624,357.74989013671876],[498.66932373046876,357.4874542236328],[498.32435302734376,357.22496337890624],[497.9802612304688,356.96123657226565],[497.63616943359375,356.6975372314453],[497.29306640625003,356.4325744628906],[496.9500183105469,356.167529296875],[496.6076293945313,355.90155029296875],[496.2654052734375,355.63524169921874],[495.9237854003906,355.368246459961],[495.5825500488281,355.1008666992188],[495.24175415039065,354.8330474853516],[494.90134277343753,354.5646240234375],[494.5611511230469,354.2958984375],[494.2215087890625,354.0264862060547],[493.8818664550781,353.7568817138672],[493.5429382324219,353.4865631103516],[493.2040100097656,353.2162719726563],[492.8656860351563,352.9451843261719],[492.5274169921875,352.6740692138672],[492.18975219726565,352.40207519531253],[491.85230712890626,352.12988891601566],[491.5148071289063,351.8576202392578],[491.1773620605469,351.58543395996094],[490.8404113769531,351.31275329589846],[490.5039001464844,351.03944091796876],[490.16760864257816,350.7658264160156],[489.83192138671876,350.4915252685547],[489.4962890625,350.21705932617186],[489.16131591796875,349.9416870117188],[488.8264526367188,349.66636962890624],[488.4923583984375,349.3900360107422],[488.1583740234375,349.1136749267578],[487.8251037597656,348.8364624023438],[487.49199829101565,348.55897521972656],[487.15955200195316,348.2808563232422],[486.82732543945315,348.0021606445313],[486.49559326171874,347.7230255126953],[486.1644653320313,347.4432037353516],[485.8336120605469,347.1631072998047],[485.50352783203124,346.8820770263672],[485.1734985351563,346.60096435546876],[484.8445129394531,346.3186981201172],[484.5154174804688,346.0363220214844],[484.18736572265624,345.7528747558594],[483.85947875976564,345.46929016113285],[483.53236083984376,345.1847717285156],[483.20562744140625,344.89984130859375],[482.879443359375,344.61414184570316],[482.5539184570313,344.3278381347656],[482.22877807617186,344.0410400390625],[481.9044616699219,343.7533355712891],[481.5803649902344,343.46538391113285],[481.2573669433594,343.17625122070314],[480.9343688964844,342.88709106445316],[480.61268920898436,342.5965026855469],[480.2910095214844,342.30588684082034],[479.9703735351563,342.0139526367188],[479.6500671386719,341.721826171875],[479.3306396484375,341.4287384033203],[479.0117614746094,341.1350463867188],[478.69348754882816,340.8406127929688],[478.3760925292969,340.5453277587891],[478.05908203125,340.2496307373047],[477.743115234375,339.9526702880859],[477.4273132324219,339.655599975586],[477.1129943847656,339.3570465087891],[476.7986755371094,339.0584930419922],[476.4857849121094,338.75840148925784],[476.1730590820313,338.4581726074219],[475.8615966796875,338.1567077636719],[475.5504638671875,337.85466613769535],[475.2403198242188,337.55174560546874],[474.9309997558594,337.24805603027346],[474.6222290039063,336.94365234375],[474.3146667480469,336.6381774902344],[474.00743408203124,336.3323455810547],[473.7016296386719,336.0250579833984],[473.39577026367186,335.7176055908203],[473.0918334960938,335.4084777832031],[472.78789672851565,335.09934997558594],[472.4852233886719,334.78904113769534],[472.18348388671876,334.4778259277344],[471.8825134277344,334.1656768798828],[471.5826416015625,333.8527313232422],[471.2834838867188,333.53879699707034],[470.9854248046875,333.2240386962891],[470.6881896972656,332.9084014892578],[470.39194335937503,332.5918853759766],[470.096630859375,332.274462890625],[469.8023620605469,331.95618896484376],[469.50908203125,331.6369537353516],[469.21673583984375,331.3166198730469],[468.92548828125,330.9954345703125],[468.63544921875,330.67331542968753],[468.34617919921874,330.35039978027345],[468.05784301757814,330.02666015625],[467.77088012695316,329.7017395019531],[467.4847412109375,329.3760223388672],[467.19931640625003,329.0495635986328],[466.9152099609375,328.7221160888672],[466.6320373535156,328.39381713867186],[466.3496887207031,328.0649139404297],[466.0682739257813,327.7351318359375],[465.7880126953125,327.4043334960938],[465.50852050781253,327.07301330566406],[465.22974243164066,326.74089660644535],[464.9522277832031,326.4078735351563],[464.6753723144531,326.0741638183594],[464.3993408203125,325.73987731933596],[464.1243530273438,325.4047393798828],[463.850244140625,325.0689422607422],[463.57679443359376,324.7325134277344],[463.3041137695313,324.39531555175785],[463.03247680664066,324.0574584960938],[462.7614990234375,323.7190795898438],[462.4911804199219,323.3800964355469],[462.22190551757814,323.04034423828125],[461.9532897949219,322.7000427246094],[461.6853881835938,322.3593292236328],[461.41814575195315,322.0177917480469],[461.1517822265625,321.675732421875],[460.8860229492188,321.33326110839846],[460.6208953857422,320.9902679443359],[460.3566467285156,320.64661560058596],[460.0928924560547,320.30249633789066],[459.8297149658203,319.95802001953126],[459.567333984375,319.61277465820314],[459.305859375,319.2670349121094],[459.04485168457035,318.92088317871094],[458.78387145996095,318.5747314453125],[458.5241271972656,318.22764587402344],[458.2647674560547,317.8802856445313],[458.00538024902346,317.5329254150391],[457.74736633300785,317.1844116210938],[457.4895446777344,316.8358978271485],[457.2318054199219,316.4873016357422],[456.9753845214844,316.137744140625],[456.7189636230469,315.7881591796875],[456.4628448486328,315.43840942382815],[456.20771484375,315.087890625],[455.9525573730469,314.73728942871094],[455.6978393554688,314.3864410400391],[455.4439178466797,314.0350708007813],[455.18999633789065,313.68370056152344],[454.93662414550784,313.3319458007813],[454.6837463378906,312.9798065185547],[454.4308685302735,312.62766723632814],[454.17856750488284,312.27500610351564],[453.9266784667969,311.92218017578125],[453.67478942871094,311.56935424804686],[453.42355957031253,311.21611633300785],[453.17246704101564,310.8627136230469],[452.92140197753906,310.50928344726566],[452.6709686279297,310.1553863525391],[452.4205627441406,309.80137939453124],[452.17026672363284,309.44739990234376],[451.92071228027345,309.0928985595703],[451.6711853027344,308.7383972167969],[451.421630859375,308.38392333984376],[451.1720764160156,308.0294219970703],[450.92254943847655,307.6749206542969],[450.6732421875,307.3201171875],[450.42451171875,306.9650390625],[450.17578125,306.60996093750003],[449.92705078125,306.2549102783203],[449.67832031250003,305.89983215332035],[449.42958984375,305.5447540283203],[449.180859375,305.18970336914066],[448.9320739746094,304.8345428466797],[448.6833435058594,304.4794647216797],[448.4346130371094,304.1243865966797],[448.1858825683594,303.7693359375],[447.93715209960936,303.4142578125],[447.6882568359375,303.0592895507813],[447.43938903808595,302.70432128906253],[447.19043884277346,302.3492706298828],[446.94154357910156,301.9943023681641],[446.6926483154297,301.6393615722656],[446.4435607910156,301.2845031738281],[446.1939239501953,300.9300842285156],[445.944287109375,300.5756378173828],[445.6946502685547,300.2212188720703],[445.44495849609376,299.8666900634766],[445.19532165527346,299.51227111816405],[444.9457946777344,299.1577423095703],[444.6968994140625,298.8027740478516],[444.4492126464844,298.44695434570315],[444.20273437500003,298.09039306640625],[443.95740966796876,297.7329528808594],[443.71323852539064,297.3746337890625],[443.4700836181641,297.0156280517578],[443.2279998779297,296.65601806640626],[442.9869323730469,296.2957763671875],[442.74688110351565,295.93471069335936],[442.5079284667969,295.57301330566406],[442.2690032958985,295.21123352050785],[442.03191833496095,294.84816284179686],[441.79486083984375,294.4852020263672],[441.5591217041016,294.12147216796876],[441.3237670898438,293.7574127197266],[441.0890716552735,293.3929412841797],[440.8552276611328,293.02789306640625],[440.6214935302734,292.66273498535156],[440.38885803222655,292.2967803955078],[440.15630493164065,291.9309356689453],[439.92457580566406,291.56451416015625],[439.69309387207034,291.19798278808594],[439.46213378906253,290.83103942871094],[439.2318054199219,290.4637939453125],[439.00144958496094,290.0965484619141],[438.7710388183594,289.7291931152344],[438.5406829833984,289.36192016601564],[438.31101379394534,288.9942626953125],[438.08142700195316,288.62652282714845],[437.8518402099609,288.2587829589844],[437.62225341796875,287.89104309082035],[437.3926666259766,287.52330322265624],[437.16302490234375,287.1554809570313],[436.9334381103516,286.7877410888672],[436.7038513183594,286.4200012207031],[436.4742645263672,286.05226135253906],[436.2440460205078,285.68498840332035],[436.01344299316406,285.31788024902346],[435.7828674316406,284.9507720947266],[435.5522369384766,284.58355407714845],[435.32155151367186,284.2164733886719],[435.0897125244141,283.8501342773438],[434.8578735351563,283.48382263183595],[434.62518310546875,283.1180877685547],[434.39219055175784,282.752490234375],[434.15859375,282.38730468750003],[433.92420043945316,282.02247619628906],[433.6896148681641,281.65789489746095],[433.45371093750003,281.2941925048828],[433.2178070068359,280.9304901123047],[432.9803924560547,280.5677215576172],[432.7427032470703,280.2051727294922],[432.5041900634766,279.84311828613284],[432.26455078125,279.4817230224609],[432.0241149902344,279.12106933593753],[431.7826629638672,278.76096496582034],[431.5401947021484,278.4016021728516],[431.2966278076172,278.0430084228516],[431.05193481445315,277.6851013183594],[430.8061431884766,277.327963256836],[430.5591705322266,276.9715118408203],[430.31109924316405,276.6159942626953],[430.0618469238281,276.26132812500003],[429.8113586425781,275.90756835937503],[429.55938720703125,275.55479736328124],[429.3059875488281,275.2029602050781],[429.05132446289065,274.8522216796875],[428.79515075683594,274.50230712890624],[428.53765869140625,274.1536010742188],[428.2786560058594,273.8059112548828],[428.01819763183596,273.4593475341797],[427.75620117187503,273.1139373779297],[427.49241943359374,272.76995544433595],[427.22808837890625,272.4263854980469],[426.96356506347655,272.0827880859375],[426.6991241455078,271.73927307128906],[426.4346557617188,271.39575805664066],[426.17021484375,271.0522430419922],[425.90574645996094,270.70872802734374],[425.6412780761719,270.36521301269534],[425.3763153076172,270.0220001220703],[425.1111602783203,269.67889709472655],[424.84608764648436,269.3358489990234],[424.58079528808594,268.9929931640625],[424.31476135253905,268.65068664550785],[424.04839782714845,268.3087646484375],[423.7814849853516,267.9671173095703],[423.5139129638672,267.6260467529297],[423.24590148925785,267.28516845703126],[422.97679138183594,266.94519653320316],[422.70746154785155,266.6055541992188],[422.43686828613284,266.266845703125],[422.1657257080078,265.92860412597656],[421.89356689453126,265.5911590576172],[421.6203643798828,265.2545104980469],[421.3463928222656,264.9183837890625],[421.07091064453124,264.5836578369141],[420.7949890136719,264.2492340087891],[420.5174468994141,263.9162933349609],[420.2387237548828,263.5843139648438],[419.95862731933596,263.2533233642578],[419.6772674560547,262.9235412597656],[419.3944519042969,262.59483032226564],[419.11023559570316,262.26743774414064],[418.82456359863284,261.9413635253906],[418.5372985839844,261.61671752929686],[418.2483581542969,261.29355468750003],[417.95774230957034,260.9717926025391],[417.66550598144534,260.65159606933594],[417.3714294433594,260.3328826904297],[417.0757049560547,260.01592712402345],[416.7781677246094,259.70070190429686],[416.4787078857422,259.38726196289065],[416.17713317871096,259.0757720947266],[415.87366333007816,258.7662322998047],[415.5681610107422,258.45867004394535],[415.2604614257813,258.1529754638672],[414.95086669921875,257.84958801269534],[414.6391571044922,257.5483428955078],[414.325277709961,257.2492950439453],[414.00900878906253,256.95285644531253],[413.6904327392578,256.65875244140625],[413.36960449218753,256.3671478271485],[413.04652404785156,256.0781524658203],[412.7210266113281,255.79165649414062],[412.3933044433594,255.5079071044922],[412.0631103515625,255.226904296875],[411.73044433593753,254.9488952636719],[411.39525146484374,254.67401733398438],[411.05755920410155,254.40216064453125],[410.71714782714844,254.13373718261718],[410.3738525390625,253.8687744140625],[410.02783813476566,253.6077667236328],[409.6789947509766,253.35024719238282],[409.3278442382813,253.09613342285158],[408.97424926757816,252.84520568847657],[408.61818237304686,252.59801330566407],[408.25986328125003,252.35400695800783],[407.8993194580078,252.112939453125],[407.53704528808595,251.87503051757812],[407.17246398925784,251.64036254882814],[406.8060974121094,251.40857849121093],[406.4380279541016,251.1794860839844],[406.06836547851566,250.9531677246094],[405.6968902587891,250.72970581054688],[405.3237670898438,250.50863342285157],[404.949462890625,250.29008789062502],[404.5737030029297,250.07390441894532],[404.1964874267578,249.86016540527345],[403.8181457519531,249.64848632812502],[403.4386779785156,249.4388397216797],[403.058056640625,249.23130798339844],[402.6763092041016,249.02569885253908],[402.2937377929688,248.821875],[401.9102325439453,248.61964416503906],[401.52568359375,248.4195556640625],[401.1405853271485,248.2202911376953],[400.75474548339844,248.02264709472658],[400.3681915283203,247.82648620605468],[399.98125305175785,247.6311218261719],[399.5934631347656,247.43732299804688],[399.20517883300784,247.24423828125],[398.816455078125,247.05184020996094],[398.4273193359375,246.86073303222656],[398.03801879882815,246.67023010253908],[397.64816894531253,246.48057861328127],[397.2583465576172,246.29092712402345],[396.868359375,246.10138549804688],[396.47804260253906,245.91272277832033],[396.0877258300781,245.72403259277345],[395.6974090576172,245.53536987304688],[395.3071197509766,245.3466796875],[394.91680297851565,245.15801696777345],[394.5264862060547,244.96932678222657],[394.13671875,244.77986755371094],[393.7469512939453,244.59007873535157],[393.35699157714845,244.40018005371095],[392.9675537109375,244.20951232910156],[392.57850036621096,244.01826782226564],[392.1901336669922,243.8257049560547],[391.80173950195314,243.63300476074218],[391.4134552001953,243.44019470214843],[391.0251708984375,243.24738464355468],[390.6368316650391,243.05465698242188],[390.24794311523436,242.8631103515625],[389.85902709960936,242.67156372070312],[389.47011108398436,242.48001708984376],[389.0806457519531,242.2895690917969],[388.69101562500003,242.0995330810547],[388.3013580322266,241.9094970703125],[387.91123352050784,241.71990051269532],[387.5209442138672,241.53118286132812],[387.1304626464844,241.3432342529297],[386.7395416259766,241.15547790527344],[386.34831848144535,240.96871032714844],[385.9569580078125,240.78243713378907],[385.5652130126953,240.59676818847657],[385.1729461669922,240.41192321777345],[384.7806793212891,240.22754516601563],[384.3878082275391,240.0442657470703],[383.9947723388672,239.86156311035157],[383.60129699707034,239.67957458496093],[383.2072723388672,239.49854736328126],[382.8131103515625,239.3180145263672],[382.41815185546875,239.1387176513672],[382.0231658935547,238.96016235351564],[381.62774047851565,238.78243103027344],[381.23187561035155,238.6059356689453],[380.83562622070315,238.4299072265625],[380.43877258300785,238.2553894042969],[380.0415893554688,238.08161315917968],[379.643994140625,237.90879821777344],[379.24590454101565,237.73738403320314],[378.8474029541016,237.56649169921874],[378.4482696533203,237.39730224609374],[378.048779296875,237.22896423339844],[377.6488494873047,237.061669921875],[377.2483154296875,236.89599609375],[376.8472045898438,236.73084411621093],[376.44557189941406,236.56761474609377],[376.0436096191406,236.4053741455078],[375.64112548828126,236.244287109375],[375.2378173828125,236.08490295410158],[374.83448181152346,235.9263427734375],[374.43023986816405,235.76976013183594],[374.0255035400391,235.61422119140624],[373.6203552246094,235.45997314453126],[373.21465759277345,235.30720825195314],[372.80824584960936,235.1561462402344],[372.4013671875,235.00659484863283],[371.99391174316406,234.8584991455078],[371.58587951660155,234.71196899414062],[371.17713317871096,234.5668670654297],[370.7679748535156,234.42368774414064],[370.3583221435547,234.28182678222657],[369.94866943359375,234.1399658203125],[369.5387420654297,233.9989013671875],[369.1284851074219,233.85879821777345],[368.7182281494141,233.71869506835938],[368.3074493408203,233.57988281250002],[367.89658813476564,233.44153747558593],[367.4858093261719,233.30330200195314],[367.0743438720703,233.1668243408203],[366.6628784179688,233.0303192138672],[366.25108337402344,232.8943634033203],[365.839013671875,232.75969848632812],[365.4267242431641,232.624951171875],[365.0144348144531,232.49143981933594],[364.6017608642578,232.358642578125],[364.1890594482422,232.22584533691406],[363.7758361816406,232.0947235107422],[363.36255798339846,231.9638214111328],[362.94919738769534,231.8332489013672],[362.5353149414063,231.7042419433594],[362.1214324951172,231.57526245117188],[361.7072204589844,231.44688720703127],[361.2929260253906,231.31947326660156],[360.87827453613284,231.19293823242188],[360.4634582519531,231.06708984375],[360.04839477539065,230.94190063476563],[359.63291931152344,230.81728820800782],[359.21738891601564,230.69369201660157],[358.8016662597656,230.57078247070314],[358.3856964111328,230.4485321044922],[357.9695617675781,230.3269821166992],[357.553125,230.20637969970704],[357.1364959716797,230.08643646240236],[356.7198120117188,229.96719360351562],[356.30279846191405,229.8487335205078],[355.88548278808594,229.73115234375],[355.46800231933594,229.6142578125],[355.05030212402346,229.49800872802734],[354.63238220214845,229.38269348144533],[354.21440734863285,229.26824340820312],[353.79607543945315,229.15445251464845],[353.37733154296876,229.0412796020508],[352.95856018066405,228.92913665771485],[352.5395965576172,228.817790222168],[352.12041320800785,228.70714416503907],[351.70106506347656,228.59719848632812],[351.2814422607422,228.48835144042968],[350.86162719726565,228.38021850585938],[350.4416748046875,228.27281341552734],[350.0214752197266,228.16617736816406],[349.60089111328125,228.0605438232422],[349.18036193847655,227.9557067871094],[348.7594482421875,227.85152893066407],[348.33839721679686,227.74827117919924],[347.917236328125,227.64602966308595],[347.4955261230469,227.54441986083984],[347.0738983154297,227.44362030029296],[346.6520233154297,227.34380950927735],[346.22995605468753,227.2449188232422],[345.80750427246096,227.14674224853516],[345.3851348876953,227.04937591552735],[344.9624359130859,226.95306701660158],[344.53968200683596,226.85763702392578],[344.1165435791016,226.76292114257814],[343.6932678222656,226.66897430419922],[343.2697998046875,226.57623596191408],[342.8461120605469,226.48428039550782],[342.42234191894534,226.39313507080078],[341.99835205078125,226.30282745361328],[341.5739227294922,226.2136184692383],[341.1493835449219,226.1252197265625],[340.72495422363284,226.0376724243164],[340.3001678466797,225.9510452270508],[339.87513427734376,225.8655029296875],[339.4499908447266,225.78077087402343],[339.0246826171875,225.6968490600586],[338.5991546630859,225.61398468017578],[338.1732971191406,225.53210906982423],[337.7475494384766,225.45111236572265],[337.32147216796875,225.37088470458986],[336.89520263671875,225.29185180664064],[336.46876831054686,225.21373901367187],[336.0421966552735,225.13649139404296],[335.61529541015625,225.06004028320314],[335.18833923339844,224.98489379882812],[334.7611083984375,224.9105987548828],[334.33385009765624,224.8369903564453],[333.9065368652344,224.76390380859377],[333.4793334960938,224.69095458984376],[333.0518829345703,224.61863708496094],[332.6242950439453,224.546305847168],[332.1966522216797,224.47511444091796],[331.76881713867186,224.4049255371094],[331.3410095214844,224.33593139648437],[330.9127624511719,224.26825561523438],[330.4841583251953,224.20213165283204],[330.0556365966797,224.13780670166017],[329.62640075683595,224.07534942626953],[329.1969451904297,224.01504821777345],[328.7674896240234,223.95709533691408],[328.33740234375,223.90162811279296],[327.9072601318359,223.84871520996094],[327.47656860351566,223.798974609375],[327.0456024169922,223.7523651123047],[326.61414184570316,223.70909271240234],[326.18235168457034,223.66947326660156],[325.75042419433595,223.63367156982423],[325.3180847167969,223.60183868408203],[324.8853332519531,223.5741943359375],[324.4524719238281,223.55095825195312],[324.0194458007813,223.5323501586914],[323.5858978271485,223.5185760498047],[323.15256958007814,223.50992431640626],[322.7189392089844,223.5066696166992],[322.2854736328125,223.5089080810547],[321.85203552246094,223.51683197021484],[321.4187896728516,223.53068847656252],[320.98557128906253,223.55066986083986],[320.55303955078125,223.57695465087892],[320.1207550048828,223.60977630615236],[319.6889373779297,223.64950561523438],[319.2579711914063,223.695964050293],[318.8276092529297,223.74879455566406],[318.39818115234374,223.80777740478516],[317.9695770263672,223.87276153564454],[317.5415771484375,223.94360961914063],[317.1148956298828,224.02003326416016],[316.68914794921875,224.10190887451174],[316.2645263671875,224.18923645019532],[315.84094848632816,224.2815902709961],[315.4186065673828,224.37877807617187],[314.99708862304686,224.4806900024414],[314.5768615722656,224.58706512451172],[314.15781555175784,224.69773864746094],[313.7396209716797,224.81258697509767],[313.3227447509766,224.93145904541015],[312.9070495605469,225.0541213989258],[312.4923431396484,225.18038177490234],[312.0786804199219,225.31006164550783],[311.66586914062503,225.44305114746095],[311.2540740966797,225.57908935546877],[310.84356994628905,225.71795654296875],[310.4338348388672,225.86007843017578],[310.0250610351563,226.00432891845705],[309.61716613769534,226.15101013183593],[309.2099578857422,226.30001220703124],[308.8036560058594,226.45108795166016],[308.3980407714844,226.60414123535156],[307.9931121826172,226.75897979736328],[307.5888977050781,226.9156036376953],[307.1853698730469,227.0736831665039],[306.7821441650391,227.23319091796876],[306.3796051025391,227.39381103515626],[305.9771209716797,227.5559829711914],[305.5751861572266,227.71844329833985],[305.17369079589844,227.8822219848633],[304.7735961914063,228.04863739013672],[304.3744354248047,228.2180603027344],[303.9765655517578,228.39027099609376],[303.57993164062503,228.5653793334961],[303.18469848632816,228.7431381225586],[302.7903717041016,228.9235061645508],[302.39722595214846,229.10630493164064],[302.00537109375,229.2913558959961],[301.61439514160156,229.47879638671876],[301.2244354248047,229.66842041015624],[300.83571166992186,229.8600631713867],[300.44772949218753,230.05384826660156],[300.060873413086,230.24963836669923],[299.674951171875,230.44729614257812],[299.29004516601566,230.64667053222658],[298.9059631347656,230.84769287109376],[298.5226226806641,231.05036315917968],[298.14027099609376,231.25443420410156],[297.7585784912109,231.4599609375],[297.3775177001953,231.66683349609374],[296.9973083496094,231.87491455078126],[296.6178680419922,232.08469848632814],[296.23878479003906,232.29478454589844],[295.8604431152344,232.50643615722657],[295.4823486328125,232.7187469482422],[295.1046936035156,232.9321014404297],[294.7277526855469,233.14606018066408],[294.35105895996094,233.36065063476562],[293.97474975585936,233.57611999511718],[293.59868774414065,233.79175415039063],[293.22301025390624,234.00821228027345],[292.8475250244141,234.2247528076172],[292.47234191894535,234.44192504882812],[292.0971313476563,234.65909729003906],[291.7219207763672,234.87626953125002],[291.34682006835936,235.09344177246095],[290.97169189453126,235.31069641113282],[290.59653625488284,235.527978515625],[290.2213806152344,235.74523315429687],[289.84556579589844,235.962158203125],[289.4701354980469,236.17869873046877],[289.09423828125,236.39468994140626],[288.7181762695313,236.6103515625],[288.3417572021485,236.82535400390626],[287.96489868164065,237.03972473144532],[287.5877655029297,237.2535186767578],[287.20997314453126,237.46621398925782],[286.8319885253906,237.67852478027345],[286.453207397461,237.8891326904297],[286.0741790771485,238.09949340820313],[285.6941619873047,238.30839843750002],[285.3135681152344,238.5160675048828],[284.93231506347655,238.7223907470703],[284.55018310546876,238.92742309570312],[284.16733703613284,239.1310272216797],[283.78391418457034,239.33295593261718],[283.39947509765625,239.5333465576172],[283.01495361328125,239.73338012695314],[282.63034973144534,239.93341369628908],[282.2458831787109,240.1340789794922],[281.8619110107422,240.3353485107422],[281.47796630859375,240.5366180419922],[281.09454345703125,240.73887634277344],[280.71112060546875,240.94121704101562],[280.3279724121094,241.14391479492187],[279.94504394531253,241.34716186523437],[279.56211547851564,241.55038146972657],[279.1795989990234,241.75467224121095],[278.79721984863284,241.9589630126953],[278.4148681640625,242.1632537841797],[278.03248901367186,242.36754455566407],[277.6501098632813,242.57183532714845],[277.26817016601564,242.77692260742188],[276.88628540039065,242.98209228515626],[276.50437316894534,243.1872344970703],[276.1224609375,243.3923767089844],[275.7405487060547,243.59754638671876],[275.35869140625,243.80296325683594],[274.97691650390624,244.00835266113282],[274.5951416015625,244.2137420654297],[274.21336669921874,244.41915893554688],[273.83139953613284,244.624658203125],[273.4493774414063,244.82974548339845],[273.0673828125,245.03475036621094],[272.6854156494141,245.23975524902343],[272.3034210205078,245.44478759765624],[271.9214538574219,245.64979248046876],[271.5391571044922,245.85416564941406],[271.1568328857422,246.05851135253906],[270.77439880371094,246.2625274658203],[270.3916900634766,246.4661865234375],[270.00900878906253,246.669873046875],[269.6259429931641,246.87276306152344],[269.2427947998047,247.07562561035158],[268.8593994140625,247.278076171875],[268.47556457519534,247.48008728027344],[268.0919219970703,247.6819610595703],[267.70764770507816,247.88281860351563],[267.3234008789063,248.08356628417968],[266.9389343261719,248.2837371826172],[266.5540283203125,248.48319396972656],[266.1690948486328,248.68262329101563],[265.78355712890624,248.88067932128908],[265.39788208007815,249.07868041992188],[265.01190490722655,249.27593994140625],[264.6254058837891,249.47232055664062],[264.23890686035156,249.6686737060547],[263.8517761230469,249.86381835937502],[263.4641510009766,250.0583038330078],[263.0761962890625,250.2520477294922],[262.6879119873047,250.44505004882814],[262.29932556152346,250.63720092773437],[261.9101898193359,250.82836303710937],[261.5207244873047,251.0186737060547],[261.13087463378906,251.20813293457033],[260.7404479980469,251.39676818847656],[260.34966430664065,251.58444213867188],[259.9584411621094,251.77088012695313],[259.5666137695313,251.9564666748047],[259.17437438964845,252.141064453125],[258.78147583007814,252.3247283935547],[258.38824768066405,252.50723876953126],[257.99444274902345,252.68840332031252],[257.59995117187503,252.86857910156252],[257.20521240234376,253.04754638671875],[256.80970458984376,253.22549743652345],[256.4138397216797,253.40218505859374],[256.01731567382814,253.57730712890626],[255.62032470703124,253.75124816894532],[255.2227294921875,253.92398071289062],[254.8245574951172,254.0954772949219],[254.42580871582032,254.26562805175783],[254.0263458251953,254.4341033935547],[253.62622375488283,254.60128784179688],[253.22568969726564,254.7670440673828],[252.8246612548828,254.9313720703125],[252.4229461669922,255.09432678222657],[252.02007751464845,255.255029296875],[251.61652221679688,255.41317749023438],[251.21189575195314,255.56885375976563],[250.80630798339845,255.72205810546876],[250.39984130859375,255.8730651855469],[249.99249572753908,256.02154541015625],[249.5845733642578,256.16782836914064],[249.17552490234377,256.3117218017578],[248.7660369873047,256.4538848876953],[248.3558074951172,256.5941528320313],[247.94486389160156,256.7321685791016],[247.5331787109375,256.8682891845703],[247.12102661132812,257.0026519775391],[246.7083526611328,257.1354217529297],[246.29504699707033,257.2666259765625],[245.8813018798828,257.3960723876953],[245.46708984375002,257.5238433837891],[245.05235595703127,257.65032348632815],[244.6373474121094,257.7754302978516],[244.2218994140625,257.89935607910155],[243.80609436035158,258.02199096679686],[243.38987731933594,258.1433349609375],[242.97330322265626,258.2637176513672],[242.5566192626953,258.3830841064453],[242.13966064453126,258.50157165527344],[241.72239990234377,258.6192626953125],[241.30475463867188,258.73601989746095],[240.88702697753908,258.85178833007814],[240.4689697265625,258.96733703613285],[240.05099487304688,259.08250122070314],[239.63280029296877,259.19675903320314],[239.21460571289063,259.31101684570314],[238.79627380371093,259.42461547851565],[238.37785949707032,259.5380767822266],[237.9594451904297,259.65142822265625],[237.54094848632812,259.7646148681641],[237.1224792480469,259.8778015136719],[236.70398254394533,259.9909881591797],[236.28551330566407,260.1041748046875],[235.8669891357422,260.21716918945316],[235.44835510253907,260.32972412109376],[235.02936401367188,260.4409881591797],[234.60987854003906,260.55112609863284],[234.19031066894533,260.66022033691405],[233.77033081054688,260.7683807373047],[233.35026855468752,260.87555236816405],[232.9299041748047,260.9815155029297],[232.5093200683594,261.086572265625],[232.0885437011719,261.19077758789064],[231.66749267578126,261.2941589355469],[231.24627685546875,261.3966888427735],[230.82481384277344,261.4982574462891],[230.40326843261718,261.5987823486328],[229.98146209716796,261.69886779785156],[229.5594497680664,261.7987060546875],[229.1372314453125,261.8970886230469],[228.71480712890624,261.99549865722656],[228.2923828125,262.092919921875],[227.86982116699218,262.1897644042969],[227.4471908569336,262.2864990234375],[227.02434082031252,262.3820526123047],[226.60147705078126,262.4776062011719],[226.17861328125,262.57252807617186],[225.7555160522461,262.66701049804686],[225.3324188232422,262.76149291992186],[224.90906066894533,262.85479431152345],[224.48570251464844,262.9481231689453],[224.06234436035157,263.0414245605469],[223.63898620605468,263.13475341796874],[223.21562805175782,263.2280548095703],[222.79198150634767,263.32061462402345],[222.36822509765625,263.41314697265625],[221.94468841552734,263.50562438964846],[221.5211380004883,263.5981018066406],[221.09760131835938,263.6905792236328],[220.6740509033203,263.7830841064453],[220.25052795410156,263.87561645507816],[219.82699127197267,263.96814880371096],[219.40345458984376,264.06068115234376],[218.979931640625,264.15318603515624],[218.55665588378906,264.2464050292969],[218.1333251953125,264.3398162841797],[217.7099807739258,264.4332550048828],[217.28665008544922,264.52666625976565],[216.86334686279298,264.62070922851564],[216.44000244140625,264.71513671875],[216.0168914794922,264.8095367431641],[215.59376678466796,264.90393676757816],[215.170751953125,264.9985565185547],[214.74781951904296,265.09372558593753],[214.3248733520508,265.1889221191406],[213.9019271850586,265.2840911865234],[213.47899475097657,265.37928771972656],[213.05614471435547,265.4750061035156],[212.63334960937502,265.57080688476566],[212.21054077148438,265.66663513183596],[211.78774566650392,265.76243591308594],[211.3650329589844,265.8584289550781],[210.94238891601563,265.95488891601565],[210.51952514648437,266.05140380859376],[210.09686737060548,266.1478637695313],[209.67422332763672,266.24432373046875],[209.2515655517578,266.3408111572266],[208.82890777587892,266.43727111816406],[208.40626373291016,266.5337310791016],[207.98360595703124,266.63019104003905],[207.56096191406252,266.7266510009766],[207.13827667236328,266.82355041503905],[206.71572875976562,266.9204772949219],[206.29318084716797,267.0173767089844],[205.87063293457032,267.1143035888672],[205.44808502197267,267.2112030029297],[205.025537109375,267.3081298828125],[204.60276947021484,267.40508422851565],[204.1802215576172,267.50201110839845],[203.75767364501954,267.59893798828125],[203.3352493286133,267.69580993652346],[202.91270141601564,267.79270935058594],[202.490153503418,267.88963623046874],[202.0676055908203,267.9865356445313],[201.64505767822266,268.08343505859375],[201.222509765625,268.18036193847655],[200.7999481201172,268.2772613525391],[200.37740020751954,268.37416076660156],[199.9548522949219,268.47108764648436],[199.5323043823242,268.5679870605469],[199.1097152709961,268.6647216796875],[198.68683776855468,268.76123657226566],[198.26419372558595,268.8576965332031],[197.84153594970704,268.95415649414065],[197.41889190673828,269.0506164550781],[196.9962341308594,269.14707641601564],[196.57359008789064,269.24353637695316],[196.15093231201172,269.34002380371095],[195.72827453613283,269.4364837646485],[195.30563049316407,269.53294372558594],[194.8828079223633,269.6291015625],[194.46001281738282,269.72498474121096],[194.0372314453125,269.8208404541016],[193.61443634033205,269.9166961669922],[193.19164123535157,270.01255187988284],[192.76855773925783,270.10810546875],[192.34563903808595,270.2034118652344],[191.92272033691407,270.29869079589844],[191.4998016357422,270.3939697265625],[191.0768829345703,270.48927612304686],[190.65392303466797,270.584033203125],[190.2308532714844,270.67865295410155],[189.8077835083008,270.77324523925785],[189.38471374511718,270.8678375244141],[188.9616439819336,270.96245727539065],[188.53829956054688,271.05633544921875],[188.1150375366211,271.1501037597656],[187.69178924560546,271.2438995361328],[187.2685272216797,271.3376678466797],[186.84514160156252,271.43132629394535],[186.4216735839844,271.5241333007813],[185.99820556640626,271.6169403076172],[185.57473754882812,271.7097473144531],[185.15125579833986,271.8025268554688],[184.7275405883789,271.8948669433594],[184.30382537841797,271.9865203857422],[183.88011016845704,272.0782012939453],[183.45638122558594,272.16985473632815],[183.032666015625,272.2615081787109],[182.60882720947265,272.3523376464844],[182.1848922729492,272.44305725097655],[181.76083374023438,272.53333740234376],[181.3367477416992,272.6232879638672],[180.91235961914063,272.7130462646484],[180.4881088256836,272.80222778320314],[180.06395416259767,272.89129943847655],[179.63953857421876,272.9796569824219],[179.21512298583986,273.0680419921875],[178.79046020507812,273.1555206298828],[178.36585235595703,273.2429992675781],[177.94123077392578,273.32959899902346],[177.51641693115235,273.4160888671875],[177.09127349853517,273.50183715820316],[176.66625366210937,273.5873107910156],[176.24109649658203,273.6719879150391],[175.8158432006836,273.7563079833985],[175.390576171875,273.83977661132815],[174.96488342285156,273.92291564941405],[174.5391632080078,274.0050933837891],[174.11342926025392,274.0868591308594],[173.6875717163086,274.1675537109375],[173.26156311035157,274.2479187011719],[172.83523864746095,274.32688293457034],[172.40880432128907,274.40565490722656],[171.98219146728516,274.4826965332031],[171.5556884765625,274.559326171875],[171.12873229980468,274.63452758789066],[170.70154266357423,274.708740234375],[170.2742431640625,274.7819091796875],[169.84661407470705,274.853759765625],[169.41890258789064,274.92396240234376],[168.99061431884766,274.992626953125],[168.562353515625,275.0596160888672],[168.1337631225586,275.12481994628905],[167.70480194091797,275.18779907226565],[167.27552490234376,275.24866333007816],[166.84601440429688,275.30694580078125],[166.4161605834961,275.3623992919922],[165.98567504882814,275.4146942138672],[165.55484619140626,275.46328125],[165.12374267578124,275.5074188232422],[164.69191131591796,275.54664001464846],[164.25970916748048,275.5799011230469],[163.82693023681642,275.6054718017578],[163.3936294555664,275.62140197753905],[162.9599853515625,275.62140197753905],[162.5309829711914,275.56243286132815],[162.11248626708985,275.4498229980469],[161.70659637451172,275.298046875],[161.3134780883789,275.1158111572266],[160.93291168212892,274.90814208984375],[160.5652816772461,274.6786376953125],[160.2106430053711,274.4292755126953],[159.8698745727539,274.16142883300785],[159.54388275146485,273.87559204101564],[159.2346176147461,273.5719848632813],[158.94424896240236,273.2500854492188],[158.67625122070314,272.9095916748047],[158.43521118164062,272.54932250976566],[158.2283660888672,272.1682067871094],[158.08624420166015,271.75946044921875],[158.01955718994142,271.33154296875],[158.01358337402345,270.8982421875],[158.05046997070312,270.4665893554688],[158.11456146240235,270.0376831054688],[158.19227600097656,269.61130371093753],[158.2717758178711,269.18511657714845],[158.34200592041017,268.7573913574219],[158.38979644775392,268.32658996582035],[158.41841583251954,267.89397583007815],[158.45940856933595,267.4624053955078],[158.5121292114258,267.0323455810547],[158.5740509033203,266.6032196044922],[158.64277038574218,266.175],[158.715966796875,265.7476043701172],[158.79129180908203,265.3206756591797],[158.86664428710938,264.8937194824219],[158.93978576660157,264.4664611816406],[159.00887603759767,264.0384887695313],[159.07103118896484,263.6094451904297],[159.1241638183594,263.17930297851564],[159.16573333740234,262.7477600097656],[159.19282836914064,262.3151458740235],[159.20318298339845,261.8817077636719],[159.1935562133789,261.4484344482422],[159.1613525390625,261.0159851074219],[159.1040451049805,260.5864196777344],[159.01936798095704,260.16111145019534],[158.90618133544922,259.7427520751953],[158.76504821777345,259.3328521728516],[158.59774017333984,258.9328948974609],[158.40547943115234,258.5446380615235],[158.18895263671877,258.1689880371094],[157.94913482666016,257.8080596923828],[157.68627319335937,257.46330871582035],[157.4007110595703,257.13726196289065],[157.09273681640624,256.83217163085936],[156.76305084228517,256.5511413574219],[156.41130981445312,256.29771423339844],[156.03668975830078,256.07977294921875],[155.64336547851562,255.8981689453125],[155.23514099121095,255.7518035888672],[154.8163833618164,255.64029235839845],[154.38979797363282,255.56341552734375],[153.95852966308595,255.52144775390624],[153.52503662109376,255.51546020507814],[153.09264221191407,255.54633178710938],[152.66368103027344,255.60741577148437],[152.2390869140625,255.69525146484375],[151.82031555175783,255.80733947753907],[151.40819091796877,255.94161987304688],[151.00313873291017,256.09559326171876],[150.6052001953125,256.26758422851566],[150.21445770263674,256.45545043945316],[149.83092498779297,256.6575164794922],[149.4541763305664,256.87224426269535],[149.0840606689453,257.0979858398438],[148.72022094726563,257.33372497558594],[148.36231384277343,257.57825317382816],[148.00958404541015,257.83025207519535],[147.66124877929687,258.0884582519531],[147.3137649536133,258.3476806640625],[146.9662811279297,258.6069030761719],[146.61909942626954,258.8667022705078],[146.2722610473633,259.1268035888672],[145.92542266845703,259.3868774414063],[145.57903747558595,259.6475555419922],[145.23280334472656,259.90845336914066],[144.88658294677734,260.1693511962891],[144.5406509399414,260.43104553222656],[144.1949935913086,260.69268493652345],[143.84943237304688,260.954296875],[143.50428314208986,261.2166229248047],[143.1591339111328,261.4789489746094],[142.81413574218752,261.741357421875],[142.46945343017578,262.00428771972656],[142.12477111816406,262.2672454833984],[141.78030853271486,262.53050537109374],[141.43621673583985,262.7942321777344],[141.09212493896484,263.0579315185547],[140.748046875,263.3216583251953],[140.403955078125,263.5853576660156],[140.05986328125002,263.8490844726563],[139.71604614257814,264.1136901855469],[139.37255859375,264.37818603515626],[139.0290710449219,264.64268188476564],[138.68558349609376,264.907177734375],[138.34209594726562,265.1716735839844],[137.99891052246093,265.4362518310547],[137.65579376220703,265.7012420654297],[137.31267700195312,265.96620483398436],[136.9695602416992,266.2311676025391],[136.6264434814453,266.49615783691405],[136.28318939208984,266.76123046875],[135.94012756347658,267.0262756347656],[135.59705200195313,267.29132080078125],[135.25399017333984,267.5563659667969],[134.91074981689454,267.82154846191406],[134.56768798828125,268.0865936279297],[134.22462615966796,268.351611328125],[133.8815643310547,268.6166564941406],[133.53850250244142,268.88170166015624],[133.19542694091797,269.14674682617186],[132.85236511230468,269.4117919921875],[132.5092758178711,269.6765075683594],[132.1657470703125,269.9409484863281],[131.8222183227539,270.2053894042969],[131.47868957519532,270.4698028564453],[131.13516082763672,270.7342437744141],[130.79143981933595,270.99876708984374],[130.44745788574218,271.2626037597656],[130.10329742431642,271.5266052246094],[129.75921936035158,271.79013977050784],[129.41485290527345,272.05348205566406],[129.07047271728516,272.31682434082035],[128.72573547363282,272.579672241211],[128.3809020996094,272.84238281250003],[128.035986328125,273.1049835205078],[127.69063110351563,273.3670623779297],[127.34527587890625,273.6291137695313],[126.99953613281251,273.8907806396484],[126.65360412597657,274.15203552246095],[126.30765838623047,274.41331787109374],[125.96121826171876,274.6737762451172],[125.61464080810548,274.9342071533203],[125.2676513671875,275.19455566406253],[124.9203872680664,275.454052734375],[124.57312316894532,275.7135498046875],[124.22543334960938,275.9723327636719],[123.87740020751953,276.23084106445316],[123.52931213378906,276.4893493652344],[123.18046875,276.7467315673828],[122.83162536621094,277.0041412353516],[122.48247985839843,277.26108398437503],[122.13278503417969,277.51731262207034],[121.78307647705078,277.77354125976564],[121.43272247314454,278.02886352539065],[121.08212127685547,278.2838562011719],[120.73147888183594,278.5387390136719],[120.3797378540039,278.7925231933594],[120.0281753540039,279.04619750976565],[119.67620086669922,279.29954223632814],[119.32391052246093,279.55206298828125],[118.97109832763672,279.8039794921875],[118.61792907714845,280.0553741455078],[118.26447143554688,280.3062469482422]],
	bounds=3000,
	full_zoom=0.24,
	max_episode_steps=1500
)

Brazil = RaceTrack(
	name='Brazil',
	xy=[[525.9970703125,384.6461181640625],[526.5438842773438,384.4936218261719],[527.0906372070312,384.34112548828125],[527.637451171875,384.1886291503906],[528.1842041015625,384.0361328125],[528.7310180664062,383.88360595703125],[529.27783203125,383.7311096191406],[529.8245849609375,383.57861328125],[530.3713989257812,383.4262390136719],[530.9183959960938,383.27447509765625],[531.4653930664062,383.1227111816406],[532.0123901367188,382.970947265625],[532.5593872070312,382.8191833496094],[533.1063842773438,382.66741943359375],[533.6533813476562,382.515625],[534.2003784179688,382.3638610839844],[534.7474365234375,382.2123107910156],[535.2946166992188,382.06121826171875],[535.841796875,381.91009521484375],[536.3889770507812,381.7590026855469],[536.9361572265625,381.6078796386719],[537.4833374023438,381.456787109375],[538.030517578125,381.3056640625],[538.5776977539062,381.1545715332031],[539.1249389648438,381.00372314453125],[539.6722412109375,380.85321044921875],[540.2196044921875,380.7026672363281],[540.7669677734375,380.5521240234375],[541.3142700195312,380.401611328125],[541.8616333007812,380.2510681152344],[542.408935546875,380.10052490234375],[542.956298828125,379.95001220703125],[543.5037231445312,379.7999267578125],[544.05126953125,379.6501159667969],[544.5988159179688,379.5002746582031],[545.1463623046875,379.3504638671875],[545.69384765625,379.2006530761719],[546.2413940429688,379.05084228515625],[546.7889404296875,378.9010009765625],[547.3364868164062,378.7511901855469],[547.8839721679688,378.60137939453125],[548.4315185546875,378.4515380859375],[548.9790649414062,378.3017272949219],[549.526611328125,378.15191650390625],[550.0740966796875,378.0021057128906],[550.6216430664062,377.8522644042969],[551.169189453125,377.70245361328125],[551.7167358398438,377.5526428222656],[552.264404296875,377.4034729003906],[552.8121337890625,377.25433349609375],[553.35986328125,377.1051940917969],[553.9075927734375,376.9560546875],[554.4552612304688,376.8069152832031],[555.0029907226562,376.65777587890625],[555.5507202148438,376.5086669921875],[556.0984497070312,376.3595275878906],[556.6461791992188,376.21038818359375],[557.1939086914062,376.0612487792969],[557.7415771484375,375.912109375],[558.289306640625,375.76300048828125],[558.8370361328125,375.6138610839844],[559.384765625,375.4647216796875],[559.9324951171875,375.3155822753906],[560.480224609375,375.16656494140625],[561.028076171875,375.017822265625],[561.5758666992188,374.8691101074219],[562.1237182617188,374.7203674316406],[562.6715087890625,374.5716552734375],[563.2193603515625,374.42291259765625],[563.7672119140625,374.2742004394531],[564.3150024414062,374.1254577636719],[564.8628540039062,373.9767150878906],[565.41064453125,373.8280029296875],[565.95849609375,373.67926025390625],[566.50634765625,373.5305480957031],[567.0541381835938,373.3818054199219],[567.6019897460938,373.23309326171875],[568.1498413085938,373.0843505859375],[568.6976318359375,372.9356384277344],[569.2454833984375,372.7868957519531],[569.7932739257812,372.63818359375],[570.3411254882812,372.48944091796875],[570.8889770507812,372.3407287597656],[571.436767578125,372.1919860839844],[571.984619140625,372.04327392578125],[572.532470703125,371.89453125],[573.0802612304688,371.7458190917969],[573.6281127929688,371.5970764160156],[574.1759033203125,371.4483337402344],[574.7237548828125,371.29962158203125],[575.2716064453125,371.15087890625],[575.8193969726562,371.0021667480469],[576.3672485351562,370.8534240722656],[576.9151000976562,370.7047119140625],[577.462890625,370.55596923828125],[578.0106811523438,370.40704345703125],[578.5584716796875,370.25811767578125],[579.106201171875,370.1091613769531],[579.6539916992188,369.960205078125],[580.2017211914062,369.8112487792969],[580.74951171875,369.66229248046875],[581.2973022460938,369.5133361816406],[581.8450317382812,369.3644104003906],[582.392822265625,369.2154541015625],[582.9406127929688,369.0664978027344],[583.4883422851562,368.91754150390625],[584.0361328125,368.7685852050781],[584.5838623046875,368.61962890625],[585.1316528320312,368.4706726074219],[585.679443359375,368.3217468261719],[586.2271728515625,368.1726989746094],[586.7747802734375,368.0231628417969],[587.3223876953125,367.8736572265625],[587.8699951171875,367.72412109375],[588.4176025390625,367.5746154785156],[588.9652099609375,367.4250793457031],[589.5128173828125,367.27557373046875],[590.0604858398438,367.1260681152344],[590.6080932617188,366.9765319824219],[591.1557006835938,366.8270263671875],[591.7033081054688,366.677490234375],[592.2509155273438,366.5279846191406],[592.7985229492188,366.37847900390625],[593.3461303710938,366.22894287109375],[593.8937377929688,366.0794372558594],[594.4413452148438,365.9299011230469],[594.9888916015625,365.77996826171875],[595.5362548828125,365.62957763671875],[596.0836181640625,365.47918701171875],[596.6309814453125,365.3287658691406],[597.1783447265625,365.1783752441406],[597.7257080078125,365.0279846191406],[598.2731323242188,364.8775939941406],[598.8204956054688,364.7271728515625],[599.3678588867188,364.5767822265625],[599.9152221679688,364.4263916015625],[600.4625854492188,364.2760009765625],[601.0099487304688,364.1255798339844],[601.5573120117188,363.9751892089844],[602.104736328125,363.8247985839844],[602.652099609375,363.6744079589844],[603.199462890625,363.52398681640625],[603.7466430664062,363.3729248046875],[604.2937622070312,363.2216796875],[604.8409423828125,363.0704345703125],[605.3880615234375,362.9191589355469],[605.9351806640625,362.7679138183594],[606.4822998046875,362.6166687011719],[607.0294799804688,362.4654235839844],[607.5765991210938,362.3141784667969],[608.12353515625,362.1622619628906],[608.6705322265625,362.0103454589844],[609.2174682617188,361.8583984375],[609.764404296875,361.70648193359375],[610.3113403320312,361.5545654296875],[610.8583374023438,361.4026184082031],[611.4052734375,361.2507019042969],[611.9522094726562,361.09869384765625],[612.4989013671875,360.9460144042969],[613.045654296875,360.7933044433594],[613.5924072265625,360.640625],[614.13916015625,360.4879455566406],[614.6859130859375,360.33526611328125],[615.2326049804688,360.1825866699219],[615.7793579101562,360.0299072265625],[616.3260498046875,359.87701416015625],[616.87255859375,359.7234802246094],[617.4190673828125,359.5699768066406],[617.965576171875,359.4164733886719],[618.5120849609375,359.2629699707031],[619.05859375,359.10943603515625],[619.6051025390625,358.9559326171875],[620.151611328125,358.80242919921875],[620.697998046875,358.6485290527344],[621.2442626953125,358.4941101074219],[621.7904663085938,358.3396911621094],[622.3367309570312,358.1852722167969],[622.8829956054688,358.0308532714844],[623.4292602539062,357.8764343261719],[623.9755249023438,357.7220153808594],[624.521728515625,357.5675964355469],[625.0678100585938,357.41259765625],[625.6138305664062,357.2571716308594],[626.1597900390625,357.1017761230469],[626.7057495117188,356.9463806152344],[627.251708984375,356.79095458984375],[627.7976684570312,356.63555908203125],[628.3436889648438,356.4801330566406],[628.8896484375,356.3247375488281],[629.4353637695312,356.16851806640625],[629.9810791015625,356.0120544433594],[630.5267333984375,355.8555908203125],[631.0723876953125,355.6991271972656],[631.6180419921875,355.54266357421875],[632.1636962890625,355.3861999511719],[632.7094116210938,355.2297058105469],[633.2550659179688,355.0732421875],[633.8004150390625,354.9157409667969],[634.3457641601562,354.75811767578125],[634.89111328125,354.6004943847656],[635.4364013671875,354.44287109375],[635.9817504882812,354.2852478027344],[636.527099609375,354.12762451171875],[637.0724487304688,353.9700012207031],[637.6177368164062,353.8122863769531],[638.1627197265625,353.6534729003906],[638.7077026367188,353.49462890625],[639.252685546875,353.3357849121094],[639.7976684570312,353.17694091796875],[640.3426513671875,353.0180969238281],[640.8876342773438,352.8592529296875],[641.4326171875,352.7004089355469],[641.9775390625,352.541259765625],[642.5220947265625,352.3811340332031],[643.0667114257812,352.2209777832031],[643.611328125,352.06085205078125],[644.1559448242188,351.90069580078125],[644.7005615234375,351.7405700683594],[645.2451171875,351.5804138183594],[645.7897338867188,351.4202880859375],[646.3341674804688,351.25958251953125],[646.8783569335938,351.09808349609375],[647.4225463867188,350.9365539550781],[647.9667358398438,350.7750244140625],[648.5109252929688,350.613525390625],[649.0551147460938,350.4519958496094],[649.599365234375,350.2904968261719],[650.1435546875,350.12896728515625],[650.6875,349.96661376953125],[651.2312622070312,349.80364990234375],[651.7750244140625,349.64068603515625],[652.3187866210938,349.47772216796875],[652.862548828125,349.31475830078125],[653.4063110351562,349.15179443359375],[653.9500732421875,348.9888000488281],[654.4938354492188,348.8258361816406],[655.0372314453125,348.6617126464844],[655.5805053710938,348.4972229003906],[656.1238403320312,348.3327331542969],[656.6671142578125,348.168212890625],[657.21044921875,348.00372314453125],[657.7537231445312,347.8392028808594],[658.2969970703125,347.6747131347656],[658.84033203125,347.5102233886719],[659.3831787109375,347.34423828125],[659.9259643554688,347.1781005859375],[660.4688110351562,347.0119934082031],[661.0115966796875,346.84588623046875],[661.5543823242188,346.6797790527344],[662.0972290039062,346.513671875],[662.6400756835938,346.3475646972656],[663.1827392578125,346.1811828613281],[663.72412109375,346.0104675292969],[664.2635498046875,345.83355712890625],[664.8008422851562,345.650390625],[665.335693359375,345.4603576660156],[665.8682861328125,345.26397705078125],[666.3983764648438,345.0609436035156],[666.92578125,344.8509216308594],[667.4505004882812,344.6343078613281],[667.972412109375,344.4111328125],[668.4913330078125,344.18096923828125],[669.0072021484375,343.9442138671875],[669.5201416015625,343.7010498046875],[670.0300903320312,343.4516906738281],[670.5369873046875,343.1961975097656],[671.040771484375,342.9345703125],[671.5415649414062,342.6673278808594],[672.0394897460938,342.39471435546875],[672.5346069335938,342.1170654296875],[673.027099609375,341.834716796875],[673.5170288085938,341.54803466796875],[674.0042114257812,341.2566833496094],[674.4895629882812,340.9622802734375],[674.972900390625,340.6646423339844],[675.4544677734375,340.36407470703125],[675.9344482421875,340.0610046386719],[676.4129638671875,339.755615234375],[676.8901977539062,339.44830322265625],[677.3662719726562,339.13909912109375],[677.842041015625,338.8294372558594],[678.3172607421875,338.51898193359375],[678.7919921875,338.2077331542969],[679.2667236328125,337.8964538574219],[679.7413330078125,337.5851135253906],[680.2160034179688,337.27374267578125],[680.6912231445312,336.9632263183594],[681.1666259765625,336.6531066894531],[681.6420288085938,336.34283447265625],[682.1152954101562,336.0293884277344],[682.5841064453125,335.7093200683594],[683.048095703125,335.3823547363281],[683.5074462890625,335.0488586425781],[683.9618530273438,334.7086486816406],[684.4111938476562,334.36175537109375],[684.8552856445312,334.0081787109375],[685.2939453125,333.6479187011719],[685.7272338867188,333.2811584472656],[686.1548461914062,332.9078674316406],[686.5767822265625,332.5281066894531],[686.9928588867188,332.14202880859375],[687.4031372070312,331.7497253417969],[687.8076171875,331.3514099121094],[688.2061767578125,330.9472351074219],[688.598876953125,330.5373229980469],[688.9857788085938,330.1219177246094],[689.3668212890625,329.701171875],[689.7421264648438,329.2752685546875],[690.11181640625,328.8445129394531],[690.4759521484375,328.4090270996094],[690.834716796875,327.96917724609375],[691.1881713867188,327.5249938964844],[691.53662109375,327.07684326171875],[691.8800659179688,326.6248779296875],[692.21875,326.1693420410156],[692.5528564453125,325.71038818359375],[692.882568359375,325.2483215332031],[693.2081298828125,324.7832946777344],[693.5294799804688,324.31536865234375],[693.8474731445312,323.84515380859375],[694.1619262695312,323.3725280761719],[694.4730224609375,322.8977355957031],[694.769775390625,322.41387939453125],[695.045166015625,321.91754150390625],[695.3002319335938,321.41046142578125],[695.5360107421875,320.8941345214844],[695.75390625,320.3700256347656],[695.9542236328125,319.8388977050781],[696.1383056640625,319.3019714355469],[696.3063354492188,318.7597961425781],[696.4595947265625,318.2132263183594],[696.5977172851562,317.66265869140625],[696.7220458984375,317.1087951660156],[696.8323974609375,316.552001953125],[696.9293212890625,315.99267578125],[697.0133056640625,315.4312744140625],[697.0838623046875,314.8680725097656],[697.1417846679688,314.3033752441406],[697.1868286132812,313.7375183105469],[697.2188110351562,313.1707763671875],[697.2380981445312,312.6034851074219],[697.2435913085938,312.0358581542969],[697.2362060546875,311.46826171875],[697.2142944335938,310.90106201171875],[697.178466796875,310.3345642089844],[697.1272583007812,309.7692565917969],[697.060302734375,309.20556640625],[696.9760131835938,308.6442565917969],[696.865234375,308.08758544921875],[696.7280883789062,307.5367736816406],[696.56689453125,306.9925537109375],[696.3836669921875,306.455322265625],[696.1801147460938,305.9254455566406],[695.9580688476562,305.4030456542969],[695.7190551757812,304.8882141113281],[695.46435546875,304.3809509277344],[695.1951904296875,303.8811950683594],[694.9125366210938,303.3889465332031],[694.6170654296875,302.90423583984375],[694.3099365234375,302.4268798828125],[693.9917602539062,301.956787109375],[693.6632080078125,301.4939270019531],[693.3244018554688,301.0384521484375],[692.9761962890625,300.59014892578125],[692.6190795898438,300.14892578125],[692.2530517578125,299.71502685546875],[691.87841796875,299.2885437011719],[691.4957275390625,298.8693542480469],[691.1048583984375,298.45770263671875],[690.7059936523438,298.0538024902344],[690.300537109375,297.6565246582031],[689.892822265625,297.26153564453125],[689.4830322265625,296.8687438964844],[689.0711669921875,296.4781188964844],[688.6572875976562,296.089599609375],[688.2415161132812,295.7030944824219],[687.823974609375,295.318603515625],[687.4046020507812,294.93597412109375],[686.9835815429688,294.55523681640625],[686.5609741210938,294.1762390136719],[686.1369018554688,293.79888916015625],[685.7113647460938,293.4231872558594],[685.284423828125,293.0490417480469],[684.8562622070312,292.6763610839844],[684.4268798828125,292.3050537109375],[683.9959106445312,291.9355773925781],[683.5650024414062,291.56610107421875],[683.132080078125,291.1988830566406],[682.6991577148438,290.8316955566406],[682.2647705078125,290.46630859375],[681.8302612304688,290.10101318359375],[681.3946533203125,289.73699951171875],[680.9589233398438,289.3731689453125],[680.5223999023438,289.01025390625],[680.0857543945312,288.64752197265625],[679.6486206054688,288.285400390625],[679.2113647460938,287.92340087890625],[678.7741088867188,287.5614013671875],[678.3368530273438,287.19940185546875],[677.8998413085938,286.8371276855469],[677.462890625,286.4747619628906],[677.0259399414062,286.11236572265625],[676.5890502929688,285.7499694824219],[676.15283203125,285.38671875],[675.717041015625,285.0229797363281],[675.281982421875,284.6582946777344],[674.847412109375,284.2930908203125],[674.413818359375,283.9267272949219],[673.9808349609375,283.5596008300781],[673.5490112304688,283.191162109375],[673.1180419921875,282.82171630859375],[672.68798828125,282.4512023925781],[672.2593994140625,282.0789794921875],[671.8320922851562,281.70526123046875],[671.4061889648438,281.3299865722656],[670.9818115234375,280.9530029296875],[670.5589599609375,280.5742492675781],[670.1378173828125,280.1936340332031],[669.7184448242188,279.81103515625],[669.3009643554688,279.4264221191406],[668.8854370117188,279.0396728515625],[668.4720458984375,278.6506652832031],[668.060791015625,278.2593994140625],[667.6517333984375,277.8658142089844],[667.2450561523438,277.4697570800781],[666.8408813476562,277.0711975097656],[666.439208984375,276.6700439453125],[666.0402221679688,276.26629638671875],[665.6439819335938,275.85980224609375],[665.2505493164062,275.4505920410156],[664.8600463867188,275.0386047363281],[664.4725952148438,274.6237487792969],[664.0882568359375,274.2060241699219],[663.7071533203125,273.7853088378906],[663.329345703125,273.3616638183594],[662.9548950195312,272.93499755859375],[662.59423828125,272.49676513671875],[662.2579345703125,272.0395202636719],[661.9489135742188,271.5634460449219],[661.670654296875,271.06878662109375],[661.425537109375,270.55694580078125],[661.2155151367188,270.0296630859375],[661.0415649414062,269.4894714355469],[660.9031982421875,268.93902587890625],[660.7986450195312,268.3811950683594],[660.7252197265625,267.818359375],[660.6796264648438,267.2525939941406],[660.6578979492188,266.6853942871094],[660.6558837890625,266.1177673339844],[660.6697998046875,265.5502624511719],[660.6958618164062,264.9832458496094],[660.7308959960938,264.4166564941406],[660.771484375,263.8504638671875],[660.8139038085938,263.2843933105469],[660.85693359375,262.7183837890625],[660.8983764648438,262.1522521972656],[660.9356079101562,261.5858154296875],[660.9669189453125,261.0190124511719],[660.9942016601562,260.4520263671875],[661.038330078125,259.8861083984375],[661.1022338867188,259.3221130371094],[661.1851196289062,258.7605895996094],[661.2854614257812,258.20184326171875],[661.4020385742188,257.6463623046875],[661.5336303710938,257.09417724609375],[661.6788940429688,256.5454406738281],[661.8367919921875,256.00018310546875],[662.006103515625,255.45840454101562],[662.1858520507812,254.9199676513672],[662.375244140625,254.38482666015625],[662.5736083984375,253.85293579101562],[662.7796020507812,253.32398986816406],[662.99267578125,252.7978515625],[663.2119750976562,252.27426147460938],[663.4367065429688,251.7530059814453],[663.6665649414062,251.2339630126953],[663.9002075195312,250.7166290283203],[664.137451171875,250.200927734375],[664.3776245117188,249.6865997314453],[664.6201782226562,249.17335510253906],[664.8644409179688,248.6609344482422],[665.110107421875,248.14918518066406],[665.3558349609375,247.63748168945312],[665.6015625,247.12574768066406],[665.84716796875,246.61399841308594],[666.0911865234375,246.10145568847656],[666.3331909179688,245.58799743652344],[666.5726318359375,245.07330322265625],[666.8096313476562,244.5574951171875],[667.046875,244.04177856445312],[667.2864990234375,243.52719116210938],[667.5283203125,243.0135955810547],[667.7724609375,242.50111389160156],[668.0185546875,241.98959350585938],[668.266357421875,241.4788818359375],[668.5159301757812,240.96902465820312],[668.7670288085938,240.4599151611328],[669.0198364257812,239.9517059326172],[669.2738647460938,239.44400024414062],[669.5285034179688,238.93667602539062],[669.78515625,238.43035888671875],[670.0418090820312,237.9240264892578],[670.3005981445312,237.4187774658203],[670.5594482421875,236.91357421875],[670.8193969726562,236.40892028808594],[671.0799560546875,235.9045867919922],[671.3410034179688,235.4005584716797],[671.603271484375,234.89710998535156],[671.865478515625,234.39364624023438],[672.1277465820312,233.89019775390625],[672.3899536132812,233.38673400878906],[672.6527709960938,232.8835906982422],[672.9158935546875,232.38058471679688],[673.1790161132812,231.87759399414062],[673.4420776367188,231.3745880126953],[673.7052001953125,230.87158203125],[673.9676513671875,230.36822509765625],[674.22998046875,229.8648223876953],[674.4923706054688,229.36143493652344],[674.7546997070312,228.85804748535156],[675.0167846679688,228.35452270507812],[675.2776489257812,227.850341796875],[675.5384521484375,227.34616088867188],[675.798095703125,226.84132385253906],[676.0573120117188,226.33633422851562],[676.3157348632812,225.8309326171875],[676.5730590820312,225.32489013671875],[676.8302612304688,224.81884765625],[677.0851440429688,224.31163024902344],[677.3400268554688,223.80442810058594],[677.5935668945312,223.2965087890625],[677.8456420898438,222.7878875732422],[678.096435546875,222.27865600585938],[678.3458862304688,221.76876831054688],[678.59375,221.25808715820312],[678.8399658203125,220.74656677246094],[679.08447265625,220.23426818847656],[679.3272705078125,219.72117614746094],[679.5682373046875,219.20718383789062],[679.8072509765625,218.69232177734375],[680.0443115234375,218.17654418945312],[680.2789916992188,217.65968322753906],[680.5112915039062,217.14170837402344],[680.7412109375,216.62269592285156],[680.9686279296875,216.10260009765625],[681.1934204101562,215.58135986328125],[681.41552734375,215.0589599609375],[681.634765625,214.5353546142578],[681.8509521484375,214.01046752929688],[682.0640869140625,213.4843292236328],[682.2733764648438,212.95668029785156],[682.4791870117188,212.4276580810547],[682.6812744140625,211.89718627929688],[682.8800048828125,211.36544799804688],[683.0744018554688,210.83209228515625],[683.264404296875,210.2971954345703],[683.4498901367188,209.76071166992188],[683.6306762695312,209.22259521484375],[683.8065185546875,208.68287658691406],[683.9772338867188,208.1414794921875],[684.1424560546875,207.5984344482422],[684.3018798828125,207.05360412597656],[684.449462890625,206.50547790527344],[684.5821533203125,205.95359802246094],[684.7002563476562,205.39837646484375],[684.804443359375,204.84036254882812],[684.8952026367188,204.28004455566406],[684.9730834960938,203.7177734375],[685.0386352539062,203.15390014648438],[685.0923461914062,202.5888214111328],[685.1349487304688,202.02276611328125],[685.1665649414062,201.45602416992188],[685.1888427734375,200.88880920410156],[685.2010498046875,200.3212890625],[685.2050170898438,199.753662109375],[685.2000122070312,199.18601989746094],[685.1875610351562,198.61851501464844],[685.1676635742188,198.05123901367188],[685.1409912109375,197.4842071533203],[685.1082763671875,196.91749572753906],[685.0693969726562,196.35118103027344],[685.0255737304688,195.78521728515625],[684.9764404296875,195.2196807861328],[684.9232788085938,194.6544952392578],[684.8653564453125,194.08981323242188],[684.8049926757812,193.52537536621094],[684.7407836914062,192.9613494873047],[684.6738891601562,192.39767456054688],[684.60498046875,191.83421325683594],[684.5342407226562,191.27096557617188],[684.4611206054688,190.70803833007812],[684.3880004882812,190.14511108398438],[684.3141479492188,189.582275390625],[684.2396850585938,189.01953125],[684.1652221679688,188.45677185058594],[684.092041015625,187.89385986328125],[684.0189208984375,187.3309326171875],[683.94677734375,186.7678985595703],[683.8765869140625,186.20460510253906],[683.80908203125,185.64097595214844],[683.7442626953125,185.0770263671875],[683.681884765625,184.51280212402344],[683.6232299804688,183.94821166992188],[683.56591796875,183.38345336914062],[683.508544921875,182.81871032714844],[683.4512329101562,182.2539520263672],[683.3938598632812,181.68919372558594],[683.3356323242188,181.12451171875],[683.2764892578125,180.55995178222656],[683.2171020507812,179.9954071044922],[683.156005859375,179.43104553222656],[683.0933837890625,178.86685180664062],[683.029296875,178.30279541015625],[682.96337890625,177.73899841308594],[682.8955078125,177.1754150390625],[682.82568359375,176.612060546875],[682.7532958984375,176.0490264892578],[682.6781005859375,175.48638916015625],[682.60009765625,174.9241180419922],[682.5191650390625,174.36227416992188],[682.4351196289062,173.80088806152344],[682.347900390625,173.2399444580078],[682.2569580078125,172.67962646484375],[682.161865234375,172.1199951171875],[682.0628051757812,171.56105041503906],[681.9595947265625,171.0028839111328],[681.8515625,170.4456024169922],[681.7389526367188,169.88922119140625],[681.6215209960938,169.33384704589844],[681.4985961914062,168.7796630859375],[681.370361328125,168.22666931152344],[681.2366333007812,167.6750030517578],[681.096923828125,167.12481689453125],[680.9509887695312,166.5762481689453],[680.799072265625,166.02928161621094],[680.6405029296875,165.48423767089844],[680.4749145507812,164.9412841796875],[680.3026123046875,164.40042114257812],[680.1231689453125,163.86187744140625],[679.9358520507812,163.32601928710938],[679.7412719726562,162.79275512695312],[679.5408935546875,162.26162719726562],[679.3350219726562,161.73263549804688],[679.12451171875,161.2054443359375],[678.9088134765625,160.6803741455078],[678.6885375976562,160.15719604492188],[678.4635009765625,159.6360626220703],[678.2339477539062,159.1168975830078],[678.0000610351562,158.5996856689453],[677.76171875,158.08448791503906],[677.5193481445312,157.57115173339844],[677.2725830078125,157.0599365234375],[677.0221557617188,156.550537109375],[676.767333984375,156.04327392578125],[676.5090942382812,155.53778076171875],[676.246826171875,155.03433227539062],[675.9810791015625,154.53273010253906],[675.711669921875,154.0330810546875],[675.4388427734375,153.53529357910156],[675.16259765625,153.03939819335938],[674.8829345703125,152.5453643798828],[674.6001586914062,152.05320739746094],[674.3140869140625,151.56285095214844],[674.0250854492188,151.07427978515625],[673.73291015625,150.58763122558594],[673.4379272460938,150.1026153564453],[673.1396484375,149.61964416503906],[672.8392944335938,149.13795471191406],[672.5353393554688,148.6584930419922],[672.22900390625,148.1805877685547],[671.9203491210938,147.70423889160156],[671.6092529296875,147.22940063476562],[671.295166015625,146.75657653808594],[670.9786376953125,146.28533935546875],[670.659912109375,145.81561279296875],[670.3390502929688,145.34732055664062],[670.0157470703125,144.88076782226562],[669.68994140625,144.41590881347656],[669.362060546875,143.9524688720703],[669.0322875976562,143.49046325683594],[668.7005004882812,143.02984619140625],[668.3662719726562,142.57107543945312],[668.0313720703125,142.11270141601562],[667.6962890625,141.65451049804688],[667.3618774414062,141.19580078125],[667.0277709960938,140.7368927001953],[666.6942138671875,140.27757263183594],[666.3609008789062,139.81805419921875],[666.0276489257812,139.35853576660156],[665.6943359375,138.89901733398438],[665.3610229492188,138.43951416015625],[665.0277099609375,137.98001098632812],[664.6943969726562,137.5205078125],[664.361083984375,137.06101989746094],[664.0272827148438,136.60191345214844],[663.693115234375,136.14303588867188],[663.3583374023438,135.68458557128906],[663.0231323242188,135.22640991210938],[662.687255859375,134.76881408691406],[662.3507690429688,134.31163024902344],[662.013427734375,133.8551025390625],[661.67529296875,133.3991241455078],[661.336181640625,132.9438934326172],[660.99609375,132.48939514160156],[660.6549072265625,132.0356903076172],[660.3125610351562,131.5828857421875],[659.9693603515625,131.1307373046875],[659.62451171875,130.67984008789062],[659.2783203125,130.22999572753906],[658.9306030273438,129.78128051757812],[658.5814208984375,129.33375549316406],[658.2305297851562,128.88748168945312],[657.8780517578125,128.44256591796875],[657.5237426757812,127.99906158447266],[657.1675415039062,127.55702209472656],[656.8095092773438,127.11654663085938],[656.449462890625,126.6777114868164],[656.0873413085938,126.2405776977539],[655.7230834960938,125.80518341064453],[655.3565673828125,125.37168884277344],[654.98779296875,124.94013977050781],[654.6166381835938,124.51062774658203],[654.2430419921875,124.08325958251953],[653.866943359375,123.6580810546875],[653.48828125,123.23519134521484],[653.1068725585938,122.81468963623047],[652.7227783203125,122.39674377441406],[652.3358764648438,121.9813461303711],[651.9461059570312,121.56865692138672],[651.5534057617188,121.1587905883789],[651.15771484375,120.75180053710938],[650.7589111328125,120.34783172607422],[650.35693359375,119.9469985961914],[649.9517822265625,119.54940795898438],[649.5435791015625,119.15491485595703],[649.1318969726562,118.76412963867188],[648.7167358398438,118.376953125],[648.2982177734375,117.99349975585938],[647.8761596679688,117.6138916015625],[647.4505615234375,117.23824310302734],[647.0214233398438,116.86668395996094],[646.5885620117188,116.49942016601562],[646.152099609375,116.1364974975586],[645.7118530273438,115.77810668945312],[645.2679443359375,115.42432403564453],[644.8202514648438,115.07539367675781],[644.3688354492188,114.731201171875],[643.9149169921875,114.3902816772461],[643.4591674804688,114.05186462402344],[643.0013427734375,113.71630096435547],[642.541259765625,113.38379669189453],[642.07958984375,113.05355072021484],[641.6160888671875,112.7258071899414],[641.1506958007812,112.40070343017578],[640.6831665039062,112.07874298095703],[640.2139892578125,111.75924682617188],[639.7431640625,111.44217681884766],[639.2706909179688,111.1275405883789],[638.79638671875,110.81562805175781],[638.3201904296875,110.50662994384766],[637.8424682617188,110.20003509521484],[637.3632202148438,109.89582061767578],[636.8824462890625,109.59394836425781],[636.39990234375,109.29498291015625],[635.915771484375,108.9986572265625],[635.43017578125,108.70465850830078],[634.9431762695312,108.41300201416016],[634.4547729492188,108.12364959716797],[633.9645385742188,107.83747100830078],[633.4730224609375,107.55357360839844],[632.9801025390625,107.27197265625],[632.4859619140625,106.99263763427734],[631.990234375,106.71600341796875],[631.4930419921875,106.44212341308594],[630.9945678710938,106.17047882080078],[630.4949340820312,105.9011001586914],[629.9940795898438,105.63394927978516],[629.4915161132812,105.36997985839844],[628.9878540039062,105.10823059082031],[628.4829711914062,104.84870147705078],[627.9769897460938,104.5914306640625],[627.4695434570312,104.33692169189453],[626.9608154296875,104.08500671386719],[626.4510498046875,103.83533477783203],[625.9401245117188,103.587890625],[625.4281005859375,103.34286499023438],[624.9146728515625,103.10081481933594],[624.400146484375,102.8609848022461],[623.8846435546875,102.62339782714844],[623.3680419921875,102.38801574707031],[622.8501586914062,102.1556625366211],[622.3311157226562,101.92573547363281],[621.8111572265625,101.69805145263672],[621.2901611328125,101.47260284423828],[620.76806640625,101.24980163574219],[620.2447509765625,101.02980041503906],[619.7205200195312,100.81206512451172],[619.1953735351562,100.59661865234375],[618.6692504882812,100.38350677490234],[618.141845703125,100.17354583740234],[617.613525390625,99.96589660644531],[617.0842895507812,99.76054382324219],[616.55419921875,99.5575180053711],[616.0230102539062,99.357421875],[615.4907836914062,99.16001892089844],[614.9577026367188,98.9649429321289],[614.4237670898438,98.77222442626953],[613.888916015625,98.58206176757812],[613.3529052734375,98.39507293701172],[612.8161010742188,98.21047973632812],[612.2784423828125,98.02828979492188],[611.7400512695312,97.84854125976562],[611.2005615234375,97.67184448242188],[610.6602172851562,97.49795532226562],[610.1190185546875,97.3265609741211],[609.5770874023438,97.15766906738281],[609.0343627929688,96.99131774902344],[608.4906005859375,96.82843780517578],[607.946044921875,96.66812133789062],[607.4006958007812,96.5103988647461],[606.8546752929688,96.35528564453125],[606.3078002929688,96.20308685302734],[605.760009765625,96.05421447753906],[605.2114868164062,95.90803527832031],[604.6622924804688,95.76457977294922],[604.1123657226562,95.62384796142578],[603.5616455078125,95.48626708984375],[603.0100708007812,95.35204315185547],[602.4580688476562,95.21956634521484],[601.9058837890625,95.08782958984375],[601.353759765625,94.95608520507812],[600.8015747070312,94.82434844970703],[600.2494506835938,94.69261169433594],[599.697265625,94.56087493896484],[599.1451416015625,94.42913055419922],[598.5929565429688,94.29739379882812],[598.040771484375,94.16565704345703],[597.4886474609375,94.0339126586914],[596.9364624023438,93.90217590332031],[596.38427734375,93.77043151855469],[595.8321533203125,93.6386947631836],[595.2799682617188,93.50695037841797],[594.7278442382812,93.37521362304688],[594.1756591796875,93.24347686767578],[593.6234741210938,93.11174011230469],[593.0713500976562,92.97999572753906],[592.5191650390625,92.84825897216797],[591.967041015625,92.71652221679688],[591.4148559570312,92.58477783203125],[590.8626708984375,92.45304107666016],[590.310546875,92.32130432128906],[589.7583618164062,92.18956756591797],[589.2062377929688,92.05782318115234],[588.654052734375,91.92608642578125],[588.1019287109375,91.79434967041016],[587.5497436523438,91.66261291503906],[586.99755859375,91.53086853027344],[586.4454345703125,91.39913177490234],[585.8932495117188,91.26739501953125],[585.3411254882812,91.13565063476562],[584.7889404296875,91.00391387939453],[584.23681640625,90.87217712402344],[583.6846313476562,90.74044036865234],[583.1323852539062,90.60917663574219],[582.580078125,90.47795867919922],[582.02783203125,90.34673309326172],[581.4755249023438,90.21551513671875],[580.9232177734375,90.08428192138672],[580.3709106445312,89.95306396484375],[579.8186645507812,89.82183837890625],[579.266357421875,89.69062042236328],[578.714111328125,89.55939483642578],[578.1618041992188,89.42817687988281],[577.6094970703125,89.29695892333984],[577.0572509765625,89.16573333740234],[576.5049438476562,89.03451538085938],[575.9526977539062,88.90328979492188],[575.400390625,88.7720718383789],[574.8480834960938,88.6408462524414],[574.2958374023438,88.50962829589844],[573.7435302734375,88.37840270996094],[573.1912841796875,88.24718475341797],[572.6389770507812,88.11595916748047],[572.086669921875,87.9847412109375],[571.534423828125,87.853515625],[570.9821166992188,87.72229766845703],[570.4298706054688,87.59107971191406],[569.8775634765625,87.45985412597656],[569.3252563476562,87.3286361694336],[568.7730102539062,87.1974105834961],[568.220703125,87.06619262695312],[567.66845703125,86.93496704101562],[567.1161499023438,86.80374908447266],[566.5638427734375,86.67252349853516],[566.0115966796875,86.54130554199219],[565.4592895507812,86.41007995605469],[564.906982421875,86.27885437011719],[564.354736328125,86.14767456054688],[563.8023071289062,86.01708984375],[563.2498779296875,85.88650512695312],[562.6974487304688,85.75592803955078],[562.1449584960938,85.6253433227539],[561.592529296875,85.49475860595703],[561.0401611328125,85.36418914794922],[560.4876708984375,85.23359680175781],[559.935302734375,85.10301971435547],[559.3828125,84.9724349975586],[558.8303833007812,84.84185791015625],[558.2779541015625,84.71126556396484],[557.7255249023438,84.5806884765625],[557.173095703125,84.45010375976562],[556.62060546875,84.31951141357422],[556.0682373046875,84.1889419555664],[555.5157470703125,84.058349609375],[554.9633178710938,83.92777252197266],[554.410888671875,83.79718780517578],[553.8584594726562,83.66661071777344],[553.3060302734375,83.53601837158203],[552.7536010742188,83.40544891357422],[552.201171875,83.27485656738281],[551.6487426757812,83.14427947998047],[551.0962524414062,83.0136947631836],[550.5438842773438,82.88311767578125],[549.9913940429688,82.75252532958984],[549.4390258789062,82.62195587158203],[548.8865356445312,82.49136352539062],[548.3341674804688,82.36078643798828],[547.7816772460938,82.2302017211914],[547.229248046875,82.09962463378906],[546.6768188476562,81.96903228759766],[546.1243896484375,81.83846282958984],[545.5719604492188,81.70787048339844],[545.01953125,81.57734680175781],[544.4669189453125,81.44731140136719],[543.9143676757812,81.31729125976562],[543.36181640625,81.187255859375],[542.8092651367188,81.0572280883789],[542.2566528320312,80.92719268798828],[541.7040405273438,80.79716491699219],[541.1515502929688,80.6671371459961],[540.5989379882812,80.53710174560547],[540.04638671875,80.4070816040039],[539.4938354492188,80.27704620361328],[538.9412841796875,80.14702606201172],[538.388671875,80.0169906616211],[537.8361206054688,79.88697052001953],[537.2835693359375,79.7569351196289],[536.7310180664062,79.62691497802734],[536.1784057617188,79.49687957763672],[535.6259155273438,79.36685943603516],[535.0731811523438,79.23705291748047],[534.5205688476562,79.1074447631836],[533.9678955078125,78.97782135009766],[533.415283203125,78.84821319580078],[532.862548828125,78.71858978271484],[532.3099365234375,78.58897399902344],[531.7572631835938,78.4593505859375],[531.20458984375,78.32974243164062],[530.6519165039062,78.20011901855469],[530.0993041992188,78.07051086425781],[529.5465698242188,77.94088745117188],[528.9939575195312,77.811279296875],[528.4412841796875,77.68165588378906],[527.888671875,77.55204010009766],[527.3359375,77.42241668701172],[526.7833251953125,77.29280853271484],[526.2306518554688,77.1631851196289],[525.6779174804688,77.03357696533203],[525.1251831054688,76.90440368652344],[524.5723876953125,76.77522277832031],[524.0196533203125,76.64605712890625],[523.4668579101562,76.5168685913086],[522.9141235351562,76.38770294189453],[522.361328125,76.2585220336914],[521.80859375,76.12934875488281],[521.2557983398438,76.00016784667969],[520.7030639648438,75.87100219726562],[520.1502685546875,75.74181365966797],[519.5975341796875,75.6126480102539],[519.0447387695312,75.48346710205078],[518.4920043945312,75.35429382324219],[517.939208984375,75.22511291503906],[517.386474609375,75.09593963623047],[516.8336791992188,74.96675872802734],[516.2809448242188,74.83759307861328],[515.7281494140625,74.7086410522461],[515.17529296875,74.57994079589844],[514.6223754882812,74.45123291015625],[514.0695190429688,74.3225326538086],[513.5166015625,74.1938247680664],[512.9638061523438,74.06512451171875],[512.410888671875,73.93640899658203],[511.8580322265625,73.80770874023438],[511.3051452636719,73.67900085449219],[510.7522888183594,73.55030059814453],[510.1993713378906,73.42159271240234],[509.646484375,73.29287719726562],[509.0936279296875,73.16417694091797],[508.5407409667969,73.03546905517578],[507.9878845214844,72.90676879882812],[507.4349670410156,72.7780532836914],[506.88214111328125,72.64936065673828],[506.3292236328125,72.52064514160156],[505.77630615234375,72.39241790771484],[505.2232971191406,72.26420593261719],[504.6703186035156,72.1360092163086],[504.1173095703125,72.00779724121094],[503.5643310546875,71.87960815429688],[503.0113220214844,71.75139617919922],[502.4583740234375,71.62319946289062],[501.90533447265625,71.49498748779297],[501.3523864746094,71.36679077148438],[500.7993469238281,71.23858642578125],[500.24639892578125,71.11038970947266],[499.693359375,70.982177734375],[499.1404113769531,70.8539810180664],[498.58740234375,70.72577667236328],[498.034423828125,70.59757995605469],[497.4814147949219,70.46936798095703],[496.9284362792969,70.34117126464844],[496.3753662109375,70.213134765625],[495.8222961425781,70.0854721069336],[495.2691650390625,69.95780181884766],[494.71600341796875,69.83012390136719],[494.1629333496094,69.70246124267578],[493.6097717285156,69.57478332519531],[493.05670166015625,69.4471206665039],[492.5035400390625,69.31944274902344],[491.9504699707031,69.19178009033203],[491.3973083496094,69.06410217285156],[490.84423828125,68.93643951416016],[490.2911071777344,68.80876159667969],[489.7380065917969,68.68109893798828],[489.18487548828125,68.55342102050781],[488.63177490234375,68.4257583618164],[488.0786437988281,68.29808044433594],[487.5255432128906,68.17041778564453],[486.972412109375,68.04273986816406],[486.4192199707031,67.91548156738281],[485.8659362792969,67.78836822509766],[485.3127136230469,67.66127014160156],[484.75946044921875,67.5341567993164],[484.20623779296875,67.40705871582031],[483.6529541015625,67.27994537353516],[483.0997619628906,67.15283966064453],[482.5464782714844,67.02572631835938],[481.9932556152344,66.89862823486328],[481.4399719238281,66.77151489257812],[480.88677978515625,66.64441680908203],[480.33349609375,66.51729583740234],[479.7802734375,66.39019775390625],[479.2270202636719,66.2630844116211],[478.6737365722656,66.13597106933594],[478.1205139160156,66.00887298583984],[477.5672607421875,65.88175964355469],[477.0140075683594,65.75473022460938],[476.4606018066406,65.62821197509766],[475.9072570800781,65.50170135498047],[475.3538513183594,65.37518310546875],[474.8005065917969,65.2486801147461],[474.2470703125,65.12216186523438],[473.6937255859375,64.99565124511719],[473.14031982421875,64.86913299560547],[472.58697509765625,64.74263000488281],[472.0335693359375,64.6161117553711],[471.480224609375,64.4896011352539],[470.9267883300781,64.36308288574219],[470.3734436035156,64.23657989501953],[469.8200378417969,64.11005401611328],[469.2666931152344,63.983551025390625],[468.7132873535156,63.857032775878906],[468.1599426269531,63.730525970458984],[467.6065368652344,63.604007720947266],[467.0531311035156,63.47782516479492],[466.49957275390625,63.3519287109375],[465.9460754394531,63.226051330566406],[465.39251708984375,63.100154876708984],[464.83905029296875,62.974273681640625],[464.2854919433594,62.84838104248047],[463.73199462890625,62.72249984741211],[463.1784362792969,62.59660720825195],[462.6248779296875,62.47071075439453],[462.0713806152344,62.34483337402344],[461.5178527832031,62.218936920166016],[460.96435546875,62.093055725097656],[460.4107971191406,61.9671630859375],[459.8572998046875,61.84128189086914],[459.3037414550781,61.715389251708984],[458.750244140625,61.589508056640625],[458.19671630859375,61.4636116027832],[457.6432189941406,61.33773422241211],[457.0895080566406,61.21241760253906],[456.5358581542969,61.08719253540039],[455.982177734375,60.96195602416992],[455.42852783203125,60.836734771728516],[454.87481689453125,60.71149444580078],[454.3211975097656,60.586273193359375],[453.7674865722656,60.461036682128906],[453.2138366699219,60.335811614990234],[452.6601257324219,60.210575103759766],[452.10650634765625,60.085350036621094],[451.55279541015625,59.960113525390625],[450.9991455078125,59.83489227294922],[450.4454650878906,59.709651947021484],[449.8918151855469,59.58443069458008],[449.3381042480469,59.45919418334961],[448.7844543457031,59.33396911621094],[448.23077392578125,59.20873260498047],[447.67706298828125,59.08348846435547],[447.1234436035156,58.95823669433594],[446.5697326660156,58.832969665527344],[446.01611328125,58.70771789550781],[445.46240234375,58.58245086669922],[444.9087829589844,58.45719909667969],[444.3550720214844,58.33193588256836],[443.80157470703125,58.20613479614258],[443.248046875,58.08015060424805],[442.6945495605469,57.95418167114258],[442.1410217285156,57.82819366455078],[441.5875549316406,57.70222473144531],[441.0340270996094,57.57624053955078],[440.4805908203125,57.4500846862793],[439.9272155761719,57.32341003417969],[439.3739013671875,57.19675064086914],[438.8205261230469,57.07007598876953],[438.2672119140625,56.94341278076172],[437.7138366699219,56.81673812866211],[437.1605224609375,56.69007873535156],[436.6072998046875,56.562896728515625],[436.05413818359375,56.43557357788086],[435.50091552734375,56.30823516845703],[434.94775390625,56.180908203125],[434.39453125,56.05357360839844],[433.84136962890625,55.926246643066406],[433.2881774902344,55.79873275756836],[432.73516845703125,55.670772552490234],[432.1820983886719,55.54279708862305],[431.6290283203125,55.414825439453125],[431.07598876953125,55.286865234375],[430.5229187011719,55.15888977050781],[429.96990966796875,55.03093338012695],[429.41693115234375,54.90247344970703],[428.8640441894531,54.77390670776367],[428.3111267089844,54.645328521728516],[427.75823974609375,54.516761779785156],[427.205322265625,54.388179779052734],[426.6524353027344,54.259613037109375],[426.0995178222656,54.13085174560547],[425.5467834472656,54.001705169677734],[424.9939880371094,53.87254333496094],[424.4412536621094,53.7433967590332],[423.8884582519531,53.61423873901367],[423.335693359375,53.48509216308594],[422.78289794921875,53.35593032836914],[422.23028564453125,53.22633361816406],[421.6776123046875,53.096622467041016],[421.125,52.966922760009766],[420.57232666015625,52.83720779418945],[420.01971435546875,52.7075080871582],[419.467041015625,52.57779312133789],[418.91448974609375,52.44792556762695],[418.3619384765625,52.31768798828125],[417.8094482421875,52.187461853027344],[417.25689697265625,52.05722427368164],[416.70440673828125,51.927001953125],[416.15185546875,51.79676055908203],[415.5993347167969,51.66652297973633],[415.0469055175781,51.5358772277832],[414.4944763183594,51.4051399230957],[413.9421081542969,51.2744140625],[413.3896789550781,51.1436767578125],[412.8373107910156,51.0129508972168],[412.2848815917969,50.8822135925293],[411.7325744628906,50.75132369995117],[411.1802673339844,50.6201171875],[410.62799072265625,50.488922119140625],[410.07568359375,50.35771560668945],[409.5234375,50.22652053833008],[408.9710998535156,50.095314025878906],[408.4188537597656,49.96411895751953],[407.8666076660156,49.832523345947266],[407.314453125,49.700889587402344],[406.7622375488281,49.569236755371094],[406.2100830078125,49.437599182128906],[405.6578674316406,49.30595016479492],[405.105712890625,49.174312591552734],[404.5536193847656,49.042442321777344],[404.0015869140625,48.910194396972656],[403.44952392578125,48.77793502807617],[402.89752197265625,48.645687103271484],[402.345458984375,48.513427734375],[401.79345703125,48.38117980957031],[401.24139404296875,48.24892044067383],[400.68939208984375,48.11667251586914],[400.1373291015625,47.984413146972656],[399.5852355957031,47.852149963378906],[399.0332336425781,47.71990203857422],[398.4811706542969,47.587642669677734],[397.9291687011719,47.45539474487305],[397.37713623046875,47.32283401489258],[396.8253173828125,47.18986511230469],[396.2734069824219,47.056880950927734],[395.7215881347656,46.923912048339844],[395.1697082519531,46.79092788696289],[394.61785888671875,46.657958984375],[394.06597900390625,46.52497863769531],[393.5141296386719,46.39200973510742],[392.9622497558594,46.25902557373047],[392.410400390625,46.12605667114258],[391.8585205078125,45.993072509765625],[391.30670166015625,45.860103607177734],[390.7547912597656,45.72711944580078],[390.2030334472656,45.5938835144043],[389.65130615234375,45.460289001464844],[389.099609375,45.32670974731445],[388.5478820800781,45.193115234375],[387.9961853027344,45.05953598022461],[387.4444274902344,44.925941467285156],[386.89276123046875,44.792362213134766],[386.34100341796875,44.65877151489258],[385.789306640625,44.52518844604492],[385.2375793457031,44.391597747802734],[384.6858215332031,44.25800323486328],[384.1341552734375,44.12442398071289],[383.5823974609375,43.99082946777344],[383.03076171875,43.85700607299805],[382.4791564941406,43.72290802001953],[381.9275817871094,43.58882522583008],[381.3759460449219,43.45473098754883],[380.82440185546875,43.320648193359375],[380.27276611328125,43.18655014038086],[379.7212219238281,43.052467346191406],[379.1695861816406,42.91836929321289],[378.6180114746094,42.78428649902344],[378.06640625,42.65018844604492],[377.51483154296875,42.51610565185547],[376.9632263183594,42.38200759887695],[376.4116516113281,42.2479248046875],[375.860107421875,42.1136360168457],[375.30865478515625,41.97916030883789],[374.7571105957031,41.84467315673828],[374.2056579589844,41.71019744873047],[373.65411376953125,41.575706481933594],[373.1026611328125,41.44123077392578],[372.5511474609375,41.30674362182617],[371.9996643066406,41.17226791381836],[371.4481506347656,41.037776947021484],[370.89666748046875,40.90330123901367],[370.34515380859375,40.76881408691406],[369.7936706542969,40.63433837890625],[369.2421569824219,40.499847412109375],[368.690673828125,40.36520004272461],[368.1392517089844,40.230445861816406],[367.5877990722656,40.095672607421875],[367.0364074707031,39.960914611816406],[366.4849548339844,39.82614517211914],[365.93353271484375,39.69138717651367],[365.382080078125,39.55661392211914],[364.8306884765625,39.42185974121094],[364.27923583984375,39.287086486816406],[363.72784423828125,39.15232849121094],[363.1763610839844,39.01755905151367],[362.6249694824219,38.8828010559082],[362.0735168457031,38.74802780151367],[361.52215576171875,38.61315155029297],[360.9707336425781,38.478172302246094],[360.4194030761719,38.34321212768555],[359.86798095703125,38.20823669433594],[359.316650390625,38.073272705078125],[358.7652282714844,37.938297271728516],[358.2138671875,37.80333709716797],[357.6624755859375,37.668357849121094],[357.1111145019531,37.53339767456055],[356.5597229003906,37.39842224121094],[356.00836181640625,37.263458251953125],[355.45697021484375,37.128482818603516],[354.9056091308594,36.99352264404297],[354.35418701171875,36.858543395996094],[353.8028564453125,36.72358322143555],[353.2514343261719,36.58860778808594],[352.7000427246094,36.45362854003906],[352.148681640625,36.318668365478516],[351.5972900390625,36.183692932128906],[351.0459289550781,36.048728942871094],[350.4945068359375,35.913753509521484],[349.94317626953125,35.77879333496094],[349.3917541503906,35.64381408691406],[348.8404235839844,35.508853912353516],[348.28900146484375,35.373878479003906],[347.7376403808594,35.238914489746094],[347.18621826171875,35.104000091552734],[346.6348571777344,34.96913146972656],[346.0834045410156,34.834251403808594],[345.53204345703125,34.69938278198242],[344.9806213378906,34.56449890136719],[344.4292297363281,34.429630279541016],[343.8778076171875,34.29475021362305],[343.3264465332031,34.159881591796875],[342.7749938964844,34.02499771118164],[342.2236328125,33.89012908935547],[341.6722106933594,33.7552490234375],[341.1208190917969,33.62038040161133],[340.56939697265625,33.485496520996094],[340.0180358886719,33.35062789916992],[339.4665832519531,33.21574783325195],[338.91522216796875,33.08087921142578],[338.3638000488281,32.94599533081055],[337.8123474121094,32.81111145019531],[337.260986328125,32.676246643066406],[336.7095642089844,32.54136276245117],[336.1581726074219,32.406494140625],[335.60675048828125,32.27161407470703],[335.0553894042969,32.13674545288086],[334.5039367675781,32.001861572265625],[333.95257568359375,31.866992950439453],[333.4011535644531,31.73211097717285],[332.8496398925781,31.597654342651367],[332.298095703125,31.463306427001953],[331.74658203125,31.32897186279297],[331.1950378417969,31.194622039794922],[330.6435241699219,31.060287475585938],[330.0919494628906,30.92593765258789],[329.54046630859375,30.791603088378906],[328.9888916015625,30.65725326538086],[328.4374084472656,30.522918701171875],[327.8858337402344,30.388568878173828],[327.3343200683594,30.254234313964844],[326.78277587890625,30.11988639831543],[326.23126220703125,29.985551834106445],[325.6797180175781,29.8512020111084],[325.1282043457031,29.716867446899414],[324.57666015625,29.582517623901367],[324.025146484375,29.448183059692383],[323.47357177734375,29.313833236694336],[322.9220886230469,29.17949867248535],[322.3705139160156,29.045150756835938],[321.8189697265625,28.91080093383789],[321.2674560546875,28.776466369628906],[320.71588134765625,28.64211654663086],[320.1643981933594,28.507781982421875],[319.6128234863281,28.373432159423828],[319.06134033203125,28.239097595214844],[318.5096435546875,28.1053466796875],[317.9579772949219,27.97168731689453],[317.40625,27.8380126953125],[316.8545837402344,27.7043514251709],[316.3028564453125,27.570676803588867],[315.7511901855469,27.4370174407959],[315.199462890625,27.303342819213867],[314.6477966308594,27.169681549072266],[314.0960693359375,27.036006927490234],[313.5444030761719,26.902347564697266],[312.9927062988281,26.7686710357666],[312.4410400390625,26.635011672973633],[311.8893127441406,26.5013370513916],[311.3374938964844,26.36822509765625],[310.7856140136719,26.235149383544922],[310.2337951660156,26.10208511352539],[309.68194580078125,25.969009399414062],[309.130126953125,25.83594512939453],[308.5782470703125,25.702869415283203],[308.02642822265625,25.569807052612305],[307.4745788574219,25.436729431152344],[306.9227600097656,25.303667068481445],[306.3708801269531,25.170589447021484],[305.81903076171875,25.037511825561523],[305.2672119140625,24.904449462890625],[304.71533203125,24.771371841430664],[304.1633605957031,24.638999938964844],[303.611328125,24.506629943847656],[303.059326171875,24.37427520751953],[302.5072937011719,24.241905212402344],[301.955322265625,24.10955047607422],[301.4032897949219,23.97718048095703],[300.8512878417969,23.844825744628906],[300.29925537109375,23.71245574951172],[299.7472839355469,23.580101013183594],[299.1952209472656,23.447731018066406],[298.64324951171875,23.31537628173828],[298.0912170410156,23.183006286621094],[297.5392761230469,23.050687789916992],[296.9870300292969,22.91913414001465],[296.43487548828125,22.787593841552734],[295.88262939453125,22.65604019165039],[295.3304443359375,22.524499893188477],[294.7782287597656,22.392946243286133],[294.2260437011719,22.26140785217285],[293.6737976074219,22.129854202270508],[293.12164306640625,21.998313903808594],[292.56939697265625,21.86676025390625],[292.0172119140625,21.735219955444336],[291.4649963378906,21.603666305541992],[290.9128112792969,21.47212791442871],[290.36053466796875,21.34064292907715],[289.8080749511719,21.21001625061035],[289.25567626953125,21.079404830932617],[288.7032165527344,20.94877815246582],[288.15081787109375,20.818166732788086],[287.598388671875,20.687541961669922],[287.0459899902344,20.556928634643555],[286.4935302734375,20.42630386352539],[285.9411315917969,20.295692443847656],[285.388671875,20.16506576538086],[284.8362731933594,20.034454345703125],[284.2838134765625,19.903827667236328],[283.7314147949219,19.773216247558594],[283.178955078125,19.642698287963867],[282.62640380859375,19.512849807739258],[282.0737609863281,19.38298797607422],[281.52117919921875,19.253141403198242],[280.9685363769531,19.123279571533203],[280.4159851074219,18.993431091308594],[279.86334228515625,18.863571166992188],[279.3106384277344,18.73407554626465],[278.75787353515625,18.604761123657227],[278.2051696777344,18.475460052490234],[277.65240478515625,18.34614372253418],[277.0997009277344,18.21684455871582],[276.54693603515625,18.087528228759766],[275.9942321777344,17.958335876464844],[275.4413146972656,17.8295955657959],[274.888427734375,17.700855255126953],[274.3356018066406,17.57213020324707],[273.7826843261719,17.443389892578125],[273.2298583984375,17.314664840698242],[272.67694091796875,17.185924530029297],[272.1240539550781,17.05763053894043],[271.5710144042969,16.92949104309082],[271.0180358886719,16.801366806030273],[270.4649963378906,16.673227310180664],[269.9120178222656,16.545101165771484],[269.3589782714844,16.416961669921875],[268.805908203125,16.288976669311523],[268.25274658203125,16.161466598510742],[267.6996154785156,16.033973693847656],[267.14642333984375,15.906464576721191],[266.59332275390625,15.778969764709473],[266.0401306152344,15.651461601257324],[265.48699951171875,15.523966789245605],[264.9337158203125,15.39696216583252],[264.3804626464844,15.270124435424805],[263.8271179199219,15.14327335357666],[263.2738342285156,15.016435623168945],[262.72052001953125,14.8895845413208],[262.167236328125,14.762746810913086],[261.61383056640625,14.636089324951172],[261.0604248046875,14.509937286376953],[260.5069274902344,14.383771896362305],[259.9534912109375,14.257619857788086],[259.3999938964844,14.131454467773438],[258.84649658203125,14.005288124084473],[258.2930908203125,13.879136085510254],[257.7394714355469,13.75355339050293],[257.1858825683594,13.628113746643066],[256.6322326660156,13.502660751342773],[256.0786437988281,13.377220153808594],[255.52499389648438,13.2517671585083],[254.97140502929688,13.126327514648438],[254.41766357421875,13.001115798950195],[253.86390686035156,12.876416206359863],[253.31008911132812,12.751703262329102],[252.75633239746094,12.627004623413086],[252.2025146484375,12.502291679382324],[251.6487579345703,12.377592086791992],[251.0949249267578,12.25287914276123],[250.54104614257812,12.128843307495117],[249.98704528808594,12.004898071289062],[249.43312072753906,11.880966186523438],[248.87911987304688,11.757020950317383],[248.3251953125,11.633090019226074],[247.7711944580078,11.50914478302002],[247.2172088623047,11.385518074035645],[246.6630401611328,11.262367248535156],[246.1089324951172,11.139230728149414],[245.5547637939453,11.016080856323242],[245.00064086914062,10.8929443359375],[244.44647216796875,10.769794464111328],[243.89236450195312,10.646657943725586],[243.33802795410156,10.524251937866211],[242.78367614746094,10.401926040649414],[242.22938537597656,10.279613494873047],[241.67503356933594,10.15728759765625],[241.12074279785156,10.034975051879883],[240.56639099121094,9.912649154663086],[240.01205444335938,9.790708541870117],[239.45750427246094,9.669234275817871],[238.9030303955078,9.547772407531738],[238.34849548339844,9.426298141479492],[237.79400634765625,9.30483627319336],[237.23947143554688,9.183361053466797],[236.68499755859375,9.06190013885498],[236.13026428222656,8.941258430480957],[235.57559204101562,8.82067584991455],[235.02085876464844,8.700080871582031],[234.4661865234375,8.579498291015625],[233.9114532470703,8.458902359008789],[233.35678100585938,8.338319778442383],[232.802001953125,8.218159675598145],[232.24713134765625,8.09848403930664],[231.69219970703125,7.978795051574707],[231.1373291015625,7.859118938446045],[230.58241271972656,7.7394304275512695],[230.0275421142578,7.619754314422607],[229.4726104736328,7.500065326690674],[228.91749572753906,7.381308555603027],[228.36236572265625,7.262553691864014],[227.8072509765625,7.143798828125],[227.25218200683594,7.0250563621521],[226.69705200195312,6.906301498413086],[226.14198303222656,6.787559509277344],[225.58676147460938,6.669301509857178],[225.03147888183594,6.5515217781066895],[224.4761505126953,6.43372917175293],[223.92088317871094,6.315949440002441],[223.36553955078125,6.198156833648682],[222.81027221679688,6.080377101898193],[222.25497436523438,5.96262788772583],[221.69949340820312,5.845837593078613],[221.14395141601562,5.729034900665283],[220.58847045898438,5.612244606018066],[220.03292846679688,5.495441913604736],[219.47744750976562,5.378652095794678],[218.92190551757812,5.261849403381348],[218.3660888671875,5.1467366218566895],[217.80860900878906,5.039592266082764],[217.24960327148438,4.941009998321533],[216.6891326904297,4.850869655609131],[216.1273956298828,4.769094467163086],[215.56454467773438,4.6956048011779785],[215.00062561035156,4.630331993103027],[214.43585205078125,4.573237419128418],[213.87033081054688,4.524291515350342],[213.30410766601562,4.483470916748047],[212.7374725341797,4.450801849365234],[212.17027282714844,4.4262776374816895],[211.60287475585938,4.409914016723633],[211.0352783203125,4.401745319366455],[210.46759033203125,4.401819229125977],[209.9000244140625,4.410199165344238],[209.33262634277344,4.426962852478027],[208.7655487060547,4.452198028564453],[208.1988983154297,4.4860148429870605],[207.6328887939453,4.528525352478027],[207.06752014160156,4.5798749923706055],[206.50308227539062,4.640201091766357],[205.939697265625,4.709675312042236],[205.37757873535156,4.7884674072265625],[204.81680297851562,4.876801013946533],[204.25770568847656,4.974859237670898],[203.700439453125,5.082878589630127],[203.145263671875,5.201109886169434],[202.59237670898438,5.329833030700684],[202.04212951660156,5.469295501708984],[201.49481201171875,5.619884490966797],[200.95079040527344,5.781914710998535],[200.4110565185547,5.957685470581055],[199.87876892089844,6.154769420623779],[199.35401916503906,6.371119022369385],[198.8365020751953,6.604299545288086],[198.32603454589844,6.852692604064941],[197.82240295410156,7.11444091796875],[197.32528686523438,7.388601779937744],[196.8346710205078,7.673971652984619],[196.3501434326172,7.969810485839844],[195.87171936035156,8.27537727355957],[195.3993377685547,8.590084075927734],[194.93284606933594,8.913488388061523],[194.47219848632812,9.245224952697754],[194.01742553710938,9.58499813079834],[193.56858825683594,9.932464599609375],[193.12571716308594,10.287515640258789],[192.68885803222656,10.650025367736816],[192.25823974609375,11.019875526428223],[191.8340301513672,11.397004127502441],[191.4163818359375,11.781549453735352],[191.0057373046875,12.173378944396973],[190.6023406982422,12.572769165039062],[190.20675659179688,12.979816436767578],[189.8193817138672,13.394831657409668],[189.4409942626953,13.817916870117188],[189.0723419189453,14.249600410461426],[188.7145538330078,14.690275192260742],[188.36875915527344,15.140406608581543],[188.03660583496094,15.60067367553711],[187.7201690673828,16.071985244750977],[187.4187469482422,16.552997589111328],[187.1258087158203,17.039216995239258],[186.84091186523438,17.530153274536133],[186.5638427734375,18.025623321533203],[186.29452514648438,18.52528953552246],[186.03262329101562,19.028963088989258],[185.7779083251953,19.536293029785156],[185.53021240234375,20.047029495239258],[185.28929138183594,20.561019897460938],[185.05494689941406,21.078041076660156],[184.82696533203125,21.597946166992188],[184.60519409179688,22.120450973510742],[184.38938903808594,22.645496368408203],[184.1793975830078,23.172855377197266],[183.97499084472656,23.70246696472168],[183.77603149414062,24.234060287475586],[183.582275390625,24.767681121826172],[183.39361572265625,25.303009033203125],[183.2097930908203,25.840105056762695],[183.03070068359375,26.37872314453125],[182.85617065429688,26.918970108032227],[182.68621826171875,27.460542678833008],[182.52012634277344,28.003366470336914],[182.3584747314453,28.54747200012207],[182.20037841796875,29.092744827270508],[182.04644775390625,29.63908576965332],[181.89581298828125,30.186433792114258],[181.74900817871094,30.734750747680664],[181.60525512695312,31.283906936645508],[181.46505737304688,31.833959579467773],[181.32760620117188,32.38473129272461],[181.1934814453125,32.93627166748047],[181.06185913085938,33.48851013183594],[180.93325805664062,34.041385650634766],[180.80694580078125,34.5948486328125],[180.68338012695312,35.148887634277344],[180.56190490722656,35.703365325927734],[180.44285583496094,36.2584228515625],[180.32569885253906,36.81382369995117],[180.21066284179688,37.369754791259766],[180.0973663330078,37.92598342895508],[179.98585510253906,38.48258972167969],[179.87489318847656,39.03924560546875],[179.7633514404297,39.595890045166016],[179.65103149414062,40.15227508544922],[179.53765869140625,40.70852279663086],[179.42349243164062,41.26454162597656],[179.3086395263672,41.820518493652344],[179.19314575195312,42.376258850097656],[179.07675170898438,42.931888580322266],[178.9597930908203,43.4873161315918],[178.84228515625,44.04274368286133],[178.7242431640625,44.59796142578125],[178.60520935058594,45.153038024902344],[178.48614501953125,45.708038330078125],[178.36679077148438,46.26299285888672],[178.24659729003906,46.817745208740234],[178.1263885498047,47.372562408447266],[178.0057373046875,47.927268981933594],[177.8846893310547,48.481903076171875],[177.76365661621094,49.036476135253906],[177.64215087890625,49.590972900390625],[177.52056884765625,50.145423889160156],[177.39894104003906,50.6999397277832],[177.27708435058594,51.25439453125],[177.15524291992188,51.80879211425781],[177.03338623046875,52.36324691772461],[176.91152954101562,52.917640686035156],[176.7896728515625,53.47209548950195],[176.66802978515625,54.02655029296875],[176.54647827148438,54.58107376098633],[176.42494201660156,55.135536193847656],[176.30393981933594,55.69015884399414],[176.18299865722656,56.2447509765625],[176.06222534179688,56.799434661865234],[175.942138671875,57.35421371459961],[175.82203674316406,57.909053802490234],[175.70252990722656,58.46394729614258],[175.58358764648438,59.019039154052734],[175.4646759033203,59.574066162109375],[175.34652709960938,60.12936019897461],[175.22897338867188,60.684635162353516],[175.1118927001953,61.240116119384766],[174.9956512451172,61.79571533203125],[174.88003540039062,62.3515625],[174.76504516601562,62.90740966796875],[174.65074157714844,63.463470458984375],[174.5374755859375,64.01969146728516],[174.4249267578125,64.5760726928711],[174.31312561035156,65.13259887695312],[174.20230102539062,65.68936157226562],[174.0925750732422,66.24626159667969],[173.9837188720703,66.80339813232422],[173.87571716308594,67.36075592041016],[173.76898193359375,67.91825866699219],[173.66342163085938,68.47605895996094],[173.55886840820312,69.03394317626953],[173.455322265625,69.5921401977539],[173.35337829589844,70.15054321289062],[173.25262451171875,70.70919036865234],[173.1529998779297,71.26800537109375],[173.05459594726562,71.82710266113281],[172.95802307128906,72.38642120361328],[172.86270141601562,72.946044921875],[172.76866149902344,73.50582885742188],[172.6761474609375,74.06593322753906],[172.58551025390625,74.62626647949219],[172.49595642089844,75.18688201904297],[172.40835571289062,75.74771118164062],[172.32241821289062,76.30882263183594],[172.23818969726562,76.87016296386719],[172.15574645996094,77.4318618774414],[172.0750732421875,77.99369049072266],[171.99632263183594,78.555908203125],[171.91934204101562,79.11831665039062],[171.8444366455078,79.6810531616211],[171.7713623046875,80.24394989013672],[171.70046997070312,80.80718994140625],[171.6314697265625,81.37059020996094],[171.5647735595703,81.93433380126953],[171.5,82.49834442138672],[171.43768310546875,83.06253814697266],[171.37738037109375,83.62698364257812],[171.31954956054688,84.1916732788086],[171.26385498046875,84.75660705566406],[171.21070861816406,85.32173156738281],[171.15980529785156,85.88713836669922],[171.11151123046875,86.45270538330078],[171.06561279296875,87.0185317993164],[171.02444458007812,87.58467102050781],[170.99099731445312,88.15135955810547],[170.96507263183594,88.71836853027344],[170.94647216796875,89.28578186035156],[170.9349365234375,89.8532943725586],[170.9302520751953,90.42095947265625],[170.93226623535156,90.98857116699219],[170.940673828125,91.5561752319336],[170.95526123046875,92.12361145019531],[170.97581481933594,92.69091796875],[171.0021209716797,93.25792694091797],[171.03399658203125,93.82472229003906],[171.07130432128906,94.39112854003906],[171.11386108398438,94.95719909667969],[171.1614227294922,95.52281188964844],[171.2138214111328,96.08808898925781],[171.27085876464844,96.65282440185547],[171.33241271972656,97.21719360351562],[171.39845275878906,97.7809829711914],[171.4687042236328,98.34429931640625],[171.5428466796875,98.90708923339844],[171.6207733154297,99.46932983398438],[171.70274353027344,100.03108978271484],[171.78799438476562,100.59224700927734],[171.87693786621094,101.1529312133789],[171.9691162109375,101.71302795410156],[172.0643768310547,102.27265930175781],[172.1629180908203,102.8316879272461],[172.26416015625,103.39030456542969],[172.36837768554688,103.94825744628906],[172.4752197265625,104.50577545166016],[172.5845489501953,105.06280517578125],[172.69647216796875,105.61932373046875],[172.81048583984375,106.17537689208984],[172.9269256591797,106.73098754882812],[173.04530334472656,107.28614044189453],[173.1656951904297,107.84090423583984],[173.28790283203125,108.395263671875],[173.4117889404297,108.94922637939453],[173.5375518798828,109.50279235839844],[173.66427612304688,110.05609893798828],[173.7928466796875,110.60897827148438],[173.92250061035156,111.16171264648438],[174.05307006835938,111.71406555175781],[174.18466186523438,112.26629638671875],[174.3211212158203,112.81729125976562],[174.46739196777344,113.36578369140625],[174.62289428710938,113.91166687011719],[174.78736877441406,114.45500946044922],[174.96038818359375,114.99565887451172],[175.14178466796875,115.53355407714844],[175.3311309814453,116.06869506835938],[175.5279998779297,116.6010971069336],[175.73216247558594,117.13081359863281],[175.94322204589844,117.65773010253906],[176.16099548339844,118.1819839477539],[176.38510131835938,118.7034912109375],[176.61526489257812,119.222412109375],[176.8511199951172,119.73869323730469],[177.09251403808594,120.25252532958984],[177.33908081054688,120.76378631591797],[177.59063720703125,121.27266693115234],[177.8471221923828,121.77908325195312],[178.1077423095703,122.28340148925781],[178.37277221679688,122.78535461425781],[178.6417236328125,123.2852783203125],[178.91441345214844,123.78309631347656],[179.1907958984375,124.2789535522461],[179.4703369140625,124.77300262451172],[179.75326538085938,125.26513671875],[180.0388641357422,125.75566101074219],[180.3275146484375,126.24449920654297],[180.6185302734375,126.73188018798828],[180.91200256347656,127.21778106689453],[181.20762634277344,127.70235443115234],[181.5052947998047,128.18577575683594],[181.80494689941406,128.66793823242188],[182.10589599609375,129.1492156982422],[182.40867614746094,129.62936401367188],[182.71263122558594,130.10879516601562],[183.01760864257812,130.58758544921875],[183.32350158691406,131.0657501220703],[183.6302947998047,131.54339599609375],[183.93788146972656,132.02044677734375],[184.24563598632812,132.4974822998047],[184.5531005859375,132.97459411621094],[184.8601837158203,133.45205688476562],[185.16574096679688,133.930419921875],[185.47064208984375,134.40928649902344],[185.77474975585938,134.88858032226562],[186.0782012939453,135.3683319091797],[186.3814697265625,135.84817504882812],[186.68460083007812,136.3280792236328],[186.98779296875,136.80809020996094],[187.2912139892578,137.28782653808594],[187.5950469970703,137.7672882080078],[187.8998565673828,138.24610900878906],[188.20545959472656,138.724609375],[188.51190185546875,139.20240783691406],[188.8197784423828,139.6792755126953],[189.12924194335938,140.1551971435547],[189.44033813476562,140.6300811767578],[189.75331115722656,141.1036376953125],[190.0684356689453,141.5757293701172],[190.38568115234375,142.04640197753906],[190.7055206298828,142.51547241210938],[191.0281219482422,142.98260498046875],[191.3533477783203,143.4477996826172],[191.6817626953125,143.91091918945312],[192.01348876953125,144.37155151367188],[192.34832763671875,144.8299102783203],[192.68692016601562,145.2853546142578],[193.02951049804688,145.73822021484375],[193.3759765625,146.187744140625],[193.72662353515625,146.63414001464844],[194.08160400390625,147.0770263671875],[194.4413604736328,147.5162811279297],[194.8057098388672,147.95159912109375],[195.17483520507812,148.38272094726562],[195.54917907714844,148.8093719482422],[195.92884826660156,149.23153686523438],[196.31373596191406,149.64871215820312],[196.70423889160156,150.06069946289062],[197.10047912597656,150.46719360351562],[197.50253295898438,150.86807250976562],[197.9103546142578,151.26283264160156],[198.32440185546875,151.65109252929688],[198.7445526123047,152.03280639648438],[199.17091369628906,152.40769958496094],[199.603515625,152.77513122558594],[200.0425262451172,153.1349639892578],[200.48785400390625,153.4869384765625],[200.9395294189453,153.83084106445312],[201.396484375,154.16758728027344],[201.85394287109375,154.50364685058594],[202.31149291992188,154.83978271484375],[202.76925659179688,155.1753692626953],[203.22714233398438,155.51084899902344],[203.6850128173828,155.84632873535156],[204.14341735839844,156.18141174316406],[204.60169982910156,156.51634216308594],[205.05995178222656,156.85118103027344],[205.51864624023438,157.18553161621094],[205.97744750976562,157.51995849609375],[206.43634033203125,157.85421752929688],[206.89564514160156,158.18775939941406],[207.3549346923828,158.5212860107422],[207.8143310546875,158.85488891601562],[208.2736358642578,159.1884307861328],[208.73292541503906,159.52197265625],[209.1925506591797,159.85498046875],[209.65272521972656,160.18751525878906],[210.11279296875,160.5199737548828],[210.5728759765625,160.85244750976562],[211.03294372558594,161.18490600585938],[211.4931182861328,161.51744079589844],[211.95370483398438,161.84910583496094],[212.41452026367188,162.18052673339844],[212.87535095214844,162.51194763183594],[213.33627319335938,162.8434295654297],[213.79710388183594,163.1748504638672],[214.2579803466797,163.5063018798828],[214.71963500976562,163.83677673339844],[215.18118286132812,164.1671905517578],[215.64273071289062,164.4976043701172],[216.10427856445312,164.82801818847656],[216.56593322753906,165.1584930419922],[217.02769470214844,165.4886474609375],[217.4899444580078,165.8180694580078],[217.9521942138672,166.1475067138672],[218.41455078125,166.4770050048828],[218.87680053710938,166.80642700195312],[219.33905029296875,167.1358642578125],[219.80166625976562,167.4647674560547],[220.2646942138672,167.79331970214844],[220.7276153564453,168.12179565429688],[221.1905517578125,168.4502716064453],[221.65347290039062,168.77874755859375],[222.1165008544922,169.10728454589844],[222.5799102783203,169.43499755859375],[223.0435028076172,169.76254272460938],[223.507080078125,170.09010314941406],[223.9707489013672,170.41773986816406],[224.43434143066406,170.74530029296875],[224.89794921875,171.07278442382812],[225.36216735839844,171.3994598388672],[225.8264617919922,171.7261962890625],[226.29066467285156,172.05287170410156],[226.7548828125,172.37953186035156],[227.21908569335938,172.70620727539062],[227.68362426757812,173.03268432617188],[228.14842224121094,173.35850524902344],[228.6132354736328,173.68431091308594],[229.07814025878906,174.01019287109375],[229.54295349121094,174.3360137939453],[230.00775146484375,174.6618194580078],[230.47288513183594,174.98712158203125],[230.93838500976562,175.3121795654297],[231.4037628173828,175.63717651367188],[231.869140625,175.962158203125],[232.33453369140625,176.2871551513672],[232.80001831054688,176.61221313476562],[233.26585388183594,176.93649291992188],[233.73179626464844,177.26068115234375],[234.19773864746094,177.58486938476562],[234.66378784179688,177.90911865234375],[235.1297149658203,178.2333221435547],[235.59580993652344,178.55746459960938],[236.06227111816406,178.88088989257812],[236.52883911132812,179.2043914794922],[236.9953155517578,179.52783203125],[237.46177673339844,179.85125732421875],[237.92825317382812,180.1746826171875],[238.3949737548828,180.4978790283203],[238.86195373535156,180.82057189941406],[239.3289337158203,181.14328002929688],[239.7958984375,181.46597290039062],[240.2629852294922,181.78872680664062],[240.72996520996094,182.11143493652344],[241.19728088378906,182.43370056152344],[241.6648406982422,182.75575256347656],[242.13230895996094,183.07774353027344],[242.59976196289062,183.3997344970703],[243.06723022460938,183.72174072265625],[243.5347900390625,184.04379272460938],[244.00265502929688,184.36517333984375],[244.47056579589844,184.68649291992188],[244.93849182128906,185.00782775878906],[245.40652465820312,185.32920837402344],[245.87445068359375,185.65052795410156],[246.3424530029297,185.97177124023438],[246.81080627441406,186.29246520996094],[247.27926635742188,186.61322021484375],[247.74761962890625,186.93389892578125],[248.2159881591797,187.2545928955078],[248.68434143066406,187.57528686523438],[249.15289306640625,187.89573669433594],[249.62167358398438,188.2158203125],[250.09043884277344,188.53590393066406],[250.55921936035156,188.85598754882812],[251.02809143066406,189.17613220214844],[251.49685668945312,189.4962158203125],[251.96591186523438,189.81593322753906],[252.43507385253906,190.13543701171875],[252.9043426513672,190.45501708984375],[253.37350463867188,190.77452087402344],[253.84266662597656,191.09402465820312],[254.3119354248047,191.41360473632812],[254.78143310546875,191.73260498046875],[255.25096130371094,192.05157470703125],[255.72048950195312,192.3705291748047],[256.19012451171875,192.68955993652344],[256.65966796875,193.00852966308594],[257.1293029785156,193.3274383544922],[257.59918212890625,193.64588928222656],[258.0691833496094,193.96441650390625],[258.5390625,194.28286743164062],[259.0089416503906,194.60130310058594],[259.47882080078125,194.9197540283203],[259.94891357421875,195.2380828857422],[260.41912841796875,195.55604553222656],[260.88934326171875,195.8740234375],[261.35955810546875,196.19198608398438],[261.8298645019531,196.51002502441406],[262.3000793457031,196.82798767089844],[262.7704772949219,197.1456756591797],[263.2409973144531,197.46319580078125],[263.7115783691406,197.78079223632812],[264.1820983886719,198.0983123779297],[264.6526184082031,198.4158477783203],[265.12310791015625,198.73336791992188],[265.59405517578125,199.0503692626953],[266.0649719238281,199.36729431152344],[266.535888671875,199.6842041015625],[267.0068054199219,200.00111389160156],[267.4778137207031,200.31809997558594],[267.94873046875,200.63502502441406],[268.4196472167969,200.95193481445312],[268.89068603515625,201.2689208984375],[269.3616027832031,201.58583068847656],[269.83251953125,201.9027557373047],[270.3034362792969,202.21966552734375],[270.774658203125,202.536376953125],[271.2460632324219,202.85260009765625],[271.7174377441406,203.16880798339844],[272.1888427734375,203.48501586914062],[272.66033935546875,203.80130004882812],[273.1317138671875,204.1175079345703],[273.6031188964844,204.43373107910156],[274.07452392578125,204.74993896484375],[274.5459899902344,205.06622314453125],[275.01739501953125,205.38243103027344],[275.4888000488281,205.69863891601562],[275.9601745605469,206.01486206054688],[276.4320068359375,206.3306121826172],[276.9037780761719,206.646240234375],[277.37554931640625,206.96188354492188],[277.8473205566406,207.27752685546875],[278.3192138671875,207.59323120117188],[278.7909851074219,207.9088592529297],[279.26275634765625,208.22450256347656],[279.7345275878906,208.54013061523438],[280.2064208984375,208.8558349609375],[280.6781921386719,209.17147827148438],[281.14996337890625,209.4871063232422],[281.6220397949219,209.80270385742188],[282.0941162109375,210.11788940429688],[282.5661926269531,210.43309020996094],[283.03826904296875,210.74827575683594],[283.5104675292969,211.06353759765625],[283.9825439453125,211.37872314453125],[284.4546203613281,211.69390869140625],[284.92669677734375,212.0091094970703],[285.39886474609375,212.32435607910156],[285.8709411621094,212.63955688476562],[286.343017578125,212.95474243164062],[286.8150939941406,213.26992797851562],[287.2875061035156,213.58482360839844],[287.7598571777344,213.89959716796875],[288.2322082519531,214.21437072753906],[288.7045593261719,214.52914428710938],[289.177001953125,214.84397888183594],[289.6493835449219,215.15875244140625],[290.1217346191406,215.47352600097656],[290.5940856933594,215.78829956054688],[291.0665283203125,216.10313415527344],[291.53887939453125,216.41790771484375],[292.01123046875,216.73268127441406],[292.48358154296875,217.04745483398438],[292.9560546875,217.36228942871094],[293.42840576171875,217.67706298828125],[293.9007568359375,217.99183654785156],[294.37322998046875,218.3066864013672],[294.8455810546875,218.6214599609375],[295.31793212890625,218.93621826171875],[295.790283203125,219.25099182128906],[296.2627258300781,219.5658416748047],[296.7350769042969,219.880615234375],[297.20745849609375,220.1953887939453],[297.6798095703125,220.51016235351562],[298.1522521972656,220.82485961914062],[298.62469482421875,221.13949584960938],[299.0971374511719,221.4541473388672],[299.569580078125,221.768798828125],[300.0421142578125,222.08351135253906],[300.5145568847656,222.3981475830078],[300.98699951171875,222.71279907226562],[301.4594421386719,223.02745056152344],[301.9319763183594,223.3421630859375],[302.4044189453125,223.6568145751953],[302.8768615722656,223.97145080566406],[303.34930419921875,224.28610229492188],[303.82183837890625,224.60081481933594],[304.2942810058594,224.91546630859375],[304.7666931152344,225.23011779785156],[305.2391357421875,225.5447540283203],[305.711669921875,225.85946655273438],[306.1841125488281,226.1741180419922],[306.65655517578125,226.48876953125],[307.1289978027344,226.80340576171875],[307.6015319824219,227.11813354492188],[308.073974609375,227.43276977539062],[308.5464172363281,227.74742126464844],[309.01885986328125,228.06234741210938],[309.49114990234375,228.37721252441406],[309.96343994140625,228.6920928955078],[310.43572998046875,229.0069580078125],[310.9081115722656,229.3218994140625],[311.3804016113281,229.63677978515625],[311.8526916503906,229.95164489746094],[312.3249816894531,230.2665252685547],[312.79736328125,230.58145141601562],[313.2696533203125,230.89633178710938],[313.741943359375,231.21119689941406],[314.2141418457031,231.526123046875],[314.6863098144531,231.8413848876953],[315.15838623046875,232.15658569335938],[315.6304626464844,232.47177124023438],[316.1025390625,232.78697204589844],[316.57470703125,233.10223388671875],[317.0467834472656,233.41741943359375],[317.51885986328125,233.7326202392578],[317.9909362792969,234.0478057861328],[318.4631042480469,234.36306762695312],[318.9351806640625,234.67825317382812],[319.4072570800781,234.9934539794922],[319.8791198730469,235.3090057373047],[320.35101318359375,235.62472534179688],[320.8227844238281,235.94036865234375],[321.2945556640625,236.25601196289062],[321.76641845703125,236.57171630859375],[322.2381896972656,236.88735961914062],[322.7099914550781,237.2030029296875],[323.1817626953125,237.51864624023438],[323.65362548828125,237.8343505859375],[324.1253967285156,238.14999389648438],[324.59716796875,238.46563720703125],[325.06884765625,238.7814178466797],[325.54034423828125,239.0977020263672],[326.01171875,239.41392517089844],[326.48309326171875,239.7301483154297],[326.9544982910156,240.04637145996094],[327.42596435546875,240.36265563964844],[327.8973693847656,240.6788787841797],[328.3687438964844,240.99510192871094],[328.8401184082031,241.3113250732422],[329.3116149902344,241.6276092529297],[329.7829895019531,241.94383239746094],[330.25439453125,242.2600555419922],[330.72552490234375,242.57666015625],[331.1966857910156,242.89346313476562],[331.667724609375,243.21018981933594],[332.1387634277344,243.52691650390625],[332.60980224609375,243.84365844726562],[333.0809631347656,244.16046142578125],[333.5517578125,244.47756958007812],[334.02252197265625,244.79469299316406],[334.493408203125,245.11187744140625],[334.9642028808594,245.42898559570312],[335.43499755859375,245.74610900878906],[335.9056701660156,246.06329345703125],[336.37628173828125,246.38088989257812],[336.8467712402344,246.69842529296875],[337.3172607421875,247.01596069335938],[337.78778076171875,247.33349609375],[338.2583923339844,247.65110778808594],[338.7287292480469,247.9688262939453],[339.1989440917969,248.2868194580078],[339.66912841796875,248.60479736328125],[340.1394348144531,248.92283630371094],[340.609619140625,249.24082946777344],[341.079833984375,249.55880737304688],[341.5498046875,249.8771209716797],[342.019775390625,250.19564819335938],[342.4896545410156,250.5141143798828],[342.95953369140625,250.8325653076172],[343.4294128417969,251.15103149414062],[343.8993835449219,251.4695587158203],[344.3690185546875,251.78855895996094],[344.8385314941406,252.1075439453125],[345.3080749511719,252.426513671875],[345.7776794433594,252.74554443359375],[346.2472229003906,253.0645294189453],[346.7166442871094,253.3835906982422],[347.1858215332031,253.70310974121094],[347.65509033203125,254.02268981933594],[348.1242370605469,254.34219360351562],[348.5934143066406,254.66171264648438],[349.0626525878906,254.98129272460938],[349.5316162109375,255.30104064941406],[350.0003967285156,255.6211395263672],[350.4691467285156,255.9412384033203],[350.9380187988281,256.2613830566406],[351.40679931640625,256.58148193359375],[351.87554931640625,256.9015808105469],[352.34405517578125,257.22210693359375],[352.8125,257.5428771972656],[353.2808532714844,257.86358642578125],[353.74920654296875,258.18426513671875],[354.2175598144531,258.5049743652344],[354.6860046386719,258.82574462890625],[355.1539306640625,259.1470031738281],[355.621826171875,259.4683532714844],[356.0897521972656,259.7896728515625],[356.5577697753906,260.1110534667969],[357.02569580078125,260.4324035644531],[357.4935607910156,260.7538757324219],[357.9610290527344,261.0758972167969],[358.4285583496094,261.3979797363281],[358.8960266113281,261.719970703125],[359.36346435546875,262.0419921875],[359.8309326171875,262.3639831542969],[360.2981872558594,262.6863098144531],[360.7651672363281,263.009033203125],[361.2321472167969,263.33172607421875],[361.69921875,263.6545104980469],[362.16619873046875,263.9772033691406],[362.6331481933594,264.2999267578125],[363.0997619628906,264.62310791015625],[363.5663146972656,264.9466247558594],[364.03277587890625,265.2700500488281],[364.4992370605469,265.593505859375],[364.9656982421875,265.91693115234375],[365.4322509765625,266.2404479980469],[365.89825439453125,266.5646057128906],[366.36419677734375,266.8888244628906],[366.83013916015625,267.2130126953125],[367.2961730957031,267.53729248046875],[367.7620849609375,267.8614807128906],[368.2279052734375,268.1858215332031],[368.69329833984375,268.51080322265625],[369.1587829589844,268.83587646484375],[369.6241455078125,269.1608581542969],[370.08953857421875,269.48583984375],[370.5549011230469,269.81085205078125],[371.02020263671875,270.1363220214844],[371.4850158691406,270.462158203125],[371.9498291015625,270.7879638671875],[372.4146423339844,271.11376953125],[372.8795471191406,271.4396667480469],[373.3443298339844,271.7654724121094],[373.8093566894531,272.091064453125],[374.2745361328125,272.4165954589844],[374.7395935058594,272.7420349121094],[375.2049865722656,273.0669250488281],[375.6704406738281,273.39178466796875],[376.1360168457031,273.716796875],[376.6008605957031,274.0425720214844],[377.06573486328125,274.3683166503906],[377.5302734375,274.6943054199219],[377.9941101074219,275.021728515625],[378.45703125,275.3502502441406],[378.9192810058594,275.6797180175781],[379.3805847167969,276.0104675292969],[379.84051513671875,276.34326171875],[380.2996520996094,276.67718505859375],[380.7572021484375,277.0130920410156],[381.2129821777344,277.35125732421875],[381.6674499511719,277.6915588378906],[382.1200256347656,278.0343017578125],[382.5704345703125,278.37957763671875],[383.01904296875,278.72747802734375],[383.4651184082031,279.0785827636719],[383.9089050292969,279.43255615234375],[384.3500671386719,279.789794921875],[384.78826904296875,280.1505432128906],[385.2237854003906,280.5146789550781],[385.6557922363281,280.883056640625],[386.08453369140625,281.2549743652344],[386.5095520019531,281.63116455078125],[386.9307861328125,282.0118103027344],[387.34808349609375,282.3966369628906],[387.7608642578125,282.7862243652344],[388.1690368652344,283.18084716796875],[388.5721740722656,283.5804138183594],[388.9701843261719,283.98516845703125],[389.3626708984375,284.3952941894531],[389.7493896484375,284.8109130859375],[390.1298828125,285.2321472167969],[390.50384521484375,285.65911865234375],[390.87091064453125,286.092041015625],[391.2308044433594,286.53118896484375],[391.58294677734375,286.976318359375],[391.9270324707031,287.42779541015625],[392.2626037597656,287.8856201171875],[392.58929443359375,288.3499755859375],[392.9060974121094,288.8208923339844],[393.2110290527344,289.2996520996094],[393.5044250488281,289.78558349609375],[393.78619384765625,290.2784118652344],[394.0570068359375,290.77728271484375],[394.3170471191406,291.2818298339844],[394.56658935546875,291.791748046875],[394.8061218261719,292.306396484375],[395.0360107421875,292.82537841796875],[395.2564697265625,293.348388671875],[395.46807861328125,293.8751220703125],[395.6712341308594,294.4053039550781],[395.8658142089844,294.9385070800781],[396.0526123046875,295.47454833984375],[396.23193359375,296.01318359375],[396.4044494628906,296.55401611328125],[396.5694885253906,297.0970458984375],[396.7283935546875,297.6419677734375],[396.8810729980469,298.1888427734375],[397.02764892578125,298.7371520996094],[397.16900634765625,299.2869567871094],[397.3046569824219,299.8381042480469],[397.435546875,300.3905334472656],[397.5616760253906,300.9439697265625],[397.6832275390625,301.4984130859375],[397.8008728027344,302.0537109375],[397.91424560546875,302.6100158691406],[398.0241394042969,303.16693115234375],[398.1306457519531,303.7245178222656],[398.23370361328125,304.2826843261719],[398.3345031738281,304.8414001464844],[398.4319152832031,305.4005432128906],[398.5272216796875,305.960205078125],[398.6204833984375,306.52001953125],[398.7120056152344,307.0804138183594],[398.8018798828125,307.6408996582031],[398.8901062011719,308.2016296386719],[398.9769287109375,308.7626037597656],[399.06341552734375,309.32373046875],[399.1493835449219,309.884765625],[399.23455810546875,310.4459533691406],[399.31842041015625,311.0073547363281],[399.40130615234375,311.5690612792969],[399.4830627441406,312.1307067871094],[399.5633850097656,312.692626953125],[399.6417541503906,313.2550048828125],[399.7185974121094,313.8173828125],[399.7938537597656,314.3800048828125],[399.8665466308594,314.9429626464844],[399.9370422363281,315.50634765625],[400.00579833984375,316.0697326660156],[400.0716552734375,316.633544921875],[400.1346740722656,317.1976318359375],[400.1949157714844,317.76220703125],[400.2521667480469,318.326904296875],[400.3060302734375,318.8919372558594],[400.35687255859375,319.4573669433594],[400.40380859375,320.02313232421875],[400.4472961425781,320.589111328125],[400.4867248535156,321.1553039550781],[400.52215576171875,321.7218322753906],[400.5534973144531,322.288818359375],[400.5801086425781,322.85577392578125],[400.6025085449219,323.4228820800781],[400.61956787109375,323.990234375],[400.6320495605469,324.55792236328125],[400.63897705078125,325.12542724609375],[400.6406555175781,325.69305419921875],[400.63671875,326.26068115234375],[400.6267395019531,326.828369140625],[400.611083984375,327.3957214355469],[400.588623046875,327.962890625],[400.5602111816406,328.5299377441406],[400.5243835449219,329.0964660644531],[400.482177734375,329.6624450683594],[400.4322814941406,330.2279052734375],[400.3754577636719,330.7928466796875],[400.31060791015625,331.3567810058594],[400.2378234863281,331.9196472167969],[400.1568603515625,332.48150634765625],[400.0675354003906,333.0421447753906],[399.9695129394531,333.6012268066406],[399.86260986328125,334.1587219238281],[399.74658203125,334.7143859863281],[399.62420654296875,335.2687683105469],[399.497802734375,335.8220520019531],[399.3674011230469,336.37457275390625],[399.233154296875,336.9260559082031],[399.09503173828125,337.47674560546875],[398.9531555175781,338.0262756347656],[398.8075256347656,338.57501220703125],[398.6582336425781,339.1226501464844],[398.50537109375,339.66943359375],[398.3490295410156,340.215087890625],[398.1891174316406,340.7597351074219],[398.0256042480469,341.3031921386719],[397.8587341308594,341.84588623046875],[397.68853759765625,342.3874206542969],[397.5151062011719,342.9278869628906],[397.33843994140625,343.4674377441406],[397.1585998535156,344.00579833984375],[396.97564697265625,344.54315185546875],[396.7896423339844,345.07940673828125],[396.60052490234375,345.61474609375],[396.408447265625,346.1489562988281],[396.21343994140625,346.68206787109375],[396.01556396484375,347.21405029296875],[395.81475830078125,347.74505615234375],[395.61114501953125,348.2749328613281],[395.4047546386719,348.8036193847656],[395.195556640625,349.331298828125],[394.9835510253906,349.85797119140625],[394.768798828125,350.38348388671875],[394.5514221191406,350.9078369140625],[394.3314208984375,351.4310302734375],[394.10870361328125,351.953369140625],[393.8835144042969,352.4743957519531],[393.65582275390625,352.9942932128906],[393.42559814453125,353.51312255859375],[393.19281005859375,354.0309753417969],[392.95758056640625,354.547607421875],[392.7200012207031,355.06304931640625],[392.4799499511719,355.5774230957031],[392.2374572753906,356.09075927734375],[391.9926452636719,356.6028747558594],[391.7455139160156,357.1139221191406],[391.4960632324219,357.6237487792969],[391.2441711425781,358.13262939453125],[390.99005126953125,358.64019775390625],[390.7336120605469,359.14654541015625],[390.4748229980469,359.6518859863281],[390.21380615234375,360.156005859375],[389.95062255859375,360.65887451171875],[389.6851806640625,361.16070556640625],[389.4175720214844,361.6612854003906],[389.1477355957031,362.1607666015625],[388.87579345703125,362.658935546875],[388.6016540527344,363.1559753417969],[388.3253173828125,363.6519775390625],[388.0469055175781,364.14666748046875],[387.7663879394531,364.64013671875],[387.4837341308594,365.1323547363281],[387.19891357421875,365.6234130859375],[386.9117431640625,366.1130676269531],[386.6184387207031,366.5990905761719],[386.31646728515625,367.0796203613281],[386.005859375,367.55487060546875],[385.6871032714844,368.0245361328125],[385.3602600097656,368.48858642578125],[385.0255432128906,368.9470520019531],[384.6831359863281,369.39984130859375],[384.3331604003906,369.8468322753906],[383.975830078125,370.287841796875],[383.6112365722656,370.7227783203125],[383.2392578125,371.15179443359375],[382.8604431152344,371.5743408203125],[382.4744567871094,371.9905700683594],[382.0814514160156,372.4002990722656],[381.6816711425781,372.80316162109375],[381.2749938964844,373.19915771484375],[380.8614807128906,373.58807373046875],[380.4410705566406,373.9696960449219],[380.0140380859375,374.3436279296875],[379.580322265625,374.7096862792969],[379.13983154296875,375.0676574707031],[378.6924743652344,375.4172058105469],[378.2385559082031,375.758056640625],[377.7779846191406,376.0896911621094],[377.31060791015625,376.4118957519531],[376.83660888671875,376.7242736816406],[376.35601806640625,377.02630615234375],[375.8687744140625,377.3175048828125],[375.3751220703125,377.5975341796875],[374.8746337890625,377.8656921386719],[374.3678894042969,378.12139892578125],[373.8551330566406,378.36492919921875],[373.3404235839844,378.6042175292969],[372.8239440917969,378.8399658203125],[372.30596923828125,379.0721435546875],[371.7864685058594,379.3008728027344],[371.2654724121094,379.5262145996094],[370.742919921875,379.74835205078125],[370.21923828125,379.967041015625],[369.6941223144531,380.1825866699219],[369.1676025390625,380.3950500488281],[368.6399841308594,380.6043701171875],[368.1112060546875,380.8106689453125],[367.5811767578125,381.0140380859375],[367.04998779296875,381.21453857421875],[366.5179138183594,381.4121398925781],[365.9847412109375,381.6069641113281],[365.45068359375,381.799072265625],[364.9154968261719,381.98858642578125],[364.37945556640625,382.17547607421875],[363.84271240234375,382.3597717285156],[363.3049011230469,382.5416259765625],[362.7662353515625,382.72113037109375],[362.22698974609375,382.898193359375],[361.68695068359375,383.0729675292969],[361.1461486816406,383.2453918457031],[360.6044921875,383.4156494140625],[360.06243896484375,383.583740234375],[359.51959228515625,383.7497863769531],[358.97613525390625,383.913818359375],[358.4320373535156,384.0758972167969],[357.8874816894531,384.23602294921875],[357.3423767089844,384.3943176269531],[356.7967529296875,384.5508117675781],[356.25048828125,384.7055969238281],[355.7038269042969,384.8586730957031],[355.1568908691406,385.0100402832031],[354.6093444824219,385.15985107421875],[354.061279296875,385.3081970214844],[353.512939453125,385.45501708984375],[352.9643249511719,385.6003723144531],[352.4151306152344,385.7444152832031],[351.86566162109375,385.88690185546875],[351.31585693359375,386.0279846191406],[350.7658996582031,386.1685485839844],[350.21533203125,386.3072204589844],[349.66485595703125,386.4455871582031],[349.1138610839844,386.58197021484375],[348.5628356933594,386.7182922363281],[348.01123046875,386.8526611328125],[347.459716796875,386.98699951171875],[346.90777587890625,387.1196594238281],[346.3558349609375,387.2521667480469],[345.80352783203125,387.3833923339844],[345.251220703125,387.5143737792969],[344.6986389160156,387.6443176269531],[344.14599609375,387.7739562988281],[343.5930480957031,387.90283203125],[343.0401611328125,388.03131103515625],[342.4871520996094,388.1590270996094],[341.9339599609375,388.2862548828125],[341.38067626953125,388.4134826660156],[340.8274841308594,388.54071044921875],[340.27410888671875,388.66754150390625],[339.720703125,388.7938537597656],[339.1672058105469,388.9201965332031],[338.6138000488281,389.0465087890625],[338.0603942871094,389.17254638671875],[337.5067138671875,389.2980651855469],[336.953125,389.4235534667969],[336.3995361328125,389.5490417480469],[335.8459777832031,389.6745300292969],[335.2922668457031,389.800048828125],[334.73846435546875,389.92486572265625],[334.18463134765625,390.0492248535156],[333.63079833984375,390.1735534667969],[333.0767517089844,390.2972412109375],[332.522705078125,390.420654296875],[331.9686584472656,390.5440979003906],[331.41436767578125,390.6666564941406],[330.8599548339844,390.7890930175781],[330.3056945800781,390.9114990234375],[329.75115966796875,391.0328063964844],[329.1966552734375,391.154052734375],[328.64202880859375,391.27520751953125],[328.08721923828125,391.395263671875],[327.5324401855469,391.51531982421875],[326.9775085449219,391.6350402832031],[326.42230224609375,391.7537536621094],[325.8672180175781,391.8724365234375],[325.3120422363281,391.9906005859375],[324.75665283203125,392.10784912109375],[324.2011413574219,392.22509765625],[323.6455993652344,392.3415832519531],[323.0898742675781,392.4572448730469],[322.5340576171875,392.5729064941406],[321.97808837890625,392.6875915527344],[321.4220275878906,392.80157470703125],[320.865966796875,392.9155578613281],[320.30963134765625,393.02825927734375],[319.7532043457031,393.14044189453125],[319.19677734375,393.2525939941406],[318.63995361328125,393.36322021484375],[318.0830383300781,393.4735107421875],[317.5262145996094,393.58380126953125],[316.96905517578125,393.692138671875],[316.411865234375,393.8004150390625],[315.8544921875,393.9085693359375],[315.2968444824219,394.0146789550781],[314.7392272949219,394.12078857421875],[314.18157958984375,394.22650146484375],[313.6234130859375,394.3304138183594],[313.0653991699219,394.4342956542969],[312.5071716308594,394.53765869140625],[311.94879150390625,394.6397705078125],[311.3902282714844,394.7408447265625],[310.8314514160156,394.8412170410156],[310.2726135253906,394.9408874511719],[309.7135925292969,395.0392761230469],[309.15435791015625,395.1369934082031],[308.5950927734375,395.2339172363281],[308.03558349609375,395.32965087890625],[307.4759521484375,395.4244689941406],[306.91607666015625,395.5185546875],[306.3561096191406,395.611572265625],[305.7959899902344,395.7033996582031],[305.2355041503906,395.7944641113281],[304.6750793457031,395.8846130371094],[304.11444091796875,395.9733581542969],[303.5536804199219,396.0612487792969],[302.99267578125,396.1482849121094],[302.4315490722656,396.2338562011719],[301.8702697753906,396.3184509277344],[301.3087463378906,396.4021301269531],[300.74700927734375,396.48455810546875],[300.1852722167969,396.565673828125],[299.6233215332031,396.6458435058594],[299.06121826171875,396.72491455078125],[298.4988098144531,396.8024597167969],[297.93634033203125,396.8790283203125],[297.3738098144531,396.95458984375],[296.8110046386719,397.0284423828125],[296.24786376953125,397.1012268066406],[295.68487548828125,397.17291259765625],[295.1216125488281,397.24310302734375],[294.5581970214844,397.3118896484375],[293.9944763183594,397.379638671875],[293.4307556152344,397.4460754394531],[292.86676025390625,397.5107727050781],[292.3027038574219,397.5743103027344],[291.7384033203125,397.63671875],[291.17401123046875,397.6972961425781],[290.6094665527344,397.75653076171875],[290.0447082519531,397.8145751953125],[289.4798889160156,397.87103271484375],[288.9149169921875,397.9257507324219],[288.3498229980469,397.979248046875],[287.78448486328125,398.0314636230469],[287.2191162109375,398.08154296875],[286.653564453125,398.1303405761719],[286.0878601074219,398.1763916015625],[285.5216064453125,398.21875],[284.955322265625,398.2562561035156],[284.3885498046875,398.28875732421875],[283.8215026855469,398.3143005371094],[283.25408935546875,398.3318786621094],[282.68658447265625,398.3404846191406],[282.11895751953125,398.3385314941406],[281.551513671875,398.3247985839844],[280.9844055175781,398.29803466796875],[280.4182434082031,398.25701904296875],[279.8534851074219,398.2002868652344],[279.2906494140625,398.1268005371094],[278.7303161621094,398.0357971191406],[278.17333984375,397.92669677734375],[277.6202392578125,397.7991638183594],[277.0718078613281,397.652587890625],[276.5286865234375,397.4873352050781],[275.9915771484375,397.3038330078125],[275.46087646484375,397.1026306152344],[274.9368591308594,396.8843078613281],[274.419921875,396.64996337890625],[273.9101257324219,396.4004211425781],[273.4078369140625,396.135986328125],[272.9158020019531,395.8526306152344],[272.4349365234375,395.5512390136719],[271.9646911621094,395.2333068847656],[271.5049743652344,394.900390625],[271.0555725097656,394.553466796875],[270.616455078125,394.1937561035156],[270.1873779296875,393.82220458984375],[269.7681579589844,393.4395751953125],[269.35858154296875,393.04644775390625],[268.9587097167969,392.64361572265625],[268.5684509277344,392.2314758300781],[268.1877746582031,391.81036376953125],[267.8165588378906,391.3807373046875],[267.455078125,390.9431457519531],[267.1033630371094,390.4976806640625],[266.7615051269531,390.0445556640625],[266.429931640625,389.583740234375],[266.1087341308594,389.11566162109375],[265.79827880859375,388.6405029296875],[265.4989013671875,388.1582946777344],[265.21142578125,387.66876220703125],[264.93646240234375,387.172119140625],[264.6749572753906,386.6683349609375],[264.43701171875,386.15313720703125],[264.2320556640625,385.6237487792969],[264.0574951171875,385.08367919921875],[263.9112548828125,384.5353088378906],[263.79071044921875,383.9805603027344],[263.6946105957031,383.421142578125],[263.6210021972656,382.8583679199219],[263.5689697265625,382.2932434082031],[263.53741455078125,381.72637939453125],[263.5254211425781,381.158935546875],[263.5328674316406,380.5913391113281],[263.5588684082031,380.0242919921875],[263.6037902832031,379.4584045410156],[263.6675109863281,378.8944396972656],[263.7502746582031,378.3329162597656],[263.8529968261719,377.774658203125],[263.97650146484375,377.22052001953125],[264.12274169921875,376.67218017578125],[264.2941589355469,376.131103515625],[264.4886779785156,375.5979309082031],[264.70355224609375,375.0723571777344],[264.9364318847656,374.5547180175781],[265.1852722167969,374.0446472167969],[265.44818115234375,373.5415954589844],[265.7232666015625,373.0449523925781],[266.0086364746094,372.55426025390625],[266.302734375,372.0688171386719],[266.6044006347656,371.5880432128906],[266.91168212890625,371.1105041503906],[267.2236328125,370.6363830566406],[267.5389099121094,370.1643371582031],[267.8565979003906,369.69384765625],[268.1750183105469,369.22393798828125],[268.493408203125,368.7540283203125],[268.8106994628906,368.28326416015625],[269.1253662109375,367.8106994628906],[269.43621826171875,367.33587646484375],[269.7419738769531,366.8576354980469],[270.04559326171875,366.3780822753906],[270.3529357910156,365.90069580078125],[270.6636962890625,365.4257507324219],[270.9781494140625,364.9530944824219],[271.29583740234375,364.4827575683594],[271.6164245605469,364.0141296386719],[271.9397888183594,363.5475769042969],[272.26556396484375,363.08282470703125],[272.5934143066406,362.6194763183594],[272.92352294921875,362.157470703125],[273.2554931640625,361.69708251953125],[273.5884704589844,361.23736572265625],[273.9232177734375,360.77899169921875],[274.2588195800781,360.32098388671875],[274.5951232910156,359.86370849609375],[274.9324645996094,359.4072265625],[275.2698974609375,358.9507751464844],[275.6073913574219,358.49420166015625],[275.9447021484375,358.03765869140625],[276.281982421875,357.58111572265625],[276.6193542480469,357.1244812011719],[276.9553527832031,356.6670837402344],[277.2906494140625,356.20904541015625],[277.62506103515625,355.7503967285156],[277.95758056640625,355.2902526855469],[278.28912353515625,354.8294372558594],[278.61859130859375,354.3672790527344],[278.9458923339844,353.9034118652344],[279.27093505859375,353.43792724609375],[279.59356689453125,352.97100830078125],[279.9130554199219,352.50177001953125],[280.2296447753906,352.0306396484375],[280.5430908203125,351.5572204589844],[280.85247802734375,351.0813903808594],[281.15826416015625,350.60321044921875],[281.45989990234375,350.122314453125],[281.7568054199219,349.638427734375],[282.04925537109375,349.1519470214844],[282.3363342285156,348.6622009277344],[282.6182556152344,348.16949462890625],[282.8943176269531,347.6734619140625],[283.1640930175781,347.174072265625],[283.4275207519531,346.6712341308594],[283.6842041015625,346.1650085449219],[283.9338073730469,345.65509033203125],[284.1757507324219,345.14154052734375],[284.4098205566406,344.6244812011719],[284.63348388671875,344.10272216796875],[284.8323059082031,343.571044921875],[285.0057373046875,343.0306091308594],[285.1557312011719,342.4832763671875],[285.2844543457031,341.9302673339844],[285.39349365234375,341.3733215332031],[285.484375,340.8130187988281],[285.5587158203125,340.2502746582031],[285.6177978515625,339.6856384277344],[285.6626892089844,339.11981201171875],[285.6944885253906,338.5530700683594],[285.7140808105469,337.9858093261719],[285.72222900390625,337.4180908203125],[285.7198791503906,336.8504943847656],[285.70758056640625,336.2830505371094],[285.685791015625,335.7158203125],[285.6550598144531,335.14886474609375],[285.61602783203125,334.5826721191406],[285.5690612792969,334.01702880859375],[285.5144958496094,333.4519348144531],[285.45269775390625,332.88763427734375],[285.3840026855469,332.3241882324219],[285.30865478515625,331.7615966796875],[285.22686767578125,331.19989013671875],[285.1387939453125,330.63897705078125],[285.0447082519531,330.0792541503906],[284.9447021484375,329.52044677734375],[284.83892822265625,328.9627990722656],[284.7272644042969,328.4062194824219],[284.6098327636719,327.85076904296875],[284.4867858886719,327.2967224121094],[284.3566589355469,326.7440185546875],[284.2081604003906,326.1961975097656],[284.0404052734375,325.65399169921875],[283.85430908203125,325.1177062988281],[283.6515197753906,324.5875244140625],[283.43316650390625,324.0636291503906],[283.2004699707031,323.5459289550781],[282.9543151855469,323.0343933105469],[282.69586181640625,322.5289306640625],[282.4260559082031,322.0294494628906],[282.1456604003906,321.5360107421875],[281.8553771972656,321.04815673828125],[281.5561218261719,320.5657653808594],[281.24847412109375,320.0887756347656],[280.9330749511719,319.61688232421875],[280.6104736328125,319.1498718261719],[280.281005859375,318.6873779296875],[279.9454650878906,318.2296142578125],[279.60406494140625,317.7761535644531],[279.2572326660156,317.32672119140625],[278.9053039550781,316.8812561035156],[278.54888916015625,316.4395751953125],[278.18804931640625,316.00128173828125],[277.8233337402344,315.56634521484375],[277.45489501953125,315.1344299316406],[277.0829772949219,314.7056579589844],[276.70819091796875,314.2793884277344],[276.3305358886719,313.8555603027344],[275.9503173828125,313.43389892578125],[275.5679931640625,313.0143737792969],[275.18084716796875,312.5992126464844],[274.7798767089844,312.19744873046875],[274.3660888671875,311.8088684082031],[273.9406433105469,311.43316650390625],[273.5046691894531,311.069580078125],[273.05902099609375,310.71783447265625],[272.6050109863281,310.37738037109375],[272.1430358886719,310.0474853515625],[271.6737976074219,309.7280578613281],[271.19805908203125,309.41827392578125],[270.7164611816406,309.117919921875],[270.2293701171875,308.8265075683594],[269.7372131347656,308.5436096191406],[269.2403869628906,308.2689514160156],[268.7393798828125,308.0021667480469],[268.234375,307.7430114746094],[267.7255859375,307.4912414550781],[267.2132263183594,307.24658203125],[266.69781494140625,307.0088195800781],[266.1794738769531,306.77764892578125],[265.65826416015625,306.5528869628906],[265.1342468261719,306.3341979980469],[264.60797119140625,306.12164306640625],[264.0792541503906,305.9149475097656],[263.54840087890625,305.7143249511719],[263.0151672363281,305.5191650390625],[262.4801025390625,305.3296203613281],[261.9431457519531,305.1455383300781],[261.4041748046875,304.9670715332031],[260.8634338378906,304.7947998046875],[260.317626953125,304.6390075683594],[259.7666931152344,304.502197265625],[259.2116394042969,304.3833312988281],[258.6531982421875,304.2813415527344],[258.0921325683594,304.19561767578125],[257.5289001464844,304.12530517578125],[256.9638671875,304.0695495605469],[256.3978576660156,304.02783203125],[255.8308868408203,303.9996337890625],[255.2634735107422,303.9842529296875],[254.69573974609375,303.98162841796875],[254.1282196044922,303.9907531738281],[253.56103515625,304.01202392578125],[252.99436950683594,304.0445556640625],[252.42828369140625,304.0881652832031],[251.8633270263672,304.1427307128906],[251.29945373535156,304.2083740234375],[250.7370147705078,304.2845764160156],[250.17596435546875,304.37127685546875],[249.6167755126953,304.4685974121094],[249.0595703125,304.57672119140625],[248.50445556640625,304.6952819824219],[247.95155334472656,304.824462890625],[247.4016571044922,304.96484375],[246.85450744628906,305.1160888671875],[246.31057739257812,305.2785949707031],[245.77041625976562,305.4530334472656],[245.23471069335938,305.6407775878906],[244.70559692382812,305.8460693359375],[244.18357849121094,306.0693359375],[243.66986083984375,306.3106994628906],[243.1650390625,306.5699768066406],[242.6696014404297,306.8470458984375],[242.18423461914062,307.1414489746094],[241.70947265625,307.4524230957031],[241.24517822265625,307.779052734375],[240.7916717529297,308.120361328125],[240.34841918945312,308.47503662109375],[239.9151153564453,308.8418273925781],[239.49114990234375,309.2191467285156],[239.07571411132812,309.6058654785156],[238.66758728027344,310.0005187988281],[238.26602172851562,310.40167236328125],[237.86964416503906,310.80810546875],[237.47775268554688,311.2186279296875],[237.08847045898438,311.6318664550781],[236.70108032226562,312.0468444824219],[236.31439208984375,312.46240234375],[235.927734375,312.87799072265625],[235.53982543945312,313.29248046875],[235.14990234375,313.7049255371094],[234.75717163085938,314.1148376464844],[234.36082458496094,314.5211181640625],[233.9602508544922,314.9234313964844],[233.55502319335938,315.3209228515625],[233.1446990966797,315.713134765625],[232.72885131835938,316.0996398925781],[232.31004333496094,316.4827575683594],[231.89320373535156,316.86810302734375],[231.47894287109375,317.25604248046875],[231.06723022460938,317.6470031738281],[230.6577606201172,318.0401306152344],[230.25057983398438,318.4356994628906],[229.84571838378906,318.8335266113281],[229.4429931640625,319.2337341308594],[229.0425567626953,319.63592529296875],[228.6441192626953,320.040283203125],[228.24777221679688,320.4465637207031],[227.85325622558594,320.85491943359375],[227.46078491210938,321.2649841308594],[227.0701446533203,321.6768493652344],[226.68128967285156,322.09027099609375],[226.2940673828125,322.5054016113281],[225.90847778320312,322.9220886230469],[225.52450561523438,323.3401794433594],[225.14210510253906,323.7596435546875],[224.7611083984375,324.1805114746094],[224.38153076171875,324.6025085449219],[224.0032196044922,325.02569580078125],[223.62611389160156,325.4499816894531],[223.25013732910156,325.8753356933594],[222.875244140625,326.3016052246094],[222.50143432617188,326.72869873046875],[222.12838745117188,327.1567687988281],[221.756591796875,327.5856628417969],[221.38531494140625,328.0150146484375],[221.01470947265625,328.44500732421875],[220.64480590820312,328.8757019042969],[220.2754364013672,329.3066101074219],[219.90672302246094,329.7381896972656],[219.5382537841797,330.1700439453125],[219.17051696777344,330.60260009765625],[218.8028564453125,331.0350646972656],[218.43521118164062,331.467529296875],[218.06756591796875,331.9000244140625],[217.70016479492188,332.3328552246094],[217.3328399658203,332.765625],[216.96551513671875,333.1983642578125],[216.59817504882812,333.631103515625],[216.23033142089844,334.06353759765625],[215.86244201660156,334.4958190917969],[215.49398803710938,334.9275817871094],[215.1252899169922,335.3591613769531],[214.7557830810547,335.7903137207031],[214.385986328125,336.220947265625],[214.01548767089844,336.6509094238281],[213.6442413330078,337.0802917480469],[213.27224731445312,337.5091552734375],[212.8992462158203,337.93701171875],[212.5258026123047,338.364501953125],[212.15087890625,338.7909851074219],[211.77508544921875,339.21630859375],[211.39813232421875,339.6406555175781],[211.01991271972656,340.0639953613281],[210.64036560058594,340.4862365722656],[210.25953674316406,340.9071350097656],[209.87722778320312,341.3267517089844],[209.49346923828125,341.74493408203125],[209.10804748535156,342.16180419921875],[208.72108459472656,342.5771484375],[208.33248901367188,342.9908142089844],[207.94203186035156,343.4029235839844],[207.54974365234375,343.8133544921875],[207.1556854248047,344.2218322753906],[206.75967407226562,344.6285705566406],[206.36119079589844,345.0328369140625],[205.95993041992188,345.43438720703125],[205.5563507080078,345.8336181640625],[205.15052795410156,346.2304382324219],[204.74212646484375,346.62469482421875],[204.3312530517578,347.01654052734375],[203.91830444335938,347.40594482421875],[203.5031280517578,347.79302978515625],[203.08538818359375,348.17730712890625],[202.66546630859375,348.5593566894531],[202.2435302734375,348.9389953613281],[201.8192901611328,349.3161926269531],[201.39273071289062,349.6907653808594],[200.96412658691406,350.0630187988281],[200.5335693359375,350.432861328125],[200.10076904296875,350.8002014160156],[199.6656951904297,351.1650085449219],[199.2288360595703,351.5273132324219],[198.78993225097656,351.88726806640625],[198.3488006591797,352.2445983886719],[197.90560913085938,352.59942626953125],[197.46060180664062,352.9517517089844],[197.01364135742188,353.3016357421875],[196.5644989013672,353.6487731933594],[196.11334228515625,353.99346923828125],[195.66043090820312,354.3355712890625],[195.20562744140625,354.6751403808594],[194.74867248535156,355.0118408203125],[194.2897186279297,355.3460693359375],[193.82901000976562,355.677734375],[193.36639404296875,356.00665283203125],[192.90179443359375,356.3326110839844],[192.4351348876953,356.6561279296875],[191.96685791015625,356.9768981933594],[191.49655151367188,357.2947082519531],[191.02430725097656,357.6096496582031],[190.55015563964844,357.92193603515625],[190.07432556152344,358.2313537597656],[189.59637451171875,358.5375061035156],[189.11656188964844,358.84088134765625],[188.6348876953125,359.1414794921875],[188.15139770507812,359.43878173828125],[187.6659393310547,359.73291015625],[187.1785888671875,360.02410888671875],[186.68939208984375,360.3122253417969],[186.1982421875,360.5966796875],[185.70533752441406,360.8780517578125],[185.21044921875,361.1563415527344],[184.71356201171875,361.4308166503906],[184.21490478515625,361.7020568847656],[183.71389770507812,361.9688720703125],[183.2106170654297,362.2315368652344],[182.70518493652344,362.489990234375],[182.19775390625,362.744384765625],[181.68838500976562,362.9947204589844],[181.1768035888672,363.24102783203125],[180.6635284423828,363.4833679199219],[180.14849853515625,363.72198486328125],[179.6317596435547,363.95684814453125],[179.11328125,364.1880798339844],[178.5931854248047,364.41571044921875],[178.07174682617188,364.63970947265625],[177.5487060546875,364.8603515625],[177.02413940429688,365.07769775390625],[176.49842834472656,365.291748046875],[175.97145080566406,365.5025939941406],[175.44314575195312,365.7101745605469],[174.91354370117188,365.9148864746094],[174.38291931152344,366.1162414550781],[173.8511962890625,366.31500244140625],[173.318359375,366.5110168457031],[172.78466796875,366.70428466796875],[172.2500457763672,366.89495849609375],[171.71449279785156,367.08306884765625],[171.1779327392578,367.2687683105469],[170.64065551757812,367.4518737792969],[170.1025848388672,367.6324768066406],[169.5636749267578,367.8108825683594],[169.0239715576172,367.9871826171875],[168.48374938964844,368.1613464355469],[167.9428253173828,368.3335266113281],[167.4013214111328,368.50372314453125],[166.859130859375,368.6720886230469],[166.31654357910156,368.8386535644531],[165.77334594726562,369.0033874511719],[165.22952270507812,369.16632080078125],[164.68524169921875,369.3277282714844],[164.14065551757812,369.4875793457031],[163.59559631347656,369.6460266113281],[163.0501251220703,369.8031005859375],[162.5041046142578,369.9589538574219],[161.95802307128906,370.113525390625],[161.41146850585938,370.2669677734375],[160.86463928222656,370.4192199707031],[160.31729125976562,370.5699768066406],[159.76998901367188,370.72052001953125],[159.22230529785156,370.8698425292969],[158.6744842529297,371.0184326171875],[158.12646484375,371.16644287109375],[157.57821655273438,371.3135070800781],[157.0299072265625,371.46038818359375],[156.48123168945312,371.60626220703125],[155.93264770507812,371.7521057128906],[155.3837890625,371.8970031738281],[154.83493041992188,372.041748046875],[154.28594970703125,372.1865234375],[153.73707580566406,372.33123779296875],[153.18820190429688,372.47589111328125],[152.6392822265625,372.6203918457031],[152.09024047851562,372.7649230957031],[151.5413055419922,372.909423828125],[150.9923858642578,373.0539245605469],[150.4436492919922,373.1990051269531],[149.89479064941406,373.34423828125],[149.34619140625,373.49005126953125],[148.79771423339844,373.6362609863281],[148.2493133544922,373.782958984375],[147.70108032226562,373.9305419921875],[147.1529998779297,374.07830810546875],[146.6053466796875,374.2275695800781],[146.05770874023438,374.3768615722656],[145.51002502441406,374.52655029296875],[144.96249389648438,374.67626953125],[144.41497802734375,374.82598876953125],[143.86709594726562,374.9744567871094],[143.31898498535156,375.1221618652344],[142.7706756591797,375.26898193359375],[142.2218475341797,375.4139709472656],[141.67262268066406,375.5576477050781],[141.12307739257812,375.7000427246094],[140.57301330566406,375.8399963378906],[140.02243041992188,375.9779357910156],[139.4710235595703,376.1131896972656],[138.9190216064453,376.2458801269531],[138.366455078125,376.3754577636719],[137.8130340576172,376.5018310546875],[137.2587890625,376.6247863769531],[136.70372009277344,376.7437438964844],[136.1479034423828,376.8588562011719],[135.59121704101562,376.9692687988281],[135.0334930419922,377.0754699707031],[134.47483825683594,377.1761474609375],[133.91537475585938,377.2720947265625],[133.35484313964844,377.36181640625],[132.79344177246094,377.4463195800781],[132.23121643066406,377.5238952636719],[131.66815185546875,377.5956115722656],[131.1041259765625,377.66021728515625],[130.5393524169922,377.7176818847656],[129.97396850585938,377.7677307128906],[129.40789794921875,377.80999755859375],[128.8412322998047,377.84429931640625],[128.27410888671875,377.8703308105469],[127.7067642211914,377.8877868652344],[127.13925170898438,377.89654541015625],[126.57145690917969,377.8963317871094],[126.00394439697266,377.886962890625],[125.43659210205078,377.86822509765625],[124.86974334716797,377.8400573730469],[124.30323028564453,377.8022155761719],[123.73765563964844,377.754638671875],[123.17285919189453,377.6972351074219],[122.6092758178711,377.6300048828125],[122.04686737060547,377.5528564453125],[121.48607635498047,377.4655456542969],[120.93054962158203,377.3490905761719],[120.3839111328125,377.1968688964844],[119.84705352783203,377.01226806640625],[119.32095336914062,376.7992248535156],[118.80584716796875,376.5609130859375],[118.30191802978516,376.2998046875],[117.80879211425781,376.0185546875],[117.3265380859375,375.71929931640625],[116.85474395751953,375.4036865234375],[116.3932113647461,375.0733337402344],[115.94145202636719,374.72943115234375],[115.4994888305664,374.37335205078125],[115.06682586669922,374.0059509277344],[114.6432876586914,373.6280517578125],[114.22856903076172,373.2402648925781],[113.82279968261719,372.84344482421875],[113.42548370361328,372.43804931640625],[113.03666687011719,372.0245361328125],[112.65612030029297,371.60321044921875],[112.28402709960938,371.17462158203125],[111.92030334472656,370.7388000488281],[111.56498718261719,370.2960205078125],[111.21821594238281,369.8465576171875],[110.88021087646484,369.3905944824219],[110.55117797851562,368.9280700683594],[110.23136138916016,368.4588928222656],[109.9214096069336,367.9833984375],[109.62179565429688,367.5013732910156],[109.33334350585938,367.01251220703125],[109.05687713623047,366.5166320800781],[108.79380798339844,366.013671875],[108.56019592285156,365.4966735839844],[108.38085174560547,364.9584045410156],[108.25502014160156,364.4049377441406],[108.17986297607422,363.8424987792969],[108.15129089355469,363.2757263183594],[108.16468048095703,362.7084045410156],[108.21548461914062,362.1429748535156],[108.29934692382812,361.5816650390625],[108.41217803955078,361.0254821777344],[108.55081939697266,360.4750671386719],[108.71207427978516,359.93072509765625],[108.89349365234375,359.3929748535156],[109.09285736083984,358.86151123046875],[109.30818939208984,358.3363342285156],[109.53792572021484,357.81719970703125],[109.78062438964844,357.3040771484375],[110.03512573242188,356.79669189453125],[110.3004379272461,356.2948303222656],[110.57566833496094,355.79840087890625],[110.86066436767578,355.30743408203125],[111.15959930419922,354.824951171875],[111.47186279296875,354.3508605957031],[111.79608154296875,353.8848876953125],[112.13102722167969,353.4267578125],[112.47584533691406,352.9757385253906],[112.82946014404297,352.5315856933594],[113.1909408569336,352.0940856933594],[113.55960083007812,351.6624450683594],[113.93476104736328,351.2364501953125],[114.31591033935547,350.81573486328125],[114.70231628417969,350.39990234375],[115.09355926513672,349.9885559082031],[115.48899841308594,349.58135986328125],[115.88835906982422,349.1778564453125],[116.2911376953125,348.7778625488281],[116.69693756103516,348.3810729980469],[117.10559844970703,347.98712158203125],[117.51673889160156,347.5956115722656],[117.93004608154297,347.20648193359375],[118.34503936767578,346.81915283203125],[118.76142883300781,346.4334411621094],[119.17913055419922,346.0489501953125],[119.59782409667969,345.6656799316406],[120.01707458496094,345.2829895019531],[120.43655395507812,344.900390625],[120.856201171875,344.5181884765625],[121.27571105957031,344.1358337402344],[121.69468688964844,343.7528076171875],[122.11292266845703,343.3688049316406],[122.52980041503906,342.9836730957031],[122.9452133178711,342.5967712402344],[123.35865020751953,342.20782470703125],[123.76973724365234,341.81622314453125],[124.17996215820312,341.42388916015625],[124.59024047851562,341.0317687988281],[125.00155639648438,340.6405944824219],[125.4132080078125,340.2496032714844],[125.82556915283203,339.8595275878906],[126.23835754394531,339.4697570800781],[126.6517105102539,339.08074951171875],[127.06559753417969,338.692138671875],[127.4798812866211,338.3041076660156],[127.89470672607422,337.9166564941406],[128.30987548828125,337.5295715332031],[128.7257537841797,337.1430969238281],[129.14173889160156,336.75689697265625],[129.55848693847656,336.3714294433594],[129.97528076171875,335.98614501953125],[130.39283752441406,335.6014709472656],[130.81044006347656,335.217041015625],[131.2285614013672,334.8331298828125],[131.64706420898438,334.4495544433594],[132.06613159179688,334.0664978027344],[132.485107421875,333.6835632324219],[132.90408325195312,333.30059814453125],[133.32383728027344,332.9183654785156],[133.74374389648438,332.53643798828125],[134.16366577148438,332.1545104980469],[134.58363342285156,331.7727355957031],[135.0043487548828,331.3914794921875],[135.4249725341797,331.0103454589844],[135.84559631347656,330.6291809082031],[136.26654052734375,330.24835205078125],[136.6878204345703,329.86773681640625],[137.10902404785156,329.48724365234375],[137.53021240234375,329.1067199707031],[137.95140075683594,328.7261962890625],[138.37269592285156,328.3455810546875],[138.79388427734375,327.9650573730469],[139.21507263183594,327.5845031738281],[139.63619995117188,327.2038879394531],[140.05740356445312,326.8232116699219],[140.478515625,326.4425964355469],[140.89964294433594,326.06201171875],[141.3207550048828,325.681396484375],[141.74197387695312,325.30072021484375],[142.16293334960938,324.919921875],[142.58335876464844,324.5385437011719],[143.0037841796875,324.15716552734375],[143.42430114746094,323.7757263183594],[143.84413146972656,323.3937683105469],[144.26376342773438,323.0115051269531],[144.6834716796875,322.6291809082031],[145.10292053222656,322.2467346191406],[145.521484375,321.8633117675781],[145.94004821777344,321.47991943359375],[146.35870361328125,321.0964050292969],[146.7766571044922,320.7123107910156],[147.19424438476562,320.3278503417969],[147.61114501953125,319.9427185058594],[148.0280303955078,319.5572509765625],[148.44410705566406,319.1711120605469],[148.85984802246094,318.7846374511719],[149.27505493164062,318.3976135253906],[149.6898193359375,318.00982666015625],[150.10411071777344,317.6217956542969],[150.51747131347656,317.23284912109375],[150.93064880371094,316.84356689453125],[151.34295654296875,316.4532775878906],[151.75477600097656,316.0626220703125],[152.1658477783203,315.6711730957031],[152.5762176513672,315.2790222167969],[152.98617553710938,314.88623046875],[153.39491271972656,314.49249267578125],[153.80345153808594,314.0983581542969],[154.21070861816406,313.70294189453125],[154.61756896972656,313.30706787109375],[155.02342224121094,312.9102478027344],[155.4285430908203,312.5124816894531],[155.8329315185547,312.1141662597656],[156.2361297607422,311.71453857421875],[156.63893127441406,311.3145751953125],[157.0401611328125,310.9130554199219],[157.44102478027344,310.510986328125],[157.84060668945312,310.1078186035156],[158.23927307128906,309.70379638671875],[158.63710021972656,309.29888916015625],[159.03369140625,308.892578125],[159.42971801757812,308.4859313964844],[159.82427978515625,308.077880859375],[160.2177276611328,307.6687927246094],[160.61016845703125,307.258544921875],[161.00149536132812,306.8472900390625],[161.3916473388672,306.43499755859375],[161.7805938720703,306.0216979980469],[162.16856384277344,305.6070861816406],[162.5552520751953,305.1915283203125],[162.94064331054688,304.7747802734375],[163.32470703125,304.35693359375],[163.70773315429688,303.937744140625],[164.08935546875,303.5176086425781],[164.46971130371094,303.0962829589844],[164.8488006591797,302.67376708984375],[165.22666931152344,302.2499694824219],[165.60305786132812,301.82513427734375],[165.9781494140625,301.3991394042969],[166.3518524169922,300.9718322753906],[166.72415161132812,300.543212890625],[167.09500122070312,300.1134948730469],[167.46446228027344,299.68255615234375],[167.83253479003906,299.2503356933594],[168.19911193847656,298.8169250488281],[168.56423950195312,298.38232421875],[168.9279022216797,297.946533203125],[169.29017639160156,297.5093688964844],[169.65087890625,297.0710754394531],[170.0101318359375,296.6315002441406],[170.36761474609375,296.190673828125],[170.71920776367188,295.74493408203125],[171.0611572265625,295.2918395996094],[171.3937225341797,294.8319091796875],[171.71673583984375,294.36517333984375],[172.0306854248047,293.8920593261719],[172.33558654785156,293.4133605957031],[172.63136291503906,292.92889404296875],[172.91859436035156,292.4392395019531],[173.19740295410156,291.9446716308594],[173.46768188476562,291.4455871582031],[173.73004150390625,290.9422912597656],[173.9844512939453,290.434814453125],[174.2313232421875,289.92352294921875],[174.47084045410156,289.40887451171875],[174.70298767089844,288.8909606933594],[174.9283905029297,288.3699645996094],[175.14695739746094,287.8459777832031],[175.3590545654297,287.319580078125],[175.56495666503906,286.79058837890625],[175.76483154296875,286.2591857910156],[175.95896911621094,285.7257995605469],[176.1473846435547,285.1903991699219],[176.33067321777344,284.653076171875],[176.50865173339844,284.11395263671875],[176.68182373046875,283.5733947753906],[176.84999084472656,283.0312805175781],[177.0141143798828,282.48785400390625],[177.17352294921875,281.9430236816406],[177.32904052734375,281.3970642089844],[177.48080444335938,280.8501892089844],[177.62887573242188,280.3021545410156],[177.77322387695312,279.7530517578125],[177.91436767578125,279.2033386230469],[178.05258178710938,278.6527099609375],[178.187744140625,278.1014404296875],[178.3201141357422,277.5492858886719],[178.45001220703125,276.99676513671875],[178.57766723632812,276.44366455078125],[178.70297241210938,275.8900451660156],[178.8263397216797,275.3358459472656],[178.94761657714844,274.7814025878906],[179.0680389404297,274.2266540527344],[179.18626403808594,273.6714782714844],[179.3037567138672,273.1159973144531],[179.42025756835938,272.5604553222656],[179.53562927246094,272.0047302246094],[179.6505584716797,271.44879150390625],[179.76492309570312,270.8927001953125],[179.87925720214844,270.3367004394531],[179.9930419921875,269.78057861328125],[180.1020965576172,269.2234802246094],[180.2046356201172,268.6651916503906],[180.30050659179688,268.1056823730469],[180.3898162841797,267.545166015625],[180.4728546142578,266.9835510253906],[180.54966735839844,266.4211120605469],[180.6202392578125,265.8578186035156],[180.6842498779297,265.2939147949219],[180.74220275878906,264.7291259765625],[180.79408264160156,264.1639099121094],[180.8399200439453,263.5980529785156],[180.8793182373047,263.0318603515625],[180.9127197265625,262.46502685546875],[180.940185546875,261.89813232421875],[180.96160888671875,261.3309326171875],[180.97665405273438,260.7635192871094],[180.98577880859375,260.19586181640625],[180.98895263671875,259.62823486328125],[180.98602294921875,259.060546875],[180.97674560546875,258.4930114746094],[180.96148681640625,257.9255065917969],[180.94020080566406,257.3582458496094],[180.91265869140625,256.7912902832031],[180.87875366210938,256.2247314453125],[180.83871459960938,255.6584014892578],[180.79251098632812,255.09263610839844],[180.73985290527344,254.5274200439453],[180.6806182861328,253.96286010742188],[180.6150665283203,253.39898681640625],[180.5431365966797,252.83595275878906],[180.46458435058594,252.27377319335938],[180.37911987304688,251.7125244140625],[180.2870330810547,251.1523895263672],[180.1881866455078,250.5934600830078],[180.08255004882812,250.03582763671875],[179.9696044921875,249.47930908203125],[179.85037231445312,248.92437744140625],[179.7255096435547,248.37063598632812],[179.59521484375,247.8181610107422],[179.45938110351562,247.26690673828125],[179.3184356689453,246.717041015625],[179.1720733642578,246.16864013671875],[179.02072143554688,245.62156677246094],[178.8640899658203,245.07589721679688],[178.70252990722656,244.53170776367188],[178.53599548339844,243.98904418945312],[178.3645477294922,243.4479522705078],[178.18833923339844,242.9082794189453],[178.00721740722656,242.37030029296875],[177.82151794433594,241.83383178710938],[177.631103515625,241.2991943359375],[177.43605041503906,240.76597595214844],[177.236572265625,240.23460388183594],[177.03245544433594,239.7049102783203],[176.82398986816406,239.17686462402344],[176.6110076904297,238.65061950683594],[176.39378356933594,238.12620544433594],[176.17222595214844,237.60360717773438],[175.94630432128906,237.08274841308594],[175.71632385253906,236.56381225585938],[175.48196411132812,236.04685974121094],[175.24362182617188,235.53173828125],[175.00100708007812,235.0184326171875],[174.7543487548828,234.50717163085938],[174.50372314453125,233.9978790283203],[174.2489776611328,233.49066162109375],[173.99026489257812,232.9853057861328],[173.7274932861328,232.4820556640625],[173.46090698242188,231.98101806640625],[173.1903839111328,231.4819793701172],[172.91580200195312,230.9849853515625],[172.6375274658203,230.49026489257812],[172.35525512695312,229.997802734375],[172.0692596435547,229.50755310058594],[171.77926635742188,229.01942443847656],[171.48558044433594,228.5337371826172],[171.18809509277344,228.05026245117188],[170.88673400878906,227.56922912597656],[170.5816650390625,227.0904541015625],[170.27273559570312,226.61428833007812],[169.9601593017578,226.1404266357422],[169.64369201660156,225.669189453125],[169.3235321044922,225.20034790039062],[168.9995574951172,224.7341766357422],[168.67193603515625,224.2707061767578],[168.3404541015625,223.80984497070312],[168.00523376464844,223.3516845703125],[167.66627502441406,222.89639282226562],[167.32337951660156,222.44412231445312],[166.97494506835938,221.99578857421875],[166.620849609375,221.5521697998047],[166.2611541748047,221.11302185058594],[165.8960723876953,220.67852783203125],[165.52552795410156,220.2482147216797],[165.15017700195312,219.822509765625],[164.76991271972656,219.4010467529297],[164.38504028320312,218.98390197753906],[163.99549865722656,218.57080078125],[163.60177612304688,218.1619873046875],[163.203857421875,217.7572021484375],[162.8018798828125,217.3563690185547],[162.39598083496094,216.95941162109375],[161.98641967773438,216.5663604736328],[161.57334899902344,216.1771240234375],[161.15679931640625,215.7915496826172],[160.73684692382812,215.40948486328125],[160.31378173828125,215.03102111816406],[159.88768005371094,214.65602111816406],[159.45867919921875,214.28440856933594],[159.02670288085938,213.91592407226562],[158.59210205078125,213.55068969726562],[158.15496826171875,213.18865966796875],[157.71527099609375,212.82957458496094],[157.2732391357422,212.47348022460938],[156.8289031982422,212.12022399902344],[156.3823699951172,211.76976013183594],[155.93368530273438,211.42193603515625],[155.48304748535156,211.07676696777344],[155.030517578125,210.73414611816406],[154.5760955810547,210.39393615722656],[154.11973571777344,210.0561065673828],[153.66200256347656,209.72059631347656],[153.20254516601562,209.38722229003906],[152.7415771484375,209.05596923828125],[152.27911376953125,208.72669982910156],[151.81529235839844,208.3994140625],[151.35018920898438,208.07403564453125],[150.88385009765625,207.7504425048828],[150.4161834716797,207.428466796875],[149.947509765625,207.1082000732422],[149.47784423828125,206.78953552246094],[149.00717163085938,206.47230529785156],[148.5354461669922,206.15640258789062],[148.06283569335938,205.84181213378906],[147.58956909179688,205.528564453125],[147.11538696289062,205.2163848876953],[146.64056396484375,204.9053192138672],[146.16502380371094,204.59519958496094],[145.68881225585938,204.28628540039062],[145.212158203125,203.97784423828125],[144.73509216308594,203.67030334472656],[144.25758361816406,203.36338806152344],[143.77972412109375,203.05711364746094],[143.3013916015625,202.7512664794922],[142.82286071777344,202.44602966308594],[142.343994140625,202.14125061035156],[141.8651123046875,201.83648681640625],[141.38613891601562,201.5316619873047],[140.90719604492188,201.22698974609375],[140.42819213867188,200.92242431640625],[139.94918823242188,200.6178741455078],[139.47007751464844,200.31324768066406],[138.9911346435547,200.00868225097656],[138.51205444335938,199.70413208007812],[138.03269958496094,199.40013122558594],[137.55276489257812,199.0967559814453],[137.07284545898438,198.7936553955078],[136.59291076660156,198.4906005859375],[136.1122283935547,198.18870544433594],[135.63143920898438,197.88673400878906],[135.15060424804688,197.58518981933594],[134.669189453125,197.28445434570312],[134.18777465820312,196.9837188720703],[133.70584106445312,196.68353271484375],[133.2237091064453,196.3839569091797],[132.74156188964844,196.08438110351562],[132.2588348388672,195.78567504882812],[131.77589416503906,195.4871826171875],[131.29307556152344,195.18882751464844],[130.80953979492188,194.8915252685547],[130.32589721679688,194.5941619873047],[129.84217834472656,194.29718017578125],[129.35797119140625,194.0009765625],[128.87374877929688,193.7047882080078],[128.38902282714844,193.40908813476562],[127.90413665771484,193.11398315429688],[127.41925811767578,192.81887817382812],[126.9338607788086,192.5246124267578],[126.44822692871094,192.2305145263672],[125.96268463134766,191.93653869628906],[125.47651672363281,191.6435546875],[124.99034881591797,191.35057067871094],[124.50390625,191.05784606933594],[124.0171127319336,190.76589965820312],[123.53032684326172,190.4739532470703],[123.04309844970703,190.18251037597656],[122.55559539794922,189.89151000976562],[122.06819152832031,189.60057067871094],[121.58039093017578,189.3105010986328],[121.09239959716797,189.02056884765625],[120.60419464111328,188.73060607910156],[120.11561584472656,188.441650390625],[119.62704467773438,188.15269470214844],[119.13827514648438,187.86404418945312],[118.6490249633789,187.57598876953125],[118.15988159179688,187.28799438476562],[117.67041778564453,187.0005645751953],[117.18061828613281,186.7134552001953],[116.69091796875,186.42640686035156],[116.2008056640625,186.14015197753906],[115.71056365966797,185.85403442382812],[115.22021484375,185.56796264648438],[114.72945404052734,185.28274536132812],[114.23868560791016,184.99752807617188],[113.74765014648438,184.7126007080078],[113.25627136230469,184.42820739746094],[112.7649917602539,184.1438751220703],[112.27340698242188,183.86009216308594],[111.78162384033203,183.57662963867188],[111.28973388671875,183.29310607910156],[110.79749298095703,183.0103759765625],[110.30522918701172,182.72775268554688],[109.81292724609375,182.44528198242188],[109.32008361816406,182.16343688964844],[108.82733917236328,181.8816375732422],[108.33438110351562,181.6001739501953],[107.84117889404297,181.31919860839844],[107.34786987304688,181.0381622314453],[106.8543701171875,180.75772094726562],[106.36071014404297,180.4775390625],[105.86705780029297,180.19735717773438],[105.37291717529297,179.91783142089844],[104.87882995605469,179.63841247558594],[104.38460540771484,179.35911560058594],[103.88997650146484,179.0803985595703],[103.39546203613281,178.80172729492188],[102.90079498291016,178.52342224121094],[102.40586853027344,178.2454833984375],[101.91083526611328,177.9674835205078],[101.41565704345703,177.69007873535156],[100.92032623291016,177.41287231445312],[100.42500305175781,177.13565063476562],[99.92919158935547,176.85903930664062],[99.43347930908203,176.58250427246094],[98.9376449584961,176.30612182617188],[98.4415512084961,176.03025817871094],[97.94535827636719,175.7543487548828],[97.4491195678711,175.4788360595703],[96.95267486572266,175.20362854003906],[96.45623016357422,174.92840576171875],[95.95938110351562,174.6536102294922],[95.46258544921875,174.37904357910156],[94.9657974243164,174.1044921875],[94.46866607666016,173.83053588867188],[93.97142028808594,173.5565185546875],[93.47412872314453,173.28269958496094],[92.97666931152344,173.0093231201172],[92.47920989990234,172.73594665527344],[91.98153686523438,172.46287536621094],[91.4837646484375,172.19007873535156],[90.9859848022461,171.9172821044922],[90.48795318603516,171.64492797851562],[89.9897689819336,171.3726043701172],[89.49154663085938,171.100341796875],[88.99317932128906,170.82862854003906],[88.49481201171875,170.55690002441406],[87.99646759033203,170.28555297851562],[87.49747467041016,170.01446533203125],[86.99869537353516,169.74349975585938],[86.49991607666016,169.47254943847656],[86.00114440917969,169.2015838623047],[85.50236511230469,168.9306182861328],[85.00299835205078,168.660400390625],[84.50370788574219,168.390380859375],[84.0044174194336,168.120361328125],[83.50492095947266,167.8502197265625],[83.00563049316406,167.5802001953125],[82.50626373291016,167.3105926513672],[82.00651550292969,167.0414276123047],[81.50676727294922,166.77224731445312],[81.00701904296875,166.50308227539062],[80.50727081298828,166.23391723632812],[80.00752258300781,165.96475219726562],[79.50707244873047,165.69613647460938],[79.00690460205078,165.42774963378906],[78.5067367553711,165.15936279296875],[78.0065689086914,164.89097595214844],[77.50640106201172,164.62258911132812],[77.00611114501953,164.3545379638672],[76.50556945800781,164.0868377685547],[76.0050277709961,163.8191375732422],[75.50428009033203,163.55133056640625],[75.00373840332031,163.28363037109375],[74.5031967163086,163.01593017578125],[74.00225067138672,162.74879455566406],[73.50138854980469,162.48170471191406],[73.00051879882812,162.21463012695312],[72.4996566772461,161.94754028320312],[71.99857330322266,161.6803436279297],[71.4977035522461,161.41360473632812],[70.9965591430664,161.1470489501953],[70.49541473388672,160.88047790527344],[69.99427032470703,160.61392211914062],[69.49312591552734,160.3473663330078],[68.9918441772461,160.08074951171875],[68.49046325683594,159.81463623046875],[67.98886108398438,159.5484161376953],[67.48748016357422,159.28228759765625],[66.98609924316406,159.01617431640625],[66.4847183227539,158.75006103515625],[65.98322296142578,158.48414611816406],[65.48165130615234,158.21839904785156],[64.9800796508789,157.95263671875],[64.47850799560547,157.6868896484375],[63.976715087890625,157.4210205078125],[63.47523880004883,157.1553497314453],[62.97346496582031,156.88998413085938],[62.4716911315918,156.62460327148438],[61.96991729736328,156.35922241210938],[61.468143463134766,156.09385681152344],[60.966373443603516,155.82847595214844],[60.46438217163086,155.56298828125],[59.962608337402344,155.297607421875],[59.460838317871094,155.03224182128906],[58.95906448364258,154.76686096191406],[58.45729064941406,154.50149536132812],[57.955406188964844,154.236083984375],[57.453514099121094,153.97093200683594],[56.951622009277344,153.70578002929688],[56.44951629638672,153.44052124023438],[55.94762420654297,153.1753692626953],[55.44573211669922,152.91021728515625],[54.94384002685547,152.6450653076172],[54.44194793701172,152.37991333007812],[53.94005584716797,152.11476135253906],[53.43816375732422,151.849609375],[52.936275482177734,151.58445739746094],[52.434165954589844,151.31936645507812],[51.929317474365234,151.05958557128906],[51.42058181762695,150.80816650390625],[50.90768814086914,150.56480407714844],[50.391056060791016,150.32949829101562],[49.87089920043945,150.1023406982422],[49.34721755981445,149.88345336914062],[48.82017517089844,149.67286682128906],[48.28949737548828,149.4706268310547],[47.75585174560547,149.27735900878906],[47.21891403198242,149.09304809570312],[46.678932189941406,148.91806030273438],[46.135841369628906,148.75286865234375],[45.58989334106445,148.5980224609375],[45.040767669677734,148.453857421875],[44.488670349121094,148.32098388671875],[43.93415451049805,148.200439453125],[43.3766975402832,148.09263610839844],[42.81707000732422,147.99874877929688],[42.25487518310547,147.91973876953125],[41.69083786010742,147.8568115234375],[41.125064849853516,147.81130981445312],[40.558082580566406,147.784912109375],[39.99021530151367,147.7792205810547],[39.42287063598633,147.79629516601562],[38.85692596435547,147.8384246826172],[38.29367446899414,147.90814208984375],[37.73493576049805,148.00811767578125],[37.183258056640625,148.1411895751953],[36.642635345458984,148.3134002685547],[36.11666488647461,148.52662658691406],[35.60646438598633,148.77552795410156],[35.112422943115234,149.05506896972656],[34.63449478149414,149.3611297607422],[34.17207336425781,149.68994140625],[33.72431564331055,150.0388946533203],[33.2909049987793,150.4053497314453],[32.87092971801758,150.78726196289062],[32.46384048461914,151.182861328125],[32.0689811706543,151.59085083007812],[31.6859130859375,152.00985717773438],[31.314231872558594,152.438720703125],[30.95332908630371,152.876708984375],[30.602828979492188,153.32313537597656],[30.262544631958008,153.7775115966797],[29.932071685791016,154.23919677734375],[29.611316680908203,154.7077178955078],[29.30032730102539,155.1825714111328],[28.99904441833496,155.66346740722656],[28.70724105834961,156.1504364013672],[28.425153732299805,156.64309692382812],[28.153108596801758,157.14112854003906],[27.891176223754883,157.644775390625],[27.640010833740234,158.1536407470703],[27.398603439331055,158.66773986816406],[27.15970230102539,159.1826629638672],[26.921987533569336,159.69808959960938],[26.685564041137695,160.21412658691406],[26.450241088867188,160.73080444335938],[26.21611785888672,161.2478790283203],[25.98318099975586,161.76541137695312],[25.75141716003418,162.28366088867188],[25.52082061767578,162.8026123046875],[25.29147720336914,163.3218231201172],[25.063278198242188,163.841552734375],[24.83634376525879,164.36167907714844],[24.610559463500977,164.8826446533203],[24.385984420776367,165.4039306640625],[24.162595748901367,165.9256134033203],[23.940208435058594,166.44825744628906],[23.719200134277344,166.97116088867188],[23.499343872070312,167.49447631835938],[23.280960083007812,168.01834106445312],[23.063196182250977,168.54248046875],[22.847076416015625,169.06735229492188],[22.631864547729492,169.5927276611328],[22.417572021484375,170.1183624267578],[22.20492172241211,170.64486694335938],[21.993133544921875,171.1714630126953],[21.782440185546875,171.6985321044922],[21.573240280151367,172.22607421875],[21.364782333374023,172.75401306152344],[21.157608032226562,173.282470703125],[20.951583862304688,173.8115692138672],[20.746360778808594,174.34088134765625],[20.542516708374023,174.8708953857422],[20.33981704711914,175.4009552001953],[20.13779640197754,175.93150329589844],[19.937360763549805,176.4625701904297],[19.737775802612305,176.99388122558594],[19.538957595825195,177.5255584716797],[19.34169578552246,178.05776977539062],[19.145097732543945,178.5904083251953],[18.9493408203125,179.1234588623047],[18.755046844482422,179.6567840576172],[18.56145668029785,180.19033813476562],[18.368806838989258,180.72427368164062],[18.17741584777832,181.2584991455078],[17.986597061157227,181.7932586669922],[17.79683494567871,182.32821655273438],[17.60810089111328,182.8636474609375],[17.41998291015625,183.39939880371094],[17.23296356201172,183.93533325195312],[17.046886444091797,184.47154235839844],[16.861448287963867,185.00787353515625],[16.677032470703125,185.54470825195312],[16.49335479736328,186.08197021484375],[16.310344696044922,186.61915588378906],[16.128297805786133,187.1570587158203],[15.946996688842773,187.6949462890625],[15.766234397888184,188.23301696777344],[15.586554527282715,188.77146911621094],[15.407369613647461,189.3102264404297],[15.228771209716797,189.84902954101562],[15.051188468933105,190.38812255859375],[14.874072074890137,190.9273681640625],[14.697446823120117,191.46707153320312],[14.521728515625,192.00685119628906],[14.346430778503418,192.54676818847656],[14.171748161315918,193.08685302734375],[13.997774124145508,193.6271209716797],[13.824163436889648,194.16757202148438],[13.651187896728516,194.7082061767578],[13.47877025604248,195.24896240234375],[13.306591033935547,195.7901611328125],[13.135141372680664,196.33126831054688],[12.964153289794922,196.87234497070312],[12.79336166381836,197.4138641357422],[12.62326717376709,197.95541381835938],[12.453607559204102,198.4969940185547],[12.28441047668457,199.038818359375],[12.115140914916992,199.58087158203125],[11.946270942687988,200.12277221679688],[11.77812385559082,200.66493225097656],[11.609977722167969,201.2070770263672],[11.441963195800781,201.74923706054688],[11.274693489074707,202.29165649414062],[11.10742473602295,202.83407592773438],[10.940155982971191,203.37649536132812],[10.773452758789062,203.91946411132812],[10.606888771057129,204.46209716796875],[10.440323829650879,205.00474548339844],[10.274352073669434,205.54734802246094],[10.10850715637207,206.0902099609375],[9.942663192749023,206.63307189941406],[9.77681827545166,207.17591857910156],[9.610973358154297,207.71878051757812],[9.445056915283203,208.26187133789062],[9.279305458068848,208.80477905273438],[9.113872528076172,209.34776306152344],[8.948439598083496,209.8907470703125],[8.78300666809082,210.43374633789062],[8.617572784423828,210.9767303466797],[8.452139854431152,211.51971435546875],[8.286636352539062,212.06292724609375],[8.121786117553711,212.6060333251953],[7.959428787231445,213.14999389648438],[7.7997145652771,213.6947784423828],[7.642920017242432,214.24032592773438],[7.489135265350342,214.78662109375],[7.338196754455566,215.33389282226562],[7.1906633377075195,215.88189697265625],[7.045949459075928,216.43109130859375],[6.904938220977783,216.9810028076172],[6.767146110534668,217.53155517578125],[6.632935047149658,218.0830535888672],[6.502346038818359,218.6354522705078],[6.375256538391113,219.18873596191406],[6.252311706542969,219.74290466308594],[6.132970809936523,220.29776000976562],[6.017886161804199,220.85389709472656],[5.9068522453308105,221.41041564941406],[5.800029277801514,221.96786499023438],[5.69772481918335,222.52626037597656],[5.599514961242676,223.08543395996094],[5.506260395050049,223.64523315429688],[5.417713165283203,224.20587158203125],[5.333990097045898,224.7674102783203],[5.255234241485596,225.3297576904297],[5.1816182136535645,225.892578125],[5.113250732421875,226.45603942871094],[5.050329208374023,227.02015686035156],[4.99297571182251,227.58485412597656],[4.941287517547607,228.150146484375],[4.895418643951416,228.71600341796875],[4.855522155761719,229.2823028564453],[4.821752071380615,229.84896850585938],[4.7942657470703125,230.41592407226562],[4.773271560668945,230.9831085205078],[4.758920669555664,231.55067443847656],[4.751335620880127,232.11822509765625],[4.750675678253174,232.68576049804688],[4.757106781005859,233.25338745117188],[4.770809650421143,233.82125854492188],[4.791924953460693,234.38836669921875],[4.8206400871276855,234.95529174804688],[4.85711669921875,235.52175903320312],[4.901557922363281,236.0875701904297],[4.954150199890137,236.65277099609375],[5.014984130859375,237.21701049804688],[5.081142902374268,237.78073120117188],[5.148841857910156,238.34466552734375],[5.2179274559021,238.90798950195312],[5.288398265838623,239.4711151123047],[5.360276222229004,240.0343017578125],[5.433518886566162,240.59727478027344],[5.508089542388916,241.1598358154297],[5.58403205871582,241.722412109375],[5.661312103271484,242.28480529785156],[5.73994779586792,242.84719848632812],[5.819863796234131,243.4091339111328],[5.901085376739502,243.9708709716797],[5.9835968017578125,244.53237915039062],[6.0674285888671875,245.09388732910156],[6.15253210067749,245.65516662597656],[6.2388997077941895,246.21621704101562],[6.326556205749512,246.77725219726562],[6.41541862487793,247.3378143310547],[6.5055131912231445,247.8981475830078],[6.596867561340332,248.45846557617188],[6.68943452835083,249.01852416992188],[6.783204555511475,249.5783233642578],[6.878166198730469,250.13784790039062],[6.974351406097412,250.69737243652344],[7.071753978729248,251.2567901611328],[7.170347213745117,251.81591796875],[7.270050048828125,252.37452697753906],[7.370972633361816,252.9333038330078],[7.473092079162598,253.4916229248047],[7.576601028442383,254.0497283935547],[7.680577278137207,254.6075897216797],[7.786253452301025,255.16529846191406],[7.89246129989624,255.72317504882812],[8.000127792358398,256.2806701660156],[8.10905933380127,256.8377685546875],[8.218976020812988,257.3946533203125],[8.329767227172852,257.9512023925781],[8.441758155822754,258.5076599121094],[8.554807662963867,259.0640869140625],[8.668883323669434,259.620361328125],[8.784037590026855,260.1760559082031],[8.900080680847168,260.7317199707031],[9.017402648925781,261.28717041015625],[9.135425567626953,261.8423767089844],[9.254826545715332,262.3973693847656],[9.374798774719238,262.9521484375],[9.496234893798828,263.5066223144531],[9.618176460266113,264.0612487792969],[9.741600036621094,264.6151123046875],[9.865385055541992,265.1690673828125],[9.990869522094727,265.72283935546875],[10.116512298583984,266.2763977050781],[10.243854522705078,266.829345703125],[10.371367454528809,267.38250732421875],[10.500643730163574,267.9352111816406],[10.630123138427734,268.4881896972656],[10.761174201965332,269.04046630859375],[10.892467498779297,269.59271240234375],[11.025264739990234,270.14459228515625],[11.158387184143066,270.6963195800781],[11.292902946472168,271.2477722167969],[11.427870750427246,271.7991943359375],[11.56407642364502,272.3502502441406],[11.700858116149902,272.9013671875],[11.83872127532959,273.4519958496094],[11.977209091186523,274.00250244140625],[12.116706848144531,274.5527038574219],[12.256928443908691,275.10284423828125],[12.398030281066895,275.65264892578125],[12.539876937866211,276.2021179199219],[12.682619094848633,276.75177001953125],[12.826176643371582,277.3009948730469],[12.970410346984863,277.8499755859375],[13.11557674407959,278.3987121582031],[13.261336326599121,278.9472961425781],[13.408135414123535,279.4957275390625],[13.555395126342773,280.0439453125],[13.703721046447754,280.5917663574219],[13.852520942687988,281.1398010253906],[14.002408027648926,281.6872863769531],[14.152586936950684,282.2347106933594],[14.303930282592773,282.7815856933594],[14.455526351928711,283.32861328125],[14.608407974243164,283.8752746582031],[14.76140308380127,284.4219055175781],[14.91572380065918,284.9681091308594],[15.070235252380371,285.5146789550781],[15.225944519042969,286.0605163574219],[15.3817777633667,286.6063232421875],[15.53880500793457,287.15179443359375],[15.696054458618164,287.6972351074219],[15.854375839233398,288.2423400878906],[16.013002395629883,288.78741455078125],[16.17259407043457,289.3321533203125],[16.332622528076172,289.8770446777344],[16.493459701538086,290.42138671875],[16.65473175048828,290.96563720703125],[16.816787719726562,291.5096435546875],[16.979312896728516,292.0533752441406],[17.14256477355957,292.5970153808594],[17.306385040283203,293.1404724121094],[17.47087860107422,293.6839904785156],[17.635961532592773,294.2271423339844],[17.80152702331543,294.7701110839844],[17.967819213867188,295.3128967285156],[18.134511947631836,295.8554992675781],[18.30191421508789,296.39764404296875],[18.46970558166504,296.9399108886719],[18.638391494750977,297.4821472167969],[18.807329177856445,298.0242919921875],[18.9770450592041,298.5658264160156],[19.146961212158203,299.107421875],[19.31781005859375,299.6486511230469],[19.488758087158203,300.18994140625],[19.66069984436035,300.7308349609375],[19.832792282104492,301.27197265625],[20.00572967529297,301.8126220703125],[20.17886734008789,302.3533630371094],[20.352764129638672,302.8937072753906],[20.526899337768555,303.43402099609375],[20.70173454284668,303.9740295410156],[20.876848220825195,304.5139465332031],[21.052589416503906,305.0536804199219],[21.228870391845703,305.5931091308594],[21.40721893310547,306.1324768066406],[21.587556838989258,306.6705627441406],[21.770097732543945,307.2080993652344],[21.954927444458008,307.74462890625],[22.14202117919922,308.2806091308594],[22.331214904785156,308.8157958984375],[22.522491455078125,309.3502197265625],[22.715848922729492,309.8839416503906],[22.91135025024414,310.41705322265625],[23.10906982421875,310.9491271972656],[23.30886459350586,311.4804992675781],[23.51058578491211,312.01092529296875],[23.71442413330078,312.5408935546875],[23.920169830322266,313.0699157714844],[24.127965927124023,313.5981750488281],[24.337810516357422,314.1253662109375],[24.54979705810547,314.6523742675781],[24.763452529907227,315.1780700683594],[24.979053497314453,315.703125],[25.196575164794922,316.2275390625],[25.416128158569336,316.7509765625],[25.637500762939453,317.2735900878906],[25.86073875427246,317.79559326171875],[26.08565902709961,318.31658935546875],[26.312522888183594,318.8372497558594],[26.541200637817383,319.3568420410156],[26.771677017211914,319.87567138671875],[27.003747940063477,320.39349365234375],[27.23760986328125,320.91082763671875],[27.473045349121094,321.4272155761719],[27.71025848388672,321.94287109375],[27.94934844970703,322.45806884765625],[28.189836502075195,322.9721374511719],[28.431943893432617,323.4855041503906],[28.675640106201172,323.998291015625],[28.920928955078125,324.51025390625],[29.167783737182617,325.0213317871094],[29.416095733642578,325.5316162109375],[29.665904998779297,326.04132080078125],[29.917325973510742,326.5506591796875],[30.170543670654297,327.0587463378906],[30.42436981201172,327.56622314453125],[30.680089950561523,328.0729675292969],[30.937124252319336,328.5791320800781],[31.19512939453125,329.084716796875],[31.4551944732666,329.5894470214844],[31.715848922729492,330.0935363769531],[31.97831916809082,330.59710693359375],[32.24190139770508,331.0999450683594],[32.5063362121582,331.6022033691406],[32.772544860839844,332.1034240722656],[33.039451599121094,332.6044006347656],[33.30784606933594,333.1045837402344],[33.577274322509766,333.6040954589844],[33.84754943847656,334.1032409667969],[34.1196403503418,334.6018371582031],[34.392120361328125,335.0997314453125],[34.665950775146484,335.596923828125],[34.94074630737305,336.0936279296875],[35.21625900268555,336.58990478515625],[35.49317932128906,337.0852966308594],[35.77072525024414,337.58056640625],[36.04951858520508,338.0752868652344],[36.328956604003906,338.5692138671875],[36.609107971191406,339.0628967285156],[36.890602111816406,339.55596923828125],[37.17247009277344,340.0486755371094],[37.45539093017578,340.540771484375],[37.73895263671875,341.0323181152344],[38.023170471191406,341.523681640625],[38.30860900878906,342.0146789550781],[38.59429168701172,342.5052185058594],[38.88087844848633,342.99517822265625],[39.168087005615234,343.4848937988281],[39.45576095581055,343.9742126464844],[39.7442626953125,344.46295166015625],[40.03314971923828,344.95159912109375],[40.32281494140625,345.43975830078125],[40.613014221191406,345.92779541015625],[40.903587341308594,346.4154357910156],[41.195159912109375,346.9024963378906],[41.4869499206543,347.3893737792969],[41.77873611450195,347.8762512207031],[42.07111358642578,348.3627014160156],[42.36432647705078,348.8487548828125],[42.65766525268555,349.3349914550781],[42.95102310180664,349.8210754394531],[43.24540328979492,350.3064270019531],[43.53977966308594,350.791748046875],[43.83415985107422,351.2770690917969],[44.12913513183594,351.761962890625],[44.42443084716797,352.2467346191406],[44.719730377197266,352.7314758300781],[45.01539993286133,353.2162780761719],[45.31159210205078,353.70050048828125],[45.60778045654297,354.1847229003906],[45.903968811035156,354.6689453125],[46.20016098022461,355.1531677246094],[46.4963493347168,355.63739013671875],[46.792537689208984,356.1216125488281],[47.08890914916992,356.605712890625],[47.3856086730957,357.08990478515625],[47.68218231201172,357.57391357421875],[47.978755950927734,358.0578918457031],[48.27532958984375,358.5418701171875],[48.5718994140625,359.02587890625],[48.868473052978516,359.5098571777344],[49.16594696044922,359.9933166503906],[49.4659309387207,360.4750671386719],[49.76924514770508,360.9551086425781],[50.075714111328125,361.43316650390625],[50.3851432800293,361.9090270996094],[50.697601318359375,362.3828430175781],[51.01305389404297,362.85455322265625],[51.331573486328125,363.3243713378906],[51.65320587158203,363.79229736328125],[51.97780990600586,364.2580871582031],[52.305320739746094,364.7217712402344],[52.63568878173828,365.183349609375],[52.9688606262207,365.6427917480469],[53.304935455322266,366.1002197265625],[53.64385223388672,366.5555725097656],[53.9856071472168,367.00885009765625],[54.33011245727539,367.4599609375],[54.67751693725586,367.9090881347656],[55.02759552001953,368.35601806640625],[55.380332946777344,368.8006591796875],[55.735801696777344,369.2431640625],[56.0940055847168,369.6835021972656],[56.45488357543945,370.1216125488281],[56.818565368652344,370.5576477050781],[57.18483352661133,370.9913635253906],[57.5538444519043,371.42291259765625],[57.92535400390625,371.8520202636719],[58.29954528808594,372.27886962890625],[58.67631530761719,372.703369140625],[59.05570602416992,373.12554931640625],[59.43776321411133,373.5454406738281],[59.82235336303711,373.9628601074219],[60.2095947265625,374.3779602050781],[60.599422454833984,374.7906494140625],[60.99184036254883,375.20086669921875],[61.386802673339844,375.6085510253906],[61.78428268432617,376.0137023925781],[62.184417724609375,376.4163818359375],[62.587005615234375,376.81640625],[62.992366790771484,377.2140197753906],[63.400299072265625,377.6090393066406],[63.81059646606445,378.0012512207031],[64.22331237792969,378.39080810546875],[64.63887023925781,378.7775573730469],[65.05674743652344,379.1615905761719],[65.477294921875,379.5428161621094],[65.90042877197266,379.9212341308594],[66.32614135742188,380.2967224121094],[66.75466918945312,380.6695251464844],[67.18534851074219,381.0390319824219],[67.61882781982422,381.4057312011719],[68.0545883178711,381.7691650390625],[68.4931640625,382.12969970703125],[68.93413543701172,382.4869384765625],[69.37785339355469,382.8411560058594],[69.82393646240234,383.1919860839844],[70.27293395996094,383.5397644042969],[70.7242431640625,383.8840026855469],[71.17813873291016,384.2248229980469],[71.6347885131836,384.56219482421875],[72.09386444091797,384.89593505859375],[72.55553436279297,385.2261047363281],[73.01984405517578,385.5526428222656],[73.48692321777344,385.87548828125],[73.95638275146484,386.1944580078125],[74.42858123779297,386.5097351074219],[74.90312194824219,386.8212890625],[75.380126953125,387.12884521484375],[75.85929870605469,387.4329528808594],[76.34087371826172,387.7335205078125],[76.82453155517578,388.03045654296875],[77.31066131591797,388.3240966796875],[77.79875946044922,388.6141052246094],[78.2887954711914,388.9005432128906],[78.78089904785156,389.18328857421875],[79.27499389648438,389.4625244140625],[79.77104949951172,389.73834228515625],[80.26918029785156,390.01092529296875],[80.76892852783203,390.2799987792969],[81.27067565917969,390.54583740234375],[81.77391815185547,390.8082580566406],[82.27904510498047,391.0675048828125],[82.7855453491211,391.32330322265625],[83.2940444946289,391.5760192871094],[83.80382537841797,391.82537841796875],[84.3154525756836,392.0715026855469],[84.82849884033203,392.3143005371094],[85.34307098388672,392.55401611328125],[85.85912322998047,392.7906188964844],[86.37662506103516,393.02410888671875],[86.89530181884766,393.2544250488281],[87.41552734375,393.48175048828125],[87.93682861328125,393.7059326171875],[88.4595947265625,393.92718505859375],[88.9837646484375,394.1454772949219],[89.50907897949219,394.3607482910156],[90.0354995727539,394.5730285644531],[90.56312561035156,394.78216552734375],[91.09215545654297,394.9884338378906],[91.62210083007812,395.1916809082031],[92.15316009521484,395.39202880859375],[92.6852798461914,395.5895080566406],[93.21885681152344,395.78424072265625],[93.75296020507812,395.9759521484375],[94.2881851196289,396.16485595703125],[94.82452392578125,396.35101318359375],[95.3616714477539,396.5343017578125],[95.89983367919922,396.71478271484375],[96.43897247314453,396.89251708984375],[96.97907257080078,397.0675048828125],[97.52001953125,397.239501953125],[98.06199645996094,397.4088134765625],[98.60450744628906,397.5752868652344],[99.14818572998047,397.7391662597656],[99.69229125976562,397.9001770019531],[100.23749542236328,398.05859375],[100.78327941894531,398.2142639160156],[101.32981872558594,398.3672180175781],[101.87755584716797,398.51763916015625],[102.42550659179688,398.6652526855469],[102.97431945800781,398.8101806640625],[103.52362060546875,398.95318603515625],[104.07295227050781,399.0961608886719],[104.62227630615234,399.2391052246094],[105.1716079711914,399.382080078125],[105.72139739990234,399.52410888671875],[106.27098083496094,399.6661071777344],[106.82056427001953,399.80810546875],[107.3702163696289,399.9500732421875],[107.92003631591797,400.0910949707031],[108.46986389160156,400.2321472167969],[109.01969146728516,400.3731689453125],[109.56948852539062,400.51416015625],[110.11978912353516,400.6543273925781],[110.66985321044922,400.79443359375],[111.21991729736328,400.9345397949219],[111.76995849609375,401.0745544433594],[112.32025146484375,401.2137451171875],[112.87054443359375,401.3529357910156],[113.42083740234375,401.4921569824219],[113.97117614746094,401.6312255859375],[114.52193450927734,401.76959228515625],[115.07244873046875,401.90789794921875],[115.62296295166016,402.0462341308594],[116.17366790771484,402.1844177246094],[116.72440338134766,402.3218688964844],[117.27513885498047,402.4593200683594],[117.82586669921875,402.5967712402344],[118.37676239013672,402.7340393066406],[118.92770385742188,402.8706359863281],[119.47865295410156,403.0072326660156],[120.02959442138672,403.14385986328125],[120.58052825927734,403.2801818847656],[121.13166809082031,403.4159851074219],[121.68281555175781,403.5517883300781],[122.23396301269531,403.68756103515625],[122.78544616699219,403.8231506347656],[123.3367919921875,403.9581298828125],[123.88813018798828,404.0931091308594],[124.4394760131836,404.22808837890625],[124.9908676147461,404.36273193359375],[125.54240417480469,404.4969482421875],[126.09394073486328,404.6311340332031],[126.64546966552734,404.7653503417969],[127.19734191894531,404.8992614746094],[127.74905395507812,405.03271484375],[128.30078125,405.1661682128906],[128.8524932861328,405.29962158203125],[129.40440368652344,405.4327087402344],[129.956298828125,405.5654296875],[130.50819396972656,405.6981506347656],[131.06008911132812,405.83087158203125],[131.61231994628906,405.96319580078125],[132.16439819335938,406.0951843261719],[132.71646118164062,406.2272033691406],[133.26852416992188,406.35919189453125],[133.82061767578125,406.490478515625],[134.3729248046875,406.6214599609375],[134.92523193359375,406.75244140625],[135.477783203125,406.8834533691406],[136.03009033203125,407.0144348144531],[136.5823974609375,407.1454162597656],[137.13470458984375,407.2763977050781],[137.68701171875,407.4073791503906],[138.23971557617188,407.537353515625],[138.79234313964844,407.66705322265625],[139.34495544433594,407.7967224121094],[139.89779663085938,407.9264831542969],[140.45040893554688,408.05615234375],[141.00302124023438,408.18585205078125],[141.55563354492188,408.3155517578125],[142.10824584960938,408.4452209472656],[142.66098022460938,408.5737609863281],[143.21388244628906,408.7022399902344],[143.7667694091797,408.8307189941406],[144.3199005126953,408.95928955078125],[144.872802734375,409.0877685546875],[145.42568969726562,409.21624755859375],[145.97857666015625,409.3447570800781],[146.53155517578125,409.47314453125],[147.08470153808594,409.60052490234375],[147.63784790039062,409.7279052734375],[148.19100952148438,409.85528564453125],[148.744384765625,409.98272705078125],[149.29754638671875,410.110107421875],[149.85069274902344,410.23748779296875],[150.40383911132812,410.3648681640625],[150.95718383789062,410.4920349121094],[151.51055908203125,410.618408203125],[152.06393432617188,410.7447814941406],[152.6175537109375,410.8711853027344],[153.1709442138672,410.99755859375],[153.7243194580078,411.1239318847656],[154.27769470214844,411.25030517578125],[154.83108520507812,411.3766784667969],[155.38455200195312,411.502685546875],[155.9381561279297,411.6281433105469],[156.4917449951172,411.75360107421875],[157.0455780029297,411.87908935546875],[157.5991668701172,412.0045471191406],[158.1527557373047,412.1299743652344],[158.7063446044922,412.25543212890625],[159.2599334716797,412.3808898925781],[159.8135986328125,412.505859375],[160.36737060546875,412.6304626464844],[160.92115783691406,412.7550964355469],[161.4751739501953,412.8797607421875],[162.02894592285156,413.00439453125],[162.58273315429688,413.1289978027344],[163.13650512695312,413.2536315917969],[163.69029235839844,413.37823486328125],[164.24415588378906,413.5023193359375],[164.798095703125,413.626220703125],[165.35227966308594,413.7501525878906],[165.90621948242188,413.8740234375],[166.46017456054688,413.9979248046875],[167.0141143798828,414.1217956542969],[167.56805419921875,414.2456970214844],[168.1219940185547,414.36956787109375],[168.6761016845703,414.492919921875],[169.23019409179688,414.6161804199219],[169.78451538085938,414.7394714355469],[170.33859252929688,414.8627014160156],[170.89268493652344,414.9859619140625],[171.44677734375,415.10919189453125],[172.0008544921875,415.2324523925781],[172.55496215820312,415.3556823730469],[173.10922241210938,415.4781494140625],[173.66348266601562,415.6006164550781],[174.2179718017578,415.72314453125],[174.77223205566406,415.8456115722656],[175.3264923095703,415.96807861328125],[175.88075256347656,416.0905456542969],[176.43499755859375,416.2130126953125],[176.9892578125,416.33551025390625],[177.54351806640625,416.4579772949219],[178.0977783203125,416.5804443359375],[178.6522674560547,416.7029724121094],[179.20652770996094,416.825439453125],[179.7607879638672,416.9479064941406],[180.31504821777344,417.07037353515625],[180.86929321289062,417.1928405761719],[181.42359924316406,417.3150939941406],[181.97801208496094,417.4368591308594],[182.53265380859375,417.55865478515625],[183.0870819091797,417.680419921875],[183.64149475097656,417.80218505859375],[184.19590759277344,417.9239501953125],[184.7503204345703,418.0456848144531],[185.3047332763672,418.1674499511719],[185.85914611816406,418.2892150878906],[186.41355895996094,418.4109802246094],[186.9682159423828,418.53277587890625],[187.5226287841797,418.654541015625],[188.07704162597656,418.77630615234375],[188.63145446777344,418.8980712890625],[189.1858673095703,419.0198059082031],[189.7402801513672,419.1415710449219],[190.29466247558594,419.26312255859375],[190.84913635253906,419.38458251953125],[191.4038543701172,419.5060729980469],[191.95834350585938,419.6275329589844],[192.51283264160156,419.74896240234375],[193.0673065185547,419.87042236328125],[193.62179565429688,419.99188232421875],[194.17626953125,420.1133117675781],[194.7307586669922,420.2347717285156],[195.2852325439453,420.356201171875],[195.8399658203125,420.47772216796875],[196.39443969726562,420.5991516113281],[196.9489288330078,420.7206115722656],[197.50340270996094,420.8420715332031],[198.05789184570312,420.9635009765625],[198.61236572265625,421.0849609375],[199.16685485839844,421.2063903808594],[199.72157287597656,421.3279113769531],[200.27606201171875,421.4493408203125],[200.83053588867188,421.57080078125],[201.38502502441406,421.6922607421875],[201.9394989013672,421.8136901855469],[202.49398803710938,421.9351501464844],[203.0484619140625,422.05657958984375],[203.6029510498047,422.17803955078125],[204.1576690673828,422.2995300292969],[204.712158203125,422.4209899902344],[205.26663208007812,422.5424499511719],[205.8211212158203,422.66387939453125],[206.37559509277344,422.78533935546875],[206.93008422851562,422.9067687988281],[207.48455810546875,423.0282897949219],[208.0389404296875,423.1501770019531],[208.59356689453125,423.2721252441406],[209.14794921875,423.3940124511719],[209.70233154296875,423.5158996582031],[210.2567138671875,423.6377868652344],[210.8111114501953,423.7596740722656],[211.36549377441406,423.8815612792969],[211.9198760986328,424.0034484863281],[212.47450256347656,424.1253967285156],[213.0288848876953,424.2472839355469],[213.58326721191406,424.3691711425781],[214.13766479492188,424.4910583496094],[214.69204711914062,424.6129455566406],[215.24642944335938,424.7348327636719],[215.80081176757812,424.8567199707031],[216.355224609375,424.9787902832031],[216.90972900390625,425.1012878417969],[217.4639892578125,425.2237243652344],[218.01824951171875,425.3461608886719],[218.57252502441406,425.4685974121094],[219.1267852783203,425.5910339355469],[219.68104553222656,425.7134704589844],[220.23532104492188,425.83587646484375],[220.78953552246094,425.9585266113281],[221.34393310546875,426.0815124511719],[221.89808654785156,426.2044372558594],[222.45223999023438,426.3273620605469],[223.0063934326172,426.4503173828125],[223.560546875,426.5732421875],[224.1147003173828,426.6961669921875],[224.66885375976562,426.819091796875],[225.2229766845703,426.94232177734375],[225.77723693847656,427.06585693359375],[226.33126831054688,427.18939208984375],[226.8852996826172,427.3128967285156],[227.4393310546875,427.4364013671875],[227.99334716796875,427.5599060058594],[228.54737854003906,427.68341064453125],[229.10140991210938,427.8069152832031],[229.65542602539062,427.9307861328125],[230.2093048095703,428.05499267578125],[230.76318359375,428.1791687011719],[231.31704711914062,428.3033447265625],[231.8709259033203,428.4275207519531],[232.4248046875,428.55169677734375],[232.9786834716797,428.6758728027344],[233.53256225585938,428.8000793457031],[234.08676147460938,428.9247741699219],[234.64047241210938,429.0497131347656],[235.1941680908203,429.1746520996094],[235.7478790283203,429.2995910644531],[236.3015899658203,429.4245300292969],[236.8553009033203,429.5494689941406],[237.40899658203125,429.6744079589844],[237.96270751953125,429.7993469238281],[238.51641845703125,429.9248046875],[239.06993103027344,430.05059814453125],[239.62344360351562,430.1763916015625],[240.1769561767578,430.30218505859375],[240.73046875,430.4280090332031],[241.2839813232422,430.5538024902344],[241.83749389648438,430.6795959472656],[242.39100646972656,430.8053894042969],[242.94456481933594,430.9320373535156],[243.49777221679688,431.05914306640625],[244.0509796142578,431.186279296875],[244.60400390625,431.3144836425781],[245.15687561035156,431.4430847167969],[245.70974731445312,431.5716857910156],[246.2623748779297,431.7013244628906],[246.81520080566406,431.8311767578125],[247.36778259277344,431.9609680175781],[247.92010498046875,432.0915832519531],[248.4724884033203,432.2221984863281],[249.0249481201172,432.3529052734375],[249.5771942138672,432.484130859375],[250.1294403076172,432.6153564453125],[250.68170166015625,432.74658203125],[251.23419189453125,432.8778381347656],[251.78643798828125,433.0090637207031],[252.3386688232422,433.14013671875],[252.89100646972656,433.2710266113281],[253.44332885742188,433.40191650390625],[253.99566650390625,433.5328063964844],[254.54798889160156,433.6636962890625],[255.10032653808594,433.7945861816406],[255.65316772460938,433.9248046875],[256.20574951171875,434.0545959472656],[256.7583312988281,434.18438720703125],[257.3111267089844,434.31317138671875],[257.8639831542969,434.4418029785156],[258.4168395996094,434.5704040527344],[258.969970703125,434.6974792480469],[259.5231628417969,434.8245849609375],[260.0766296386719,434.9514465332031],[260.6302490234375,435.07666015625],[261.18389892578125,435.2018737792969],[261.7378845214844,435.32647705078125],[262.2920227050781,435.4494934082031],[262.8461608886719,435.572509765625],[263.40032958984375,435.6946105957031],[263.9551086425781,435.8157653808594],[264.5099792480469,435.935546875],[265.06512451171875,436.054443359375],[265.6202087402344,436.17242431640625],[266.1756896972656,436.2892150878906],[266.7314758300781,436.40472412109375],[267.2874450683594,436.5192565917969],[267.8436279296875,436.6327209472656],[268.4004211425781,436.7444763183594],[268.9571228027344,436.8551025390625],[269.5140380859375,436.9646301269531],[270.07135009765625,437.0724182128906],[270.6289978027344,437.1787414550781],[271.18670654296875,437.2838134765625],[271.7447814941406,437.38739013671875],[272.3034362792969,437.4890441894531],[272.8624267578125,437.5893249511719],[273.4212951660156,437.68817138671875],[273.98065185546875,437.7847900390625],[274.5401306152344,437.8797607421875],[275.1000061035156,437.9732666015625],[275.66021728515625,438.0647277832031],[276.22076416015625,438.1540222167969],[276.7818298339844,438.24176025390625],[277.3428649902344,438.3278503417969],[277.9044189453125,438.41107177734375],[278.4662780761719,438.4925842285156],[279.0282287597656,438.57232666015625],[279.590576171875,438.6495361328125],[280.1531066894531,438.7243957519531],[280.7160949707031,438.7974548339844],[281.2795104980469,438.8683776855469],[281.8431091308594,438.9362487792969],[282.4068298339844,439.0025939941406],[282.9708557128906,439.06610107421875],[283.5351867675781,439.1270751953125],[284.0998840332031,439.185791015625],[284.66473388671875,439.2416687011719],[285.2297668457031,439.295166015625],[285.7953796386719,439.34600830078125],[286.36102294921875,439.39410400390625],[286.9266662597656,439.4397277832031],[287.4927062988281,439.4823303222656],[288.0588684082031,439.5223693847656],[288.6254577636719,439.55950927734375],[289.1920471191406,439.59375],[289.7586669921875,439.62530517578125],[290.325927734375,439.6537170410156],[290.892822265625,439.6793212890625],[291.460205078125,439.7018127441406],[292.0273742675781,439.7213439941406],[292.5948486328125,439.7379150390625],[293.1622619628906,439.7510986328125],[293.7298583984375,439.7613220214844],[294.2976379394531,439.7706604003906],[294.8652038574219,439.77996826171875],[295.4325866699219,439.7877502441406],[296.0003662109375,439.794677734375],[296.5679626464844,439.8007507324219],[297.1353759765625,439.8055419921875],[297.703125,439.80950927734375],[298.2707214355469,439.8126525878906],[298.8385925292969,439.8146057128906],[299.40618896484375,439.8155212402344],[299.9737548828125,439.8155822753906],[300.5413818359375,439.8146057128906],[301.1089782714844,439.8123474121094],[301.6767272949219,439.8091735839844],[302.244384765625,439.8051452636719],[302.8119812011719,439.79962158203125],[303.3797302246094,439.7931213378906],[303.9473571777344,439.78570556640625],[304.514892578125,439.7769775390625],[305.08233642578125,439.7669982910156],[305.6500244140625,439.7560119628906],[306.217529296875,439.7440185546875],[306.7850036621094,439.7303771972656],[307.3523864746094,439.71575927734375],[307.91998291015625,439.70013427734375],[308.48736572265625,439.68292236328125],[309.05462646484375,439.6645202636719],[309.62200927734375,439.6450500488281],[310.1892395019531,439.624267578125],[310.7564392089844,439.6018981933594],[311.323486328125,439.5784912109375],[311.89080810546875,439.55389404296875],[312.4578857421875,439.5274963378906],[313.02496337890625,439.4999694824219],[313.5918273925781,439.4713134765625],[314.15863037109375,439.4409484863281],[314.72540283203125,439.4091796875],[315.2920837402344,439.3762512207031],[315.8586730957031,439.3418273925781],[316.4251708984375,439.3056640625],[316.9916076660156,439.268310546875],[317.55792236328125,439.229736328125],[318.12408447265625,439.1889953613281],[318.6901550292969,439.1470642089844],[319.25628662109375,439.1038513183594],[319.8221130371094,439.05877685546875],[320.3876647949219,439.01214599609375],[320.9535217285156,438.9641418457031],[321.51898193359375,438.9145812988281],[322.0843811035156,438.863037109375],[322.6495056152344,438.8101806640625],[323.21441650390625,438.7559814453125],[323.77923583984375,438.699462890625],[324.34405517578125,438.6415100097656],[324.90863037109375,438.5821533203125],[325.47296142578125,438.5208740234375],[326.0371398925781,438.45770263671875],[326.6009826660156,438.39312744140625],[327.16473388671875,438.326904296875],[327.7283935546875,438.2583312988281],[328.29168701171875,438.1883239746094],[328.85479736328125,438.1168518066406],[329.4178466796875,438.0429382324219],[329.98040771484375,437.9673767089844],[330.54278564453125,437.8902893066406],[331.1048583984375,437.8111267089844],[331.6664123535156,437.7298583984375],[332.22796630859375,437.64697265625],[332.7892761230469,437.5624084472656],[333.350341796875,437.4752197265625],[333.9111633300781,437.3863830566406],[334.47149658203125,437.2960205078125],[335.0314636230469,437.203125],[335.5912170410156,437.1081848144531],[336.1504211425781,437.01165771484375],[336.70941162109375,436.9130554199219],[337.26800537109375,436.8118896484375],[337.82623291015625,436.70904541015625],[338.38433837890625,436.60443115234375],[338.9416809082031,436.4969787597656],[339.49884033203125,436.38763427734375],[340.0553283691406,436.2765808105469],[340.6114807128906,436.1630859375],[341.16717529296875,436.047119140625],[341.72247314453125,435.9293518066406],[342.2775573730469,435.8096008300781],[342.83172607421875,435.6868896484375],[343.3856506347656,435.5622863769531],[343.9389343261719,435.43585205078125],[344.49163818359375,435.3066101074219],[345.0440368652344,435.17572021484375],[345.59619140625,435.044189453125],[346.14837646484375,434.91265869140625],[346.7008056640625,434.7810974121094],[347.2529602050781,434.6495666503906],[347.804931640625,434.5173034667969],[348.3568115234375,434.3844299316406],[348.9086608886719,434.2515869140625],[349.46051025390625,434.11871337890625],[350.0123596191406,433.98583984375],[350.5639953613281,433.8525085449219],[351.11578369140625,433.7182922363281],[351.6673278808594,433.5841369628906],[352.2188720703125,433.4499816894531],[352.7704162597656,433.3158264160156],[353.3218994140625,433.181396484375],[353.8731384277344,433.04595947265625],[354.42437744140625,432.9105529785156],[354.9756164550781,432.7751159667969],[355.5270690917969,432.6396484375],[356.0784912109375,432.504150390625],[356.6294250488281,432.36749267578125],[357.18035888671875,432.2308349609375],[357.73126220703125,432.09417724609375],[358.2821960449219,431.95751953125],[358.8331298828125,431.82086181640625],[359.3839111328125,431.6831359863281],[359.9345397949219,431.5452880859375],[360.48516845703125,431.40740966796875],[361.0357971191406,431.2695617675781],[361.58642578125,431.1317138671875],[362.1369323730469,430.9930419921875],[362.687255859375,430.85400390625],[363.23760986328125,430.7149963378906],[363.7881774902344,430.575927734375],[364.3385009765625,430.4368896484375],[364.888671875,430.29730224609375],[365.438720703125,430.1571350097656],[365.98876953125,430.0169982910156],[366.5388488769531,429.8768615722656],[367.0888977050781,429.7367248535156],[367.6390075683594,429.59613037109375],[368.1889953613281,429.454833984375],[368.73876953125,429.3135681152344],[369.2885437011719,429.1723327636719],[369.83831787109375,429.03106689453125],[370.38787841796875,428.8896789550781],[370.9373779296875,428.7473449707031],[371.48687744140625,428.60504150390625],[372.0365905761719,428.462646484375],[372.5860900878906,428.3203430175781],[373.1356201171875,428.1780090332031],[373.6848449707031,428.0346374511719],[374.23406982421875,427.89129638671875],[374.7832946777344,427.7479248046875],[375.33251953125,427.6045837402344],[375.8817443847656,427.4612121582031],[376.430908203125,427.3169860839844],[376.9798889160156,427.172607421875],[377.5288391113281,427.02825927734375],[378.07781982421875,426.8838806152344],[378.62677001953125,426.7395324707031],[379.1756591796875,426.5945129394531],[379.724365234375,426.44915771484375],[380.2730712890625,426.3038330078125],[380.822021484375,426.158447265625],[381.3707275390625,426.01312255859375],[381.91937255859375,425.8673095703125],[382.46783447265625,425.7210388183594],[383.0162658691406,425.57476806640625],[383.5647277832031,425.4284973144531],[384.1131896972656,425.2822265625],[384.6615295410156,425.1357116699219],[385.2099609375,424.98846435546875],[385.7581787109375,424.8412780761719],[386.306396484375,424.6941223144531],[386.8546142578125,424.54693603515625],[387.40283203125,424.3996276855469],[387.9508361816406,424.2515869140625],[388.4988098144531,424.103515625],[389.0470275878906,423.9554138183594],[389.5950012207031,423.8073425292969],[390.1429748535156,423.6593017578125],[390.69073486328125,423.51043701171875],[391.23846435546875,423.3615417480469],[391.7862243652344,423.212646484375],[392.333984375,423.0637512207031],[392.8817138671875,422.91485595703125],[393.4294128417969,422.76531982421875],[393.9769592285156,422.6156005859375],[394.52447509765625,422.46588134765625],[395.0719909667969,422.316162109375],[395.6195373535156,422.1664733886719],[396.1669006347656,422.01629638671875],[396.7142333984375,421.8658142089844],[397.26153564453125,421.71533203125],[397.80908203125,421.5647888183594],[398.3564147949219,421.414306640625],[398.90374755859375,421.26348876953125],[399.4508361816406,421.11224365234375],[399.9979553222656,420.96099853515625],[400.5450439453125,420.80975341796875],[401.0921630859375,420.65850830078125],[401.63916015625,420.50714111328125],[402.1863098144531,420.3551025390625],[402.73321533203125,420.2031555175781],[403.2801208496094,420.05120849609375],[403.8270568847656,419.8992614746094],[404.3740234375,419.74725341796875],[404.9207458496094,419.5946044921875],[405.46746826171875,419.44195556640625],[406.0144348144531,419.28924560546875],[406.5611572265625,419.1365966796875],[407.10784912109375,418.9839782714844],[407.6542663574219,418.83050537109375],[408.2007141113281,418.6769104003906],[408.7471618652344,418.5233154296875],[409.2936096191406,418.36968994140625],[409.8400573730469,418.2160949707031],[410.3867492675781,418.0624084472656],[410.9331970214844,417.9088134765625],[411.4796447753906,417.7552185058594],[412.0260925292969,417.6015930175781],[412.5725402832031,417.447998046875],[413.11895751953125,417.29376220703125],[413.6650695800781,417.13897705078125],[414.211181640625,416.98419189453125],[414.7575378417969,416.829345703125],[415.30364990234375,416.674560546875],[415.8497619628906,416.519775390625],[416.3958740234375,416.364990234375],[416.9419860839844,416.210205078125],[417.48809814453125,416.055419921875],[418.0342102050781,415.900634765625],[418.5805358886719,415.74566650390625],[419.1263427734375,415.58984375],[419.6721496582031,415.4339904785156],[420.2179870605469,415.27813720703125],[420.7637939453125,415.122314453125],[421.3096008300781,414.9664611816406],[421.85540771484375,414.8106384277344],[422.4012451171875,414.65478515625],[422.9472961425781,414.4989013671875],[423.49310302734375,414.3430480957031],[424.0389099121094,414.18719482421875],[424.5843505859375,414.0307312011719],[425.1299133300781,413.87396240234375],[425.6754455566406,413.7171936035156],[426.22100830078125,413.5604248046875],[426.76654052734375,413.4036560058594],[427.31231689453125,413.2467956542969],[427.8578796386719,413.09002685546875],[428.4034118652344,412.9332580566406],[428.948974609375,412.7764892578125],[429.4945373535156,412.6197204589844],[430.0401611328125,412.46258544921875],[430.5854797363281,412.3050231933594],[431.13079833984375,412.1474609375],[431.67633056640625,411.98980712890625],[432.2216491699219,411.8322448730469],[432.7669677734375,411.6746520996094],[433.3122863769531,411.51708984375],[433.85760498046875,411.3594970703125],[434.4029235839844,411.2019348144531],[434.9482421875,411.04437255859375],[435.4937438964844,410.88671875],[436.0388488769531,410.7284851074219],[436.583984375,410.5702209472656],[437.12908935546875,410.4119873046875],[437.6742248535156,410.25372314453125],[438.2193298339844,410.095458984375],[438.76446533203125,409.9372253417969],[439.3095703125,409.7789611816406],[439.8549499511719,409.6206359863281],[440.4000549316406,409.46240234375],[440.9451904296875,409.30413818359375],[441.4902648925781,409.1455383300781],[442.03521728515625,408.9867248535156],[442.5801696777344,408.8279113769531],[443.1251525878906,408.6690979003906],[443.67010498046875,408.5102844238281],[444.2153015136719,408.3514099121094],[444.76025390625,408.1925964355469],[445.3052062988281,408.0337829589844],[445.85015869140625,407.875],[446.3951110839844,407.7161865234375],[446.94000244140625,407.5572509765625],[447.4847717285156,407.3978271484375],[448.0295715332031,407.2384338378906],[448.5745849609375,407.0789794921875],[449.119384765625,406.9195861816406],[449.6641540527344,406.76019287109375],[450.2089538574219,406.6007995605469],[450.7537536621094,406.44140625],[451.29852294921875,406.2820129394531],[451.84332275390625,406.12261962890625],[452.3883361816406,405.9631652832031],[452.9331359863281,405.80377197265625],[453.4779052734375,405.6443786621094],[454.022705078125,405.4849853515625],[454.5675048828125,405.3255920410156],[455.1122741699219,405.16619873046875],[455.6570739746094,405.00677490234375],[456.20184326171875,404.8473815917969],[456.74688720703125,404.68792724609375],[457.2916564941406,404.5285339355469],[457.8364562988281,404.369140625],[458.3812561035156,404.2095947265625],[458.92596435546875,404.0498962402344],[459.4706726074219,403.89019775390625],[460.015380859375,403.7304992675781],[460.56005859375,403.5708312988281],[461.1050109863281,403.41107177734375],[461.64971923828125,403.2513732910156],[462.19439697265625,403.0916748046875],[462.7391052246094,402.9319763183594],[463.2838134765625,402.7723083496094],[463.8284912109375,402.61260986328125],[464.3731994628906,402.4529113769531],[464.91815185546875,402.29315185546875],[465.46282958984375,402.1334533691406],[466.0075378417969,401.9737854003906],[466.55224609375,401.8140869140625],[467.0969543457031,401.6543884277344],[467.64166259765625,401.49468994140625],[468.18634033203125,401.33502197265625],[468.7310485839844,401.1753234863281],[469.2760009765625,401.01556396484375],[469.8206787109375,400.8558654785156],[470.3653869628906,400.6961669921875],[470.91009521484375,400.5364990234375],[471.4548034667969,400.3768005371094],[471.9994812011719,400.21710205078125],[472.544189453125,400.0574035644531],[473.0888977050781,399.8977355957031],[473.6338195800781,399.73797607421875],[474.17852783203125,399.5782775878906],[474.7232360839844,399.4185791015625],[475.2679443359375,399.2588806152344],[475.8126220703125,399.0992126464844],[476.3573303222656,398.93951416015625],[476.90203857421875,398.7798156738281],[477.4467468261719,398.6201171875],[477.9916687011719,398.4603576660156],[478.536376953125,398.3006896972656],[479.0810852050781,398.1409912109375],[479.6257629394531,397.9812927246094],[480.17047119140625,397.82159423828125],[480.7151794433594,397.66192626953125],[481.2598876953125,397.5029602050781],[481.8050231933594,397.3439025878906],[482.34991455078125,397.1849060058594],[482.89483642578125,397.0259094238281],[483.4397277832031,396.8669128417969],[483.9846496582031,396.7079162597656],[484.529541015625,396.5489196777344],[485.074462890625,396.3899230957031],[485.6193542480469,396.2309265136719],[486.16448974609375,396.0718688964844],[486.70941162109375,395.9128723144531],[487.2543029785156,395.7538757324219],[487.7991943359375,395.5948791503906],[488.3441162109375,395.4358825683594],[488.8890075683594,395.2768859863281],[489.4339294433594,395.1178894042969],[489.97882080078125,394.9588928222656],[490.5239562988281,394.7998352050781],[491.0688781738281,394.6408386230469],[491.61376953125,394.4818420410156],[492.1589050292969,394.3229675292969],[492.70404052734375,394.1647644042969],[493.2491760253906,394.0065612792969],[493.7943115234375,393.84832763671875],[494.3394470214844,393.69012451171875],[494.8847961425781,393.5318298339844],[495.429931640625,393.3736267089844],[495.9750671386719,393.2154235839844],[496.52020263671875,393.05718994140625],[497.0653381347656,392.89898681640625],[497.6104736328125,392.74078369140625],[498.15570068359375,392.5831604003906],[498.7012634277344,392.4255676269531],[499.24658203125,392.2680358886719],[499.79193115234375,392.1105041503906],[500.3372497558594,391.9530029296875],[500.882568359375,391.79547119140625],[501.42791748046875,391.637939453125],[501.9732360839844,391.48040771484375],[502.5185852050781,391.3228759765625],[503.06414794921875,391.165283203125],[503.60955810546875,391.0081787109375],[504.1551208496094,390.8514404296875],[504.70068359375,390.6947326660156],[505.2462463378906,390.53802490234375],[505.79180908203125,390.3813171386719],[506.3373718261719,390.2245788574219],[506.8829345703125,390.06787109375],[507.4287414550781,389.9111022949219],[507.97430419921875,389.75439453125],[508.5198669433594,389.59765625],[509.0653991699219,389.4410705566406],[509.6112365722656,389.2852783203125],[510.1570739746094,389.1295166015625],[510.7029113769531,388.9737548828125],[511.24896240234375,388.8179016113281],[511.7947998046875,388.6621398925781],[512.3406372070312,388.50634765625],[512.886474609375,388.3505859375],[513.4323120117188,388.19482421875],[513.9781494140625,388.0390319824219],[514.5239868164062,387.8832702636719],[515.0701904296875,387.72821044921875],[515.6165771484375,387.5734558105469],[516.1627197265625,387.4187316894531],[516.7088623046875,387.2640075683594],[517.2550048828125,387.10931396484375],[517.8011474609375,386.95458984375],[518.3472900390625,386.7998962402344],[518.8933715820312,386.6451721191406],[519.4395141601562,386.490478515625],[519.9859008789062,386.335693359375],[520.5321044921875,386.1814270019531],[521.07861328125,386.02789306640625],[521.6250610351562,385.8743896484375],[522.1715087890625,385.7208557128906],[522.718017578125,385.56732177734375],[523.2644653320312,385.413818359375],[523.8109741210938,385.2602844238281],[524.357666015625,385.106689453125],[524.9041137695312,384.9531555175781],[525.4506225585938,384.7996520996094]],
	bounds=3000,
	full_zoom=0.22,
	max_episode_steps=2000
)

Mexico = RaceTrack(
	name='Mexico',
	xy=[[485.53179931640625,439.3223876953125],[485.1310119628906,439.31634521484375],[484.730224609375,439.3103332519531],[484.3294372558594,439.3042907714844],[483.92864990234375,439.2982482910156],[483.52789306640625,439.2922058105469],[483.1270751953125,439.28619384765625],[482.726318359375,439.2801513671875],[482.3255310058594,439.27410888671875],[481.92474365234375,439.2680969238281],[481.5239562988281,439.2620544433594],[481.1231689453125,439.2560119628906],[480.7223815917969,439.2499694824219],[480.32159423828125,439.24395751953125],[479.9208068847656,439.2379150390625],[479.52001953125,439.23187255859375],[479.1192321777344,439.225830078125],[478.71844482421875,439.2198181152344],[478.31768798828125,439.2137756347656],[477.9168701171875,439.2077331542969],[477.51611328125,439.20172119140625],[477.11529541015625,439.1956787109375],[476.71453857421875,439.18963623046875],[476.3137512207031,439.18359375],[475.9129638671875,439.1775817871094],[475.5121765136719,439.1715393066406],[475.11138916015625,439.1654968261719],[474.7106018066406,439.15948486328125],[474.309814453125,439.1534423828125],[473.9090270996094,439.14739990234375],[473.50823974609375,439.141357421875],[473.10748291015625,439.1353454589844],[472.7066650390625,439.1293029785156],[472.305908203125,439.1232604980469],[471.90509033203125,439.11724853515625],[471.50433349609375,439.1112060546875],[471.1035461425781,439.10516357421875],[470.7027587890625,439.09912109375],[470.3019714355469,439.0931091308594],[469.90118408203125,439.0870666503906],[469.5003967285156,439.0810241699219],[469.099609375,439.0749816894531],[468.6988220214844,439.0689697265625],[468.29803466796875,439.06292724609375],[467.8972473144531,439.056884765625],[467.4964599609375,439.0508728027344],[467.0956726074219,439.0448303222656],[466.69488525390625,439.0387878417969],[466.29412841796875,439.0327453613281],[465.8933410644531,439.0267333984375],[465.4925537109375,439.02069091796875],[465.0917663574219,439.0146484375],[464.69097900390625,439.0086364746094],[464.2901916503906,439.0025939941406],[463.889404296875,438.9965515136719],[463.4886169433594,438.9905090332031],[463.08782958984375,438.9844970703125],[462.6870422363281,438.97845458984375],[462.2862548828125,438.972412109375],[461.885498046875,438.9664001464844],[461.48468017578125,438.9603576660156],[461.08392333984375,438.9543151855469],[460.68310546875,438.9482727050781],[460.2823486328125,438.9422607421875],[459.8815612792969,438.93621826171875],[459.48077392578125,438.93017578125],[459.0799865722656,438.92413330078125],[458.67919921875,438.9181213378906],[458.2784118652344,438.9120788574219],[457.87762451171875,438.9060363769531],[457.4768371582031,438.9000244140625],[457.0760498046875,438.89398193359375],[456.67529296875,438.887939453125],[456.27447509765625,438.88189697265625],[455.87371826171875,438.8758850097656],[455.472900390625,438.8698425292969],[455.0721435546875,438.8638000488281],[454.6713562011719,438.8577880859375],[454.27056884765625,438.85174560546875],[453.8697814941406,438.845703125],[453.468994140625,438.83966064453125],[453.0682067871094,438.8336486816406],[452.66741943359375,438.8276062011719],[452.2666320800781,438.8215637207031],[451.8658447265625,438.8155517578125],[451.4650573730469,438.80950927734375],[451.06427001953125,438.803466796875],[450.6634826660156,438.79742431640625],[450.2626953125,438.7914123535156],[449.8619384765625,438.7853698730469],[449.4611511230469,438.7793273925781],[449.06036376953125,438.7732849121094],[448.6595764160156,438.76727294921875],[448.2587890625,438.76123046875],[447.8580017089844,438.75518798828125],[447.45721435546875,438.7491760253906],[447.0564270019531,438.7431335449219],[446.6556396484375,438.7370910644531],[446.2548522949219,438.7310485839844],[445.85406494140625,438.72503662109375],[445.45330810546875,438.718994140625],[445.0525207519531,438.71295166015625],[444.6517333984375,438.7069396972656],[444.2509460449219,438.7008972167969],[443.85015869140625,438.6948547363281],[443.4493408203125,438.6888122558594],[443.048583984375,438.68280029296875],[442.6477966308594,438.6767578125],[442.24700927734375,438.67071533203125],[441.8462219238281,438.6647033691406],[441.4454345703125,438.6586608886719],[441.0446472167969,438.6526184082031],[440.64385986328125,438.6465759277344],[440.2430725097656,438.64056396484375],[439.84228515625,438.634521484375],[439.4415283203125,438.62847900390625],[439.0407409667969,438.6224365234375],[438.63995361328125,438.6164245605469],[438.2391662597656,438.6103820800781],[437.83837890625,438.6043395996094],[437.4375915527344,438.59832763671875],[437.03680419921875,438.59228515625],[436.6360168457031,438.58624267578125],[436.2352294921875,438.5802001953125],[435.8344421386719,438.5741882324219],[435.43365478515625,438.5681457519531],[435.0328674316406,438.5621032714844],[434.632080078125,438.55609130859375],[434.2313232421875,438.550048828125],[433.8305358886719,438.54400634765625],[433.42974853515625,438.5379638671875],[433.0289611816406,438.5319519042969],[432.628173828125,438.5259094238281],[432.2273864746094,438.5198669433594],[431.82659912109375,438.51385498046875],[431.4258117675781,438.5078125],[431.0250244140625,438.50177001953125],[430.6242370605469,438.4957275390625],[430.22344970703125,438.4897155761719],[429.8226623535156,438.4836730957031],[429.421875,438.4776306152344],[429.0210876464844,438.47161865234375],[428.62030029296875,438.465576171875],[428.21954345703125,438.45953369140625],[427.8187561035156,438.4534912109375],[427.41796875,438.4474792480469],[427.0171813964844,438.4414367675781],[426.61639404296875,438.4353942871094],[426.2156066894531,438.4293518066406],[425.8148193359375,438.42333984375],[425.4140319824219,438.41729736328125],[425.01324462890625,438.4112548828125],[424.6124572753906,438.4052429199219],[424.211669921875,438.3992004394531],[423.8108825683594,438.3931579589844],[423.41009521484375,438.3871154785156],[423.00933837890625,438.381103515625],[422.6085510253906,438.37506103515625],[422.207763671875,438.3690185546875],[421.8069763183594,438.3630065917969],[421.40618896484375,438.3569641113281],[421.0054016113281,438.3509216308594],[420.6046142578125,438.3448791503906],[420.2038269042969,438.3388671875],[419.80303955078125,438.33282470703125],[419.4022521972656,438.3267822265625],[419.00146484375,438.3207702636719],[418.6006774902344,438.3147277832031],[418.19989013671875,438.3086853027344],[417.7991027832031,438.3026428222656],[417.3983459472656,438.296630859375],[416.99755859375,438.29058837890625],[416.5967712402344,438.2845458984375],[416.19598388671875,438.27850341796875],[415.7951965332031,438.2724914550781],[415.3944091796875,438.2664489746094],[414.9936218261719,438.2604064941406],[414.59283447265625,438.25439453125],[414.1920471191406,438.24835205078125],[413.791259765625,438.2423095703125],[413.3904724121094,438.23626708984375],[412.98968505859375,438.2302551269531],[412.58892822265625,438.2242126464844],[412.1881103515625,438.2181701660156],[411.7873229980469,438.212158203125],[411.3865661621094,438.20611572265625],[410.98577880859375,438.2000732421875],[410.5849914550781,438.19403076171875],[410.1842041015625,438.1880187988281],[409.7834167480469,438.1819763183594],[409.38262939453125,438.1759338378906],[408.9818420410156,438.169921875],[408.5810546875,438.16387939453125],[408.1802673339844,438.1578369140625],[407.77947998046875,438.15179443359375],[407.3786926269531,438.1457824707031],[406.9779052734375,438.1397399902344],[406.5771484375,438.1336975097656],[406.17633056640625,438.1276550292969],[405.77557373046875,438.12164306640625],[405.3747863769531,438.1156005859375],[404.9739990234375,438.10955810546875],[404.5732116699219,438.1035461425781],[404.17242431640625,438.0975036621094],[403.7716369628906,438.0914611816406],[403.370849609375,438.0854187011719],[402.9700622558594,438.07940673828125],[402.56927490234375,438.0733642578125],[402.1684875488281,438.06732177734375],[401.7677001953125,438.0613098144531],[401.3669128417969,438.0552673339844],[400.9661560058594,438.0492248535156],[400.56536865234375,438.0431823730469],[400.1645812988281,438.03717041015625],[399.7637939453125,438.0311279296875],[399.3630065917969,438.02508544921875],[398.96221923828125,438.0190734863281],[398.5614318847656,438.0130310058594],[398.16064453125,438.0069885253906],[397.7598571777344,438.0009460449219],[397.35906982421875,437.99493408203125],[396.9582824707031,437.9888916015625],[396.5574951171875,437.98284912109375],[396.15673828125,437.976806640625],[395.75592041015625,437.9707946777344],[395.3551330566406,437.9647521972656],[394.9543762207031,437.9587097167969],[394.5535888671875,437.95269775390625],[394.1528015136719,437.9466552734375],[393.75201416015625,437.94061279296875],[393.3512268066406,437.9345703125],[392.950439453125,437.9285583496094],[392.5496520996094,437.9225158691406],[392.14886474609375,437.9164733886719],[391.7480773925781,437.91046142578125],[391.3472900390625,437.9044189453125],[390.9465026855469,437.89837646484375],[390.54571533203125,437.892333984375],[390.14495849609375,437.8863220214844],[389.7441711425781,437.8802795410156],[389.3433837890625,437.8742370605469],[388.9425964355469,437.86822509765625],[388.54180908203125,437.8621826171875],[388.1410217285156,437.85614013671875],[387.740234375,437.85009765625],[387.3394470214844,437.8440856933594],[386.93865966796875,437.8380432128906],[386.5378723144531,437.8320007324219],[386.1370849609375,437.8259582519531],[385.7362976074219,437.8199462890625],[385.33551025390625,437.81390380859375],[384.9347229003906,437.807861328125],[384.533935546875,437.8018493652344],[384.1331787109375,437.7958068847656],[383.7323913574219,437.7897644042969],[383.33160400390625,437.7837219238281],[382.9308166503906,437.7777099609375],[382.530029296875,437.77166748046875],[382.1292419433594,437.765625],[381.72845458984375,437.7596130371094],[381.3276672363281,437.7535705566406],[380.9268798828125,437.7475280761719],[380.5260925292969,437.7414855957031],[380.12530517578125,437.7354736328125],[379.7245178222656,437.72943115234375],[379.32373046875,437.723388671875],[378.9229431152344,437.7173767089844],[378.5221862792969,437.7113037109375],[378.12139892578125,437.70513916015625],[377.7206115722656,437.6989440917969],[377.31982421875,437.6927490234375],[376.9190368652344,437.68658447265625],[376.51824951171875,437.6803894042969],[376.11749267578125,437.6742248535156],[375.7167053222656,437.66802978515625],[375.31591796875,437.6618347167969],[374.9151306152344,437.6556701660156],[374.51434326171875,437.64947509765625],[374.1135559082031,437.643310546875],[373.7127685546875,437.6371154785156],[373.3119812011719,437.63092041015625],[372.91119384765625,437.624755859375],[372.51043701171875,437.6185607910156],[372.1096496582031,437.6123962402344],[371.7088623046875,437.606201171875],[371.3080749511719,437.6000061035156],[370.90728759765625,437.5938415527344],[370.5065002441406,437.587646484375],[370.1057434082031,437.58148193359375],[369.7049560546875,437.5752868652344],[369.3041687011719,437.569091796875],[368.90338134765625,437.56292724609375],[368.5025939941406,437.5567321777344],[368.101806640625,437.5505676269531],[367.7010498046875,437.54437255859375],[367.3002624511719,437.5381774902344],[366.89947509765625,437.5320129394531],[366.4986877441406,437.52581787109375],[366.097900390625,437.5196533203125],[365.6971130371094,437.5134582519531],[365.29632568359375,437.50726318359375],[364.8955383300781,437.5010986328125],[364.4947814941406,437.4949035644531],[364.093994140625,437.4887390136719],[363.6932067871094,437.4825439453125],[363.29241943359375,437.4763488769531],[362.8916320800781,437.4701843261719],[362.4908447265625,437.4639892578125],[362.0900573730469,437.45782470703125],[361.6893005371094,437.4516296386719],[361.28851318359375,437.4454345703125],[360.8877258300781,437.43927001953125],[360.4869384765625,437.4330749511719],[360.0861511230469,437.4269104003906],[359.6853942871094,437.42071533203125],[359.28460693359375,437.4145202636719],[358.8838195800781,437.4083557128906],[358.4830322265625,437.40216064453125],[358.0822448730469,437.39599609375],[357.68145751953125,437.3898010253906],[357.2806701660156,437.38360595703125],[356.8798828125,437.37744140625],[356.4791259765625,437.3712463378906],[356.0783386230469,437.3650817871094],[355.67755126953125,437.35888671875],[355.2767639160156,437.3526916503906],[354.8759765625,437.3465270996094],[354.4751892089844,437.34033203125],[354.0744323730469,437.33416748046875],[353.67364501953125,437.3279724121094],[353.2728576660156,437.32177734375],[352.8720703125,437.31561279296875],[352.4712829589844,437.3094177246094],[352.07049560546875,437.30322265625],[351.6697082519531,437.2969665527344],[351.2689514160156,437.2906188964844],[350.8681640625,437.2843017578125],[350.4673767089844,437.2779846191406],[350.06658935546875,437.27166748046875],[349.6658020019531,437.26531982421875],[349.2650451660156,437.2590026855469],[348.8642578125,437.252685546875],[348.4634704589844,437.246337890625],[348.06268310546875,437.2400207519531],[347.6618957519531,437.23370361328125],[347.2611389160156,437.22735595703125],[346.8603515625,437.2210388183594],[346.4595642089844,437.2147216796875],[346.05877685546875,437.2083740234375],[345.65802001953125,437.2020568847656],[345.2572326660156,437.19573974609375],[344.8564453125,437.1894226074219],[344.4556579589844,437.1830749511719],[344.0549011230469,437.1767578125],[343.65411376953125,437.1704406738281],[343.2533264160156,437.1640930175781],[342.8525390625,437.15777587890625],[342.4517822265625,437.1514587402344],[342.0509948730469,437.1451110839844],[341.65020751953125,437.1387939453125],[341.2494201660156,437.1324768066406],[340.8486328125,437.1261291503906],[340.4478454589844,437.11981201171875],[340.0470886230469,437.1134948730469],[339.64630126953125,437.107177734375],[339.2455139160156,437.100830078125],[338.8447265625,437.0945129394531],[338.4439392089844,437.08819580078125],[338.0431823730469,437.08184814453125],[337.64239501953125,437.0755310058594],[337.2416076660156,437.0692138671875],[336.8408203125,437.0628662109375],[336.4400634765625,437.0565490722656],[336.0392761230469,437.05023193359375],[335.63848876953125,437.04388427734375],[335.23773193359375,437.0375671386719],[334.8369445800781,437.03125],[334.4361572265625,437.0249328613281],[334.0353698730469,437.0185852050781],[333.63458251953125,437.01226806640625],[333.2337951660156,437.0059509277344],[332.8330383300781,436.9996032714844],[332.4322509765625,436.9932861328125],[332.0314636230469,436.9869689941406],[331.63067626953125,436.9806213378906],[331.2298889160156,436.97430419921875],[330.8291320800781,436.9679870605469],[330.4283447265625,436.9616394042969],[330.0275573730469,436.955322265625],[329.62677001953125,436.9490051269531],[329.22601318359375,436.94268798828125],[328.8252258300781,436.93634033203125],[328.4244384765625,436.9300231933594],[328.0236511230469,436.9237060546875],[327.6228942871094,436.9173583984375],[327.22210693359375,436.9110412597656],[326.8213195800781,436.90472412109375],[326.4205322265625,436.89837646484375],[326.019775390625,436.8920593261719],[325.6189880371094,436.8857421875],[325.21820068359375,436.8793640136719],[324.8174133300781,436.87286376953125],[324.4166259765625,436.8663330078125],[324.015869140625,436.8598327636719],[323.6150817871094,436.85333251953125],[323.2143249511719,436.8468017578125],[322.81353759765625,436.8403015136719],[322.4127502441406,436.83380126953125],[322.011962890625,436.8272705078125],[321.6112060546875,436.8207702636719],[321.2104187011719,436.8142395019531],[320.8096618652344,436.8077392578125],[320.40887451171875,436.8012390136719],[320.0080871582031,436.7947082519531],[319.6072998046875,436.7882080078125],[319.20654296875,436.7817077636719],[318.8057556152344,436.7751770019531],[318.40496826171875,436.7686767578125],[318.00421142578125,436.7621765136719],[317.6034240722656,436.7556457519531],[317.20263671875,436.7491455078125],[316.8018493652344,436.7426452636719],[316.4010925292969,436.7361145019531],[316.00030517578125,436.7296142578125],[315.59954833984375,436.7231140136719],[315.1987609863281,436.7165832519531],[314.7979736328125,436.7100830078125],[314.3971862792969,436.7035827636719],[313.9964294433594,436.6970520019531],[313.59564208984375,436.6905517578125],[313.1948547363281,436.6840515136719],[312.7940979003906,436.6775207519531],[312.393310546875,436.6710205078125],[311.9925231933594,436.66448974609375],[311.5917663574219,436.6579895019531],[311.19097900390625,436.6514892578125],[310.7901916503906,436.64495849609375],[310.3894348144531,436.6384582519531],[309.9886474609375,436.6319580078125],[309.5878601074219,436.62542724609375],[309.1871032714844,436.6189270019531],[308.78631591796875,436.6124267578125],[308.3855285644531,436.60589599609375],[307.9847412109375,436.5993957519531],[307.583984375,436.5928955078125],[307.1831970214844,436.58636474609375],[306.7824401855469,436.5798645019531],[306.38165283203125,436.5733642578125],[305.9808654785156,436.56683349609375],[305.580078125,436.5603332519531],[305.1793212890625,436.5538330078125],[304.7785339355469,436.54730224609375],[304.3777770996094,436.5408020019531],[303.97698974609375,436.5343017578125],[303.5762023925781,436.52777099609375],[303.1754150390625,436.5212707519531],[302.774658203125,436.5147399902344],[302.3738708496094,436.50823974609375],[301.97308349609375,436.5017395019531],[301.57232666015625,436.4952087402344],[301.1715393066406,436.48870849609375],[300.770751953125,436.4822082519531],[300.3699645996094,436.4756774902344],[299.9692077636719,436.46917724609375],[299.56842041015625,436.4626770019531],[299.16766357421875,436.4561462402344],[298.7668762207031,436.44964599609375],[298.3660888671875,436.44293212890625],[297.9653015136719,436.4361877441406],[297.5645446777344,436.429443359375],[297.1637878417969,436.4227294921875],[296.76300048828125,436.4159851074219],[296.3622131347656,436.40924072265625],[295.9614562988281,436.4024963378906],[295.5606689453125,436.3957824707031],[295.159912109375,436.3890380859375],[294.7591247558594,436.3822937011719],[294.3583679199219,436.37554931640625],[293.95758056640625,436.36883544921875],[293.5567932128906,436.3620910644531],[293.1560363769531,436.3553466796875],[292.7552795410156,436.3486022949219],[292.3544921875,436.34185791015625],[291.9537048339844,436.33514404296875],[291.5529479980469,436.3283996582031],[291.15216064453125,436.3216552734375],[290.7513732910156,436.3149108886719],[290.3506164550781,436.3081970214844],[289.9498596191406,436.30145263671875],[289.549072265625,436.2947082519531],[289.1482849121094,436.2879638671875],[288.7475280761719,436.28125],[288.34674072265625,436.2745056152344],[287.94598388671875,436.26776123046875],[287.5451965332031,436.2610168457031],[287.1444396972656,436.2543029785156],[286.74365234375,436.24755859375],[286.3428649902344,436.2408142089844],[285.9421081542969,436.23406982421875],[285.54132080078125,436.22735595703125],[285.14056396484375,436.2206115722656],[284.7397766113281,436.2138671875],[284.3390197753906,436.2071228027344],[283.938232421875,436.20037841796875],[283.5374450683594,436.19366455078125],[283.1366882324219,436.1869201660156],[282.73590087890625,436.18017578125],[282.33514404296875,436.1734313964844],[281.9343566894531,436.1667175292969],[281.5335998535156,436.15997314453125],[281.1328125,436.1532287597656],[280.7320556640625,436.146484375],[280.3312683105469,436.1397705078125],[279.93048095703125,436.1330261230469],[279.52972412109375,436.12628173828125],[279.1289367675781,436.1195373535156],[278.7281799316406,436.1128234863281],[278.327392578125,436.1060791015625],[277.9266357421875,436.0993347167969],[277.5258483886719,436.09259033203125],[277.12506103515625,436.08587646484375],[276.72430419921875,436.0791320800781],[276.32354736328125,436.0723876953125],[275.9227600097656,436.0656433105469],[275.52197265625,436.05889892578125],[275.1212158203125,436.05218505859375],[274.7204284667969,436.0454406738281],[274.31964111328125,436.0386962890625],[273.91888427734375,436.0319519042969],[273.51812744140625,436.0252380371094],[273.1173400878906,436.01849365234375],[272.716552734375,436.0117492675781],[272.3157958984375,436.0050048828125],[271.9150085449219,435.9981384277344],[271.5142517089844,435.9911193847656],[271.1134948730469,435.984130859375],[270.71270751953125,435.97711181640625],[270.31195068359375,435.9700927734375],[269.9111633300781,435.9631042480469],[269.5104064941406,435.9560852050781],[269.1096496582031,435.9490966796875],[268.7088623046875,435.94207763671875],[268.30810546875,435.9350891113281],[267.9073181152344,435.9280700683594],[267.5065612792969,435.92108154296875],[267.10577392578125,435.9140625],[266.70501708984375,435.90704345703125],[266.30426025390625,435.9000549316406],[265.9034729003906,435.8930358886719],[265.5027160644531,435.88604736328125],[265.1019287109375,435.8790283203125],[264.701171875,435.8720397949219],[264.3004150390625,435.8650207519531],[263.8996276855469,435.8580322265625],[263.4988708496094,435.85101318359375],[263.09808349609375,435.8440246582031],[262.69732666015625,435.8370056152344],[262.2965393066406,435.8299865722656],[261.8957824707031,435.822998046875],[261.4950256347656,435.81597900390625],[261.09423828125,435.8089904785156],[260.6934814453125,435.8019714355469],[260.2926940917969,435.79498291015625],[259.8919372558594,435.7879638671875],[259.4911804199219,435.7809753417969],[259.09039306640625,435.7739562988281],[258.68963623046875,435.7669372558594],[258.2888488769531,435.75994873046875],[257.8880920410156,435.7529296875],[257.4873352050781,435.7459411621094],[257.0865478515625,435.7389221191406],[256.685791015625,435.73193359375],[256.2850036621094,435.72491455078125],[255.88424682617188,435.7179260253906],[255.4834747314453,435.7109069824219],[255.0827178955078,435.70391845703125],[254.68194580078125,435.6968994140625],[254.2811737060547,435.68988037109375],[253.88040161132812,435.6828918457031],[253.47962951660156,435.6758728027344],[253.078857421875,435.66888427734375],[252.6781005859375,435.661865234375],[252.27732849121094,435.6548767089844],[251.87655639648438,435.6478576660156],[251.4757843017578,435.640869140625],[251.07501220703125,435.63385009765625],[250.6742401123047,435.6268310546875],[250.2734832763672,435.6198425292969],[249.87271118164062,435.6128234863281],[249.47193908691406,435.6058349609375],[249.0711669921875,435.59881591796875],[248.67039489746094,435.5918273925781],[248.26962280273438,435.5848083496094],[247.86886596679688,435.57781982421875],[247.4680938720703,435.57080078125],[247.06732177734375,435.5638122558594],[246.6665496826172,435.5567932128906],[246.26577758789062,435.5497741699219],[245.86500549316406,435.54278564453125],[245.46426391601562,435.53570556640625],[245.06349182128906,435.52838134765625],[244.6627197265625,435.5210876464844],[244.261962890625,435.5137634277344],[243.86119079589844,435.5064392089844],[243.46043395996094,435.4991149902344],[243.05967712402344,435.4918212890625],[242.65890502929688,435.4844970703125],[242.25814819335938,435.4771728515625],[241.8573760986328,435.4698791503906],[241.45660400390625,435.4625549316406],[241.05584716796875,435.4552307128906],[240.65509033203125,435.44793701171875],[240.25433349609375,435.44061279296875],[239.8535614013672,435.43328857421875],[239.45278930664062,435.4259948730469],[239.05203247070312,435.4186706542969],[238.65126037597656,435.4113464355469],[238.25051879882812,435.404052734375],[237.84974670410156,435.396728515625],[237.448974609375,435.389404296875],[237.0482177734375,435.3821105957031],[236.64744567871094,435.3747863769531],[236.24667358398438,435.3674621582031],[235.84593200683594,435.3601379394531],[235.44515991210938,435.35284423828125],[235.04440307617188,435.34552001953125],[234.6436309814453,435.33819580078125],[234.24285888671875,435.3309020996094],[233.8421173095703,435.3235778808594],[233.44134521484375,435.3162536621094],[233.0405731201172,435.3089599609375],[232.6398162841797,435.3016357421875],[232.23904418945312,435.2943115234375],[231.83828735351562,435.2870178222656],[231.43753051757812,435.2796936035156],[231.03675842285156,435.2723693847656],[230.63600158691406,435.26507568359375],[230.2352294921875,435.25775146484375],[229.83445739746094,435.25042724609375],[229.4337158203125,435.24310302734375],[229.03292846679688,435.2358093261719],[228.63217163085938,435.2284851074219],[228.2313995361328,435.2211608886719],[227.8306427001953,435.2138671875],[227.42990112304688,435.20654296875],[227.02911376953125,435.19921875],[226.62835693359375,435.1919250488281],[226.2275848388672,435.1846008300781],[225.8268280029297,435.1772766113281],[225.42608642578125,435.16998291015625],[225.02529907226562,435.16265869140625],[224.62454223632812,435.15533447265625],[224.22377014160156,435.1480407714844],[223.82301330566406,435.1407165527344],[223.42222595214844,435.1333923339844],[223.021484375,435.1260986328125],[222.6207275390625,435.1187744140625],[222.21994018554688,435.1114501953125],[221.81919860839844,435.1041259765625],[221.4184112548828,435.0968322753906],[221.01766967773438,435.0895080566406],[220.61691284179688,435.0821838378906],[220.21612548828125,435.07489013671875],[219.8153839111328,435.06756591796875],[219.4145965576172,435.06024169921875],[219.0138397216797,435.0529479980469],[218.61306762695312,435.0453186035156],[218.2123260498047,435.03765869140625],[217.81158447265625,435.02996826171875],[217.4108123779297,435.0223083496094],[217.01007080078125,435.0146484375],[216.60928344726562,435.0069885253906],[216.2085418701172,434.99932861328125],[215.80780029296875,434.9916687011719],[215.4070281982422,434.9839782714844],[215.00628662109375,434.976318359375],[214.60549926757812,434.9686584472656],[214.2047576904297,434.96099853515625],[213.80398559570312,434.9533386230469],[213.4032440185547,434.9456787109375],[213.00250244140625,434.93798828125],[212.60171508789062,434.9303283691406],[212.2009735107422,434.92266845703125],[211.80020141601562,434.9150085449219],[211.3994598388672,434.9073486328125],[210.99871826171875,434.8996887207031],[210.59793090820312,434.89202880859375],[210.1971893310547,434.88433837890625],[209.79641723632812,434.8766784667969],[209.3956756591797,434.8690185546875],[208.99493408203125,434.8613586425781],[208.59414672851562,434.85369873046875],[208.1934051513672,434.8460388183594],[207.79263305664062,434.8383483886719],[207.3918914794922,434.8306884765625],[206.99111938476562,434.8230285644531],[206.59036254882812,434.81536865234375],[206.1896209716797,434.8077087402344],[205.78884887695312,434.800048828125],[205.3881072998047,434.7923583984375],[204.98733520507812,434.7846984863281],[204.58657836914062,434.77703857421875],[204.1858367919922,434.7693786621094],[203.78506469726562,434.76171875],[203.3843231201172,434.7540588378906],[202.98355102539062,434.7463684082031],[202.58279418945312,434.73870849609375],[202.18202209472656,434.7310485839844],[201.78128051757812,434.723388671875],[201.3805389404297,434.7157287597656],[200.97976684570312,434.70806884765625],[200.57901000976562,434.7004089355469],[200.17823791503906,434.6927185058594],[199.77749633789062,434.68505859375],[199.3767547607422,434.6773986816406],[198.97598266601562,434.66973876953125],[198.5752410888672,434.6620788574219],[198.17445373535156,434.6544189453125],[197.77371215820312,434.646728515625],[197.37294006347656,434.6390686035156],[196.97219848632812,434.63140869140625],[196.5714569091797,434.6237487792969],[196.17066955566406,434.6160888671875],[195.76992797851562,434.6084289550781],[195.36915588378906,434.6007385253906],[194.96841430664062,434.59307861328125],[194.5676727294922,434.5854187011719],[194.16688537597656,434.5777587890625],[193.76614379882812,434.5700988769531],[193.36537170410156,434.56243896484375],[192.96463012695312,434.55474853515625],[192.56385803222656,434.5470886230469],[192.16310119628906,434.53924560546875],[191.76235961914062,434.53118896484375],[191.36160278320312,434.52313232421875],[190.9608612060547,434.51507568359375],[190.56008911132812,434.50701904296875],[190.15936279296875,434.49896240234375],[189.7586212158203,434.49090576171875],[189.35784912109375,434.48284912109375],[188.95712280273438,434.47479248046875],[188.5563507080078,434.46673583984375],[188.15560913085938,434.45867919921875],[187.7548828125,434.45062255859375],[187.35411071777344,434.44256591796875],[186.953369140625,434.43450927734375],[186.5526123046875,434.42645263671875],[186.15187072753906,434.41839599609375],[185.7510986328125,434.41033935546875],[185.35035705566406,434.40228271484375],[184.9496307373047,434.39422607421875],[184.54885864257812,434.38616943359375],[184.1481170654297,434.3781433105469],[183.7473602294922,434.3700866699219],[183.34661865234375,434.3620300292969],[182.9458770751953,434.3539733886719],[182.54510498046875,434.3459167480469],[182.14437866210938,434.3378601074219],[181.7436065673828,434.3298034667969],[181.34286499023438,434.3217468261719],[180.94210815429688,434.3136901855469],[180.54136657714844,434.3056335449219],[180.140625,434.2975769042969],[179.7398681640625,434.2895202636719],[179.33912658691406,434.2814636230469],[178.9383544921875,434.2734069824219],[178.53762817382812,434.2653503417969],[178.1368865966797,434.2572937011719],[177.73611450195312,434.2492370605469],[177.33538818359375,434.2411804199219],[176.9346160888672,434.2331237792969],[176.53387451171875,434.2250671386719],[176.1331024169922,434.2170104980469],[175.7323760986328,434.2089538574219],[175.33163452148438,434.2008972167969],[174.9308624267578,434.1928405761719],[174.53013610839844,434.1847839355469],[174.12936401367188,434.1767272949219],[173.72862243652344,434.1686706542969],[173.32789611816406,434.1606140136719],[172.9271240234375,434.1525573730469],[172.52638244628906,434.14453125],[172.1256103515625,434.136474609375],[171.72488403320312,434.12841796875],[171.32411193847656,434.120361328125],[170.92337036132812,434.1123046875],[170.52264404296875,434.104248046875],[170.1218719482422,434.09619140625],[169.72113037109375,434.088134765625],[169.32037353515625,434.080078125],[168.9196319580078,434.072021484375],[168.51889038085938,434.06396484375],[168.11813354492188,434.055908203125],[167.71739196777344,434.0478515625],[167.31661987304688,434.039794921875],[166.91587829589844,434.03173828125],[166.51515197753906,434.023681640625],[166.1143798828125,434.015625],[165.71365356445312,434.0075378417969],[165.31289672851562,433.9991760253906],[164.9121551513672,433.9908142089844],[164.5113983154297,433.982421875],[164.1106719970703,433.97406005859375],[163.70993041992188,433.9656677246094],[163.30917358398438,433.9573059082031],[162.908447265625,433.94891357421875],[162.5076904296875,433.9405517578125],[162.10694885253906,433.93218994140625],[161.7062225341797,433.9237976074219],[161.3054656982422,433.9154357910156],[160.9047393798828,433.90704345703125],[160.50396728515625,433.898681640625],[160.10324096679688,433.89031982421875],[159.70248413085938,433.8819274902344],[159.3017578125,433.8735656738281],[158.90101623535156,433.86517333984375],[158.50025939941406,433.8568115234375],[158.0995330810547,433.8484191894531],[157.69876098632812,433.8400573730469],[157.29803466796875,433.8316955566406],[156.89730834960938,433.82330322265625],[156.49655151367188,433.81494140625],[156.09580993652344,433.8065490722656],[155.69505310058594,433.7981872558594],[155.29432678222656,433.7898254394531],[154.89356994628906,433.78143310546875],[154.49282836914062,433.7730712890625],[154.09210205078125,433.7646789550781],[153.69134521484375,433.7563171386719],[153.2906036376953,433.7479248046875],[152.8898468017578,433.73956298828125],[152.48912048339844,433.731201171875],[152.08840942382812,433.7226257324219],[151.68765258789062,433.7140197753906],[151.28692626953125,433.7054443359375],[150.88616943359375,433.69683837890625],[150.48544311523438,433.688232421875],[150.08468627929688,433.67962646484375],[149.6839599609375,433.6710205078125],[149.28323364257812,433.6624450683594],[148.88247680664062,433.6538391113281],[148.48175048828125,433.6452331542969],[148.08099365234375,433.6366271972656],[147.68026733398438,433.6280212402344],[147.279541015625,433.61944580078125],[146.8787841796875,433.61083984375],[146.47805786132812,433.60223388671875],[146.07730102539062,433.5936279296875],[145.6765899658203,433.58502197265625],[145.2758331298828,433.5764465332031],[144.87510681152344,433.5678405761719],[144.47438049316406,433.5592346191406],[144.07362365722656,433.5506286621094],[143.6728973388672,433.5420227050781],[143.2721405029297,433.533447265625],[142.8714141845703,433.52484130859375],[142.47068786621094,433.5162353515625],[142.06993103027344,433.50762939453125],[141.66920471191406,433.4990234375],[141.26844787597656,433.4904479980469],[140.8677215576172,433.4818420410156],[140.4669952392578,433.4732360839844],[140.0662384033203,433.4646301269531],[139.66551208496094,433.4560241699219],[139.26475524902344,433.44744873046875],[138.8640594482422,433.4386291503906],[138.4633026123047,433.4296875],[138.06259155273438,433.42071533203125],[137.661865234375,433.4117736816406],[137.26112365722656,433.4028015136719],[136.86041259765625,433.39385986328125],[136.45965576171875,433.3848876953125],[136.05894470214844,433.3759460449219],[135.65821838378906,433.3669738769531],[135.25747680664062,433.3580322265625],[134.85675048828125,433.34906005859375],[134.4560089111328,433.3401184082031],[134.0552978515625,433.3311462402344],[133.654541015625,433.32220458984375],[133.2538299560547,433.313232421875],[132.8531036376953,433.3042907714844],[132.45236206054688,433.2953186035156],[132.0516357421875,433.286376953125],[131.65089416503906,433.27740478515625],[131.2501678466797,433.2684631347656],[130.84945678710938,433.2594909667969],[130.44869995117188,433.25054931640625],[130.04798889160156,433.2415771484375],[129.64724731445312,433.2326354980469],[129.24652099609375,433.2236633300781],[128.8457794189453,433.2147216796875],[128.44505310058594,433.20574951171875],[128.04434204101562,433.1968078613281],[127.64359283447266,433.1878356933594],[127.24287414550781,433.17889404296875],[126.84212493896484,433.169921875],[126.44140625,433.1609802246094],[126.04068756103516,433.1520080566406],[125.63993835449219,433.14306640625],[125.23922729492188,433.13409423828125],[124.8384780883789,433.1251525878906],[124.43775939941406,433.1161804199219],[124.0370101928711,433.10723876953125],[123.63629150390625,433.0982666015625],[123.2355728149414,433.0893249511719],[122.83482360839844,433.0803527832031],[122.4341049194336,433.0714111328125],[122.03335571289062,433.06243896484375],[121.63264465332031,433.0534973144531],[121.23192596435547,433.0445251464844],[120.8311767578125,433.03558349609375],[120.43045806884766,433.026611328125],[120.02970886230469,433.0176696777344],[119.62899017333984,433.0086975097656],[119.228271484375,432.999755859375],[118.82752990722656,432.99078369140625],[118.42681121826172,432.9818420410156],[118.02606201171875,432.9728698730469],[117.6253433227539,432.96392822265625],[117.22459411621094,432.9549560546875],[116.8238754272461,432.9460144042969],[116.42315673828125,432.9370422363281],[116.02240753173828,432.9281005859375],[115.62168884277344,432.91912841796875],[115.220947265625,432.9101867675781],[114.82022857666016,432.9012145996094],[114.41950988769531,432.89227294921875],[114.01876068115234,432.88330078125],[113.6180419921875,432.8743591308594],[113.21729278564453,432.8653869628906],[112.81657409667969,432.8564453125],[112.41582489013672,432.84747314453125],[112.01510620117188,432.8381652832031],[111.6144027709961,432.8288269042969],[111.21366119384766,432.8194885253906],[110.81295013427734,432.8101501464844],[110.4122085571289,432.8008117675781],[110.01150512695312,432.7914733886719],[109.61079406738281,432.7821350097656],[109.21005249023438,432.7728271484375],[108.80934143066406,432.76348876953125],[108.40860748291016,432.754150390625],[108.00789642333984,432.74481201171875],[107.6071548461914,432.7354736328125],[107.2064437866211,432.72613525390625],[106.80574035644531,432.716796875],[106.40499877929688,432.70745849609375],[106.00428771972656,432.6981201171875],[105.60354614257812,432.68878173828125],[105.20284271240234,432.6794738769531],[104.80213165283203,432.6701354980469],[104.4013900756836,432.6607971191406],[104.00067901611328,432.6514587402344],[103.59994506835938,432.6421203613281],[103.19923400878906,432.6327819824219],[102.79849243164062,432.6234436035156],[102.39778137207031,432.6141052246094],[101.99707794189453,432.6047668457031],[101.5963363647461,432.5954284667969],[101.19562530517578,432.58612060546875],[100.79488372802734,432.5767822265625],[100.39418029785156,432.56744384765625],[99.99346923828125,432.55810546875],[99.59272766113281,432.54876708984375],[99.1920166015625,432.5394287109375],[98.79127502441406,432.5299377441406],[98.39057159423828,432.52032470703125],[97.9898681640625,432.5107421875],[97.58914184570312,432.5011291503906],[97.18843841552734,432.4915466308594],[96.78770446777344,432.48193359375],[96.38700103759766,432.47235107421875],[95.98626708984375,432.4627380371094],[95.58556365966797,432.4531555175781],[95.18486022949219,432.44354248046875],[94.78412628173828,432.4339294433594],[94.3834228515625,432.4243469238281],[93.9826889038086,432.41473388671875],[93.58198547363281,432.4051513671875],[93.18128204345703,432.3955383300781],[92.78054809570312,432.3859558105469],[92.37984466552734,432.3763427734375],[91.97911071777344,432.36676025390625],[91.57841491699219,432.3571472167969],[91.17768096923828,432.3475646972656],[90.7769775390625,432.33795166015625],[90.37627410888672,432.3283386230469],[89.97554016113281,432.3187561035156],[89.57483673095703,432.30914306640625],[89.17410278320312,432.299560546875],[88.77339935302734,432.2899475097656],[88.37269592285156,432.2803649902344],[87.97196197509766,432.270751953125],[87.57125854492188,432.26116943359375],[87.17052459716797,432.2515563964844],[86.76982116699219,432.2419738769531],[86.36908721923828,432.23236083984375],[85.96839141845703,432.2227478027344],[85.56768035888672,432.2131042480469],[85.16695404052734,432.2032165527344],[84.7662582397461,432.193359375],[84.36553192138672,432.1834716796875],[83.96483612060547,432.1736145019531],[83.56414031982422,432.1637268066406],[83.16341400146484,432.1538391113281],[82.7627182006836,432.14398193359375],[82.36199188232422,432.13409423828125],[81.96129608154297,432.1242370605469],[81.5605697631836,432.1143493652344],[81.15987396240234,432.1044921875],[80.7591781616211,432.0946044921875],[80.35844421386719,432.0847473144531],[79.95774841308594,432.0748596191406],[79.55702209472656,432.0649719238281],[79.15632629394531,432.05511474609375],[78.75563049316406,432.04522705078125],[78.35490417480469,432.0353698730469],[77.95420837402344,432.0254821777344],[77.55348205566406,432.015625],[77.15278625488281,432.0057373046875],[76.75205993652344,431.9958801269531],[76.35136413574219,431.9859924316406],[75.95066833496094,431.97613525390625],[75.54994201660156,431.96624755859375],[75.14924621582031,431.95635986328125],[74.74851989746094,431.9465026855469],[74.34782409667969,431.9366149902344],[73.94712829589844,431.9267578125],[73.54640197753906,431.9168701171875],[73.14569854736328,431.9070129394531],[72.7449722290039,431.8971252441406],[72.34427642822266,431.88726806640625],[71.94358825683594,431.87713623046875],[71.5428695678711,431.86700439453125],[71.14218139648438,431.8568420410156],[70.74146270751953,431.8466796875],[70.34077453613281,431.8365173339844],[69.94004821777344,431.82635498046875],[69.53936004638672,431.8161926269531],[69.138671875,431.8060607910156],[68.73795318603516,431.7958984375],[68.33726501464844,431.7857360839844],[67.9365463256836,431.77557373046875],[67.53585815429688,431.7654113769531],[67.13516235351562,431.7552795410156],[66.73444366455078,431.7451171875],[66.33375549316406,431.7349548339844],[65.93303680419922,431.72479248046875],[65.5323486328125,431.7146301269531],[65.13162994384766,431.7044982910156],[64.73094177246094,431.6943359375],[64.33024597167969,431.6841735839844],[63.92953109741211,431.67401123046875],[63.528839111328125,431.6638488769531],[63.12812042236328,431.6537170410156],[62.72743225097656,431.6435546875],[62.326744079589844,431.6333923339844],[61.926021575927734,431.62322998046875],[61.525333404541016,431.6130676269531],[61.12461471557617,431.6029052734375],[60.72392654418945,431.5927734375],[60.323204040527344,431.5826110839844],[59.922515869140625,431.57244873046875],[59.521827697753906,431.5622863769531],[59.12110900878906,431.5521240234375],[58.720428466796875,431.54107666015625],[58.32006072998047,431.5223083496094],[57.92019271850586,431.4947509765625],[57.52092742919922,431.4597473144531],[57.12227249145508,431.4177551269531],[56.724403381347656,431.3692321777344],[56.32732391357422,431.3146057128906],[55.931034088134766,431.25457763671875],[55.53551483154297,431.1893615722656],[55.14094161987305,431.1190185546875],[54.747161865234375,431.044189453125],[54.35426712036133,430.9647521972656],[53.962303161621094,430.88104248046875],[53.571144104003906,430.79339599609375],[53.1810302734375,430.7013854980469],[52.79179763793945,430.6057434082031],[52.403568267822266,430.5060729980469],[52.016292572021484,430.40277099609375],[51.63001251220703,430.29571533203125],[51.244789123535156,430.1849060058594],[50.86063003540039,430.070556640625],[50.47761917114258,429.9523620605469],[50.095703125,429.8307189941406],[49.71509552001953,429.70501708984375],[49.33567428588867,429.5757751464844],[48.95761489868164,429.4425354003906],[48.581016540527344,429.3053894042969],[48.205833435058594,429.1643371582031],[47.83235549926758,429.01873779296875],[47.46060562133789,428.8689270019531],[47.090641021728516,428.71466064453125],[46.722877502441406,428.5552673339844],[46.35732650756836,428.3908996582031],[45.994205474853516,428.2211608886719],[45.633907318115234,428.0455627441406],[45.27685546875,427.8633728027344],[44.9234733581543,427.6742248535156],[44.57426834106445,427.4775085449219],[44.2309455871582,427.2707214355469],[43.90046691894531,427.0440673828125],[43.58359909057617,426.7986145019531],[43.279605865478516,426.5374755859375],[42.9873046875,426.26318359375],[42.70598220825195,425.97772216796875],[42.43504333496094,425.6823425292969],[42.17332077026367,425.3787841796875],[41.9207649230957,425.0675964355469],[41.67631149291992,424.74993896484375],[41.440181732177734,424.4260559082031],[41.21145248413086,424.0968933105469],[40.99024200439453,423.76263427734375],[40.776119232177734,423.423828125],[40.56885528564453,423.08074951171875],[40.368621826171875,422.7335510253906],[40.17501449584961,422.382568359375],[39.98843002319336,422.02783203125],[39.808616638183594,421.6695861816406],[39.635990142822266,421.307861328125],[39.4705924987793,420.9427490234375],[39.31304168701172,420.57415771484375],[39.16358184814453,420.2023010253906],[39.02311325073242,419.8268737792969],[38.89262771606445,419.4479064941406],[38.771820068359375,419.06573486328125],[38.65382385253906,418.6826477050781],[38.53802490234375,418.2989501953125],[38.42457580566406,417.91448974609375],[38.31364440917969,417.5293273925781],[38.20539474487305,417.1434020996094],[38.099693298339844,416.7567443847656],[37.9973258972168,416.3692321777344],[37.89815902709961,415.9808349609375],[37.8023681640625,415.5916442871094],[37.71010971069336,415.20159912109375],[37.62156295776367,414.8106689453125],[37.53689193725586,414.41888427734375],[37.45627212524414,414.0262451171875],[37.37986373901367,413.63275146484375],[37.30782699584961,413.2384338378906],[37.240325927734375,412.8433532714844],[37.177513122558594,412.4474792480469],[37.11954116821289,412.0508728027344],[37.066551208496094,411.653564453125],[37.01868438720703,411.255615234375],[36.976070404052734,410.8570556640625],[36.9388313293457,410.4579772949219],[36.90707778930664,410.0583801269531],[36.88101577758789,409.6584167480469],[36.86067199707031,409.2580871582031],[36.84612274169922,408.8575439453125],[36.83743667602539,408.4568176269531],[36.834686279296875,408.0559997558594],[36.837913513183594,407.65521240234375],[36.84717559814453,407.2544860839844],[36.86248779296875,406.85394287109375],[36.88386535644531,406.4537048339844],[36.909969329833984,406.0537414550781],[36.93544387817383,405.65374755859375],[36.95923614501953,405.2535705566406],[36.98122024536133,404.8533630371094],[37.00153350830078,404.4530334472656],[37.020263671875,404.05267333984375],[37.037445068359375,403.6521911621094],[37.05310821533203,403.2516784667969],[37.06727981567383,402.8511047363281],[37.079830169677734,402.450439453125],[37.09080505371094,402.0498046875],[37.10057830810547,401.6490783691406],[37.108917236328125,401.24835205078125],[37.11643981933594,400.84759521484375],[37.12193298339844,400.44677734375],[37.126766204833984,400.0459899902344],[37.130184173583984,399.6451721191406],[37.1324577331543,399.2443542480469],[37.1340217590332,398.843505859375],[37.133949279785156,398.44268798828125],[37.133331298828125,398.0418701171875],[37.131591796875,397.6410217285156],[37.128944396972656,397.240234375],[37.12575912475586,396.8393859863281],[37.12131118774414,396.4385681152344],[37.116455078125,396.03778076171875],[37.110809326171875,395.6369934082031],[37.104488372802734,395.2362060546875],[37.09781265258789,394.8354187011719],[37.09028244018555,394.4346923828125],[37.08238220214844,394.0339050292969],[37.07383728027344,393.6331787109375],[37.0652961730957,393.2324523925781],[37.05668258666992,392.83172607421875],[37.04713821411133,392.4309997558594],[37.037593841552734,392.0302734375],[37.028053283691406,391.62957763671875],[37.01851272583008,391.2288818359375],[37.008968353271484,390.828125],[36.99942398071289,390.42742919921875],[36.98996353149414,390.0267028808594],[36.98059844970703,389.6259765625],[36.97123336791992,389.22528076171875],[36.962013244628906,388.82452392578125],[36.95354461669922,388.4237976074219],[36.945072174072266,388.0230407714844],[36.93660354614258,387.622314453125],[36.92900848388672,387.2215270996094],[36.92173385620117,386.8207702636719],[36.9151725769043,386.4200134277344],[36.90914535522461,386.01922607421875],[36.90360641479492,385.6184387207031],[36.899051666259766,385.21759033203125],[36.89452362060547,384.8168029785156],[36.880096435546875,384.416259765625],[36.8497428894043,384.0166015625],[36.80314254760742,383.6185302734375],[36.74042510986328,383.22265625],[36.6617546081543,382.8296813964844],[36.56761932373047,382.4400634765625],[36.458675384521484,382.0543518066406],[36.33609390258789,381.6727600097656],[36.200782775878906,381.29547119140625],[36.053955078125,380.92254638671875],[35.8968620300293,380.55377197265625],[35.73080825805664,380.1889953613281],[35.55705261230469,379.82781982421875],[35.37676239013672,379.46978759765625],[35.191261291503906,379.114501953125],[35.00168228149414,378.7613220214844],[34.80918502807617,378.4097595214844],[34.61471176147461,378.0592346191406],[34.41908264160156,377.70941162109375],[34.22358322143555,377.3594970703125],[34.028282165527344,377.0094299316406],[33.83460235595703,376.65850830078125],[33.636016845703125,376.3103942871094],[33.412269592285156,375.9779357910156],[33.17063522338867,375.6581726074219],[32.916500091552734,375.3482360839844],[32.652767181396484,375.0464172363281],[32.38107681274414,374.751708984375],[32.102439880371094,374.463623046875],[31.817485809326172,374.18170166015625],[31.52667236328125,373.9058837890625],[31.230144500732422,373.63623046875],[30.927865982055664,373.3729553222656],[30.6197566986084,373.11663818359375],[30.305418014526367,372.867919921875],[29.98430633544922,372.6280822753906],[29.655607223510742,372.3987121582031],[29.317882537841797,372.1828918457031],[28.969463348388672,371.98492431640625],[28.607126235961914,371.81378173828125],[28.228235244750977,371.6837158203125],[27.844741821289062,371.56707763671875],[27.46029281616211,371.45367431640625],[27.075143814086914,371.3426818847656],[26.68920135498047,371.2344055175781],[26.302698135375977,371.128173828125],[25.9155330657959,371.0243225097656],[25.528026580810547,370.9219055175781],[25.14019203186035,370.8207702636719],[24.75197410583496,370.720947265625],[24.36349868774414,370.6222839355469],[23.97479248046875,370.5242614746094],[23.58603858947754,370.4266662597656],[23.197284698486328,370.3290710449219],[22.80858612060547,370.2311706542969],[22.41991424560547,370.13323974609375],[22.031335830688477,370.034912109375],[21.643043518066406,369.93548583984375],[21.255111694335938,369.8345031738281],[20.86761474609375,369.7320861816406],[20.480457305908203,369.6282958984375],[20.093896865844727,369.5221862792969],[19.7081298828125,369.4134521484375],[19.323060989379883,369.30224609375],[18.938827514648438,369.18792724609375],[18.55561065673828,369.0704650878906],[18.173507690429688,368.9493408203125],[17.79263687133789,368.824462890625],[17.41315460205078,368.69549560546875],[17.0351619720459,368.56201171875],[16.658838272094727,368.424072265625],[16.284448623657227,368.281005859375],[15.91190242767334,368.1331787109375],[15.541626930236816,367.9797058105469],[15.173680305480957,367.82061767578125],[14.808320999145508,367.65570068359375],[14.44581413269043,367.48480224609375],[14.086219787597656,367.3077392578125],[13.729835510253906,367.12432861328125],[13.376774787902832,366.9344787597656],[13.027361869812012,366.7381286621094],[12.68172836303711,366.53509521484375],[12.34019660949707,366.3254089355469],[12.006369590759277,366.1036071777344],[11.68255615234375,365.86737060546875],[11.367913246154785,365.6191101074219],[11.061797142028809,365.3603515625],[10.763662338256836,365.09246826171875],[10.472931861877441,364.81646728515625],[10.189167976379395,364.5334167480469],[9.91195011138916,364.2439880371094],[9.640833854675293,363.9487609863281],[9.37562370300293,363.6482849121094],[9.115755081176758,363.3429870605469],[8.861200332641602,363.0334167480469],[8.611599922180176,362.71978759765625],[8.366817474365234,362.40240478515625],[8.126845359802246,362.08135986328125],[7.891444683074951,361.7569274902344],[7.660423278808594,361.4293518066406],[7.433713436126709,361.0988464355469],[7.211228370666504,360.7654724121094],[6.993084907531738,360.4292297363281],[6.779146671295166,360.09014892578125],[6.569433689117432,359.74859619140625],[6.363907814025879,359.40447998046875],[6.162662506103516,359.0578918457031],[5.965734481811523,358.7087707519531],[5.773329734802246,358.3570861816406],[5.5856218338012695,358.0029296875],[5.402729511260986,357.64630126953125],[5.224918842315674,357.287109375],[5.05247163772583,356.92529296875],[4.885766506195068,356.5606994628906],[4.725513935089111,356.1933288574219],[4.572278022766113,355.8229675292969],[4.4247355461120605,355.4503173828125],[4.28198766708374,355.07574462890625],[4.144247055053711,354.69927978515625],[4.011687755584717,354.321044921875],[3.8844053745269775,353.9410095214844],[3.762550115585327,353.55914306640625],[3.6464483737945557,353.17547607421875],[3.5360255241394043,352.7901611328125],[3.431335926055908,352.40325927734375],[3.3324482440948486,352.0148620605469],[3.239501953125,351.6249694824219],[3.152597188949585,351.23358154296875],[3.0715904235839844,350.841064453125],[2.996431827545166,350.4473571777344],[2.927147626876831,350.0525817871094],[2.863798141479492,349.65679931640625],[2.8060781955718994,349.2601318359375],[2.7538912296295166,348.8627014160156],[2.7071213722229004,348.4646301269531],[2.6658191680908203,348.0659484863281],[2.629582643508911,347.666748046875],[2.59824800491333,347.26715087890625],[2.5716280937194824,346.8671875],[2.54953670501709,346.4670104980469],[2.5318713188171387,346.0665588378906],[2.518326759338379,345.6658935546875],[2.5086748600006104,345.2652282714844],[2.5027029514312744,344.86444091796875],[2.5002031326293945,344.4636535644531],[2.5026090145111084,344.0628356933594],[2.5140819549560547,343.6621398925781],[2.5342795848846436,343.2618408203125],[2.5630054473876953,342.862060546875],[2.5994160175323486,342.4629211425781],[2.643357992172241,342.0645446777344],[2.694491147994995,341.66693115234375],[2.7524521350860596,341.2703552246094],[2.816934823989868,340.874755859375],[2.8876380920410156,340.4801940917969],[2.964268207550049,340.0867919921875],[3.046577215194702,339.6944885253906],[3.1342930793762207,339.3033752441406],[3.2272074222564697,338.9134826660156],[3.3251953125,338.52484130859375],[3.427943229675293,338.1374206542969],[3.5352542400360107,337.75115966796875],[3.646916151046753,337.3662109375],[3.7627642154693604,336.9825439453125],[3.8826537132263184,336.6000671386719],[4.006454944610596,336.2188415527344],[4.133995056152344,335.8387756347656],[4.265122890472412,335.4600524902344],[4.399751663208008,335.08251953125],[4.53782320022583,334.7062072753906],[4.679137706756592,334.3310852050781],[4.823557376861572,333.95721435546875],[4.971020698547363,333.58447265625],[5.121417045593262,333.21295166015625],[5.274662494659424,332.8425598144531],[5.430666923522949,332.47332763671875],[5.589349746704102,332.1052551269531],[5.750776290893555,331.7383728027344],[5.913735389709473,331.3721923828125],[6.077038288116455,331.00616455078125],[6.240365982055664,330.6400451660156],[6.403669357299805,330.2740173339844],[6.566972255706787,329.907958984375],[6.7302751541137695,329.54193115234375],[6.893578052520752,329.1758728027344],[7.056905746459961,328.8097839355469],[7.220209121704102,328.4437561035156],[7.383512020111084,328.07769775390625],[7.546814918518066,327.711669921875],[7.710118293762207,327.3456115722656],[7.873445987701416,326.9795227050781],[8.036748886108398,326.61346435546875],[8.200052261352539,326.2474365234375],[8.363354682922363,325.8813781738281],[8.52668285369873,325.5152893066406],[8.689986228942871,325.1492614746094],[8.853288650512695,324.783203125],[9.016786575317383,324.417236328125],[9.180338859558105,324.0513000488281],[9.343915939331055,323.6853332519531],[9.507469177246094,323.31939697265625],[9.671022415161133,322.9534606933594],[9.834574699401855,322.5875244140625],[9.998126983642578,322.22161865234375],[10.161705017089844,321.8556213378906],[10.325257301330566,321.48968505859375],[10.488810539245605,321.1237487792969],[10.652362823486328,320.7578125],[10.815916061401367,320.39190673828125],[10.979493141174316,320.0259094238281],[11.143045425415039,319.65997314453125],[11.306598663330078,319.2940368652344],[11.4701509475708,318.9281005859375],[11.63370418548584,318.56219482421875],[11.797281265258789,318.1961975097656],[11.960834503173828,317.83026123046875],[12.1246337890625,317.4644775390625],[12.288480758666992,317.0986633300781],[12.452326774597168,316.7328796386719],[12.61619758605957,316.36700439453125],[12.780044555664062,316.001220703125],[12.943891525268555,315.6354064941406],[13.10773754119873,315.2696228027344],[13.271608352661133,314.90374755859375],[13.435455322265625,314.5379638671875],[13.599302291870117,314.1721496582031],[13.763148307800293,313.8063659667969],[13.926994323730469,313.4405517578125],[14.090866088867188,313.07470703125],[14.25471305847168,312.7088928222656],[14.418559074401855,312.3431091308594],[14.582406044006348,311.977294921875],[14.746252059936523,311.61151123046875],[14.910123825073242,311.24566650390625],[15.073969841003418,310.8798522949219],[15.23781681060791,310.5140686035156],[15.401662826538086,310.14825439453125],[15.565509796142578,309.7824401855469],[15.72938060760498,309.4165954589844],[15.893227577209473,309.0508117675781],[16.05707359313965,308.68499755859375],[16.22092056274414,308.3192138671875],[16.384767532348633,307.9533996582031],[16.54863739013672,307.5875549316406],[16.71248435974121,307.22174072265625],[16.876331329345703,306.85595703125],[17.040178298950195,306.4901428222656],[17.20404815673828,306.1242980957031],[17.367895126342773,305.75848388671875],[17.531742095947266,305.3927001953125],[17.695589065551758,305.0268859863281],[17.859434127807617,304.6611022949219],[18.023305892944336,304.29522705078125],[18.187265396118164,303.929443359375],[18.351409912109375,303.56378173828125],[18.515554428100586,303.1981201171875],[18.679698944091797,302.83245849609375],[18.843868255615234,302.46673583984375],[19.008010864257812,302.10107421875],[19.172155380249023,301.73541259765625],[19.336299896240234,301.3697204589844],[19.500444412231445,301.0040588378906],[19.664613723754883,300.6383361816406],[19.828758239746094,300.2726745605469],[19.992900848388672,299.9070129394531],[20.157045364379883,299.5413513183594],[20.321189880371094,299.1756896972656],[20.48535919189453,298.8099670410156],[20.649503707885742,298.4443054199219],[20.813648223876953,298.07861328125],[20.97779083251953,297.71295166015625],[21.141935348510742,297.3472900390625],[21.30610466003418,296.9815673828125],[21.47024917602539,296.61590576171875],[21.6343936920166,296.250244140625],[21.798538208007812,295.88458251953125],[21.96270751953125,295.51885986328125],[22.126850128173828,295.1531982421875],[22.29099464416504,294.78753662109375],[22.45513916015625,294.4218444824219],[22.61928367614746,294.0561828613281],[22.7834529876709,293.6904602050781],[22.94759750366211,293.3247985839844],[23.111740112304688,292.9591369628906],[23.2758846282959,292.5934753417969],[23.44002914428711,292.2278137207031],[23.604198455810547,291.8620910644531],[23.768342971801758,291.4964294433594],[23.93248748779297,291.1307373046875],[24.096630096435547,290.76507568359375],[24.260774612426758,290.3994140625],[24.424943923950195,290.03369140625],[24.589088439941406,289.66802978515625],[24.753232955932617,289.3023681640625],[24.917377471923828,288.93670654296875],[25.081520080566406,288.571044921875],[25.245689392089844,288.205322265625],[25.409833908081055,287.8396301269531],[25.573978424072266,287.4739685058594],[25.738122940063477,287.1083068847656],[25.902292251586914,286.7425842285156],[26.066436767578125,286.3769226074219],[26.230579376220703,286.0112609863281],[26.394723892211914,285.6455993652344],[26.558868408203125,285.2799377441406],[26.723037719726562,284.9142150878906],[26.887182235717773,284.5485534667969],[27.051326751708984,284.182861328125],[27.215469360351562,283.81719970703125],[27.379613876342773,283.4515380859375],[27.54378318786621,283.0858154296875],[27.707927703857422,282.72015380859375],[27.872072219848633,282.3544921875],[28.036216735839844,281.98883056640625],[28.200359344482422,281.6231689453125],[28.36452865600586,281.2574462890625],[28.52867317199707,280.8917541503906],[28.69281768798828,280.5260925292969],[28.856962203979492,280.1604309082031],[29.02110481262207,279.7947692871094],[29.185274124145508,279.4290466308594],[29.34941864013672,279.0633850097656],[29.51356315612793,278.6977233886719],[29.67770767211914,278.3320617675781],[29.84185218811035,277.96636962890625],[30.00602149963379,277.60064697265625],[30.170164108276367,277.2349853515625],[30.33428955078125,276.8693542480469],[30.498390197753906,276.503662109375],[30.662513732910156,276.137939453125],[30.826614379882812,275.7722473144531],[30.99071502685547,275.40655517578125],[31.154813766479492,275.0408630371094],[31.31891441345215,274.6752014160156],[31.48303985595703,274.3094482421875],[31.647138595581055,273.9437561035156],[31.811237335205078,273.57806396484375],[31.975337982177734,273.21240234375],[32.13943862915039,272.8467102050781],[32.30356216430664,272.48095703125],[32.4676628112793,272.1152648925781],[32.63176345825195,271.7496032714844],[32.79586410522461,271.3839111328125],[32.9599609375,271.0182189941406],[33.124088287353516,270.6524658203125],[33.28818893432617,270.28680419921875],[33.45228576660156,269.9211120605469],[33.61638641357422,269.555419921875],[33.780487060546875,269.1897277832031],[33.944610595703125,268.8240051269531],[34.10871124267578,268.45831298828125],[34.27281188964844,268.0926208496094],[34.436912536621094,267.7269287109375],[34.601036071777344,267.3612060546875],[34.76513671875,266.9955139160156],[34.929237365722656,266.62982177734375],[35.09333419799805,266.2641296386719],[35.2574348449707,265.8984375],[35.42156219482422,265.53271484375],[35.58565902709961,265.1670227050781],[35.749759674072266,264.80133056640625],[35.91386032104492,264.4356384277344],[36.07796096801758,264.0699768066406],[36.24208450317383,263.7042236328125],[36.406124114990234,263.33843994140625],[36.5699577331543,262.97265625],[36.733795166015625,262.6068420410156],[36.89762878417969,262.24102783203125],[37.061492919921875,261.87518310546875],[37.22532653808594,261.5093688964844],[37.389163970947266,261.1435852050781],[37.55299758911133,260.77777099609375],[37.716835021972656,260.4119567871094],[37.88069534301758,260.0461120605469],[38.044532775878906,259.6802978515625],[38.20836639404297,259.3144836425781],[38.3722038269043,258.9486999511719],[38.53603744506836,258.5828857421875],[38.69989776611328,258.2170104980469],[38.86373519897461,257.8512268066406],[39.02757263183594,257.48541259765625],[39.19140625,257.1195983886719],[39.35526657104492,256.7537536621094],[39.51910400390625,256.387939453125],[39.68293762207031,256.02215576171875],[39.84677505493164,255.65634155273438],[40.01061248779297,255.29052734375],[40.17447280883789,254.9246826171875],[40.33830642700195,254.55886840820312],[40.50214385986328,254.1930694580078],[40.665977478027344,253.82725524902344],[40.82981491088867,253.46145629882812],[40.993675231933594,253.09559631347656],[41.15751266479492,252.72979736328125],[41.321346282958984,252.36398315429688],[41.48518371582031,251.99818420410156],[41.649017333984375,251.63238525390625],[41.81288146972656,251.2665252685547],[41.976715087890625,250.9007110595703],[42.14055252075195,250.534912109375],[42.304386138916016,250.1691131591797],[42.46799087524414,249.80325317382812],[42.63154602050781,249.437255859375],[42.79507064819336,249.07130432128906],[42.95859909057617,248.7053680419922],[43.122127532958984,248.33941650390625],[43.285682678222656,247.97341918945312],[43.44921112060547,247.60748291015625],[43.61273956298828,247.24154663085938],[43.77626419067383,246.87559509277344],[43.93979263305664,246.50965881347656],[44.10334777832031,246.14366149902344],[44.266876220703125,245.7777099609375],[44.43040466308594,245.41177368164062],[44.593929290771484,245.04583740234375],[44.7574577331543,244.6798858642578],[44.92101287841797,244.3138885498047],[45.08454132080078,243.9479522705078],[45.248069763183594,243.58201599121094],[45.4114875793457,243.21600341796875],[45.57474899291992,242.84994506835938],[45.738037109375,242.48382568359375],[45.901302337646484,242.11776733398438],[46.0645637512207,241.751708984375],[46.22782897949219,241.38565063476562],[46.391090393066406,241.01959228515625],[46.554378509521484,240.65347290039062],[46.71764373779297,240.28741455078125],[46.88090515136719,239.92135620117188],[47.04417037963867,239.5552978515625],[47.20745849609375,239.18917846679688],[47.370723724365234,238.8231201171875],[47.53398513793945,238.45706176757812],[47.69725036621094,238.09100341796875],[47.860511779785156,237.7249298095703],[48.023799896240234,237.35882568359375],[48.18706512451172,236.99276733398438],[48.35026931762695,236.62667846679688],[48.513221740722656,236.26048278808594],[48.67617416381836,235.89427185058594],[48.83915328979492,235.5280303955078],[49.002105712890625,235.1618194580078],[49.165061950683594,234.79562377929688],[49.3280143737793,234.42942810058594],[49.490970611572266,234.063232421875],[49.65394592285156,233.6969757080078],[49.81690216064453,233.33078002929688],[49.979854583740234,232.96458435058594],[50.1428108215332,232.598388671875],[50.305763244628906,232.23219299316406],[50.46874237060547,231.86593627929688],[50.63169479370117,231.49974060058594],[50.794647216796875,231.13352966308594],[50.957603454589844,230.767333984375],[51.12055587768555,230.40113830566406],[51.28353500366211,230.03488159179688],[51.446144104003906,229.6685333251953],[51.60874557495117,229.30218505859375],[51.77134704589844,228.93582153320312],[51.9339714050293,228.5694122314453],[52.09657287597656,228.20306396484375],[52.25917434692383,227.83670043945312],[52.421775817871094,227.47035217285156],[52.584373474121094,227.10400390625],[52.74700164794922,226.7375946044922],[52.909603118896484,226.37123107910156],[53.072200775146484,226.0048828125],[53.23480224609375,225.63851928710938],[53.397403717041016,225.2721710205078],[53.560028076171875,224.90576171875],[53.72262954711914,224.53939819335938],[53.885231018066406,224.1730499267578],[54.04783248901367,223.8066864013672],[54.21043395996094,223.44033813476562],[54.37274932861328,223.0738067626953],[54.534950256347656,222.707275390625],[54.6971549987793,222.3407440185547],[54.85935974121094,221.97421264648438],[55.02156066894531,221.60768127441406],[55.18378829956055,221.24110412597656],[55.34599304199219,220.87457275390625],[55.50819778442383,220.50804138183594],[55.6703987121582,220.14151000976562],[55.83262634277344,219.77491760253906],[55.99483108520508,219.40838623046875],[56.15703582763672,219.04185485839844],[56.319236755371094,218.67532348632812],[56.481441497802734,218.3087921142578],[56.64366912841797,217.94219970703125],[56.80587387084961,217.57566833496094],[56.968074798583984,217.20913696289062],[57.130279541015625,216.8426055908203],[57.29230499267578,216.4759979248047],[57.45420455932617,216.10926818847656],[57.616085052490234,215.7425994873047],[57.77796173095703,215.37591552734375],[57.939842224121094,215.00924682617188],[58.10171890258789,214.642578125],[58.26362228393555,214.27584838867188],[58.425498962402344,213.90916442871094],[58.587379455566406,213.54249572753906],[58.74916076660156,213.17575073242188],[58.910804748535156,212.80897521972656],[59.07247543334961,212.442138671875],[59.23412322998047,212.0753631591797],[59.39576721191406,211.70858764648438],[59.55741500854492,211.34181213378906],[59.719058990478516,210.97503662109375],[59.88072967529297,210.6082000732422],[60.04237747192383,210.24142456054688],[60.203895568847656,209.87457275390625],[60.36517333984375,209.5076446533203],[60.5264778137207,209.14064025878906],[60.6877555847168,208.77369689941406],[60.84903335571289,208.40676879882812],[61.010311126708984,208.03982543945312],[61.17158889770508,207.67288208007812],[61.332889556884766,207.30589294433594],[61.49416732788086,206.93894958496094],[61.65544509887695,206.57200622558594],[61.81672286987305,206.205078125],[61.97800064086914,205.838134765625],[62.13930130004883,205.47113037109375],[62.30057907104492,205.1042022705078],[62.461856842041016,204.7372589111328],[62.62313461303711,204.3703155517578],[62.7844123840332,204.00338745117188],[62.94571304321289,203.63638305664062],[63.1069221496582,203.2694091796875],[63.26767349243164,202.90223693847656],[63.42842483520508,202.53506469726562],[63.58917236328125,202.1678924560547],[63.74994659423828,201.8006591796875],[63.91069793701172,201.43348693847656],[64.07144927978516,201.06631469726562],[64.23219299316406,200.6991424560547],[64.3929672241211,200.33192443847656],[64.55371856689453,199.96475219726562],[64.71446990966797,199.5975799560547],[64.8752212524414,199.23040771484375],[65.03597259521484,198.8632354736328],[65.19674682617188,198.4960174560547],[65.35749053955078,198.12884521484375],[65.51824188232422,197.7616729736328],[65.67899322509766,197.39450073242188],[65.8397445678711,197.02732849121094],[66.00051879882812,196.66009521484375],[66.1608657836914,196.29278564453125],[66.3211898803711,195.92543029785156],[66.48152160644531,195.55807495117188],[66.641845703125,195.1907196044922],[66.80219268798828,194.8233184814453],[66.9625244140625,194.45596313476562],[67.12284851074219,194.08860778808594],[67.2831802368164,193.72125244140625],[67.4435043334961,193.35389709472656],[67.6036148071289,192.98638916015625],[67.76364135742188,192.61891174316406],[67.92367553710938,192.2514190673828],[68.08370971679688,191.88394165039062],[68.24374389648438,191.51646423339844],[68.40380096435547,191.14891052246094],[68.56382751464844,190.78143310546875],[68.72386169433594,190.41395568847656],[68.88389587402344,190.0464630126953],[69.04376220703125,189.6787872314453],[69.2034912109375,189.31117248535156],[69.36321258544922,188.9435577392578],[69.52294158935547,188.575927734375],[69.68267059326172,188.20831298828125],[69.84241485595703,187.84063720703125],[70.00214385986328,187.4730224609375],[70.16187286376953,187.10540771484375],[70.32159423828125,186.73779296875],[70.48111724853516,186.3701629638672],[70.64054870605469,186.00234985351562],[70.79995727539062,185.63458251953125],[70.95936584472656,185.26683044433594],[71.1187744140625,184.89907836914062],[71.27818298339844,184.5313262939453],[71.43761444091797,184.16351318359375],[71.5970230102539,183.79576110839844],[71.75643157958984,183.42800903320312],[71.91571807861328,183.06016540527344],[72.07479858398438,182.69227600097656],[72.23390197753906,182.32431030273438],[72.39298248291016,181.9564208984375],[72.55207061767578,181.58853149414062],[72.71115112304688,181.2206268310547],[72.87025451660156,180.85267639160156],[73.02933502197266,180.48477172851562],[73.18842315673828,180.11688232421875],[73.347412109375,179.74893188476562],[73.50615692138672,179.38088989257812],[73.66492462158203,179.01278686523438],[73.82366943359375,178.64474487304688],[73.98241424560547,178.27670288085938],[74.14115905761719,177.90866088867188],[74.2999038696289,177.54061889648438],[74.45867156982422,177.17251586914062],[74.61741638183594,176.80447387695312],[74.7761001586914,176.43646240234375],[74.93449401855469,176.06826782226562],[75.0928955078125,175.7000732421875],[75.2513198852539,175.3318328857422],[75.40971374511719,174.96363830566406],[75.568115234375,174.59544372558594],[75.72650909423828,174.2272491455078],[75.8849105834961,173.85906982421875],[76.04332733154297,173.49081420898438],[76.20172882080078,173.12261962890625],[76.35977935791016,172.7542724609375],[76.517822265625,172.38592529296875],[76.67586517333984,172.017578125],[76.83393096923828,171.64918518066406],[76.9919662475586,171.2808380126953],[77.15000915527344,170.91249084472656],[77.30805206298828,170.5441436767578],[77.46611785888672,170.17575073242188],[77.62416076660156,169.80740356445312],[77.78190612792969,169.43893432617188],[77.9395751953125,169.07041931152344],[78.09725189208984,168.70191955566406],[78.25495147705078,168.33335876464844],[78.4126205444336,167.96485900878906],[78.57029724121094,167.5963592529297],[78.72796630859375,167.2278594970703],[78.8856430053711,166.85935974121094],[79.04334259033203,166.4907989501953],[79.2007827758789,166.12217712402344],[79.35807800292969,165.75350952148438],[79.51537322998047,165.38485717773438],[79.67267608642578,165.0161895751953],[79.82999420166016,164.6474609375],[79.98729705810547,164.27880859375],[80.14459228515625,163.91014099121094],[80.30188751220703,163.54147338867188],[80.45918273925781,163.17282104492188],[80.61632537841797,162.8040313720703],[80.77323913574219,162.43521118164062],[80.93014526367188,162.06637573242188],[81.0870590209961,161.6975555419922],[81.2439956665039,161.32867431640625],[81.4009017944336,160.9598388671875],[81.55781555175781,160.5910186767578],[81.7147216796875,160.22218322753906],[81.87163543701172,159.85336303710938],[82.0284652709961,159.4844512939453],[82.18497467041016,159.11544799804688],[82.34149169921875,158.7464599609375],[82.49800872802734,158.37745666503906],[82.65452575683594,158.00845336914062],[82.8110580444336,157.639404296875],[82.96757507324219,157.27041625976562],[83.12409210205078,156.9014129638672],[83.28060150146484,156.5324249267578],[83.43712615966797,156.1633758544922],[83.59325408935547,155.7941436767578],[83.7493667602539,155.42498779296875],[83.90547180175781,155.05581665039062],[84.06158447265625,154.6866455078125],[84.21768951416016,154.31747436523438],[84.37382507324219,153.94825744628906],[84.5299301147461,153.57908630371094],[84.68604278564453,153.2099151611328],[84.84214782714844,152.8407440185547],[84.9979248046875,152.47142028808594],[85.15364837646484,152.10202026367188],[85.30934143066406,151.73268127441406],[85.46503448486328,151.36334228515625],[85.6207275390625,150.99398803710938],[85.77644348144531,150.6245880126953],[85.93213653564453,150.2552490234375],[86.08782958984375,149.8859100341797],[86.24352264404297,149.5165557861328],[86.39896392822266,149.1471405029297],[86.55426025390625,148.77755737304688],[86.70952606201172,148.4080352783203],[86.86479949951172,148.03851318359375],[87.02006530761719,147.6689910888672],[87.17533874511719,147.29946899414062],[87.33063507080078,146.9298858642578],[87.48590087890625,146.56036376953125],[87.64117431640625,146.1908416748047],[87.7962875366211,145.82130432128906],[87.95112609863281,145.45159912109375],[88.1059799194336,145.08184814453125],[88.26081848144531,144.71214294433594],[88.41565704345703,144.34243774414062],[88.57049560546875,143.9727325439453],[88.72532653808594,143.60302734375],[88.88018798828125,143.23326110839844],[89.03502655029297,142.8635711669922],[89.1898422241211,142.49383544921875],[89.34423828125,142.1239471435547],[89.49864959716797,141.75399780273438],[89.65304565429688,141.3841094970703],[89.80744171142578,141.01422119140625],[89.96183013916016,140.6443328857422],[90.11622619628906,140.27444458007812],[90.27064514160156,139.9044952392578],[90.42503356933594,139.53460693359375],[90.57942962646484,139.1647186279297],[90.73347473144531,138.794677734375],[90.88742065429688,138.4246063232422],[91.04138946533203,138.05447387695312],[91.1953353881836,137.6844024658203],[91.34927368164062,137.31431579589844],[91.50321960449219,136.94424438476562],[91.65716552734375,136.5741729736328],[91.8111343383789,136.20404052734375],[91.96507263183594,135.83396911621094],[92.1187973022461,135.46380615234375],[92.27228546142578,135.09353637695312],[92.42576599121094,134.7232666015625],[92.57926940917969,134.35293579101562],[92.73275756835938,133.98268127441406],[92.88623809814453,133.61241149902344],[93.03971862792969,133.2421417236328],[93.19320678710938,132.8718719482422],[93.34671020507812,132.50155639648438],[93.50012969970703,132.1312255859375],[93.65314483642578,131.76077270507812],[93.80615997314453,131.3903045654297],[93.95919799804688,131.01979064941406],[94.11222076416016,130.6493377685547],[94.2652359008789,130.27886962890625],[94.41825103759766,129.90841674804688],[94.5712661743164,129.53794860839844],[94.72430419921875,129.1674346923828],[94.8773193359375,128.79696655273438],[95.02993774414062,128.42636108398438],[95.18247985839844,128.0557098388672],[95.33501434326172,127.68505096435547],[95.48757934570312,127.31433868408203],[95.64012145996094,126.94367980957031],[95.79265594482422,126.5730209350586],[95.94519805908203,126.2023696899414],[96.09774017333984,125.83171081542969],[96.25030517578125,125.46099853515625],[96.4026107788086,125.09024047851562],[96.5546646118164,124.71939086914062],[96.70671844482422,124.3485336303711],[96.85877227783203,123.97767639160156],[97.01085662841797,123.60676574707031],[97.16291046142578,123.23590850830078],[97.3149642944336,122.86505126953125],[97.4670181274414,122.49419403076172],[97.61909484863281,122.12328338623047],[97.77110290527344,121.75239562988281],[97.92266082763672,121.38134002685547],[98.07422637939453,121.01028442382812],[98.22578430175781,120.63922882080078],[98.37737274169922,120.26811218261719],[98.5289306640625,119.89705657958984],[98.68049621582031,119.52599334716797],[98.83206176757812,119.15493774414062],[98.9836196899414,118.78388214111328],[99.13520812988281,118.41276550292969],[99.28641510009766,118.04155731201172],[99.4374771118164,117.67029571533203],[99.58853912353516,117.29903411865234],[99.7396011352539,116.92777252197266],[99.89068603515625,116.55645751953125],[100.04174041748047,116.18518829345703],[100.19280242919922,115.81392669677734],[100.34386444091797,115.44266510009766],[100.49492645263672,115.07140350341797],[100.64501953125,114.69970703125],[100.78108978271484,114.32270812988281],[100.90201568603516,113.9405746459961],[101.0107650756836,113.55485534667969],[101.10960388183594,113.16632843017578],[101.19989776611328,112.77584838867188],[101.28292083740234,112.38371276855469],[101.35945892333984,111.99024963378906],[101.43025207519531,111.59574127197266],[101.49595642089844,111.20028686523438],[101.5570068359375,110.80414581298828],[101.6136245727539,110.40738677978516],[101.6663818359375,110.01004791259766],[101.71526336669922,109.61224365234375],[101.76078033447266,109.21395874023438],[101.80284881591797,108.81531524658203],[101.84183502197266,108.41639709472656],[101.87781524658203,108.01722717285156],[101.91080474853516,107.61774444580078],[101.9410400390625,107.21805572509766],[101.9685287475586,106.81816101074219],[101.99330139160156,106.4181137084961],[102.0154800415039,106.01788330078125],[102.03508758544922,105.61756134033203],[102.05205535888672,105.2170639038086],[102.06649780273438,104.81649780273438],[102.07843017578125,104.41586303710938],[102.08770751953125,104.01513671875],[102.09442138671875,103.6143798828125],[102.09855651855469,103.21351623535156],[102.09991455078125,102.81272888183594],[102.09854888916016,102.41189575195312],[102.09441375732422,102.01109313964844],[102.08723449707031,101.61026763916016],[102.07708740234375,101.20960235595703],[102.06365966796875,100.80903625488281],[102.0468978881836,100.40855407714844],[102.02645111083984,100.00823974609375],[102.00223541259766,99.6081314086914],[101.97374725341797,99.20832061767578],[101.94068908691406,98.8088607788086],[101.90261840820312,98.40986633300781],[101.85889434814453,98.01146697998047],[101.8087158203125,97.61370086669922],[101.7511215209961,97.21707153320312],[101.68482208251953,96.82177734375],[101.60787963867188,96.42842102050781],[101.51753234863281,96.03799438476562],[101.41492462158203,95.65044403076172],[101.30844116210938,95.26402282714844],[101.19828796386719,94.87859344482422],[101.08457946777344,94.4942855834961],[100.96732330322266,94.11100769042969],[100.84651184082031,93.7287826538086],[100.72216033935547,93.34772491455078],[100.59440612792969,92.96782684326172],[100.46326446533203,92.58908081054688],[100.32870483398438,92.21144104003906],[100.19080352783203,91.8351058959961],[100.04939270019531,91.46002960205078],[99.9045639038086,91.08634185791016],[99.75631713867188,90.71392059326172],[99.60465240478516,90.34285736083984],[99.44959259033203,89.9732666015625],[99.29096221923828,89.60515594482422],[99.12870788574219,89.23863220214844],[98.96292877197266,88.87373352050781],[98.79353332519531,88.5103988647461],[98.62049865722656,88.1488265991211],[98.4437255859375,87.78910827636719],[98.26300048828125,87.43133544921875],[98.07853698730469,87.07551574707031],[97.89000701904297,86.72175598144531],[97.69738006591797,86.3702392578125],[97.50061798095703,86.02105712890625],[97.29959869384766,85.67428588867188],[97.09414672851562,85.33014678955078],[96.8841552734375,84.98869323730469],[96.66952514648438,84.65015411376953],[96.45010375976562,84.31475067138672],[96.22572326660156,83.98260498046875],[95.99622344970703,83.65401458740234],[95.76138305664062,83.3291244506836],[95.52243041992188,83.00739288330078],[95.27979278564453,82.68833923339844],[95.0334243774414,82.37216186523438],[94.783447265625,82.05880737304688],[94.52985382080078,81.74842834472656],[94.27259826660156,81.44099426269531],[94.01184844970703,81.13660430908203],[93.74754333496094,80.8353271484375],[93.47966766357422,80.53706359863281],[93.20841217041016,80.24195098876953],[92.9336929321289,79.95008850097656],[92.65565490722656,79.66139221191406],[92.37433624267578,79.37593841552734],[92.08963012695312,79.09368896484375],[91.80183410644531,78.81473541259766],[91.5108871459961,78.53907012939453],[91.216796875,78.26668548583984],[90.91976165771484,77.9975814819336],[90.61968231201172,77.73175048828125],[90.31683349609375,77.46927642822266],[90.01116180419922,77.21002197265625],[89.70263671875,76.95406341552734],[89.39151763916016,76.70137023925781],[89.07775115966797,76.45186614990234],[88.76145935058594,76.20573425292969],[88.4427261352539,75.96270751953125],[88.1216049194336,75.72278594970703],[87.79821014404297,75.48596954345703],[87.47251892089844,75.25235748291016],[87.14460754394531,75.02182006835938],[86.81466674804688,74.79428100585938],[86.48269653320312,74.56965637207031],[86.14867401123047,74.3479995727539],[85.8127670288086,74.12934875488281],[85.47500610351562,73.91346740722656],[85.13551330566406,73.70044708251953],[84.7939224243164,73.49075317382812],[84.4504165649414,73.2840347290039],[84.10541534423828,73.08001708984375],[83.7590103149414,72.87836456298828],[83.41149139404297,72.67870330810547],[83.06289672851562,72.48091125488281],[82.71348571777344,72.2844009399414],[82.36353302001953,72.08898162841797],[82.01313781738281,71.89425659179688],[81.66268157958984,71.69984436035156],[81.31217956542969,71.5053482055664],[80.96184539794922,71.31046295166016],[80.61196899414062,71.11492156982422],[80.26287078857422,70.91800689697266],[79.91465759277344,70.71947479248047],[79.5676040649414,70.51897430419922],[79.22201538085938,70.31580352783203],[78.87818145751953,70.10986328125],[78.53643798828125,69.90035247802734],[78.19713592529297,69.68700408935547],[77.86061096191406,69.46923828125],[77.52728271484375,69.24661254882812],[77.1976547241211,69.01860046386719],[76.87210845947266,68.7847671508789],[76.55131530761719,68.54452514648438],[76.23561096191406,68.2974853515625],[75.92584991455078,68.04308319091797],[75.62260437011719,67.78101348876953],[75.32649993896484,67.51091003417969],[75.03839874267578,67.23225402832031],[74.75897216796875,66.94488525390625],[74.48900604248047,66.64860534667969],[74.22940063476562,66.3432846069336],[73.98075866699219,66.0289306640625],[73.74386596679688,65.7055892944336],[73.51944732666016,65.37348937988281],[73.30773162841797,65.03312683105469],[73.10567474365234,64.68699645996094],[72.9124526977539,64.33586120605469],[72.72811126708984,63.97996520996094],[72.55278778076172,63.61943817138672],[72.3866195678711,63.254703521728516],[72.22962188720703,62.885929107666016],[72.08187103271484,62.51335144042969],[71.94343566894531,62.13713455200195],[71.81444549560547,61.757667541503906],[71.6949691772461,61.37510299682617],[71.58506774902344,60.98961639404297],[71.48480224609375,60.6015510559082],[71.39424896240234,60.211090087890625],[71.31351470947266,59.8184814453125],[71.24263000488281,59.423980712890625],[71.18172454833984,59.027835845947266],[71.13085174560547,58.630306243896484],[71.09010314941406,58.23147964477539],[71.05957794189453,57.83185958862305],[71.03935241699219,57.43153381347656],[71.02953338623047,57.0308837890625],[71.03021240234375,56.63008117675781],[71.04148864746094,56.229339599609375],[71.0634536743164,55.82914733886719],[71.09618377685547,55.42970275878906],[71.13983154296875,55.0312614440918],[71.19444274902344,54.63423156738281],[71.2601547241211,54.23875427246094],[71.3370361328125,53.84537124633789],[71.4251708984375,53.45439147949219],[71.524658203125,53.06614685058594],[71.63561248779297,52.68101119995117],[71.75812530517578,52.29931640625],[71.89215087890625,51.921627044677734],[72.03778839111328,51.548213958740234],[72.195068359375,51.179534912109375],[72.3639907836914,50.816036224365234],[72.54460906982422,50.458213806152344],[72.73681640625,50.106536865234375],[72.94058990478516,49.7613639831543],[73.15579223632812,49.42327117919922],[73.38236999511719,49.092620849609375],[73.62016296386719,48.76996994018555],[73.86900329589844,48.45576095581055],[74.12861633300781,48.15041732788086],[74.39877319335938,47.85434341430664],[74.67919921875,47.567955017089844],[74.96953582763672,47.29165267944336],[75.26947784423828,47.025760650634766],[75.57855987548828,46.77066421508789],[75.89582061767578,46.52570724487305],[76.21475982666016,46.28285217285156],[76.53365325927734,46.040035247802734],[76.8523941040039,45.79697036743164],[77.17105865478516,45.5538444519043],[77.4896469116211,45.310672760009766],[77.80801391601562,45.06706619262695],[78.12633514404297,44.8234977722168],[78.44466400146484,44.57992935180664],[78.76298522949219,44.336360931396484],[79.08135223388672,44.09275436401367],[79.39924621582031,43.848628997802734],[79.71711730957031,43.60447692871094],[80.03499603271484,43.36032485961914],[80.35287475585938,43.116172790527344],[80.67079162597656,42.87198257446289],[80.98841857910156,42.627498626708984],[81.30596160888672,42.38291931152344],[81.62349700927734,42.138267517089844],[81.94082641601562,41.893409729003906],[82.25820922851562,41.64851379394531],[82.57535552978516,41.403404235839844],[82.89236450195312,41.158138275146484],[83.20938110351562,40.912872314453125],[83.52639770507812,40.667606353759766],[83.84346008300781,40.42230224609375],[84.16027069091797,40.176815032958984],[84.47687530517578,39.93101501464844],[84.7934799194336,39.68521499633789],[85.11007690429688,39.439414978027344],[85.42672729492188,39.19357681274414],[85.74323272705078,38.94761276245117],[86.05944061279297,38.70130157470703],[86.37564086914062,38.45499038696289],[86.69184875488281,38.208675384521484],[87.00810241699219,37.96232604980469],[87.3242416381836,37.71595001220703],[87.64006042480469,37.46914291381836],[87.95587158203125,37.22233581542969],[88.27174377441406,36.97549057006836],[88.58755493164062,36.72868347167969],[88.90339660644531,36.48186111450195],[89.21884155273438,36.234580993652344],[89.53428649902344,35.98729705810547],[89.84978485107422,35.7399787902832],[90.16522979736328,35.49269485473633],[90.48067474365234,35.24541473388672],[90.79581451416016,34.99774169921875],[91.11090850830078,34.750003814697266],[91.42604064941406,34.50223159790039],[91.74113464355469,34.254493713378906],[92.05622100830078,34.00675964355469],[92.37104797363281,33.75872802734375],[92.68579864501953,33.510555267333984],[93.0005874633789,33.26234817504883],[93.31533813476562,33.01417922973633],[93.63008880615234,32.76600646972656],[93.94464111328125,32.51760482788086],[94.25906372070312,32.269020080566406],[94.57353210449219,32.0203971862793],[94.88795471191406,31.771814346313477],[95.20237731933594,31.523231506347656],[95.51668548583984,31.274465560913086],[95.83084869384766,31.025453567504883],[96.14495849609375,30.776477813720703],[96.45906829833984,30.527503967285156],[96.77318572998047,30.278528213500977],[97.08720397949219,30.029460906982422],[97.40106964111328,29.780078887939453],[97.71488952636719,29.53073501586914],[98.0287094116211,29.281391143798828],[98.342529296875,29.032047271728516],[98.65632629394531,28.782657623291016],[98.96991729736328,28.532928466796875],[99.28346252441406,28.283235549926758],[99.59700775146484,28.033544540405273],[99.9105453491211,27.78385353088379],[100.22409057617188,27.534162521362305],[100.5374526977539,27.28411865234375],[100.85073852539062,27.034101486206055],[101.16401672363281,26.78408432006836],[101.47730255126953,26.534067153930664],[101.79058837890625,26.28404998779297],[102.10371398925781,26.03378677368164],[102.41675567626953,25.78346824645996],[102.72979736328125,25.53314781188965],[103.04283905029297,25.282827377319336],[103.35588073730469,25.032508850097656],[103.66886901855469,24.781980514526367],[103.981689453125,24.53137969970703],[104.29450225830078,24.280778884887695],[104.6073226928711,24.03017807006836],[104.92018127441406,23.779539108276367],[105.23291778564453,23.528867721557617],[105.5455322265625,23.278011322021484],[105.85814666748047,23.02715492248535],[106.1707534790039,22.77629852294922],[106.48341369628906,22.52540397644043],[106.79602813720703,22.274513244628906],[107.10845184326172,22.023420333862305],[107.4208755493164,21.772327423095703],[107.7332992553711,21.5212345123291],[108.04576873779297,21.270103454589844],[108.35818481445312,21.019010543823242],[108.67036437988281,20.7677001953125],[108.9825439453125,20.51630210876465],[109.29471588134766,20.264902114868164],[109.60694122314453,20.013463973999023],[109.91911315917969,19.762065887451172],[110.23129272460938,19.510665893554688],[110.54346466064453,19.259265899658203],[110.85563659667969,19.00786590576172],[111.16786193847656,18.75642967224121],[111.48003387451172,18.505029678344727],[111.79217529296875,18.253536224365234],[112.10408782958984,18.00180435180664],[112.4160385131836,17.750032424926758],[112.72794342041016,17.49829864501953],[113.03984832763672,17.246566772460938],[113.35175323486328,16.99483299255371],[113.66366577148438,16.743099212646484],[113.97561645507812,16.4913272857666],[114.28752136230469,16.239593505859375],[114.59942626953125,15.987861633300781],[114.91133117675781,15.736127853393555],[115.22310638427734,15.484230041503906],[115.53479766845703,15.232132911682129],[115.846435546875,14.980073928833008],[116.1580810546875,14.728014945983887],[116.46971893310547,14.475955963134766],[116.78136444091797,14.223896026611328],[117.09305572509766,13.97179889678955],[117.40470123291016,13.71973991394043],[117.71633911132812,13.467680931091309],[118.02798461914062,13.215621948242188],[118.3396224975586,12.963562965393066],[118.65131378173828,12.711464881896973],[118.96295928955078,12.459405899047852],[119.27460479736328,12.20734691619873],[119.58624267578125,11.95528793334961],[119.89793395996094,11.703189849853516],[120.20957946777344,11.451130867004395],[120.5212173461914,11.199071884155273],[120.8328628540039,10.947012901306152],[121.1445083618164,10.694953918457031],[121.45619201660156,10.442856788635254],[121.76783752441406,10.190796852111816],[122.07940673828125,9.93862533569336],[122.39093017578125,9.686413764953613],[122.70244598388672,9.434202194213867],[123.0140151977539,9.181953430175781],[123.32553100585938,8.929741859436035],[123.63705444335938,8.677530288696289],[123.94857025146484,8.42531967163086],[124.26009368896484,8.173108100891113],[124.5716552734375,7.920858383178711],[124.8831787109375,7.668647766113281],[125.1947021484375,7.416436195373535],[125.50621795654297,7.1642255783081055],[125.81774139404297,6.912014007568359],[126.12930297851562,6.659764289855957],[126.44082641601562,6.407553195953369],[126.7523422241211,6.155342102050781],[127.0638656616211,5.903131008148193],[127.37538146972656,5.6509199142456055],[127.68695068359375,5.398670196533203],[127.99847412109375,5.146459102630615],[128.30999755859375,4.894248008728027],[128.6215057373047,4.6420369148254395],[128.9333953857422,4.390189170837402],[129.25369262695312,4.1492919921875],[129.5856170654297,3.9246742725372314],[129.9283447265625,3.716902732849121],[130.28097534179688,3.526489496231079],[130.6426544189453,3.3537046909332275],[131.01231384277344,3.1988654136657715],[131.3890838623047,3.062161445617676],[131.77191162109375,2.9436819553375244],[132.15997314453125,2.843442678451538],[132.55235290527344,2.761474847793579],[132.94805908203125,2.6978096961975098],[133.34620666503906,2.6524102687835693],[133.74610900878906,2.6253018379211426],[134.14678955078125,2.616523265838623],[134.54751586914062,2.6261651515960693],[134.94729614257812,2.6545379161834717],[135.3452606201172,2.7018325328826904],[135.74044799804688,2.7685227394104004],[136.13169860839844,2.8552184104919434],[136.51780700683594,2.9629318714141846],[136.89698791503906,3.0926904678344727],[137.26719665527344,3.2460367679595947],[137.62576293945312,3.4249520301818848],[137.9689178466797,3.6319491863250732],[138.29107666015625,3.8700826168060303],[138.58433532714844,4.142958164215088],[138.86143493652344,4.432554721832275],[139.1418914794922,4.718858242034912],[139.42481994628906,5.002868175506592],[139.70947265625,5.285118579864502],[139.9952850341797,5.566064834594727],[140.28182983398438,5.846342086791992],[140.56881713867188,6.126155376434326],[140.85606384277344,6.405783176422119],[141.1432647705078,6.685368061065674],[141.43023681640625,6.965183258056641],[141.71685791015625,7.245351314544678],[142.00306701660156,7.525972366333008],[142.28863525390625,7.807310581207275],[142.57339477539062,8.089380264282227],[142.85719299316406,8.372440338134766],[143.1400146484375,8.656449317932129],[143.42156982421875,8.941767692565918],[143.70188903808594,9.228286743164062],[143.9808349609375,9.516157150268555],[144.258056640625,9.805658340454102],[144.53366088867188,10.096664428710938],[144.80738830566406,10.389402389526367],[145.0792236328125,10.684096336364746],[145.34869384765625,10.980795860290527],[145.61582946777344,11.279624938964844],[145.88037109375,11.580718994140625],[146.1421356201172,11.88435173034668],[146.40077209472656,12.190553665161133],[146.6561279296875,12.49952220916748],[146.9078369140625,12.811383247375488],[147.1555633544922,13.126524925231934],[147.39889526367188,13.445050239562988],[147.63743591308594,13.76718807220459],[147.87066650390625,14.09317398071289],[148.09799194335938,14.423237800598145],[148.3187713623047,14.757752418518066],[148.53225708007812,15.097033500671387],[148.73753356933594,15.44127082824707],[148.9334259033203,15.790952682495117],[149.11875915527344,16.146387100219727],[149.2918701171875,16.507827758789062],[149.45106506347656,16.87569236755371],[149.59552001953125,17.249544143676758],[149.728515625,17.627649307250977],[149.84996032714844,18.009624481201172],[149.9591827392578,18.39520263671875],[150.05593872070312,18.784238815307617],[150.13980102539062,19.176166534423828],[150.21047973632812,19.570688247680664],[150.26788330078125,19.967342376708984],[150.3120574951172,20.36577033996582],[150.34315490722656,20.765361785888672],[150.3614959716797,21.165721893310547],[150.367431640625,21.566490173339844],[150.3614959716797,21.96725845336914],[150.3443145751953,22.36773109436035],[150.31655883789062,22.767560958862305],[150.2790069580078,23.166654586791992],[150.23236083984375,23.564699172973633],[150.1773681640625,23.96170425415039],[150.11483764648438,24.35767936706543],[150.04554748535156,24.75244903564453],[149.9700927734375,25.146116256713867],[149.8893585205078,25.53874969482422],[149.80398559570312,25.930330276489258],[149.71449279785156,26.321115493774414],[149.6214599609375,26.71095085144043],[149.5254669189453,27.100088119506836],[149.42694091796875,27.488609313964844],[149.32635498046875,27.876630783081055],[149.21881103515625,28.26278305053711],[149.10324096679688,28.646535873413086],[148.9800567626953,29.027942657470703],[148.84959411621094,29.40692710876465],[148.71249389648438,29.7835693359375],[148.56924438476562,30.157976150512695],[148.42034912109375,30.530092239379883],[148.26608276367188,30.900028228759766],[148.1070556640625,31.26799774169922],[147.94369506835938,31.634061813354492],[147.7763214111328,31.998254776000977],[147.60536193847656,32.360801696777344],[147.4312744140625,32.721832275390625],[147.2542266845703,33.08138656616211],[147.07489013671875,33.43991470336914],[146.8934783935547,33.797332763671875],[146.71022033691406,34.15378952026367],[146.52565002441406,34.50957489013672],[146.33993530273438,34.86484146118164],[146.1533966064453,35.21967697143555],[145.9666748046875,35.57429122924805],[145.77976989746094,35.92884826660156],[145.59315490722656,36.2835693359375],[145.4069366455078,36.638519287109375],[145.2216339111328,36.994041442871094],[145.03768920898438,37.35013198852539],[144.85519409179688,37.70702362060547],[144.67465209960938,38.06486511230469],[144.49649047851562,38.423912048339844],[144.32070922851562,38.78419494628906],[144.14813232421875,39.145896911621094],[143.97886657714844,39.509281158447266],[143.8135223388672,39.87440490722656],[143.65240478515625,40.241432189941406],[143.49588012695312,40.610450744628906],[143.34449768066406,40.981563568115234],[143.19879150390625,41.3549690246582],[143.0591278076172,41.73066711425781],[142.92599487304688,42.108760833740234],[142.79991149902344,42.489200592041016],[142.6815643310547,42.87216567993164],[142.5713653564453,43.25755310058594],[142.46971130371094,43.64521408081055],[142.37745666503906,44.03532791137695],[142.294921875,44.427555084228516],[142.22279357910156,44.821815490722656],[142.16140747070312,45.217857360839844],[142.10812377929688,45.615081787109375],[142.06166076660156,46.013267517089844],[142.02195739746094,46.412105560302734],[141.9888916015625,46.81159210205078],[141.96217346191406,47.21149826049805],[141.9417724609375,47.61179733276367],[141.92764282226562,48.01242446899414],[141.9195098876953,48.413124084472656],[141.91737365722656,48.81393814086914],[141.92120361328125,49.21476364135742],[141.9307098388672,49.61540603637695],[141.94607543945312,50.01601028442383],[141.9670867919922,50.416263580322266],[141.9935760498047,50.81620407104492],[142.02577209472656,51.21575164794922],[142.06333923339844,51.61481475830078],[142.1063995361328,52.013328552246094],[142.15496826171875,52.41121292114258],[142.2087860107422,52.80839538574219],[142.26809692382812,53.20478439331055],[142.33273315429688,53.600406646728516],[142.40264892578125,53.99504470825195],[142.47804260253906,54.38873291015625],[142.55865478515625,54.78135681152344],[142.64471435546875,55.1728401184082],[142.73614501953125,55.5631217956543],[142.8328857421875,55.95212173461914],[142.93521118164062,56.33964920043945],[143.0429229736328,56.725711822509766],[143.15609741210938,57.110206604003906],[143.2749481201172,57.49301528930664],[143.3993682861328,57.87403869628906],[143.52940368652344,58.25321578979492],[143.66529846191406,58.630245208740234],[143.80697631835938,59.00517272949219],[143.9545440673828,59.377933502197266],[144.10818481445312,59.74808883666992],[144.26795959472656,60.1157112121582],[144.4339141845703,60.480567932128906],[144.60618591308594,60.84250259399414],[144.78497314453125,61.201229095458984],[144.9703826904297,61.55658721923828],[145.1625213623047,61.90830993652344],[145.361572265625,62.25621795654297],[145.5677032470703,62.60005187988281],[145.781005859375,62.93939208984375],[146.00167846679688,63.273956298828125],[146.2298583984375,63.60350799560547],[146.4651336669922,63.92793655395508],[146.7073974609375,64.24736022949219],[146.95620727539062,64.56156921386719],[147.21133422851562,64.8707046508789],[147.47244262695312,65.17479705810547],[147.73934936523438,65.47381591796875],[148.01165771484375,65.76782989501953],[148.2891845703125,66.05724334716797],[148.5713653564453,66.3418960571289],[148.858154296875,66.62175750732422],[149.14923095703125,66.89739990234375],[149.4442138671875,67.16866302490234],[149.74310302734375,67.43589782714844],[150.0452880859375,67.69921112060547],[150.3507080078125,67.95873260498047],[150.6591796875,68.2147445678711],[150.97019958496094,68.46741485595703],[151.283935546875,68.71697235107422],[151.59996032714844,68.963623046875],[151.91798400878906,69.20757293701172],[152.2379913330078,69.44902038574219],[152.55955505371094,69.68806457519531],[152.88287353515625,69.92523193359375],[153.20741271972656,70.16048431396484],[153.53309631347656,70.39395904541016],[153.8599090576172,70.62612915039062],[154.1874542236328,70.8570327758789],[154.5158233642578,71.0870132446289],[154.84487915039062,71.31605529785156],[155.17401123046875,71.54470825195312],[155.50367736816406,71.77281188964844],[155.83328247070312,72.00077819824219],[156.16299438476562,72.22880554199219],[156.49249267578125,72.45698547363281],[156.82171630859375,72.68550109863281],[157.1507110595703,72.91453552246094],[157.47906494140625,73.14439392089844],[157.80682373046875,73.37522888183594],[158.13372802734375,73.60713195800781],[158.45965576171875,73.84046936035156],[158.78445434570312,74.07527160644531],[159.10806274414062,74.3117446899414],[159.43055725097656,74.5499267578125],[159.75144958496094,74.79019165039062],[160.07054138183594,75.03260040283203],[160.38800048828125,75.27740478515625],[160.7034912109375,75.52459716796875],[161.0169677734375,75.7744140625],[161.32821655273438,76.02698516845703],[161.63702392578125,76.28252410888672],[161.9433135986328,76.54105377197266],[162.24685668945312,76.80267333984375],[162.5477294921875,77.06764221191406],[162.8456268310547,77.33598327636719],[163.1400909423828,77.60769653320312],[163.43185424804688,77.88263702392578],[163.72262573242188,78.15852355957031],[164.01243591308594,78.43534088134766],[164.3014678955078,78.71318817138672],[164.5894012451172,78.99185180664062],[164.87648010253906,79.27171325683594],[165.1622314453125,79.55281066894531],[165.4468231201172,79.83507537841797],[165.7301483154297,80.11856842041016],[166.01217651367188,80.40335083007812],[166.29290771484375,80.68956756591797],[166.57196044921875,80.97736358642578],[166.849365234375,81.26653289794922],[167.125244140625,81.55731964111328],[167.39939880371094,81.84967803955078],[167.67185974121094,82.1437759399414],[167.94244384765625,82.43959045410156],[168.2108154296875,82.7372055053711],[168.47718811035156,83.0367431640625],[168.74131774902344,83.33805847167969],[169.00326538085938,83.64161682128906],[169.26275634765625,83.94718170166016],[169.51966857910156,84.25469207763672],[169.77406311035156,84.56454467773438],[170.02549743652344,84.87653350830078],[170.27420043945312,85.19097137451172],[170.51986694335938,85.50776672363281],[170.76214599609375,85.8270034790039],[171.00120544433594,86.1488037109375],[171.23670959472656,86.47303771972656],[171.4684295654297,86.80021667480469],[171.69630432128906,87.13003540039062],[171.9200439453125,87.46250915527344],[172.13934326171875,87.79805755615234],[172.3541259765625,88.13641357421875],[172.56411743164062,88.47789001464844],[172.76889038085938,88.8224105834961],[172.96847534179688,89.17005157470703],[173.16212463378906,89.52095031738281],[173.3498992919922,89.87504577636719],[173.53126525878906,90.2325439453125],[173.70594787597656,90.59337615966797],[173.87339782714844,90.95742797851562],[174.03347778320312,91.3249282836914],[174.1854248046875,91.6957778930664],[174.32899475097656,92.07007598876953],[174.4635772705078,92.4476089477539],[174.5886993408203,92.82833099365234],[174.7039031982422,93.21234130859375],[174.80845642089844,93.59918212890625],[174.90194702148438,93.98892974853516],[174.98379516601562,94.38139343261719],[175.05337524414062,94.77603912353516],[175.111572265625,95.17268371582031],[175.16395568847656,95.57006072998047],[175.21095275878906,95.96802520751953],[175.25296020507812,96.36669921875],[175.28988647460938,96.7657470703125],[175.3221435546875,97.16532135009766],[175.34951782226562,97.56533813476562],[175.37245178222656,97.96544647216797],[175.39085388183594,98.36585235595703],[175.40487670898438,98.76640319824219],[175.41470336914062,99.1671371459961],[175.420166015625,99.56793212890625],[175.4215850830078,99.96873474121094],[175.4189910888672,100.36956787109375],[175.4122772216797,100.77027893066406],[175.4016571044922,101.17095947265625],[175.38722229003906,101.5716323852539],[175.3688201904297,101.97195434570312],[175.34658813476562,102.3721923828125],[175.3206329345703,102.77214813232422],[175.29090881347656,103.17185974121094],[175.2573699951172,103.57131958007812],[175.22012329101562,103.97037506103516],[175.17922973632812,104.369140625],[175.1345977783203,104.76741027832031],[175.08619689941406,105.16535949707031],[175.03414916992188,105.56288146972656],[174.97845458984375,105.95975494384766],[174.91897583007812,106.3561782836914],[174.85577392578125,106.75189208984375],[174.78884887695312,107.14716339111328],[174.7182159423828,107.54175567626953],[174.6437530517578,107.93549346923828],[174.56539916992188,108.32872009277344],[174.48330688476562,108.72098541259766],[174.39735412597656,109.1125259399414],[174.3073272705078,109.50310516357422],[174.21337890625,109.89275360107422],[174.11546325683594,110.28140258789062],[174.01344299316406,110.66901397705078],[173.90719604492188,111.05550384521484],[173.79678344726562,111.44090270996094],[173.68218994140625,111.82489013671875],[173.56301879882812,112.20771026611328],[173.43955993652344,112.58900451660156],[173.31155395507812,112.96883392333984],[173.17880249023438,113.3470458984375],[173.0414276123047,113.7236099243164],[172.8990936279297,114.09832763671875],[172.75186157226562,114.47102355957031],[172.5995635986328,114.84185791015625],[172.44187927246094,115.21041107177734],[172.279052734375,115.57666015625],[172.11044311523438,115.94027709960938],[171.93634033203125,116.30145263671875],[171.7560577392578,116.6593246459961],[171.5693817138672,117.01416015625],[171.37643432617188,117.3653335571289],[171.1774444580078,117.7134017944336],[170.97218322753906,118.05772399902344],[170.7612762451172,118.39842987060547],[170.54444885253906,118.73558044433594],[170.32191467285156,119.06896209716797],[170.09397888183594,119.39865112304688],[169.86074829101562,119.72473907470703],[169.62258911132812,120.04694366455078],[169.37928771972656,120.36557006835938],[169.13128662109375,120.68035125732422],[168.87867736816406,120.99163818359375],[168.62176513671875,121.29936218261719],[168.3607940673828,121.60350036621094],[168.0956268310547,121.90422821044922],[167.8268585205078,122.20142364501953],[167.55445861816406,122.49547576904297],[167.2786102294922,122.78645324707031],[166.99972534179688,123.07415771484375],[166.71763610839844,123.35899353027344],[166.43276977539062,123.64097595214844],[166.145263671875,123.92028045654297],[165.85523986816406,124.19707489013672],[165.56301879882812,124.47130584716797],[165.26853942871094,124.74322509765625],[164.9721221923828,125.01296997070312],[164.67379760742188,125.2807846069336],[164.37376403808594,125.54670715332031],[164.0723876953125,125.81085205078125],[163.76956176757812,126.07339477539062],[163.4654083251953,126.33446502685547],[163.16014099121094,126.59428405761719],[162.8539581298828,126.85292053222656],[162.5469512939453,127.11051940917969],[162.23899841308594,127.36724090576172],[161.93063354492188,127.6231918334961],[161.62176513671875,127.87877655029297],[161.3125,128.1338348388672],[161.0031280517578,128.3885040283203],[160.69345092773438,128.64306640625],[160.3838653564453,128.89755249023438],[160.07418823242188,129.15211486816406],[159.7647705078125,129.40704345703125],[159.45556640625,129.66197204589844],[159.14688110351562,129.91773986816406],[158.83843994140625,130.17359924316406],[158.53054809570312,130.430419921875],[158.22341918945312,130.68800354003906],[157.91712951660156,130.94647216796875],[157.6116485595703,131.20599365234375],[157.30703735351562,131.4666748046875],[157.00360107421875,131.728515625],[156.70127868652344,131.9916534423828],[156.40025329589844,132.25616455078125],[156.1004180908203,132.5222625732422],[155.802001953125,132.7899627685547],[155.5051727294922,133.0592041015625],[155.20982360839844,133.330322265625],[154.91708374023438,133.60400390625],[154.62771606445312,133.8814697265625],[154.34194946289062,134.16249084472656],[154.05967712402344,134.44703674316406],[153.7808380126953,134.73504638671875],[153.50555419921875,135.0262908935547],[153.23362731933594,135.32086181640625],[152.9651336669922,135.61854553222656],[152.7001495361328,135.919189453125],[152.43849182128906,136.2228546142578],[152.18028259277344,136.52931213378906],[151.9254150390625,136.8386993408203],[151.67385864257812,137.15086364746094],[151.4256591796875,137.465576171875],[151.1807403564453,137.78282165527344],[150.93910217285156,138.10256958007812],[150.70059204101562,138.4248809814453],[150.46534729003906,138.74945068359375],[150.23336791992188,139.0762176513672],[150.00448608398438,139.40528869628906],[149.77886962890625,139.73646545410156],[149.5563201904297,140.0699005126953],[149.3369140625,140.40541076660156],[149.1206512451172,140.74276733398438],[148.90736389160156,141.0821990966797],[148.69711303710938,141.42347717285156],[148.4899444580078,141.76658630371094],[148.28573608398438,142.11151123046875],[148.0845184326172,142.45814514160156],[147.8862762451172,142.80661010742188],[147.69110107421875,143.15664672851562],[147.49879455566406,143.50839233398438],[147.3094482421875,143.8616485595703],[147.1230010986328,144.21641540527344],[146.9393768310547,144.57284545898438],[146.75872802734375,144.93052673339844],[146.5808868408203,145.28982543945312],[146.40589904785156,145.6505126953125],[146.23387145996094,146.0124053955078],[146.06460571289062,146.3758544921875],[145.8983154296875,146.74037170410156],[145.73471069335938,147.1064453125],[145.573974609375,147.4736328125],[145.4160919189453,147.84197998046875],[145.26097106933594,148.21160888671875],[145.108642578125,148.58245849609375],[144.95919799804688,148.95433044433594],[144.81253051757812,149.32733154296875],[144.66868591308594,149.70143127441406],[144.52760314941406,150.07672119140625],[144.38938903808594,150.4530029296875],[144.2541046142578,150.83021545410156],[144.12156677246094,151.20852661132812],[143.991943359375,151.5877685546875],[143.86512756347656,151.9680633544922],[143.74122619628906,152.34922790527344],[143.62022399902344,152.73126220703125],[143.50209045410156,153.11436462402344],[143.38690185546875,153.49819946289062],[143.27462768554688,153.88311767578125],[143.16537475585938,154.2687225341797],[143.0591278076172,154.65516662597656],[142.9558563232422,155.0425567626953],[142.85572814941406,155.43052673339844],[142.75865173339844,155.81951904296875],[142.66473388671875,156.20925903320312],[142.5747528076172,156.59983825683594],[142.4913787841797,156.99192810058594],[142.41525268554688,157.3853302001953],[142.34573364257812,157.7801055908203],[142.28294372558594,158.17599487304688],[142.22653198242188,158.5728302001953],[142.17633056640625,158.9705352783203],[142.13232421875,159.3688201904297],[142.09408569335938,159.7678985595703],[142.0618438720703,160.16751098632812],[142.03515625,160.56732177734375],[142.013916015625,160.9676513671875],[141.99832153320312,161.36814880371094],[141.98789978027344,161.768798828125],[141.9826202392578,162.169677734375],[141.98265075683594,162.5704345703125],[141.98764038085938,162.97128295898438],[141.99752807617188,163.3719024658203],[142.0123291015625,163.77252197265625],[142.0320281982422,164.17291259765625],[142.056396484375,164.5729217529297],[142.0854034423828,164.97279357910156],[142.11917114257812,165.3720245361328],[142.1575927734375,165.77105712890625],[142.2005157470703,166.16966247558594],[142.24789428710938,166.567626953125],[142.2999267578125,166.96514892578125],[142.35641479492188,167.3618927001953],[142.41734313964844,167.7581024169922],[142.482666015625,168.15362548828125],[142.55245971679688,168.5482635498047],[142.6267547607422,168.94212341308594],[142.70542907714844,169.33526611328125],[142.78848266601562,169.72731018066406],[142.87600708007812,170.1185302734375],[142.9680633544922,170.50851440429688],[143.06459045410156,170.8976287841797],[143.16549682617188,171.2855224609375],[143.2708740234375,171.6721954345703],[143.38099670410156,172.0576934814453],[143.49557495117188,172.44166564941406],[143.61473083496094,172.8243865966797],[143.73858642578125,173.20571899414062],[143.86720275878906,173.58526611328125],[144.00051879882812,173.9632568359375],[144.13858032226562,174.33953857421875],[144.28163146972656,174.71397399902344],[144.42965698242188,175.08660888671875],[144.58253479003906,175.45703125],[144.7406463623047,175.825439453125],[144.9038543701172,176.1913604736328],[145.07232666015625,176.55519104003906],[145.2462158203125,176.9163360595703],[145.42552185058594,177.27476501464844],[145.61032104492188,177.63050842285156],[145.80081176757812,177.98304748535156],[145.99539184570312,178.3336181640625],[146.19300842285156,178.68228149414062],[146.39395141601562,179.02908325195312],[146.5980224609375,179.37405395507812],[146.8052520751953,179.7171173095703],[147.01573181152344,180.0582733154297],[147.2294921875,180.39747619628906],[147.4462890625,180.7344512939453],[147.66639709472656,181.06959533691406],[147.88967895507812,181.40228271484375],[148.1162872314453,181.73300170898438],[148.34608459472656,182.06143188476562],[148.5790557861328,182.38751220703125],[148.81552124023438,182.7113037109375],[149.05511474609375,183.03256225585938],[149.2980194091797,183.35145568847656],[149.5443115234375,183.66773986816406],[149.7938995361328,183.9813232421875],[150.04676818847656,184.292236328125],[150.30299377441406,184.6003875732422],[150.5628204345703,184.9057159423828],[150.82601928710938,185.2081756591797],[151.09242248535156,185.50750732421875],[151.3625030517578,185.8037567138672],[151.63587951660156,186.0966796875],[151.91282653808594,186.3865203857422],[152.19342041015625,186.67294311523438],[152.47738647460938,186.95570373535156],[152.7649383544922,187.2350311279297],[153.05606079101562,187.5105743408203],[153.35073852539062,187.78219604492188],[153.6490020751953,188.05003356933594],[153.9508056640625,188.31361389160156],[154.25637817382812,188.5731201171875],[154.56553649902344,188.8284149169922],[154.8782196044922,189.07896423339844],[155.19467163085938,189.3250274658203],[155.5146484375,189.5664520263672],[155.83843994140625,189.80276489257812],[156.1657257080078,190.03411865234375],[156.49658203125,190.26022338867188],[156.8312225341797,190.48095703125],[157.1692352294922,190.69622802734375],[157.51107788085938,190.90567016601562],[157.85641479492188,191.10939025878906],[158.205078125,191.30691528320312],[158.5573272705078,191.4982147216797],[158.9127655029297,191.6831817626953],[159.27186584472656,191.8614501953125],[159.63412475585938,192.03314208984375],[159.9995880126953,192.1976318359375],[160.36813354492188,192.35516357421875],[160.73968505859375,192.50527954101562],[161.11427307128906,192.6479949951172],[161.49168395996094,192.78334045410156],[161.87136840820312,192.9116668701172],[162.253173828125,193.03367614746094],[162.6367950439453,193.14968872070312],[163.0221405029297,193.26002502441406],[163.4091033935547,193.36492919921875],[163.7972412109375,193.46453857421875],[164.18679809570312,193.55926513671875],[164.57720947265625,193.64932250976562],[164.9688262939453,193.735107421875],[165.36129760742188,193.8167724609375],[165.7544708251953,193.89456176757812],[166.1483612060547,193.96875],[166.54290771484375,194.03956604003906],[166.9380340576172,194.10720825195312],[167.3336181640625,194.17190551757812],[167.72959899902344,194.23358154296875],[168.12600708007812,194.29302978515625],[168.52272033691406,194.3501739501953],[168.91973876953125,194.40518188476562],[169.31707763671875,194.458251953125],[169.714599609375,194.50958251953125],[170.11233520507812,194.55935668945312],[170.51014709472656,194.60772705078125],[170.90821838378906,194.65489196777344],[171.3065185546875,194.7008056640625],[171.7047119140625,194.74609375],[172.10313415527344,194.7906951904297],[172.5015869140625,194.83473205566406],[172.89988708496094,194.87843322753906],[173.2984161376953,194.92185974121094],[173.69686889648438,194.96530151367188],[174.0953826904297,195.0087890625],[174.4937744140625,195.0526123046875],[174.89208984375,195.09677124023438],[175.29049682617188,195.14161682128906],[175.68865966796875,195.18714904785156],[176.08688354492188,195.2333526611328],[176.48487854003906,195.28085327148438],[176.88265991210938,195.32960510253906],[177.2803955078125,195.37977600097656],[177.6778564453125,195.43148803710938],[178.0751190185547,195.48500061035156],[178.47213745117188,195.54042053222656],[178.86878967285156,195.5979461669922],[179.26516723632812,195.657470703125],[179.66104125976562,195.71974182128906],[180.0565948486328,195.78468322753906],[180.4517364501953,195.8525390625],[180.84616088867188,195.9233856201172],[181.24012756347656,195.99757385253906],[181.63330078125,196.07522583007812],[182.02577209472656,196.1565704345703],[182.41754150390625,196.24185180664062],[182.8081817626953,196.3312225341797],[183.19798278808594,196.4250030517578],[183.58645629882812,196.52334594726562],[183.97384643554688,196.62657165527344],[184.3597869873047,196.73483276367188],[184.74411010742188,196.84841918945312],[185.1267852783203,196.9675750732422],[185.50755310058594,197.09266662597656],[185.88632202148438,197.22390747070312],[186.2621612548828,197.36349487304688],[186.63417053222656,197.5123291015625],[187.00296020507812,197.6697540283203],[187.3679656982422,197.8349151611328],[187.72976684570312,198.00772094726562],[188.08811950683594,198.18728637695312],[188.44317626953125,198.37332153320312],[188.7949676513672,198.56539916992188],[189.1434783935547,198.76318359375],[189.48895263671875,198.96653747558594],[189.83140563964844,199.175048828125],[190.17062377929688,199.38836669921875],[190.5069580078125,199.6064453125],[190.8402862548828,199.82899475097656],[191.17071533203125,200.05584716796875],[191.49838256835938,200.28695678710938],[191.82301330566406,200.52191162109375],[192.14491271972656,200.7608642578125],[192.4639434814453,201.00355529785156],[192.7799530029297,201.25006103515625],[193.09339904785156,201.4998016357422],[193.4038848876953,201.75323486328125],[193.71173095703125,202.010009765625],[194.01678466796875,202.2701873779297],[194.31878662109375,202.5334930419922],[194.6182098388672,202.80003356933594],[194.9145050048828,203.06996154785156],[195.2081756591797,203.3427276611328],[195.4986114501953,203.61900329589844],[195.7862548828125,203.89805603027344],[196.07083129882812,204.1804962158203],[196.352294921875,204.46583557128906],[196.63058471679688,204.75428771972656],[196.90565490722656,205.04588317871094],[197.177490234375,205.34042358398438],[197.44577026367188,205.63815307617188],[197.7105255126953,205.93905639648438],[197.97171020507812,206.2432403564453],[198.22897338867188,206.55055236816406],[198.48233032226562,206.86114501953125],[198.73153686523438,207.17510986328125],[198.9763641357422,207.49232482910156],[199.21730041503906,207.81271362304688],[199.45545959472656,208.1351776123047],[199.6907196044922,208.4595947265625],[199.92323303222656,208.78611755371094],[200.1532440185547,209.11441040039062],[200.3807373046875,209.4443817138672],[200.6057586669922,209.77622985839844],[200.82846069335938,210.10940551757812],[201.04898071289062,210.44410705566406],[201.26722717285156,210.7802276611328],[201.48362731933594,211.1177215576172],[201.69802856445312,211.4564208984375],[201.91043090820312,211.79623413085938],[202.12100219726562,212.1373748779297],[202.33006286621094,212.47926330566406],[202.53770446777344,212.82223510742188],[202.743896484375,213.16603088378906],[202.94833374023438,213.51072692871094],[203.15151977539062,213.85623168945312],[203.35353088378906,214.20236206054688],[203.55447387695312,214.54917907714844],[203.75448608398438,214.89669799804688],[203.95327758789062,215.2446746826172],[204.15118408203125,215.59326171875],[204.34828186035156,215.94216918945312],[204.54478454589844,216.29164123535156],[204.74058532714844,216.6414337158203],[204.9354705810547,216.9916229248047],[205.13040161132812,217.34190368652344],[205.32456970214844,217.6925506591797],[205.51829528808594,218.0433807373047],[205.7120819091797,218.39430236816406],[205.9058074951172,218.74513244628906],[206.09959411621094,219.09605407714844],[206.29330444335938,219.44708251953125],[206.48687744140625,219.79800415039062],[206.6805877685547,220.14894104003906],[206.8747100830078,220.49954223632812],[207.06890869140625,220.85023498535156],[207.2637939453125,221.2005157470703],[207.45896911621094,221.550537109375],[207.65443420410156,221.90054321289062],[207.8507080078125,222.2499542236328],[208.0479278564453,222.59898376464844],[208.2459259033203,222.94760131835938],[208.4447021484375,223.29559326171875],[208.64442443847656,223.64317321777344],[208.8450927734375,223.99008178710938],[209.0471954345703,224.3362274169922],[209.2505340576172,224.6817626953125],[209.4550018310547,225.02638244628906],[209.66091918945312,225.3704071044922],[209.8681182861328,225.71337890625],[210.07717895507812,226.055419921875],[210.28781127929688,226.39654541015625],[210.5000762939453,226.7363739013672],[210.71446228027344,227.0751953125],[210.93060302734375,227.41261291503906],[211.14883422851562,227.7489776611328],[211.36929321289062,228.08375549316406],[211.59182739257812,228.41697692871094],[211.81666564941406,228.7488250732422],[212.0440673828125,229.07884216308594],[212.2739715576172,229.40725708007812],[212.50640869140625,229.73391723632812],[212.74159240722656,230.05836486816406],[212.97962951660156,230.3809356689453],[213.22042846679688,230.70135498046875],[213.46437072753906,231.01943969726562],[213.71141052246094,231.33509826660156],[213.9615020751953,231.6482696533203],[214.21495056152344,231.95889282226562],[214.4718017578125,232.2664031982422],[214.73219299316406,232.57125854492188],[214.99603271484375,232.87306213378906],[215.2635040283203,233.17144775390625],[215.53488159179688,233.46649169921875],[215.80987548828125,233.75796508789062],[216.08981323242188,234.04501342773438],[216.37496948242188,234.3267059326172],[216.6648712158203,234.60330200195312],[216.9598388671875,234.87484741210938],[217.25942993164062,235.1412353515625],[217.56338500976562,235.4023895263672],[217.87181091308594,235.65835571289062],[218.18435668945312,235.90931701660156],[218.50112915039062,236.15493774414062],[218.8217315673828,236.39559936523438],[219.1460723876953,236.63099670410156],[219.4741668701172,236.86141967773438],[219.80551147460938,237.08665466308594],[220.1405029296875,237.30691528320312],[220.4786376953125,237.5223388671875],[220.81980895996094,237.73245239257812],[221.16403198242188,237.9378204345703],[221.51113891601562,238.13827514648438],[221.86109924316406,238.33384704589844],[222.213623046875,238.5247039794922],[222.56866455078125,238.71054077148438],[222.92613220214844,238.89175415039062],[223.28599548339844,239.06829833984375],[223.64816284179688,239.24012756347656],[224.01239013671875,239.4074249267578],[224.37879943847656,239.5700225830078],[224.74710083007812,239.72811889648438],[225.1172637939453,239.8817596435547],[225.4893341064453,240.0308380126953],[225.8632049560547,240.1756591796875],[226.23855590820312,240.3159637451172],[226.61569213867188,240.45196533203125],[226.99411010742188,240.58372497558594],[227.37425231933594,240.7111358642578],[227.7556915283203,240.8343505859375],[228.13832092285156,240.95338439941406],[228.5224151611328,241.06813049316406],[228.90768432617188,241.17886352539062],[229.2941131591797,241.28550720214844],[229.6815643310547,241.38796997070312],[230.07008361816406,241.4864501953125],[230.45970153808594,241.58087158203125],[230.8500518798828,241.67124938964844],[231.24147033691406,241.7577667236328],[231.6338653564453,241.8402099609375],[232.0268096923828,241.918701171875],[232.420654296875,241.9933624267578],[232.8152313232422,242.0640106201172],[233.21047973632812,242.13082885742188],[233.60638427734375,242.19371032714844],[234.0027313232422,242.252685546875],[234.39974975585938,242.30789184570312],[234.7972869873047,242.3590850830078],[235.19546508789062,242.406005859375],[235.5940704345703,242.4475860595703],[235.9932098388672,242.4838409423828],[236.3928680419922,242.51480102539062],[236.79298400878906,242.540771484375],[237.19313049316406,242.5618438720703],[237.5936279296875,242.5781707763672],[237.99429321289062,242.58984375],[238.39512634277344,242.5968475341797],[238.79595947265625,242.5994873046875],[239.19664001464844,242.59791564941406],[239.59750366210938,242.59222412109375],[239.9981231689453,242.58253479003906],[240.39886474609375,242.5689697265625],[240.79931640625,242.55154418945312],[241.19952392578125,242.53050231933594],[241.5996551513672,242.50596618652344],[241.99937438964844,242.4780731201172],[242.3991241455078,242.44664001464844],[242.79844665527344,242.41229248046875],[243.1974334716797,242.3749237060547],[243.59628295898438,242.33462524414062],[243.99472045898438,242.29150390625],[244.39295959472656,242.24569702148438],[244.79098510742188,242.19725036621094],[245.18841552734375,242.14634704589844],[245.58570861816406,242.093017578125],[245.98268127441406,242.03741455078125],[246.3793487548828,241.97959899902344],[246.77566528320312,241.919677734375],[247.17166137695312,241.8577117919922],[247.5673370361328,241.79380798339844],[247.96270751953125,241.72811889648438],[248.3578338623047,241.66067504882812],[248.75271606445312,241.59161376953125],[249.14730834960938,241.52101135253906],[249.54156494140625,241.44895935058594],[249.93551635742188,241.3755645751953],[250.32949829101562,241.30084228515625],[250.7230682373047,241.22494506835938],[251.11634826660156,241.14794921875],[251.50953674316406,241.06968688964844],[251.90243530273438,240.99072265625],[252.29527282714844,240.91085815429688],[252.68797302246094,240.8302764892578],[253.0803985595703,240.74891662597656],[253.4728240966797,240.6670379638672],[253.8649444580078,240.58450317382812],[254.2571563720703,240.5016326904297],[254.6492462158203,240.41807556152344],[255.04116821289062,240.3343505859375],[255.43319702148438,240.25059509277344],[255.82522583007812,240.16683959960938],[256.2171325683594,240.08294677734375],[256.609130859375,239.9990234375],[257.0010070800781,239.91513061523438],[257.39300537109375,239.831298828125],[257.78515625,239.7480010986328],[258.1771240234375,239.6649627685547],[258.5694274902344,239.58250427246094],[258.96160888671875,239.4999237060547],[259.3534240722656,239.41549682617188],[259.7447509765625,239.32815551757812],[260.13525390625,239.23805236816406],[260.5252685546875,239.14544677734375],[260.9145202636719,239.0502471923828],[261.3033752441406,238.9526824951172],[261.69158935546875,238.85292053222656],[262.0790710449219,238.75071716308594],[262.4661865234375,238.64662170410156],[262.85272216796875,238.54075622558594],[263.2389221191406,238.43313598632812],[263.6246337890625,238.32386779785156],[264.0096130371094,238.21267700195312],[264.3943786621094,238.10003662109375],[264.7786560058594,237.9861602783203],[265.16259765625,237.8710479736328],[265.5462951660156,237.7547607421875],[265.9294128417969,237.63719177246094],[266.3123779296875,237.5186767578125],[266.6949157714844,237.39939880371094],[267.0773620605469,237.27932739257812],[267.4596252441406,237.1585693359375],[267.84149169921875,237.0367889404297],[268.2234191894531,236.9149932861328],[268.6050720214844,236.792724609375],[268.9866638183594,236.66989135742188],[269.3682556152344,236.54705810546875],[269.7497253417969,236.42425537109375],[270.1313171386719,236.30142211914062],[270.5128479003906,236.17869567871094],[270.8945007324219,236.0560302734375],[271.2761535644531,235.93338012695312],[271.657958984375,235.81163024902344],[272.0399169921875,235.68988037109375],[272.4218444824219,235.56866455078125],[272.8041687011719,235.44818115234375],[273.18670654296875,235.32839965820312],[273.5695495605469,235.20968627929688],[273.9526672363281,235.09185791015625],[274.3360290527344,234.9750518798828],[274.71990966796875,234.85926818847656],[275.10406494140625,234.7447052001953],[275.48858642578125,234.63185119628906],[275.87359619140625,234.5203857421875],[276.2591247558594,234.410400390625],[276.64495849609375,234.3020477294922],[277.0313720703125,234.19537353515625],[277.4183044433594,234.09100341796875],[277.8058776855469,233.98834228515625],[278.1939392089844,233.8878936767578],[278.58245849609375,233.7899627685547],[278.97174072265625,233.69422912597656],[279.3615417480469,233.60107421875],[279.7520751953125,233.51065063476562],[280.1432800292969,233.42286682128906],[280.5349426269531,233.33811950683594],[280.9273986816406,233.2564239501953],[281.3203125,233.17779541015625],[281.7141418457031,233.10260009765625],[282.1085510253906,233.03086853027344],[282.5034484863281,232.96263122558594],[282.89910888671875,232.8982696533203],[283.2952880859375,232.83782958984375],[283.692138671875,232.78126525878906],[284.0896301269531,232.72903442382812],[284.4874267578125,232.68121337890625],[284.885986328125,232.63768005371094],[285.2848205566406,232.59889221191406],[285.6843566894531,232.56503295898438],[286.08416748046875,232.53594970703125],[286.48419189453125,232.51190185546875],[286.8846130371094,232.4933624267578],[287.28515625,232.48007202148438],[287.6858825683594,232.4721221923828],[288.08685302734375,232.47021484375],[288.4875793457031,232.4739990234375],[288.8883361816406,232.48353576660156],[289.28875732421875,232.49929809570312],[289.6890869140625,232.51966857910156],[290.0893859863281,232.54200744628906],[290.4893493652344,232.5662078857422],[290.889404296875,232.59230041503906],[291.2891845703125,232.62045288085938],[291.6888732910156,232.6510009765625],[292.0885009765625,232.68348693847656],[292.4877014160156,232.71786499023438],[292.88690185546875,232.7542266845703],[293.2857971191406,232.79269409179688],[293.6846008300781,232.83364868164062],[294.0831604003906,232.87657165527344],[294.4814147949219,232.9211883544922],[294.8795471191406,232.96827697753906],[295.2773132324219,233.0175323486328],[295.6748046875,233.06900024414062],[296.0721740722656,233.12261962890625],[296.46893310546875,233.17852783203125],[296.86566162109375,233.2365264892578],[297.261962890625,233.2969512939453],[297.65777587890625,233.3594512939453],[298.05340576171875,233.4243927001953],[298.4484558105469,233.4915313720703],[298.8432922363281,233.56103515625],[299.23760986328125,233.6328887939453],[299.6314392089844,233.70701599121094],[300.0249328613281,233.78366088867188],[300.4179382324219,233.86251831054688],[300.8104553222656,233.94403076171875],[301.202392578125,234.02774047851562],[301.59375,234.1141357421875],[301.9847106933594,234.20286560058594],[302.37493896484375,234.29415893554688],[302.7646179199219,234.38792419433594],[303.15380859375,234.48431396484375],[303.5421142578125,234.5832061767578],[303.92999267578125,234.68470764160156],[304.31695556640625,234.78884887695312],[304.7033996582031,234.89553833007812],[305.0890197753906,235.0050811767578],[305.4737854003906,235.11703491210938],[305.8578796386719,235.2320098876953],[306.2409973144531,235.34939575195312],[306.6234130859375,235.46986389160156],[307.0048828125,235.5928497314453],[307.3853454589844,235.71881103515625],[307.7650146484375,235.84747314453125],[308.1435852050781,235.97909545898438],[308.5212097167969,236.11351013183594],[308.8977966308594,236.2509002685547],[309.27325439453125,236.3911590576172],[309.64764404296875,236.53431701660156],[310.0207824707031,236.6805419921875],[310.3929443359375,236.82969665527344],[310.7637023925781,236.98199462890625],[311.1332702636719,237.13711547851562],[311.50146484375,237.2955322265625],[311.8683776855469,237.45675659179688],[312.2337951660156,237.6214141845703],[312.59808349609375,237.78897094726562],[312.9605712890625,237.95986938476562],[313.32171630859375,238.13372802734375],[313.6811828613281,238.3109588623047],[314.0391845703125,238.4912872314453],[314.3954772949219,238.6749267578125],[314.7500915527344,238.8617401123047],[315.10296630859375,239.05186462402344],[315.4539794921875,239.24526977539062],[315.8033447265625,239.4419708251953],[316.15069580078125,239.64210510253906],[316.4960021972656,239.8452911376953],[316.8394470214844,240.05209350585938],[317.180908203125,240.2620849609375],[317.5201110839844,240.47564697265625],[317.8573303222656,240.6922607421875],[318.192138671875,240.91262817382812],[318.52490234375,241.13607788085938],[318.855224609375,241.36328125],[319.1831970214844,241.5934600830078],[319.50872802734375,241.82740783691406],[319.8318786621094,242.06455993652344],[320.15240478515625,242.30528259277344],[320.4704895019531,242.54934692382812],[320.7850036621094,242.79759216308594],[321.0958557128906,243.0507049560547],[321.40277099609375,243.308349609375],[321.7060241699219,243.57061767578125],[322.0054931640625,243.83717346191406],[322.3010559082031,244.10763549804688],[322.5931396484375,244.38223266601562],[322.8815002441406,244.6605224609375],[323.16644287109375,244.9425506591797],[323.4478759765625,245.22804260253906],[323.72576904296875,245.51675415039062],[324.00042724609375,245.80877685546875],[324.27166748046875,246.10374450683594],[324.5398864746094,246.4017791748047],[324.80487060546875,246.70248413085938],[325.0667724609375,247.0059051513672],[325.32574462890625,247.3119354248047],[325.5816955566406,247.6201934814453],[325.83502197265625,247.9308624267578],[326.0856628417969,248.24374389648438],[326.3336181640625,248.55859375],[326.5791931152344,248.87554931640625],[326.8221435546875,249.1941375732422],[327.0628662109375,249.5146942138672],[327.30126953125,249.8369598388672],[327.5375061035156,250.1606903076172],[327.7717590332031,250.4860382080078],[328.00396728515625,250.81263732910156],[328.2344055175781,251.1406707763672],[328.463134765625,251.47000122070312],[328.6899719238281,251.80026245117188],[328.9153747558594,252.13177490234375],[329.13922119140625,252.4641571044922],[329.36175537109375,252.79769897460938],[329.5829162597656,253.13201904296875],[329.8028259277344,253.467041015625],[330.02154541015625,253.802978515625],[330.2391662597656,254.13955688476562],[330.4558410644531,254.47679138183594],[330.6717224121094,254.81463623046875],[330.886474609375,255.15293884277344],[331.10089111328125,255.4916534423828],[331.3147888183594,255.83074951171875],[331.5279235839844,256.1701354980469],[331.74090576171875,256.5097351074219],[331.9532165527344,256.8496398925781],[332.1655578613281,257.1896057128906],[332.3775634765625,257.5298156738281],[332.58953857421875,257.86993408203125],[332.8015441894531,258.2101745605469],[333.01348876953125,258.55029296875],[333.2258605957031,258.89031982421875],[333.4383544921875,259.230224609375],[333.6512451171875,259.56982421875],[333.8646240234375,259.9091796875],[334.0783386230469,260.2481994628906],[334.2930603027344,260.58673095703125],[334.5078430175781,260.92510986328125],[334.72381591796875,261.2627868652344],[334.9407653808594,261.59991455078125],[335.1585998535156,261.9361877441406],[335.3776550292969,262.27197265625],[335.5978698730469,262.6069641113281],[335.81927490234375,262.9409484863281],[336.0421142578125,263.2742004394531],[336.266357421875,263.60638427734375],[336.4921875,263.9375915527344],[336.7196350097656,264.26763916015625],[336.94830322265625,264.5968017578125],[337.1763000488281,264.9263916015625],[337.4020080566406,265.2576904296875],[337.6258239746094,265.5901794433594],[337.84765625,265.92413330078125],[338.0675048828125,266.2591247558594],[338.28564453125,266.595458984375],[338.5019836425781,266.932861328125],[338.7168884277344,267.271240234375],[338.930419921875,267.610595703125],[339.14227294921875,267.95074462890625],[339.3526306152344,268.2919921875],[339.5617370605469,268.6337585449219],[339.7698974609375,268.9764404296875],[339.9768371582031,269.31976318359375],[340.1824035644531,269.66375732421875],[340.3872375488281,270.0084228515625],[340.5911560058594,270.35345458984375],[340.7942810058594,270.6990661621094],[340.9964599609375,271.0451354980469],[341.1979675292969,271.3915100097656],[341.39892578125,271.7383728027344],[341.5990295410156,272.0856018066406],[341.7992248535156,272.4328918457031],[341.9988708496094,272.78057861328125],[342.1980285644531,273.12835693359375],[342.39727783203125,273.4762268066406],[342.5961608886719,273.8243408203125],[342.7948913574219,274.1723327636719],[342.99371337890625,274.52044677734375],[343.1924743652344,274.8684387207031],[343.39129638671875,275.216552734375],[343.5904846191406,275.5644226074219],[343.78985595703125,275.9120788574219],[343.9892883300781,276.25982666015625],[344.1896667480469,276.6068420410156],[344.3902282714844,276.9539489746094],[344.5910339355469,277.30084228515625],[344.79266357421875,277.6471862792969],[344.9952392578125,277.9931945800781],[345.19842529296875,278.338623046875],[345.4023742675781,278.68365478515625],[345.6072998046875,279.0281982421875],[345.8133544921875,279.3719177246094],[346.0204162597656,279.7151794433594],[346.22845458984375,280.0577697753906],[346.4377746582031,280.399658203125],[346.6485900878906,280.7405700683594],[346.8606262207031,281.0806579589844],[347.0740051269531,281.4200134277344],[347.2887878417969,281.7583312988281],[347.505615234375,282.0955505371094],[347.72393798828125,282.4317932128906],[347.943603515625,282.76702880859375],[348.165283203125,283.1009521484375],[348.3890075683594,283.4334716796875],[348.6146240234375,283.7648620605469],[348.8424072265625,284.0947570800781],[349.0720520019531,284.4230651855469],[349.30419921875,284.74993896484375],[349.5384216308594,285.07513427734375],[349.775146484375,285.398681640625],[350.01422119140625,285.7204284667969],[350.25579833984375,286.04022216796875],[350.5000305175781,286.35809326171875],[350.7467041015625,286.6738586425781],[350.99639892578125,286.9875793457031],[351.24859619140625,287.29913330078125],[351.5039367675781,287.6080322265625],[351.76202392578125,287.9148254394531],[352.0231628417969,288.21881103515625],[352.2873840332031,288.52020263671875],[352.5547180175781,288.81890869140625],[352.82525634765625,289.11456298828125],[353.09893798828125,289.4075622558594],[353.3760681152344,289.697021484375],[353.65643310546875,289.9835205078125],[353.94036865234375,290.2665100097656],[354.22760009765625,290.5460205078125],[354.518310546875,290.8219909667969],[354.81268310546875,291.0940856933594],[355.1102600097656,291.362548828125],[355.4118347167969,291.626708984375],[355.71661376953125,291.8868408203125],[356.0248718261719,292.1432189941406],[356.33416748046875,292.3981628417969],[356.6441955566406,292.6521911621094],[356.9550476074219,292.9052734375],[357.2666015625,293.1572265625],[357.5792541503906,293.4082336425781],[357.892822265625,293.6580810546875],[358.20709228515625,293.9065246582031],[358.52264404296875,294.1539001464844],[358.8390197753906,294.3998107910156],[359.15667724609375,294.64434814453125],[359.4754943847656,294.88739013671875],[359.79534912109375,295.1288146972656],[360.1165466308594,295.3687438964844],[360.43890380859375,295.60693359375],[360.7625427246094,295.8433837890625],[361.0874938964844,296.07806396484375],[361.41375732421875,296.3108215332031],[361.7415466308594,296.54168701171875],[362.0705871582031,296.77044677734375],[362.40118408203125,296.9972229003906],[362.7332763671875,297.22174072265625],[363.0667419433594,297.4439392089844],[363.40185546875,297.66387939453125],[363.7384033203125,297.8814392089844],[364.07684326171875,298.0963134765625],[364.416748046875,298.30877685546875],[364.75836181640625,298.51837158203125],[365.101806640625,298.7251892089844],[365.4468688964844,298.9290466308594],[365.79376220703125,299.1299133300781],[366.1424560546875,299.3277587890625],[366.4928283691406,299.5223388671875],[366.8450622558594,299.713623046875],[367.1990966796875,299.9014892578125],[367.5550231933594,300.0859069824219],[367.912841796875,300.26666259765625],[368.2723388671875,300.443603515625],[368.6339416503906,300.6168212890625],[368.9972229003906,300.78582763671875],[369.3626403808594,300.9508056640625],[369.7298889160156,301.1115417480469],[370.098876953125,301.2678527832031],[370.4698791503906,301.41973876953125],[370.842529296875,301.5669860839844],[371.2171936035156,301.7095031738281],[371.5937805175781,301.84722900390625],[371.971923828125,301.9798583984375],[372.3519592285156,302.10736083984375],[372.7337951660156,302.2296142578125],[373.11712646484375,302.3464050292969],[373.5021667480469,302.45770263671875],[373.8888244628906,302.5632629394531],[374.2771301269531,302.66302490234375],[374.6668701171875,302.7568359375],[375.05780029296875,302.8445739746094],[375.4502868652344,302.9261779785156],[375.8439025878906,303.0014953613281],[376.23883056640625,303.0704345703125],[376.6347351074219,303.13287353515625],[377.0315856933594,303.188720703125],[377.42950439453125,303.2378845214844],[377.82794189453125,303.2802429199219],[378.227294921875,303.3157958984375],[378.6271667480469,303.3443908691406],[379.02728271484375,303.3659973144531],[379.4278564453125,303.3804626464844],[379.82861328125,303.3884582519531],[380.22943115234375,303.3951416015625],[380.6302490234375,303.4018249511719],[381.03094482421875,303.4084777832031],[381.4317626953125,303.4151611328125],[381.83245849609375,303.42181396484375],[382.2333068847656,303.4284973144531],[382.6341247558594,303.4351501464844],[383.0348205566406,303.44183349609375],[383.4356384277344,303.448486328125],[383.8363342285156,303.4551696777344],[384.2371826171875,303.4618225097656],[384.63800048828125,303.468505859375],[385.0386962890625,303.47515869140625],[385.43951416015625,303.4818420410156],[385.8402099609375,303.4884948730469],[386.24102783203125,303.49517822265625],[386.641845703125,303.5017395019531],[387.0425720214844,303.5079040527344],[387.4433898925781,303.5140686035156],[387.8441162109375,303.5202331542969],[388.24493408203125,303.5263671875],[388.6457824707031,303.53253173828125],[389.0464782714844,303.5386962890625],[389.44732666015625,303.54486083984375],[389.8480224609375,303.551025390625],[390.24884033203125,303.55718994140625],[390.6496887207031,303.5633544921875],[391.0503845214844,303.56951904296875],[391.45123291015625,303.57568359375],[391.8519287109375,303.5818176269531],[392.2527770996094,303.5879821777344],[392.6535949707031,303.5941467285156],[393.0543212890625,303.6003112792969],[393.45513916015625,303.6064758300781],[393.85595703125,303.6121826171875],[394.2566833496094,303.61785888671875],[394.65753173828125,303.62353515625],[395.0582580566406,303.62921142578125],[395.4590759277344,303.6349182128906],[395.85992431640625,303.6405944824219],[396.2606506347656,303.6462707519531],[396.6614685058594,303.6519775390625],[397.06219482421875,303.65765380859375],[397.4630432128906,303.663330078125],[397.8638610839844,303.66900634765625],[398.26458740234375,303.6747131347656],[398.6654357910156,303.6803894042969],[399.0661315917969,303.6860656738281],[399.46697998046875,303.6917419433594],[399.8678283691406,303.69744873046875],[400.2685241699219,303.703125],[400.6694641113281,303.70849609375],[401.0701904296875,303.7137451171875],[401.47100830078125,303.718994140625],[401.8718566894531,303.7242431640625],[402.2725830078125,303.7294921875],[402.6734313964844,303.7347412109375],[403.07415771484375,303.739990234375],[403.4750061035156,303.7452392578125],[403.8758544921875,303.75048828125],[404.27655029296875,303.7557373046875],[404.6773986816406,303.760986328125],[405.078125,303.7662353515625],[405.4789733886719,303.771484375],[405.87982177734375,303.7767333984375],[406.2805480957031,303.781982421875],[406.681396484375,303.7872314453125],[407.0821228027344,303.79248046875],[407.48297119140625,303.79754638671875],[407.8838195800781,303.8023986816406],[408.2845458984375,303.8072509765625],[408.6853942871094,303.8121032714844],[409.08612060546875,303.81695556640625],[409.4869689941406,303.8218078613281],[409.8878173828125,303.82666015625],[410.2885437011719,303.8315124511719],[410.68939208984375,303.8363952636719],[411.09014892578125,303.84124755859375],[411.4909973144531,303.8460998535156],[411.891845703125,303.8509521484375],[412.2925720214844,303.8558044433594],[412.69342041015625,303.86065673828125],[413.0941467285156,303.8655090332031],[413.4949951171875,303.870361328125],[413.8958435058594,303.8752136230469],[414.2965087890625,303.8800048828125],[414.6973571777344,303.8844909667969],[415.09820556640625,303.8890075683594],[415.49896240234375,303.89349365234375],[415.8998107910156,303.8979797363281],[416.300537109375,303.9024963378906],[416.7013854980469,303.906982421875],[417.10223388671875,303.9114685058594],[417.50299072265625,303.9159851074219],[417.9038391113281,303.92047119140625],[418.3045654296875,303.9249572753906],[418.7054138183594,303.929443359375],[419.10626220703125,303.9339599609375],[419.5069885253906,303.9384460449219],[419.9078674316406,303.94293212890625],[420.30859375,303.94744873046875],[420.7094421386719,303.9519348144531],[421.11029052734375,303.9564208984375],[421.510986328125,303.96051025390625],[421.911865234375,303.96453857421875],[422.3125915527344,303.96856689453125],[422.71343994140625,303.97259521484375],[423.11431884765625,303.97662353515625],[423.5150451660156,303.98065185546875],[423.9158935546875,303.98468017578125],[424.316650390625,303.98870849609375],[424.7174987792969,303.99273681640625],[425.11834716796875,303.99676513671875],[425.51910400390625,304.00079345703125],[425.9199523925781,304.00482177734375],[426.3206787109375,304.00885009765625],[426.7215576171875,304.01287841796875],[427.1224060058594,304.01690673828125],[427.52313232421875,304.0209655761719],[427.92401123046875,304.0249938964844],[428.3247375488281,304.0290222167969],[428.7255859375,304.0330505371094],[429.12646484375,304.0370788574219],[429.5271911621094,304.0411071777344],[429.92803955078125,304.0451354980469],[430.32879638671875,304.0491638183594],[430.7296447753906,304.0531921386719],[431.1304931640625,304.0572204589844],[431.53125,304.0612487792969],[431.9320983886719,304.0652770996094],[432.33282470703125,304.0693054199219],[432.73370361328125,304.0733337402344],[433.1345520019531,304.0773620605469],[433.5352783203125,304.0813903808594],[433.9361572265625,304.0854187011719],[434.3368835449219,304.0894470214844],[434.73773193359375,304.0934753417969],[435.138671875,304.0973815917969],[435.5393981933594,304.1009216308594],[435.9402770996094,304.1044616699219],[436.34112548828125,304.1080017089844],[436.74188232421875,304.11151123046875],[437.1427307128906,304.11505126953125],[437.54345703125,304.11859130859375],[437.9443359375,304.12213134765625],[438.3451843261719,304.12567138671875],[438.7459411621094,304.12921142578125],[439.14678955078125,304.13275146484375],[439.54754638671875,304.13629150390625],[439.9483947753906,304.13983154296875],[440.3492736816406,304.14337158203125],[440.75,304.14691162109375],[441.15087890625,304.15045166015625],[441.5516052246094,304.15399169921875],[441.9524841308594,304.15753173828125],[442.35333251953125,304.16107177734375],[442.75408935546875,304.16461181640625],[443.1549377441406,304.16815185546875],[443.5556945800781,304.17169189453125],[443.95654296875,304.17523193359375],[444.357421875,304.17877197265625],[444.7581481933594,304.18231201171875],[445.1590270996094,304.18585205078125],[445.55975341796875,304.18939208984375],[445.96063232421875,304.19293212890625],[446.3614807128906,304.19647216796875],[446.7622375488281,304.20001220703125],[447.1630859375,304.20355224609375],[447.5638427734375,304.20709228515625],[447.9646911621094,304.21063232421875],[448.3655700683594,304.21417236328125],[448.76629638671875,304.21771240234375],[449.16717529296875,304.22100830078125],[449.56793212890625,304.2242126464844],[449.9687805175781,304.2274169921875],[450.3696594238281,304.2305908203125],[450.7704162597656,304.2337951660156],[451.1712646484375,304.23699951171875],[451.572021484375,304.2402038574219],[451.9728698730469,304.2433776855469],[452.3737487792969,304.24658203125],[452.77447509765625,304.2497863769531],[453.17535400390625,304.25299072265625],[453.57611083984375,304.25616455078125],[453.9769592285156,304.2593688964844],[454.3778381347656,304.2625732421875],[454.778564453125,304.2657775878906],[455.179443359375,304.2689514160156],[455.5802001953125,304.27215576171875],[455.9810485839844,304.2753601074219],[456.3819274902344,304.278564453125],[456.78265380859375,304.28173828125],[457.18353271484375,304.2849426269531],[457.5843811035156,304.28814697265625],[457.9851379394531,304.2913513183594],[458.3860168457031,304.2945251464844],[458.7867431640625,304.2977294921875],[459.1876220703125,304.3009338378906],[459.5884704589844,304.30413818359375],[459.9892272949219,304.30731201171875],[460.3901062011719,304.3105163574219],[460.79083251953125,304.313720703125],[461.19171142578125,304.3169250488281],[461.5925598144531,304.3200988769531],[461.9933166503906,304.32330322265625],[462.3941650390625,304.3265075683594],[462.794921875,304.3297119140625],[463.19580078125,304.3326721191406],[463.5966796875,304.3356628417969],[463.9974060058594,304.3386535644531],[464.3982849121094,304.3416442871094],[464.79901123046875,304.3446350097656],[465.19989013671875,304.34759521484375],[465.60076904296875,304.3505859375],[466.0014953613281,304.35357666015625],[466.4023742675781,304.3565673828125],[466.8031311035156,304.35955810546875],[467.2039794921875,304.3625183105469],[467.6048583984375,304.3655090332031],[468.005615234375,304.3684997558594],[468.4064636230469,304.3714904785156],[468.8072204589844,304.3744812011719],[469.20806884765625,304.37744140625],[469.60894775390625,304.38043212890625],[470.00970458984375,304.3834228515625],[470.4105529785156,304.38641357421875],[470.8113098144531,304.3893737792969],[471.2121887207031,304.3923645019531],[471.613037109375,304.3953552246094],[472.0137939453125,304.3983459472656],[472.4146728515625,304.4013366699219],[472.8153991699219,304.404296875],[473.2162780761719,304.40728759765625],[473.61712646484375,304.4102783203125],[474.01788330078125,304.41326904296875],[474.41876220703125,304.416259765625],[474.8194885253906,304.4192199707031],[475.2203674316406,304.4222106933594],[475.6212463378906,304.4252014160156],[476.02197265625,304.4281921386719],[476.4228515625,304.4311828613281],[476.8236083984375,304.43414306640625],[477.2244567871094,304.4371337890625],[477.6253356933594,304.44012451171875],[478.02606201171875,304.443115234375],[478.42694091796875,304.44610595703125],[478.82781982421875,304.4490661621094],[479.2285461425781,304.4520568847656],[479.6294250488281,304.4550476074219],[480.0301818847656,304.4580383300781],[480.4310302734375,304.4610290527344],[480.8319091796875,304.4639892578125],[481.232666015625,304.46697998046875],[481.6335144042969,304.469970703125],[482.0342712402344,304.47296142578125],[482.43511962890625,304.4759216308594],[482.83599853515625,304.4789123535156],[483.23675537109375,304.4819030761719],[483.6376037597656,304.4848937988281],[484.0383605957031,304.4878845214844],[484.4392395019531,304.4908447265625],[484.840087890625,304.49383544921875],[485.2408447265625,304.496826171875],[485.6417236328125,304.49981689453125],[486.0424499511719,304.5028076171875],[486.4433288574219,304.5057678222656],[486.84417724609375,304.5087585449219],[487.24493408203125,304.5117492675781],[487.64581298828125,304.5147399902344],[488.0465393066406,304.5177307128906],[488.4474182128906,304.52069091796875],[488.8482971191406,304.523681640625],[489.2490234375,304.52667236328125],[489.64990234375,304.5296630859375],[490.0506591796875,304.53265380859375],[490.4515075683594,304.5356140136719],[490.8523254394531,304.5386657714844],[491.2530822753906,304.5417175292969],[491.6539306640625,304.5447998046875],[492.0546875,304.5478515625],[492.45556640625,304.5509338378906],[492.8564147949219,304.5539855957031],[493.2571716308594,304.55706787109375],[493.65802001953125,304.56011962890625],[494.05877685546875,304.5632019042969],[494.45965576171875,304.5662841796875],[494.8605041503906,304.5693359375],[495.2612609863281,304.5724182128906],[495.6621398925781,304.5754699707031],[496.0628662109375,304.57855224609375],[496.4637451171875,304.58160400390625],[496.8645935058594,304.5846862792969],[497.2653503417969,304.5877380371094],[497.6662292480469,304.5908203125],[498.06695556640625,304.5938720703125],[498.46783447265625,304.5969543457031],[498.8686828613281,304.6000061035156],[499.2694396972656,304.60308837890625],[499.6703186035156,304.6061706542969],[500.0711669921875,304.6092224121094],[500.471923828125,304.6123046875],[500.872802734375,304.6153564453125],[501.2735290527344,304.6184387207031],[501.6744079589844,304.6214904785156],[502.07525634765625,304.62457275390625],[502.47601318359375,304.62762451171875],[502.87689208984375,304.6307067871094],[503.2776184082031,304.6337585449219],[503.6784973144531,304.6368408203125],[504.079345703125,304.639892578125],[504.4801025390625,304.6429748535156],[504.8810119628906,304.646240234375],[505.2817687988281,304.6495666503906],[505.6826171875,304.65289306640625],[506.08349609375,304.6562194824219],[506.4842529296875,304.6595458984375],[506.8851013183594,304.6628723144531],[507.2858581542969,304.66619873046875],[507.68670654296875,304.6695251464844],[508.08758544921875,304.6728210449219],[508.4883117675781,304.6761474609375],[508.8891906738281,304.6794738769531],[509.2899169921875,304.68280029296875],[509.6907958984375,304.6861267089844],[510.0916442871094,304.689453125],[510.4924011230469,304.6927795410156],[510.8932800292969,304.69610595703125],[511.29400634765625,304.69940185546875],[511.69488525390625,304.7027282714844],[512.0957641601562,304.7060546875],[512.4964599609375,304.7093811035156],[512.8973388671875,304.71270751953125],[513.298095703125,304.7160339355469],[513.698974609375,304.7193603515625],[514.0997924804688,304.7226867675781],[514.5005493164062,304.72601318359375],[514.9014282226562,304.72930908203125],[515.3021850585938,304.7326354980469],[515.7030639648438,304.7359619140625],[516.1038818359375,304.7392883300781],[516.504638671875,304.74261474609375],[516.905517578125,304.7459411621094],[517.3062744140625,304.749267578125],[517.7070922851562,304.7525939941406],[518.1079711914062,304.75592041015625],[518.5086669921875,304.7592468261719],[518.9095458984375,304.7629699707031],[519.3103637695312,304.7666931152344],[519.7111206054688,304.7704162597656],[520.1119995117188,304.7741394042969],[520.5126953125,304.7778625488281],[520.91357421875,304.7815856933594],[521.314453125,304.7853088378906],[521.7152099609375,304.7890319824219],[522.1160278320312,304.7927551269531],[522.5167846679688,304.7965087890625],[522.9176635742188,304.80023193359375],[523.3184814453125,304.803955078125],[523.71923828125,304.80767822265625],[524.1201171875,304.8114013671875],[524.5208740234375,304.81512451171875],[524.9216918945312,304.81884765625],[525.3225708007812,304.82257080078125],[525.7233276367188,304.8262939453125],[526.1241455078125,304.83001708984375],[526.52490234375,304.833740234375],[526.92578125,304.83746337890625],[527.32666015625,304.8411865234375],[527.7273559570312,304.84490966796875],[528.1282348632812,304.8486328125],[528.5289916992188,304.85235595703125],[528.9298095703125,304.8561096191406],[529.3306884765625,304.8598327636719],[529.7314453125,304.8635559082031],[530.13232421875,304.8672790527344],[530.5330200195312,304.8710021972656],[530.9338989257812,304.8747253417969],[531.3347778320312,304.8784484863281],[531.7354736328125,304.8821716308594],[532.1363525390625,304.8858947753906],[532.5371704101562,304.8897705078125],[532.9380493164062,304.89404296875],[533.3388671875,304.8983154296875],[533.7396240234375,304.902587890625],[534.1404418945312,304.9068603515625],[534.5411987304688,304.9111328125],[534.9420776367188,304.9154052734375],[535.3428955078125,304.919677734375],[535.74365234375,304.9239501953125],[536.14453125,304.9282531738281],[536.5452270507812,304.9325256347656],[536.9461059570312,304.9367980957031],[537.346923828125,304.9410705566406],[537.7476806640625,304.9453430175781],[538.1485595703125,304.9496154785156],[538.5492553710938,304.9538879394531],[538.9501342773438,304.9581604003906],[539.3510131835938,304.9624328613281],[539.751708984375,304.9667053222656],[540.152587890625,304.97100830078125],[540.5534057617188,304.97528076171875],[540.9541625976562,304.97955322265625],[541.3550415039062,304.98382568359375],[541.7557373046875,304.98809814453125],[542.1566162109375,304.99237060546875],[542.5574951171875,304.99664306640625],[542.9581909179688,305.00091552734375],[543.3590698242188,305.00518798828125],[543.759765625,305.00946044921875],[544.16064453125,305.0137634277344],[544.5615234375,305.0180358886719],[544.9622192382812,305.0223083496094],[545.3630981445312,305.0265808105469],[545.7638549804688,305.0308532714844],[546.1646728515625,305.0351257324219],[546.5654907226562,305.0396423339844],[546.9661865234375,305.0444030761719],[547.3670654296875,305.0491943359375],[547.767822265625,305.0539855957031],[548.1686401367188,305.05877685546875],[548.5695190429688,305.06353759765625],[548.97021484375,305.0683288574219],[549.37109375,305.0731201171875],[549.7717895507812,305.077880859375],[550.1726684570312,305.0826721191406],[550.573486328125,305.08746337890625],[550.9742431640625,305.0922546386719],[551.3750610351562,305.0970153808594],[551.7758178710938,305.101806640625],[552.1766357421875,305.1065979003906],[552.5775146484375,305.11138916015625],[552.9782104492188,305.11614990234375],[553.3790893554688,305.1209716796875],[553.7798461914062,305.1261291503906],[554.1806640625,305.13128662109375],[554.58154296875,305.136474609375],[554.9822387695312,305.1416320800781],[555.3831176757812,305.14678955078125],[555.7838134765625,305.1519775390625],[556.1846923828125,305.1571350097656],[556.5855102539062,305.16229248046875],[556.9862670898438,305.16748046875],[557.3870849609375,305.1726379394531],[557.7877807617188,305.17779541015625],[558.1886596679688,305.1829833984375],[558.5894775390625,305.1881408691406],[558.990234375,305.19329833984375],[559.3910522460938,305.198486328125],[559.7918090820312,305.2036437988281],[560.192626953125,305.2088317871094],[560.5934448242188,305.2142639160156],[560.994140625,305.2198486328125],[561.3949584960938,305.2254333496094],[561.7958374023438,305.2310485839844],[562.196533203125,305.23663330078125],[562.597412109375,305.2422180175781],[562.9981079101562,305.247802734375],[563.39892578125,305.25341796875],[563.7998046875,305.2590026855469],[564.2005004882812,305.26458740234375],[564.601318359375,305.2701721191406],[565.0020751953125,305.2757873535156],[565.4028930664062,305.2813720703125],[565.8037109375,305.2869567871094],[566.2044677734375,305.29254150390625],[566.6052856445312,305.29815673828125],[567.0059814453125,305.3037414550781],[567.4069213867188,305.3094482421875],[567.8077392578125,305.31549072265625],[568.2084350585938,305.3215637207031],[568.6093139648438,305.3276062011719],[569.010009765625,305.3336486816406],[569.4108276367188,305.3397216796875],[569.8116455078125,305.34576416015625],[570.21240234375,305.351806640625],[570.6132202148438,305.3578796386719],[571.013916015625,305.3639221191406],[571.4147338867188,305.3699645996094],[571.8156127929688,305.37603759765625],[572.21630859375,305.382080078125],[572.6171264648438,305.38812255859375],[573.017822265625,305.3941955566406],[573.418701171875,305.4002380371094],[573.8195190429688,305.40631103515625],[574.22021484375,305.412353515625],[574.6209716796875,305.4188232421875],[575.0216674804688,305.4253845214844],[575.4224853515625,305.43194580078125],[575.8233032226562,305.4384765625],[576.2239990234375,305.4450378417969],[576.6248168945312,305.45159912109375],[577.0255126953125,305.4581298828125],[577.4263305664062,305.4646911621094],[577.8272094726562,305.47125244140625],[578.2279052734375,305.4778137207031],[578.6287231445312,305.4843444824219],[579.0294189453125,305.49090576171875],[579.4302368164062,305.4974670410156],[579.8310546875,305.5040283203125],[580.2317504882812,305.51055908203125],[580.632568359375,305.5171203613281],[581.0332641601562,305.523681640625],[581.4341430664062,305.53045654296875],[581.8349609375,305.5375671386719],[582.2356567382812,305.5446472167969],[582.636474609375,305.5517272949219],[583.0372924804688,305.5588073730469],[583.43798828125,305.5658874511719],[583.8388061523438,305.572998046875],[584.239501953125,305.580078125],[584.6403198242188,305.587158203125],[585.0411376953125,305.59423828125],[585.4418334960938,305.601318359375],[585.8426513671875,305.6084289550781],[586.2433471679688,305.6155090332031],[586.6441650390625,305.6225891113281],[587.0449829101562,305.6296691894531],[587.4456787109375,305.6367492675781],[587.8464965820312,305.64385986328125],[588.2471313476562,305.6509704589844],[588.64794921875,305.6585998535156],[589.0487060546875,305.666259765625],[589.4494018554688,305.6739196777344],[589.8502197265625,305.68157958984375],[590.2509155273438,305.6892395019531],[590.6517333984375,305.6968994140625],[591.052490234375,305.7045593261719],[591.4531860351562,305.71221923828125],[591.85400390625,305.7198791503906],[592.2546997070312,305.7275390625],[592.655517578125,305.7351989746094],[593.0562744140625,305.74285888671875],[593.4569702148438,305.7505187988281],[593.8577880859375,305.7581787109375],[594.2584838867188,305.7658386230469],[594.6593017578125,305.77349853515625],[595.06005859375,305.7811584472656],[595.4607543945312,305.7891845703125],[595.861572265625,305.7974548339844],[596.2622680664062,305.80572509765625],[596.6630249023438,305.8139953613281],[597.0638427734375,305.822265625],[597.4644775390625,305.8305358886719],[597.8652954101562,305.83880615234375],[598.2659912109375,305.8470764160156],[598.666748046875,305.8553466796875],[599.0675659179688,305.8636169433594],[599.4682006835938,305.87188720703125],[599.8690185546875,305.8801574707031],[600.2697143554688,305.888427734375],[600.6704711914062,305.8966979980469],[601.0712890625,305.90496826171875],[601.471923828125,305.9132385253906],[601.8727416992188,305.9215087890625],[602.2734375,305.93011474609375],[602.6741943359375,305.94012451171875],[603.0748291015625,305.9519958496094],[603.4754028320312,305.9657897949219],[603.8759765625,305.9814758300781],[604.2764892578125,305.9991455078125],[604.6766967773438,306.0187072753906],[605.0770263671875,306.0400695800781],[605.4771728515625,306.0633239746094],[605.877197265625,306.0884094238281],[606.2771606445312,306.1153259277344],[606.6768798828125,306.1440734863281],[607.0765991210938,306.17462158203125],[607.4760131835938,306.20697021484375],[607.8754272460938,306.2411804199219],[608.2747192382812,306.2771911621094],[608.6737060546875,306.3150939941406],[609.0726318359375,306.35498046875],[609.47119140625,306.39666748046875],[609.8696899414062,306.440185546875],[610.2679443359375,306.4855041503906],[610.6658935546875,306.5326843261719],[611.0638427734375,306.5816955566406],[611.4613037109375,306.6325378417969],[611.8587036132812,306.6852722167969],[612.255859375,306.7400207519531],[612.652587890625,306.7967529296875],[613.0491333007812,306.85540771484375],[613.4453125,306.9159240722656],[613.8411865234375,306.9783935546875],[614.2368774414062,307.0428161621094],[614.632080078125,307.109130859375],[615.0271606445312,307.1774597167969],[615.4216918945312,307.2477111816406],[615.8159790039062,307.3203125],[616.2098388671875,307.3949890136719],[616.6031494140625,307.4716491699219],[616.9962768554688,307.5504150390625],[617.3887939453125,307.6312561035156],[617.7809448242188,307.7142028808594],[618.1727294921875,307.7993469238281],[618.5638427734375,307.8865661621094],[618.95458984375,307.9761962890625],[619.3446044921875,308.06817626953125],[619.7342529296875,308.1624755859375],[620.123291015625,308.259033203125],[620.51171875,308.35791015625],[620.8995971679688,308.45916748046875],[621.2866821289062,308.56280517578125],[621.6732788085938,308.66888427734375],[622.0591430664062,308.7774658203125],[622.4442138671875,308.8885498046875],[622.8285522460938,309.00250244140625],[623.2119750976562,309.1190490722656],[623.5946655273438,309.23828125],[623.9766235351562,309.3601989746094],[624.3574829101562,309.48480224609375],[624.7374877929688,309.61224365234375],[625.1166381835938,309.7425537109375],[625.4945678710938,309.875732421875],[625.8717041015625,310.011962890625],[626.2474365234375,310.1510925292969],[626.6222534179688,310.2934265136719],[626.9957885742188,310.4388732910156],[627.3678588867188,310.5877380371094],[627.7387084960938,310.7398986816406],[628.1080322265625,310.8954162597656],[628.47607421875,311.05438232421875],[628.842529296875,311.21685791015625],[629.2074584960938,311.382568359375],[629.5706176757812,311.55224609375],[629.931884765625,311.7256164550781],[630.2924194335938,311.9009094238281],[630.6520385742188,312.0782470703125],[631.0101928710938,312.2580871582031],[631.3673095703125,312.4401550292969],[631.7232666015625,312.62408447265625],[632.0784301757812,312.8100891113281],[632.432373046875,312.9983215332031],[632.7848510742188,313.1888427734375],[633.1365356445312,313.38134765625],[633.487060546875,313.5757141113281],[633.8366088867188,313.77203369140625],[634.1846313476562,313.9709167480469],[634.531494140625,314.171630859375],[634.8773803710938,314.37420654296875],[635.2220458984375,314.5785827636719],[635.5654907226562,314.78533935546875],[635.9077758789062,314.99420166015625],[636.2487182617188,315.2046813964844],[636.5886840820312,315.41705322265625],[636.9273071289062,315.63140869140625],[637.2646484375,315.8480529785156],[637.6008911132812,316.06646728515625],[637.935791015625,316.2864685058594],[638.2696533203125,316.50836181640625],[638.6018676757812,316.7325439453125],[638.9329833984375,316.9584655761719],[639.262939453125,317.18603515625],[639.5916748046875,317.4153137207031],[639.9189453125,317.6468505859375],[640.2448120117188,317.8801574707031],[640.569580078125,318.1151428222656],[640.8931274414062,318.35174560546875],[641.2151489257812,318.59033203125],[641.5358276367188,318.8309326171875],[641.8551025390625,319.072998046875],[642.17333984375,319.31683349609375],[642.4901733398438,319.5624084472656],[642.8052978515625,319.8099670410156],[643.1193237304688,320.0592041015625],[643.4320678710938,320.30999755859375],[643.7434692382812,320.56231689453125],[644.0531616210938,320.8168640136719],[644.3613891601562,321.0729064941406],[644.66845703125,321.3305358886719],[644.9743041992188,321.5897521972656],[645.2783813476562,321.8507995605469],[645.5809936523438,322.1136474609375],[645.8822631835938,322.3779602050781],[646.1822509765625,322.6438903808594],[646.4807739257812,322.9114990234375],[646.7774658203125,323.1809387207031],[647.0728149414062,323.45196533203125],[647.3667602539062,323.7243957519531],[647.659423828125,323.998291015625],[647.9501953125,324.2743225097656],[648.2393798828125,324.55169677734375],[648.5272827148438,324.83056640625],[648.813720703125,325.11083984375],[649.0985107421875,325.39300537109375],[649.381591796875,325.6769104003906],[649.6631469726562,325.9620666503906],[649.943359375,326.248779296875],[650.2218627929688,326.5369567871094],[650.49853515625,326.82708740234375],[650.773681640625,327.1185302734375],[651.0473022460938,327.41143798828125],[651.3194580078125,327.70574951171875],[651.5895385742188,328.0018005371094],[651.8580322265625,328.29937744140625],[652.125,328.5985107421875],[652.3903198242188,328.8988037109375],[652.6539306640625,329.2008056640625],[652.91552734375,329.50445556640625],[653.175537109375,329.80950927734375],[653.4339599609375,330.115966796875],[653.6907348632812,330.4237365722656],[653.9454345703125,330.7332763671875],[654.1983032226562,331.04425048828125],[654.449462890625,331.3565979003906],[654.6990356445312,331.67034912109375],[654.94677734375,331.9853820800781],[655.1922607421875,332.3023376464844],[655.4358520507812,332.62054443359375],[655.6766357421875,332.9410095214844],[655.9147338867188,333.2636413574219],[656.1497802734375,333.5881042480469],[656.38232421875,333.91461181640625],[656.6122436523438,334.2429504394531],[656.8395385742188,334.5731201171875],[657.0642700195312,334.9051208496094],[657.2864990234375,335.2384948730469],[657.5064697265625,335.57366943359375],[657.72412109375,335.9104309082031],[657.9392700195312,336.2485046386719],[658.1521606445312,336.58807373046875],[658.3629150390625,336.92901611328125],[658.5714721679688,337.27142333984375],[658.7778930664062,337.6149597167969],[658.9821166992188,337.95977783203125],[659.1842651367188,338.3060607910156],[659.38427734375,338.6533203125],[659.5823364257812,339.0018310546875],[659.7783813476562,339.3514709472656],[659.9723510742188,339.70208740234375],[660.16455078125,340.053955078125],[660.3546752929688,340.4067687988281],[660.54296875,340.76068115234375],[660.7293701171875,341.1155700683594],[660.9138793945312,341.47125244140625],[661.0965576171875,341.82818603515625],[661.27734375,342.1858215332031],[661.4563598632812,342.54443359375],[661.6336059570312,342.9040222167969],[661.8090209960938,343.26434326171875],[661.9827270507812,343.6257019042969],[662.1546020507812,343.98773193359375],[662.32470703125,344.3506774902344],[662.4931030273438,344.7144470214844],[662.6596069335938,345.0789794921875],[662.8243408203125,345.4444580078125],[662.9873657226562,345.8105773925781],[663.1486206054688,346.17755126953125],[663.3082885742188,346.5453796386719],[663.4661254882812,346.9136962890625],[663.6222534179688,347.2829284667969],[663.776611328125,347.6527404785156],[663.9292602539062,348.02337646484375],[664.0802001953125,348.39471435546875],[664.2294311523438,348.7667541503906],[664.376953125,349.1394348144531],[664.522705078125,349.5128173828125],[664.6666259765625,349.8869323730469],[664.808837890625,350.2617492675781],[664.9491577148438,350.6371154785156],[665.0877685546875,351.0133056640625],[665.2244262695312,351.3900146484375],[665.3593139648438,351.7675476074219],[665.4924926757812,352.1456604003906],[665.6237182617188,352.5243225097656],[665.7531127929688,352.9036865234375],[665.880615234375,353.2836608886719],[666.0062255859375,353.6643371582031],[666.1298828125,354.045654296875],[666.2515869140625,354.427490234375],[666.371337890625,354.81005859375],[666.4890747070312,355.1932373046875],[666.604736328125,355.576904296875],[666.7183837890625,355.9613952636719],[666.8298950195312,356.34625244140625],[666.9393920898438,356.7319641113281],[667.0469970703125,357.1180725097656],[667.152587890625,357.5047607421875],[667.2562255859375,357.8919372558594],[667.3578491210938,358.2796325683594],[667.4573364257812,358.6679382324219],[667.5548095703125,359.05682373046875],[667.650146484375,359.44598388671875],[667.7435913085938,359.8359375],[667.8347778320312,360.2261047363281],[667.9239501953125,360.6169128417969],[668.0110473632812,361.00830078125],[668.0960083007812,361.39990234375],[668.1788330078125,361.7921447753906],[668.2594604492188,362.1847229003906],[668.337890625,362.5778503417969],[668.4140625,362.9713439941406],[668.4878540039062,363.3653259277344],[668.559326171875,363.7597351074219],[668.6286010742188,364.15447998046875],[668.6954956054688,364.5496826171875],[668.7601318359375,364.94537353515625],[668.822265625,365.34130859375],[668.882080078125,365.7377014160156],[668.939453125,366.1342468261719],[668.9943237304688,366.5313415527344],[669.0466918945312,366.92877197265625],[669.0964965820312,367.32647705078125],[669.143798828125,367.72454833984375],[669.1884765625,368.122802734375],[669.2304077148438,368.5214538574219],[669.2695922851562,368.9203796386719],[669.3059692382812,369.31951904296875],[669.3397216796875,369.718994140625],[669.37060546875,370.1185607910156],[669.3986206054688,370.5184020996094],[669.423828125,370.9185485839844],[669.4461059570312,371.3187255859375],[669.4654541015625,371.71905517578125],[669.4817504882812,372.1195373535156],[669.4949340820312,372.5201110839844],[669.5050659179688,372.92083740234375],[669.511962890625,373.3215637207031],[669.5155639648438,373.72247314453125],[669.515869140625,374.1231689453125],[669.5128173828125,374.52410888671875],[669.5064086914062,374.9249267578125],[669.4966430664062,375.3255310058594],[669.4833984375,375.7262268066406],[669.466552734375,376.1266784667969],[669.4461669921875,376.5268859863281],[669.422119140625,376.92706298828125],[669.3943481445312,377.326904296875],[669.3627319335938,377.7265319824219],[669.3270263671875,378.1257629394531],[669.2874755859375,378.5245666503906],[669.2439575195312,378.9230651855469],[669.1964721679688,379.321044921875],[669.1451416015625,379.7185974121094],[669.0923461914062,380.1159973144531],[669.0387573242188,380.51312255859375],[668.9832763671875,380.9101257324219],[668.9276123046875,381.3070068359375],[668.8700561523438,381.7037353515625],[668.81103515625,382.1003112792969],[668.7507934570312,382.4964599609375],[668.689208984375,382.8925476074219],[668.626220703125,383.2884216308594],[668.5619506835938,383.6840515136719],[668.4962768554688,384.07958984375],[668.4292602539062,384.4745788574219],[668.36083984375,384.8695983886719],[668.2908935546875,385.26422119140625],[668.2193603515625,385.6587219238281],[668.146240234375,386.05279541015625],[668.0717163085938,386.4466247558594],[667.99560546875,386.8402099609375],[667.91796875,387.2333679199219],[667.8387451171875,387.6263732910156],[667.7579956054688,388.0189514160156],[667.675537109375,388.4111328125],[667.5912475585938,388.8030090332031],[667.5052490234375,389.1944580078125],[667.4175415039062,389.5856018066406],[667.3280639648438,389.9764404296875],[667.23681640625,390.36669921875],[667.1438598632812,390.75665283203125],[667.0491333007812,391.1460266113281],[666.952392578125,391.5350341796875],[666.853515625,391.92352294921875],[666.7528076171875,392.31146240234375],[666.6502075195312,392.698974609375],[666.545654296875,393.08587646484375],[666.4390869140625,393.47222900390625],[666.3305053710938,393.8581848144531],[666.2199096679688,394.24334716796875],[666.1070556640625,394.6280212402344],[665.9920043945312,395.0119323730469],[665.8746948242188,395.39520263671875],[665.7551879882812,395.77789306640625],[665.633544921875,396.15966796875],[665.5095825195312,396.5409851074219],[665.3833618164062,396.9214172363281],[665.2548828125,397.301025390625],[665.123779296875,397.6798400878906],[664.9901123046875,398.0577087402344],[664.8540649414062,398.434814453125],[664.7154541015625,398.8109130859375],[664.574462890625,399.1860656738281],[664.4308471679688,399.56024169921875],[664.2846069335938,399.93341064453125],[664.1357421875,400.3056640625],[663.9841918945312,400.6767272949219],[663.8296508789062,401.0464782714844],[663.6722412109375,401.4152526855469],[663.5121459960938,401.7825927734375],[663.34912109375,402.1488342285156],[663.1832275390625,402.5137634277344],[663.0144653320312,402.87725830078125],[662.8427124023438,403.2393798828125],[662.6679077148438,403.6000671386719],[662.4900512695312,403.9593505859375],[662.3089599609375,404.3169860839844],[662.12451171875,404.67279052734375],[661.9368896484375,405.0269470214844],[661.7463989257812,405.3795471191406],[661.5519409179688,405.7301025390625],[661.3549194335938,406.0791931152344],[661.1541137695312,406.4260559082031],[660.94970703125,406.77099609375],[660.7418823242188,407.1136474609375],[660.5321655273438,407.4552917480469],[660.320068359375,407.79547119140625],[660.1064453125,408.13446044921875],[659.8910522460938,408.4725341796875],[659.6740112304688,408.8095397949219],[659.4548950195312,409.1452331542969],[659.2340087890625,409.479736328125],[659.0115966796875,409.8130798339844],[658.78759765625,410.14556884765625],[658.561767578125,410.4766540527344],[658.3340454101562,410.8065490722656],[658.1047973632812,411.13543701171875],[657.874267578125,411.463134765625],[657.6419067382812,411.7898254394531],[657.40771484375,412.11505126953125],[657.1719360351562,412.4393615722656],[656.934814453125,412.7625427246094],[656.6962280273438,413.08453369140625],[656.4556274414062,413.4051208496094],[656.2137451171875,413.72467041015625],[655.9703369140625,414.0432434082031],[655.7254638671875,414.3606262207031],[655.4788818359375,414.6764221191406],[655.2307739257812,414.9913635253906],[654.9813842773438,415.3052978515625],[654.7305297851562,415.6177978515625],[654.4779052734375,415.9289245605469],[654.2239990234375,416.2389831542969],[653.9686889648438,416.5481262207031],[653.7117919921875,416.8558654785156],[653.453369140625,417.1621398925781],[653.193603515625,417.4674987792969],[652.9326782226562,417.7716369628906],[652.669921875,418.07440185546875],[652.4056396484375,418.3758850097656],[652.1401977539062,418.6761779785156],[651.87353515625,418.97540283203125],[651.6050415039062,419.2729187011719],[651.335205078125,419.5693664550781],[651.0640869140625,419.8647155761719],[650.7918090820312,420.1587829589844],[650.517578125,420.451171875],[650.2421875,420.7423400878906],[649.9655151367188,421.0323791503906],[649.6875,421.3211669921875],[649.4078369140625,421.6081237792969],[649.1267700195312,421.89404296875],[648.8446044921875,422.1786804199219],[648.5609130859375,422.4619140625],[648.2755737304688,422.7434997558594],[647.9890747070312,423.0237731933594],[647.7012939453125,423.3028564453125],[647.412109375,423.58026123046875],[647.1212768554688,423.8561096191406],[646.8291625976562,424.1307373046875],[646.5360107421875,424.4038391113281],[646.2410278320312,424.6753234863281],[645.9447631835938,424.9451599121094],[645.6471557617188,425.2137145996094],[645.3482666015625,425.48089599609375],[645.0478515625,425.74609375],[644.7457885742188,426.0097961425781],[644.4426879882812,426.27197265625],[644.1382446289062,426.5327453613281],[643.8320922851562,426.79156494140625],[643.524658203125,427.04852294921875],[643.2158203125,427.3041076660156],[642.9058227539062,427.55804443359375],[642.5940551757812,427.8100280761719],[642.28076171875,428.0601806640625],[641.96630859375,428.3086853027344],[641.6504516601562,428.55560302734375],[641.3331298828125,428.8003845214844],[641.0142211914062,429.0431213378906],[640.6939086914062,429.28424072265625],[640.3724975585938,429.52349853515625],[640.0494384765625,429.7608642578125],[639.724609375,429.9958190917969],[639.3986206054688,430.2288513183594],[639.0711059570312,430.4601745605469],[638.742431640625,430.689453125],[638.4118041992188,430.9161376953125],[638.0797729492188,431.1407775878906],[637.7464599609375,431.36328125],[637.4116821289062,431.5837707519531],[637.0751953125,431.8014221191406],[636.73681640625,432.016357421875],[636.3966064453125,432.2283935546875],[636.0547485351562,432.43743896484375],[635.7109985351562,432.64385986328125],[635.3657836914062,432.8473815917969],[635.0188598632812,433.0482482910156],[634.67041015625,433.2463073730469],[634.3204345703125,433.44171142578125],[633.968994140625,433.63433837890625],[633.6160888671875,433.8242492675781],[633.2615966796875,434.0115661621094],[632.90576171875,434.1961364746094],[632.548583984375,434.37799072265625],[632.1898803710938,434.5570068359375],[631.8299560546875,434.7331848144531],[631.4686279296875,434.9067077636719],[631.10595703125,435.0776062011719],[630.7421875,435.2457275390625],[630.3770751953125,435.4112243652344],[630.0109252929688,435.573974609375],[629.6433715820312,435.7341613769531],[629.2747802734375,435.8916015625],[628.9051513671875,436.0463562011719],[628.5340576171875,436.1980895996094],[628.1619873046875,436.34710693359375],[627.7888793945312,436.4934387207031],[627.4144897460938,436.6370849609375],[627.039306640625,436.77789306640625],[626.6629638671875,436.9159851074219],[626.2857666015625,437.0513610839844],[625.9075317382812,437.18402099609375],[625.5282592773438,437.31378173828125],[625.1480102539062,437.4404296875],[624.7667236328125,437.5643310546875],[624.3847045898438,437.6853332519531],[624.001708984375,437.8035888671875],[623.6177368164062,437.91900634765625],[623.2330932617188,438.031494140625],[622.8475341796875,438.1411437988281],[622.461181640625,438.24786376953125],[622.073974609375,438.3513488769531],[621.6858520507812,438.4517517089844],[621.2971801757812,438.54913330078125],[620.9075927734375,438.6435546875],[620.5172729492188,438.7349853515625],[620.1263427734375,438.8233337402344],[619.7347412109375,438.9085693359375],[619.3424072265625,438.99066162109375],[618.9494018554688,439.0697021484375],[618.5557250976562,439.1451110839844],[618.1614379882812,439.2172546386719],[617.7666015625,439.2861633300781],[617.3712768554688,439.3517761230469],[616.9752807617188,439.41412353515625],[616.5787353515625,439.47308349609375],[616.1818237304688,439.5286560058594],[615.7843017578125,439.580810546875],[615.3865356445312,439.62945556640625],[614.9881591796875,439.6743469238281],[614.5894775390625,439.7156982421875],[614.1904907226562,439.75335693359375],[613.7910766601562,439.7873229980469],[613.3914794921875,439.8176574707031],[612.9913940429688,439.8441467285156],[612.5912475585938,439.8666687011719],[612.1909790039062,439.8853759765625],[611.7903442382812,439.900146484375],[611.3897094726562,439.9110107421875],[610.9888916015625,439.9178466796875],[610.5880737304688,439.92041015625],[610.1873779296875,439.9206848144531],[609.7864990234375,439.92083740234375],[609.3857421875,439.9210205078125],[608.98486328125,439.9211730957031],[608.583984375,439.92132568359375],[608.1832275390625,439.9215087890625],[607.7823486328125,439.9216613769531],[607.381591796875,439.92181396484375],[606.980712890625,439.9219970703125],[606.579833984375,439.9221496582031],[606.1790771484375,439.92230224609375],[605.7781982421875,439.9224853515625],[605.37744140625,439.9226379394531],[604.9765625,439.92279052734375],[604.57568359375,439.9229736328125],[604.1749267578125,439.9231262207031],[603.7740478515625,439.92327880859375],[603.373291015625,439.9234619140625],[602.972412109375,439.9236145019531],[602.571533203125,439.92376708984375],[602.1707763671875,439.9239501953125],[601.7698974609375,439.9241027832031],[601.3690185546875,439.92425537109375],[600.96826171875,439.9244384765625],[600.5673828125,439.9245910644531],[600.1666259765625,439.92474365234375],[599.7657470703125,439.9249267578125],[599.3648681640625,439.9250793457031],[598.964111328125,439.92523193359375],[598.563232421875,439.9254150390625],[598.1624755859375,439.9255676269531],[597.7615966796875,439.92572021484375],[597.3607177734375,439.9259033203125],[596.9599609375,439.9260559082031],[596.55908203125,439.92620849609375],[596.1583251953125,439.9263916015625],[595.7574462890625,439.9265441894531],[595.3565673828125,439.92669677734375],[594.955810546875,439.9268798828125],[594.554931640625,439.92681884765625],[594.1541748046875,439.9267578125],[593.7532958984375,439.9267272949219],[593.3524169921875,439.9266662597656],[592.95166015625,439.9266052246094],[592.55078125,439.9265441894531],[592.1500244140625,439.9264831542969],[591.7491455078125,439.9264221191406],[591.3482666015625,439.9263610839844],[590.947509765625,439.92633056640625],[590.546630859375,439.92626953125],[590.1458740234375,439.92620849609375],[589.7449951171875,439.9261474609375],[589.3441162109375,439.92608642578125],[588.943359375,439.926025390625],[588.54248046875,439.9259948730469],[588.1417236328125,439.9259338378906],[587.7408447265625,439.9258728027344],[587.3399658203125,439.9258117675781],[586.939208984375,439.9257507324219],[586.538330078125,439.9256896972656],[586.1375732421875,439.9256286621094],[585.7366943359375,439.92559814453125],[585.3358154296875,439.925537109375],[584.93505859375,439.92547607421875],[584.5341796875,439.9254150390625],[584.1334228515625,439.92535400390625],[583.7325439453125,439.92529296875],[583.3316650390625,439.92523193359375],[582.930908203125,439.9252014160156],[582.530029296875,439.9251403808594],[582.1292724609375,439.9250793457031],[581.7283935546875,439.9250183105469],[581.3275146484375,439.9249572753906],[580.9267578125,439.9248962402344],[580.52587890625,439.92486572265625],[580.125,439.9248046875],[579.7242431640625,439.92474365234375],[579.3233642578125,439.9246826171875],[578.922607421875,439.9242248535156],[578.521728515625,439.92376708984375],[578.120849609375,439.9233093261719],[577.7200927734375,439.9228515625],[577.3192138671875,439.9223937988281],[576.91845703125,439.92193603515625],[576.517578125,439.9214782714844],[576.11669921875,439.9210205078125],[575.7159423828125,439.9205627441406],[575.3150634765625,439.9200744628906],[574.914306640625,439.91961669921875],[574.513427734375,439.9191589355469],[574.112548828125,439.918701171875],[573.7117919921875,439.9182434082031],[573.3109130859375,439.91778564453125],[572.91015625,439.9173278808594],[572.50927734375,439.9168701171875],[572.1083984375,439.9164123535156],[571.7076416015625,439.91595458984375],[571.3067626953125,439.9154968261719],[570.906005859375,439.9150390625],[570.505126953125,439.9145812988281],[570.104248046875,439.9140930175781],[569.7034912109375,439.91363525390625],[569.3026123046875,439.9131774902344],[568.90185546875,439.9127197265625],[568.5009765625,439.9122619628906],[568.10009765625,439.91180419921875],[567.6993408203125,439.9113464355469],[567.2984619140625,439.910888671875],[566.897705078125,439.9104309082031],[566.496826171875,439.90997314453125],[566.095947265625,439.9095153808594],[565.6951904296875,439.9090576171875],[565.2943115234375,439.9085693359375],[564.8935546875,439.9081115722656],[564.49267578125,439.90765380859375],[564.091796875,439.9071960449219],[563.6910400390625,439.90673828125],[563.2901611328125,439.9058532714844],[562.889404296875,439.90496826171875],[562.488525390625,439.9040832519531],[562.087646484375,439.9031982421875],[561.6868896484375,439.9023132324219],[561.2860107421875,439.90142822265625],[560.88525390625,439.9005432128906],[560.484375,439.899658203125],[560.08349609375,439.8987731933594],[559.6827392578125,439.89788818359375],[559.2818603515625,439.8970031738281],[558.8809814453125,439.8961181640625],[558.480224609375,439.8952331542969],[558.079345703125,439.89434814453125],[557.6785888671875,439.8934631347656],[557.2777099609375,439.8926086425781],[556.8768310546875,439.8917236328125],[556.47607421875,439.8908386230469],[556.0751953125,439.88995361328125],[555.6743774414062,439.8888854980469],[555.2734985351562,439.8876647949219],[554.8726196289062,439.88641357421875],[554.471923828125,439.88519287109375],[554.071044921875,439.88397216796875],[553.6702880859375,439.88275146484375],[553.2694091796875,439.8815002441406],[552.8685302734375,439.8802795410156],[552.4677734375,439.8790588378906],[552.06689453125,439.8778381347656],[551.6661376953125,439.8765869140625],[551.2652587890625,439.8753662109375],[550.8643798828125,439.8741455078125],[550.463623046875,439.8729248046875],[550.062744140625,439.8716735839844],[549.6619873046875,439.8704528808594],[549.2611083984375,439.8692321777344],[548.8602294921875,439.8680114746094],[548.45947265625,439.86676025390625],[548.05859375,439.86553955078125],[547.6578979492188,439.8639221191406],[547.2570190429688,439.8623046875],[546.8561401367188,439.8606872558594],[546.4553833007812,439.85906982421875],[546.0545043945312,439.8574523925781],[545.6537475585938,439.8558349609375],[545.2528686523438,439.8542175292969],[544.8519897460938,439.85260009765625],[544.4512329101562,439.8509826660156],[544.0503540039062,439.849365234375],[543.649658203125,439.8477478027344],[543.248779296875,439.84613037109375],[542.847900390625,439.8445129394531],[542.4471435546875,439.8428955078125],[542.0462646484375,439.8412780761719],[541.6455078125,439.83966064453125],[541.24462890625,439.8380432128906],[540.84375,439.83642578125],[540.4429931640625,439.8348083496094],[540.0419921875,439.83294677734375],[539.6412353515625,439.8309020996094],[539.2404174804688,439.828857421875],[538.8395385742188,439.8267822265625],[538.4387817382812,439.8247375488281],[538.0379028320312,439.82269287109375],[537.6370239257812,439.82061767578125],[537.2362670898438,439.8185729980469],[536.8353881835938,439.8164978027344],[536.4346313476562,439.814453125],[536.0337524414062,439.8124084472656],[535.6328735351562,439.8103332519531],[535.2321166992188,439.80828857421875],[534.8312377929688,439.8062438964844],[534.4305419921875,439.8041687011719],[534.0296630859375,439.8021240234375],[533.6287841796875,439.800048828125],[533.22802734375,439.7980041503906],[532.8271484375,439.79595947265625],[532.4263916015625,439.79388427734375],[532.0255737304688,439.7913513183594],[531.6246948242188,439.788818359375],[531.2239379882812,439.7862854003906],[530.8230590820312,439.7837219238281],[530.4223022460938,439.78118896484375],[530.0214233398438,439.7786560058594],[529.6205444335938,439.7760925292969],[529.2197875976562,439.7735595703125],[528.8189697265625,439.7710266113281],[528.418212890625,439.76849365234375],[528.017333984375,439.76593017578125],[527.616455078125,439.7633972167969],[527.2156982421875,439.7608642578125],[526.8148193359375,439.7583312988281],[526.4140625,439.7557678222656],[526.0132446289062,439.75323486328125],[525.6123657226562,439.7507019042969],[525.2116088867188,439.7481384277344],[524.8107299804688,439.74560546875],[524.4100341796875,439.7427978515625],[524.0092163085938,439.73974609375],[523.6083374023438,439.7366638183594],[523.2075805664062,439.73358154296875],[522.8067016601562,439.7304992675781],[522.4059448242188,439.7274169921875],[522.0050659179688,439.724365234375],[521.604248046875,439.7212829589844],[521.2034912109375,439.71820068359375],[520.8026123046875,439.7151184082031],[520.40185546875,439.7120666503906],[520.0009765625,439.708984375],[519.6001586914062,439.7059020996094],[519.1994018554688,439.70281982421875],[518.7985229492188,439.69976806640625],[518.3977661132812,439.6966857910156],[517.9968872070312,439.693603515625],[517.5960693359375,439.6905212402344],[517.1953125,439.6874694824219],[516.79443359375,439.68438720703125],[516.3935546875,439.68072509765625],[515.9927978515625,439.6770935058594],[515.5919189453125,439.6734313964844],[515.1912231445312,439.6697692871094],[514.7903442382812,439.6661071777344],[514.3894653320312,439.6624755859375],[513.98876953125,439.6588134765625],[513.587890625,439.6551513671875],[513.1871337890625,439.6515197753906],[512.7862548828125,439.6478576660156],[512.3854370117188,439.6441955566406],[511.98468017578125,439.64056396484375],[511.58380126953125,439.63690185546875],[511.1830749511719,439.63323974609375],[510.7822265625,439.6296081542969],[510.38134765625,439.6259460449219],[509.9806213378906,439.6222839355469],[509.5797424316406,439.61865234375],[509.17901611328125,439.614990234375],[508.7781982421875,439.61102294921875],[508.3773498535156,439.60675048828125],[507.9765930175781,439.60247802734375],[507.57574462890625,439.5981750488281],[507.1750183105469,439.5939025878906],[506.774169921875,439.5896301269531],[506.373291015625,439.5853271484375],[505.9725646972656,439.5810546875],[505.57171630859375,439.5767822265625],[505.17095947265625,439.572509765625],[504.7701110839844,439.5682067871094],[504.3692626953125,439.5639343261719],[503.9685363769531,439.5596618652344],[503.56768798828125,439.5553894042969],[503.16693115234375,439.55108642578125],[502.7660827636719,439.54681396484375],[502.365234375,439.54254150390625],[501.9644775390625,439.53826904296875],[501.5636291503906,439.5339660644531],[501.16290283203125,439.5296936035156],[500.7619323730469,439.5247497558594],[500.361083984375,439.519775390625],[499.9603576660156,439.51483154296875],[499.55950927734375,439.5098876953125],[499.1587829589844,439.5049133300781],[498.7579345703125,439.4999694824219],[498.3570861816406,439.4950256347656],[497.95635986328125,439.49005126953125],[497.5555114746094,439.485107421875],[497.15478515625,439.4801330566406],[496.7539367675781,439.4751892089844],[496.35308837890625,439.4702453613281],[495.9523620605469,439.46527099609375],[495.551513671875,439.4603271484375],[495.1506652832031,439.4553527832031],[494.74993896484375,439.4504089355469],[494.3490905761719,439.4454650878906],[493.9483642578125,439.44049072265625],[493.5475158691406,439.435546875],[493.1467590332031,439.43023681640625],[492.74603271484375,439.424560546875],[492.34521484375,439.41888427734375],[491.9444885253906,439.4132080078125],[491.54364013671875,439.40753173828125],[491.142822265625,439.40185546875],[490.7420959472656,439.39617919921875],[490.34124755859375,439.3905029296875],[489.9405517578125,439.38482666015625],[489.5397033691406,439.379150390625],[489.13885498046875,439.37347412109375],[488.7381286621094,439.3677978515625],[488.3373107910156,439.36212158203125],[487.93658447265625,439.3564453125],[487.5357360839844,439.35076904296875],[487.1349182128906,439.3450927734375],[486.73419189453125,439.33941650390625],[486.3333435058594,439.333740234375],[485.9326477050781,439.32806396484375]],
	bounds=3000,
	full_zoom=0.22,
	max_episode_steps=3000
)

Australia = RaceTrack(
	name='Australia',
	xy=[[217.32278442382812,54.43253707885742],[217.56837463378906,54.664161682128906],[217.81396484375,54.895790100097656],[218.05955505371094,55.127418518066406],[218.30514526367188,55.35904312133789],[218.5507354736328,55.59067153930664],[218.79632568359375,55.822296142578125],[219.0419158935547,56.053924560546875],[219.28750610351562,56.28554916381836],[219.53309631347656,56.51717758178711],[219.7786865234375,56.748802185058594],[220.02427673339844,56.980430603027344],[220.26986694335938,57.212059020996094],[220.5154571533203,57.44368362426758],[220.76104736328125,57.67531204223633],[221.0066375732422,57.90693664550781],[221.25222778320312,58.13856506347656],[221.49781799316406,58.37018966674805],[221.743408203125,58.6018180847168],[221.98899841308594,58.83344650268555],[222.23458862304688,59.06507110595703],[222.48016357421875,59.29669952392578],[222.7257537841797,59.528324127197266],[222.97134399414062,59.759952545166016],[223.21693420410156,59.9915771484375],[223.4625244140625,60.22320556640625],[223.70811462402344,60.454830169677734],[223.95370483398438,60.686458587646484],[224.1992950439453,60.91808319091797],[224.44488525390625,61.14971160888672],[224.6904754638672,61.38134002685547],[224.93606567382812,61.61296463012695],[225.18165588378906,61.8445930480957],[225.42724609375,62.07621765136719],[225.67283630371094,62.30784606933594],[225.91842651367188,62.53947067260742],[226.1640167236328,62.77109909057617],[226.40960693359375,63.00272750854492],[226.6551971435547,63.234352111816406],[226.90078735351562,63.465980529785156],[227.14637756347656,63.69760513305664],[227.3919677734375,63.92923355102539],[227.63755798339844,64.16085815429688],[227.88314819335938,64.39248657226562],[228.1287384033203,64.62411499023438],[228.37432861328125,64.85574340820312],[228.6199188232422,65.08736419677734],[228.86550903320312,65.3189926147461],[229.11109924316406,65.55062103271484],[229.356689453125,65.7822494506836],[229.60227966308594,66.01387786865234],[229.84786987304688,66.24549865722656],[230.0934600830078,66.47712707519531],[230.33905029296875,66.70875549316406],[230.58462524414062,66.94038391113281],[230.83021545410156,67.17201232910156],[231.0758056640625,67.40364074707031],[231.32139587402344,67.63526916503906],[231.56698608398438,67.86688995361328],[231.8125762939453,68.09851837158203],[232.05816650390625,68.33014678955078],[232.3037567138672,68.56177520751953],[232.54934692382812,68.79339599609375],[232.79493713378906,69.0250244140625],[233.04052734375,69.25665283203125],[233.28611755371094,69.48828125],[233.53170776367188,69.71990966796875],[233.7772979736328,69.9515380859375],[234.02288818359375,70.18315887451172],[234.2684783935547,70.41478729248047],[234.51406860351562,70.64641571044922],[234.75965881347656,70.87804412841797],[235.0052490234375,71.10967254638672],[235.25083923339844,71.34130096435547],[235.49642944335938,71.57292175292969],[235.7420196533203,71.80455017089844],[235.98760986328125,72.03617858886719],[236.23318481445312,72.26780700683594],[236.47877502441406,72.49943542480469],[236.724365234375,72.7310562133789],[236.96995544433594,72.96268463134766],[237.21554565429688,73.1943130493164],[237.4611358642578,73.42594146728516],[237.70672607421875,73.6575698852539],[237.9523162841797,73.88919067382812],[238.19790649414062,74.12081909179688],[238.44349670410156,74.35244750976562],[238.6890869140625,74.58407592773438],[238.93467712402344,74.81570434570312],[239.18045043945312,75.04712677001953],[239.4269561767578,75.27778625488281],[239.67327880859375,75.50862884521484],[239.91729736328125,75.74190521240234],[240.15728759765625,75.97932434082031],[240.391357421875,76.2225570678711],[240.61741638183594,76.47325134277344],[240.83274841308594,76.73320007324219],[241.03396606445312,77.00420379638672],[241.21617126464844,77.28829193115234],[241.3728485107422,77.587158203125],[241.4951934814453,77.90155792236328],[241.5723114013672,78.2298583984375],[241.59263610839844,78.56634521484375],[241.5489959716797,78.90054321289062],[241.46173095703125,79.22662353515625],[241.38644409179688,79.55567932128906],[241.32192993164062,79.88703155517578],[241.26329040527344,80.21949005126953],[241.2060089111328,80.55217742919922],[241.14576721191406,80.88433837890625],[241.07786560058594,81.21501159667969],[240.99754333496094,81.54287719726562],[240.89971923828125,81.86591339111328],[240.77940368652344,82.18123626708984],[240.6317596435547,82.48467254638672],[240.45346069335938,82.77112579345703],[240.25027465820312,83.04067993164062],[240.04042053222656,83.30511474609375],[239.82530212402344,83.56526947021484],[239.60552978515625,83.82151794433594],[239.38162231445312,84.07416534423828],[239.15406799316406,84.32352447509766],[238.9231719970703,84.5698013305664],[238.68939208984375,84.8133316040039],[238.4533233642578,85.05465698242188],[238.2150115966797,85.29375457763672],[237.9750518798828,85.53121185302734],[237.73367309570312,85.7672119140625],[237.4910888671875,86.00199127197266],[237.24761962890625,86.23583984375],[237.0038299560547,86.46935272216797],[236.75975036621094,86.70257568359375],[236.5156707763672,86.93579864501953],[236.27169799804688,87.16912841796875],[236.02857971191406,87.40335083007812],[235.7860870361328,87.63821411132812],[235.544921875,87.87444305419922],[235.30532836914062,88.11225891113281],[235.0674285888672,88.35176849365234],[234.8317108154297,88.59343719482422],[234.59852600097656,88.8375473022461],[234.36830139160156,89.08444213867188],[234.14144897460938,89.33444213867188],[233.9183349609375,89.5877914428711],[233.699462890625,89.84480285644531],[233.4853515625,90.10579681396484],[233.27667236328125,90.37115478515625],[233.0739288330078,90.64105224609375],[232.8777618408203,90.9157943725586],[232.6888885498047,91.19557189941406],[232.50802612304688,91.4806137084961],[232.33599853515625,91.77104949951172],[232.17356872558594,92.06697082519531],[232.02166748046875,92.3684310913086],[231.881103515625,92.67533874511719],[231.7527313232422,92.98753356933594],[231.6373291015625,93.30476379394531],[231.53565979003906,93.62664031982422],[231.4483642578125,93.95272064208984],[231.37599182128906,94.28242492675781],[231.3188934326172,94.6151123046875],[231.27740478515625,94.95011138916016],[231.24508666992188,95.28614807128906],[231.20970153808594,95.62187194824219],[231.17127990722656,95.95726013183594],[231.13040161132812,96.2923583984375],[231.08743286132812,96.627197265625],[231.04342651367188,96.96190643310547],[230.99874877929688,97.29652404785156],[230.95407104492188,97.63114166259766],[230.9098358154297,97.9658203125],[230.8663330078125,98.30059051513672],[230.82470703125,98.6355972290039],[230.7850799560547,98.97085571289062],[230.74853515625,99.30644989013672],[230.7150421142578,99.64237213134766],[230.6857452392578,99.97868347167969],[230.6610565185547,100.31536102294922],[230.6416015625,100.65238952636719],[230.6279754638672,100.98969268798828],[230.6207733154297,101.32719421386719],[230.62059020996094,101.6647720336914],[230.62803649902344,102.00226593017578],[230.644287109375,102.33944702148438],[230.66744995117188,102.67623901367188],[230.69403076171875,103.01277923583984],[230.7226104736328,103.34915161132812],[230.75213623046875,103.68544006347656],[230.7821502685547,104.02169799804688],[230.81214904785156,104.35794067382812],[230.84178161621094,104.69422149658203],[230.870361328125,105.03060150146484],[230.8976287841797,105.3670883178711],[230.92172241210938,105.70381164550781],[230.93991088867188,106.04090118408203],[230.94114685058594,106.37833404541016],[230.81399536132812,106.30528259277344],[230.75582885742188,106.14608001708984],[230.81724548339844,106.47803497314453],[230.88128662109375,106.80947875976562],[230.94786071777344,107.14044189453125],[231.0169219970703,107.47088623046875],[231.0884552001953,107.80081176757812],[231.16238403320312,108.13019561767578],[231.23867797851562,108.45905303955078],[231.31724548339844,108.78736114501953],[231.39830017089844,109.11507415771484],[231.48133850097656,109.44229125976562],[231.56654357910156,109.76893615722656],[231.65386962890625,110.09503936767578],[231.74325561523438,110.42057800292969],[231.8346710205078,110.74554443359375],[231.92803955078125,111.06996154785156],[232.02334594726562,111.39381408691406],[232.1205291748047,111.71710205078125],[232.21957397460938,112.03984069824219],[232.32040405273438,112.36200714111328],[232.42298889160156,112.68363952636719],[232.52728271484375,113.00470733642578],[232.6332244873047,113.32523345947266],[232.74081420898438,113.64521026611328],[232.85000610351562,113.96466827392578],[232.96072387695312,114.2835693359375],[233.0729522705078,114.60195922851562],[233.18663024902344,114.9198226928711],[233.30177307128906,115.23717498779297],[233.4182891845703,115.55401611328125],[233.53614807128906,115.87035369873047],[233.6553192138672,116.18621826171875],[233.7757568359375,116.50157928466797],[233.89744567871094,116.81646728515625],[234.02032470703125,117.13089752197266],[234.14437866210938,117.44486999511719],[234.26956176757812,117.75838470458984],[234.39585876464844,118.07145690917969],[234.523193359375,118.38410186767578],[234.6515655517578,118.69634246826172],[234.78091430664062,119.00816345214844],[234.91122436523438,119.319580078125],[235.04246520996094,119.630615234375],[235.1746063232422,119.94126892089844],[235.30760192871094,120.25155639648438],[235.44140625,120.56148529052734],[235.57601928710938,120.87107849121094],[235.71141052246094,121.18032836914062],[235.84764099121094,121.48919677734375],[235.9845428466797,121.79777526855469],[236.1219024658203,122.10616302490234],[236.26010131835938,122.41416931152344],[236.39869689941406,122.72198486328125],[236.53807067871094,123.02946472167969],[236.67779541015625,123.33677673339844],[236.81822204589844,123.6437759399414],[236.95895385742188,123.95063018798828],[237.10028076171875,124.2572021484375],[237.2418975830078,124.56365203857422],[237.384033203125,124.86985778808594],[237.52639770507812,125.17596435546875],[237.66920471191406,125.48185729980469],[237.8122100830078,125.78765869140625],[237.95556640625,126.09329223632812],[238.09909057617188,126.39884948730469],[238.24293518066406,126.70426177978516],[238.3867645263672,127.00967407226562],[238.53060913085938,127.31507873535156],[238.67445373535156,127.62049102783203],[238.81863403320312,127.92574310302734],[238.96299743652344,128.2309112548828],[239.1073455810547,128.53607177734375],[239.25169372558594,128.84124755859375],[239.39605712890625,129.1464080810547],[239.5409393310547,129.45132446289062],[239.68582153320312,129.75624084472656],[239.83070373535156,130.0611572265625],[239.9755859375,130.36607360839844],[240.1206512451172,130.6708984375],[240.26609802246094,130.97555541992188],[240.4115447998047,131.28021240234375],[240.55697631835938,131.58485412597656],[240.70242309570312,131.88951110839844],[240.84825134277344,132.1939697265625],[240.99427795410156,132.4983367919922],[241.1403045654297,132.80271911621094],[241.28631591796875,133.10708618164062],[241.43234252929688,133.4114532470703],[241.5789794921875,133.71554565429688],[241.72560119628906,134.01962280273438],[241.8722381591797,134.32369995117188],[242.0188751220703,134.62777709960938],[242.1656951904297,134.9317626953125],[242.31295776367188,135.23553466796875],[242.46022033691406,135.539306640625],[242.60748291015625,135.84307861328125],[242.75474548339844,136.14686584472656],[242.9024200439453,136.45042419433594],[243.0503387451172,136.75387573242188],[243.19825744628906,137.05734252929688],[243.34617614746094,137.3607940673828],[243.4940948486328,137.66424560546875],[243.6426544189453,137.96739196777344],[243.79124450683594,138.27052307128906],[243.93984985351562,138.5736541748047],[244.08843994140625,138.87677001953125],[244.23721313476562,139.1798095703125],[244.3865203857422,139.4825897216797],[244.5358123779297,139.78536987304688],[244.68511962890625,140.08815002441406],[244.83441162109375,140.39093017578125],[244.984130859375,140.69349670410156],[245.13414001464844,140.9959259033203],[245.28416442871094,141.29833984375],[245.43418884277344,141.60076904296875],[245.58421325683594,141.90318298339844],[245.7349090576172,142.2052764892578],[245.8856658935547,142.50732421875],[246.0364532470703,142.8093719482422],[246.1872100830078,143.11141967773438],[246.33815002441406,143.41339111328125],[246.48968505859375,143.7150421142578],[246.6412353515625,144.01670837402344],[246.7927703857422,144.31837463378906],[246.94432067871094,144.6200408935547],[247.09628295898438,144.92149353027344],[247.24862670898438,145.22274780273438],[247.4009552001953,145.5240020751953],[247.5532989501953,145.82525634765625],[247.7056427001953,146.12652587890625],[247.85867309570312,146.42742919921875],[248.0118408203125,146.728271484375],[248.1649932861328,147.02911376953125],[248.3181610107422,147.3299560546875],[248.47145080566406,147.6307373046875],[248.62545776367188,147.93115234375],[248.7794647216797,148.2315673828125],[248.9334716796875,148.531982421875],[249.0874786376953,148.8323974609375],[249.24188232421875,149.13258361816406],[249.39675903320312,149.43255615234375],[249.55162048339844,149.73252868652344],[249.7064971923828,150.03248596191406],[249.8613739013672,150.3324432373047],[250.01693725585938,150.63206481933594],[250.17269897460938,150.9315643310547],[250.32846069335938,151.2310791015625],[250.48422241210938,151.53057861328125],[250.64007568359375,151.8300323486328],[250.7967529296875,152.12905883789062],[250.95343017578125,152.42808532714844],[251.11012268066406,152.72711181640625],[251.2667999267578,153.02613830566406],[251.4238739013672,153.32496643066406],[251.5814971923828,153.6234893798828],[251.73910522460938,153.92201232910156],[251.89674377441406,154.22055053710938],[252.0543670654297,154.5190887451172],[252.21267700195312,154.81723022460938],[252.3712615966797,155.11526489257812],[252.52984619140625,155.4132843017578],[252.68841552734375,155.7113037109375],[252.84703063964844,156.00930786132812],[253.00634765625,156.30694580078125],[253.16566467285156,156.6045684814453],[253.32533264160156,156.90200805664062],[253.48513793945312,157.19937133789062],[253.6451416015625,157.49664306640625],[253.8054656982422,157.79373168945312],[253.96578979492188,158.09080505371094],[254.1266326904297,158.3876190185547],[254.28746032714844,158.68443298339844],[254.44863891601562,158.98106384277344],[254.6099853515625,159.277587890625],[254.77151489257812,159.57403564453125],[254.9333953857422,159.87026977539062],[255.09527587890625,160.16651916503906],[255.25767517089844,160.4624786376953],[255.42007446289062,160.75843811035156],[255.58282470703125,161.05419921875],[255.7457733154297,161.349853515625],[255.90887451171875,161.6454315185547],[256.0723571777344,161.9407958984375],[256.2358093261719,162.2361602783203],[256.39984130859375,162.53123474121094],[256.5638427734375,162.8262939453125],[256.7282409667969,163.12115478515625],[256.8927917480469,163.41592407226562],[257.05755615234375,163.71058654785156],[257.2226867675781,164.00502014160156],[257.3878173828125,164.29945373535156],[257.5534973144531,164.5935821533203],[257.7192077636719,164.88771057128906],[257.88525390625,165.18162536621094],[258.051513671875,165.47543334960938],[258.21795654296875,165.76914978027344],[258.3847961425781,166.0626220703125],[258.5516357421875,166.35610961914062],[258.7190246582031,166.64926147460938],[258.8864440917969,166.94241333007812],[259.0542297363281,167.2353515625],[259.2222595214844,167.5281524658203],[259.39044189453125,167.82086181640625],[259.5590515136719,168.11334228515625],[259.7276306152344,168.4058074951172],[259.89678955078125,168.69793701171875],[260.0660095214844,168.99008178710938],[260.2355651855469,169.28199768066406],[260.4053649902344,169.5737762451172],[260.5753479003906,169.8654327392578],[260.7457580566406,170.1568603515625],[260.9161682128906,170.44827270507812],[261.0871887207031,170.7393341064453],[261.2582092285156,171.0303955078125],[261.42987060546875,171.3210906982422],[261.6026306152344,171.61111450195312],[261.7767028808594,171.90036010742188],[261.9520263671875,172.18885803222656],[262.1285705566406,172.47657775878906],[262.3063659667969,172.7635498046875],[262.48541259765625,173.04974365234375],[262.6656494140625,173.335205078125],[262.8470764160156,173.6199188232422],[263.0296936035156,173.90383911132812],[263.2134704589844,174.18701171875],[263.3984069824219,174.46942138671875],[263.5845031738281,174.75108337402344],[263.7717590332031,175.03196716308594],[263.96014404296875,175.31210327148438],[264.149658203125,175.59149169921875],[264.3403015136719,175.87010192871094],[264.5320129394531,176.14794921875],[264.7248229980469,176.425048828125],[264.9187316894531,176.70140075683594],[265.11370849609375,176.9769744873047],[265.3097839355469,177.25180053710938],[265.50689697265625,177.52589416503906],[265.70501708984375,177.79920959472656],[265.9042053222656,178.07176208496094],[266.10443115234375,178.34356689453125],[266.3056640625,178.61460876464844],[266.5079040527344,178.88491821289062],[266.711181640625,179.15443420410156],[266.9154357910156,179.4232177734375],[267.12066650390625,179.69126892089844],[267.3268737792969,179.95855712890625],[267.5340576171875,180.22509765625],[267.7421875,180.49087524414062],[267.9512939453125,180.7559051513672],[268.1613464355469,181.02017211914062],[268.3723449707031,181.28369140625],[268.5842590332031,181.54647827148438],[268.797119140625,181.8085174560547],[269.0108947753906,182.06979370117188],[269.2255554199219,182.33033752441406],[269.4411315917969,182.5901336669922],[269.6576232910156,182.8491668701172],[269.875,183.10745239257812],[270.09326171875,183.364990234375],[270.3123779296875,183.62179565429688],[270.53240966796875,183.8778533935547],[270.7532653808594,184.13316345214844],[270.9749755859375,184.38772583007812],[271.19757080078125,184.6415252685547],[271.4209899902344,184.8946075439453],[271.645263671875,185.14694213867188],[271.870361328125,185.3985137939453],[272.0963134765625,185.6493377685547],[272.32305908203125,185.89944458007812],[272.5506591796875,186.14877319335938],[272.779052734375,186.39736938476562],[273.0082702636719,186.6452178955078],[273.2382507324219,186.89231872558594],[273.46905517578125,187.13868713378906],[273.7006530761719,187.3843231201172],[273.93304443359375,187.6291961669922],[274.16619873046875,187.87330627441406],[274.400146484375,188.11669921875],[274.6349182128906,188.35928344726562],[274.8706359863281,188.6009521484375],[275.10736083984375,188.84161376953125],[275.3451843261719,189.08120727539062],[275.5841064453125,189.31973266601562],[275.823974609375,189.5572509765625],[276.0648498535156,189.79379272460938],[276.306640625,190.02935791015625],[276.54937744140625,190.26397705078125],[276.7929992675781,190.49766540527344],[277.0375061035156,190.7304229736328],[277.2829284667969,190.96226501464844],[277.5291748046875,191.19320678710938],[277.7762145996094,191.4232635498047],[278.024169921875,191.65235900878906],[278.2729187011719,191.88058471679688],[278.5224304199219,192.10797119140625],[278.7726745605469,192.3345489501953],[279.0236511230469,192.56033325195312],[279.2753601074219,192.78530883789062],[279.5277404785156,193.00950622558594],[279.78082275390625,193.2329559326172],[280.0345153808594,193.45562744140625],[280.28887939453125,193.67758178710938],[280.5439453125,193.89874267578125],[280.79962158203125,194.11920166015625],[281.0558776855469,194.33897399902344],[281.3127136230469,194.55807495117188],[281.570068359375,194.77651977539062],[281.8281555175781,194.99417114257812],[282.0867004394531,195.2112274169922],[282.345458984375,195.42799377441406],[282.6051330566406,195.64373779296875],[282.8647766113281,195.85946655273438],[283.12548828125,196.073974609375],[283.38616943359375,196.2884521484375],[283.6476135253906,196.5020294189453],[283.90924072265625,196.71534729003906],[284.17138671875,196.92808532714844],[284.4339294433594,197.1403045654297],[284.69671630859375,197.35220336914062],[284.9600830078125,197.5634307861328],[285.2234802246094,197.7745819091797],[285.487548828125,197.98486328125],[285.75164794921875,198.1951446533203],[286.01629638671875,198.40472412109375],[286.28106689453125,198.61416625976562],[286.54620361328125,198.82313537597656],[286.8115539550781,199.0318145751953],[287.0771484375,199.24026489257812],[287.343017578125,199.44827270507812],[287.6089782714844,199.65618896484375],[287.87530517578125,199.86363220214844],[288.14166259765625,200.07106018066406],[288.40850830078125,200.27783203125],[288.6753845214844,200.4845428466797],[288.9422912597656,200.69126892089844],[289.2091979980469,200.8979949951172],[289.476318359375,201.10440063476562],[289.74371337890625,201.31045532226562],[290.0111389160156,201.51651000976562],[290.2785339355469,201.7225799560547],[290.5459289550781,201.92861938476562],[290.8135681152344,202.13438415527344],[291.0812072753906,202.3401641845703],[291.34881591796875,202.54592895507812],[291.616455078125,202.75169372558594],[291.88409423828125,202.95745849609375],[292.1517028808594,203.16322326660156],[292.4193420410156,203.36898803710938],[292.6869812011719,203.57473754882812],[292.95465087890625,203.7804412841797],[293.2237243652344,203.98431396484375],[293.4952392578125,204.18496704101562],[293.7689514160156,204.3824920654297],[294.04498291015625,204.57688903808594],[294.32305908203125,204.76824951171875],[294.60308837890625,204.95680236816406],[294.8849182128906,205.14260864257812],[295.168701171875,205.3254852294922],[295.4542541503906,205.50555419921875],[295.74139404296875,205.68307495117188],[296.0300598144531,205.8580780029297],[296.3202819824219,206.030517578125],[296.61199951171875,206.2003936767578],[296.9050598144531,206.36801147460938],[297.1993408203125,206.53343200683594],[297.494873046875,206.69659423828125],[297.7916564941406,206.8574676513672],[298.0895080566406,207.016357421875],[298.3883972167969,207.17330932617188],[298.688232421875,207.3284149169922],[298.9891357421875,207.48147583007812],[299.2908935546875,207.63282775878906],[299.59344482421875,207.7825469970703],[299.89678955078125,207.93072509765625],[300.2009582519531,208.0771942138672],[300.505615234375,208.22262573242188],[300.8102722167969,208.3680419921875],[301.11492919921875,208.51344299316406],[301.4195861816406,208.6588592529297],[301.7242431640625,208.8042755126953],[302.0286865234375,208.95022583007812],[302.3329772949219,209.09640502929688],[302.63726806640625,209.24258422851562],[302.9415588378906,209.38876342773438],[303.245849609375,209.5349578857422],[303.5500183105469,209.68138122558594],[303.85418701171875,209.82781982421875],[304.1583557128906,209.97427368164062],[304.4625244140625,210.12071228027344],[304.7666931152344,210.26715087890625],[305.07086181640625,210.41358947753906],[305.3750305175781,210.56002807617188],[305.67919921875,210.7064666748047],[305.9833679199219,210.8529052734375],[306.2877197265625,210.99900817871094],[306.5921936035156,211.1448211669922],[306.89666748046875,211.29063415527344],[307.2011413574219,211.4364471435547],[307.505615234375,211.58224487304688],[307.8103942871094,211.7274932861328],[308.1152038574219,211.87258911132812],[308.4201354980469,212.0174102783203],[308.7252502441406,212.16188049316406],[309.0303955078125,212.30628967285156],[309.3358459472656,212.4500274658203],[309.64129638671875,212.59376525878906],[309.9470520019531,212.73687744140625],[310.2528991699219,212.8797607421875],[310.5589294433594,213.02230834960938],[310.8652038574219,213.1642303466797],[311.1715393066406,213.30616760253906],[311.47833251953125,213.447021484375],[311.7851257324219,213.58787536621094],[312.09228515625,213.72796630859375],[312.39959716796875,213.8676300048828],[312.7071228027344,214.00692749023438],[313.0150451660156,214.14527893066406],[313.322998046875,214.2836456298828],[313.63153076171875,214.42066955566406],[313.9400939941406,214.5576171875],[314.2490234375,214.69366455078125],[314.55828857421875,214.8290557861328],[314.8676452636719,214.96417236328125],[315.17742919921875,215.09829711914062],[315.4875793457031,215.2316131591797],[315.798095703125,215.3641357421875],[316.10888671875,215.4958953857422],[316.4200439453125,215.62689208984375],[316.73150634765625,215.75709533691406],[317.0433044433594,215.886474609375],[317.35546875,216.01502990722656],[317.66802978515625,216.14251708984375],[317.98101806640625,216.26913452148438],[318.2943115234375,216.39483642578125],[318.60797119140625,216.5196075439453],[318.92205810546875,216.6434326171875],[319.2364807128906,216.7662811279297],[319.55133056640625,216.88807678222656],[319.86663818359375,217.00869750976562],[320.18231201171875,217.12828063964844],[320.4984130859375,217.24679565429688],[320.81494140625,217.36422729492188],[321.1318664550781,217.4805450439453],[321.4491882324219,217.59573364257812],[321.7669677734375,217.7096405029297],[322.085205078125,217.82223510742188],[322.4039001464844,217.93360900878906],[322.7230224609375,218.04376220703125],[323.0425720214844,218.15264892578125],[323.362548828125,218.26028442382812],[323.6829528808594,218.36659240722656],[324.0039367675781,218.4710693359375],[324.3255920410156,218.57363891601562],[324.6477966308594,218.67431640625],[324.9706115722656,218.7731475830078],[325.2939453125,218.87014770507812],[325.6178283691406,218.9653778076172],[325.9422302246094,219.058837890625],[326.26708984375,219.1505889892578],[326.5924377441406,219.2406463623047],[326.9182434082031,219.3290557861328],[327.2445068359375,219.41583251953125],[327.5711669921875,219.5010528564453],[327.898193359375,219.58470153808594],[328.22564697265625,219.66685485839844],[328.553466796875,219.7475128173828],[328.8816223144531,219.82669067382812],[329.21014404296875,219.90444946289062],[329.5389709472656,219.98080444335938],[329.86810302734375,220.05584716796875],[330.1975402832031,220.12957763671875],[330.52728271484375,220.2020263671875],[330.8572692871094,220.2732391357422],[331.1875,220.34327697753906],[331.51800537109375,220.41213989257812],[331.84869384765625,220.47988891601562],[332.1796569824219,220.54652404785156],[332.5108642578125,220.61183166503906],[332.8421936035156,220.67652893066406],[333.17376708984375,220.73992919921875],[333.5054626464844,220.80276489257812],[333.83740234375,220.86422729492188],[334.1694030761719,220.92532348632812],[334.5016784667969,220.98497009277344],[334.833984375,221.04444885253906],[335.16656494140625,221.1024627685547],[335.4991455078125,221.16033935546875],[335.8319396972656,221.21694946289062],[336.164794921875,221.27334594726562],[336.497802734375,221.32872009277344],[336.83087158203125,221.3837890625],[337.1640625,221.43804931640625],[337.497314453125,221.49192810058594],[337.8306884765625,221.5452117919922],[338.16412353515625,221.59805297851562],[338.49761962890625,221.65045166015625],[338.8312072753906,221.70223999023438],[339.16485595703125,221.75357055664062],[339.4985046386719,221.80491638183594],[339.8321838378906,221.85626220703125],[340.16595458984375,221.90682983398438],[340.499755859375,221.95716857910156],[340.8335876464844,222.0075225830078],[341.1673889160156,222.057861328125],[341.50128173828125,222.1077117919922],[341.8351745605469,222.1575469970703],[342.1690368652344,222.20738220214844],[342.5029296875,222.25723266601562],[342.8368225097656,222.30706787109375],[343.17071533203125,222.35690307617188],[343.5046081542969,222.40673828125],[343.8385009765625,222.4564971923828],[344.17242431640625,222.50613403320312],[344.50634765625,222.55575561523438],[344.8402404785156,222.6053924560547],[345.1741943359375,222.65501403808594],[345.50811767578125,222.70462036132812],[345.8421630859375,222.75338745117188],[346.17620849609375,222.80215454101562],[346.51025390625,222.85093688964844],[346.84429931640625,222.8997039794922],[347.1783447265625,222.948486328125],[347.5124816894531,222.99656677246094],[347.8466796875,223.04434204101562],[348.1808776855469,223.09210205078125],[348.5150451660156,223.13987731933594],[348.8492431640625,223.18763732910156],[349.1834716796875,223.23501586914062],[349.517822265625,223.2816162109375],[349.8521728515625,223.32823181152344],[350.1865539550781,223.3748321533203],[350.5209045410156,223.4214324951172],[350.8552551269531,223.46804809570312],[351.18975830078125,223.51368713378906],[351.52423095703125,223.55931091308594],[351.8587646484375,223.60472106933594],[352.1933288574219,223.649658203125],[352.5279235839844,223.69459533691406],[352.8625793457031,223.7390594482422],[353.197265625,223.7832489013672],[353.5319519042969,223.8274383544922],[353.8667297363281,223.87088012695312],[354.2015075683594,223.91427612304688],[354.53631591796875,223.95745849609375],[354.8711853027344,224.0000457763672],[355.2060852050781,224.04263305664062],[355.5410461425781,224.084716796875],[355.8760681152344,224.12643432617188],[356.2110595703125,224.16815185546875],[356.546142578125,224.2090606689453],[356.8812561035156,224.2498779296875],[357.2164001464844,224.2904815673828],[357.5516052246094,224.3303680419922],[357.8868408203125,224.3702392578125],[358.2221374511719,224.40957641601562],[358.5574645996094,224.448486328125],[358.8927917480469,224.4873809814453],[359.2282409667969,224.525390625],[359.5636901855469,224.56324768066406],[359.899169921875,224.60092163085938],[360.2347412109375,224.6377410888672],[360.5703430175781,224.67454528808594],[360.90594482421875,224.71078491210938],[361.24163818359375,224.74649047851562],[361.5773620605469,224.78221130371094],[361.91314697265625,224.81695556640625],[362.24896240234375,224.8515167236328],[362.5848083496094,224.88589477539062],[362.92071533203125,224.9192657470703],[363.25665283203125,224.95265197753906],[363.5926513671875,224.98544311523438],[363.9287109375,225.01759338378906],[364.2647705078125,225.04974365234375],[364.60089111328125,225.0808868408203],[364.93707275390625,225.11178588867188],[365.2732238769531,225.1425018310547],[365.6095275878906,225.17208862304688],[365.94580078125,225.20166015625],[366.28216552734375,225.2306365966797],[366.6186218261719,225.25888061523438],[366.95501708984375,225.287109375],[367.29150390625,225.3142852783203],[367.6280212402344,225.3411407470703],[367.96453857421875,225.3678436279297],[368.3011779785156,225.3932647705078],[368.6377868652344,225.41867065429688],[368.9744567871094,225.44346618652344],[369.3111877441406,225.4674072265625],[369.6479187011719,225.49134826660156],[369.9847412109375,225.51417541503906],[370.32159423828125,225.53660583496094],[370.6584167480469,225.5589141845703],[370.995361328125,225.5797882080078],[371.3323059082031,225.60067749023438],[371.6693115234375,225.62091064453125],[372.00634765625,225.6401824951172],[372.3433837890625,225.6594696044922],[372.6804504394531,225.6780548095703],[373.0175476074219,225.69638061523438],[373.3546142578125,225.7147216796875],[373.69171142578125,225.73304748535156],[374.02880859375,225.7513885498047],[374.3658752441406,225.76971435546875],[374.7029724121094,225.7880401611328],[375.0400695800781,225.80638122558594],[375.37713623046875,225.82470703125],[375.7142333984375,225.84303283691406],[376.05133056640625,225.8613739013672],[376.3883972167969,225.87969970703125],[376.72552490234375,225.89804077148438],[377.0626220703125,225.91636657714844],[377.3996887207031,225.9346923828125],[377.7367858886719,225.95303344726562],[378.0738830566406,225.9713592529297],[378.41094970703125,225.98968505859375],[378.748046875,226.00802612304688],[379.08514404296875,226.0264434814453],[379.4222106933594,226.0448760986328],[379.7593078613281,226.0633087158203],[380.09637451171875,226.0817413330078],[380.4334716796875,226.1001739501953],[380.7705383300781,226.11862182617188],[381.1076354980469,226.13705444335938],[381.4447021484375,226.15548706054688],[381.7818298339844,226.17391967773438],[382.118896484375,226.19247436523438],[382.4559631347656,226.2112579345703],[382.79302978515625,226.2300262451172],[383.13006591796875,226.24880981445312],[383.4671325683594,226.267578125],[383.80419921875,226.28636169433594],[384.1412658691406,226.3051300048828],[384.47833251953125,226.32391357421875],[384.8153991699219,226.34268188476562],[385.1524658203125,226.36146545410156],[385.4894714355469,226.38084411621094],[385.8265075683594,226.40029907226562],[386.16351318359375,226.41973876953125],[386.50054931640625,226.43919372558594],[386.83758544921875,226.45864868164062],[387.17462158203125,226.47808837890625],[387.51165771484375,226.49754333496094],[387.8486633300781,226.51698303222656],[388.1856994628906,226.53643798828125],[388.5227355957031,226.55589294433594],[388.8597412109375,226.57533264160156],[389.19677734375,226.59478759765625],[389.5338134765625,226.61422729492188],[389.8708190917969,226.63368225097656],[390.2078552246094,226.65313720703125],[390.54486083984375,226.67257690429688],[390.88189697265625,226.69203186035156],[391.21893310546875,226.7115020751953],[391.5559387207031,226.7312469482422],[391.8929748535156,226.75099182128906],[392.22998046875,226.77072143554688],[392.5669860839844,226.79046630859375],[392.90399169921875,226.81021118164062],[393.2409973144531,226.82994079589844],[393.5780334472656,226.8496856689453],[393.9150390625,226.8694305419922],[394.2520446777344,226.88916015625],[394.58905029296875,226.90890502929688],[394.9260559082031,226.92864990234375],[395.2630615234375,226.94837951660156],[395.6000671386719,226.96812438964844],[395.93707275390625,226.9878692626953],[396.2740783691406,227.00759887695312],[396.611083984375,227.02734375],[396.9481201171875,227.04708862304688],[397.28515625,227.06607055664062],[397.6226806640625,227.0687255859375],[397.959716796875,227.05044555664062],[398.295166015625,227.01300048828125],[398.628173828125,226.95790100097656],[398.9580993652344,226.8865509033203],[399.2843933105469,226.8000946044922],[399.6065979003906,226.6994171142578],[399.9242858886719,226.58535766601562],[400.23712158203125,226.45852661132812],[400.544677734375,226.31939697265625],[400.8465270996094,226.1682891845703],[401.1421813964844,226.00537109375],[401.4309387207031,225.8306121826172],[401.712158203125,225.64389038085938],[401.9848937988281,225.44491577148438],[402.2471008300781,225.23239135742188],[402.4940490722656,225.00228881835938],[402.7292785644531,224.7602081298828],[402.9563903808594,224.51046752929688],[403.1777648925781,224.25559997558594],[403.394775390625,223.9970245361328],[403.60845947265625,223.7356719970703],[403.8197937011719,223.47242736816406],[404.0290832519531,223.20755004882812],[404.23681640625,222.9414520263672],[404.44390869140625,222.6748504638672],[404.6501770019531,222.40762329101562],[404.8564147949219,222.14035034179688],[405.0626525878906,221.8730926513672],[405.269775390625,221.60647583007812],[405.4775695800781,221.3404083251953],[405.68707275390625,221.07569885253906],[405.8990478515625,220.81297302246094],[406.1141052246094,220.55276489257812],[406.3337707519531,220.2964324951172],[406.5603332519531,220.0461883544922],[406.7967529296875,219.80526733398438],[407.0364685058594,219.5675811767578],[407.2773742675781,219.3310546875],[407.5188903808594,219.09519958496094],[407.76123046875,218.8601837158203],[408.004638671875,218.62625122070312],[408.24859619140625,218.39295959472656],[408.4932556152344,218.16033935546875],[408.73895263671875,217.92874145507812],[408.985107421875,217.69776916503906],[409.2318420410156,217.4673309326172],[409.4794006347656,217.23780822753906],[409.7274475097656,217.00881958007812],[409.9759216308594,216.78030395507812],[410.22503662109375,216.55245971679688],[410.4748229980469,216.3253631591797],[410.724853515625,216.0985565185547],[410.9748840332031,215.8717498779297],[411.2257385253906,215.64585876464844],[411.47674560546875,215.4201202392578],[411.727783203125,215.1943817138672],[411.9794006347656,214.96932983398438],[412.23101806640625,214.74429321289062],[412.48272705078125,214.51927185058594],[412.734619140625,214.29452514648438],[412.9865417480469,214.0697784423828],[413.2384338378906,213.84503173828125],[413.4903259277344,213.6202850341797],[413.7422180175781,213.39553833007812],[413.9939270019531,213.1705780029297],[414.24542236328125,212.9453887939453],[414.4969177246094,212.72018432617188],[414.74798583984375,212.49452209472656],[414.998779296875,212.26852416992188],[415.2495422363281,212.0425262451172],[415.4996032714844,211.81570434570312],[415.74932861328125,211.58856201171875],[415.99908447265625,211.36143493652344],[416.248046875,211.1334228515625],[416.49658203125,210.90492248535156],[416.7445983886719,210.67588806152344],[416.9918518066406,210.44610595703125],[417.23870849609375,210.2158203125],[417.4849853515625,209.98492431640625],[417.73040771484375,209.75311279296875],[417.97528076171875,209.520751953125],[418.21954345703125,209.2877197265625],[418.4638366699219,209.05474853515625],[418.7093505859375,208.82302856445312],[418.955810546875,208.5923309326172],[419.2030334472656,208.3624725341797],[419.4509582519531,208.13331604003906],[419.69976806640625,207.90518188476562],[419.9489440917969,207.67735290527344],[420.1990051269531,207.45062255859375],[420.44921875,207.2239990234375],[420.70037841796875,206.99839782714844],[420.9515686035156,206.77285766601562],[421.2035827636719,206.5482177734375],[421.45562744140625,206.32366943359375],[421.7084045410156,206.0998992919922],[421.96124267578125,205.87620544433594],[422.2147216796875,205.6532440185547],[422.46826171875,205.4303741455078],[422.722412109375,205.20816040039062],[422.9766540527344,204.9860382080078],[423.2314147949219,204.76454162597656],[423.4862976074219,204.543212890625],[423.74169921875,204.3223876953125],[423.99725341796875,204.101806640625],[424.2532043457031,203.88169860839844],[424.50946044921875,203.6619415283203],[424.7660217285156,203.44252014160156],[425.0230407714844,203.22364807128906],[425.2802429199219,203.00502014160156],[425.5380554199219,202.78709411621094],[425.7973937988281,202.57101440429688],[426.06646728515625,202.36721801757812],[426.3453674316406,202.177001953125],[426.63275146484375,202],[426.92767333984375,201.8357696533203],[427.2293395996094,201.684326171875],[427.5369567871094,201.54534912109375],[427.8499450683594,201.41880798339844],[428.1677551269531,201.30502319335938],[428.4898681640625,201.20407104492188],[428.8157958984375,201.1162567138672],[429.1451721191406,201.0424041748047],[429.4774475097656,200.9828643798828],[429.81207275390625,200.93869018554688],[430.14849853515625,200.91087341308594],[430.4857482910156,200.89602661132812],[430.8232421875,200.8888397216797],[431.1607971191406,200.88868713378906],[431.4983215332031,200.8950958251953],[431.835693359375,200.9076690673828],[432.1727600097656,200.92596435546875],[432.509521484375,200.94932556152344],[432.8459777832031,200.97727966308594],[433.1820373535156,201.0093994140625],[433.5177001953125,201.04531860351562],[433.85296630859375,201.08456420898438],[434.18792724609375,201.12660217285156],[434.5225830078125,201.1709747314453],[434.8569641113281,201.21731567382812],[435.19110107421875,201.26541137695312],[435.5251159667969,201.31442260742188],[435.85906982421875,201.3640899658203],[436.1929016113281,201.4141845703125],[436.5267639160156,201.46408081054688],[436.86065673828125,201.51390075683594],[437.1947021484375,201.56277465820312],[437.52886962890625,201.61038208007812],[437.8633728027344,201.6562957763672],[438.1981201171875,201.7001495361328],[438.53314208984375,201.74151611328125],[438.8685302734375,201.78001403808594],[439.2042236328125,201.81556701660156],[439.54034423828125,201.84707641601562],[439.8768005371094,201.87437438964844],[440.2135314941406,201.89837646484375],[440.55029296875,201.9220733642578],[440.8870544433594,201.94577026367188],[441.2237854003906,201.96946716308594],[441.560546875,201.9931640625],[441.8973083496094,202.01686096191406],[442.2340393066406,202.04055786132812],[442.57080078125,202.0642547607422],[442.9075927734375,202.08795166015625],[443.2443542480469,202.1116485595703],[443.5810852050781,202.13534545898438],[443.9178466796875,202.15904235839844],[444.25457763671875,202.1829376220703],[444.5912780761719,202.20704650878906],[444.9280090332031,202.2311553955078],[445.2647399902344,202.25527954101562],[445.6014404296875,202.27938842773438],[445.93817138671875,202.30349731445312],[446.27490234375,202.32762145996094],[446.61163330078125,202.3517303466797],[446.9483337402344,202.37583923339844],[447.2850646972656,202.3999481201172],[447.6217956542969,202.424072265625],[447.95855712890625,202.44818115234375],[448.2952575683594,202.4725341796875],[448.6319274902344,202.49720764160156],[448.9686279296875,202.5218963623047],[449.3052978515625,202.54656982421875],[449.6419677734375,202.57125854492188],[449.9786682128906,202.59593200683594],[450.3153381347656,202.62062072753906],[450.65203857421875,202.6453094482422],[450.98870849609375,202.66998291015625],[451.32537841796875,202.69467163085938],[451.6620788574219,202.71934509277344],[451.9987487792969,202.74403381347656],[452.33544921875,202.76901245117188],[452.67205810546875,202.79443359375],[453.00872802734375,202.81983947753906],[453.3453369140625,202.84524536132812],[453.6819763183594,202.8706512451172],[454.01861572265625,202.89605712890625],[454.355224609375,202.9214630126953],[454.6918640136719,202.94688415527344],[455.02850341796875,202.9722900390625],[455.3651123046875,202.99769592285156],[455.7017517089844,203.02310180664062],[456.0383605957031,203.0485076904297],[456.3749694824219,203.07424926757812],[456.7115478515625,203.1002960205078],[457.0481262207031,203.12635803222656],[457.38470458984375,203.15240478515625],[457.7212829589844,203.17845153808594],[458.0578918457031,203.2045135498047],[458.3944396972656,203.2308349609375],[458.7309875488281,203.2573699951172],[459.0675048828125,203.28390502929688],[459.404052734375,203.3104248046875],[459.7406005859375,203.3369598388672],[460.0771484375,203.36349487304688],[460.4136657714844,203.39036560058594],[460.7501525878906,203.41741943359375],[461.086669921875,203.44447326660156],[461.42315673828125,203.4715118408203],[461.7596435546875,203.49856567382812],[462.0961608886719,203.52561950683594],[462.4326477050781,203.5531005859375],[462.76910400390625,203.58070373535156],[463.1055908203125,203.60830688476562],[463.4420471191406,203.6359100341797],[463.77850341796875,203.6635284423828],[464.11492919921875,203.69113159179688],[464.45135498046875,203.71923828125],[464.7877502441406,203.7474365234375],[465.1241455078125,203.775634765625],[465.4605712890625,203.80384826660156],[465.7969665527344,203.83204650878906],[466.13336181640625,203.86024475097656],[466.4697265625,203.88905334472656],[466.80609130859375,203.9178924560547],[467.1424255371094,203.9467315673828],[467.4787902832031,203.97555541992188],[467.81512451171875,204.00439453125],[468.1515197753906,204.0332794189453],[468.48779296875,204.0627899169922],[468.8240966796875,204.09230041503906],[469.160400390625,204.12179565429688],[469.4966735839844,204.15130615234375],[469.8329772949219,204.18081665039062],[470.16925048828125,204.21044921875],[470.5054931640625,204.24066162109375],[470.8417053222656,204.2708740234375],[471.1779479980469,204.30108642578125],[471.5141906738281,204.331298828125],[471.85040283203125,204.36151123046875],[472.1866149902344,204.39195251464844],[472.5227966308594,204.4228973388672],[472.85894775390625,204.453857421875],[473.19512939453125,204.48480224609375],[473.53131103515625,204.5157470703125],[473.8674621582031,204.5467071533203],[474.20361328125,204.57798767089844],[474.5397033691406,204.60972595214844],[474.87579345703125,204.64144897460938],[475.2118835449219,204.67318725585938],[475.5479736328125,204.7049102783203],[475.8840637207031,204.73663330078125],[476.2200927734375,204.76881408691406],[476.5561218261719,204.80136108398438],[476.8921203613281,204.8339080810547],[477.2281494140625,204.86643981933594],[477.56414794921875,204.89898681640625],[477.9001770019531,204.9315185546875],[478.2361145019531,204.96463012695312],[478.57208251953125,204.99801635742188],[478.90802001953125,205.03140258789062],[479.2439270019531,205.06478881835938],[479.5798645019531,205.09817504882812],[479.9158020019531,205.13156127929688],[480.2516784667969,205.16561889648438],[480.5875244140625,205.1998748779297],[480.9233703613281,205.234130859375],[481.25921630859375,205.26840209960938],[481.5950622558594,205.3026580810547],[481.930908203125,205.3369140625],[482.2666320800781,205.37196350097656],[482.6023864746094,205.40713500976562],[482.9381408691406,205.4423065185547],[483.2738952636719,205.47747802734375],[483.60968017578125,205.5126495361328],[483.9454040527344,205.5478057861328],[484.28106689453125,205.58389282226562],[484.61669921875,205.6199951171875],[484.9523620605469,205.65611267089844],[485.2879943847656,205.6922149658203],[485.6236572265625,205.7283172607422],[485.95928955078125,205.7644805908203],[486.2948303222656,205.8015594482422],[486.63037109375,205.83863830566406],[486.9659118652344,205.87571716308594],[487.3014831542969,205.9127960205078],[487.63702392578125,205.94985961914062],[487.9725341796875,205.987060546875],[488.3079528808594,206.02513122558594],[488.6434326171875,206.06320190429688],[488.9788513183594,206.1012725830078],[489.3143005371094,206.13934326171875],[489.64971923828125,206.1774139404297],[489.9851379394531,206.21566772460938],[490.3204345703125,206.2547607421875],[490.65576171875,206.29385375976562],[490.9910888671875,206.33294677734375],[491.3263854980469,206.3720245361328],[491.6617126464844,206.41111755371094],[491.99700927734375,206.450439453125],[492.33221435546875,206.49058532714844],[492.6673889160156,206.53073120117188],[493.0025939941406,206.57086181640625],[493.3377685546875,206.6110076904297],[493.6730041503906,206.65115356445312],[494.0081481933594,206.69154357910156],[494.34320068359375,206.73275756835938],[494.67828369140625,206.7739715576172],[495.0133361816406,206.815185546875],[495.348388671875,206.85638427734375],[495.6834411621094,206.89759826660156],[496.01849365234375,206.93905639648438],[496.3533935546875,206.9813690185547],[496.6883239746094,207.02366638183594],[497.02325439453125,207.06597900390625],[497.3581848144531,207.10829162597656],[497.6930847167969,207.1505889892578],[498.02801513671875,207.193115234375],[498.36279296875,207.23654174804688],[498.6976013183594,207.27996826171875],[499.0323791503906,207.32339477539062],[499.3671569824219,207.3668212890625],[499.7019348144531,207.41024780273438],[500.03668212890625,207.45382690429688],[500.3713073730469,207.49838256835938],[500.7059631347656,207.54293823242188],[501.04058837890625,207.58750915527344],[501.3752136230469,207.63206481933594],[501.7098388671875,207.67662048339844],[502.0444641113281,207.72125244140625],[502.3789367675781,207.7669677734375],[502.7134094238281,207.81268310546875],[503.0478820800781,207.8583984375],[503.3823547363281,207.9041290283203],[503.71685791015625,207.94984436035156],[504.05133056640625,207.9955596923828],[504.3856506347656,208.04244995117188],[504.71978759765625,208.09054565429688],[505.0537414550781,208.13987731933594],[505.3875427246094,208.19039916992188],[505.7211608886719,208.2421417236328],[506.0545349121094,208.2950897216797],[506.3877258300781,208.34925842285156],[506.72076416015625,208.40464782714844],[507.0535888671875,208.46124267578125],[507.38616943359375,208.51902770996094],[507.7185363769531,208.5780487060547],[508.05072021484375,208.63829040527344],[508.3826599121094,208.69972229003906],[508.71441650390625,208.7623748779297],[509.0458984375,208.82630920410156],[509.37713623046875,208.89149475097656],[509.7080993652344,208.95790100097656],[510.03887939453125,209.02552795410156],[510.3693542480469,209.0943603515625],[510.6995544433594,209.1644287109375],[511.029541015625,209.23573303222656],[511.3592529296875,209.3082275390625],[511.6886901855469,209.38197326660156],[512.017822265625,209.45693969726562],[512.3467407226562,209.53314208984375],[512.67529296875,209.61056518554688],[513.0036010742188,209.68923950195312],[513.3316040039062,209.7691192626953],[513.6593017578125,209.85031127929688],[513.9866943359375,209.93280029296875],[514.3136596679688,210.01654052734375],[514.640380859375,210.10153198242188],[514.9667358398438,210.18777465820312],[515.2928466796875,210.27525329589844],[515.6185302734375,210.36399841308594],[515.9439086914062,210.45401000976562],[516.2689208984375,210.5452880859375],[516.5935668945312,210.63783264160156],[516.9178466796875,210.73162841796875],[517.2417602539062,210.82672119140625],[517.5653076171875,210.92308044433594],[517.888427734375,211.02072143554688],[518.211181640625,211.11968994140625],[518.5335693359375,211.2200469970703],[518.8555297851562,211.32167053222656],[519.177001953125,211.4246063232422],[519.4981079101562,211.52883911132812],[519.8187255859375,211.63438415527344],[520.1389770507812,211.74124145507812],[520.4588012695312,211.8494415283203],[520.778076171875,211.95895385742188],[521.096923828125,212.06979370117188],[521.4153442382812,212.1819610595703],[521.7332763671875,212.29547119140625],[522.0507202148438,212.4103546142578],[522.36767578125,212.52658081054688],[522.6841430664062,212.6441650390625],[523.0000610351562,212.7631072998047],[523.3154296875,212.88352966308594],[523.6303100585938,213.0052947998047],[523.9446411132812,213.12844848632812],[524.2583618164062,213.25302124023438],[524.5715942382812,213.37896728515625],[524.8842163085938,213.50631713867188],[525.1962890625,213.63507080078125],[525.5078125,213.76524353027344],[525.8186645507812,213.89683532714844],[526.1289672851562,214.0298614501953],[526.4385375976562,214.1644287109375],[526.7473754882812,214.30068969726562],[527.0554809570312,214.43878173828125],[527.3627319335938,214.57864379882812],[527.6691284179688,214.72027587890625],[527.9747924804688,214.86366271972656],[528.2796020507812,215.0087432861328],[528.5836181640625,215.15548706054688],[528.8868408203125,215.30393981933594],[529.189208984375,215.4539794921875],[529.4908447265625,215.6056365966797],[529.7916259765625,215.7588348388672],[530.0916748046875,215.91354370117188],[530.3909912109375,216.0697479248047],[530.6895141601562,216.2273712158203],[530.9872436523438,216.38644409179688],[531.2842407226562,216.54689025878906],[531.58056640625,216.708740234375],[531.8760375976562,216.87191772460938],[532.1708374023438,217.03640747070312],[532.4649658203125,217.20223999023438],[532.75830078125,217.36929321289062],[533.0509033203125,217.53759765625],[533.3428955078125,217.70709228515625],[533.6340942382812,217.87782287597656],[533.9246826171875,218.0497283935547],[534.2145385742188,218.22276306152344],[534.503662109375,218.39695739746094],[534.7921752929688,218.57223510742188],[535.080078125,218.74856567382812],[535.3673095703125,218.9259033203125],[535.6539306640625,219.104248046875],[535.93994140625,219.28358459472656],[536.225341796875,219.46392822265625],[536.510009765625,219.6453857421875],[536.7941284179688,219.82772827148438],[537.0779418945312,220.0105743408203],[537.36083984375,220.19479370117188],[537.6435546875,220.37924194335938],[537.92529296875,220.5652313232422],[538.2069702148438,220.751220703125],[538.4876098632812,220.93890380859375],[538.7681884765625,221.1265869140625],[539.0479125976562,221.3156280517578],[539.3274536132812,221.50491333007812],[539.6062622070312,221.69525146484375],[539.884765625,221.88601684570312],[540.1627197265625,222.0775909423828],[540.4402465820312,222.269775390625],[540.7174072265625,222.4625244140625],[540.9940185546875,222.6560516357422],[541.2704467773438,222.8498992919922],[541.5462036132812,223.0446319580078],[541.8218383789062,223.239501953125],[542.0968017578125,223.4353485107422],[542.3717651367188,223.63121032714844],[542.64599609375,223.8280792236328],[542.9202270507812,224.02496337890625],[543.1939086914062,224.22265625],[543.4674072265625,224.42047119140625],[543.7405395507812,224.6189422607422],[544.013427734375,224.81764221191406],[544.2860107421875,225.0167999267578],[544.558349609375,225.2162628173828],[544.8303833007812,225.41619873046875],[545.1019897460938,225.61668395996094],[545.3736572265625,225.81715393066406],[545.645263671875,226.0176239013672],[545.9166870117188,226.21827697753906],[546.1876831054688,226.4196319580078],[546.4586181640625,226.62098693847656],[546.7296142578125,226.82235717773438],[547.0005493164062,227.02371215820312],[547.271484375,227.22506713867188],[547.54248046875,227.4264373779297],[547.8134155273438,227.62779235839844],[548.0840454101562,227.82960510253906],[548.3545532226562,228.03158569335938],[548.6250610351562,228.2335662841797],[548.8955688476562,228.43553161621094],[549.1660766601562,228.6375274658203],[549.4365844726562,228.83950805664062],[549.7070922851562,229.04148864746094],[549.9774780273438,229.24359130859375],[550.2474975585938,229.44615173339844],[550.517578125,229.6487274169922],[550.78759765625,229.85128784179688],[551.0576782226562,230.05386352539062],[551.3276977539062,230.25643920898438],[551.5977783203125,230.45899963378906],[551.8678588867188,230.6615753173828],[552.1375732421875,230.86456298828125],[552.4072265625,231.0677032470703],[552.6768188476562,231.2708282470703],[552.9464721679688,231.47396850585938],[553.2161254882812,231.67710876464844],[553.4857788085938,231.8802490234375],[553.75537109375,232.08338928222656],[554.02490234375,232.2866668701172],[554.2941284179688,232.4903564453125],[554.5633544921875,232.69403076171875],[554.8325805664062,232.89772033691406],[555.101806640625,233.1013946533203],[555.3709716796875,233.30508422851562],[555.6401977539062,233.50875854492188],[555.909423828125,233.7124481201172],[556.1783447265625,233.91653442382812],[556.4471435546875,234.12074279785156],[556.7159423828125,234.32496643066406],[556.9848022460938,234.5291748046875],[557.2536010742188,234.73338317871094],[557.5224609375,234.9376220703125],[557.791259765625,235.14183044433594],[558.0599365234375,235.34617614746094],[558.328369140625,235.55088806152344],[558.5968017578125,235.75559997558594],[558.865234375,235.96031188964844],[559.1337280273438,236.16502380371094],[559.4021606445312,236.36972045898438],[559.6705932617188,236.57443237304688],[559.9390258789062,236.77914428710938],[560.2071533203125,236.98423767089844],[560.4752197265625,237.18943786621094],[560.7432861328125,237.39462280273438],[561.0113525390625,237.59982299804688],[561.2794189453125,237.8050079345703],[561.5475463867188,238.01022338867188],[561.8156127929688,238.21542358398438],[562.0835571289062,238.4207305908203],[562.3512573242188,238.6263885498047],[562.6189575195312,238.83203125],[562.8866577148438,239.03768920898438],[563.1544189453125,239.24334716796875],[563.422119140625,239.44898986816406],[563.6898193359375,239.65464782714844],[563.95751953125,239.8603057861328],[564.2249755859375,240.06631469726562],[564.4923706054688,240.2723846435547],[564.759765625,240.4784698486328],[565.0271606445312,240.68455505371094],[565.2945556640625,240.89064025878906],[565.5619506835938,241.09674072265625],[565.829345703125,241.30282592773438],[566.0966186523438,241.509033203125],[566.3636474609375,241.71554565429688],[566.6307373046875,241.9220428466797],[566.8977661132812,242.12855529785156],[567.1648559570312,242.33505249023438],[567.431884765625,242.54156494140625],[567.6989135742188,242.74807739257812],[567.9660034179688,242.95457458496094],[568.2328491210938,243.16139221191406],[568.4995727539062,243.3682861328125],[568.766357421875,243.57518005371094],[569.0330810546875,243.78207397460938],[569.2998657226562,243.9889678955078],[569.566650390625,244.1958770751953],[569.8333740234375,244.40277099609375],[570.1000366210938,244.60977172851562],[570.3665161132812,244.81703186035156],[570.6329956054688,245.02430725097656],[570.8994140625,245.2315673828125],[571.1658935546875,245.4388427734375],[571.432373046875,245.6461181640625],[571.6988525390625,245.85337829589844],[571.9652709960938,246.06065368652344],[572.2315063476562,246.2681884765625],[572.4977416992188,246.47581481933594],[572.763916015625,246.6834259033203],[573.0300903320312,246.89105224609375],[573.2963256835938,247.09866333007812],[573.5625,247.30630493164062],[573.8287353515625,247.513916015625],[574.0947875976562,247.72169494628906],[574.360595703125,247.92979431152344],[574.6264038085938,248.1378936767578],[574.8922729492188,248.3459930419922],[575.1580810546875,248.55409240722656],[575.4238891601562,248.76219177246094],[575.689697265625,248.9702911376953],[575.9555053710938,249.1783905029297],[576.2213134765625,249.38648986816406],[576.4871215820312,249.59458923339844],[576.7529907226562,249.8026885986328],[577.018798828125,250.0107879638672],[577.2846069335938,250.21888732910156],[577.5504150390625,250.42701721191406],[577.8162841796875,250.63511657714844],[578.0819091796875,250.8433837890625],[578.3472900390625,251.05206298828125],[578.6126708984375,251.26072692871094],[578.8780517578125,251.4694061279297],[579.1433715820312,251.67808532714844],[579.4087524414062,251.88674926757812],[579.6741333007812,252.09542846679688],[579.9395141601562,252.30410766601562],[580.204833984375,252.5127716064453],[580.47021484375,252.72145080566406],[580.735595703125,252.9301300048828],[581.0009765625,253.1387939453125],[581.2662963867188,253.34747314453125],[581.53173828125,253.55616760253906],[581.7970581054688,253.7648468017578],[582.0623168945312,253.97366333007812],[582.3273315429688,254.18283081054688],[582.59228515625,254.39198303222656],[582.8572998046875,254.6011505126953],[583.1222534179688,254.810302734375],[583.3872680664062,255.01947021484375],[583.6522216796875,255.22862243652344],[583.917236328125,255.4377899169922],[584.1821899414062,255.64694213867188],[584.4472045898438,255.85610961914062],[584.712158203125,256.0652770996094],[584.9771728515625,256.2744140625],[585.2421264648438,256.48358154296875],[585.5071411132812,256.6927490234375],[585.7720947265625,256.90191650390625],[586.0369873046875,257.1112060546875],[586.3016967773438,257.3207702636719],[586.5663452148438,257.53033447265625],[586.8309936523438,257.7398986816406],[587.0956420898438,257.949462890625],[587.3603515625,258.1590270996094],[587.625,258.36859130859375],[587.8896484375,258.578125],[588.154296875,258.7876892089844],[588.4190063476562,258.99725341796875],[588.6836547851562,259.2068176269531],[588.9483032226562,259.4163818359375],[589.2130126953125,259.6259460449219],[589.4776611328125,259.8355407714844],[589.7423706054688,260.04510498046875],[590.0069580078125,260.2547607421875],[590.2713012695312,260.4646301269531],[590.5357055664062,260.67449951171875],[590.8001708984375,260.8843994140625],[591.0645751953125,261.0942687988281],[591.3289794921875,261.30413818359375],[591.5934448242188,261.5140686035156],[591.8578491210938,261.7239685058594],[592.1222534179688,261.933837890625],[592.3866577148438,262.1437072753906],[592.6510620117188,262.3536071777344],[592.9154663085938,262.5634765625],[593.1798706054688,262.77337646484375],[593.4442749023438,262.9832458496094],[593.708740234375,263.1931457519531],[593.9730224609375,263.4031066894531],[594.2372436523438,263.6133117675781],[594.5014038085938,263.823486328125],[594.7655639648438,264.03369140625],[595.0297241210938,264.2438659667969],[595.2938842773438,264.4540710449219],[595.5580444335938,264.6642761230469],[595.8222045898438,264.87445068359375],[596.0863647460938,265.08465576171875],[596.3505249023438,265.2948303222656],[596.6146850585938,265.5050354003906],[596.8788452148438,265.7152099609375],[597.14306640625,265.9254150390625],[597.4072265625,266.1355895996094],[597.67138671875,266.3457946777344],[597.935546875,266.5559997558594],[598.19970703125,266.76617431640625],[598.4638671875,266.97637939453125],[598.72802734375,267.1865539550781],[598.9921875,267.3967590332031],[599.25634765625,267.60693359375],[599.5205688476562,267.8171691894531],[599.7847290039062,268.0273742675781],[600.0488891601562,268.237548828125],[600.3130493164062,268.44775390625],[600.5772094726562,268.6579284667969],[600.8414306640625,268.8681335449219],[601.1055908203125,269.07830810546875],[601.3697509765625,269.28851318359375],[601.6339111328125,269.49871826171875],[601.8980102539062,269.70892333984375],[602.1620483398438,269.91925048828125],[602.4261474609375,270.12957763671875],[602.690185546875,270.33990478515625],[602.9542236328125,270.55023193359375],[603.2183227539062,270.76055908203125],[603.4823608398438,270.97088623046875],[603.7463989257812,271.18121337890625],[604.010498046875,271.39154052734375],[604.2745361328125,271.60186767578125],[604.53857421875,271.81219482421875],[604.8026733398438,272.02252197265625],[605.0667114257812,272.23284912109375],[605.3307495117188,272.44317626953125],[605.5948486328125,272.65350341796875],[605.85888671875,272.86383056640625],[606.1229248046875,273.07415771484375],[606.386962890625,273.28448486328125],[606.6510620117188,273.49481201171875],[606.9151000976562,273.70513916015625],[607.1791381835938,273.91546630859375],[607.4432373046875,274.1258544921875],[607.7073364257812,274.336181640625],[607.9713745117188,274.5465087890625],[608.2354125976562,274.7568359375],[608.49951171875,274.9671630859375],[608.7635498046875,275.177490234375],[609.027587890625,275.3878173828125],[609.2916870117188,275.59814453125],[609.5557250976562,275.8084716796875],[609.8194580078125,276.0191650390625],[610.0822143554688,276.2311706542969],[610.3433227539062,276.4450378417969],[610.6029052734375,276.6608581542969],[610.8607788085938,276.8787536621094],[611.1172485351562,277.0982971191406],[611.372314453125,277.3194885253906],[611.6259765625,277.54217529296875],[611.8783569335938,277.7664489746094],[612.12939453125,277.99212646484375],[612.3790283203125,278.2193908691406],[612.6271362304688,278.4482727050781],[612.8739624023438,278.67852783203125],[613.11962890625,278.91015625],[613.3638916015625,279.14312744140625],[613.60693359375,279.37744140625],[613.848388671875,279.61334228515625],[614.0885009765625,279.8506774902344],[614.3272094726562,280.0893249511719],[614.5645751953125,280.3293762207031],[614.8005981445312,280.5707702636719],[615.0352172851562,280.8135681152344],[615.2680053710938,281.05810546875],[615.499267578125,281.30401611328125],[615.7289428710938,281.5513916015625],[615.95703125,281.8002624511719],[616.1834716796875,282.0506591796875],[616.4080810546875,282.3026428222656],[616.6305541992188,282.5565185546875],[616.8510131835938,282.8122253417969],[617.0693969726562,283.0696716308594],[617.2855224609375,283.3290100097656],[617.4992065429688,283.59027099609375],[617.7107543945312,283.8534240722656],[617.9190673828125,284.1189880371094],[618.1244506835938,284.386962890625],[618.3264770507812,284.6573791503906],[618.5224609375,284.93218994140625],[618.6504516601562,285.2431640625],[618.692138671875,285.577392578125],[618.6702880859375,285.9138488769531],[618.60400390625,286.24468994140625],[618.5062255859375,286.56768798828125],[618.3849487304688,286.8826904296875],[618.24560546875,287.19012451171875],[618.0916748046875,287.4905090332031],[617.92529296875,287.78424072265625],[617.748291015625,288.07171630859375],[617.5687866210938,288.35760498046875],[617.3892211914062,288.64349365234375],[617.2096557617188,288.9293518066406],[617.0300903320312,289.2153015136719],[616.8505859375,289.5011901855469],[616.6710205078125,289.7870788574219],[616.4915161132812,290.0729675292969],[616.3119506835938,290.35882568359375],[616.1324462890625,290.64471435546875],[615.952880859375,290.93060302734375],[615.7731323242188,291.2163391113281],[615.5932006835938,291.501953125],[615.4132080078125,291.7875671386719],[615.2332763671875,292.07318115234375],[615.0532836914062,292.3587951660156],[614.8733520507812,292.6444396972656],[614.693359375,292.9300537109375],[614.513427734375,293.2156677246094],[614.3334350585938,293.50128173828125],[614.1535034179688,293.7868957519531],[613.9735717773438,294.072509765625],[613.793212890625,294.3578796386719],[613.61279296875,294.6432189941406],[613.432373046875,294.9285583496094],[613.251953125,295.2138977050781],[613.071533203125,295.4992370605469],[612.8911743164062,295.7845764160156],[612.7107543945312,296.06988525390625],[612.5303344726562,296.355224609375],[612.3499145507812,296.64056396484375],[612.1694946289062,296.9259033203125],[611.9889526367188,297.2111511230469],[611.8080444335938,297.4961853027344],[611.6271362304688,297.78125],[611.4462890625,298.0662841796875],[611.265380859375,298.351318359375],[611.0845336914062,298.6363525390625],[610.9036254882812,298.9214172363281],[610.7227172851562,299.2064514160156],[610.5418701171875,299.4914855957031],[610.3609619140625,299.7765197753906],[610.1801147460938,300.0615539550781],[609.998779296875,300.3462829589844],[609.8173828125,300.6310119628906],[609.6360473632812,300.9157409667969],[609.4546508789062,301.2004699707031],[609.2732543945312,301.48516845703125],[609.0919189453125,301.7698974609375],[608.9105224609375,302.05462646484375],[608.7291259765625,302.33935546875],[608.5477294921875,302.6240539550781],[608.3663940429688,302.9087829589844],[608.1847534179688,303.1933288574219],[608.0028686523438,303.47772216796875],[607.8209838867188,303.7621154785156],[607.6390991210938,304.0465087890625],[607.4572143554688,304.3309326171875],[607.2753295898438,304.6153259277344],[607.0934448242188,304.89971923828125],[606.9115600585938,305.1841125488281],[606.7296752929688,305.468505859375],[606.5477905273438,305.7528991699219],[606.36572265625,306.0372314453125],[606.1832885742188,306.32135009765625],[606.0008544921875,306.60540771484375],[605.8184204101562,306.88946533203125],[605.6360473632812,307.17352294921875],[605.45361328125,307.45758056640625],[605.2711791992188,307.7416076660156],[605.0887451171875,308.0256652832031],[604.9063110351562,308.3097229003906],[604.7239379882812,308.5937805175781],[604.54150390625,308.8778381347656],[604.3585815429688,309.1615295410156],[604.1755981445312,309.44525146484375],[603.99267578125,309.7289733886719],[603.8096923828125,310.0126647949219],[603.626708984375,310.29638671875],[603.4437866210938,310.580078125],[603.2608032226562,310.8638000488281],[603.077880859375,311.14752197265625],[602.8948974609375,311.43121337890625],[602.7119750976562,311.7149353027344],[602.528564453125,311.9983825683594],[602.3450927734375,312.28173828125],[602.1615600585938,312.5650634765625],[601.97802734375,312.8484191894531],[601.7945556640625,313.13177490234375],[601.6110229492188,313.4151306152344],[601.427490234375,313.698486328125],[601.2440185546875,313.9818115234375],[601.0604858398438,314.2651672363281],[600.876953125,314.54852294921875],[600.6931762695312,314.83172607421875],[600.5090942382812,315.1147155761719],[600.3250122070312,315.397705078125],[600.1409301757812,315.6806945800781],[599.9569091796875,315.96368408203125],[599.7728271484375,316.2466735839844],[599.5887451171875,316.5296630859375],[599.4046630859375,316.8126525878906],[599.2205810546875,317.09564208984375],[599.0365600585938,317.3786315917969],[598.852294921875,317.66156005859375],[598.6676635742188,317.9441833496094],[598.4830322265625,318.226806640625],[598.2984619140625,318.50946044921875],[598.1138305664062,318.7920837402344],[597.92919921875,319.07470703125],[597.7445678710938,319.3573303222656],[597.5599365234375,319.63995361328125],[597.3753051757812,319.9225769042969],[597.190673828125,320.2052001953125],[597.0060424804688,320.4878234863281],[596.8209228515625,320.77008056640625],[596.6357421875,321.0523376464844],[596.4505615234375,321.3345947265625],[596.265380859375,321.61688232421875],[596.0801391601562,321.8991394042969],[595.8949584960938,322.181396484375],[595.7097778320312,322.4636535644531],[595.5245971679688,322.74591064453125],[595.3394165039062,323.0281677246094],[595.1542358398438,323.3104248046875],[594.9686889648438,323.5924987792969],[594.782958984375,323.8743896484375],[594.5972290039062,324.1562805175781],[594.4114990234375,324.43817138671875],[594.2257690429688,324.7200622558594],[594.0400390625,325.001953125],[593.854248046875,325.2838439941406],[593.6685180664062,325.5657653808594],[593.4827880859375,325.84765625],[593.2970581054688,326.1295471191406],[593.1112060546875,326.41143798828125],[592.9249267578125,326.6929626464844],[592.7386474609375,326.9744873046875],[592.5523681640625,327.2560119628906],[592.3660888671875,327.5375671386719],[592.1797485351562,327.819091796875],[591.9934692382812,328.1006164550781],[591.8071899414062,328.38214111328125],[591.6209106445312,328.6636962890625],[591.4346313476562,328.9452209472656],[591.2483520507812,329.22674560546875],[591.061767578125,329.5080261230469],[590.8749389648438,329.7892150878906],[590.6881103515625,330.0704040527344],[590.5012817382812,330.3515625],[590.314453125,330.63275146484375],[590.1276245117188,330.9139404296875],[589.9407958984375,331.1950988769531],[589.7540283203125,331.4762878417969],[589.5671997070312,331.7574462890625],[589.3803100585938,332.0386962890625],[589.1934814453125,332.3198547363281],[589.0062255859375,332.6007385253906],[588.81884765625,332.8815612792969],[588.6315307617188,333.16241455078125],[588.4441528320312,333.4432373046875],[588.2568359375,333.72406005859375],[588.0694580078125,334.0048828125],[587.8821411132812,334.28570556640625],[587.6947631835938,334.5665588378906],[587.5074462890625,334.8473815917969],[587.320068359375,335.1282043457031],[587.1327514648438,335.4090576171875],[586.9462280273438,335.6904296875],[586.7603759765625,335.9722595214844],[586.5758666992188,336.2549743652344],[586.392578125,336.5384216308594],[586.2097778320312,336.8222351074219],[586.0283813476562,337.10693359375],[585.8473510742188,337.3918762207031],[585.6671142578125,337.67730712890625],[585.4874877929688,337.963134765625],[585.3082275390625,338.2491760253906],[585.1296997070312,338.5357360839844],[584.9512329101562,338.822265625],[584.7727661132812,339.10882568359375],[584.5943603515625,339.39544677734375],[584.4160766601562,339.6820983886719],[584.2377319335938,339.9687805175781],[584.059326171875,340.2553405761719],[583.880126953125,340.54150390625],[583.700927734375,340.8276062011719],[583.521728515625,341.11370849609375],[583.3416137695312,341.399169921875],[583.1610717773438,341.6844177246094],[582.9793090820312,341.9689025878906],[582.7970581054688,342.2530822753906],[582.6138305664062,342.5365905761719],[582.429443359375,342.8193664550781],[582.2444458007812,343.10174560546875],[582.0574340820312,343.3828430175781],[581.8699340820312,343.66357421875],[581.6807250976562,343.9431457519531],[581.489990234375,344.2217102050781],[581.2977905273438,344.4991760253906],[581.1038818359375,344.7755432128906],[580.9080200195312,345.05047607421875],[580.7103881835938,345.32415771484375],[580.5108032226562,345.596435546875],[580.3092651367188,345.8672790527344],[580.10546875,346.13641357421875],[579.8993530273438,346.4037780761719],[579.69091796875,346.6693115234375],[579.4801635742188,346.9329833984375],[579.266845703125,347.19464111328125],[579.0509033203125,347.4541320800781],[578.8320922851562,347.7111511230469],[578.6105346679688,347.96588134765625],[578.3861694335938,348.2181396484375],[578.1588745117188,348.4677734375],[577.9282836914062,348.71435546875],[577.6945190429688,348.95794677734375],[577.457763671875,349.1985168457031],[577.2177734375,349.4359130859375],[576.9743041992188,349.6698303222656],[576.7271728515625,349.8998107910156],[576.4767456054688,350.1261291503906],[576.2203369140625,350.345703125],[575.95849609375,350.558837890625],[575.6915893554688,350.76544189453125],[575.419921875,350.9658203125],[575.1438598632812,351.16009521484375],[574.8636474609375,351.3484191894531],[574.57958984375,351.5307312011719],[574.2918701171875,351.7073059082031],[574.0009155273438,351.87847900390625],[573.7068481445312,352.0442199707031],[573.4099731445312,352.2049255371094],[573.1102294921875,352.3603210449219],[572.8079833984375,352.5107116699219],[572.5034790039062,352.6563415527344],[572.19677734375,352.7973937988281],[571.8880004882812,352.93377685546875],[571.5771484375,353.0655517578125],[571.2645874023438,353.1929931640625],[570.9503173828125,353.3162841796875],[570.6344604492188,353.4353942871094],[570.3170166015625,353.55029296875],[569.9981689453125,353.6612243652344],[569.6780395507812,353.7682800292969],[569.3566284179688,353.87152099609375],[569.033935546875,353.9707336425781],[568.7101440429688,354.0662841796875],[568.3853149414062,354.158203125],[568.0594482421875,354.24652099609375],[567.732666015625,354.3311462402344],[567.4049072265625,354.4121398925781],[567.0763549804688,354.4896240234375],[566.7470092773438,354.5635681152344],[566.4168701171875,354.63409423828125],[566.0859985351562,354.7010498046875],[565.75439453125,354.7643737792969],[565.4217529296875,354.8221435546875],[565.087890625,354.8718566894531],[564.7529296875,354.9139709472656],[564.4171752929688,354.9483642578125],[564.0806274414062,354.97540283203125],[563.74365234375,354.995361328125],[563.4063110351562,355.0082702636719],[563.0687866210938,355.01416015625],[562.7312622070312,355.01336669921875],[562.3937377929688,355.0060119628906],[562.0564575195312,354.99200439453125],[561.719482421875,354.97149658203125],[561.3829956054688,354.9446716308594],[561.0470581054688,354.91156005859375],[560.7117919921875,354.8720703125],[560.3773193359375,354.8262634277344],[560.0437622070312,354.7742614746094],[559.7112426757812,354.7160339355469],[559.3798217773438,354.65167236328125],[559.0497436523438,354.5807800292969],[558.7211303710938,354.5036926269531],[558.3939819335938,354.42034912109375],[558.0685424804688,354.33062744140625],[557.7449951171875,354.2342529296875],[557.4234619140625,354.1314392089844],[557.1041259765625,354.0220642089844],[556.787109375,353.9059753417969],[556.4727783203125,353.7828674316406],[556.1605834960938,353.654541015625],[555.8485107421875,353.52569580078125],[555.5364990234375,353.3968200683594],[555.2249145507812,353.26702880859375],[554.913330078125,353.1371154785156],[554.6017456054688,353.0071105957031],[554.2905883789062,352.8761901855469],[553.9793701171875,352.74530029296875],[553.6683349609375,352.6141357421875],[553.3576049804688,352.4822692871094],[553.0468139648438,352.35040283203125],[552.7362670898438,352.21807861328125],[552.4259033203125,352.0852966308594],[552.1155395507812,351.9524841308594],[551.805419921875,351.8190612792969],[551.4954223632812,351.6853332519531],[551.1854248046875,351.5516052246094],[550.8757934570312,351.41717529296875],[550.5662231445312,351.2825622558594],[550.2566528320312,351.14794921875],[549.9473876953125,351.01251220703125],[549.6381225585938,350.8770751953125],[549.3289184570312,350.7414855957031],[549.02001953125,350.6052551269531],[548.711181640625,350.468994140625],[548.4024658203125,350.33245849609375],[548.0939331054688,350.1954345703125],[547.785400390625,350.0583801269531],[547.4771118164062,349.92095947265625],[547.1689453125,349.7831726074219],[546.8607177734375,349.6453857421875],[546.552734375,349.5071105957031],[546.244873046875,349.36865234375],[545.9369506835938,349.23016357421875],[545.6295166015625,349.0907897949219],[545.3221435546875,348.9512939453125],[545.0147094726562,348.811767578125],[544.707275390625,348.6722412109375],[544.39990234375,348.5327453613281],[544.0925903320312,348.3929443359375],[543.7857666015625,348.252197265625],[543.4789428710938,348.1114501953125],[543.1720581054688,347.970703125],[542.865234375,347.8299255371094],[542.5584106445312,347.6891784667969],[542.2518310546875,347.54779052734375],[541.9454956054688,347.4058837890625],[541.63916015625,347.2640075683594],[541.3328857421875,347.1221008300781],[541.0265502929688,346.980224609375],[540.7201538085938,346.83831787109375],[540.414306640625,346.6955261230469],[540.1084594726562,346.5526428222656],[539.8026123046875,346.4097595214844],[539.4967651367188,346.266845703125],[539.19091796875,346.12396240234375],[538.8851318359375,345.9808654785156],[538.5797119140625,345.83709716796875],[538.2742309570312,345.69329833984375],[537.9688110351562,345.5495300292969],[537.6633911132812,345.40576171875],[537.35791015625,345.2619934082031],[537.052734375,345.1177978515625],[536.7476196289062,344.9732360839844],[536.4425659179688,344.8287048339844],[536.1375122070312,344.68414306640625],[535.8324584960938,344.5395812988281],[535.52734375,344.3950500488281],[535.2225341796875,344.2499084472656],[534.9177856445312,344.104736328125],[534.613037109375,343.95953369140625],[534.3082275390625,343.8143310546875],[534.0034790039062,343.66912841796875],[533.69873046875,343.5238037109375],[533.3942260742188,343.3780822753906],[533.0897216796875,343.23236083984375],[532.7852172851562,343.0866394042969],[532.4806518554688,342.94091796875],[532.1761474609375,342.7951965332031],[531.871826171875,342.6492004394531],[531.5675659179688,342.5029296875],[531.2633056640625,342.35662841796875],[530.9590454101562,342.2103271484375],[530.65478515625,342.06402587890625],[530.3505859375,341.9177551269531],[530.0463256835938,341.7714538574219],[529.7420654296875,341.62518310546875],[529.4378051757812,341.4788818359375],[529.1336059570312,341.3326110839844],[528.829345703125,341.1863098144531],[528.5250854492188,341.03997802734375],[528.2210083007812,340.8934020996094],[527.9169311523438,340.7467956542969],[527.61279296875,340.6002197265625],[527.3087158203125,340.45361328125],[527.004638671875,340.3070373535156],[526.7005004882812,340.1604309082031],[526.3964233398438,340.01385498046875],[526.0923461914062,339.86724853515625],[525.7882080078125,339.7206726074219],[525.484130859375,339.5740966796875],[525.1800537109375,339.427490234375],[524.8759155273438,339.2809143066406],[524.5718383789062,339.1343078613281],[524.2677612304688,338.98773193359375],[523.963623046875,338.84112548828125],[523.6595458984375,338.6945495605469],[523.35546875,338.5479736328125],[523.0513305664062,338.4013671875],[522.7472534179688,338.2547912597656],[522.4431762695312,338.1081848144531],[522.1389770507812,337.9615783691406],[521.8348999023438,337.81500244140625],[521.5307006835938,337.668701171875],[521.2262573242188,337.5227355957031],[520.921875,337.37677001953125],[520.6174926757812,337.2308349609375],[520.3130493164062,337.0848693847656],[520.0086669921875,336.93890380859375],[519.7042846679688,336.79296875],[519.3998413085938,336.6470031738281],[519.095458984375,336.5010681152344],[518.7910766601562,336.3551025390625],[518.4866333007812,336.2091369628906],[518.1821899414062,336.0632629394531],[517.87744140625,335.91802978515625],[517.5726928710938,335.7727966308594],[517.2679443359375,335.6275634765625],[516.9631958007812,335.4823303222656],[516.658447265625,335.33709716796875],[516.3536376953125,335.192138671875],[516.048583984375,335.04754638671875],[515.7435302734375,334.9029541015625],[515.4384155273438,334.7583923339844],[515.1333618164062,334.6138000488281],[514.8283081054688,334.4692077636719],[514.52294921875,334.3251647949219],[514.217529296875,334.18133544921875],[513.912109375,334.03753662109375],[513.6067504882812,333.8937072753906],[513.3013305664062,333.7498779296875],[512.9957885742188,333.6060791015625],[512.6900024414062,333.463134765625],[512.3841552734375,333.3201904296875],[512.0783081054688,333.17724609375],[511.7724914550781,333.0343017578125],[511.4666748046875,332.891357421875],[511.1606750488281,332.7488098144531],[510.8543701171875,332.60687255859375],[510.5480651855469,332.4649353027344],[510.2417907714844,332.322998046875],[509.93548583984375,332.1810607910156],[509.6291809082031,332.0390930175781],[509.32257080078125,331.89801025390625],[509.0157470703125,331.7571716308594],[508.7089538574219,331.6163330078125],[508.4021301269531,331.47552490234375],[508.0953369140625,331.3346862792969],[507.7884521484375,331.1939392089844],[507.4810791015625,331.0543518066406],[507.1736755371094,330.914794921875],[506.8663024902344,330.77520751953125],[506.5589294433594,330.6356201171875],[506.2515563964844,330.4960632324219],[505.9440002441406,330.3569030761719],[505.63616943359375,330.21832275390625],[505.3283386230469,330.07977294921875],[505.02032470703125,329.9416198730469],[504.712158203125,329.8037414550781],[504.4040222167969,329.6658935546875],[504.0955505371094,329.5285949707031],[503.7870178222656,329.3914489746094],[503.4785461425781,329.25433349609375],[503.1697082519531,329.11798095703125],[502.8608703613281,328.98162841796875],[502.55206298828125,328.8454284667969],[502.24285888671875,328.70989990234375],[501.9336853027344,328.57440185546875],[501.62432861328125,328.4390869140625],[501.3147888183594,328.3044128417969],[501.0052185058594,328.1697082519531],[500.6948547363281,328.0369873046875],[500.3792724609375,327.9171142578125],[500.05865478515625,327.8116760253906],[499.7337341308594,327.72015380859375],[499.40521240234375,327.6426086425781],[499.0735778808594,327.5796203613281],[498.7394714355469,327.5315856933594],[498.40338134765625,327.4998474121094],[498.066162109375,327.485595703125],[497.7286682128906,327.4906921386719],[497.3922119140625,327.5177917480469],[497.0587463378906,327.5697021484375],[496.73101806640625,327.650146484375],[496.4132385253906,327.7633972167969],[496.10589599609375,327.90301513671875],[495.80645751953125,328.0587463378906],[495.5147399902344,328.228515625],[495.2307434082031,328.4110107421875],[494.9546813964844,328.605224609375],[494.686767578125,328.81060791015625],[494.4275207519531,329.02685546875],[494.17755126953125,329.2537841796875],[493.93792724609375,329.491455078125],[493.7095947265625,329.74005126953125],[493.4939880371094,329.999755859375],[493.2929992675781,330.2709655761719],[493.1090393066406,330.55389404296875],[492.9452209472656,330.84893798828125],[492.8050231933594,331.1559753417969],[492.6935729980469,331.4744567871094],[492.6041564941406,331.7999572753906],[492.5234375,332.1277160644531],[492.4504699707031,332.45733642578125],[492.3849792480469,332.7884521484375],[492.32647705078125,333.12091064453125],[492.27471923828125,333.45452880859375],[492.2292175292969,333.7890319824219],[492.1893005371094,334.1242370605469],[492.1545715332031,334.4599914550781],[492.12457275390625,334.7962951660156],[492.0990905761719,335.1328430175781],[492.0776062011719,335.46978759765625],[492.0596923828125,335.806884765625],[492.04534912109375,336.1441650390625],[492.033447265625,336.48150634765625],[492.0239562988281,336.8190002441406],[492.0166015625,337.1564636230469],[492.0110168457031,337.4940185546875],[492.0071105957031,337.8315734863281],[492.0043029785156,338.16912841796875],[492.00238037109375,338.50677490234375],[492.00079345703125,338.8443603515625],[491.9991760253906,339.18194580078125],[491.99755859375,339.51953125],[491.9958801269531,339.85711669921875],[491.9931640625,340.1947021484375],[491.98931884765625,340.53228759765625],[491.9841003417969,340.8698425292969],[491.9771423339844,341.20733642578125],[491.9682312011719,341.5447692871094],[491.95721435546875,341.8821716308594],[491.9432678222656,342.219482421875],[491.92626953125,342.556640625],[491.9056701660156,342.8935852050781],[491.88134765625,343.2303161621094],[491.8529968261719,343.5666809082031],[491.82098388671875,343.90277099609375],[491.78863525390625,344.2388000488281],[491.7562561035156,344.5748291015625],[491.7239074707031,344.9108581542969],[491.6922912597656,345.2469177246094],[491.66070556640625,345.5830078125],[491.6291198730469,345.91912841796875],[491.59771728515625,346.2552490234375],[491.5665588378906,346.5914001464844],[491.5354309082031,346.92755126953125],[491.5042724609375,347.2637023925781],[491.47314453125,347.599853515625],[491.4420166015625,347.9360046386719],[491.4108581542969,348.2721252441406],[491.379638671875,348.60833740234375],[491.3482666015625,348.9444580078125],[491.3168640136719,349.28057861328125],[491.2854919433594,349.61669921875],[491.25360107421875,349.95281982421875],[491.2215576171875,350.28887939453125],[491.1895446777344,350.62493896484375],[491.1573181152344,350.9609375],[491.1242980957031,351.2969055175781],[491.0912780761719,351.63287353515625],[491.0582580566406,351.9688415527344],[491.0243835449219,352.30474853515625],[490.9900207519531,352.64056396484375],[490.9556579589844,352.9764099121094],[490.9211730957031,353.31219482421875],[490.8856201171875,353.6479187011719],[490.8497314453125,353.983642578125],[490.8132019042969,354.3192443847656],[490.776123046875,354.6547546386719],[490.73858642578125,354.990234375],[490.7001953125,355.3256530761719],[490.6615295410156,355.6610107421875],[490.6216735839844,355.9962463378906],[490.58154296875,356.3314514160156],[490.5404052734375,356.66650390625],[490.4986572265625,357.0014953613281],[490.4560852050781,357.33636474609375],[490.4125671386719,357.671142578125],[490.3685607910156,358.005859375],[490.3231201171875,358.34039306640625],[490.27734375,358.67486572265625],[490.2301330566406,359.0091247558594],[490.1822814941406,359.34332275390625],[490.1333312988281,359.6773376464844],[490.0832824707031,360.0111999511719],[490.032470703125,360.3449401855469],[489.9801025390625,360.67840576171875],[489.9272766113281,361.0118408203125],[489.8725280761719,361.344970703125],[489.81719970703125,361.6780090332031],[489.7603454589844,362.0107727050781],[489.7023010253906,362.3432922363281],[489.64324951171875,362.6756591796875],[489.57977294921875,363.0072021484375],[489.50506591796875,363.3363952636719],[489.419189453125,363.662841796875],[489.3223876953125,363.9862365722656],[489.21502685546875,364.3062744140625],[489.0974426269531,364.6226806640625],[488.9690246582031,364.93487548828125],[488.8301696777344,365.2425537109375],[488.6805725097656,365.5451965332031],[488.52020263671875,365.84222412109375],[488.34893798828125,366.1330871582031],[488.1662292480469,366.4169616699219],[487.97210693359375,366.6931457519531],[487.7660827636719,366.96051025390625],[487.5479431152344,367.2180480957031],[487.320556640625,367.46759033203125],[487.08599853515625,367.7103271484375],[486.8449401855469,367.9466857910156],[486.59808349609375,368.1769714355469],[486.3462219238281,368.4017028808594],[486.08990478515625,368.6213684082031],[485.82977294921875,368.8365478515625],[485.56610107421875,369.0473937988281],[485.29986572265625,369.2549743652344],[485.03131103515625,369.4594421386719],[484.76068115234375,369.6612854003906],[484.4884338378906,369.8608703613281],[484.2154846191406,370.0595397949219],[483.94158935546875,370.2568359375],[483.6673889160156,370.4538269042969],[483.3931884765625,370.6507263183594],[483.11932373046875,370.8481140136719],[482.84637451171875,371.0467834472656],[482.57415771484375,371.2463684082031],[482.30364990234375,371.4483337402344],[482.03497314453125,371.6528015136719],[481.7688903808594,371.8605041503906],[481.5054016113281,372.0715637207031],[481.2472229003906,372.28900146484375],[480.99664306640625,372.5152282714844],[480.7519226074219,372.74774169921875],[480.5115661621094,372.9847412109375],[480.2738952636719,373.22454833984375],[480.0372009277344,373.4652099609375],[479.7998962402344,373.7052917480469],[479.56048583984375,373.94329833984375],[479.3171691894531,374.17730712890625],[479.0685119628906,374.4056091308594],[478.8125305175781,374.6257629394531],[478.5477600097656,374.835205078125],[478.2728576660156,375.031005859375],[477.986572265625,375.20977783203125],[477.6883239746094,375.3677673339844],[477.3782043457031,375.5007629394531],[477.0609130859375,375.615966796875],[476.74017333984375,375.72119140625],[476.41644287109375,375.8169250488281],[476.0901794433594,375.903564453125],[475.76171875,375.9815979003906],[475.43145751953125,376.05145263671875],[475.09967041015625,376.1134948730469],[474.7665100097656,376.1682434082031],[474.4323425292969,376.2158508300781],[474.09722900390625,376.2566223144531],[473.761474609375,376.29150390625],[473.42510986328125,376.31982421875],[473.0882873535156,376.3428039550781],[472.7511291503906,376.3597106933594],[472.4137878417969,376.3717346191406],[472.07623291015625,376.3781433105469],[471.73870849609375,376.37994384765625],[471.4010925292969,376.3766174316406],[471.06365966796875,376.368896484375],[470.72625732421875,376.3564453125],[470.38909912109375,376.3398132324219],[470.0520324707031,376.3206481933594],[469.7150573730469,376.30120849609375],[469.37811279296875,376.28045654296875],[469.0411071777344,376.2593688964844],[468.7042541503906,376.2371520996094],[468.367431640625,376.21453857421875],[468.0306701660156,376.1907958984375],[467.6939697265625,376.1666259765625],[467.3573303222656,376.1414794921875],[467.02069091796875,376.1158142089844],[466.68414306640625,376.0892333984375],[466.3476867675781,376.0621337890625],[466.0112609863281,376.0341796875],[465.67486572265625,376.00567626953125],[465.3385314941406,375.9764099121094],[465.0022888183594,375.9465026855469],[464.66607666015625,375.91595458984375],[464.3299865722656,375.8847351074219],[463.993896484375,375.8528747558594],[463.6578674316406,375.82037353515625],[463.3218994140625,375.78729248046875],[462.9859924316406,375.75347900390625],[462.6501770019531,375.7192077636719],[462.31439208984375,375.6842041015625],[461.9786682128906,375.6487731933594],[461.6430358886719,375.6125793457031],[461.30743408203125,375.5760192871094],[460.971923828125,375.5386657714844],[460.6364440917969,375.5009765625],[460.30108642578125,375.4625244140625],[459.9657287597656,375.42376708984375],[459.63043212890625,375.3842468261719],[459.29522705078125,375.344482421875],[458.9600524902344,375.30389404296875],[458.62493896484375,375.2630920410156],[458.2898864746094,375.2215270996094],[457.95489501953125,375.1798095703125],[457.6199951171875,375.13726806640625],[457.2851257324219,375.0946044921875],[456.9503479003906,375.0511169433594],[456.6156005859375,375.0075378417969],[456.28094482421875,374.9631652832031],[455.9463195800781,374.9187316894531],[455.6117858886719,374.87310791015625],[455.2773132324219,374.82745361328125],[454.94281005859375,374.78179931640625],[454.6083984375,374.736083984375],[454.2741394042969,374.6888732910156],[453.9398498535156,374.64166259765625],[453.6055908203125,374.5944519042969],[453.2713623046875,374.5470886230469],[452.9372863769531,374.49847412109375],[452.6032409667969,374.4498291015625],[452.2691650390625,374.4012145996094],[451.9350891113281,374.35235595703125],[451.6011962890625,374.30242919921875],[451.267333984375,374.25250244140625],[450.9334411621094,374.20257568359375],[450.59967041015625,374.1523742675781],[450.2659606933594,374.101318359375],[449.9322509765625,374.05023193359375],[449.59857177734375,373.9991455078125],[449.2649230957031,373.94781494140625],[448.9312744140625,373.8958740234375],[448.59771728515625,373.84393310546875],[448.2641296386719,373.7920227050781],[447.9305725097656,373.7400817871094],[447.5970458984375,373.68792724609375],[447.2635803222656,373.6354064941406],[446.93011474609375,373.5829162597656],[446.59661865234375,373.5303955078125],[446.2631530761719,373.4778747558594],[445.9297180175781,373.42510986328125],[445.5963134765625,373.37200927734375],[445.262939453125,373.3189392089844],[444.9295654296875,373.265869140625],[444.5961608886719,373.2127685546875],[444.2628173828125,373.1593933105469],[443.92950439453125,373.10577392578125],[443.5962219238281,373.0521545410156],[443.2629089355469,372.99853515625],[442.92962646484375,372.94488525390625],[442.5964050292969,372.89080810546875],[442.26324462890625,372.83642578125],[441.9300537109375,372.7820739746094],[441.5968933105469,372.7276916503906],[441.2637023925781,372.6733093261719],[440.9305419921875,372.6189270019531],[440.59735107421875,372.5645446777344],[440.2641906738281,372.5101623535156],[439.9309997558594,372.4557800292969],[439.59783935546875,372.4013977050781],[439.26470947265625,372.3463134765625],[438.931640625,372.291015625],[438.5986022949219,372.2356872558594],[438.2655944824219,372.1803894042969],[437.93255615234375,372.1250915527344],[437.59954833984375,372.0697937011719],[437.2665100097656,372.0144958496094],[436.9335021972656,371.9591979980469],[436.6004638671875,371.90386962890625],[436.2674255371094,371.84857177734375],[435.9345703125,371.7925720214844],[435.6016845703125,371.7364501953125],[435.268798828125,371.6803283691406],[434.9359130859375,371.62420654296875],[434.60302734375,371.5680847167969],[434.2701416015625,371.511962890625],[433.937255859375,371.4558410644531],[433.6043701171875,371.3996887207031],[433.271484375,371.34356689453125],[432.9385986328125,371.2874450683594],[432.6058349609375,371.2305908203125],[432.2730407714844,371.17376708984375],[431.9402770996094,371.1169128417969],[431.6075134277344,371.0600891113281],[431.2747497558594,371.0032653808594],[430.9419860839844,370.9464111328125],[430.6092224121094,370.88958740234375],[430.2764587402344,370.8327331542969],[429.9436950683594,370.7759094238281],[429.6109313964844,370.7189636230469],[429.2782897949219,370.6614990234375],[428.945556640625,370.60406494140625],[428.6128845214844,370.5466003417969],[428.2802429199219,370.4891357421875],[427.94757080078125,370.43170166015625],[427.6148986816406,370.3742370605469],[427.2822570800781,370.3168029785156],[426.9495849609375,370.25933837890625],[426.6169128417969,370.201904296875],[426.2842712402344,370.144287109375],[425.95172119140625,370.0863342285156],[425.619140625,370.02838134765625],[425.28656005859375,369.9704284667969],[424.9539794921875,369.9124755859375],[424.62139892578125,369.8545227050781],[424.2888488769531,369.79656982421875],[423.9562683105469,369.7386169433594],[423.6236877441406,369.6806640625],[423.2911071777344,369.6227111816406],[422.9585876464844,369.56451416015625],[422.6260986328125,369.5060119628906],[422.2936096191406,369.447509765625],[421.9611511230469,369.3890075683594],[421.628662109375,369.33050537109375],[421.2961730957031,369.2720031738281],[420.9637145996094,369.2134704589844],[420.6312255859375,369.15496826171875],[420.29876708984375,369.0964660644531],[419.9662780761719,369.0379638671875],[419.6337890625,368.9794616699219],[419.30133056640625,368.92095947265625],[418.9687805175781,368.8624267578125],[418.6363220214844,368.8039245605469],[418.3038330078125,368.74542236328125],[417.9713439941406,368.6869201660156],[417.6388854980469,368.62841796875],[417.306396484375,368.5699157714844],[416.97393798828125,368.51141357421875],[416.6414489746094,368.4529113769531],[416.30902099609375,368.39410400390625],[415.97662353515625,368.335205078125],[415.64422607421875,368.27630615234375],[415.3117980957031,368.2174072265625],[414.9794006347656,368.15850830078125],[414.6470031738281,368.099609375],[414.3145751953125,368.04071044921875],[413.982177734375,367.9818115234375],[413.6497802734375,367.9228820800781],[413.3173522949219,367.8639831542969],[412.9849548339844,367.8050842285156],[412.6525573730469,367.7461853027344],[412.32012939453125,367.6872863769531],[411.98773193359375,367.6283874511719],[411.65533447265625,367.5694885253906],[411.32293701171875,367.5105895996094],[410.9905090332031,367.4516906738281],[410.6581115722656,367.3927917480469],[410.3257141113281,367.3338623046875],[409.9932861328125,367.27496337890625],[409.660888671875,367.2160949707031],[409.3284606933594,367.1572265625],[408.9960021972656,367.09832763671875],[408.66357421875,367.0394592285156],[408.3311767578125,366.9805603027344],[407.998779296875,366.92169189453125],[407.6663513183594,366.8628234863281],[407.3339538574219,366.8039245605469],[407.00152587890625,366.74505615234375],[406.66912841796875,366.6861572265625],[406.3367004394531,366.6272888183594],[406.0043029785156,366.56842041015625],[405.671875,366.509521484375],[405.3394775390625,366.4506530761719],[405.007080078125,366.39178466796875],[404.6746520996094,366.3328857421875],[404.3422546386719,366.2740173339844],[404.00982666015625,366.21514892578125],[403.67742919921875,366.15625],[403.344970703125,366.0975036621094],[403.0124816894531,366.0390625],[402.67999267578125,365.9805908203125],[402.3475036621094,365.9221496582031],[402.0150146484375,365.86370849609375],[401.68255615234375,365.8052673339844],[401.3500671386719,365.746826171875],[401.017578125,365.6883850097656],[400.6850891113281,365.6299133300781],[400.35260009765625,365.57147216796875],[400.0201110839844,365.5130310058594],[399.6876220703125,365.45458984375],[399.3551330566406,365.3961486816406],[399.02264404296875,365.33770751953125],[398.6900939941406,365.27923583984375],[398.35760498046875,365.2207946777344],[398.0251159667969,365.162353515625],[397.692626953125,365.1039123535156],[397.3601379394531,365.0454406738281],[397.02764892578125,364.98699951171875],[396.6951599121094,364.9287109375],[396.36260986328125,364.87054443359375],[396.03009033203125,364.8123474121094],[395.6975402832031,364.7541809082031],[395.3650207519531,364.6960144042969],[395.032470703125,364.6378173828125],[394.699951171875,364.57965087890625],[394.3674011230469,364.521484375],[394.0348815917969,364.4632873535156],[393.70233154296875,364.4051208496094],[393.36981201171875,364.3469543457031],[393.0372619628906,364.28875732421875],[392.7047424316406,364.2305908203125],[392.3721923828125,364.17242431640625],[392.0396728515625,364.1142272949219],[391.7071228027344,364.0560607910156],[391.3746032714844,363.99786376953125],[391.04205322265625,363.939697265625],[390.70953369140625,363.88153076171875],[390.3769836425781,363.8233337402344],[390.0444641113281,363.7651672363281],[389.7119140625,363.7070007324219],[389.37939453125,363.6488037109375],[389.0468444824219,363.59063720703125],[388.7142639160156,363.5324401855469],[388.3817138671875,363.4742736816406],[388.0491943359375,363.4161071777344],[387.7166442871094,363.35791015625],[387.3841247558594,363.29974365234375],[387.05157470703125,363.2415771484375],[386.71905517578125,363.1833801269531],[386.3865051269531,363.1252136230469],[386.0539855957031,363.0670471191406],[385.721435546875,363.00885009765625],[385.388916015625,362.95068359375],[385.0563659667969,362.89251708984375],[384.7238464355469,362.8343200683594],[384.39129638671875,362.7761535644531],[384.05877685546875,362.71795654296875],[383.7262268066406,362.6597900390625],[383.3937072753906,362.60162353515625],[383.0611572265625,362.5434265136719],[382.7286376953125,362.4852600097656],[382.3960876464844,362.4270935058594],[382.0635681152344,362.368896484375],[381.7310485839844,362.3106994628906],[381.3985290527344,362.25238037109375],[381.0660400390625,362.19403076171875],[380.7335205078125,362.1357116699219],[380.4010009765625,362.0773620605469],[380.0685119628906,362.01904296875],[379.7359924316406,361.960693359375],[379.40350341796875,361.9023742675781],[379.07098388671875,361.8440246582031],[378.7384033203125,361.7856750488281],[378.4059143066406,361.72735595703125],[378.0733947753906,361.66900634765625],[377.74090576171875,361.6106872558594],[377.40838623046875,361.5523376464844],[377.07586669921875,361.4940185546875],[376.7433776855469,361.4356689453125],[376.4108581542969,361.3773498535156],[376.078369140625,361.3190002441406],[375.745849609375,361.26068115234375],[375.413330078125,361.20233154296875],[375.0808410644531,361.1440124511719],[374.7483215332031,361.0856628417969],[374.41583251953125,361.02734375],[374.08331298828125,360.968994140625],[373.75079345703125,360.9106750488281],[373.4183044433594,360.8523254394531],[373.0857849121094,360.79400634765625],[372.7532958984375,360.7356872558594],[372.4207763671875,360.6773376464844],[372.0882568359375,360.6190185546875],[371.7557678222656,360.5606689453125],[371.4232482910156,360.5023498535156],[371.09075927734375,360.4440002441406],[370.75823974609375,360.38568115234375],[370.42572021484375,360.32733154296875],[370.0932312011719,360.2690124511719],[369.7607116699219,360.2106628417969],[369.42822265625,360.15234375],[369.095703125,360.093994140625],[368.76312255859375,360.03564453125],[368.4306335449219,359.9773254394531],[368.0981140136719,359.9189758300781],[367.765625,359.86065673828125],[367.43310546875,359.80230712890625],[367.1005859375,359.7439880371094],[366.7680969238281,359.6856384277344],[366.4356384277344,359.6271667480469],[366.1031494140625,359.56866455078125],[365.77069091796875,359.5101318359375],[365.4382019042969,359.4516296386719],[365.105712890625,359.3930969238281],[364.77325439453125,359.3345947265625],[364.4407653808594,359.2760925292969],[364.1083068847656,359.2175598144531],[363.77581787109375,359.1590576171875],[363.443359375,359.10052490234375],[363.1108703613281,359.0420227050781],[362.7784118652344,358.9835205078125],[362.4459228515625,358.92498779296875],[362.11346435546875,358.8664855957031],[361.7809753417969,358.8079528808594],[361.448486328125,358.74945068359375],[361.11602783203125,358.6909484863281],[360.7835388183594,358.6324157714844],[360.4510803222656,358.57391357421875],[360.11859130859375,358.515380859375],[359.7861328125,358.4568786621094],[359.4536437988281,358.39837646484375],[359.12115478515625,358.33984375],[358.78863525390625,358.2813415527344],[358.4561462402344,358.2228088378906],[358.1236877441406,358.164306640625],[357.79119873046875,358.10577392578125],[357.458740234375,358.0472717285156],[357.1262512207031,357.98876953125],[356.7937927246094,357.93023681640625],[356.4613037109375,357.8717346191406],[356.1288146972656,357.8132019042969],[355.7963562011719,357.75469970703125],[355.4638671875,357.6961975097656],[355.13140869140625,357.6376647949219],[354.7989196777344,357.57916259765625],[354.4664611816406,357.5206298828125],[354.13397216796875,357.4621276855469],[353.801513671875,357.40362548828125],[353.4690246582031,357.3450927734375],[353.13653564453125,357.2865905761719],[352.8040771484375,357.2280578613281],[352.4715881347656,357.1695556640625],[352.1391296386719,357.1110534667969],[351.806640625,357.0525207519531],[351.47418212890625,356.9940185546875],[351.1416931152344,356.93548583984375],[350.8092041015625,356.8769836425781],[350.47674560546875,356.8184814453125],[350.1442565917969,356.75994873046875],[349.8117980957031,356.7014465332031],[349.47930908203125,356.6429443359375],[349.1468505859375,356.58441162109375],[348.8143005371094,356.52587890625],[348.4818420410156,356.4673767089844],[348.14935302734375,356.40887451171875],[347.8168640136719,356.350341796875],[347.4844055175781,356.2918395996094],[347.15191650390625,356.2333068847656],[346.8194580078125,356.1748046875],[346.4869689941406,356.1163024902344],[346.1545104980469,356.0577697753906],[345.822021484375,355.999267578125],[345.48956298828125,355.94073486328125],[345.1570739746094,355.8822326660156],[344.8245849609375,355.82373046875],[344.49212646484375,355.76519775390625],[344.1596374511719,355.7066955566406],[343.8271789550781,355.6481628417969],[343.49468994140625,355.58966064453125],[343.1622314453125,355.5311584472656],[342.8297424316406,355.4726257324219],[342.49725341796875,355.41412353515625],[342.164794921875,355.3556213378906],[341.8323059082031,355.2970886230469],[341.4998474121094,355.23858642578125],[341.1673583984375,355.1800537109375],[340.83489990234375,355.1215515136719],[340.5024108886719,355.06304931640625],[340.1699523925781,355.0045166015625],[339.83746337890625,354.9460144042969],[339.5049743652344,354.8874816894531],[339.1725158691406,354.8289794921875],[338.8399658203125,354.77044677734375],[338.50750732421875,354.7119445800781],[338.1750183105469,354.6534118652344],[337.8425598144531,354.59490966796875],[337.51007080078125,354.5364074707031],[337.1776123046875,354.4778747558594],[336.8451232910156,354.41937255859375],[336.51263427734375,354.36083984375],[336.18017578125,354.3021545410156],[335.8477478027344,354.2434997558594],[335.5152893066406,354.1848449707031],[335.1828308105469,354.12615966796875],[334.85040283203125,354.0675048828125],[334.5179443359375,354.00885009765625],[334.18548583984375,353.9501953125],[333.85302734375,353.8915100097656],[333.5205993652344,353.8328552246094],[333.1881408691406,353.7742004394531],[332.8556823730469,353.7155456542969],[332.52325439453125,353.6568603515625],[332.1907958984375,353.59820556640625],[331.85833740234375,353.53955078125],[331.5259094238281,353.4808654785156],[331.1934509277344,353.4222106933594],[330.8609924316406,353.3635559082031],[330.528564453125,353.3049011230469],[330.19610595703125,353.2462158203125],[329.8636474609375,353.18756103515625],[329.53118896484375,353.12890625],[329.1987609863281,353.07025146484375],[328.8662414550781,353.0115661621094],[328.5337829589844,352.9529113769531],[328.20135498046875,352.89422607421875],[327.868896484375,352.8355712890625],[327.53643798828125,352.77691650390625],[327.2040100097656,352.71826171875],[326.8715515136719,352.6595764160156],[326.5390930175781,352.6009216308594],[326.2066345214844,352.5422668457031],[325.87420654296875,352.48358154296875],[325.541748046875,352.4249267578125],[325.20928955078125,352.36627197265625],[324.8768615722656,352.3076171875],[324.5444030761719,352.2489318847656],[324.2119445800781,352.1902770996094],[323.8795166015625,352.1316223144531],[323.54705810546875,352.07293701171875],[323.214599609375,352.0142822265625],[322.88214111328125,351.95562744140625],[322.5497131347656,351.89697265625],[322.2172546386719,351.8382873535156],[321.8847961425781,351.7796325683594],[321.5523681640625,351.7209777832031],[321.21990966796875,351.6623229980469],[320.887451171875,351.6036376953125],[320.5550231933594,351.54498291015625],[320.2225646972656,351.486328125],[319.8901062011719,351.4276428222656],[319.5576477050781,351.3689880371094],[319.2252197265625,351.3103332519531],[318.89276123046875,351.2516784667969],[318.56024169921875,351.1929931640625],[318.2278137207031,351.13433837890625],[317.8953552246094,351.0756530761719],[317.5628967285156,351.0169982910156],[317.23046875,350.9583435058594],[316.89801025390625,350.8996887207031],[316.5655517578125,350.84100341796875],[316.23309326171875,350.7823486328125],[315.9006652832031,350.72369384765625],[315.5682067871094,350.6650085449219],[315.2357482910156,350.6063537597656],[314.9033203125,350.5476989746094],[314.57086181640625,350.4890441894531],[314.2384033203125,350.43035888671875],[313.9059753417969,350.3717041015625],[313.5735168457031,350.31304931640625],[313.2410583496094,350.25439453125],[312.9085998535156,350.1957092285156],[312.576171875,350.1370544433594],[312.24371337890625,350.0783996582031],[311.9112548828125,350.01971435546875],[311.5788269042969,349.9610595703125],[311.2463684082031,349.90240478515625],[310.9139099121094,349.84375],[310.58148193359375,349.7850646972656],[310.2490234375,349.7264099121094],[309.91656494140625,349.6677551269531],[309.5841064453125,349.6091003417969],[309.2516784667969,349.5504150390625],[308.9192199707031,349.49176025390625],[308.5867004394531,349.4330749511719],[308.2542724609375,349.3744201660156],[307.92181396484375,349.3157653808594],[307.58935546875,349.257080078125],[307.2569274902344,349.19842529296875],[306.9244689941406,349.1397705078125],[306.5920104980469,349.08111572265625],[306.2595520019531,349.02239990234375],[305.9270935058594,348.9637145996094],[305.59466552734375,348.9049987792969],[305.26220703125,348.8463134765625],[304.9297790527344,348.78759765625],[304.5973205566406,348.7289123535156],[304.264892578125,348.6701965332031],[303.93243408203125,348.61151123046875],[303.6000061035156,348.55279541015625],[303.2675476074219,348.49407958984375],[302.93511962890625,348.4353942871094],[302.6026611328125,348.3766784667969],[302.2702331542969,348.3179931640625],[301.93780517578125,348.25927734375],[301.6053466796875,348.2005920410156],[301.2729187011719,348.1418762207031],[300.9404602050781,348.08319091796875],[300.6080322265625,348.02447509765625],[300.27557373046875,347.96575927734375],[299.9431457519531,347.9070739746094],[299.6106872558594,347.8483581542969],[299.27825927734375,347.7896728515625],[298.94580078125,347.73095703125],[298.6133117675781,347.6722412109375],[298.2808532714844,347.6135559082031],[297.94842529296875,347.5548400878906],[297.615966796875,347.49615478515625],[297.2835388183594,347.43743896484375],[296.9510803222656,347.3787536621094],[296.61865234375,347.3200378417969],[296.28619384765625,347.2613220214844],[295.9537658691406,347.20263671875],[295.621337890625,347.1439208984375],[295.28887939453125,347.0852355957031],[294.9564514160156,347.0265197753906],[294.6239929199219,346.96783447265625],[294.29156494140625,346.90911865234375],[293.9591064453125,346.8504333496094],[293.6266784667969,346.7917175292969],[293.2942199707031,346.7330017089844],[292.9617919921875,346.67431640625],[292.62933349609375,346.6156005859375],[292.2969055175781,346.5569152832031],[291.9644470214844,346.4981994628906],[291.63201904296875,346.43951416015625],[291.299560546875,346.38079833984375],[290.9671325683594,346.3221130371094],[290.6346740722656,346.2633972167969],[290.30224609375,346.2046813964844],[289.96978759765625,346.14599609375],[289.6373596191406,346.0872802734375],[289.304931640625,346.0285949707031],[288.97247314453125,345.9698791503906],[288.6399841308594,345.9111633300781],[288.3075256347656,345.85247802734375],[287.97509765625,345.79376220703125],[287.64263916015625,345.7350769042969],[287.3102111816406,345.6763610839844],[286.9777526855469,345.61767578125],[286.64532470703125,345.5589599609375],[286.3128662109375,345.500244140625],[285.9804382324219,345.4415588378906],[285.6479797363281,345.3828430175781],[285.3155517578125,345.32415771484375],[284.98309326171875,345.26544189453125],[284.6506652832031,345.2067565917969],[284.3182067871094,345.1480407714844],[283.98577880859375,345.0893249511719],[283.6533508300781,345.0306396484375],[283.3208923339844,344.971923828125],[282.98846435546875,344.9132385253906],[282.656005859375,344.8545227050781],[282.3235778808594,344.79583740234375],[281.9911193847656,344.73712158203125],[281.65869140625,344.6784362792969],[281.32623291015625,344.6197204589844],[280.9938049316406,344.5610046386719],[280.6613464355469,344.5023193359375],[280.32891845703125,344.443603515625],[279.9964599609375,344.3849182128906],[279.6640319824219,344.3262023925781],[279.3315734863281,344.26751708984375],[278.9991455078125,344.20880126953125],[278.6666259765625,344.15008544921875],[278.3341979980469,344.0914001464844],[278.00177001953125,344.0326843261719],[277.6693115234375,343.9739990234375],[277.3368835449219,343.915283203125],[277.0044250488281,343.8565673828125],[276.6719970703125,343.7978820800781],[276.33953857421875,343.7391662597656],[276.0070495605469,343.6806945800781],[275.674560546875,343.62225341796875],[275.3420715332031,343.5638122558594],[275.00958251953125,343.5054016113281],[274.6770935058594,343.44696044921875],[274.3446044921875,343.3885192871094],[274.0121154785156,343.330078125],[273.67962646484375,343.27166748046875],[273.3471374511719,343.2132263183594],[273.0146484375,343.15478515625],[272.6820983886719,343.0965881347656],[272.34954833984375,343.03857421875],[272.0169677734375,342.9805603027344],[271.6844177246094,342.9225769042969],[271.3518371582031,342.86456298828125],[271.019287109375,342.8065490722656],[270.68670654296875,342.74853515625],[270.3541564941406,342.6905212402344],[270.0216064453125,342.6325378417969],[269.68902587890625,342.57452392578125],[269.3564453125,342.5166320800781],[269.0238037109375,342.45904541015625],[268.69110107421875,342.4014587402344],[268.35845947265625,342.3438720703125],[268.02581787109375,342.28631591796875],[267.69317626953125,342.2287292480469],[267.36053466796875,342.171142578125],[267.02789306640625,342.1135559082031],[266.69525146484375,342.0559997558594],[266.3626403808594,341.9984130859375],[266.0299987792969,341.9408264160156],[265.6973571777344,341.8832702636719],[265.3647155761719,341.82568359375],[265.0320739746094,341.7680969238281],[264.6994323730469,341.71051025390625],[264.3667907714844,341.6529541015625],[264.0341491699219,341.5953674316406],[263.7015075683594,341.53778076171875],[263.3688659667969,341.4801940917969],[263.0362243652344,341.4226379394531],[262.70361328125,341.36505126953125],[262.3709411621094,341.3076171875],[262.03826904296875,341.250244140625],[261.7055969238281,341.19287109375],[261.3729248046875,341.135498046875],[261.0402526855469,341.078125],[260.70758056640625,341.020751953125],[260.3749084472656,340.96337890625],[260.0422058105469,340.906005859375],[259.70953369140625,340.8486328125],[259.3768615722656,340.791259765625],[259.044189453125,340.73388671875],[258.7114562988281,340.676513671875],[258.3787841796875,340.619140625],[258.0461120605469,340.561767578125],[257.71343994140625,340.50439453125],[257.3807678222656,340.447021484375],[257.048095703125,340.3896179199219],[256.7154235839844,340.3322448730469],[256.38275146484375,340.2748718261719],[256.0500793457031,340.2174987792969],[255.71742248535156,340.16009521484375],[255.38478088378906,340.10247802734375],[255.05215454101562,340.0448913574219],[254.71951293945312,339.9872741699219],[254.3868865966797,339.9296875],[254.0542449951172,339.8720703125],[253.7216033935547,339.8144836425781],[253.38897705078125,339.7568664550781],[253.05633544921875,339.69927978515625],[252.7237091064453,339.64166259765625],[252.3910675048828,339.5840759277344],[252.05844116210938,339.5264587402344],[251.72579956054688,339.4688720703125],[251.39315795898438,339.4112548828125],[251.06053161621094,339.3536682128906],[250.72789001464844,339.29608154296875],[250.395263671875,339.23846435546875],[250.0626220703125,339.1808776855469],[249.72999572753906,339.1232604980469],[249.39735412597656,339.065673828125],[249.06471252441406,339.008056640625],[248.73207092285156,338.95013427734375],[248.39952087402344,338.89208984375],[248.06695556640625,338.83404541015625],[247.73440551757812,338.7760009765625],[247.40184020996094,338.71795654296875],[247.0692901611328,338.659912109375],[246.73672485351562,338.60186767578125],[246.4041748046875,338.5438232421875],[246.0716094970703,338.48577880859375],[245.7390594482422,338.427734375],[245.40652465820312,338.3694763183594],[245.07403564453125,338.31097412109375],[244.74156188964844,338.25250244140625],[244.40907287597656,338.1940002441406],[244.07659912109375,338.1355285644531],[243.74411010742188,338.0770263671875],[243.41163635253906,338.0185546875],[243.0791473388672,337.9600524902344],[242.74667358398438,337.9015808105469],[242.41419982910156,337.8431091308594],[242.08172607421875,337.78448486328125],[241.7493438720703,337.7254638671875],[241.41696166992188,337.6664123535156],[241.08457946777344,337.6073913574219],[240.752197265625,337.54833984375],[240.41981506347656,337.48931884765625],[240.08741760253906,337.4302978515625],[239.75503540039062,337.3712463378906],[239.4226531982422,337.3122253417969],[239.09027099609375,337.253173828125],[238.75782775878906,337.19415283203125],[238.42559814453125,337.13446044921875],[238.0933380126953,337.07476806640625],[237.7610626220703,337.01507568359375],[237.42880249023438,336.95538330078125],[237.09654235839844,336.89569091796875],[236.76426696777344,336.83599853515625],[236.4320068359375,336.7762756347656],[236.09974670410156,336.7165832519531],[235.76747131347656,336.6568908691406],[235.43521118164062,336.5971984863281],[235.10305786132812,336.5369567871094],[234.7709197998047,336.47650146484375],[234.4387969970703,336.4160461425781],[234.10667419433594,336.3555603027344],[233.77455139160156,336.29510498046875],[233.44241333007812,336.2346496582031],[233.11029052734375,336.1741943359375],[232.77816772460938,336.1137390136719],[232.44602966308594,336.05328369140625],[232.11390686035156,335.9927978515625],[231.78184509277344,335.9320373535156],[231.4498291015625,335.8709411621094],[231.11782836914062,335.8098449707031],[230.7858123779297,335.74871826171875],[230.4538116455078,335.6876220703125],[230.12181091308594,335.6263427734375],[229.78988647460938,335.5647888183594],[229.4579620361328,335.5032043457031],[229.12603759765625,335.441650390625],[228.7941131591797,335.38006591796875],[228.46217346191406,335.3183898925781],[228.13034057617188,335.25634765625],[227.7985076904297,335.19427490234375],[227.4666748046875,335.1322326660156],[227.1348419189453,335.0701599121094],[226.802978515625,335.008056640625],[226.47129821777344,334.94549560546875],[226.13951110839844,334.8829040527344],[225.80783081054688,334.8203125],[225.47604370117188,334.7577209472656],[225.1443634033203,334.69512939453125],[224.81265258789062,334.63201904296875],[224.4810791015625,334.5688781738281],[224.14938354492188,334.5057373046875],[223.8178253173828,334.442626953125],[223.4861297607422,334.3794860839844],[223.15463256835938,334.31585693359375],[222.82318115234375,334.2521667480469],[222.49159240722656,334.1884460449219],[222.16014099121094,334.124755859375],[221.82855224609375,334.06103515625],[221.4962615966797,334.001953125],[221.1618194580078,333.9554138183594],[220.82679748535156,333.9149475097656],[220.49142456054688,333.87567138671875],[220.15643310546875,333.834228515625],[219.82199096679688,333.7876892089844],[219.48892211914062,333.7333679199219],[219.1573944091797,333.6695556640625],[218.82838439941406,333.59454345703125],[218.5023193359375,333.5068054199219],[218.18035888671875,333.405517578125],[217.8632354736328,333.28961181640625],[217.55223083496094,333.1587219238281],[217.24795532226562,333.0123291015625],[216.9518280029297,332.8506164550781],[216.6641845703125,332.6737365722656],[216.3862762451172,332.4823303222656],[216.1183624267578,332.2768249511719],[215.86111450195312,332.0585021972656],[215.61451721191406,331.8277893066406],[215.37925720214844,331.5857849121094],[215.15818786621094,331.3306884765625],[214.9523468017578,331.0632629394531],[214.7614288330078,330.7847900390625],[214.58509826660156,330.4969787597656],[214.42274475097656,330.2010803222656],[214.2736053466797,329.8981628417969],[214.1370849609375,329.58953857421875],[214.01242065429688,329.2757873535156],[213.89889526367188,328.9579772949219],[213.79576110839844,328.6364440917969],[213.70240783691406,328.3121337890625],[213.6182861328125,327.985107421875],[213.542724609375,327.6560974121094],[213.47515869140625,327.3253173828125],[213.4151611328125,326.99322509765625],[213.36241149902344,326.65966796875],[213.31605529785156,326.3254699707031],[213.27598571777344,325.9901428222656],[213.24200439453125,325.65435791015625],[213.21348571777344,325.3179016113281],[213.19015502929688,324.98114013671875],[213.1717529296875,324.64410400390625],[213.15811157226562,324.3067932128906],[213.14906311035156,323.9693603515625],[213.14418029785156,323.6318054199219],[213.14328002929688,323.29412841796875],[213.14617919921875,322.9566955566406],[213.15284729003906,322.6190490722656],[213.1630401611328,322.2817687988281],[213.1765594482422,321.9443054199219],[213.19325256347656,321.6072998046875],[213.21298217773438,321.27020263671875],[213.2356414794922,320.9334411621094],[213.2595977783203,320.5966491699219],[213.27865600585938,320.2594909667969],[213.29176330566406,319.92230224609375],[213.29937744140625,319.58477783203125],[213.30078125,319.24725341796875],[213.29664611816406,318.90966796875],[213.28636169433594,318.57220458984375],[213.26983642578125,318.23504638671875],[213.24752807617188,317.89825439453125],[213.2192840576172,317.561767578125],[213.18472290039062,317.22601318359375],[213.14407348632812,316.890869140625],[213.09732055664062,316.5565185546875],[213.04434204101562,316.22308349609375],[212.98533630371094,315.89080810546875],[212.92007446289062,315.5594787597656],[212.84872436523438,315.2295837402344],[212.77130126953125,314.90106201171875],[212.68763732910156,314.57403564453125],[212.5979766845703,314.2485046386719],[212.50228881835938,313.92486572265625],[212.4004669189453,313.6029357910156],[212.29281616210938,313.2830505371094],[212.17909240722656,312.9651184082031],[212.05955505371094,312.6494445800781],[211.9342041015625,312.3359069824219],[211.80307006835938,312.02496337890625],[211.66627502441406,311.71630859375],[211.52389526367188,311.4102478027344],[211.37582397460938,311.1068115234375],[211.2223663330078,310.8060302734375],[211.06361389160156,310.5082092285156],[210.89944458007812,310.2131652832031],[210.7301483154297,309.9211730957031],[210.5557098388672,309.63214111328125],[210.37632751464844,309.3461608886719],[210.19189453125,309.0633544921875],[210.0027618408203,308.78387451171875],[209.8087615966797,308.50750732421875],[209.61166381835938,308.23358154296875],[209.41201782226562,307.961181640625],[209.20970153808594,307.6910095214844],[209.00498962402344,307.4224853515625],[208.798095703125,307.1559143066406],[208.58851623535156,306.8911437988281],[208.37686157226562,306.6282653808594],[208.16294860839844,306.366943359375],[207.94676208496094,306.1078186035156],[207.72842407226562,305.8501892089844],[207.5082244873047,305.594482421875],[207.28562927246094,305.3406066894531],[207.06121826171875,305.0885009765625],[206.83482360839844,304.837890625],[206.6063995361328,304.5894775390625],[206.37608337402344,304.3426208496094],[206.14401245117188,304.097412109375],[205.9099578857422,303.8540954589844],[205.67425537109375,303.61260986328125],[205.43670654296875,303.3726501464844],[205.19740295410156,303.1345520019531],[204.956298828125,302.898193359375],[204.71365356445312,302.6634826660156],[204.46932983398438,302.4305725097656],[204.22317504882812,302.19940185546875],[203.97567749023438,301.97003173828125],[203.7264862060547,301.7421875],[203.4756317138672,301.5163269042969],[203.2231903076172,301.2919921875],[202.9694366455078,301.0694274902344],[202.71397399902344,300.8487548828125],[202.45706176757812,300.6297912597656],[202.19871520996094,300.41241455078125],[201.93894958496094,300.1969909667969],[201.67752075195312,299.9831848144531],[201.41493225097656,299.771240234375],[201.15066528320312,299.5609436035156],[200.8851776123047,299.3526916503906],[200.61819458007812,299.1459655761719],[200.34983825683594,298.941162109375],[200.08004760742188,298.73822021484375],[199.80899047851562,298.5370178222656],[199.53651428222656,298.3376770019531],[199.2626953125,298.140380859375],[198.98753356933594,297.9447326660156],[198.7109832763672,297.7510681152344],[198.43313598632812,297.55938720703125],[198.15399169921875,297.3695068359375],[197.8727264404297,297.18280029296875],[197.5881805419922,297.0011291503906],[197.30075073242188,296.82403564453125],[197.01036071777344,296.65167236328125],[196.71768188476562,296.48370361328125],[196.4223175048828,296.3200988769531],[196.1246795654297,296.1608581542969],[195.82493591308594,296.0054931640625],[195.52313232421875,295.85430908203125],[195.21946716308594,295.70684814453125],[194.91415405273438,295.5629577636719],[194.60691833496094,295.4227294921875],[194.29840087890625,295.2858581542969],[193.98837280273438,295.152099609375],[193.67718505859375,295.0216979980469],[193.36456298828125,294.89398193359375],[193.05096435546875,294.7691955566406],[192.73619079589844,294.6471252441406],[192.42054748535156,294.5274353027344],[192.1039276123047,294.41021728515625],[191.7865753173828,294.2952880859375],[191.46836853027344,294.18231201171875],[191.14955139160156,294.0715026855469],[190.8298797607422,293.962646484375],[190.50991821289062,293.85528564453125],[190.18939208984375,293.7493591308594],[189.8684539794922,293.64483642578125],[189.546875,293.5419006347656],[189.2250518798828,293.4400634765625],[188.9028778076172,293.33917236328125],[188.58053588867188,293.2391357421875],[188.25775146484375,293.1398010253906],[187.93484497070312,293.04156494140625],[187.61181640625,292.9432678222656],[187.28872680664062,292.84539794921875],[186.96560668945312,292.7478332519531],[186.6423797607422,292.6502380371094],[186.3192596435547,292.55267333984375],[185.9960174560547,292.455078125],[185.6725616455078,292.3587951660156],[185.34739685058594,292.2677307128906],[185.02084350585938,292.18231201171875],[184.69290161132812,292.1021423339844],[184.36390686035156,292.0269470214844],[184.0336456298828,291.9564208984375],[183.70269775390625,291.8902282714844],[183.3707733154297,291.828125],[183.03839111328125,291.76971435546875],[182.70526123046875,291.7149353027344],[182.37161254882812,291.6632385253906],[182.03762817382812,291.6142578125],[181.70333862304688,291.5677490234375],[181.3685302734375,291.5236511230469],[181.03363037109375,291.4814453125],[180.698486328125,291.4407958984375],[180.3631591796875,291.4017333984375],[180.02781677246094,291.3632507324219],[179.6923828125,291.3258056640625],[179.3567657470703,291.2885437011719],[179.0212860107422,291.25146484375],[178.68568420410156,291.2143859863281],[178.35018920898438,291.1768798828125],[178.01470947265625,291.1386413574219],[177.67955017089844,291.0994567871094],[177.3443145751953,291.05889892578125],[177.0091094970703,291.0183410644531],[176.67393493652344,290.97882080078125],[176.33847045898438,290.9404296875],[176.00311279296875,290.9022216796875],[175.66748046875,290.8655090332031],[175.33193969726562,290.8288879394531],[174.9961395263672,290.7936706542969],[174.66046142578125,290.7585144042969],[174.3245086669922,290.72467041015625],[173.9886932373047,290.69085693359375],[173.6526336669922,290.6581726074219],[173.3166961669922,290.6255187988281],[172.9804229736328,290.5938415527344],[172.64437866210938,290.5622253417969],[172.3081817626953,290.5314025878906],[171.97206115722656,290.50067138671875],[171.63571166992188,290.4707946777344],[171.2994842529297,290.4410705566406],[170.96315002441406,290.411376953125],[170.62693786621094,290.38165283203125],[170.2906036376953,290.3525390625],[169.95433044433594,290.3236389160156],[169.617919921875,290.2947082519531],[169.28163146972656,290.26580810546875],[168.94515991210938,290.23699951171875],[168.60885620117188,290.208251953125],[168.27243041992188,290.17950439453125],[167.93614196777344,290.1507873535156],[167.599853515625,290.1217956542969],[167.2634735107422,290.09259033203125],[166.92721557617188,290.0633850097656],[166.5908203125,290.0341796875],[166.2545166015625,290.0046081542969],[165.918212890625,289.9746398925781],[165.5820770263672,289.94439697265625],[165.24583435058594,289.91375732421875],[164.90975952148438,289.88275146484375],[164.57357788085938,289.8511962890625],[164.2375946044922,289.8193054199219],[163.90151977539062,289.7867431640625],[163.56553649902344,289.7538146972656],[163.2295684814453,289.7200622558594],[162.89373779296875,289.6859436035156],[162.55792236328125,289.6508483886719],[162.22238159179688,289.61541748046875],[161.88671875,289.5788269042969],[161.5512237548828,289.5419006347656],[161.21575927734375,289.503662109375],[160.88043212890625,289.4651794433594],[160.5450439453125,289.4254455566406],[160.21005249023438,289.3847961425781],[159.87496948242188,289.3431396484375],[159.5401611328125,289.3005065917969],[159.20526123046875,289.25677490234375],[158.87078857421875,289.2120056152344],[158.53622436523438,289.16607666015625],[158.20208740234375,289.1190185546875],[157.86790466308594,289.0707092285156],[157.53402709960938,289.02117919921875],[157.20022583007812,288.9703369140625],[156.86663818359375,288.9181823730469],[156.53335571289062,288.8647155761719],[156.2001953125,288.8097839355469],[155.86734008789062,288.7535095214844],[155.5347442626953,288.69573974609375],[155.2024688720703,288.63671875],[154.87005615234375,288.5774841308594],[154.5377655029297,288.5182800292969],[154.20535278320312,288.4590759277344],[153.87310791015625,288.399658203125],[153.54086303710938,288.3394775390625],[153.208740234375,288.2793273925781],[152.8765106201172,288.2191162109375],[152.5443878173828,288.1589660644531],[152.21217346191406,288.0982360839844],[151.88023376464844,288.0371398925781],[151.5481719970703,287.97601318359375],[151.21621704101562,287.9149169921875],[150.8841552734375,287.8537902832031],[150.5523681640625,287.7919006347656],[150.22047424316406,287.7298889160156],[149.88868713378906,287.66790771484375],[149.55677795410156,287.60589599609375],[149.22500610351562,287.5436706542969],[148.8932647705078,287.4808349609375],[148.56163024902344,287.41796875],[148.22988891601562,287.3551330566406],[147.8982696533203,287.29229736328125],[147.56668090820312,287.22894287109375],[147.23509216308594,287.1652526855469],[146.90362548828125,287.1015930175781],[146.57203674316406,287.0379333496094],[146.24057006835938,286.9742736816406],[145.90914916992188,286.90985107421875],[145.5778350830078,286.8454284667969],[145.24639892578125,286.78094482421875],[144.91506958007812,286.7165222167969],[144.58363342285156,286.6518249511719],[144.25247192382812,286.586669921875],[143.92117309570312,286.5214538574219],[143.5900115966797,286.4562683105469],[143.2587127685547,286.3910827636719],[142.9275665283203,286.325439453125],[142.59642028808594,286.259521484375],[142.26539611816406,286.1936340332031],[141.93423461914062,286.12774658203125],[141.60321044921875,286.0618591308594],[141.27224731445312,285.99530029296875],[140.94134521484375,285.92877197265625],[140.61032104492188,285.8622131347656],[140.2794189453125,285.795654296875],[139.94847106933594,285.7289123535156],[139.61769104003906,285.6617126464844],[139.28680419921875,285.5945129394531],[138.95603942871094,285.52734375],[138.62513732910156,285.46014404296875],[138.29437255859375,285.3925476074219],[137.96360778808594,285.32476806640625],[137.63294982910156,285.25701904296875],[137.3021697998047,285.189208984375],[136.97142028808594,285.1214294433594],[136.64088439941406,285.0531311035156],[136.3102264404297,284.9847717285156],[135.9796905517578,284.9164733886719],[135.64903259277344,284.8481140136719],[135.31857299804688,284.7796325683594],[134.988037109375,284.7107849121094],[134.65760803222656,284.6419372558594],[134.32705688476562,284.57305908203125],[133.9966278076172,284.5042419433594],[133.6661376953125,284.4350280761719],[133.33580017089844,284.36572265625],[133.00535583496094,284.29638671875],[132.67501831054688,284.22705078125],[132.34458923339844,284.15771484375],[132.01434326171875,284.08795166015625],[131.68399047851562,284.0181884765625],[131.353759765625,283.94842529296875],[131.0233917236328,283.878662109375],[130.6931915283203,283.8086853027344],[130.36294555664062,283.7383117675781],[130.0328369140625,283.66796875],[129.70260620117188,283.5976257324219],[129.37249755859375,283.52728271484375],[129.04226684570312,283.4569091796875],[128.71214294433594,283.3865661621094],[128.3819122314453,283.3161926269531],[128.0518035888672,283.245849609375],[127.72154998779297,283.1754455566406],[127.3914566040039,283.1044006347656],[127.06148529052734,283.0334167480469],[126.73139953613281,282.9623718261719],[126.40142059326172,282.891357421875],[126.07133483886719,282.8203430175781],[125.74136352539062,282.74932861328125],[125.41127014160156,282.6783142089844],[125.081298828125,282.6072998046875],[124.75121307373047,282.5362854003906],[124.4212875366211,282.4648742675781],[124.09130859375,282.3933410644531],[123.76144409179688,282.3218078613281],[123.43146514892578,282.2502746582031],[123.10160827636719,282.17877197265625],[122.7716293334961,282.1072082519531],[122.44176483154297,282.03570556640625],[122.11178588867188,281.9641418457031],[121.78192901611328,281.89263916015625],[121.45207977294922,281.8209533691406],[121.12229919433594,281.74908447265625],[120.79239654541016,281.67718505859375],[120.46261596679688,281.60528564453125],[120.1327133178711,281.53338623046875],[119.80293273925781,281.46148681640625],[119.47303009033203,281.38958740234375],[119.14324951171875,281.3177185058594],[118.81334686279297,281.24578857421875],[118.48350524902344,281.17388916015625],[118.1536636352539,281.1017150878906],[117.82393646240234,281.02960205078125],[117.49408721923828,280.9574279785156],[117.16424560546875,280.8852844238281],[116.83451843261719,280.8131408691406],[116.50466918945312,280.7409973144531],[116.17494201660156,280.6688537597656],[115.84510040283203,280.5967102050781],[115.51537322998047,280.5245666503906],[115.1855239868164,280.4524230957031],[114.85579681396484,280.3802795410156],[114.52595520019531,280.3081359863281],[114.19622802734375,280.2359924316406],[113.86637878417969,280.163818359375],[113.53665161132812,280.0917053222656],[113.2068099975586,280.01953125],[112.87708282470703,279.9474182128906],[112.54723358154297,279.875244140625],[112.21754455566406,279.8031921386719],[111.88766479492188,279.731201171875],[111.55789947509766,279.6592102050781],[111.22801971435547,279.58721923828125],[110.89826202392578,279.5152587890625],[110.5683822631836,279.4432373046875],[110.23861694335938,279.37127685546875],[109.90873718261719,279.29925537109375],[109.5789794921875,279.227294921875],[109.24909973144531,279.1552734375],[108.91934204101562,279.08331298828125],[108.58946228027344,279.01129150390625],[108.25969696044922,278.9393310546875],[107.92981719970703,278.8673095703125],[107.59993743896484,278.7953186035156],[107.27017974853516,278.7233581542969],[106.94029998779297,278.6513366699219],[106.61053466796875,278.5793762207031],[106.28065490722656,278.5073547363281],[105.95092010498047,278.43505859375],[105.62114715576172,278.36260986328125],[105.29179382324219,278.2887878417969],[104.96243286132812,278.2145080566406],[104.6334457397461,278.1390686035156],[104.30448913574219,278.06304931640625],[103.97589111328125,277.9858093261719],[103.64752960205078,277.9075012207031],[103.31940460205078,277.8280944824219],[102.9915542602539,277.74755859375],[102.66402435302734,277.6657409667969],[102.3368148803711,277.5826416015625],[102.00994873046875,277.498291015625],[101.68344116210938,277.4126281738281],[101.35731506347656,277.32562255859375],[101.03148651123047,277.2370910644531],[100.70620727539062,277.1471252441406],[100.38114929199219,277.0555725097656],[100.05669403076172,276.9624938964844],[99.73261260986328,276.8676452636719],[99.40927124023438,276.7711486816406],[99.08625793457031,276.6728820800781],[98.76383972167969,276.5728759765625],[98.44189453125,276.4710388183594],[98.12071228027344,276.3673400878906],[97.8000717163086,276.2617492675781],[97.47998809814453,276.1541748046875],[97.1606674194336,276.0445861816406],[96.8420639038086,275.9328918457031],[96.52391052246094,275.8202209472656],[96.20563507080078,275.7074890136719],[95.8874740600586,275.59478759765625],[95.56920623779297,275.48193359375],[95.2511978149414,275.3688049316406],[94.93307495117188,275.2556457519531],[94.61507415771484,275.1425476074219],[94.29698181152344,275.0291748046875],[93.97913360595703,274.9156188964844],[93.66116333007812,274.8020324707031],[93.34331512451172,274.6884765625],[93.0255355834961,274.57464599609375],[92.70783233642578,274.460693359375],[92.39002227783203,274.3466796875],[92.07231903076172,274.2326965332031],[91.75460815429688,274.1181335449219],[91.43712615966797,274.0035705566406],[91.1195297241211,273.8889465332031],[90.80204772949219,273.77435302734375],[90.48445129394531,273.6597595214844],[90.1669692993164,273.545166015625],[89.84937286376953,273.4305419921875],[89.5320053100586,273.3158874511719],[89.2146224975586,273.20068359375],[88.89735412597656,273.08551025390625],[88.57997131347656,272.9703063964844],[88.26274871826172,272.85498046875],[87.94550323486328,272.7394104003906],[87.62825775146484,272.6238098144531],[87.31112670898438,272.5082702636719],[86.99398803710938,272.39239501953125],[86.67706298828125,272.27630615234375],[86.36001586914062,272.16015625],[86.04308319091797,272.0440673828125],[85.72603607177734,271.92791748046875],[85.40911102294922,271.81182861328125],[85.0920639038086,271.6957092285156],[84.77513122558594,271.5796203613281],[84.45832824707031,271.4628601074219],[84.14164733886719,271.3460998535156],[83.82485961914062,271.229248046875],[83.50818634033203,271.11248779296875],[83.19139099121094,270.9956359863281],[82.87471771240234,270.8788757324219],[82.55792236328125,270.76202392578125],[82.2412338256836,270.64508056640625],[81.92469024658203,270.527587890625],[81.6082534790039,270.41015625],[81.29170989990234,270.29266357421875],[80.97527313232422,270.17523193359375],[80.65872192382812,270.0577392578125],[80.34229278564453,269.9403076171875],[80.02574157714844,269.82281494140625],[79.70948028564453,269.7050476074219],[79.39315795898438,269.58697509765625],[79.07695007324219,269.46893310546875],[78.76062774658203,269.350830078125],[78.44430541992188,269.2327575683594],[78.12809753417969,269.11468505859375],[77.81177520751953,268.9966125488281],[77.49555969238281,268.8785705566406],[77.17939758300781,268.75994873046875],[76.86339569091797,268.6413269042969],[76.54728698730469,268.5226745605469],[76.23129272460938,268.404052734375],[75.9151840209961,268.285400390625],[75.59918975830078,268.1667785644531],[75.2830810546875,268.0481262207031],[74.96717071533203,267.92938232421875],[74.65126037597656,267.8101806640625],[74.33546447753906,267.6910400390625],[74.0195541381836,267.57183837890625],[73.70376586914062,267.45269775390625],[73.38785552978516,267.3335266113281],[73.07205963134766,267.21435546875],[72.75614929199219,267.0951843261719],[72.44039916992188,266.9757080078125],[72.12467956542969,266.85601806640625],[71.80906677246094,266.73638916015625],[71.49333953857422,266.6167297363281],[71.177734375,266.4970703125],[70.86200714111328,266.3774108886719],[70.54639434814453,266.2577819824219],[70.23066711425781,266.1380920410156],[69.91525268554688,266.01806640625],[69.59970092773438,265.8979187011719],[69.28425598144531,265.7778625488281],[68.96869659423828,265.65771484375],[68.65314483642578,265.53759765625],[68.33769989013672,265.41754150390625],[68.02214813232422,265.2973937988281],[67.70680236816406,265.17724609375],[67.39139556884766,265.05670166015625],[67.07611083984375,264.93621826171875],[66.76071166992188,264.8157043457031],[66.44541931152344,264.6952209472656],[66.13002014160156,264.5746765136719],[65.81472778320312,264.4541931152344],[65.49932861328125,264.33367919921875],[65.18413543701172,264.21295166015625],[64.8688735961914,264.0920715332031],[64.55372619628906,263.9712219238281],[64.23846435546875,263.8503112792969],[63.923316955566406,263.7294616699219],[63.608055114746094,263.60858154296875],[63.29290771484375,263.48773193359375],[62.97764587402344,263.3668212890625],[62.66254806518555,263.2456359863281],[62.347408294677734,263.1244201660156],[62.032386779785156,263.00323486328125],[61.717247009277344,262.88201904296875],[61.4022216796875,262.7608642578125],[61.08708572387695,262.6396484375],[60.77206039428711,262.5184631347656],[60.45697784423828,262.39715576171875],[60.142059326171875,262.2757263183594],[59.827030181884766,262.1542053222656],[59.512001037597656,262.03271484375],[59.197086334228516,261.9112548828125],[58.882057189941406,261.7897644042969],[58.567142486572266,261.6683044433594],[58.252113342285156,261.54681396484375],[57.937408447265625,261.4249572753906],[57.622623443603516,261.3028259277344],[57.30796432495117,261.18060302734375],[56.993587493896484,261.05743408203125],[56.679325103759766,260.9342956542969],[56.365238189697266,260.8105163574219],[56.051414489746094,260.6862487792969],[55.73748016357422,260.56195068359375],[55.4240608215332,260.4364929199219],[55.110599517822266,260.3110046386719],[54.79745101928711,260.1850280761719],[54.484493255615234,260.05828857421875],[54.171653747558594,259.93157958984375],[53.859130859375,259.8040466308594],[53.54681396484375,259.6759338378906],[53.23459243774414,259.5472717285156],[52.922698974609375,259.4181823730469],[52.61101531982422,259.288330078125],[52.29975128173828,259.15802001953125],[51.98850631713867,259.027099609375],[51.67760467529297,258.89569091796875],[51.366878509521484,258.7635803222656],[51.05656051635742,258.6308288574219],[50.746395111083984,258.4974670410156],[50.4365119934082,258.363525390625],[50.126895904541016,258.22900390625],[49.81758499145508,258.0935974121094],[49.508636474609375,257.9576110839844],[49.19987869262695,257.82098388671875],[48.891544342041016,257.68377685546875],[48.58339309692383,257.5457458496094],[48.27567672729492,257.4069519042969],[47.968170166015625,257.2674560546875],[47.661128997802734,257.1273498535156],[47.354312896728516,256.9865417480469],[47.0479736328125,256.8448486328125],[46.741851806640625,256.7023010253906],[46.43621063232422,256.55914306640625],[46.13072204589844,256.4151916503906],[45.825782775878906,256.2705078125],[45.52116394042969,256.1247863769531],[45.21674346923828,255.9789581298828],[44.91225814819336,255.83302307128906],[44.607791900634766,255.68734741210938],[44.30298614501953,255.54209899902344],[43.998287200927734,255.39691162109375],[43.693119049072266,255.2523651123047],[43.38805389404297,255.10794067382812],[43.082881927490234,254.96347045898438],[42.77781677246094,254.81903076171875],[42.472652435302734,254.6747589111328],[42.16725158691406,254.5310516357422],[41.86173629760742,254.3872833251953],[41.55633544921875,254.2435760498047],[41.25082015991211,254.09982299804688],[40.945308685302734,253.9560546875],[40.63990783691406,253.81234741210938],[40.33439254760742,253.66859436035156],[40.02899169921875,253.52488708496094],[39.72347640991211,253.38111877441406],[39.418121337890625,253.2372283935547],[39.11271286010742,253.09324645996094],[38.80741882324219,252.94931030273438],[38.502010345458984,252.80532836914062],[38.196712493896484,252.66136169433594],[37.89154815673828,252.51686096191406],[37.58649826049805,252.37242126464844],[37.281517028808594,252.2275848388672],[36.97669982910156,252.0826416015625],[36.671791076660156,251.93740844726562],[36.367271423339844,251.79185485839844],[36.06264114379883,251.64622497558594],[35.75849151611328,251.49998474121094],[35.45421600341797,251.35360717773438],[35.15031814575195,251.2068328857422],[34.84645080566406,251.0596160888672],[34.542789459228516,250.91226196289062],[34.23939514160156,250.7640838623047],[33.93611145019531,250.61595153808594],[33.63311004638672,250.46682739257812],[33.330360412597656,250.31761169433594],[33.02787780761719,250.1678009033203],[32.72572708129883,250.0173797607422],[32.423484802246094,249.86676025390625],[32.12181854248047,249.7153778076172],[31.820398330688477,249.56329345703125],[31.519243240356445,249.41061401367188],[31.218482971191406,249.2573699951172],[30.917919158935547,249.1034393310547],[30.617904663085938,248.94895935058594],[30.318016052246094,248.79371643066406],[30.0186824798584,248.63775634765625],[29.719615936279297,248.48097229003906],[29.421062469482422,248.32351684570312],[29.12282943725586,248.165283203125],[28.825149536132812,248.00633239746094],[28.52772331237793,247.84649658203125],[28.230775833129883,247.6858673095703],[27.93433380126953,247.52423095703125],[27.638471603393555,247.3617706298828],[27.343046188354492,247.1984100341797],[27.048179626464844,247.03416442871094],[26.753707885742188,246.86891174316406],[26.459932327270508,246.70285034179688],[26.16646385192871,246.53565979003906],[25.873855590820312,246.367431640625],[25.581737518310547,246.1981201171875],[25.290409088134766,246.0278778076172],[24.999475479125977,245.85646057128906],[24.709264755249023,245.6840057373047],[24.419694900512695,245.51046752929688],[24.130887985229492,245.3358612060547],[23.842727661132812,245.15988159179688],[23.555347442626953,244.98269653320312],[23.268688201904297,244.8043212890625],[22.982772827148438,244.62474060058594],[22.698278427124023,244.44305419921875],[22.421329498291016,244.25015258789062],[22.152868270874023,244.04547119140625],[21.892902374267578,243.83010864257812],[21.641355514526367,243.6050262451172],[21.3979549407959,243.37109375],[21.16281509399414,243.1290283203125],[20.935768127441406,242.87918090820312],[20.716970443725586,242.6221160888672],[20.506465911865234,242.358154296875],[20.304555892944336,242.08770751953125],[20.111392974853516,241.81080627441406],[19.92734146118164,241.5278778076172],[19.752716064453125,241.23887634277344],[19.588224411010742,240.9442901611328],[19.434242248535156,240.64373779296875],[19.292003631591797,240.33773803710938],[19.162307739257812,240.0260009765625],[19.046598434448242,239.70892333984375],[18.946491241455078,239.38658142089844],[18.866914749145508,239.0585479736328],[18.819644927978516,238.72439575195312],[18.80210304260254,238.38746643066406],[18.81018829345703,238.05001831054688],[18.84022331237793,237.71380615234375],[18.889081954956055,237.3798370361328],[18.953960418701172,237.04864501953125],[19.03290557861328,236.72027587890625],[19.123842239379883,236.3953399658203],[19.22536849975586,236.0732421875],[19.336084365844727,235.7543487548828],[19.455049514770508,235.4384765625],[19.581315994262695,235.12539672851562],[19.714025497436523,234.8150634765625],[19.852725982666016,234.50714111328125],[19.996362686157227,234.20181274414062],[20.144832611083984,233.8986053466797],[20.300601959228516,233.59912109375],[20.463918685913086,233.3036346435547],[20.63401985168457,233.01219177246094],[20.81057357788086,232.72425842285156],[20.992658615112305,232.44015502929688],[21.179826736450195,232.15914916992188],[21.371368408203125,231.8811798095703],[21.56686019897461,231.60597229003906],[21.765777587890625,231.3332061767578],[21.967609405517578,231.06251525878906],[22.17173194885254,230.79380798339844],[22.37782859802246,230.5262451171875],[22.58539581298828,230.2600860595703],[22.79410743713379,229.9946746826172],[23.00320816040039,229.729736328125],[23.212549209594727,229.46485900878906],[23.421659469604492,229.19992065429688],[23.630290985107422,228.93447875976562],[23.83762550354004,228.66812133789062],[24.043514251708984,228.4005889892578],[24.247533798217773,228.13168334960938],[24.449007034301758,227.86074829101562],[24.647512435913086,227.58773803710938],[24.84486198425293,227.31373596191406],[25.044328689575195,227.0413818359375],[25.246110916137695,226.7708282470703],[25.450096130371094,226.50164794921875],[25.655702590942383,226.23399353027344],[25.862924575805664,225.967529296875],[26.071691513061523,225.70220947265625],[26.281585693359375,225.43771362304688],[26.492313385009766,225.17405700683594],[26.70392417907715,224.91099548339844],[26.916030883789062,224.6484375],[27.12824058532715,224.38584899902344],[27.34076499938965,224.12364196777344],[27.55336570739746,223.861328125],[27.765588760375977,223.5989227294922],[27.97745704650879,223.33602905273438],[28.18865394592285,223.0727081298828],[28.39910316467285,222.8086700439453],[28.60851287841797,222.54397583007812],[28.81662940979004,222.27810668945312],[29.023208618164062,222.0111083984375],[29.228191375732422,221.74278259277344],[29.431180953979492,221.47320556640625],[29.63205337524414,221.20175170898438],[29.83051300048828,220.92869567871094],[30.026456832885742,220.6537628173828],[30.21941566467285,220.3767852783203],[30.409162521362305,220.09762573242188],[30.595600128173828,219.81622314453125],[30.77850341796875,219.53236389160156],[30.9572696685791,219.2460174560547],[31.131784439086914,218.95713806152344],[31.30177879333496,218.66531372070312],[31.46688461303711,218.37095642089844],[31.62678337097168,218.07359313964844],[31.7812442779541,217.7735137939453],[31.92983055114746,217.4703369140625],[32.07291030883789,217.16455078125],[32.2126579284668,216.857177734375],[32.349647521972656,216.5487060546875],[32.483558654785156,216.2388153076172],[32.61476516723633,215.92787170410156],[32.74314498901367,215.6155548095703],[32.868717193603516,215.30230712890625],[32.991668701171875,214.98782348632812],[33.11178207397461,214.67239379882812],[33.22945785522461,214.3558349609375],[33.34420394897461,214.0384979248047],[33.456661224365234,213.72007751464844],[33.56626892089844,213.40081787109375],[33.67354202270508,213.08074951171875],[33.77814483642578,212.75985717773438],[33.88041687011719,212.4380645751953],[33.98011779785156,212.11563110351562],[34.0775032043457,211.792236328125],[34.17241668701172,211.46835327148438],[34.26494216918945,211.14370727539062],[34.35517120361328,210.8184356689453],[34.44300079345703,210.4923858642578],[34.528594970703125,210.1659393310547],[34.611793518066406,209.8386688232422],[34.69290542602539,209.5108642578125],[34.77149200439453,209.18264770507812],[34.848079681396484,208.8538055419922],[34.92222213745117,208.5245361328125],[34.994361877441406,208.1946563720703],[35.06411361694336,207.86451721191406],[35.13184356689453,207.53370666503906],[35.19731521606445,207.2025146484375],[35.26065444946289,206.87095642089844],[35.32184600830078,206.5390167236328],[35.38087844848633,206.20652770996094],[35.43783187866211,205.87387084960938],[35.49256896972656,205.54063415527344],[35.545310974121094,205.2073211669922],[35.59577560424805,204.87339782714844],[35.644256591796875,204.53941345214844],[35.690528869628906,204.20498657226562],[35.73476028442383,203.870361328125],[35.77692794799805,203.53538513183594],[35.81682586669922,203.2001953125],[35.85463333129883,202.86468505859375],[35.89028549194336,202.52911376953125],[35.9235954284668,202.19309997558594],[35.954627990722656,201.85693359375],[35.98342514038086,201.52052307128906],[36.00973892211914,201.1840362548828],[36.03361892700195,200.84730529785156],[36.05511474609375,200.51046752929688],[36.07400894165039,200.17335510253906],[36.090301513671875,199.83607482910156],[36.10405349731445,199.49880981445312],[36.115028381347656,199.1613006591797],[36.12321853637695,198.82395935058594],[36.12870788574219,198.48629760742188],[36.1312141418457,198.14886474609375],[36.13074493408203,197.81112670898438],[36.12737274169922,197.4737091064453],[36.12079620361328,197.1360626220703],[36.11103439331055,196.79867553710938],[36.098148345947266,196.46133422851562],[36.08182907104492,196.12423706054688],[36.06205368041992,195.7871551513672],[36.03890609741211,195.45037841796875],[36.0120964050293,195.11386108398438],[35.98153305053711,194.77772521972656],[35.94729232788086,194.44175720214844],[35.90918731689453,194.1063995361328],[35.8669319152832,193.7714385986328],[35.82072067260742,193.4371337890625],[35.770416259765625,193.10317993164062],[35.71552276611328,192.77012634277344],[35.65646743774414,192.4376983642578],[35.59276580810547,192.10629272460938],[35.524375915527344,191.7756805419922],[35.45124053955078,191.44615173339844],[35.37309646606445,191.11769104003906],[35.28865051269531,190.79086303710938],[35.19744110107422,190.46578979492188],[35.099849700927734,190.1427764892578],[34.99602508544922,189.8214874267578],[34.88628387451172,189.50216674804688],[34.770999908447266,189.18487548828125],[34.65040969848633,188.86949157714844],[34.524845123291016,188.5562286376953],[34.394287109375,188.2448272705078],[34.25947570800781,187.93544006347656],[34.12037658691406,187.62782287597656],[33.977115631103516,187.3220977783203],[33.830078125,187.01824951171875],[33.67948913574219,186.7161407470703],[33.525543212890625,186.4156951904297],[33.36846923828125,186.1168975830078],[33.208438873291016,185.81964111328125],[33.04558563232422,185.52394104003906],[32.880096435546875,185.22967529296875],[32.71221923828125,184.936767578125],[32.54212188720703,184.64512634277344],[32.37003707885742,184.3547821044922],[32.19599151611328,184.0654754638672],[32.02021026611328,183.77740478515625],[31.842605590820312,183.49021911621094],[31.66379165649414,183.203857421875],[31.48373031616211,182.91835021972656],[31.30248260498047,182.63351440429688],[31.12021255493164,182.3492889404297],[30.937089920043945,182.06576538085938],[30.753210067749023,181.78257751464844],[30.568872451782227,181.4998779296875],[30.383968353271484,181.21737670898438],[30.198925018310547,180.93495178222656],[30.01351547241211,180.65286254882812],[29.82712173461914,180.37136840820312],[29.639684677124023,180.09068298339844],[29.451099395751953,179.81056213378906],[29.261598587036133,179.53131103515625],[29.07100486755371,179.25259399414062],[28.879491806030273,178.974609375],[28.686988830566406,178.6973114013672],[28.493545532226562,178.42062377929688],[28.299259185791016,178.1445770263672],[28.104167938232422,177.86917114257812],[27.908153533935547,177.59422302246094],[27.711383819580078,177.31988525390625],[27.51387596130371,177.046142578125],[27.315614700317383,176.77291870117188],[27.116596221923828,176.5001678466797],[26.917009353637695,176.22804260253906],[26.716663360595703,175.9562530517578],[26.51572608947754,175.6849822998047],[26.314159393310547,175.41412353515625],[26.112060546875,175.14373779296875],[25.909154891967773,174.8738555908203],[25.706220626831055,174.60415649414062],[25.502334594726562,174.33509826660156],[25.29837989807129,174.06614685058594],[25.093603134155273,173.7976837158203],[24.888713836669922,173.52938842773438],[24.683191299438477,173.26148986816406],[24.477567672729492,172.993896484375],[24.271390914916992,172.7265167236328],[24.06500244140625,172.45933532714844],[23.858341217041016,172.19247436523438],[23.651315689086914,171.92567443847656],[23.444183349609375,171.6591796875],[23.236637115478516,171.39285278320312],[23.02898597717285,171.1267547607422],[22.821260452270508,170.86056518554688],[22.613609313964844,170.594482421875],[22.405540466308594,170.32859802246094],[22.197471618652344,170.06283569335938],[21.989328384399414,169.79698181152344],[21.781259536743164,169.53121948242188],[21.573116302490234,169.26535034179688],[21.365047454833984,168.9995880126953],[21.156904220581055,168.73373413085938],[20.948959350585938,168.4679412841797],[20.741119384765625,168.20184326171875],[20.533355712890625,167.9358367919922],[20.325517654418945,167.66973876953125],[20.117952346801758,167.4034881591797],[19.910585403442383,167.13702392578125],[19.703603744506836,166.87049865722656],[19.496665954589844,166.60369873046875],[19.290178298950195,166.33668518066406],[19.083763122558594,166.06947326660156],[18.877965927124023,165.80198669433594],[18.672168731689453,165.53431701660156],[18.467117309570312,165.26620483398438],[18.262062072753906,164.99790954589844],[18.057842254638672,164.72918701171875],[17.853551864624023,164.4603271484375],[17.649351119995117,164.19142150878906],[17.444721221923828,163.92295837402344],[17.239727020263672,163.65472412109375],[17.03436851501465,163.38685607910156],[16.828495025634766,163.11924743652344],[16.622413635253906,162.8519287109375],[16.415971755981445,162.58474731445312],[16.209192276000977,162.31796264648438],[16.002079010009766,162.05130004882812],[15.794779777526855,161.78494262695312],[15.587406158447266,161.5184783935547],[15.379847526550293,161.25241088867188],[15.17197322845459,160.98634338378906],[14.964174270629883,160.72036743164062],[14.756062507629395,160.45440673828125],[14.547983169555664,160.1886444091797],[14.339828491210938,159.9228057861328],[14.13180160522461,159.6570587158203],[13.923675537109375,159.3911895751953],[13.715624809265137,159.1254119873047],[13.507498741149902,158.8595428466797],[13.299448013305664,158.59376525878906],[13.091296195983887,158.32781982421875],[12.883716583251953,158.06167602539062],[12.676061630249023,157.79544067382812],[12.468603134155273,157.52928161621094],[12.261554718017578,157.26255798339844],[12.054581642150879,156.99594116210938],[11.847644805908203,156.7290802001953],[11.641199111938477,156.46189880371094],[11.435198783874512,156.19451904296875],[11.229418754577637,155.92686462402344],[11.024049758911133,155.65899658203125],[10.819099426269531,155.39060974121094],[10.614673614501953,155.12217712402344],[10.410400390625,154.8531951904297],[10.206961631774902,154.58387756347656],[10.003911972045898,154.31417846679688],[9.801305770874023,154.044189453125],[9.599372863769531,153.77357482910156],[9.398099899291992,153.50262451171875],[9.197275161743164,153.2312469482422],[8.997222900390625,152.9593963623047],[8.797835350036621,152.68682861328125],[8.599166870117188,152.41404724121094],[8.401098251342773,152.14059448242188],[8.202070236206055,151.86798095703125],[8.000408172607422,151.59722900390625],[7.797672271728516,151.32730102539062],[7.59534215927124,151.0570831298828],[7.394887924194336,150.78550720214844],[7.197567462921143,150.51156616210938],[7.005091667175293,150.23428344726562],[6.818887233734131,149.95257568359375],[6.641012191772461,149.66575622558594],[6.473191261291504,149.3727569580078],[6.317842483520508,149.0731964111328],[6.177489757537842,148.76608276367188],[6.055257797241211,148.45162963867188],[5.954035758972168,148.12957763671875],[5.877193450927734,147.80091857910156],[5.820119380950928,147.4681396484375],[5.767974376678467,147.1345672607422],[5.720035076141357,146.80047607421875],[5.676558017730713,146.4656524658203],[5.637362957000732,146.13040161132812],[5.60272216796875,145.79454040527344],[5.572428226470947,145.4584197998047],[5.54684591293335,145.12167358398438],[5.525743007659912,144.78480529785156],[5.509471893310547,144.44760131835938],[5.49789571762085,144.11021423339844],[5.491252899169922,143.772705078125],[5.489604949951172,143.43519592285156],[5.493002891540527,143.09756469726562],[5.501747131347656,142.76011657714844],[5.515685081481934,142.42282104492188],[5.53533411026001,142.0858917236328],[5.560493469238281,141.74908447265625],[5.591551303863525,141.4130401611328],[5.628549098968506,141.07748413085938],[5.671699047088623,140.74270629882812],[5.72124719619751,140.4087677001953],[5.77719783782959,140.07591247558594],[5.840015411376953,139.74407958984375],[5.909730434417725,139.4139404296875],[5.986680507659912,139.08511352539062],[6.068698406219482,138.75765991210938],[6.150929927825928,138.43019104003906],[6.233161449432373,138.1027069091797],[6.3153977394104,137.77536010742188],[6.398207664489746,137.44802856445312],[6.481060981750488,137.12081909179688],[6.564266204833984,136.7935791015625],[6.64755392074585,136.46652221679688],[6.731167316436768,136.139404296875],[6.814906597137451,135.81246948242188],[6.898932933807373,135.48545837402344],[6.983155250549316,135.1585693359375],[7.067604064941406,134.83164978027344],[7.152289867401123,134.50494384765625],[7.237166404724121,134.17813110351562],[7.3223443031311035,133.8515167236328],[7.407662868499756,133.5248260498047],[7.493319511413574,133.19837951660156],[7.579079627990723,132.87179565429688],[7.665241241455078,132.5454864501953],[7.751518249511719,132.2189483642578],[7.838170051574707,131.8927459716797],[7.924930572509766,131.5664520263672],[8.012054443359375,131.2403564453125],[8.099333763122559,130.9142303466797],[8.186938285827637,130.58827209472656],[8.274778366088867,130.26219177246094],[8.362869262695312,129.93637084960938],[8.451210021972656,129.610595703125],[8.539798736572266,129.28489685058594],[8.628742218017578,128.95909118652344],[8.717835426330566,128.63352966308594],[8.807323455810547,128.30795288085938],[8.896964073181152,127.98242950439453],[8.986971855163574,127.6572036743164],[9.077134132385254,127.33181762695312],[9.167765617370605,127.00660705566406],[9.258454322814941,126.681396484375],[9.349653244018555,126.35643005371094],[9.440937042236328,126.0313949584961],[9.532684326171875,125.70657348632812],[9.624570846557617,125.3817138671875],[9.716874122619629,125.05706024169922],[9.80940055847168,124.73229217529297],[9.902267456054688,124.40779113769531],[9.995409965515137,124.08323669433594],[10.088850021362305,123.75890350341797],[10.182613372802734,123.43457794189453],[10.27663516998291,123.11041259765625],[10.371060371398926,122.78621673583984],[10.46567153930664,122.46222686767578],[10.56076431274414,122.13819122314453],[10.655976295471191,121.81436920166016],[10.751710891723633,121.49060821533203],[10.847529411315918,121.1669692993164],[10.943946838378906,120.8433837890625],[11.04039192199707,120.51992797851562],[11.13748550415039,120.19654083251953],[11.234618186950684,119.873291015625],[11.332345008850098,119.55010223388672],[11.430173873901367,119.2270736694336],[11.528542518615723,118.9040756225586],[11.627106666564941,118.5811767578125],[11.726091384887695,118.25849151611328],[11.825398445129395,117.93573760986328],[11.925041198730469,117.6132583618164],[12.025066375732422,117.290771484375],[12.125377655029297,116.96849822998047],[12.22612476348877,116.64629364013672],[12.327112197875977,116.32423400878906],[12.42866039276123,116.00211334228516],[12.53033447265625,115.68026733398438],[12.632584571838379,115.35858154296875],[12.73495101928711,115.03694915771484],[12.838018417358398,114.71537017822266],[12.94108772277832,114.3940200805664],[13.044906616210938,114.0727310180664],[13.148797988891602,113.75152587890625],[13.253339767456055,113.43047332763672],[13.357990264892578,113.1096420288086],[13.463261604309082,112.78882598876953],[13.568755149841309,112.46815490722656],[13.674761772155762,112.14757537841797],[13.781062126159668,111.82720184326172],[13.887818336486816,111.50688171386719],[13.994937896728516,111.18681335449219],[14.102449417114258,110.86673736572266],[14.210392951965332,110.54700469970703],[14.318671226501465,110.2271957397461],[14.42748737335205,109.9076919555664],[14.536540985107422,109.588134765625],[14.64623737335205,109.26887512207031],[14.756073951721191,108.94959259033203],[14.86666202545166,108.63058471679688],[14.977307319641113,108.31168365478516],[15.088736534118652,107.99295806884766],[15.20023250579834,107.67446899414062],[15.31247329711914,107.35602569580078],[15.424917221069336,107.0377197265625],[15.537978172302246,106.71956634521484],[15.651296615600586,106.40169525146484],[15.765185356140137,106.0838394165039],[15.879467964172363,105.76617431640625],[15.994194984436035,105.44861602783203],[16.109365463256836,105.13141632080078],[16.224939346313477,104.81417083740234],[16.34109115600586,104.49722290039062],[16.45751953125,104.18028259277344],[16.57461929321289,103.86371612548828],[16.69191551208496,103.54710388183594],[16.809974670410156,103.2309341430664],[16.928203582763672,102.91460418701172],[17.047212600708008,102.5987548828125],[17.16640853881836,102.28284454345703],[17.28631019592285,101.96733093261719],[17.406476974487305,101.65187072753906],[17.52728271484375,101.33670806884766],[17.648479461669922,101.02157592773438],[17.77019500732422,100.7067642211914],[17.892431259155273,100.3919906616211],[18.01506805419922,100.07752990722656],[18.13853645324707,99.76329040527344],[18.26429557800293,99.4499282836914],[18.392295837402344,99.13755798339844],[18.52252960205078,98.82605743408203],[18.654861450195312,98.51564025878906],[18.789390563964844,98.20594787597656],[18.925973892211914,97.89720153808594],[19.0645694732666,97.58938598632812],[19.20512580871582,97.28248596191406],[19.347652435302734,96.97638702392578],[19.491975784301758,96.67135620117188],[19.638256072998047,96.36698913574219],[19.78626823425293,96.06358337402344],[19.93600845336914,95.76103210449219],[20.087438583374023,95.45932006835938],[20.24051856994629,95.15840911865234],[20.3951358795166,94.85843658447266],[20.551366806030273,94.55913543701172],[20.709108352661133,94.26061248779297],[20.868310928344727,93.96285247802734],[21.028820037841797,93.66606140136719],[21.190818786621094,93.36979675292969],[21.354095458984375,93.0743637084961],[21.518814086914062,92.77965545654297],[21.68465232849121,92.4855728149414],[21.851686477661133,92.19217681884766],[22.019817352294922,91.8995590209961],[22.189178466796875,91.60738372802734],[22.35948371887207,91.31605529785156],[22.53093719482422,91.02515411376953],[22.70330810546875,90.73497009277344],[22.876680374145508,90.44528198242188],[23.051010131835938,90.15606689453125],[23.22612762451172,89.86754608154297],[23.40218162536621,89.5793685913086],[23.57893943786621,89.29183959960938],[23.756547927856445,89.00464630126953],[23.93477439880371,88.71805572509766],[24.113771438598633,88.43177032470703],[24.293363571166992,88.14598083496094],[24.47364044189453,87.8604736328125],[24.654430389404297,87.57543182373047],[24.83576011657715,87.29071044921875],[25.0175838470459,87.00633239746094],[25.199981689453125,86.72212219238281],[25.382884979248047,86.4384536743164],[25.565885543823242,86.15473175048828],[25.749496459960938,85.87152099609375],[25.93325424194336,85.58821868896484],[26.117429733276367,85.30537414550781],[26.30173683166504,85.02249145507812],[26.48634910583496,84.73992919921875],[26.671083450317383,84.45732879638672],[26.855989456176758,84.17495727539062],[27.041046142578125,83.89247131347656],[27.226133346557617,83.61022186279297],[27.411285400390625,83.32786560058594],[27.596372604370117,83.04561614990234],[27.78138542175293,82.76329040527344],[27.966259002685547,82.48090362548828],[28.151199340820312,82.19841003417969],[28.336074829101562,81.91602325439453],[28.5211124420166,81.63355255126953],[28.70702362060547,81.35179901123047],[28.89415740966797,81.0708999633789],[29.08258628845215,80.79059600830078],[29.27206802368164,80.51130676269531],[29.46265983581543,80.23267364501953],[29.6544189453125,79.9548110961914],[29.84710121154785,79.67765045166016],[30.040916442871094,79.40123748779297],[30.235620498657227,79.12539672851562],[30.431270599365234,78.85039520263672],[30.627809524536133,78.57585906982422],[30.825254440307617,78.3020248413086],[31.02349090576172,78.02872467041016],[31.222448348999023,77.75614929199219],[31.42229461669922,77.48389434814453],[31.62276268005371,77.21238708496094],[31.823984146118164,76.94125366210938],[32.02581787109375,76.67073059082031],[32.22825622558594,76.40050506591797],[32.43112564086914,76.13075256347656],[32.63478088378906,75.86144256591797],[32.83882141113281,75.59258270263672],[33.0433349609375,75.32396697998047],[33.24822235107422,75.05574035644531],[33.4537467956543,74.78777313232422],[33.65949630737305,74.52017974853516],[33.8655891418457,74.25276184082031],[34.07197189331055,73.98568725585938],[34.27867889404297,73.71882629394531],[34.485755920410156,73.4520492553711],[34.692955017089844,73.18560791015625],[34.90022659301758,72.9190673828125],[35.1077766418457,72.6528549194336],[35.31550979614258,72.38667297363281],[35.52316665649414,72.12059020996094],[35.73089599609375,71.85440826416016],[35.93855285644531,71.58832550048828],[36.14628601074219,71.32212829589844],[36.353919982910156,71.05602264404297],[36.56162643432617,70.78982543945312],[36.76909255981445,70.52359008789062],[36.97646713256836,70.25712585449219],[37.18376541137695,69.99076080322266],[37.39078903198242,69.72410583496094],[37.59752655029297,69.45734405517578],[37.80412673950195,69.1903076171875],[38.01025390625,68.92303466796875],[38.21621322631836,68.65534210205078],[38.42170333862305,68.38761901855469],[38.62690353393555,68.1194839477539],[38.831451416015625,67.85105895996094],[39.03571701049805,67.5821533203125],[39.23945617675781,67.31304931640625],[39.44268035888672,67.04341125488281],[39.64516067504883,66.7734146118164],[39.84733200073242,66.50294494628906],[40.04864501953125,66.23211669921875],[40.24937438964844,65.96060180664062],[40.449378967285156,65.68869018554688],[40.64863204956055,65.41609954833984],[40.847171783447266,65.14302062988281],[41.044803619384766,64.86929321289062],[41.24164581298828,64.59504699707031],[41.43753433227539,64.3200912475586],[41.632537841796875,64.04457092285156],[41.8265266418457,63.768333435058594],[42.01961898803711,63.49134826660156],[42.21156692504883,63.21373748779297],[42.402523040771484,62.93529510498047],[42.59234619140625,62.65612030029297],[42.7810173034668,62.37614059448242],[42.968509674072266,62.09541320800781],[43.15474319458008,61.81380844116211],[43.33969497680664,61.53152847290039],[43.52334213256836,61.24821472167969],[43.70568084716797,60.96418762207031],[43.8865852355957,60.67906951904297],[44.06612014770508,60.39326858520508],[44.244102478027344,60.106319427490234],[44.42067337036133,59.81861114501953],[44.59554672241211,59.529869079589844],[44.76893615722656,59.240272521972656],[44.94062805175781,58.949546813964844],[45.11067199707031,58.657989501953125],[45.27899169921875,58.365272521972656],[45.44554138183594,58.07167434692383],[45.610328674316406,57.77692794799805],[45.773468017578125,57.481414794921875],[45.93527603149414,57.185142517089844],[46.09575271606445,56.88798522949219],[46.25464630126953,56.59031677246094],[46.41239929199219,56.29172134399414],[46.568809509277344,55.99266815185547],[46.72389221191406,55.692691802978516],[46.87767028808594,55.392276763916016],[47.03035354614258,55.091129302978516],[47.1817512512207,54.78946304321289],[47.331974029541016,54.48707580566406],[47.48107147216797,54.18421173095703],[47.629127502441406,53.88079071044922],[47.77593994140625,53.57680130004883],[47.9217643737793,53.27229309082031],[48.066566467285156,52.96738815307617],[48.2103271484375,52.661964416503906],[48.35307312011719,52.356082916259766],[48.494930267333984,52.04974365234375],[48.6358757019043,51.7430419921875],[48.77590560913086,51.43572998046875],[48.91501235961914,51.12822723388672],[49.05339813232422,50.82022476196289],[49.190887451171875,50.51194381713867],[49.327606201171875,50.203216552734375],[49.46352767944336,49.89436721801758],[49.598854064941406,49.584991455078125],[49.733341217041016,49.275421142578125],[49.867252349853516,48.96543884277344],[50.00052261352539,48.65528869628906],[50.133148193359375,48.34487533569336],[50.26515197753906,48.03425979614258],[50.39657974243164,47.72323226928711],[50.52772521972656,47.41209411621094],[50.658077239990234,47.100704193115234],[50.78812789916992,46.78915786743164],[50.91775894165039,46.47751998901367],[51.04690933227539,46.165462493896484],[51.17570877075195,45.85354232788086],[51.304195404052734,45.541297912597656],[51.43227005004883,45.22898864746094],[51.5601692199707,44.916534423828125],[51.687705993652344,44.604034423828125],[51.8150634765625,44.29130935668945],[51.942237854003906,43.97861862182617],[52.06918716430664,43.665748596191406],[52.195919036865234,43.353004455566406],[52.32259750366211,43.04001998901367],[52.4492301940918,42.72715377807617],[52.57590866088867,42.41409683227539],[52.70248794555664,42.10120391845703],[52.82910919189453,41.78820037841797],[52.955684661865234,41.47530746459961],[53.08230972290039,41.16230392456055],[53.208885192871094,40.84941101074219],[53.33562088012695,40.53642654418945],[53.462711334228516,40.2237434387207],[53.589847564697266,39.91094970703125],[53.71696090698242,39.59834671020508],[53.8446044921875,39.2857551574707],[53.9724235534668,38.97340774536133],[54.100494384765625,38.66099548339844],[54.22911071777344,38.348690032958984],[54.35789108276367,38.036712646484375],[54.48704528808594,37.72474670410156],[54.61671829223633,37.413169860839844],[54.746788024902344,37.10153579711914],[54.87725830078125,36.79024887084961],[55.00840759277344,36.47913360595703],[55.13981246948242,36.168304443359375],[55.27200698852539,35.85752487182617],[55.4046745300293,35.547210693359375],[55.53810501098633,35.23698425292969],[55.67210006713867,34.9272346496582],[55.806793212890625,34.61765670776367],[55.94221115112305,34.30842590332031],[56.07842254638672,33.99952697753906],[56.21531677246094,33.69106674194336],[56.353065490722656,33.3828010559082],[56.49171447753906,33.075016021728516],[56.6312370300293,32.76750564575195],[56.77155685424805,32.46051025390625],[56.912933349609375,32.153892517089844],[57.05520248413086,31.84783935546875],[57.198448181152344,31.54212760925293],[57.34273147583008,31.236997604370117],[57.48817443847656,30.932241439819336],[57.63458251953125,30.62809944152832],[57.78215026855469,30.32441520690918],[57.930885314941406,30.02145767211914],[58.08078384399414,29.718955993652344],[58.231815338134766,29.417104721069336],[58.3842887878418,29.115800857543945],[58.537960052490234,28.81511688232422],[58.69274139404297,28.51528549194336],[58.849124908447266,28.21601676940918],[59.006736755371094,27.917551040649414],[59.165714263916016,27.61967658996582],[59.326385498046875,27.32284164428711],[59.496681213378906,27.03133773803711],[59.67936706542969,26.747562408447266],[59.87333297729492,26.471176147460938],[60.07752227783203,26.20244789123535],[60.29123306274414,25.941118240356445],[60.51380157470703,25.687353134155273],[60.74468994140625,25.44104766845703],[60.983394622802734,25.202472686767578],[61.229774475097656,24.971538543701172],[61.483192443847656,24.74868392944336],[61.7437744140625,24.533916473388672],[62.01102828979492,24.327835083007812],[62.28501892089844,24.130582809448242],[62.565452575683594,23.94285774230957],[62.85257339477539,23.76503562927246],[63.14576721191406,23.598112106323242],[63.4455451965332,23.442720413208008],[63.7514533996582,23.300003051757812],[64.06346130371094,23.171140670776367],[64.38134002685547,23.05771827697754],[64.70488739013672,22.961416244506836],[65.033447265625,22.884326934814453],[65.36640167236328,22.82866859436035],[65.70176696777344,22.789409637451172],[66.03819274902344,22.7625789642334],[66.37549591064453,22.747116088867188],[66.71295166015625,22.74205780029297],[67.05054473876953,22.746315002441406],[67.3878173828125,22.75897216796875],[67.72479248046875,22.779205322265625],[68.06133270263672,22.8061580657959],[68.39738464355469,22.839012145996094],[68.73268127441406,22.877017974853516],[69.06767272949219,22.91953468322754],[69.40196990966797,22.96589469909668],[69.73602294921875,23.015460968017578],[70.0694351196289,23.067628860473633],[70.40265655517578,23.121896743774414],[70.73553466796875,23.17768669128418],[71.068359375,23.234542846679688],[71.40103149414062,23.291839599609375],[71.7337646484375,23.349201202392578],[72.06649780273438,23.406051635742188],[72.39948272705078,23.462003707885742],[72.73258209228516,23.516433715820312],[73.06610870361328,23.568918228149414],[73.39990997314453,23.618906021118164],[73.73417663574219,23.666000366210938],[74.06889343261719,23.70945167541504],[74.4042739868164,23.74880599975586],[74.74002075195312,23.783437728881836],[75.07637786865234,23.81275749206543],[75.41305541992188,23.836101531982422],[75.75029754638672,23.85280990600586],[76.08773040771484,23.864133834838867],[76.42515563964844,23.873868942260742],[76.76264953613281,23.882061004638672],[77.10020446777344,23.888607025146484],[77.43769836425781,23.89356803894043],[77.77531433105469,23.896921157836914],[78.11294555664062,23.898622512817383],[78.45046997070312,23.898515701293945],[78.7880859375,23.896697998046875],[79.12561798095703,23.89313507080078],[79.46311950683594,23.887798309326172],[79.80059051513672,23.88050079345703],[80.13815307617188,23.87134552001953],[80.47552490234375,23.860309600830078],[80.81290435791016,23.847349166870117],[81.15003204345703,23.832277297973633],[81.48724365234375,23.8151912689209],[81.82431030273438,23.796070098876953],[82.16128540039062,23.774869918823242],[82.4979476928711,23.751392364501953],[82.83464050292969,23.725732803344727],[83.17097473144531,23.697887420654297],[83.50726318359375,23.667789459228516],[83.84329986572266,23.635223388671875],[84.17908477783203,23.600317001342773],[84.5145492553711,23.56303596496582],[84.84988403320312,23.523317337036133],[85.18473815917969,23.480981826782227],[85.51933288574219,23.436086654663086],[85.85350036621094,23.38863182067871],[86.18746948242188,23.338533401489258],[86.52093505859375,23.285648345947266],[86.85380554199219,23.229997634887695],[87.18629455566406,23.171558380126953],[87.51826477050781,23.110305786132812],[87.84969329833984,23.046110153198242],[88.1805191040039,22.978912353515625],[88.51092529296875,22.909439086914062],[88.84075164794922,22.83783721923828],[89.1702651977539,22.763944625854492],[89.49915313720703,22.688077926635742],[89.82758331298828,22.609987258911133],[90.15550994873047,22.529848098754883],[90.48297119140625,22.447715759277344],[90.80980682373047,22.36341094970703],[91.13631439208984,22.277162551879883],[91.46208953857422,22.188892364501953],[91.78744506835938,22.098604202270508],[92.1120376586914,22.006515502929688],[92.4362564086914,21.912254333496094],[92.75984954833984,21.81620979309082],[93.08293151855469,21.718183517456055],[93.40542602539062,21.618242263793945],[93.72737884521484,21.516515731811523],[94.04854583740234,21.412809371948242],[94.36925506591797,21.30733299255371],[94.68926239013672,21.199993133544922],[95.00879669189453,21.090770721435547],[95.32762145996094,20.97987174987793],[95.64575958251953,20.867019653320312],[95.9633560180664,20.752479553222656],[96.2802734375,20.636112213134766],[96.59650421142578,20.517986297607422],[96.91213989257812,20.39818000793457],[97.22700500488281,20.276506423950195],[97.54124450683594,20.15320587158203],[97.85488891601562,20.028079986572266],[98.16767120361328,19.901304244995117],[98.47986602783203,19.77287483215332],[98.79129791259766,19.642601013183594],[99.10212707519531,19.510704040527344],[99.41211700439453,19.377126693725586],[99.72138214111328,19.241836547851562],[100.02992248535156,19.104984283447266],[100.3377456665039,18.96627426147461],[100.64485168457031,18.82597541809082],[100.951171875,18.683826446533203],[101.25597381591797,18.539005279541016],[101.55961608886719,18.391399383544922],[101.86190795898438,18.241235733032227],[102.16311645507812,18.08851432800293],[102.46295166015625,17.933481216430664],[102.76161193847656,17.77614402770996],[103.05912017822266,17.616708755493164],[103.35569763183594,17.455184936523438],[103.6510009765625,17.291902542114258],[103.94547271728516,17.12674903869629],[104.23897552490234,16.959888458251953],[104.53157806396484,16.791454315185547],[104.8232421875,16.62152671813965],[105.11421966552734,16.45033836364746],[105.40451049804688,16.27788543701172],[105.69402313232422,16.104341506958008],[105.98295593261719,15.929670333862305],[106.27117156982422,15.754150390625],[106.55907440185547,15.57768440246582],[106.84639739990234,15.400575637817383],[107.13350677490234,15.222733497619629],[107.4200210571289,15.044417381286621],[107.70645904541016,14.865650177001953],[107.99264526367188,14.686600685119629],[108.27873992919922,14.507280349731445],[108.56460571289062,14.32794189453125],[108.85059356689453,14.148462295532227],[109.13648223876953,13.969046592712402],[109.4224624633789,13.789586067199707],[109.70867156982422,13.610674858093262],[109.99500274658203,13.431807518005371],[110.28169250488281,13.253508567810059],[110.56871032714844,13.075752258300781],[110.85609436035156,12.898642539978027],[111.14399719238281,12.722224235534668],[111.43226623535156,12.546730041503906],[111.72125244140625,12.372078895568848],[112.01068878173828,12.198565483093262],[112.30103302001953,12.026044845581055],[112.59193420410156,11.854880332946777],[112.88368225097656,11.68504810333252],[113.17628479003906,11.516753196716309],[113.46990203857422,11.349973678588867],[113.76435089111328,11.184938430786133],[114.05978393554688,11.02170467376709],[114.35637664794922,10.860319137573242],[114.65404510498047,10.701025009155273],[114.95291137695312,10.543896675109863],[115.25283813476562,10.389087677001953],[115.55400085449219,10.23666000366211],[115.85643768310547,10.086727142333984],[116.16028594970703,9.939413070678711],[116.46537780761719,9.794986724853516],[116.77188110351562,9.653420448303223],[117.07962799072266,9.51492691040039],[117.38896942138672,9.379481315612793],[117.6996078491211,9.247415542602539],[118.01177215576172,9.118821144104004],[118.32524108886719,8.993769645690918],[118.64033508300781,8.872514724731445],[118.95674896240234,8.755001068115234],[119.27466583251953,8.641047477722168],[119.59364318847656,8.530686378479004],[119.91389465332031,8.42374038696289],[120.235107421875,8.320195198059082],[120.55746459960938,8.219878196716309],[120.88079833984375,8.122736930847168],[121.20506286621094,8.028676986694336],[121.53004455566406,7.93764066696167],[121.85595703125,7.849468231201172],[122.1825180053711,7.7642502784729],[122.50995635986328,7.681491851806641],[122.83784484863281,7.601600170135498],[123.16645812988281,7.52397346496582],[123.49571990966797,7.4490485191345215],[123.82522583007812,7.376294136047363],[124.15544128417969,7.305954933166504],[124.48603057861328,7.237654209136963],[124.81717681884766,7.171501159667969],[125.1485366821289,7.1073317527771],[125.48036193847656,7.045042991638184],[125.81240844726562,6.9846367835998535],[126.1448974609375,6.9258527755737305],[126.47757720947266,6.86884880065918],[126.8106460571289,6.813228607177734],[127.1438217163086,6.759282112121582],[127.47727966308594,6.706578731536865],[127.81085968017578,6.655284881591797],[128.14476013183594,6.605128288269043],[128.47879028320312,6.556135654449463],[128.81297302246094,6.508197784423828],[129.1472625732422,6.461392402648926],[129.481689453125,6.41525411605835],[129.81617736816406,6.3698344230651855],[130.15089416503906,6.3253583908081055],[130.48556518554688,6.281444072723389],[130.82032775878906,6.238003730773926],[131.1551055908203,6.195049285888672],[131.4901123046875,6.152541160583496],[131.82493591308594,6.110344886779785],[132.1599578857422,6.068330764770508],[132.49485778808594,6.026331424713135],[132.82989501953125,5.9848809242248535],[133.1652374267578,5.94456148147583],[133.50045776367188,5.905510902404785],[133.83595275878906,5.86763334274292],[134.17149353027344,5.831068515777588],[134.50730895996094,5.7956695556640625],[134.84307861328125,5.76165771484375],[135.1791534423828,5.728804111480713],[135.5151824951172,5.697403907775879],[135.8514404296875,5.667183876037598],[136.187744140625,5.638432025909424],[136.52432250976562,5.6109089851379395],[136.86087036132812,5.584864139556885],[137.19754028320312,5.560120582580566],[137.5342559814453,5.53685188293457],[137.8712615966797,5.514937400817871],[138.20811462402344,5.4945149421691895],[138.54525756835938,5.475512981414795],[138.88229370117188,5.458003997802734],[139.21957397460938,5.4419846534729],[139.55673217773438,5.427464485168457],[139.89419555664062,5.414501190185547],[140.23153686523438,5.403040409088135],[140.56898498535156,5.393218517303467],[140.9064178466797,5.384897232055664],[141.2439422607422,5.378290176391602],[141.58145141601562,5.373188018798828],[141.91909790039062,5.369879722595215],[142.2566375732422,5.3680830001831055],[142.59425354003906,5.368154048919678],[142.93177795410156,5.369782447814941],[143.26939392089844,5.37328577041626],[143.60704040527344,5.378431797027588],[143.94448852539062,5.385451316833496],[144.28199768066406,5.394205093383789],[144.61932373046875,5.4048309326171875],[144.95677185058594,5.417288780212402],[145.29405212402344,5.431615352630615],[145.63131713867188,5.4478759765625],[145.9683074951172,5.465987682342529],[146.30531311035156,5.486145973205566],[146.64212036132812,5.508145332336426],[146.9789276123047,5.532262802124023],[147.31546020507812,5.558207035064697],[147.65185546875,5.58610200881958],[147.98814392089844,5.615962505340576],[148.32427978515625,5.64763069152832],[148.66004943847656,5.6812920570373535],[148.99588012695312,5.716829776763916],[149.33132934570312,5.754164218902588],[149.6666717529297,5.793533802032471],[150.0016632080078,5.834660053253174],[150.33657836914062,5.877706050872803],[150.671142578125,5.922643184661865],[151.00555419921875,5.969351768493652],[151.3395233154297,6.018031120300293],[151.67327880859375,6.068509101867676],[152.00682067871094,6.120814323425293],[152.3400421142578,6.175074577331543],[152.6729278564453,6.231072902679443],[153.00558471679688,6.289017677307129],[153.33775329589844,6.348766326904297],[153.66966247558594,6.4102888107299805],[154.00128173828125,6.473835468292236],[154.3324737548828,6.539111614227295],[154.6634063720703,6.606283664703369],[154.99374389648438,6.675313949584961],[155.3238525390625,6.746129512786865],[155.65345764160156,6.818919658660889],[155.9827423095703,6.893527030944824],[156.31158447265625,6.969955921173096],[156.63999938964844,7.04837703704834],[156.96778869628906,7.128519535064697],[157.29525756835938,7.210649013519287],[157.6221923828125,7.294656753540039],[157.9488067626953,7.380499839782715],[158.27471923828125,7.468348979949951],[158.60015869140625,7.558033466339111],[158.92503356933594,7.6495819091796875],[159.24951171875,7.743208885192871],[159.5731964111328,7.838601589202881],[159.8964385986328,7.936021327972412],[160.21932983398438,8.03442668914795],[160.5419464111328,8.133901596069336],[160.86412048339844,8.234538078308105],[161.1859893798828,8.336640357971191],[161.50741577148438,8.439827919006348],[161.82839965820312,8.544458389282227],[162.14878845214844,8.650634765625],[162.46878051757812,8.758340835571289],[162.7882080078125,8.867573738098145],[163.1069793701172,8.978608131408691],[163.42527770996094,9.091398239135742],[163.74276733398438,9.205891609191895],[164.05972290039062,9.32247543334961],[164.37571716308594,9.440917015075684],[164.69110107421875,9.561391830444336],[165.00563049316406,9.684114456176758],[165.31932067871094,9.809029579162598],[165.63189697265625,9.936049461364746],[165.94375610351562,10.065645217895508],[166.25445556640625,10.197622299194336],[166.56417846679688,10.332053184509277],[166.87258911132812,10.469098091125488],[167.17994689941406,10.608893394470215],[167.48594665527344,10.751283645629883],[167.7906951904297,10.896595001220703],[168.09388732910156,11.044806480407715],[168.39588928222656,11.196008682250977],[168.69615173339844,11.350192070007324],[168.99481201171875,11.507669448852539],[169.29171752929688,11.66817855834961],[169.58694458007812,11.8319730758667],[169.88003540039062,11.999246597290039],[170.1714630126953,12.169838905334473],[170.4606475830078,12.343964576721191],[170.7476806640625,12.521746635437012],[171.0323486328125,12.703052520751953],[171.31471252441406,12.888176918029785],[171.5946502685547,13.07670783996582],[171.8740692138672,13.266227722167969],[172.15289306640625,13.456437110900879],[172.43133544921875,13.647544860839844],[172.70924377441406,13.839179992675781],[172.98672485351562,14.031411170959473],[173.26380920410156,14.224350929260254],[173.54022216796875,14.418023109436035],[173.8162841796875,14.612332344055176],[174.0919189453125,14.807198524475098],[174.36720275878906,15.002696990966797],[174.64181518554688,15.19894027709961],[174.91615295410156,15.39585018157959],[175.18997192382812,15.593219757080078],[175.46343994140625,15.791162490844727],[175.73629760742188,15.989835739135742],[176.00885009765625,16.18914794921875],[176.28094482421875,16.388944625854492],[176.5526885986328,16.589292526245117],[176.8238525390625,16.7902774810791],[177.09469604492188,16.99192237854004],[177.36502075195312,17.193952560424805],[177.6351776123047,17.39663314819336],[177.90467834472656,17.599830627441406],[178.17384338378906,17.803674697875977],[178.4424591064453,18.00786018371582],[178.71092224121094,18.21268653869629],[178.97882080078125,18.417991638183594],[179.24639892578125,18.623973846435547],[179.5135498046875,18.830350875854492],[179.78033447265625,19.03716278076172],[180.0466766357422,19.244487762451172],[180.3126983642578,19.452482223510742],[180.57835388183594,19.66089630126953],[180.84356689453125,19.869661331176758],[181.10848999023438,20.078983306884766],[181.3728485107422,20.288776397705078],[181.6370391845703,20.499113082885742],[181.90077209472656,20.70975685119629],[182.1642303466797,20.920917510986328],[182.4271240234375,21.13252830505371],[182.68984985351562,21.344654083251953],[182.9521026611328,21.557048797607422],[183.21417236328125,21.769954681396484],[183.4757080078125,21.983335494995117],[183.73707580566406,22.197193145751953],[183.99795532226562,22.411285400390625],[184.25865173339844,22.625858306884766],[184.518798828125,22.84087371826172],[184.77877807617188,23.056339263916016],[185.03839111328125,23.27208709716797],[185.2978057861328,23.48826026916504],[185.5566864013672,23.704833984375],[185.8153076171875,23.92177391052246],[186.07363891601562,24.139041900634766],[186.33177185058594,24.356698989868164],[186.58941650390625,24.57474136352539],[186.84686279296875,24.793188095092773],[187.10401916503906,25.011924743652344],[187.36085510253906,25.230937957763672],[187.61732482910156,25.450368881225586],[187.87367248535156,25.670269012451172],[188.12953186035156,25.89027214050293],[188.38526916503906,26.110708236694336],[188.64051818847656,26.331735610961914],[188.8956756591797,26.552682876586914],[189.15065002441406,26.774093627929688],[189.40509033203125,26.99585723876953],[189.65963745117188,27.217700958251953],[189.91351318359375,27.440078735351562],[190.1673583984375,27.6627140045166],[190.42100524902344,27.885377883911133],[190.6741943359375,28.108766555786133],[190.9272918701172,28.332075119018555],[191.18019104003906,28.555870056152344],[191.43264770507812,28.77989959716797],[191.68519592285156,29.004009246826172],[191.93707275390625,29.22858238220215],[192.1890106201172,29.45338249206543],[192.44078063964844,29.678295135498047],[192.69210815429688,29.903757095336914],[192.943359375,30.129138946533203],[193.1943359375,30.35491371154785],[193.4450225830078,30.580915451049805],[193.69580078125,30.806997299194336],[193.9459991455078,31.0335693359375],[194.19598388671875,31.26043701171875],[194.44561767578125,31.48761558532715],[194.6948699951172,31.715354919433594],[194.94384765625,31.943296432495117],[195.19252014160156,32.171688079833984],[195.44070434570312,32.400394439697266],[195.6887969970703,32.62946701049805],[195.9364776611328,32.858943939208984],[196.18377685546875,33.08873748779297],[196.43087768554688,33.31880569458008],[196.677490234375,33.54925537109375],[196.92393493652344,33.78010940551758],[197.17002868652344,34.011077880859375],[197.41580200195312,34.24260711669922],[197.6612548828125,34.474308013916016],[197.9065399169922,34.70633316040039],[198.15127563476562,34.93869400024414],[198.39593505859375,35.17138671875],[198.64024353027344,35.404273986816406],[198.88427734375,35.63766860961914],[199.12799072265625,35.87113952636719],[199.3715057373047,36.10502243041992],[199.61463928222656,36.339168548583984],[199.8576202392578,36.57365798950195],[200.1000213623047,36.808536529541016],[200.34249877929688,37.043495178222656],[200.5847625732422,37.278465270996094],[200.82644653320312,37.51424789428711],[201.06805419921875,37.749942779541016],[201.30970764160156,37.98577117919922],[201.550537109375,38.222251892089844],[201.7914581298828,38.45881652832031],[202.03228759765625,38.69529724121094],[202.2725067138672,38.93259048461914],[202.51260375976562,39.16981887817383],[202.75279235839844,39.407135009765625],[202.99220275878906,39.64491271972656],[203.231689453125,39.882938385009766],[203.47116088867188,40.12096405029297],[203.71006774902344,40.35945129394531],[203.94888305664062,40.59814453125],[204.18760681152344,40.836753845214844],[204.42599487304688,41.075897216796875],[204.66409301757812,41.31514358520508],[204.9022674560547,41.55447006225586],[205.13998413085938,41.79405212402344],[205.37754821777344,42.03398513793945],[205.61502075195312,42.27383041381836],[205.85235595703125,42.51408004760742],[206.08926391601562,42.75448989868164],[206.3262481689453,42.99498748779297],[206.56292724609375,43.23558807373047],[206.7993927001953,43.47661209106445],[207.0357666015625,43.717552185058594],[207.27207946777344,43.95873260498047],[207.50794982910156,44.20016098022461],[207.74391174316406,44.44167709350586],[207.97967529296875,44.68320083618164],[208.2151641845703,44.9251823425293],[208.4505615234375,45.16707229614258],[208.6859893798828,45.409095764160156],[208.9209442138672,45.65140914916992],[209.15599060058594,45.89380645751953],[209.3909149169922,46.13608932495117],[209.6255645751953,46.37887954711914],[209.86012268066406,46.621585845947266],[210.09475708007812,46.864376068115234],[210.32908630371094,47.107505798339844],[210.5632781982422,47.35055923461914],[210.7975616455078,47.59370040893555],[211.03150939941406,47.83705139160156],[211.2654571533203,48.08051681518555],[211.4993133544922,48.32389450073242],[211.73291015625,48.567626953125],[211.96633911132812,48.81141662597656],[212.19984436035156,49.0552978515625],[212.4332733154297,49.29908752441406],[212.6667938232422,49.542964935302734],[212.9002227783203,49.7867546081543],[213.13351440429688,50.03090286254883],[213.3665008544922,50.27512741088867],[213.59954833984375,50.519439697265625],[213.83253479003906,50.76366424560547],[214.06558227539062,51.00797653198242],[214.29856872558594,51.252201080322266],[214.53147888183594,51.49665451049805],[214.7640380859375,51.741268157958984],[214.99668884277344,51.98596954345703],[215.22926330566406,52.23058319091797],[215.4619140625,52.47528076171875],[215.69447326660156,52.71989440917969],[215.9271240234375,52.964595794677734],[216.15969848632812,53.20920944213867],[216.39234924316406,53.45391082763672],[216.62490844726562,53.69852066040039],[216.85755920410156,53.94322204589844],[217.0901336669922,54.187835693359375]],
	bounds=3000,
	full_zoom=0.25,
	max_episode_steps=1500
)

Austria = RaceTrack(
	name='Austria',
	xy =[[509.79998779296875,290.7200012207031],[509.42608642578125,290.8146057128906],[509.05218505859375,290.90924072265625],[508.67828369140625,291.00384521484375],[508.30438232421875,291.09844970703125],[507.93048095703125,291.1930847167969],[507.55657958984375,291.2876892089844],[507.1827087402344,291.38232421875],[506.8088073730469,291.4769287109375],[506.43487548828125,291.571533203125],[506.0610046386719,291.6661682128906],[505.6871032714844,291.7607727050781],[505.313232421875,291.8553771972656],[504.9393310546875,291.95001220703125],[504.5653991699219,292.04461669921875],[504.1915283203125,292.13922119140625],[503.817626953125,292.2338562011719],[503.4437255859375,292.3284606933594],[503.06982421875,292.423095703125],[502.6959228515625,292.5177001953125],[502.322021484375,292.6123046875],[501.9481201171875,292.7069396972656],[501.57421875,292.8015441894531],[501.2003173828125,292.89617919921875],[500.826416015625,292.99078369140625],[500.4525451660156,293.08538818359375],[500.07861328125,293.1800231933594],[499.7047119140625,293.2746276855469],[499.3308410644531,293.3692321777344],[498.9569396972656,293.4638671875],[498.5830383300781,293.5584716796875],[498.2091369628906,293.653076171875],[497.8352355957031,293.7477111816406],[497.46136474609375,293.8423156738281],[497.08746337890625,293.93695068359375],[496.71356201171875,294.03155517578125],[496.33966064453125,294.12615966796875],[495.96575927734375,294.2207946777344],[495.59185791015625,294.3153991699219],[495.21795654296875,294.4100341796875],[494.84405517578125,294.504638671875],[494.47015380859375,294.5992431640625],[494.09625244140625,294.6938781738281],[493.72235107421875,294.7884826660156],[493.34844970703125,294.8830871582031],[492.97454833984375,294.97772216796875],[492.6006774902344,295.07232666015625],[492.2267761230469,295.16693115234375],[491.85284423828125,295.2615661621094],[491.4789733886719,295.3561706542969],[491.1050720214844,295.4508056640625],[490.731201171875,295.54541015625],[490.3572998046875,295.6400146484375],[489.9833679199219,295.7346496582031],[489.6094970703125,295.8292541503906],[489.235595703125,295.92388916015625],[488.8616943359375,296.01849365234375],[488.48779296875,296.11309814453125],[488.1138916015625,296.20770263671875],[487.739990234375,296.3023376464844],[487.3660888671875,296.3969421386719],[486.9921875,296.4915771484375],[486.6182861328125,296.586181640625],[486.244384765625,296.6807861328125],[485.8704833984375,296.7754211425781],[485.49658203125,296.8700256347656],[485.1226806640625,296.96466064453125],[484.7488098144531,297.05926513671875],[484.3749084472656,297.15386962890625],[484.0010070800781,297.2485046386719],[483.6271057128906,297.3431091308594],[483.2532043457031,297.437744140625],[482.87933349609375,297.5323486328125],[482.50543212890625,297.626953125],[482.13153076171875,297.7215576171875],[481.75762939453125,297.8161926269531],[481.38372802734375,297.9107971191406],[481.00982666015625,298.00543212890625],[480.63592529296875,298.10003662109375],[480.26202392578125,298.19464111328125],[479.88812255859375,298.2892761230469],[479.51422119140625,298.3838806152344],[479.14031982421875,298.478515625],[478.76641845703125,298.5731201171875],[478.39251708984375,298.667724609375],[478.0186462402344,298.7623596191406],[477.64471435546875,298.8569641113281],[477.2708435058594,298.95159912109375],[476.8969421386719,299.04620361328125],[476.5230407714844,299.14080810546875],[476.1491394042969,299.23541259765625],[475.7752685546875,299.3300476074219],[475.4013366699219,299.4246520996094],[475.0274353027344,299.519287109375],[474.653564453125,299.6138916015625],[474.2796630859375,299.70849609375],[473.90576171875,299.8031311035156],[473.5318603515625,299.8977355957031],[473.157958984375,299.99237060546875],[472.7840576171875,300.08697509765625],[472.41015625,300.18157958984375],[472.0362548828125,300.2762145996094],[471.662353515625,300.3708190917969],[471.2884521484375,300.4654235839844],[470.91455078125,300.56005859375],[470.5406799316406,300.6546630859375],[470.1667785644531,300.7492980957031],[469.7928771972656,300.8439025878906],[469.4189758300781,300.9385070800781],[469.0450744628906,301.03314208984375],[468.6711730957031,301.12774658203125],[468.2972717285156,301.22235107421875],[467.92340087890625,301.3169860839844],[467.54949951171875,301.4115905761719],[467.17559814453125,301.5062255859375],[466.80169677734375,301.600830078125],[466.42779541015625,301.6954345703125],[466.05389404296875,301.7900695800781],[465.67999267578125,301.8846740722656],[465.30609130859375,301.9792785644531],[464.93218994140625,302.07391357421875],[464.55828857421875,302.16851806640625],[464.18438720703125,302.2631530761719],[463.81048583984375,302.3577575683594],[463.43658447265625,302.4523620605469],[463.0627136230469,302.5469970703125],[462.6888122558594,302.6416015625],[462.3149108886719,302.7362060546875],[461.9410095214844,302.8308410644531],[461.5671081542969,302.9254455566406],[461.1932067871094,303.02008056640625],[460.8193054199219,303.11468505859375],[460.4454040527344,303.20928955078125],[460.071533203125,303.3039245605469],[459.6976318359375,303.3985290527344],[459.32373046875,303.4931335449219],[458.9498291015625,303.5877685546875],[458.575927734375,303.682373046875],[458.2020263671875,303.7770080566406],[457.828125,303.8716125488281],[457.4542236328125,303.9662170410156],[457.080322265625,304.06085205078125],[456.7064208984375,304.15545654296875],[456.33251953125,304.25006103515625],[455.9586486816406,304.3446960449219],[455.5847473144531,304.4393005371094],[455.2108459472656,304.533935546875],[454.8369445800781,304.6285400390625],[454.4630432128906,304.72314453125],[454.0891418457031,304.8177795410156],[453.7152404785156,304.9123840332031],[453.34136962890625,305.0069885253906],[452.96746826171875,305.10162353515625],[452.59356689453125,305.19622802734375],[452.21966552734375,305.2908630371094],[451.84576416015625,305.3854675292969],[451.47186279296875,305.4800720214844],[451.09796142578125,305.57470703125],[450.72406005859375,305.6693115234375],[450.35015869140625,305.763916015625],[449.97625732421875,305.8585510253906],[449.60235595703125,305.9531555175781],[449.2284851074219,306.04779052734375],[448.85455322265625,306.14239501953125],[448.48065185546875,306.23699951171875],[448.1067810058594,306.3316345214844],[447.7328796386719,306.4262390136719],[447.3589782714844,306.5208435058594],[446.9850769042969,306.615478515625],[446.6111755371094,306.7100830078125],[446.2373046875,306.8046875],[445.8633728027344,306.8993225097656],[445.489501953125,306.9939270019531],[445.1156005859375,307.08856201171875],[444.74169921875,307.18316650390625],[444.3677978515625,307.27777099609375],[443.993896484375,307.3724060058594],[443.6199951171875,307.4670104980469],[443.24609375,307.5616455078125],[442.8721923828125,307.65625],[442.498291015625,307.7508544921875],[442.1243896484375,307.8454895019531],[441.75048828125,307.9400939941406],[441.3766174316406,308.0346984863281],[441.002685546875,308.12933349609375],[440.6288146972656,308.22393798828125],[440.2549133300781,308.31854248046875],[439.8810119628906,308.4131774902344],[439.5071105957031,308.5077819824219],[439.1332092285156,308.6024169921875],[438.7593078613281,308.697021484375],[438.38543701171875,308.7916259765625],[438.01153564453125,308.8862609863281],[437.63763427734375,308.9808654785156],[437.26373291015625,309.07550048828125],[436.88983154296875,309.17010498046875],[436.51593017578125,309.26470947265625],[436.14202880859375,309.3593444824219],[435.76812744140625,309.4539489746094],[435.39422607421875,309.5485534667969],[435.02032470703125,309.6431884765625],[434.64642333984375,309.73779296875],[434.27252197265625,309.8323974609375],[433.8986511230469,309.9270324707031],[433.5247497558594,310.0216369628906],[433.1508483886719,310.11627197265625],[432.7769470214844,310.21087646484375],[432.4030456542969,310.30548095703125],[432.0291442871094,310.4001159667969],[431.6552429199219,310.4947204589844],[431.2813415527344,310.58935546875],[430.907470703125,310.6839599609375],[430.5335693359375,310.778564453125],[430.15966796875,310.8731994628906],[429.7857666015625,310.9678039550781],[429.411865234375,311.0624084472656],[429.0379638671875,311.15704345703125],[428.6640625,311.25164794921875],[428.2901611328125,311.3462829589844],[427.916259765625,311.4408874511719],[427.5423583984375,311.5354919433594],[427.16845703125,311.630126953125],[426.7945861816406,311.7247314453125],[426.420654296875,311.8193359375],[426.0467834472656,311.9139709472656],[425.6728820800781,312.0085754394531],[425.2989807128906,312.10321044921875],[424.9250793457031,312.19781494140625],[424.5511779785156,312.29241943359375],[424.1772766113281,312.3870544433594],[423.80340576171875,312.4816589355469],[423.42950439453125,312.5762634277344],[423.05560302734375,312.6708984375],[422.68170166015625,312.7655029296875],[422.30780029296875,312.8601379394531],[421.93389892578125,312.9547424316406],[421.55999755859375,313.0493469238281],[421.18609619140625,313.14398193359375],[420.81219482421875,313.23858642578125],[420.43829345703125,313.33319091796875],[420.06439208984375,313.4278259277344],[419.69049072265625,313.5224304199219],[419.31658935546875,313.6170654296875],[418.9427185058594,313.711669921875],[418.5688171386719,313.8062744140625],[418.1949157714844,313.9009094238281],[417.8210144042969,313.9955139160156],[417.4471130371094,314.0901184082031],[417.0732116699219,314.18475341796875],[416.6993103027344,314.27935791015625],[416.325439453125,314.37396240234375],[415.9515380859375,314.4685974121094],[415.57763671875,314.5632019042969],[415.2037353515625,314.6578369140625],[414.829833984375,314.75244140625],[414.4559326171875,314.8470458984375],[414.08203125,314.9416809082031],[413.7081298828125,315.0362854003906],[413.334228515625,315.13092041015625],[412.9603271484375,315.22552490234375],[412.58642578125,315.32012939453125],[412.2125549316406,315.4147644042969],[411.8386535644531,315.5093688964844],[411.4647521972656,315.6039733886719],[411.0908508300781,315.6986083984375],[410.7169494628906,315.793212890625],[410.3430480957031,315.8878173828125],[409.9691467285156,315.9824523925781],[409.5952453613281,316.0770568847656],[409.22137451171875,316.17169189453125],[408.8474426269531,316.26629638671875],[408.47357177734375,316.36090087890625],[408.09967041015625,316.4555358886719],[407.72576904296875,316.5501403808594],[407.35186767578125,316.644775390625],[406.97796630859375,316.7393798828125],[406.60406494140625,316.833984375],[406.23016357421875,316.9286193847656],[405.85626220703125,317.0232238769531],[405.48236083984375,317.1178283691406],[405.1084899902344,317.21246337890625],[404.73455810546875,317.30706787109375],[404.3606872558594,317.40167236328125],[403.9867858886719,317.4963073730469],[403.6128845214844,317.5909118652344],[403.2389831542969,317.685546875],[402.8650817871094,317.7801513671875],[402.4911804199219,317.874755859375],[402.1172790527344,317.9693908691406],[401.7433776855469,318.0639953613281],[401.3695068359375,318.15863037109375],[400.99560546875,318.25323486328125],[400.6217041015625,318.34783935546875],[400.247802734375,318.4424743652344],[399.8739013671875,318.5370788574219],[399.5,318.6316833496094],[399.1260986328125,318.726318359375],[398.752197265625,318.8209228515625],[398.3782958984375,318.91552734375],[398.00439453125,319.0101623535156],[397.6305236816406,319.1047668457031],[397.2566223144531,319.19940185546875],[396.8827209472656,319.29400634765625],[396.5088195800781,319.38861083984375],[396.1349182128906,319.4832458496094],[395.7610168457031,319.5778503417969],[395.3871154785156,319.6724853515625],[395.0132141113281,319.76708984375],[394.63934326171875,319.8616943359375],[394.2654113769531,319.9563293457031],[393.89154052734375,320.0509338378906],[393.51763916015625,320.1455383300781],[393.14373779296875,320.24017333984375],[392.76983642578125,320.33477783203125],[392.39593505859375,320.42938232421875],[392.02203369140625,320.5240173339844],[391.64813232421875,320.6186218261719],[391.27423095703125,320.7132568359375],[390.90032958984375,320.807861328125],[390.5264587402344,320.9024658203125],[390.15252685546875,320.9971008300781],[389.7786560058594,321.0917053222656],[389.4047546386719,321.1863098144531],[389.0308532714844,321.28094482421875],[388.6569519042969,321.37554931640625],[388.2830505371094,321.4701843261719],[387.9091491699219,321.5647888183594],[387.5352478027344,321.6593933105469],[387.1613464355469,321.7540283203125],[386.7874755859375,321.8486328125],[386.41357421875,321.9432373046875],[386.0396728515625,322.0378723144531],[385.665771484375,322.1324768066406],[385.2918701171875,322.22711181640625],[384.91796875,322.32171630859375],[384.5440673828125,322.41632080078125],[384.170166015625,322.5109558105469],[383.7962646484375,322.6055603027344],[383.42236328125,322.7001647949219],[383.0484924316406,322.7947998046875],[382.6745910644531,322.889404296875],[382.3006896972656,322.9840393066406],[381.9267883300781,323.0786437988281],[381.5528869628906,323.1732482910156],[381.1789855957031,323.26788330078125],[380.8050842285156,323.36248779296875],[380.4311828613281,323.4571228027344],[380.0572814941406,323.5517272949219],[379.6833801269531,323.6463317871094],[379.30950927734375,323.740966796875],[378.93560791015625,323.8355712890625],[378.56170654296875,323.93017578125],[378.18780517578125,324.0248107910156],[377.81390380859375,324.1194152832031],[377.44000244140625,324.2140197753906],[377.06610107421875,324.30865478515625],[376.69219970703125,324.40325927734375],[376.31829833984375,324.4978942871094],[375.94439697265625,324.5924987792969],[375.57049560546875,324.6871032714844],[375.1966247558594,324.78173828125],[374.8227233886719,324.8763427734375],[374.4488220214844,324.970947265625],[374.0749206542969,325.0655822753906],[373.7010192871094,325.1601867675781],[373.3271179199219,325.25482177734375],[372.9532165527344,325.34942626953125],[372.579345703125,325.44403076171875],[372.2054138183594,325.5386657714844],[371.8315124511719,325.6332702636719],[371.4576416015625,325.7278747558594],[371.083740234375,325.822509765625],[370.7098388671875,325.9171142578125],[370.3359375,326.0117492675781],[369.9620361328125,326.1063537597656],[369.588134765625,326.2009582519531],[369.2142333984375,326.29559326171875],[368.84033203125,326.39019775390625],[368.4664611816406,326.48480224609375],[368.092529296875,326.5794372558594],[367.7186584472656,326.6740417480469],[367.3447570800781,326.7686767578125],[366.9708557128906,326.86328125],[366.5969543457031,326.9578857421875],[366.2230529785156,327.0525207519531],[365.8491516113281,327.1471252441406],[365.4752502441406,327.2417297363281],[365.1013488769531,327.33636474609375],[364.72747802734375,327.43096923828125],[364.35357666015625,327.5256042480469],[363.97967529296875,327.6202087402344],[363.60577392578125,327.7148132324219],[363.23187255859375,327.8094482421875],[362.85797119140625,327.904052734375],[362.48406982421875,327.9986572265625],[362.11016845703125,328.0932922363281],[361.73626708984375,328.1878967285156],[361.36236572265625,328.28253173828125],[360.9884948730469,328.37713623046875],[360.6145935058594,328.47174072265625],[360.2406921386719,328.5663757324219],[359.8667907714844,328.6609802246094],[359.4928894042969,328.7555847167969],[359.1189880371094,328.8502197265625],[358.7450866699219,328.94482421875],[358.3711853027344,329.0394592285156],[357.997314453125,329.1340637207031],[357.6233825683594,329.2286682128906],[357.2494812011719,329.32330322265625],[356.8756103515625,329.41790771484375],[356.501708984375,329.51251220703125],[356.1278076171875,329.6071472167969],[355.75390625,329.7017517089844],[355.3800048828125,329.79638671875],[355.006103515625,329.8909912109375],[354.6322021484375,329.985595703125],[354.25830078125,330.0802307128906],[353.8844299316406,330.1748352050781],[353.510498046875,330.2694396972656],[353.1366271972656,330.36407470703125],[352.7627258300781,330.45867919921875],[352.3888244628906,330.5533142089844],[352.0149230957031,330.6479187011719],[351.6410217285156,330.7425231933594],[351.2671203613281,330.837158203125],[350.8932189941406,330.9317626953125],[350.5193176269531,331.0263671875],[350.14544677734375,331.1210021972656],[349.77154541015625,331.2156066894531],[349.39764404296875,331.31024169921875],[349.0234375,331.40362548828125],[348.64910888671875,331.4964904785156],[348.2747802734375,331.58935546875],[347.90045166015625,331.68218994140625],[347.5260925292969,331.7750549316406],[347.1517333984375,331.867919921875],[346.77740478515625,331.9607849121094],[346.403076171875,332.05364990234375],[346.02874755859375,332.146484375],[345.6544189453125,332.2393493652344],[345.2800598144531,332.33221435546875],[344.90570068359375,332.4250793457031],[344.5313720703125,332.5179138183594],[344.15704345703125,332.61077880859375],[343.78271484375,332.7036437988281],[343.40838623046875,332.7965087890625],[343.0340270996094,332.88934326171875],[342.6596984863281,332.9822082519531],[342.28533935546875,333.0750732421875],[341.9110107421875,333.1679382324219],[341.53668212890625,333.26080322265625],[341.1623229980469,333.3536376953125],[340.7879943847656,333.4465026855469],[340.4136657714844,333.53936767578125],[340.039306640625,333.6322326660156],[339.66497802734375,333.7250671386719],[339.2906494140625,333.81793212890625],[338.9162902832031,333.9107971191406],[338.5419616699219,334.003662109375],[338.1676330566406,334.09649658203125],[337.79327392578125,334.1893615722656],[337.4189453125,334.2822265625],[337.04461669921875,334.3750915527344],[336.6702575683594,334.46795654296875],[336.2959289550781,334.560791015625],[335.9216003417969,334.6536560058594],[335.5472412109375,334.74652099609375],[335.17291259765625,334.8393859863281],[334.798583984375,334.9322509765625],[334.4242248535156,335.02508544921875],[334.0498962402344,335.1179504394531],[333.6755676269531,335.2108154296875],[333.3012390136719,335.3036804199219],[332.9268798828125,335.3965148925781],[332.55255126953125,335.4893798828125],[332.17822265625,335.5822448730469],[331.8038635253906,335.67510986328125],[331.4295349121094,335.7679443359375],[331.0552062988281,335.8608093261719],[330.68084716796875,335.95367431640625],[330.3065185546875,336.0465393066406],[329.93218994140625,336.139404296875],[329.5578308105469,336.23223876953125],[329.1835021972656,336.3251037597656],[328.80914306640625,336.41796875],[328.434814453125,336.5108337402344],[328.06048583984375,336.6036682128906],[327.6861572265625,336.696533203125],[327.3117980957031,336.7893981933594],[326.9374694824219,336.88226318359375],[326.5631103515625,336.9751281738281],[326.18878173828125,337.0679626464844],[325.814453125,337.16082763671875],[325.44012451171875,337.2536926269531],[325.0657653808594,337.3465576171875],[324.6914367675781,337.43939208984375],[324.31707763671875,337.5322570800781],[323.9427490234375,337.6251220703125],[323.56842041015625,337.7179870605469],[323.194091796875,337.81085205078125],[322.81976318359375,337.9036865234375],[322.4454040527344,337.9965515136719],[322.071044921875,338.08941650390625],[321.69671630859375,338.1822814941406],[321.3223876953125,338.2751159667969],[320.94805908203125,338.36798095703125],[320.57373046875,338.4608459472656],[320.1993713378906,338.5537109375],[319.82501220703125,338.64654541015625],[319.45068359375,338.7394104003906],[319.07635498046875,338.832275390625],[318.7020263671875,338.9251403808594],[318.3276672363281,339.01800537109375],[317.9533386230469,339.11083984375],[317.5789794921875,339.2037048339844],[317.20465087890625,339.29656982421875],[316.830322265625,339.3894348144531],[316.45599365234375,339.4822692871094],[316.0816345214844,339.57513427734375],[315.7073059082031,339.6679992675781],[315.33294677734375,339.7608642578125],[314.9586181640625,339.85369873046875],[314.58428955078125,339.9465637207031],[314.2099609375,340.0394287109375],[313.8356018066406,340.1322937011719],[313.4612731933594,340.22515869140625],[313.0869445800781,340.3179931640625],[312.71258544921875,340.4108581542969],[312.3382568359375,340.50372314453125],[311.96392822265625,340.5965881347656],[311.5895690917969,340.689453125],[311.2152404785156,340.78228759765625],[310.8409118652344,340.8751525878906],[310.466552734375,340.968017578125],[310.09222412109375,341.0608825683594],[309.7178955078125,341.1537170410156],[309.3435363769531,341.24658203125],[308.9692077636719,341.3394470214844],[308.5948791503906,341.43231201171875],[308.22052001953125,341.525146484375],[307.84619140625,341.6180114746094],[307.47186279296875,341.71087646484375],[307.0975036621094,341.8037414550781],[306.7231750488281,341.8966064453125],[306.3488464355469,341.98944091796875],[305.9744873046875,342.0823059082031],[305.60015869140625,342.1751708984375],[305.225830078125,342.2680358886719],[304.8514709472656,342.3608703613281],[304.4771423339844,342.4537353515625],[304.1028137207031,342.5466003417969],[303.72845458984375,342.63946533203125],[303.3541259765625,342.7323303222656],[302.97979736328125,342.8251647949219],[302.60546875,342.91802978515625],[302.2311096191406,343.0108947753906],[301.85675048828125,343.103759765625],[301.482421875,343.19659423828125],[301.10809326171875,343.2894592285156],[300.7337646484375,343.38232421875],[300.35943603515625,343.4751892089844],[299.9850769042969,343.56805419921875],[299.6107177734375,343.660888671875],[299.23638916015625,343.7537536621094],[298.862060546875,343.84661865234375],[298.48773193359375,343.9394836425781],[298.1134033203125,344.0323181152344],[297.7390441894531,344.12518310546875],[297.3647155761719,344.2180480957031],[296.9903564453125,344.3109130859375],[296.61602783203125,344.40374755859375],[296.24169921875,344.4966125488281],[295.86737060546875,344.5894775390625],[295.4930114746094,344.6823425292969],[295.1186828613281,344.77520751953125],[294.74432373046875,344.8680419921875],[294.3699951171875,344.9609069824219],[293.99566650390625,345.05377197265625],[293.6213073730469,345.1466369628906],[293.2469787597656,345.239501953125],[292.8726501464844,345.33233642578125],[292.498291015625,345.4252014160156],[292.12396240234375,345.51806640625],[291.7496337890625,345.6109313964844],[291.3752746582031,345.7037658691406],[291.0009460449219,345.796630859375],[290.6266174316406,345.8894958496094],[290.25225830078125,345.98236083984375],[289.8779296875,346.0751953125],[289.50360107421875,346.1680603027344],[289.1292419433594,346.26092529296875],[288.7549133300781,346.3537902832031],[288.3805847167969,346.4466552734375],[288.0062561035156,346.53948974609375],[287.63189697265625,346.6323547363281],[287.257568359375,346.7252197265625],[286.8832092285156,346.8180847167969],[286.5088806152344,346.9109191894531],[286.1345520019531,347.0037841796875],[285.7602233886719,347.0966491699219],[285.3858642578125,347.18951416015625],[285.01153564453125,347.2823791503906],[284.63720703125,347.3752136230469],[284.2628479003906,347.46807861328125],[283.8885192871094,347.5609436035156],[283.5141906738281,347.65380859375],[283.13983154296875,347.74664306640625],[282.7655029296875,347.8395080566406],[282.39117431640625,347.932373046875],[282.0168151855469,348.0252380371094],[281.6424865722656,348.1180725097656],[281.2681579589844,348.2109375],[280.893798828125,348.3038024902344],[280.51947021484375,348.39666748046875],[280.1451416015625,348.4895324707031],[279.7707824707031,348.5823669433594],[279.3964538574219,348.67523193359375],[279.0220947265625,348.7680969238281],[278.64776611328125,348.8609619140625],[278.2734375,348.95379638671875],[277.89910888671875,349.0466613769531],[277.5247497558594,349.1395263671875],[277.1504211425781,349.2323913574219],[276.77606201171875,349.32525634765625],[276.4017333984375,349.4180908203125],[276.02740478515625,349.5109558105469],[275.653076171875,349.60382080078125],[275.27874755859375,349.6966857910156],[274.9043884277344,349.78955078125],[274.530029296875,349.88238525390625],[274.15570068359375,349.9752502441406],[273.7813720703125,350.068115234375],[273.40704345703125,350.1609802246094],[273.03271484375,350.2538146972656],[272.6583557128906,350.3466796875],[272.2840270996094,350.4395446777344],[271.90966796875,350.53240966796875],[271.53533935546875,350.625244140625],[271.1610107421875,350.7181091308594],[270.7866516113281,350.81097412109375],[270.4123229980469,350.9038391113281],[270.0379943847656,350.9967041015625],[269.66363525390625,351.08953857421875],[269.289306640625,351.1824035644531],[268.91497802734375,351.2752685546875],[268.5406188964844,351.3681335449219],[268.1662902832031,351.4609680175781],[267.7919616699219,351.5538330078125],[267.4176025390625,351.6466979980469],[267.04327392578125,351.73956298828125],[266.6689147949219,351.8324279785156],[266.2945861816406,351.9252624511719],[265.9202575683594,352.01812744140625],[265.5459289550781,352.1109924316406],[265.17156982421875,352.203857421875],[264.7972412109375,352.29669189453125],[264.42291259765625,352.3895568847656],[264.0485534667969,352.482421875],[263.6742248535156,352.5752868652344],[263.2998962402344,352.6681213378906],[262.9255676269531,352.760986328125],[262.55120849609375,352.8538513183594],[262.1768798828125,352.94671630859375],[261.8025207519531,353.0395812988281],[261.4281921386719,353.1324157714844],[261.0538635253906,353.22528076171875],[260.6795349121094,353.3181457519531],[260.30517578125,353.4110107421875],[259.93084716796875,353.50384521484375],[259.5565185546875,353.5967102050781],[259.1821594238281,353.6895751953125],[258.80780029296875,353.7824401855469],[258.4334716796875,353.87530517578125],[258.05914306640625,353.9681396484375],[257.684814453125,354.0610046386719],[257.3104553222656,354.15386962890625],[256.9361267089844,354.2467346191406],[256.5617980957031,354.3395690917969],[256.1874694824219,354.43243408203125],[255.81312561035156,354.5252990722656],[255.43878173828125,354.6181640625],[255.06442260742188,354.7110290527344],[254.69009399414062,354.8038635253906],[254.3157501220703,354.896728515625],[253.94142150878906,354.9895935058594],[253.56707763671875,355.08245849609375],[253.1927490234375,355.17529296875],[252.8184051513672,355.2681579589844],[252.44407653808594,355.36102294921875],[252.06973266601562,355.4538879394531],[251.69540405273438,355.5467224121094],[251.32106018066406,355.63958740234375],[250.9467010498047,355.7324523925781],[250.57235717773438,355.8253173828125],[250.19802856445312,355.9181823730469],[249.8236846923828,356.0110168457031],[249.44935607910156,356.1038818359375],[249.07501220703125,356.1967468261719],[248.70068359375,356.28961181640625],[248.3263397216797,356.3824462890625],[247.95201110839844,356.4753112792969],[247.57766723632812,356.56817626953125],[247.20333862304688,356.6610412597656],[246.82896423339844,356.75390625],[246.4546356201172,356.84674072265625],[246.08029174804688,356.9396057128906],[245.70596313476562,357.032470703125],[245.33163452148438,357.1253356933594],[244.95729064941406,357.2181701660156],[244.5829620361328,357.31103515625],[244.2086181640625,357.4039001464844],[243.83428955078125,357.49676513671875],[243.45994567871094,357.589599609375],[243.0856170654297,357.6824645996094],[242.71124267578125,357.77532958984375],[242.336669921875,357.86724853515625],[241.9600830078125,357.95037841796875],[241.58412170410156,358.0364074707031],[241.20870971679688,358.124755859375],[240.8336181640625,358.21466064453125],[240.45883178710938,358.30560302734375],[240.08404541015625,358.39666748046875],[239.70921325683594,358.487548828125],[239.334228515625,358.5776672363281],[238.95892333984375,358.6664733886719],[238.58314514160156,358.75341796875],[238.20692443847656,358.83831787109375],[237.82997131347656,358.9199523925781],[237.45230102539062,358.99810791015625],[237.07379150390625,359.0721740722656],[236.69442749023438,359.14154052734375],[236.3140869140625,359.2054748535156],[235.9327850341797,359.26336669921875],[235.55050659179688,359.31463623046875],[235.16737365722656,359.3587646484375],[234.78335571289062,359.39447021484375],[234.39859008789062,359.4212341308594],[234.0133056640625,359.43829345703125],[233.627685546875,359.4445495605469],[233.2420654296875,359.43927001953125],[232.8568115234375,359.42144775390625],[232.47242736816406,359.3903503417969],[232.08944702148438,359.34490966796875],[231.70858764648438,359.284423828125],[231.33059692382812,359.20794677734375],[230.95635986328125,359.1148376464844],[230.58682250976562,359.0045471191406],[230.22296142578125,358.8767395019531],[229.86581420898438,358.73126220703125],[229.5272674560547,358.55682373046875],[229.34152221679688,358.21881103515625],[229.15576171875,357.8808288574219],[228.9700164794922,357.5428161621094],[228.78427124023438,357.2048034667969],[228.5985870361328,356.86676025390625],[228.41310119628906,356.5285949707031],[228.2276153564453,356.1904602050781],[228.04212951660156,355.852294921875],[227.85662841796875,355.5141296386719],[227.671142578125,355.1759948730469],[227.48565673828125,354.83782958984375],[227.3001708984375,354.49969482421875],[227.11468505859375,354.1615295410156],[226.92919921875,353.8233947753906],[226.7437286376953,353.4852294921875],[226.55824279785156,353.1470947265625],[226.37294006347656,352.808837890625],[226.1879119873047,352.4704284667969],[226.0028839111328,352.1320495605469],[225.81784057617188,351.7936096191406],[225.63282775878906,351.4552001953125],[225.4477996826172,351.1168212890625],[225.2627716064453,350.7784118652344],[225.07774353027344,350.44000244140625],[224.89271545410156,350.1015930175781],[224.7076873779297,349.7632141113281],[224.52267456054688,349.4248046875],[224.337646484375,349.0863952636719],[224.15261840820312,348.74798583984375],[223.96759033203125,348.40960693359375],[223.7825469970703,348.0711669921875],[223.59768676757812,347.7326965332031],[223.41322326660156,347.39398193359375],[223.22877502441406,347.0552673339844],[223.04432678222656,346.716552734375],[222.85987854003906,346.3778381347656],[222.6754150390625,346.03912353515625],[222.490966796875,345.7004089355469],[222.3065185546875,345.3616943359375],[222.1224822998047,345.02276611328125],[221.93865966796875,344.6836853027344],[221.7548370361328,344.3446044921875],[221.57102966308594,344.00555419921875],[221.38722229003906,343.6664733886719],[221.20339965820312,343.3274230957031],[221.01959228515625,342.9883728027344],[220.82521057128906,342.6553649902344],[220.62245178222656,342.3273010253906],[220.4181671142578,342.0001525878906],[220.2127227783203,341.67376708984375],[220.00640869140625,341.347900390625],[219.79896545410156,341.02276611328125],[219.5907745361328,340.69805908203125],[219.3820037841797,340.3737487792969],[219.1723175048828,340.0500793457031],[218.9622039794922,339.7266540527344],[218.75132751464844,339.40374755859375],[218.53988647460938,339.0811767578125],[218.32814025878906,338.7588195800781],[218.11537170410156,338.4371337890625],[217.90261840820312,338.1154479980469],[217.6890106201172,337.7943420410156],[217.47491455078125,337.4735107421875],[217.26083374023438,337.1527099609375],[217.04568481445312,336.83258056640625],[216.8302764892578,336.5126647949219],[216.6148681640625,336.1927490234375],[216.39852905273438,335.8734436035156],[216.1818084716797,335.5544128417969],[215.965087890625,335.2353820800781],[215.7478790283203,334.91668701171875],[215.5298309326172,334.59857177734375],[215.31179809570312,334.2804260253906],[215.09375,333.9623107910156],[214.87493896484375,333.6446838378906],[214.65589904785156,333.32720947265625],[214.43629455566406,333.0101623535156],[214.21661376953125,332.69317626953125],[213.99630737304688,332.3765869140625],[213.77597045898438,332.0600280761719],[213.55503845214844,331.7439270019531],[213.3340606689453,331.4278259277344],[213.11248779296875,331.11212158203125],[212.89083862304688,330.7965087890625],[212.668701171875,330.481201171875],[212.4464111328125,330.166015625],[212.22373962402344,329.8511047363281],[212.00079345703125,329.536376953125],[211.77764892578125,329.2218017578125],[211.55406188964844,328.9075622558594],[211.33047485351562,328.5932922363281],[211.10623168945312,328.2795104980469],[210.88197326660156,327.9657287597656],[210.65733337402344,327.6522216796875],[210.4324493408203,327.3388977050781],[210.2074432373047,327.025634765625],[209.98190307617188,326.7127685546875],[209.75634765625,326.39990234375],[209.53036499023438,326.08734130859375],[209.30418395996094,325.77496337890625],[209.0779266357422,325.4626159667969],[208.85108947753906,325.15069580078125],[208.624267578125,324.8387756347656],[208.3970947265625,324.5270690917969],[208.1696014404297,324.2156066894531],[207.94212341308594,323.9041748046875],[207.714111328125,323.5931091308594],[207.48599243164062,323.2821044921875],[207.2578125,322.97113037109375],[207.02903747558594,322.66064453125],[206.80027770996094,322.3501281738281],[206.5713348388672,322.03973388671875],[206.34193420410156,321.7297058105469],[206.11251831054688,321.419677734375],[205.8828582763672,321.1098327636719],[205.65280151367188,320.80029296875],[205.42276000976562,320.49072265625],[205.19239807128906,320.1813659667969],[204.9617156982422,319.8722839355469],[204.7310028076172,319.5632019042969],[204.50003051757812,319.2543640136719],[204.26869201660156,318.94573974609375],[204.037353515625,318.63714599609375],[203.8057403564453,318.3287353515625],[203.57376098632812,318.0205993652344],[203.34178161621094,317.7124938964844],[203.10963439941406,317.404541015625],[202.8770294189453,317.0968933105469],[202.64442443847656,316.78924560546875],[202.41172790527344,316.4816589355469],[202.178466796875,316.1744689941406],[201.94520568847656,315.8673095703125],[201.7119598388672,315.5601501464844],[201.47816467285156,315.25341796875],[201.24427795410156,314.9467468261719],[201.01040649414062,314.64007568359375],[200.77615356445312,314.33367919921875],[200.5416259765625,314.0274963378906],[200.30711364746094,313.7212829589844],[200.07247924804688,313.41522216796875],[199.83731079101562,313.1095275878906],[199.60214233398438,312.8038024902344],[199.3669891357422,312.49810791015625],[199.13133239746094,312.19281005859375],[198.89553833007812,311.8875732421875],[198.65975952148438,311.5823669433594],[198.4237823486328,311.2773132324219],[198.18736267089844,310.97259521484375],[197.95094299316406,310.6678466796875],[197.7145233154297,310.3631286621094],[197.4776153564453,310.0588073730469],[197.24057006835938,309.7545471191406],[197.0034942626953,309.4503173828125],[196.766357421875,309.1461486816406],[196.5286865234375,308.8424072265625],[196.291015625,308.5386657714844],[196.05332946777344,308.23492431640625],[195.8153533935547,307.9314270019531],[195.57704162597656,307.628173828125],[195.33872985839844,307.3249206542969],[195.1004180908203,307.0216979980469],[194.8616485595703,306.71881103515625],[194.62271118164062,306.4160461425781],[194.38377380371094,306.11328125],[194.14483642578125,305.8105163574219],[193.90528869628906,305.5082092285156],[193.6657257080078,305.2059631347656],[193.42616271972656,304.9036865234375],[193.18653869628906,304.60150146484375],[192.94635009765625,304.29974365234375],[192.70616149902344,303.9979553222656],[192.46597290039062,303.6961975097656],[192.2288360595703,303.39215087890625],[192.0052490234375,303.077880859375],[191.78163146972656,302.76361083984375],[191.55804443359375,302.4493408203125],[191.33445739746094,302.1351013183594],[191.11087036132812,301.8208312988281],[190.8872833251953,301.506591796875],[190.6636962890625,301.19232177734375],[190.44009399414062,300.8780517578125],[190.2165069580078,300.5638122558594],[189.992919921875,300.2495422363281],[189.7693328857422,299.935302734375],[189.54574584960938,299.62103271484375],[189.3221435546875,299.3067626953125],[189.09854125976562,298.99249267578125],[188.8749542236328,298.67822265625],[188.6513671875,298.3639831542969],[188.4277801513672,298.0497131347656],[188.20419311523438,297.7354736328125],[187.98060607910156,297.42120361328125],[187.75701904296875,297.1069641113281],[187.53341674804688,296.7926940917969],[187.30982971191406,296.4784240722656],[187.08624267578125,296.1641845703125],[186.86264038085938,295.8498840332031],[186.63905334472656,295.53564453125],[186.41546630859375,295.22137451171875],[186.19186401367188,294.9071350097656],[185.96827697753906,294.5928649902344],[185.74468994140625,294.2785949707031],[185.52110290527344,293.96435546875],[185.29751586914062,293.65008544921875],[185.0739288330078,293.3358459472656],[184.850341796875,293.0215759277344],[184.62673950195312,292.70733642578125],[184.40313720703125,292.3930358886719],[184.17955017089844,292.07879638671875],[183.95596313476562,291.7645263671875],[183.7323760986328,291.45025634765625],[183.50877380371094,291.1360168457031],[183.28518676757812,290.8217468261719],[183.0615997314453,290.50750732421875],[182.8380126953125,290.1932373046875],[182.6144256591797,289.87896728515625],[182.39083862304688,289.5647277832031],[182.167236328125,289.2504577636719],[181.94363403320312,288.9361877441406],[181.7200469970703,288.6219177246094],[181.4964599609375,288.30767822265625],[181.2728729248047,287.993408203125],[181.04928588867188,287.67913818359375],[180.82568359375,287.3648986816406],[180.6020965576172,287.0506286621094],[180.37850952148438,286.73638916015625],[180.15492248535156,286.422119140625],[179.93133544921875,286.10784912109375],[179.70774841308594,285.7936096191406],[179.484130859375,285.47930908203125],[179.2605438232422,285.1650695800781],[179.03695678710938,284.8507995605469],[178.81336975097656,284.53656005859375],[178.58978271484375,284.2222900390625],[178.36619567871094,283.9080505371094],[178.14260864257812,283.5937805175781],[177.91900634765625,283.2795104980469],[177.69541931152344,282.96527099609375],[177.47183227539062,282.6510009765625],[177.2482452392578,282.3367614746094],[177.024658203125,282.0224914550781],[176.80104064941406,281.7082214355469],[176.57745361328125,281.3939514160156],[176.35386657714844,281.0796813964844],[176.13027954101562,280.76544189453125],[175.9066925048828,280.451171875],[175.68310546875,280.1369323730469],[175.4595184326172,279.8226623535156],[175.2359161376953,279.5083923339844],[175.0123291015625,279.19415283203125],[174.7887420654297,278.8798828125],[174.56515502929688,278.5656433105469],[174.341552734375,278.2513427734375],[174.11795043945312,277.9371032714844],[173.8943634033203,277.6228332519531],[173.6707763671875,277.30859375],[173.4471893310547,276.99432373046875],[173.22360229492188,276.6800537109375],[173.00001525878906,276.3658142089844],[172.77642822265625,276.0515441894531],[172.55282592773438,275.7373046875],[172.32923889160156,275.42303466796875],[172.10565185546875,275.1087646484375],[171.88204956054688,274.79449462890625],[171.65846252441406,274.480224609375],[171.43487548828125,274.1659851074219],[171.21127319335938,273.8517150878906],[170.98768615722656,273.5374755859375],[170.76409912109375,273.22320556640625],[170.54051208496094,272.908935546875],[170.31692504882812,272.5946960449219],[170.0933380126953,272.2804260253906],[169.8697509765625,271.9661865234375],[169.64614868164062,271.65191650390625],[169.42254638671875,271.337646484375],[169.24679565429688,270.99462890625],[169.0738525390625,270.6498718261719],[168.90093994140625,270.30511474609375],[168.72799682617188,269.96038818359375],[168.55508422851562,269.61566162109375],[168.38214111328125,269.27093505859375],[168.209228515625,268.9261779785156],[168.03628540039062,268.5814208984375],[167.86337280273438,268.2366943359375],[167.6904296875,267.8919677734375],[167.51748657226562,267.54718017578125],[167.3445587158203,267.20245361328125],[167.171630859375,266.85772705078125],[166.9987030029297,266.5129699707031],[166.82577514648438,266.168212890625],[166.65284729003906,265.823486328125],[166.47991943359375,265.478759765625],[166.30699157714844,265.134033203125],[166.13406372070312,264.7892761230469],[165.9611358642578,264.44451904296875],[165.7882080078125,264.09979248046875],[165.61526489257812,263.7550048828125],[165.44232177734375,263.4102783203125],[165.2694091796875,263.0655517578125],[165.09646606445312,262.7208251953125],[164.92355346679688,262.3760681152344],[164.7506103515625,262.03131103515625],[164.57769775390625,261.68658447265625],[164.40475463867188,261.34185791015625],[164.23184204101562,260.9971008300781],[164.05889892578125,260.65234375],[163.88597106933594,260.3076171875],[163.71304321289062,259.9628601074219],[163.54010009765625,259.61810302734375],[163.36717224121094,259.27337646484375],[163.19424438476562,258.92864990234375],[163.0213165283203,258.5838928222656],[162.848388671875,258.2391357421875],[162.6754608154297,257.8944091796875],[162.50253295898438,257.5496826171875],[162.32960510253906,257.2049560546875],[162.15667724609375,256.8601989746094],[161.98373413085938,256.51544189453125],[161.81080627441406,256.1706848144531],[161.63787841796875,255.82595825195312],[161.46493530273438,255.48121643066406],[161.29202270507812,255.136474609375],[161.11907958984375,254.79173278808594],[160.9461669921875,254.44699096679688],[160.77322387695312,254.1022491455078],[160.60031127929688,253.75750732421875],[160.4273681640625,253.4127655029297],[160.25445556640625,253.0680389404297],[160.08151245117188,252.72329711914062],[159.9085693359375,252.37852478027344],[159.7356414794922,252.03378295898438],[159.56271362304688,251.6890411376953],[159.38978576660156,251.34429931640625],[159.21685791015625,250.9995574951172],[159.04393005371094,250.6548309326172],[158.87100219726562,250.31008911132812],[158.6980743408203,249.96534729003906],[158.525146484375,249.62060546875],[158.3522186279297,249.27586364746094],[158.17929077148438,248.93112182617188],[158.00634765625,248.58636474609375],[157.83340454101562,248.2416229248047],[157.66049194335938,247.89688110351562],[157.487548828125,247.55213928222656],[157.31463623046875,247.2073974609375],[157.14169311523438,246.86265563964844],[156.96878051757812,246.51791381835938],[156.79583740234375,246.1731719970703],[156.6229248046875,245.8284454345703],[156.44998168945312,245.48370361328125],[156.2770538330078,245.1389617919922],[156.1041259765625,244.794189453125],[155.93118286132812,244.44944763183594],[155.7582550048828,244.10470581054688],[155.5853271484375,243.75997924804688],[155.4123992919922,243.41522216796875],[155.23947143554688,243.07049560546875],[155.06654357910156,242.7257537841797],[154.89361572265625,242.38101196289062],[154.72068786621094,242.03627014160156],[154.54776000976562,241.6915283203125],[154.3748321533203,241.3468017578125],[154.20188903808594,241.00201416015625],[154.02896118164062,240.65728759765625],[153.8560333251953,240.3125457763672],[153.68310546875,239.96780395507812],[153.51016235351562,239.62306213378906],[153.33724975585938,239.2783203125],[153.164306640625,238.93359375],[152.99139404296875,238.58883666992188],[152.81845092773438,238.24411010742188],[152.64552307128906,237.8993682861328],[152.47259521484375,237.55462646484375],[152.29965209960938,237.20985412597656],[152.12672424316406,236.8651123046875],[151.95379638671875,236.5203857421875],[151.78086853027344,236.17562866210938],[151.60794067382812,235.83090209960938],[151.4350128173828,235.4861602783203],[151.2620849609375,235.14141845703125],[151.0891571044922,234.7966766357422],[150.91622924804688,234.45193481445312],[150.74330139160156,234.10720825195312],[150.57037353515625,233.762451171875],[150.39743041992188,233.41769409179688],[150.22450256347656,233.0729522705078],[150.05157470703125,232.72821044921875],[149.87863159179688,232.3834686279297],[149.70571899414062,232.03872680664062],[149.53277587890625,231.69400024414062],[149.35986328125,231.3492431640625],[149.18692016601562,231.0045166015625],[149.0139923095703,230.65977478027344],[148.841064453125,230.31503295898438],[148.6681365966797,229.9702911376953],[148.4951934814453,229.62551879882812],[148.322265625,229.28079223632812],[148.1493377685547,228.93603515625],[147.97640991210938,228.59130859375],[147.80348205566406,228.24656677246094],[147.63055419921875,227.90182495117188],[147.45762634277344,227.5570831298828],[147.28469848632812,227.21234130859375],[147.1117706298828,226.86761474609375],[146.9388427734375,226.52285766601562],[146.7659149169922,226.17813110351562],[146.5929718017578,225.83335876464844],[146.4200439453125,225.48861694335938],[146.2471160888672,225.1438751220703],[146.07418823242188,224.79913330078125],[145.9012451171875,224.45440673828125],[145.72833251953125,224.10964965820312],[145.55538940429688,223.76492309570312],[145.38247680664062,223.42018127441406],[145.20953369140625,223.075439453125],[145.03660583496094,222.73069763183594],[144.86367797851562,222.38595581054688],[144.6907501220703,222.04122924804688],[144.51780700683594,221.69644165039062],[144.34487915039062,221.35171508789062],[144.1719512939453,221.00697326660156],[143.9990234375,220.6622314453125],[143.8260955810547,220.31748962402344],[143.65316772460938,219.97274780273438],[143.48023986816406,219.62802124023438],[143.30731201171875,219.28326416015625],[143.13438415527344,218.93853759765625],[142.96145629882812,218.5937957763672],[142.7885284423828,218.24905395507812],[142.61558532714844,217.90428161621094],[142.44265747070312,217.55953979492188],[142.26971435546875,217.21481323242188],[142.0968017578125,216.87005615234375],[141.92385864257812,216.52532958984375],[141.75094604492188,216.1805877685547],[141.5780029296875,215.83584594726562],[141.4050750732422,215.49110412597656],[141.23214721679688,215.1463623046875],[141.05921936035156,214.8016357421875],[140.88629150390625,214.45687866210938],[140.71334838867188,214.11212158203125],[140.54042053222656,213.7673797607422],[140.36749267578125,213.42263793945312],[140.19456481933594,213.07789611816406],[140.02163696289062,212.733154296875],[139.8487091064453,212.388427734375],[139.67578125,212.04367065429688],[139.5028533935547,211.69894409179688],[139.32992553710938,211.3542022705078],[139.15699768066406,211.00946044921875],[138.98406982421875,210.6647186279297],[138.81112670898438,210.3199462890625],[138.63819885253906,209.9752197265625],[138.46527099609375,209.63046264648438],[138.29232788085938,209.28573608398438],[138.11941528320312,208.9409942626953],[137.94647216796875,208.59625244140625],[137.7735595703125,208.2515106201172],[137.60061645507812,207.90676879882812],[137.4276885986328,207.56204223632812],[137.2547607421875,207.21728515625],[137.0818328857422,206.87255859375],[136.9088897705078,206.5277862548828],[136.7359619140625,206.18304443359375],[136.5630340576172,205.8383026123047],[136.39010620117188,205.49356079101562],[136.21717834472656,205.14883422851562],[136.04425048828125,204.8040771484375],[135.87132263183594,204.4593505859375],[135.69839477539062,204.11460876464844],[135.5254669189453,203.76986694335938],[135.3525390625,203.4251251220703],[135.1796112060547,203.08038330078125],[135.0066680908203,202.73562622070312],[134.833740234375,202.390869140625],[134.6608123779297,202.046142578125],[134.48788452148438,201.70140075683594],[134.31494140625,201.35665893554688],[134.14202880859375,201.0119171142578],[133.96908569335938,200.66717529296875],[133.79615783691406,200.32244873046875],[133.62322998046875,199.97769165039062],[133.45030212402344,199.63296508789062],[133.27737426757812,199.2882080078125],[133.10443115234375,198.94345092773438],[132.93150329589844,198.5987091064453],[132.75857543945312,198.25396728515625],[132.5856475830078,197.90924072265625],[132.4127197265625,197.56448364257812],[132.2397918701172,197.21975708007812],[132.06686401367188,196.87501525878906],[131.89393615722656,196.5302734375],[131.72100830078125,196.18553161621094],[131.54808044433594,195.84078979492188],[131.37515258789062,195.49606323242188],[131.20220947265625,195.15127563476562],[131.02928161621094,194.80654907226562],[130.85635375976562,194.46180725097656],[130.68341064453125,194.1170654296875],[130.510498046875,193.77232360839844],[130.33755493164062,193.42758178710938],[130.16464233398438,193.08285522460938],[129.99169921875,192.73809814453125],[129.8187713623047,192.39337158203125],[129.64584350585938,192.0486297607422],[129.47291564941406,191.70388793945312],[129.2999725341797,191.35911560058594],[129.12704467773438,191.01437377929688],[128.95411682128906,190.66964721679688],[128.78118896484375,190.32489013671875],[128.60826110839844,189.98016357421875],[128.43533325195312,189.6354217529297],[128.2624053955078,189.29067993164062],[128.0894775390625,188.94593811035156],[127.91654968261719,188.6011962890625],[127.74362182617188,188.2564697265625],[127.57069396972656,187.91171264648438],[127.39775085449219,187.56695556640625],[127.22482299804688,187.2222137451172],[127.05189514160156,186.87747192382812],[126.87895965576172,186.53273010253906],[126.7060317993164,186.18798828125],[126.5331039428711,185.84326171875],[126.36017608642578,185.49850463867188],[126.18724060058594,185.15377807617188],[126.01431274414062,184.8090362548828],[125.84138488769531,184.46429443359375],[125.66845703125,184.1195526123047],[125.49551391601562,183.7747802734375],[125.32258605957031,183.4300537109375],[125.149658203125,183.08529663085938],[124.97673034667969,182.74057006835938],[124.80380249023438,182.3958282470703],[124.63087463378906,182.05108642578125],[124.45794677734375,181.7063446044922],[124.28501892089844,181.36160278320312],[124.11209106445312,181.01686096191406],[123.93916320800781,180.672119140625],[123.7662353515625,180.327392578125],[123.59329223632812,179.9826202392578],[123.42036437988281,179.63787841796875],[123.24742889404297,179.2931365966797],[123.07450103759766,178.94839477539062],[122.90157318115234,178.60366821289062],[122.72864532470703,178.2589111328125],[122.55571746826172,177.9141845703125],[122.3827896118164,177.56944274902344],[122.2098617553711,177.22470092773438],[122.03692626953125,176.8799591064453],[121.86399841308594,176.53521728515625],[121.69105529785156,176.19046020507812],[121.51812744140625,175.84571838378906],[121.34519958496094,175.5009765625],[121.17227172851562,175.15623474121094],[120.99934387207031,174.81149291992188],[120.826416015625,174.4667510986328],[120.65348815917969,174.12200927734375],[120.48056030273438,173.7772674560547],[120.30763244628906,173.43252563476562],[120.13470458984375,173.08779907226562],[119.96177673339844,172.74305725097656],[119.78883361816406,172.39828491210938],[119.61590576171875,172.0535430908203],[119.4429702758789,171.70880126953125],[119.2700424194336,171.36407470703125],[119.09711456298828,171.01931762695312],[118.92418670654297,170.67459106445312],[118.75125885009766,170.32984924316406],[118.57833099365234,169.985107421875],[118.40540313720703,169.64036560058594],[118.23246765136719,169.29562377929688],[118.05953979492188,168.9508819580078],[117.8865966796875,168.6061248779297],[117.71366882324219,168.26138305664062],[117.54074096679688,167.91664123535156],[117.36781311035156,167.5718994140625],[117.19488525390625,167.22715759277344],[117.02195739746094,166.88241577148438],[116.84902954101562,166.53768920898438],[116.67610168457031,166.19293212890625],[116.503173828125,165.84820556640625],[116.33024597167969,165.5034637451172],[116.15731811523438,165.15872192382812],[115.98438262939453,164.81398010253906],[115.81145477294922,164.46923828125],[115.6385269165039,164.12449645996094],[115.4655990600586,163.77975463867188],[115.29267120361328,163.43502807617188],[115.11974334716797,163.0902862548828],[114.94678497314453,162.7454833984375],[114.77385711669922,162.40074157714844],[114.6009292602539,162.05599975585938],[114.4280014038086,161.71127319335938],[114.25507354736328,161.3665313720703],[114.08213806152344,161.02178955078125],[113.90921020507812,160.6770477294922],[113.73628234863281,160.33230590820312],[113.5633544921875,159.98756408691406],[113.39042663574219,159.642822265625],[113.21749877929688,159.298095703125],[113.04457092285156,158.95333862304688],[112.87164306640625,158.60861206054688],[112.69871520996094,158.2638702392578],[112.52578735351562,157.91912841796875],[112.35285949707031,157.5743865966797],[112.17992401123047,157.22964477539062],[112.00699615478516,156.88490295410156],[111.83406829833984,156.5401611328125],[111.66114044189453,156.1954345703125],[111.48821258544922,155.85069274902344],[111.3152847290039,155.50595092773438],[111.14232635498047,155.16114807128906],[110.96939849853516,154.81640625],[110.79647064208984,154.4716796875],[110.62354278564453,154.12693786621094],[110.45061492919922,153.78219604492188],[110.27767944335938,153.4374542236328],[110.10475158691406,153.09271240234375],[109.93182373046875,152.7479705810547],[109.75889587402344,152.40322875976562],[109.58596801757812,152.05850219726562],[109.41304016113281,151.7137451171875],[109.2401123046875,151.3690185546875],[109.06718444824219,151.02427673339844],[108.89425659179688,150.67953491210938],[108.72132873535156,150.3347930908203],[108.54840087890625,149.99005126953125],[108.3754653930664,149.6453094482422],[108.2025375366211,149.30056762695312],[108.02960968017578,148.95584106445312],[107.85668182373047,148.61109924316406],[107.68375396728516,148.266357421875],[107.51082611083984,147.92161560058594],[107.3378677368164,147.57681274414062],[107.1649398803711,147.23208618164062],[106.99201202392578,146.88734436035156],[106.81908416748047,146.5426025390625],[106.64615631103516,146.19786071777344],[106.47322845458984,145.85311889648438],[106.30029296875,145.5083770751953],[106.12736511230469,145.16363525390625],[105.95443725585938,144.81890869140625],[105.78150939941406,144.4741668701172],[105.60858154296875,144.12942504882812],[105.43565368652344,143.78468322753906],[105.26272583007812,143.43994140625],[105.08979797363281,143.09519958496094],[104.9168701171875,142.75045776367188],[104.74394226074219,142.4057159423828],[104.57100677490234,142.06097412109375],[104.39807891845703,141.71624755859375],[104.22515106201172,141.3715057373047],[104.0522232055664,141.02676391601562],[103.8792953491211,140.68202209472656],[103.70636749267578,140.3372802734375],[103.53340911865234,139.99249267578125],[103.36048126220703,139.6477508544922],[103.18755340576172,139.30300903320312],[103.0146255493164,138.95826721191406],[102.8416976928711,138.613525390625],[102.66876983642578,138.26878356933594],[102.49583435058594,137.92404174804688],[102.32290649414062,137.57931518554688],[102.14997863769531,137.2345733642578],[101.97705078125,136.88983154296875],[101.80412292480469,136.5450897216797],[101.63119506835938,136.20034790039062],[101.45826721191406,135.85560607910156],[101.28533935546875,135.5108642578125],[101.11241149902344,135.16612243652344],[100.93948364257812,134.82138061523438],[100.76654815673828,134.47665405273438],[100.59362030029297,134.1319122314453],[100.42069244384766,133.78717041015625],[100.24776458740234,133.4424285888672],[100.07483673095703,133.09768676757812],[99.90190887451172,132.75294494628906],[99.72895050048828,132.4081573486328],[99.55602264404297,132.06341552734375],[99.38309478759766,131.7186737060547],[99.21016693115234,131.37393188476562],[99.03723907470703,131.02919006347656],[98.86431121826172,130.6844482421875],[98.69137573242188,130.3397216796875],[98.51844787597656,129.99497985839844],[98.34552001953125,129.65023803710938],[98.17259216308594,129.3054962158203],[97.99966430664062,128.96075439453125],[97.82673645019531,128.6160125732422],[97.65380859375,128.27127075195312],[97.48088073730469,127.9265365600586],[97.30795288085938,127.58179473876953],[97.13502502441406,127.23705291748047],[96.96208953857422,126.89231872558594],[96.7891616821289,126.54757690429688],[96.6162338256836,126.20283508300781],[96.44330596923828,125.85809326171875],[96.27037811279297,125.51335144042969],[96.09745025634766,125.16861724853516],[95.92452239990234,124.8238754272461],[95.7515640258789,124.47908020019531],[95.5786361694336,124.13433837890625],[95.40570831298828,123.78959655761719],[95.23278045654297,123.44486236572266],[95.05985260009766,123.1001205444336],[94.88691711425781,122.75537872314453],[94.7139892578125,122.41064453125],[94.54106140136719,122.06590270996094],[94.36813354492188,121.72116088867188],[94.19520568847656,121.37641906738281],[94.02227783203125,121.03167724609375],[93.84934997558594,120.68694305419922],[93.67642211914062,120.34220123291016],[93.50349426269531,119.9974594116211],[93.33056640625,119.65271759033203],[93.15763092041016,119.3079833984375],[92.98470306396484,118.96324157714844],[92.81177520751953,118.61849975585938],[92.63884735107422,118.27375793457031],[92.4659194946289,117.92902374267578],[92.2929916381836,117.58428192138672],[92.12006378173828,117.23954010009766],[91.90858459472656,116.92057800292969],[91.6552963256836,116.62972259521484],[91.40200805664062,116.33887481689453],[91.14871978759766,116.04801940917969],[90.89543151855469,115.75716400146484],[90.64214324951172,115.46631622314453],[90.38886260986328,115.17546081542969],[90.13557434082031,114.88460540771484],[89.88228607177734,114.59375762939453],[89.62899780273438,114.30290222167969],[89.3757095336914,114.01204681396484],[89.12242126464844,113.72119903564453],[88.86913299560547,113.43034362792969],[88.6158447265625,113.13948822021484],[88.36256408691406,112.84864044189453],[88.1092758178711,112.55778503417969],[87.85598754882812,112.26692962646484],[87.60269927978516,111.97607421875],[87.34941101074219,111.68522644042969],[87.09612274169922,111.39437103271484],[86.84283447265625,111.103515625],[86.58955383300781,110.81266784667969],[86.33621978759766,110.52176666259766],[86.08293914794922,110.23091125488281],[85.82965087890625,109.9400634765625],[85.57636260986328,109.64920806884766],[85.32307434082031,109.35835266113281],[85.06978607177734,109.0675048828125],[84.81649780273438,108.77664947509766],[84.5632095336914,108.48579406738281],[84.30992126464844,108.19493865966797],[84.056640625,107.90409088134766],[83.80335235595703,107.61323547363281],[83.55006408691406,107.32238006591797],[83.2967758178711,107.03153228759766],[83.04348754882812,106.74067687988281],[82.79019927978516,106.44982147216797],[82.53691101074219,106.15897369384766],[82.28362274169922,105.86811828613281],[82.03034210205078,105.57726287841797],[81.77705383300781,105.28641510009766],[81.52376556396484,104.99555969238281],[81.27047729492188,104.70470428466797],[81.0171890258789,104.41384887695312],[80.76386260986328,104.12295532226562],[80.51057434082031,103.83209991455078],[80.25728607177734,103.54124450683594],[80.00399780273438,103.25039672851562],[79.7507095336914,102.95954132080078],[79.49742889404297,102.66868591308594],[79.244140625,102.37783813476562],[78.99085235595703,102.08698272705078],[78.73756408691406,101.79612731933594],[78.4842758178711,101.50527954101562],[78.23098754882812,101.21442413330078],[77.97769927978516,100.92356872558594],[77.72441101074219,100.6327133178711],[77.47113037109375,100.34186553955078],[77.21784210205078,100.05101013183594],[76.96455383300781,99.7601547241211],[76.71126556396484,99.46930694580078],[76.45797729492188,99.17845153808594],[76.2046890258789,98.8875961303711],[75.95140075683594,98.59674835205078],[75.69811248779297,98.30589294433594],[75.44483184814453,98.0150375366211],[75.19149780273438,97.7241439819336],[74.93821716308594,97.43328857421875],[74.68492889404297,97.1424331665039],[74.431640625,96.85157775878906],[74.17835235595703,96.56072998046875],[73.92506408691406,96.2698745727539],[73.6717758178711,95.97901916503906],[73.41848754882812,95.68817138671875],[73.16519927978516,95.3973159790039],[72.91191864013672,95.10646057128906],[72.65862274169922,94.81561279296875],[72.40534210205078,94.5247573852539],[72.15205383300781,94.23390197753906],[71.89876556396484,93.94305419921875],[71.64547729492188,93.6521987915039],[71.3921890258789,93.36134338378906],[71.13890075683594,93.07049560546875],[70.88561248779297,92.7796401977539],[70.63232421875,92.48878479003906],[70.37904357910156,92.19792938232422],[70.1257553100586,91.9070816040039],[69.87246704101562,91.61622619628906],[69.619140625,91.32532501220703],[69.36585235595703,91.03447723388672],[69.11256408691406,90.74362182617188],[68.8592758178711,90.45276641845703],[68.60598754882812,90.16191864013672],[68.35269927978516,89.87106323242188],[68.09941864013672,89.58020782470703],[67.84613037109375,89.28936004638672],[67.59284210205078,88.99850463867188],[67.33955383300781,88.70764923095703],[67.08626556396484,88.41679382324219],[66.83297729492188,88.12594604492188],[66.5796890258789,87.83509063720703],[66.32640075683594,87.54423522949219],[66.0731201171875,87.25338745117188],[65.81983184814453,86.96253204345703],[65.56654357910156,86.67167663574219],[65.3132553100586,86.38082885742188],[65.05996704101562,86.08997344970703],[64.80667877197266,85.79911804199219],[64.55339050292969,85.50827026367188],[64.30010223388672,85.21741485595703],[64.0467758178711,84.926513671875],[63.793487548828125,84.63565826416016],[63.54020690917969,84.34481048583984],[63.28691864013672,84.053955078125],[63.03363037109375,83.76309967041016],[62.78034210205078,83.47224426269531],[62.52705383300781,83.181396484375],[62.273765563964844,82.89054107666016],[62.020477294921875,82.59968566894531],[61.767189025878906,82.308837890625],[61.51390838623047,82.01798248291016],[61.2606201171875,81.72712707519531],[61.00733184814453,81.436279296875],[60.75404357910156,81.14542388916016],[60.500755310058594,80.85456848144531],[60.247467041015625,80.563720703125],[59.994178771972656,80.27286529541016],[59.74089050292969,79.98200988769531],[59.48760986328125,79.69115447998047],[59.23432159423828,79.40030670166016],[58.98103332519531,79.10945129394531],[58.727745056152344,78.81859588623047],[58.47441864013672,78.52770233154297],[58.22113037109375,78.23684692382812],[57.96784210205078,77.94599151611328],[57.71455383300781,77.65514373779297],[57.461265563964844,77.36428833007812],[57.207977294921875,77.07343292236328],[56.95469665527344,76.78258514404297],[56.70140838623047,76.49172973632812],[56.4481201171875,76.20087432861328],[56.19483184814453,75.91001892089844],[55.94154357910156,75.61917114257812],[55.688255310058594,75.32831573486328],[55.434967041015625,75.03746032714844],[55.181678771972656,74.74661254882812],[54.92839813232422,74.45575714111328],[54.67510986328125,74.16490173339844],[54.42182159423828,73.87405395507812],[54.16853332519531,73.58319854736328],[53.915245056152344,73.29234313964844],[53.661956787109375,73.00149536132812],[53.408668518066406,72.71063995361328],[53.15538024902344,72.41978454589844],[52.902099609375,72.12893676757812],[52.648765563964844,71.8380355834961],[52.395484924316406,71.54718017578125],[52.14219665527344,71.2563247680664],[51.88890838623047,70.9654769897461],[51.6356201171875,70.67462158203125],[51.38233184814453,70.3837661743164],[51.12904357910156,70.0929183959961],[50.875755310058594,69.80206298828125],[50.622467041015625,69.5112075805664],[50.36918640136719,69.2203598022461],[50.11589813232422,68.92950439453125],[49.86260986328125,68.6386489868164],[49.60932159423828,68.3478012084961],[49.35603332519531,68.05694580078125],[49.102745056152344,67.7660903930664],[48.849456787109375,67.47523498535156],[48.59617614746094,67.18438720703125],[48.34288787841797,66.8935317993164],[48.089599609375,66.60267639160156],[47.83631134033203,66.31182861328125],[47.58302307128906,66.0209732055664],[47.329734802246094,65.73011779785156],[47.07640838623047,65.43922424316406],[46.8231201171875,65.14836883544922],[46.56983184814453,64.85751342773438],[46.31654357910156,64.56666564941406],[46.063262939453125,64.27581024169922],[45.809974670410156,63.984954833984375],[45.55668640136719,63.69409942626953],[45.30339813232422,63.40325164794922],[45.05010986328125,63.112396240234375],[44.79682159423828,62.82154083251953],[44.54353332519531,62.53069305419922],[44.290245056152344,62.239837646484375],[44.036964416503906,61.94898223876953],[43.78367614746094,61.65813446044922],[43.53038787841797,61.367279052734375],[43.277099609375,61.07642364501953],[43.02381134033203,60.78557586669922],[42.77052307128906,60.494720458984375],[42.517234802246094,60.20386505126953],[42.263946533203125,59.91300964355469],[42.01066589355469,59.622161865234375],[41.75737762451172,59.33130645751953],[41.504051208496094,59.0404052734375],[41.250762939453125,58.74955749511719],[40.997474670410156,58.458702087402344],[40.74418640136719,58.1678466796875],[40.49089813232422,57.87699890136719],[40.23760986328125,57.586143493652344],[39.98432159423828,57.2952880859375],[39.73103713989258,57.00444030761719],[39.47774887084961,56.713584899902344],[39.224464416503906,56.4227294921875],[38.97117614746094,56.131874084472656],[38.71788787841797,55.841026306152344],[38.464599609375,55.5501708984375],[38.21131134033203,55.259315490722656],[37.95802307128906,54.968467712402344],[37.70473861694336,54.6776123046875],[37.45145034790039,54.386756896972656],[37.19816589355469,54.095909118652344],[36.94487762451172,53.8050537109375],[36.69158935546875,53.514198303222656],[36.43830108642578,53.22334671020508],[36.18501281738281,52.9324951171875],[35.93168640136719,52.64159393310547],[35.67839813232422,52.35074234008789],[35.42510986328125,52.05989074707031],[35.17182540893555,51.76903533935547],[34.91853713989258,51.47818374633789],[34.665252685546875,51.18733215332031],[34.411964416503906,50.89647674560547],[34.15867614746094,50.605621337890625],[33.90538787841797,50.31477355957031],[33.652099609375,50.02391815185547],[33.39881134033203,49.733062744140625],[33.14552688598633,49.44221115112305],[32.89223861694336,49.15135955810547],[32.638954162597656,48.860504150390625],[32.38566589355469,48.56965255737305],[32.13237762451172,48.27880096435547],[31.87908935546875,47.987945556640625],[31.625802993774414,47.69709396362305],[31.372514724731445,47.40624237060547],[31.11922836303711,47.115386962890625],[30.865942001342773,46.82453536987305],[30.612653732299805,46.53368377685547],[30.35932731628418,46.24278259277344],[30.10603904724121,45.951927185058594],[29.852752685546875,45.661075592041016],[29.599464416503906,45.37022399902344],[29.34617805480957,45.079368591308594],[29.0928897857666,44.788516998291016],[28.839603424072266,44.49766540527344],[28.586315155029297,44.206809997558594],[28.33302879333496,43.915958404541016],[28.079740524291992,43.62510681152344],[27.826454162597656,43.334251403808594],[27.573165893554688,43.043399810791016],[27.31987953186035,42.75254821777344],[27.066591262817383,42.461692810058594],[26.813304901123047,42.17083740234375],[26.560016632080078,41.87998580932617],[26.306730270385742,41.589134216308594],[26.053442001342773,41.29827880859375],[25.800155639648438,41.00742721557617],[25.54686737060547,40.716575622558594],[25.293581008911133,40.42572021484375],[25.040292739868164,40.13486862182617],[24.78696632385254,39.843971252441406],[24.53367805480957,39.55311584472656],[24.280391693115234,39.262264251708984],[24.027103424072266,38.971412658691406],[23.773815155029297,38.68055725097656],[23.52052879333496,38.38970184326172],[23.267242431640625,38.09885025024414],[23.013954162597656,37.80799865722656],[22.760665893554688,37.51714324951172],[22.50737953186035,37.22629165649414],[22.254093170166016,36.93544006347656],[22.000804901123047,36.64458465576172],[21.747516632080078,36.35373306274414],[21.494230270385742,36.06288146972656],[21.240943908691406,35.77202606201172],[20.987655639648438,35.48117446899414],[20.7343692779541,35.19032287597656],[20.481082916259766,34.89946746826172],[20.227794647216797,34.60861587524414],[19.974506378173828,34.3177604675293],[19.721220016479492,34.02690887451172],[19.467933654785156,33.736053466796875],[19.2146053314209,33.44515609741211],[18.961318969726562,33.15430450439453],[18.708030700683594,32.86344909667969],[18.454742431640625,32.57259750366211],[18.20145606994629,32.28174591064453],[17.948169708251953,31.990890502929688],[17.694881439208984,31.70003890991211],[17.441593170166016,31.4091854095459],[17.18830680847168,31.118331909179688],[16.935020446777344,30.82748031616211],[16.681732177734375,30.536624908447266],[16.428443908691406,30.245773315429688],[16.17515754699707,29.954919815063477],[15.921870231628418,29.664066314697266],[15.668582916259766,29.373214721679688],[15.415295600891113,29.082361221313477],[15.162008285522461,28.791507720947266],[14.908720970153809,28.500654220581055],[14.655433654785156,28.209800720214844],[14.402146339416504,27.918949127197266],[14.148859024047852,27.628095626831055],[13.8955717086792,27.337242126464844],[13.642244338989258,27.046344757080078],[13.388957023620605,26.755491256713867],[13.135669708251953,26.464637756347656],[12.8823823928833,26.173784255981445],[12.629095077514648,25.882930755615234],[12.375807762145996,25.592079162597656],[12.122520446777344,25.301225662231445],[11.869233131408691,25.010372161865234],[11.615945816040039,24.719518661499023],[11.362658500671387,24.428667068481445],[11.109371185302734,24.137813568115234],[10.856083869934082,23.846960067749023],[10.60279655456543,23.556106567382812],[10.349509239196777,23.265254974365234],[10.096221923828125,22.974401473999023],[9.842934608459473,22.683547973632812],[9.58964729309082,22.3926944732666],[9.336359977722168,22.10184097290039],[9.083072662353516,21.810989379882812],[8.829785346984863,21.5201358795166],[8.564030647277832,21.24087142944336],[8.30080795288086,20.95892906188965],[8.044217109680176,20.67104148864746],[7.793592929840088,20.37782859802246],[7.5489373207092285,20.079627990722656],[7.310294151306152,19.776657104492188],[7.077842712402344,19.468931198120117],[6.851792812347412,19.15648078918457],[6.632503032684326,18.83917808532715],[6.420383453369141,18.5170841217041],[6.215900421142578,18.19009017944336],[6.019587993621826,17.858112335205078],[5.832077503204346,17.52109718322754],[5.654073238372803,17.17899513244629],[5.486377716064453,16.83165168762207],[5.329913139343262,16.479190826416016],[5.185703754425049,16.12151336669922],[5.0548787117004395,15.758699417114258],[4.938710689544678,15.390963554382324],[4.838662147521973,15.018535614013672],[4.7561726570129395,14.64184284210205],[4.6929121017456055,14.261375427246094],[4.650576591491699,13.878116607666016],[4.630841255187988,13.492959976196289],[4.635323524475098,13.107415199279785],[4.665461540222168,12.722882270812988],[4.722347736358643,12.341538429260254],[4.80666446685791,11.965251922607422],[4.918558597564697,11.596246719360352],[5.0575714111328125,11.236621856689453],[5.222727298736572,10.888181686401367],[5.412556171417236,10.552512168884277],[5.625161647796631,10.23082447052002],[5.858482360839844,9.923844337463379],[6.110419750213623,9.631880760192871],[6.378823757171631,9.354979515075684],[6.661721229553223,9.092870712280273],[6.957238674163818,8.845135688781738],[7.263777256011963,8.611144065856934],[7.57991886138916,8.390227317810059],[7.904333591461182,8.181702613830566],[8.235968589782715,7.984859466552734],[8.573909759521484,7.798971652984619],[8.917240142822266,7.623412609100342],[9.265411376953125,7.457467555999756],[9.617752075195312,7.300591945648193],[9.973712921142578,7.152220726013184],[10.332974433898926,7.011784553527832],[10.69503402709961,6.878857612609863],[11.059566497802734,6.752978801727295],[11.426362991333008,6.633720874786377],[11.795130729675293,6.520716190338135],[12.165632247924805,6.413606643676758],[12.53766918182373,6.312086582183838],[12.911157608032227,6.215828895568848],[13.285910606384277,6.1245622634887695],[13.661737442016602,6.038078308105469],[14.042091369628906,5.985986709594727],[14.427658081054688,5.976441383361816],[14.813217163085938,5.966896057128906],[15.198783874511719,5.957351207733154],[15.584342956542969,5.947805881500244],[15.96990966796875,5.938260555267334],[16.35546875,5.928715705871582],[16.74103546142578,5.919170379638672],[17.12659454345703,5.909625053405762],[17.512161254882812,5.900079727172852],[17.897720336914062,5.890534400939941],[18.283287048339844,5.880989074707031],[18.668907165527344,5.871442794799805],[19.054473876953125,5.8618974685668945],[19.440032958984375,5.852352142333984],[19.825599670410156,5.842806816101074],[20.211158752441406,5.833261489868164],[20.596725463867188,5.823716163635254],[20.982284545898438,5.814171314239502],[21.36785125732422,5.804625988006592],[21.75341033935547,5.795080661773682],[22.13897705078125,5.7855353355407715],[22.524539947509766,5.7759904861450195],[22.91010284423828,5.766445159912109],[23.295665740966797,5.756899833679199],[23.681228637695312,5.747354507446289],[24.066791534423828,5.737809181213379],[24.452354431152344,5.728263854980469],[24.83791732788086,5.718719005584717],[25.223480224609375,5.709173679351807],[25.60904312133789,5.6996283531188965],[25.994606018066406,5.690083026885986],[26.380168914794922,5.680538177490234],[26.765731811523438,5.670992851257324],[27.151355743408203,5.6614460945129395],[27.53691864013672,5.651900768280029],[27.922481536865234,5.642355442047119],[28.30804443359375,5.632810115814209],[28.693607330322266,5.623265266418457],[29.07917022705078,5.613719940185547],[29.464733123779297,5.604174613952637],[29.850296020507812,5.594629287719727],[30.235858917236328,5.585083961486816],[30.621421813964844,5.575538635253906],[31.00698471069336,5.565993785858154],[31.392547607421875,5.556448459625244],[31.778114318847656,5.546903133392334],[32.16367721557617,5.537357807159424],[32.54924011230469,5.527812957763672],[32.9348030090332,5.518267631530762],[33.32036590576172,5.508722305297852],[33.705928802490234,5.499176979064941],[34.09149169921875,5.489631652832031],[34.477054595947266,5.480086326599121],[34.86261749267578,5.470541477203369],[35.2481803894043,5.460996150970459],[35.63380432128906,5.451449394226074],[36.01936721801758,5.441904067993164],[36.404930114746094,5.432358741760254],[36.79049301147461,5.422813892364502],[37.176055908203125,5.413268566131592],[37.56161880493164,5.403723239898682],[37.947181701660156,5.3941779136657715],[38.33274459838867,5.3846330642700195],[38.71830749511719,5.375087738037109],[39.1038703918457,5.365542411804199],[39.48943328857422,5.355997085571289],[39.874996185302734,5.346451759338379],[40.26055908203125,5.336906433105469],[40.646121978759766,5.327361583709717],[41.03168487548828,5.317816257476807],[41.4172477722168,5.3082709312438965],[41.80281066894531,5.298725605010986],[42.18837356567383,5.289180755615234],[42.573936462402344,5.279635429382324],[42.95949935913086,5.270090103149414],[43.345062255859375,5.260544776916504],[43.73062515258789,5.250999450683594],[44.116249084472656,5.241452693939209],[44.50181579589844,5.231907844543457],[44.88737869262695,5.222362518310547],[45.27294158935547,5.212817192077637],[45.658504486083984,5.203271865844727],[46.0440673828125,5.193726539611816],[46.429630279541016,5.184181213378906],[46.81519317626953,5.174636363983154],[47.20075607299805,5.165091037750244],[47.58631896972656,5.155545711517334],[47.97188186645508,5.146000385284424],[48.357444763183594,5.136455535888672],[48.74300765991211,5.126910209655762],[49.128570556640625,5.117364883422852],[49.51413345336914,5.107819557189941],[49.899696350097656,5.098274230957031],[50.28525924682617,5.088728904724121],[50.67082214355469,5.079184055328369],[51.0563850402832,5.069638729095459],[51.44194793701172,5.060093402862549],[51.827510833740234,5.050548076629639],[52.21307373046875,5.041003227233887],[52.598697662353516,5.031456470489502],[52.98426055908203,5.021911144256592],[53.36982345581055,5.012365818023682],[53.75538635253906,5.0028204917907715],[54.140953063964844,4.993275165557861],[54.526512145996094,4.983730316162109],[54.912078857421875,4.974184989929199],[55.297637939453125,4.964639663696289],[55.683204650878906,4.955094337463379],[56.068763732910156,4.945549011230469],[56.45433044433594,4.936004161834717],[56.83988952636719,4.926458835601807],[57.22545623779297,4.9169135093688965],[57.61101531982422,4.907368183135986],[57.99658203125,4.897822856903076],[58.38214111328125,4.888278007507324],[58.76770782470703,4.878732681274414],[59.15326690673828,4.869187355041504],[59.53883361816406,4.859642028808594],[59.92439651489258,4.850096702575684],[60.309959411621094,4.840551853179932],[60.69552230834961,4.8310065269470215],[61.081085205078125,4.821461200714111],[61.46670913696289,4.811914443969727],[61.852272033691406,4.802369117736816],[62.23783493041992,4.792823791503906],[62.62339782714844,4.783278942108154],[63.00896072387695,4.773733615875244],[63.39452362060547,4.764188289642334],[63.780086517333984,4.754642963409424],[64.1656494140625,4.745098114013672],[64.55120849609375,4.735552787780762],[64.93677520751953,4.726007461547852],[65.32234191894531,4.716462135314941],[65.70790100097656,4.706916809082031],[66.09346771240234,4.697371482849121],[66.4790267944336,4.687826633453369],[66.86459350585938,4.678281307220459],[67.25015258789062,4.668735980987549],[67.6357192993164,4.659190654754639],[68.02127838134766,4.649645805358887],[68.40684509277344,4.640100479125977],[68.79240417480469,4.630555152893066],[69.17797088623047,4.621009826660156],[69.56352996826172,4.611464500427246],[69.94915771484375,4.601917743682861],[70.334716796875,4.592372894287109],[70.72028350830078,4.582827568054199],[71.10584259033203,4.573282241821289],[71.49140930175781,4.563736915588379],[71.87696838378906,4.554191589355469],[72.26253509521484,4.544646739959717],[72.6480941772461,4.535101413726807],[73.03366088867188,4.5255560874938965],[73.41921997070312,4.516010761260986],[73.8047866821289,4.506465435028076],[74.19035339355469,4.496920585632324],[74.57591247558594,4.487375259399414],[74.96147155761719,4.477829933166504],[75.34703826904297,4.468284606933594],[75.73260498046875,4.458739280700684],[76.1181640625,4.449194431304932],[76.50372314453125,4.4396491050720215],[76.88928985595703,4.430103778839111],[77.27485656738281,4.420558452606201],[77.66041564941406,4.411013126373291],[78.04598236083984,4.401468276977539],[78.43160247802734,4.391921520233154],[78.81716918945312,4.382376194000244],[79.20272827148438,4.372830867767334],[79.58829498291016,4.363285541534424],[79.9738540649414,4.353740215301514],[80.35942077636719,4.344195365905762],[80.74497985839844,4.334650039672852],[81.13054656982422,4.325104713439941],[81.51610565185547,4.315559387207031],[81.90167236328125,4.306014060974121],[82.2872314453125,4.296469211578369],[82.67279815673828,4.286923885345459],[83.05835723876953,4.277378559112549],[83.44392395019531,4.267833232879639],[83.82948303222656,4.2582879066467285],[84.21504974365234,4.248743057250977],[84.6006088256836,4.239197731018066],[84.98617553710938,4.229652404785156],[85.37173461914062,4.220107078552246],[85.7573013305664,4.210561752319336],[86.1365966796875,4.277754783630371],[86.5155029296875,4.3497467041015625],[86.89447021484375,4.421751022338867],[87.27336883544922,4.493742942810059],[87.65226745605469,4.56573486328125],[88.03117370605469,4.637727737426758],[88.41007995605469,4.709719657897949],[88.78897857666016,4.781711578369141],[89.16787719726562,4.853703498840332],[89.54678344726562,4.92569637298584],[89.92568969726562,4.997688293457031],[90.3045883178711,5.069680213928223],[90.68348693847656,5.1416730880737305],[91.06239318847656,5.213665008544922],[91.44129943847656,5.285656929016113],[91.82019805908203,5.357649803161621],[92.1990966796875,5.4296417236328125],[92.5780029296875,5.501633644104004],[92.9569091796875,5.573626518249512],[93.33580780029297,5.645618438720703],[93.71470642089844,5.7176103591918945],[94.09361267089844,5.789602756500244],[94.47251892089844,5.861595153808594],[94.8514175415039,5.933587074279785],[95.23037719726562,6.005590915679932],[95.60928344726562,6.077582836151123],[95.98818969726562,6.149575233459473],[96.3670883178711,6.221567153930664],[96.74598693847656,6.293559551239014],[97.12489318847656,6.365551948547363],[97.50379943847656,6.437543869018555],[97.88269805908203,6.509536266326904],[98.2615966796875,6.581528663635254],[98.6405029296875,6.653520584106445],[99.0194091796875,6.725512981414795],[99.39830780029297,6.797504901885986],[99.77720642089844,6.869497299194336],[100.15611267089844,6.9414896965026855],[100.53501892089844,7.013481616973877],[100.9139175415039,7.085474014282227],[101.29281616210938,7.157465934753418],[101.67172241210938,7.229458332061768],[102.05062866210938,7.301450729370117],[102.42952728271484,7.373442649841309],[102.80842590332031,7.445435047149658],[103.18733215332031,7.51742696762085],[103.56629180908203,7.589430809020996],[103.9451904296875,7.661423206329346],[104.3240966796875,7.733415126800537],[104.7030029296875,7.805407524108887],[105.08190155029297,7.877399444580078],[105.46080780029297,7.949391841888428],[105.83970642089844,8.021384239196777],[106.21861267089844,8.093376159667969],[106.5975112915039,8.165369033813477],[106.9764175415039,8.237360000610352],[107.35531616210938,8.30935287475586],[107.73422241210938,8.381345748901367],[108.11312103271484,8.453336715698242],[108.49202728271484,8.52532958984375],[108.87092590332031,8.597322463989258],[109.24983215332031,8.669313430786133],[109.62873077392578,8.74130630493164],[110.00763702392578,8.813298225402832],[110.38653564453125,8.885290145874023],[110.76544189453125,8.957283020019531],[111.14434051513672,9.029274940490723],[111.52324676513672,9.101266860961914],[111.90220642089844,9.173271179199219],[112.28111267089844,9.24526309967041],[112.6600112915039,9.317255020141602],[113.03890991210938,9.38924789428711],[113.41781616210938,9.4612398147583],[113.79672241210938,9.533231735229492],[114.17562103271484,9.605224609375],[114.55451965332031,9.677216529846191],[114.93342590332031,9.749208450317383],[115.31233215332031,9.82120132446289],[115.69123077392578,9.893193244934082],[116.07012939453125,9.965185165405273],[116.44903564453125,10.037177085876465],[116.82794189453125,10.109169960021973],[117.20684051513672,10.181161880493164],[117.58573913574219,10.253153800964355],[117.96464538574219,10.325145721435547],[118.34355163574219,10.397138595581055],[118.72245025634766,10.469130516052246],[119.10134887695312,10.541122436523438],[119.48025512695312,10.613115310668945],[119.85916137695312,10.685107231140137],[120.23812103271484,10.757110595703125],[120.61701965332031,10.829103469848633],[120.99592590332031,10.901095390319824],[121.37483215332031,10.973087310791016],[121.75373077392578,11.045080184936523],[122.13262939453125,11.117072105407715],[122.51153564453125,11.189064025878906],[122.89044189453125,11.261056900024414],[123.26934051513672,11.333048820495605],[123.64823913574219,11.405040740966797],[124.02714538574219,11.477033615112305],[124.40605163574219,11.549025535583496],[124.78495025634766,11.621017456054688],[125.16384887695312,11.693009376525879],[125.54275512695312,11.765002250671387],[125.92166137695312,11.836994171142578],[126.3005599975586,11.90898609161377],[126.67945861816406,11.980978012084961],[127.05836486816406,12.052970886230469],[127.43727111816406,12.12496280670166],[127.81616973876953,12.196954727172852],[128.195068359375,12.26894760131836],[128.573974609375,12.34093952178955],[128.95294189453125,12.412942886352539],[129.3318328857422,12.484935760498047],[129.7107391357422,12.556927680969238],[130.0896453857422,12.62891960144043],[130.4685516357422,12.700912475585938],[130.84744262695312,12.772904396057129],[131.22634887695312,12.84489631652832],[131.60525512695312,12.916888236999512],[131.98416137695312,12.98888111114502],[132.36305236816406,13.060873031616211],[132.74195861816406,13.132864952087402],[133.12086486816406,13.20485782623291],[133.49977111816406,13.276849746704102],[133.878662109375,13.348841667175293],[134.257568359375,13.4208345413208],[134.636474609375,13.492826461791992],[135.015380859375,13.564818382263184],[135.39427185058594,13.636811256408691],[135.77317810058594,13.708803176879883],[136.15231323242188,13.779627799987793],[136.53173828125,13.84887981414795],[136.91114807128906,13.918132781982422],[137.29061889648438,13.987395286560059],[137.6700439453125,14.056647300720215],[138.0494384765625,14.125900268554688],[138.42886352539062,14.195152282714844],[138.8082733154297,14.264404296875],[139.18768310546875,14.333656311035156],[139.56710815429688,14.402909278869629],[139.94650268554688,14.472161293029785],[140.325927734375,14.541413307189941],[140.70533752441406,14.610665321350098],[141.08474731445312,14.67991828918457],[141.46417236328125,14.749170303344727],[141.84356689453125,14.818422317504883],[142.22299194335938,14.887674331665039],[142.60240173339844,14.956927299499512],[142.9818115234375,15.026179313659668],[143.36123657226562,15.095431327819824],[143.74063110351562,15.16468334197998],[144.12005615234375,15.233936309814453],[144.4994659423828,15.30318832397461],[144.87887573242188,15.372440338134766],[145.25830078125,15.441692352294922],[145.63775634765625,15.510955810546875],[146.01718139648438,15.580207824707031],[146.39659118652344,15.649460792541504],[146.7760009765625,15.71871280670166],[147.15541076660156,15.787964820861816],[147.53482055664062,15.857216835021973],[147.91424560546875,15.926469802856445],[148.2936553955078,15.995721817016602],[148.67306518554688,16.064973831176758],[149.05247497558594,16.134225845336914],[149.431884765625,16.203479766845703],[149.81130981445312,16.27273178100586],[150.1907196044922,16.341983795166016],[150.57012939453125,16.411235809326172],[150.9495391845703,16.480487823486328],[151.32894897460938,16.549739837646484],[151.7083740234375,16.61899185180664],[152.08778381347656,16.688243865966797],[152.46719360351562,16.757495880126953],[152.8466033935547,16.82674789428711],[153.22601318359375,16.895999908447266],[153.60543823242188,16.965251922607422],[153.9849090576172,17.034515380859375],[154.36431884765625,17.10376739501953],[154.7437286376953,17.17302131652832],[155.12313842773438,17.242273330688477],[155.5025634765625,17.311525344848633],[155.88197326660156,17.38077735900879],[156.26138305664062,17.450031280517578],[156.6407928466797,17.519283294677734],[157.02020263671875,17.58853530883789],[157.39962768554688,17.657787322998047],[157.77903747558594,17.727039337158203],[158.158447265625,17.79629135131836],[158.53785705566406,17.865543365478516],[158.91726684570312,17.934795379638672],[159.29669189453125,18.004047393798828],[159.6761016845703,18.073299407958984],[160.05551147460938,18.14255142211914],[160.43492126464844,18.211803436279297],[160.8143310546875,18.281055450439453],[161.19375610351562,18.350309371948242],[161.5731658935547,18.4195613861084],[161.95257568359375,18.488813400268555],[162.33204650878906,18.558076858520508],[162.71145629882812,18.627328872680664],[163.09088134765625,18.69658088684082],[163.47027587890625,18.76583480834961],[163.84970092773438,18.835086822509766],[164.22911071777344,18.904338836669922],[164.6085205078125,18.973590850830078],[164.98794555664062,19.042842864990234],[165.36734008789062,19.11209487915039],[165.74676513671875,19.181346893310547],[166.1261749267578,19.250598907470703],[166.50558471679688,19.31985092163086],[166.88499450683594,19.389102935791016],[167.264404296875,19.458354949951172],[167.64382934570312,19.52760887145996],[168.0232391357422,19.596860885620117],[168.40264892578125,19.666112899780273],[168.7820587158203,19.73536491394043],[169.16146850585938,19.804616928100586],[169.5408935546875,19.873868942260742],[169.92030334472656,19.94312286376953],[170.29971313476562,20.012374877929688],[170.67918395996094,20.08163833618164],[171.05859375,20.150890350341797],[171.43801879882812,20.220142364501953],[171.8174285888672,20.28939437866211],[172.19683837890625,20.358646392822266],[172.5762481689453,20.427898406982422],[172.95565795898438,20.497150421142578],[173.3350830078125,20.566402435302734],[173.71449279785156,20.63565444946289],[174.09390258789062,20.704906463623047],[174.4733123779297,20.774160385131836],[174.85272216796875,20.843412399291992],[175.23214721679688,20.91266441345215],[175.61155700683594,20.981916427612305],[175.990966796875,21.05116844177246],[176.37037658691406,21.120420455932617],[176.74978637695312,21.189674377441406],[177.12921142578125,21.258926391601562],[177.5086212158203,21.32817840576172],[177.88803100585938,21.397430419921875],[178.26744079589844,21.46668243408203],[178.6468505859375,21.535934448242188],[179.02633666992188,21.60519790649414],[179.40574645996094,21.674449920654297],[179.78515625,21.743701934814453],[180.16456604003906,21.81295394897461],[180.54397583007812,21.882205963134766],[180.92340087890625,21.951457977294922],[181.3028106689453,22.02071189880371],[181.68222045898438,22.089963912963867],[182.06163024902344,22.159215927124023],[182.4410400390625,22.22846794128418],[182.82046508789062,22.297719955444336],[183.1998748779297,22.366971969604492],[183.57928466796875,22.43622398376465],[183.9586944580078,22.505477905273438],[184.33810424804688,22.574729919433594],[184.717529296875,22.64398193359375],[185.09693908691406,22.713233947753906],[185.47634887695312,22.782485961914062],[185.8557586669922,22.85173797607422],[186.23516845703125,22.920989990234375],[186.61459350585938,22.99024200439453],[186.99400329589844,23.059494018554688],[187.37347412109375,23.12875747680664],[187.7528839111328,23.198009490966797],[188.13229370117188,23.267261505126953],[188.51171875,23.336515426635742],[188.89112854003906,23.4057674407959],[189.27053833007812,23.475019454956055],[189.6499481201172,23.54427146911621],[190.02935791015625,23.613523483276367],[190.40878295898438,23.682775497436523],[190.78819274902344,23.752029418945312],[191.1676025390625,23.82128143310547],[191.54701232910156,23.890533447265625],[191.92642211914062,23.95978546142578],[192.30584716796875,24.029037475585938],[192.6852569580078,24.098289489746094],[193.06466674804688,24.16754150390625],[193.44407653808594,24.236793518066406],[193.823486328125,24.306045532226562],[194.20291137695312,24.37529945373535],[194.5823211669922,24.444551467895508],[194.96173095703125,24.513803482055664],[195.3411407470703,24.58305549621582],[195.72055053710938,24.652307510375977],[196.1000213623047,24.72157096862793],[196.4794464111328,24.790822982788086],[196.85885620117188,24.860074996948242],[197.23826599121094,24.9293270111084],[197.61767578125,24.998579025268555],[197.99708557128906,25.067832946777344],[198.3765106201172,25.1370849609375],[198.75592041015625,25.206336975097656],[199.1353302001953,25.275588989257812],[199.51473999023438,25.34484100341797],[199.89414978027344,25.414093017578125],[200.27357482910156,25.48334503173828],[200.65298461914062,25.552597045898438],[201.0323944091797,25.621849060058594],[201.41180419921875,25.691102981567383],[201.7912139892578,25.76035499572754],[202.17063903808594,25.829607009887695],[202.550048828125,25.89885902404785],[202.92945861816406,25.968111038208008],[203.30886840820312,26.037363052368164],[203.6882781982422,26.10661506652832],[204.0677032470703,26.17586898803711],[204.44717407226562,26.24513053894043],[204.8265838623047,26.31438446044922],[205.20599365234375,26.383636474609375],[205.5854034423828,26.45288848876953],[205.96481323242188,26.522140502929688],[206.34423828125,26.591392517089844],[206.72364807128906,26.66064453125],[207.10305786132812,26.729896545410156],[207.4824676513672,26.799148559570312],[207.86187744140625,26.86840057373047],[208.24130249023438,26.937654495239258],[208.62071228027344,27.006906509399414],[209.0001220703125,27.07615852355957],[209.37953186035156,27.145410537719727],[209.75894165039062,27.214662551879883],[210.13836669921875,27.28391456604004],[210.5177764892578,27.353166580200195],[210.90045166015625,27.399322509765625],[211.2841796875,27.438060760498047],[211.66790771484375,27.47679901123047],[212.05165100097656,27.51553726196289],[212.4353790283203,27.554275512695312],[212.8191680908203,27.593017578125],[213.20291137695312,27.631755828857422],[213.58663940429688,27.670494079589844],[213.97036743164062,27.709232330322266],[214.35409545898438,27.747970581054688],[214.73782348632812,27.78670883178711],[215.12155151367188,27.82544708251953],[215.50527954101562,27.864185333251953],[215.88900756835938,27.902923583984375],[216.2727508544922,27.941661834716797],[216.65647888183594,27.980398178100586],[217.0402069091797,28.019136428833008],[217.42393493652344,28.05787467956543],[217.80767822265625,28.09661293029785],[218.19140625,28.135351181030273],[218.57513427734375,28.174089431762695],[218.9588623046875,28.212825775146484],[219.34259033203125,28.251564025878906],[219.726318359375,28.290302276611328],[220.11004638671875,28.32904052734375],[220.49378967285156,28.367778778076172],[220.8775177001953,28.406517028808594],[221.2613067626953,28.445261001586914],[221.64503479003906,28.483999252319336],[222.02877807617188,28.522737503051758],[222.41250610351562,28.561473846435547],[222.79623413085938,28.60021209716797],[223.17996215820312,28.63895034790039],[223.56369018554688,28.677688598632812],[223.94741821289062,28.716426849365234],[224.33114624023438,28.755165100097656],[224.7148895263672,28.793903350830078],[225.09861755371094,28.8326416015625],[225.4823455810547,28.871379852294922],[225.86607360839844,28.910118103027344],[226.24981689453125,28.948854446411133],[226.633544921875,28.987592697143555],[227.01727294921875,29.026330947875977],[227.4010009765625,29.0650691986084],[227.78472900390625,29.10380744934082],[228.16845703125,29.142545700073242],[228.55218505859375,29.18128204345703],[228.93592834472656,29.220020294189453],[229.3196563720703,29.258758544921875],[229.7034454345703,29.297504425048828],[230.08717346191406,29.336240768432617],[230.47091674804688,29.37497901916504],[230.85464477539062,29.41371726989746],[231.23837280273438,29.452455520629883],[231.62210083007812,29.491193771362305],[232.00582885742188,29.529930114746094],[232.38955688476562,29.568668365478516],[232.77328491210938,29.607406616210938],[233.1570281982422,29.64614486694336],[233.54075622558594,29.68488311767578],[233.9244842529297,29.723621368408203],[234.30821228027344,29.762359619140625],[234.69195556640625,29.801097869873047],[235.07568359375,29.83983612060547],[235.45941162109375,29.87857437133789],[235.8431396484375,29.91731071472168],[236.22686767578125,29.9560489654541],[236.610595703125,29.994787216186523],[236.99432373046875,30.033525466918945],[237.37806701660156,30.072263717651367],[237.7617950439453,30.11100196838379],[238.1455841064453,30.14974594116211],[238.52931213378906,30.18848419189453],[238.91305541992188,30.227222442626953],[239.29678344726562,30.265960693359375],[239.68051147460938,30.304697036743164],[240.06423950195312,30.343435287475586],[240.44796752929688,30.382173538208008],[240.83169555664062,30.42091178894043],[241.21542358398438,30.45965003967285],[241.5991668701172,30.498388290405273],[241.98289489746094,30.537124633789062],[242.3666229248047,30.575862884521484],[242.75035095214844,30.614601135253906],[243.13409423828125,30.653339385986328],[243.517822265625,30.69207763671875],[243.90155029296875,30.730815887451172],[244.2852783203125,30.769554138183594],[244.66900634765625,30.808292388916016],[245.052734375,30.847030639648438],[245.43646240234375,30.885766983032227],[245.82020568847656,30.92450523376465],[246.2039337158203,30.96324348449707],[246.5877227783203,31.00198745727539],[246.97145080566406,31.040725708007812],[247.3551788330078,31.079463958740234],[247.73892211914062,31.118202209472656],[248.12265014648438,31.156940460205078],[248.50637817382812,31.1956787109375],[248.89010620117188,31.23441505432129],[249.27383422851562,31.27315330505371],[249.65756225585938,31.311891555786133],[250.0413055419922,31.350629806518555],[250.42503356933594,31.389368057250977],[250.8087615966797,31.4281063079834],[251.19248962402344,31.46684455871582],[251.5762176513672,31.50558090209961],[251.9599609375,31.54431915283203],[252.34368896484375,31.583057403564453],[252.7274169921875,31.621795654296875],[253.11114501953125,31.660533905029297],[253.494873046875,31.69927215576172],[253.87860107421875,31.73801040649414],[254.26234436035156,31.776748657226562],[254.6460723876953,31.815486907958984],[255.0298614501953,31.854228973388672],[255.41358947753906,31.892967224121094],[255.7973175048828,31.931705474853516],[256.1810607910156,31.970443725585938],[256.5647888183594,32.00918197631836],[256.9485168457031,32.04792022705078],[257.3322448730469,32.0866584777832],[257.7159729003906,32.125396728515625],[258.0997009277344,32.16413497924805],[258.4834289550781,32.20287322998047],[258.8671569824219,32.24161148071289],[259.25091552734375,32.28034973144531],[259.6346435546875,32.31908416748047],[260.01837158203125,32.35782241821289],[260.402099609375,32.39656066894531],[260.78582763671875,32.435298919677734],[261.1695556640625,32.474037170410156],[261.55328369140625,32.51277542114258],[261.93701171875,32.551513671875],[262.32073974609375,32.59025192260742],[262.7044677734375,32.628990173339844],[263.08819580078125,32.667728424072266],[263.471923828125,32.70646667480469],[263.8557434082031,32.745208740234375],[264.2394714355469,32.7839469909668],[264.6231994628906,32.82268524169922],[265.0069274902344,32.86142349243164],[265.3906555175781,32.90016174316406],[265.7743835449219,32.938899993896484],[266.1581115722656,32.977638244628906],[266.5418395996094,33.01637649536133],[266.9255676269531,33.05511474609375],[267.3092956542969,33.09385299682617],[267.6930236816406,33.132591247558594],[268.0767822265625,33.171329498291016],[268.46051025390625,33.21006774902344],[268.84423828125,33.24880599975586],[269.22796630859375,33.28754425048828],[269.6116943359375,33.32627868652344],[269.99542236328125,33.36501693725586],[270.379150390625,33.40375518798828],[270.76287841796875,33.4424934387207],[271.1466064453125,33.481231689453125],[271.53033447265625,33.51996994018555],[271.9140625,33.55870819091797],[272.2978820800781,33.59745407104492],[272.6816101074219,33.636192321777344],[273.0653381347656,33.6749267578125],[273.4490661621094,33.71366500854492],[273.8327941894531,33.752403259277344],[274.2165222167969,33.791141510009766],[274.6002502441406,33.82987976074219],[274.9839782714844,33.86861801147461],[275.3677062988281,33.90735626220703],[275.7514343261719,33.94609451293945],[276.1351623535156,33.984832763671875],[276.5189208984375,34.0235710144043],[276.90264892578125,34.06230926513672],[277.286376953125,34.10104751586914],[277.67010498046875,34.13978576660156],[278.0538330078125,34.178524017333984],[278.43756103515625,34.217262268066406],[278.8212890625,34.25600051879883],[279.20550537109375,34.28891372680664],[279.59002685546875,34.31854248046875],[279.9745788574219,34.348167419433594],[280.359130859375,34.37779235839844],[280.74371337890625,34.40742492675781],[281.1282653808594,34.437049865722656],[281.5128173828125,34.4666748046875],[281.8973388671875,34.496299743652344],[282.2818908691406,34.52592849731445],[282.66644287109375,34.5555534362793],[283.05096435546875,34.58517837524414],[283.4355163574219,34.614803314208984],[283.820068359375,34.644432067871094],[284.20458984375,34.67405700683594],[284.5891418457031,34.70368194580078],[284.97369384765625,34.733306884765625],[285.35821533203125,34.762935638427734],[285.7427673339844,34.79256057739258],[286.1272888183594,34.82218551635742],[286.5118408203125,34.85181427001953],[286.8963928222656,34.881439208984375],[287.2809143066406,34.91106414794922],[287.66546630859375,34.94068908691406],[288.0500183105469,34.97031784057617],[288.4345397949219,34.999942779541016],[288.819091796875,35.02956771850586],[289.2037048339844,35.059200286865234],[289.5882263183594,35.08882522583008],[289.9727783203125,35.11845016479492],[290.3573303222656,35.148075103759766],[290.7418518066406,35.177703857421875],[291.12640380859375,35.20732879638672],[291.5109558105469,35.23695373535156],[291.8954772949219,35.266578674316406],[292.280029296875,35.296207427978516],[292.6645812988281,35.32583236694336],[293.0491027832031,35.3554573059082],[293.43365478515625,35.38508605957031],[293.81817626953125,35.414710998535156],[294.2027282714844,35.4443359375],[294.5872802734375,35.473960876464844],[294.9718017578125,35.50358963012695],[295.3563537597656,35.5332145690918],[295.74090576171875,35.56283950805664],[296.12542724609375,35.592464447021484],[296.5099792480469,35.622093200683594],[296.89453125,35.65171813964844],[297.279052734375,35.68134307861328],[297.6636657714844,35.710975646972656],[298.0482177734375,35.7406005859375],[298.4327392578125,35.770225524902344],[298.8172912597656,35.79985046386719],[299.20184326171875,35.8294792175293],[299.58636474609375,35.85910415649414],[299.9709167480469,35.888729095458984],[300.35546875,35.918357849121094],[300.739990234375,35.94798278808594],[301.1245422363281,35.97760772705078],[301.50909423828125,36.007232666015625],[301.89361572265625,36.036861419677734],[302.2781677246094,36.06648635864258],[302.6627197265625,36.09611129760742],[303.0472412109375,36.125736236572266],[303.4317932128906,36.155364990234375],[303.81634521484375,36.18498992919922],[304.20086669921875,36.21461486816406],[304.5854187011719,36.244239807128906],[304.969970703125,36.273868560791016],[305.3544921875,36.30349349975586],[305.7390441894531,36.3331184387207],[306.1236572265625,36.36275100708008],[306.5081787109375,36.39237594604492],[306.8927307128906,36.422000885009766],[307.27728271484375,36.451629638671875],[307.66180419921875,36.48125457763672],[308.0463562011719,36.51087951660156],[308.430908203125,36.540504455566406],[308.8154296875,36.570133209228516],[309.1999816894531,36.59975814819336],[309.58453369140625,36.6293830871582],[309.96905517578125,36.65901184082031],[310.3536071777344,36.688636779785156],[310.7381591796875,36.71826171875],[311.1226806640625,36.747886657714844],[311.5072326660156,36.77751541137695],[311.89178466796875,36.8071403503418],[312.27630615234375,36.83676528930664],[312.6608581542969,36.866390228271484],[313.04541015625,36.896018981933594],[313.429931640625,36.92564392089844],[313.8144836425781,36.95526885986328],[314.19903564453125,36.984893798828125],[314.5836181640625,37.0145263671875],[314.9681701660156,37.044151306152344],[315.35272216796875,37.07377624511719],[315.73724365234375,37.1034049987793],[316.1217956542969,37.13302993774414],[316.50634765625,37.162654876708984],[316.890869140625,37.192283630371094],[317.2754211425781,37.22190856933594],[317.65997314453125,37.25153350830078],[318.04449462890625,37.281158447265625],[318.4290466308594,37.310787200927734],[318.8135681152344,37.34041213989258],[319.1981201171875,37.37003707885742],[319.5827331542969,37.3996696472168],[319.9671936035156,37.429290771484375],[320.351806640625,37.458919525146484],[320.7362976074219,37.48854064941406],[321.1208801269531,37.51817321777344],[321.50537109375,37.547794342041016],[321.8899841308594,37.577423095703125],[322.2744445800781,37.6070442199707],[322.6590576171875,37.63667678833008],[323.0435485839844,37.666297912597656],[323.4281311035156,37.695926666259766],[323.8126220703125,37.725547790527344],[324.1972351074219,37.75518035888672],[324.5816955566406,37.7848014831543],[324.96630859375,37.814430236816406],[325.3507995605469,37.844051361083984],[325.7353820800781,37.87368392944336],[326.119873046875,37.90330505371094],[326.5044860839844,37.93293380737305],[326.8889465332031,37.962554931640625],[327.2735595703125,37.9921875],[327.6581726074219,38.02181625366211],[328.0426330566406,38.05143737792969],[328.42724609375,38.08106994628906],[328.8117370605469,38.11069107055664],[329.1963195800781,38.140323638916016],[329.580810546875,38.169944763183594],[329.9654235839844,38.1995735168457],[330.3498840332031,38.22919464111328],[330.7344970703125,38.258827209472656],[331.11895751953125,38.288448333740234],[331.5035705566406,38.318077087402344],[331.8880615234375,38.34769821166992],[332.27264404296875,38.3773307800293],[332.6571350097656,38.406951904296875],[333.041748046875,38.436580657958984],[333.42620849609375,38.46620178222656],[333.8108215332031,38.49583435058594],[334.1953125,38.525455474853516],[334.57989501953125,38.555084228515625],[334.9643859863281,38.5847053527832],[335.3489990234375,38.61433792114258],[335.73345947265625,38.643959045410156],[336.1180725097656,38.673587799072266],[336.502685546875,38.70322036743164],[336.88714599609375,38.73284149169922],[337.2717590332031,38.76247024536133],[337.65625,38.792091369628906],[338.04083251953125,38.82172393798828],[338.4253234863281,38.85134506225586],[338.8099365234375,38.88097381591797],[339.19439697265625,38.91059494018555],[339.5790100097656,38.94022750854492],[339.9635009765625,38.9698486328125],[340.34808349609375,38.999481201171875],[340.7325744628906,39.02910232543945],[341.1171875,39.05873107910156],[341.50164794921875,39.08835220336914],[341.8862609863281,39.117984771728516],[342.270751953125,39.147605895996094],[342.65533447265625,39.1772346496582],[343.0398254394531,39.20685577392578],[343.4244384765625,39.236488342285156],[343.80889892578125,39.266109466552734],[344.1935119628906,39.295738220214844],[344.578125,39.32537078857422],[344.96258544921875,39.3549919128418],[345.3471984863281,39.384620666503906],[345.731689453125,39.414241790771484],[346.11627197265625,39.44387435913086],[346.5007629394531,39.47349548339844],[346.8853759765625,39.50312423706055],[347.26983642578125,39.532745361328125],[347.6544494628906,39.5623779296875],[348.0389404296875,39.59199905395508],[348.42352294921875,39.62162780761719],[348.8080139160156,39.651248931884766],[349.192626953125,39.68088150024414],[349.57708740234375,39.71050262451172],[349.961669921875,39.740379333496094],[350.3362121582031,39.8320198059082],[350.7080078125,39.934814453125],[351.07720947265625,40.04620361328125],[351.44415283203125,40.165077209472656],[351.80859375,40.29103469848633],[352.1706848144531,40.42394256591797],[352.53021240234375,40.563392639160156],[352.88720703125,40.709476470947266],[353.2414855957031,40.86195755004883],[353.5927734375,41.021209716796875],[353.94097900390625,41.186988830566406],[354.28594970703125,41.35932540893555],[354.6275634765625,41.53841018676758],[354.96551513671875,41.72422790527344],[355.2997741699219,41.916690826416016],[355.62969970703125,42.11629867553711],[355.9553527832031,42.322967529296875],[356.2763671875,42.536705017089844],[356.5924987792969,42.75762939453125],[356.9032897949219,42.9859619140625],[357.20855712890625,43.22163009643555],[357.5079345703125,43.46478271484375],[357.8009948730469,43.71548843383789],[358.08740234375,43.97373580932617],[358.3668518066406,44.239707946777344],[358.6387023925781,44.51316452026367],[358.90277099609375,44.79423522949219],[359.1584167480469,45.082984924316406],[359.4054870605469,45.37921142578125],[359.6434326171875,45.68279266357422],[359.87158203125,45.993648529052734],[360.0899353027344,46.31159210205078],[360.29791259765625,46.636329650878906],[360.4951171875,46.96782302856445],[360.6811218261719,47.3055534362793],[360.8558654785156,47.64936447143555],[361.01898193359375,47.998817443847656],[361.1702575683594,48.353599548339844],[361.3094787597656,48.71317672729492],[361.4365539550781,49.07735824584961],[361.5513916015625,49.445499420166016],[361.6540222167969,49.81732177734375],[361.744384765625,50.19220733642578],[361.82269287109375,50.569820404052734],[361.88909912109375,50.94971466064453],[361.9434509277344,51.33149719238281],[361.9862060546875,51.71476364135742],[362.01776123046875,52.099159240722656],[362.0380554199219,52.48428726196289],[362.0474853515625,52.86992263793945],[362.0465393066406,53.25545883178711],[362.0352783203125,53.64109420776367],[362.01422119140625,54.02613830566406],[361.98370361328125,54.41055679321289],[361.9437561035156,54.794288635253906],[361.8951110839844,55.17673873901367],[361.8380432128906,55.558292388916016],[361.7726135253906,55.938209533691406],[361.69927978515625,56.316959381103516],[361.61846923828125,56.693973541259766],[361.5303955078125,57.06957244873047],[361.4353942871094,57.443275451660156],[361.33367919921875,57.81529235839844],[361.2256164550781,58.18551254272461],[361.11138916015625,58.55396270751953],[360.9913024902344,58.92041778564453],[360.8656005859375,59.2850456237793],[360.7344970703125,59.647647857666016],[360.5981750488281,60.00859451293945],[360.45672607421875,60.367286682128906],[360.3105163574219,60.724266052246094],[360.15985107421875,61.079227447509766],[359.9933166503906,61.426963806152344],[359.8121032714844,61.76749038696289],[359.62738037109375,62.10596466064453],[359.440185546875,62.44320297241211],[359.250244140625,62.77882385253906],[359.05816650390625,63.11336135864258],[358.8641357421875,63.44660949707031],[358.66815185546875,63.778785705566406],[358.4703063964844,64.10986328125],[358.2707824707031,64.43994903564453],[358.0697021484375,64.76901245117188],[357.8669738769531,65.09715270996094],[357.6626892089844,65.42428588867188],[357.45684814453125,65.75051879882812],[357.2496032714844,66.07569885253906],[357.04083251953125,66.40000915527344],[356.8306884765625,66.72329711914062],[356.6190490722656,67.04586029052734],[356.4061279296875,67.36736297607422],[356.19183349609375,67.68807983398438],[355.9762878417969,68.00789642333984],[355.7594299316406,68.32689666748047],[355.5414123535156,68.64495849609375],[355.3218688964844,68.9621353149414],[355.10107421875,69.27833557128906],[354.87908935546875,69.59374237060547],[354.6559753417969,69.90837860107422],[354.43170166015625,70.22207641601562],[354.2058410644531,70.53482055664062],[353.9790344238281,70.84662628173828],[353.7511291503906,71.15779113769531],[353.5219421386719,71.4679183959961],[353.2913513183594,71.77719116210938],[353.0599060058594,72.08563995361328],[352.8272705078125,72.3933334350586],[352.5931701660156,72.6998062133789],[352.3581848144531,73.005615234375],[352.1222229003906,73.31060028076172],[351.8846130371094,73.6144790649414],[351.6462097167969,73.91769409179688],[351.4067077636719,74.22006225585938],[351.16619873046875,74.52137756347656],[350.9241027832031,74.82176971435547],[350.6811218261719,75.12120056152344],[350.4372253417969,75.42002868652344],[350.19207763671875,75.71783447265625],[349.9457702636719,76.0145492553711],[349.6983337402344,76.31045532226562],[349.44989013671875,76.60543060302734],[349.20037841796875,76.89952087402344],[348.94976806640625,77.19266510009766],[348.6979064941406,77.48489379882812],[348.4450988769531,77.77606964111328],[348.1911315917969,78.06641387939453],[347.93621826171875,78.35576629638672],[347.6801452636719,78.64425659179688],[347.423095703125,78.93169403076172],[347.16485595703125,79.21825408935547],[346.9056091308594,79.503662109375],[346.6452331542969,79.78824615478516],[346.3838806152344,80.07177734375],[346.1213684082031,80.3544692993164],[345.8578796386719,80.63606262207031],[345.59326171875,80.91675567626953],[345.3277282714844,81.19634246826172],[345.0610046386719,81.47505950927734],[344.7933654785156,81.75263977050781],[344.52459716796875,82.02932739257812],[344.2547607421875,82.3049545288086],[343.98394775390625,82.57939910888672],[343.71197509765625,82.8530044555664],[343.4390869140625,83.12545013427734],[343.1650390625,83.39694213867188],[342.8900451660156,83.66730499267578],[342.6139831542969,83.93668365478516],[342.3369445800781,84.20494079589844],[342.058837890625,84.47216796875],[341.77972412109375,84.7383041381836],[341.4995422363281,85.0033950805664],[341.2183837890625,85.26737213134766],[340.9361267089844,85.53033447265625],[340.6529541015625,85.7920913696289],[340.36871337890625,86.05279541015625],[340.08355712890625,86.31228637695312],[339.79718017578125,86.57083892822266],[339.5099182128906,86.82815551757812],[339.22161865234375,87.08436584472656],[338.9323425292969,87.33942413330078],[338.64202880859375,87.5933609008789],[338.3507995605469,87.84608459472656],[338.05841064453125,88.0978012084961],[337.7651062011719,88.34825134277344],[337.4708557128906,88.59751892089844],[337.175537109375,88.8456802368164],[336.8793029785156,89.09257507324219],[336.5820007324219,89.3382568359375],[336.28375244140625,89.58271026611328],[335.9844055175781,89.82599639892578],[335.6842041015625,90.06802368164062],[335.3829040527344,90.3089370727539],[335.0807800292969,90.5484848022461],[334.7774963378906,90.78691101074219],[334.4734191894531,91.02400970458984],[334.1682434082031,91.25996398925781],[333.8621826171875,91.49461364746094],[333.55511474609375,91.72803497314453],[333.2471618652344,91.96015930175781],[332.9382019042969,92.1910629272461],[332.6282958984375,92.42066955566406],[332.3173522949219,92.64891815185547],[332.00555419921875,92.87574005126953],[331.69268798828125,93.10137939453125],[331.3788757324219,93.32569122314453],[331.0642395019531,93.54866027832031],[330.7485656738281,93.77037048339844],[330.4320373535156,93.99071502685547],[330.1145935058594,94.20976257324219],[329.79632568359375,94.42741394042969],[329.47698974609375,94.643798828125],[329.1566467285156,94.85865020751953],[328.83544921875,95.07210540771484],[328.5133361816406,95.28421783447266],[328.1902770996094,95.49498748779297],[327.86651611328125,95.70428466796875],[327.5416259765625,95.91236114501953],[327.2160339355469,96.11894226074219],[326.8894958496094,96.32421875],[326.56201171875,96.52783203125],[326.2335205078125,96.73009490966797],[325.90423583984375,96.93089294433594],[325.5740661621094,97.13030242919922],[325.2431335449219,97.32823181152344],[324.9112854003906,97.52481079101562],[324.5786437988281,97.71996307373047],[324.2449645996094,97.91349792480469],[323.91046142578125,98.10546112060547],[323.57513427734375,98.2959976196289],[323.2389831542969,98.48511505126953],[322.902099609375,98.6727066040039],[322.564208984375,98.85897827148438],[322.2256774902344,99.04365539550781],[321.8861389160156,99.22657012939453],[321.54583740234375,99.40800476074219],[321.2046813964844,99.58799743652344],[320.8628234863281,99.76646423339844],[320.52008056640625,99.94351959228516],[320.17669677734375,100.11898803710938],[319.8323669433594,100.29264068603516],[319.4873046875,100.46475982666016],[319.141357421875,100.63544464111328],[318.7947082519531,100.80459594726562],[318.4473571777344,100.97225189208984],[318.0992736816406,101.1382064819336],[317.7502746582031,101.3023910522461],[317.400634765625,101.46501922607422],[317.0501708984375,101.6261978149414],[316.6990051269531,101.78585052490234],[316.3472595214844,101.94390869140625],[315.9944763183594,102.10005187988281],[315.64117431640625,102.25458526611328],[315.28717041015625,102.40758514404297],[314.9324951171875,102.55905151367188],[314.5771484375,102.70899963378906],[314.2210388183594,102.8569107055664],[313.8641052246094,103.0032730102539],[313.5066833496094,103.1480484008789],[313.1485290527344,103.29129791259766],[312.7898254394531,103.4329833984375],[312.43023681640625,103.57257843017578],[312.07012939453125,103.71058654785156],[311.70941162109375,103.8470458984375],[311.34814453125,103.98191833496094],[310.98614501953125,104.1151123046875],[310.62347412109375,104.24629211425781],[310.26025390625,104.37591552734375],[309.8965148925781,104.50395965576172],[309.53204345703125,104.63050842285156],[309.16705322265625,104.75495910644531],[308.8013916015625,104.87770080566406],[308.4351806640625,104.99889373779297],[308.0685729980469,105.11848449707031],[307.7012634277344,105.23632049560547],[307.33343505859375,105.35211944580078],[306.9649963378906,105.46639251708984],[306.59619140625,105.57906341552734],[306.2267761230469,105.69013214111328],[305.8569030761719,105.79895782470703],[305.4864196777344,105.90628051757812],[305.11553955078125,106.01202392578125],[304.744140625,106.11622619628906],[304.37225341796875,106.2181167602539],[303.99981689453125,106.3184585571289],[303.62701416015625,106.417236328125],[303.2537841796875,106.51448822021484],[302.8800048828125,106.6093978881836],[302.5057067871094,106.70279693603516],[302.1311950683594,106.79460906982422],[301.75616455078125,106.88485717773438],[301.3807067871094,106.97277069091797],[301.0047912597656,107.0591812133789],[300.62847900390625,107.14424133300781],[300.2519226074219,107.22724914550781],[299.8747863769531,107.30817413330078],[299.49749755859375,107.38795471191406],[299.11968994140625,107.46569061279297],[298.7416687011719,107.5416488647461],[298.3631591796875,107.61592864990234],[297.9843444824219,107.6883773803711],[297.6051330566406,107.75921630859375],[297.2257995605469,107.82809448242188],[296.84588623046875,107.89544677734375],[296.4659118652344,107.96086883544922],[296.0854797363281,108.024658203125],[295.7048645019531,108.08667755126953],[295.3238525390625,108.14693450927734],[294.9426574707031,108.20555114746094],[294.5611572265625,108.26226043701172],[294.1794738769531,108.3173828125],[293.7974853515625,108.37066650390625],[293.415283203125,108.42225646972656],[293.0328063964844,108.47217559814453],[292.6501770019531,108.52023315429688],[292.26727294921875,108.56671905517578],[291.8954772949219,108.66796875],[291.51983642578125,108.75487518310547],[291.1416015625,108.8305435180664],[290.76177978515625,108.89772033691406],[290.38079833984375,108.95796203613281],[289.9990234375,109.01236724853516],[289.6164855957031,109.0615234375],[289.2334899902344,109.10609436035156],[288.849853515625,109.14659118652344],[288.46600341796875,109.183349609375],[288.0816345214844,109.21649169921875],[287.697265625,109.24645233154297],[287.3125,109.27356719970703],[286.9275817871094,109.29766845703125],[286.54248046875,109.31929779052734],[286.1572570800781,109.33837890625],[285.7718505859375,109.35504913330078],[285.3866271972656,109.36959075927734],[285.0010681152344,109.38206481933594],[284.6156005859375,109.39230346679688],[284.2298889160156,109.40066528320312],[283.8443298339844,109.40719604492188],[283.4586486816406,109.41197204589844],[283.0728454589844,109.4150390625],[282.687255859375,109.41645812988281],[282.301513671875,109.41629028320312],[281.9158935546875,109.41458129882812],[281.53021240234375,109.41139221191406],[281.14459228515625,109.40676879882812],[280.75885009765625,109.40076446533203],[280.373291015625,109.39342498779297],[279.98773193359375,109.38480377197266],[279.60223388671875,109.37494659423828],[279.2166442871094,109.36389923095703],[278.83123779296875,109.35163879394531],[278.4456787109375,109.33806610107422],[278.0603942871094,109.32342529296875],[277.6749572753906,109.3077392578125],[277.2896728515625,109.29105377197266],[276.90435791015625,109.27337646484375],[276.5191650390625,109.25440979003906],[276.1339111328125,109.23454284667969],[275.7488708496094,109.21382904052734],[275.3637390136719,109.19225311279297],[274.9787292480469,109.16944885253906],[274.59381103515625,109.14586639404297],[274.20880126953125,109.12153625488281],[273.8240051269531,109.09619903564453],[273.439208984375,109.06995391845703],[273.0545349121094,109.04306030273438],[272.6697998046875,109.01527404785156],[272.2851867675781,108.98656463623047],[271.90057373046875,108.957275390625],[271.5161437988281,108.92711639404297],[271.1316223144531,108.8961181640625],[270.74737548828125,108.86463928222656],[270.3630065917969,108.83214569091797],[269.978759765625,108.79905700683594],[269.594482421875,108.76541137695312],[269.21038818359375,108.73076629638672],[268.82623291015625,108.69573974609375],[268.4422912597656,108.65985870361328],[268.058349609375,108.62337493896484],[267.67449951171875,108.58638000488281],[267.29058837890625,108.54847717285156],[266.9068603515625,108.51031494140625],[266.52313232421875,108.47113037109375],[266.139404296875,108.431640625],[265.7558898925781,108.39140319824219],[265.3722839355469,108.35063934326172],[264.9888916015625,108.3093490600586],[264.60546875,108.26736450195312],[264.2221984863281,108.22501373291016],[263.83880615234375,108.18184661865234],[263.4556579589844,108.13846588134766],[263.072509765625,108.09418487548828],[262.689453125,108.0497817993164],[262.30633544921875,108.00440216064453],[261.92340087890625,107.958984375],[261.5405578613281,107.91258239746094],[261.1577453613281,107.86616516113281],[260.7748107910156,107.81873321533203],[260.3921203613281,107.77132415771484],[260.0094909667969,107.72296142578125],[259.62689208984375,107.674560546875],[259.2443542480469,107.62528228759766],[258.8619079589844,107.57592010498047],[258.4794006347656,107.52574920654297],[258.0969543457031,107.47541046142578],[257.71478271484375,107.42443084716797],[257.33245849609375,107.37313842773438],[256.9503479003906,107.32135772705078],[256.5681457519531,107.26912689208984],[256.1860656738281,107.21656799316406],[255.80398559570312,107.16340637207031],[255.42205810546875,107.11012268066406],[255.04013061523438,107.05604553222656],[254.65830993652344,107.00198364257812],[254.27655029296875,106.94709777832031],[253.89488220214844,106.89212036132812],[253.51319885253906,106.83658599853516],[253.1316375732422,106.78070831298828],[252.7499542236328,106.72455596923828],[252.3685302734375,106.66778564453125],[251.98699951171875,106.61100006103516],[251.60568237304688,106.55340576171875],[251.22427368164062,106.49574279785156],[250.84312438964844,106.4376220703125],[250.46185302734375,106.37907409667969],[250.0806884765625,106.3204345703125],[249.6995391845703,106.26103210449219],[249.3184051513672,106.20162200927734],[248.93746948242188,106.14166259765625],[248.55645751953125,106.0813980102539],[248.1756134033203,106.02100372314453],[247.79473876953125,105.95989990234375],[247.41400146484375,105.89881134033203],[247.033203125,105.83715057373047],[246.652587890625,105.77522277832031],[246.2718505859375,105.71319580078125],[245.89137268066406,105.65043640136719],[245.51077270507812,105.58766174316406],[245.13038635253906,105.52449798583984],[244.7499237060547,105.46089172363281],[244.3695831298828,105.39730834960938],[243.9892120361328,105.33300018310547],[243.6090087890625,105.26860809326172],[243.22877502441406,105.20404815673828],[242.84869384765625,105.13884735107422],[242.468505859375,105.07362365722656],[242.0884246826172,105.00801086425781],[241.7083740234375,104.94200134277344],[241.3283233642578,104.87598419189453],[240.94847106933594,104.80937957763672],[240.5685577392578,104.7425765991211],[240.18875122070312,104.67578887939453],[239.80897521972656,104.60821533203125],[239.4293212890625,104.54065704345703],[239.04969787597656,104.47295379638672],[238.67018127441406,104.40461730957031],[238.29054260253906,104.33625793457031],[237.91104125976562,104.26766967773438],[237.53155517578125,104.19854736328125],[237.1521759033203,104.12944793701172],[236.77273559570312,104.05998992919922],[236.39349365234375,103.9901351928711],[236.01414489746094,103.92024993896484],[235.6349334716797,103.8499984741211],[235.25572204589844,103.77936553955078],[234.87661743164062,103.70875549316406],[234.4975128173828,103.63772583007812],[234.11854553222656,103.56636810302734],[233.73947143554688,103.49498748779297],[233.3605194091797,103.4232177734375],[232.9815673828125,103.35110473632812],[232.60263061523438,103.27898406982422],[232.2239532470703,103.20653533935547],[231.8451385498047,103.1336898803711],[231.46646118164062,103.06087493896484],[231.0877227783203,102.98771667480469],[230.7091827392578,102.91417694091797],[230.3305206298828,102.84061431884766],[229.95571899414062,102.7524642944336],[229.58860778808594,102.63408660888672],[229.22097778320312,102.5176773071289],[228.85281372070312,102.40277099609375],[228.4842071533203,102.28923797607422],[228.11520385742188,102.17684936523438],[227.74594116210938,102.0657730102539],[227.37625122070312,101.95572662353516],[227.0064239501953,101.8466796875],[226.63612365722656,101.73838806152344],[226.26565551757812,101.63139343261719],[225.89486694335938,101.52527618408203],[225.52392578125,101.41976165771484],[225.15249633789062,101.31568145751953],[224.78086853027344,101.21212005615234],[224.4091339111328,101.10960388183594],[224.0371551513672,101.00775146484375],[223.66494750976562,100.90696716308594],[223.2922821044922,100.8069839477539],[222.919677734375,100.70796203613281],[222.54660034179688,100.60973358154297],[222.17344665527344,100.51240539550781],[221.800048828125,100.41592407226562],[221.42640686035156,100.32032012939453],[221.052490234375,100.22555541992188],[220.67843627929688,100.13167572021484],[220.3041229248047,100.03863525390625],[219.9296417236328,99.94645690917969],[219.55496215820312,99.85514831542969],[219.1800079345703,99.76466369628906],[218.80482482910156,99.67501831054688],[218.42953491210938,99.5864028930664],[218.0539093017578,99.49864196777344],[217.6782684326172,99.41179656982422],[217.30221557617188,99.32574462890625],[216.92608642578125,99.24058532714844],[216.54974365234375,99.15626525878906],[216.173095703125,99.072998046875],[215.7963104248047,98.99066925048828],[215.4192657470703,98.90919494628906],[215.04222106933594,98.82862854003906],[214.664794921875,98.74888610839844],[214.28726196289062,98.67032623291016],[213.90943908691406,98.59268188476562],[213.5315399169922,98.51593780517578],[213.1532440185547,98.4400405883789],[212.7749481201172,98.36524200439453],[212.39637756347656,98.29155731201172],[212.01773071289062,98.21879577636719],[211.63870239257812,98.14688873291016],[211.2596435546875,98.07609558105469],[210.88023376464844,98.00648498535156],[210.5007781982422,97.93781280517578],[210.12103271484375,97.87004089355469],[209.74119567871094,97.80349731445312],[209.361083984375,97.73814392089844],[208.9807891845703,97.67373657226562],[208.60032653808594,97.61027526855469],[208.2197265625,97.54827880859375],[207.8387908935547,97.48733520507812],[207.45777893066406,97.4273910522461],[207.07666015625,97.36859130859375],[206.69520568847656,97.31126403808594],[206.3137664794922,97.25498962402344],[205.93199157714844,97.19970703125],[205.5501251220703,97.1459732055664],[205.16793823242188,97.09346771240234],[204.7857208251953,97.04203796386719],[204.40325927734375,96.99187469482422],[204.0207061767578,96.94336700439453],[203.63795471191406,96.89595794677734],[203.25515747070312,96.84964752197266],[202.87197875976562,96.80501556396484],[202.48876953125,96.76168060302734],[202.10533142089844,96.7198486328125],[201.72181701660156,96.6794204711914],[201.3380126953125,96.64041137695312],[200.95425415039062,96.60299682617188],[200.57020568847656,96.56696319580078],[200.18614196777344,96.53262329101562],[199.8017578125,96.49974822998047],[199.41729736328125,96.46846008300781],[199.03280639648438,96.43887329101562],[198.64805603027344,96.41080474853516],[198.263427734375,96.38461303710938],[197.87838745117188,96.3600082397461],[197.4935302734375,96.33719635009766],[197.1083221435547,96.31619262695312],[196.7232208251953,96.29688262939453],[196.3378143310547,96.27962493896484],[195.95248413085938,96.26409912109375],[195.56698608398438,96.25060272216797],[195.18157958984375,96.23904418945312],[194.7959747314453,96.22943878173828],[194.41043090820312,96.2220230102539],[194.02474975585938,96.21651458740234],[193.6390380859375,96.21338653564453],[193.2533416748047,96.21227264404297],[192.8677215576172,96.2135009765625],[192.48194885253906,96.21697235107422],[192.09642028808594,96.22277069091797],[191.71075439453125,96.23104858398438],[191.32530212402344,96.24164581298828],[190.9397430419922,96.25494384765625],[190.55430603027344,96.27057647705078],[190.1692352294922,96.28912353515625],[189.78404235839844,96.31011199951172],[189.399169921875,96.3341064453125],[189.0142822265625,96.36072540283203],[188.6298370361328,96.39044952392578],[188.2454833984375,96.42295837402344],[187.86154174804688,96.45872497558594],[187.477783203125,96.4974136352539],[187.09442138671875,96.53956604003906],[186.71139526367188,96.58477783203125],[186.32882690429688,96.63367462158203],[185.94659423828125,96.68572998046875],[185.56507873535156,96.74172973632812],[185.1840057373047,96.80111694335938],[184.80361938476562,96.86450958251953],[184.4237518310547,96.93167877197266],[184.0447540283203,97.00284576416016],[183.66644287109375,97.0782470703125],[183.2890625,97.15760803222656],[182.91265869140625,97.24171447753906],[182.53713989257812,97.33006286621094],[182.162841796875,97.42296600341797],[181.78976440429688,97.52067565917969],[181.41806030273438,97.623291015625],[181.047607421875,97.7309799194336],[180.67892456054688,97.8437271118164],[180.31167602539062,97.96184539794922],[179.94644165039062,98.08541107177734],[179.58285522460938,98.21463012695312],[179.22164916992188,98.34954071044922],[178.862548828125,98.49042510986328],[178.50601196289062,98.63729095458984],[178.15206909179688,98.79048156738281],[177.80087280273438,98.94996643066406],[177.44900512695312,99.10765838623047],[177.096435546875,99.26405334472656],[176.7467498779297,99.4267349243164],[176.39952087402344,99.59444427490234],[176.05422973632812,99.76656341552734],[175.7112579345703,99.94275665283203],[175.37014770507812,100.12273406982422],[175.03094482421875,100.30631256103516],[174.69358825683594,100.49333190917969],[174.35812377929688,100.68368530273438],[174.02471923828125,100.87740325927734],[173.69296264648438,101.07420349121094],[173.36317443847656,101.27417755126953],[173.03517150878906,101.47722625732422],[172.7093048095703,101.68321228027344],[172.38502502441406,101.89213562011719],[172.06283569335938,102.1041030883789],[171.74258422851562,102.31903839111328],[171.42430114746094,102.53678894042969],[171.10792541503906,102.75749969482422],[170.79373168945312,102.98097229003906],[170.48135375976562,103.20738983154297],[170.1711883544922,103.43658447265625],[169.8630828857422,103.66859436035156],[169.55714416503906,103.90331268310547],[169.2533416748047,104.14094543457031],[168.95169067382812,104.38131713867188],[168.65220642089844,104.62445068359375],[168.35519409179688,104.87029266357422],[168.06031799316406,105.1190185546875],[167.76779174804688,105.37042236328125],[167.47772216796875,105.62445068359375],[167.18994140625,105.88130187988281],[166.90469360351562,106.14083862304688],[166.62191772460938,106.40314483642578],[166.34170532226562,106.66815185546875],[166.0640106201172,106.93585205078125],[165.78895568847656,107.20620727539062],[165.51654052734375,107.47929382324219],[165.24688720703125,107.75495147705078],[164.97991943359375,108.03331756591797],[164.7158203125,108.31426239013672],[164.4543914794922,108.59801483154297],[164.19602966308594,108.88418579101562],[163.94039916992188,109.17316436767578],[163.6878662109375,109.46459197998047],[163.43829345703125,109.75865173339844],[163.19180297851562,110.0552749633789],[162.94850158691406,110.3545150756836],[162.70835876464844,110.65621185302734],[162.47132873535156,110.96054077148438],[162.23756408691406,111.26727294921875],[162.00704956054688,111.5765609741211],[161.77981567382812,111.88826751708984],[161.55606079101562,112.20234680175781],[161.3357696533203,112.51897430419922],[161.1190185546875,112.83783721923828],[160.9055938720703,113.15921783447266],[160.6957550048828,113.4827880859375],[160.48956298828125,113.80870056152344],[160.28712463378906,114.13693237304688],[160.08822631835938,114.46747589111328],[159.89308166503906,114.80001831054688],[159.7016143798828,115.13491821289062],[159.51416015625,115.47193908691406],[159.33041381835938,115.81100463867188],[159.15045166015625,116.15206909179688],[158.9745635986328,116.49539947509766],[158.80258178710938,116.84059143066406],[158.6343994140625,117.18773651123047],[158.47039794921875,117.5367431640625],[158.31044006347656,117.8876724243164],[158.15438842773438,118.24032592773438],[158.00253295898438,118.59492492675781],[157.8548126220703,118.95115661621094],[157.7109832763672,119.30896759033203],[157.57144165039062,119.66864013671875],[157.43614196777344,120.02970886230469],[157.30494689941406,120.3924560546875],[157.17794799804688,120.75664520263672],[157.05514526367188,121.12223815917969],[156.9366455078125,121.48917388916016],[156.82232666015625,121.85762786865234],[156.7122344970703,122.22718811035156],[156.60635375976562,122.59813690185547],[156.5047607421875,122.97005462646484],[156.40736389160156,123.34331512451172],[156.314208984375,123.71752166748047],[156.2252655029297,124.09292602539062],[156.14059448242188,124.46914672851562],[156.0601348876953,124.84630584716797],[155.98390197753906,125.2243881225586],[155.911865234375,125.603271484375],[155.84402465820312,125.98294830322266],[155.78033447265625,126.36341857910156],[155.72080993652344,126.74433135986328],[155.6654052734375,127.12613677978516],[155.61410522460938,127.50838470458984],[155.56695556640625,127.89111328125],[155.52389526367188,128.2744140625],[155.48489379882812,128.65814208984375],[155.4499053955078,129.0421905517578],[155.4188690185547,129.42657470703125],[155.39183044433594,129.8113555908203],[155.36880493164062,130.1963653564453],[155.34963989257812,130.58164978027344],[155.33432006835938,130.96693420410156],[155.32293701171875,131.3524932861328],[155.3153533935547,131.7379913330078],[155.31149291992188,132.12374877929688],[155.31149291992188,132.50936889648438],[155.31512451171875,132.8951416015625],[155.32244873046875,133.28070068359375],[155.3334503173828,133.6661834716797],[155.3479766845703,134.05154418945312],[155.3662109375,134.4368438720703],[155.40484619140625,134.82044982910156],[155.45582580566406,135.2027587890625],[155.5129852294922,135.58409118652344],[155.57540893554688,135.96473693847656],[155.64230346679688,136.3446807861328],[155.71348571777344,136.72366333007812],[155.78860473632812,137.1019744873047],[155.86744689941406,137.47947692871094],[155.94985961914062,137.85633850097656],[156.03599548339844,138.2322235107422],[156.1254425048828,138.6074676513672],[156.2180633544922,138.98175048828125],[156.31417846679688,139.3553009033203],[156.41323852539062,139.72796630859375],[156.51568603515625,140.0999298095703],[156.62109375,140.47079467773438],[156.72943115234375,140.84100341796875],[156.8411102294922,141.21014404296875],[156.95565795898438,141.5784454345703],[157.0729522705078,141.9458465576172],[157.193359375,142.312255859375],[157.31674194335938,142.6776580810547],[157.44293212890625,143.0421142578125],[157.57212829589844,143.405517578125],[157.70413208007812,143.76788330078125],[157.83901977539062,144.1293487548828],[157.97665405273438,144.489501953125],[158.1172637939453,144.8487091064453],[158.2606201171875,145.20672607421875],[158.4067840576172,145.56370544433594],[158.55572509765625,145.91941833496094],[158.70748901367188,146.2740478515625],[158.86195373535156,146.6272735595703],[159.01927185058594,146.9794921875],[159.17933654785156,147.33041381835938],[159.3422088623047,147.68003845214844],[159.50779724121094,148.02835083007812],[159.68142700195312,148.3726043701172],[159.86431884765625,148.71209716796875],[160.04727172851562,149.05169677734375],[160.23016357421875,149.39117431640625],[160.41311645507812,149.73077392578125],[160.59600830078125,150.0702667236328],[160.77894592285156,150.4098663330078],[160.9618377685547,150.74935913085938],[161.144775390625,151.08895874023438],[161.32766723632812,151.42845153808594],[161.5106201171875,151.76805114746094],[161.69357299804688,152.10765075683594],[161.87646484375,152.4471435546875],[162.0594024658203,152.7867431640625],[162.24229431152344,153.126220703125],[162.4252471923828,153.4658203125],[162.60812377929688,153.80532836914062],[162.79107666015625,154.14491271972656],[162.97396850585938,154.48440551757812],[163.15692138671875,154.82400512695312],[163.33981323242188,155.1634979248047],[163.5227508544922,155.5030975341797],[163.7056427001953,155.84259033203125],[163.8885955810547,156.18218994140625],[164.07147216796875,156.5216827392578],[164.25442504882812,156.8612823486328],[164.43731689453125,157.20077514648438],[164.62026977539062,157.54037475585938],[164.80316162109375,157.87985229492188],[164.98609924316406,158.21945190429688],[165.1689910888672,158.55894470214844],[165.35194396972656,158.89854431152344],[165.53488159179688,159.23814392089844],[165.7177734375,159.57763671875],[165.90072631835938,159.917236328125],[166.0836181640625,160.25672912597656],[166.2665557861328,160.59632873535156],[166.44944763183594,160.93582153320312],[166.6324005126953,161.27542114257812],[166.81529235839844,161.61489868164062],[166.99822998046875,161.95449829101562],[167.18112182617188,162.2939910888672],[167.36407470703125,162.6335906982422],[167.54696655273438,162.97308349609375],[167.7299041748047,163.31268310546875],[167.9127960205078,163.6521759033203],[168.0957489013672,163.9917755126953],[168.2786407470703,164.33126831054688],[168.46157836914062,164.67086791992188],[168.64447021484375,165.01036071777344],[168.82742309570312,165.34994506835938],[169.01031494140625,165.689453125],[169.19325256347656,166.029052734375],[169.3761444091797,166.3685302734375],[169.55909729003906,166.7081298828125],[169.74203491210938,167.0477294921875],[169.9249267578125,167.38722229003906],[170.10787963867188,167.72682189941406],[170.290771484375,168.06631469726562],[170.4737091064453,168.40591430664062],[170.65660095214844,168.7454071044922],[170.8395538330078,169.0850067138672],[171.02244567871094,169.42449951171875],[171.20538330078125,169.76409912109375],[171.38827514648438,170.10357666015625],[171.57122802734375,170.44317626953125],[171.75411987304688,170.7826690673828],[171.9370574951172,171.1222686767578],[172.1199493408203,171.46176147460938],[172.3029022216797,171.80136108398438],[172.4857940673828,172.14085388183594],[172.66873168945312,172.48045349121094],[172.85162353515625,172.8199462890625],[173.03457641601562,173.1595458984375],[173.21746826171875,173.4990234375],[173.40040588378906,173.838623046875],[173.58335876464844,174.17822265625],[173.76625061035156,174.51771545410156],[173.94918823242188,174.85731506347656],[174.132080078125,175.19680786132812],[174.31503295898438,175.53640747070312],[174.4979248046875,175.8759002685547],[174.68087768554688,176.2154998779297],[174.86375427246094,176.55499267578125],[175.0467071533203,176.89459228515625],[175.22959899902344,177.2340850830078],[175.41253662109375,177.57366943359375],[175.59542846679688,177.91317749023438],[175.77838134765625,178.25277709960938],[175.96127319335938,178.59225463867188],[176.14422607421875,178.93185424804688],[176.3271026611328,179.27134704589844],[176.5100555419922,179.61094665527344],[176.6929473876953,179.950439453125],[176.87588500976562,180.2900390625],[177.05877685546875,180.62953186035156],[177.24172973632812,180.96913146972656],[177.42462158203125,181.30862426757812],[177.60757446289062,181.64822387695312],[177.79051208496094,181.98782348632812],[177.97340393066406,182.32730102539062],[178.15635681152344,182.66690063476562],[178.3392333984375,183.0063934326172],[178.52218627929688,183.3459930419922],[178.705078125,183.68548583984375],[178.88803100585938,184.02508544921875],[179.0709228515625,184.3645782470703],[179.2538604736328,184.7041778564453],[179.43675231933594,185.04367065429688],[179.6197052001953,185.38327026367188],[179.80258178710938,185.72276306152344],[179.98553466796875,186.06234741210938],[180.16842651367188,186.40185546875],[180.35137939453125,186.74143981933594],[180.53427124023438,187.0809326171875],[180.7172088623047,187.4205322265625],[180.9001007080078,187.76002502441406],[181.0830535888672,188.09962463378906],[181.26593017578125,188.43911743164062],[181.44888305664062,188.77871704101562],[181.63177490234375,189.1182098388672],[181.81472778320312,189.4578094482422],[181.99766540527344,189.7974090576172],[182.18055725097656,190.13690185546875],[182.36351013183594,190.47650146484375],[182.54640197753906,190.81597900390625],[182.72933959960938,191.15557861328125],[182.9122314453125,191.4950714111328],[183.09518432617188,191.8346710205078],[183.278076171875,192.17416381835938],[183.4610137939453,192.51376342773438],[183.64390563964844,192.85325622558594],[183.8268585205078,193.19285583496094],[184.00975036621094,193.5323486328125],[184.19268798828125,193.8719482421875],[184.37557983398438,194.21142578125],[184.55853271484375,194.551025390625],[184.74142456054688,194.89051818847656],[184.9243621826172,195.23011779785156],[185.1072540283203,195.56961059570312],[185.2902069091797,195.90921020507812],[185.4730987548828,196.2487030029297],[185.65603637695312,196.5883026123047],[185.8389892578125,196.9279022216797],[186.02188110351562,197.26739501953125],[186.20481872558594,197.60699462890625],[186.38771057128906,197.9464874267578],[186.57066345214844,198.2860870361328],[186.75355529785156,198.62557983398438],[186.93649291992188,198.9651641845703],[187.119384765625,199.30465698242188],[187.30233764648438,199.64425659179688],[187.4852294921875,199.98374938964844],[187.6681671142578,200.32334899902344],[187.85105895996094,200.662841796875],[188.0340118408203,201.00244140625],[188.21690368652344,201.34193420410156],[188.39984130859375,201.68153381347656],[188.58273315429688,202.02102661132812],[188.76568603515625,202.36062622070312],[188.94857788085938,202.70010375976562],[189.1315155029297,203.03970336914062],[189.3144073486328,203.3791961669922],[189.4973602294922,203.7187957763672],[189.6802520751953,204.05828857421875],[189.86318969726562,204.39788818359375],[190.046142578125,204.73748779296875],[190.22903442382812,205.0769805908203],[190.41197204589844,205.4165802001953],[190.59486389160156,205.75607299804688],[190.77781677246094,206.09567260742188],[190.96070861816406,206.43516540527344],[191.14364624023438,206.77476501464844],[191.3265380859375,207.11424255371094],[191.50949096679688,207.45384216308594],[191.6923828125,207.7933349609375],[191.8753204345703,208.1329345703125],[192.05821228027344,208.47242736816406],[192.2411651611328,208.81202697753906],[192.42405700683594,209.15151977539062],[192.60699462890625,209.49111938476562],[192.78988647460938,209.8306121826172],[192.97283935546875,210.1702117919922],[193.15573120117188,210.50970458984375],[193.3386688232422,210.84930419921875],[193.5215606689453,211.18878173828125],[193.70626831054688,211.52711486816406],[193.96726989746094,211.81126403808594],[194.23382568359375,212.0897674560547],[194.50491333007812,212.36427307128906],[194.77947998046875,212.6349639892578],[195.05743408203125,212.90255737304688],[195.338134765625,213.1668243408203],[195.62181091308594,213.42832946777344],[195.90789794921875,213.68673706054688],[196.19686889648438,213.9422607421875],[196.4881134033203,214.19512939453125],[196.7819366455078,214.44505310058594],[197.0778045654297,214.69235229492188],[197.3762664794922,214.9366912841797],[197.6767120361328,215.17835998535156],[197.9794921875,215.41748046875],[198.284423828125,215.6534881591797],[198.59149169921875,215.88690185546875],[198.90052795410156,216.11758422851562],[199.2116241455078,216.3456268310547],[199.52481079101562,216.57057189941406],[199.8401641845703,216.79281616210938],[200.15724182128906,217.01211547851562],[200.4765167236328,217.22869873046875],[200.7977752685547,217.44223022460938],[201.12081909179688,217.65280151367188],[201.44580078125,217.86045837402344],[201.772705078125,218.0651397705078],[202.1014404296875,218.2667999267578],[202.43203735351562,218.46536254882812],[202.76458740234375,218.6609344482422],[203.0987548828125,218.85325622558594],[203.4348907470703,219.04251098632812],[203.77272033691406,219.22850036621094],[204.11241149902344,219.41134643554688],[204.4536895751953,219.59083557128906],[204.79678344726562,219.76705932617188],[205.14149475097656,219.93991088867188],[205.4879608154297,220.1094512939453],[205.8360595703125,220.2754364013672],[206.18582153320312,220.43792724609375],[206.5372314453125,220.5969696044922],[206.8902130126953,220.7524871826172],[207.24456787109375,220.90440368652344],[207.60069274902344,221.05271911621094],[207.95831298828125,221.1972198486328],[208.31736755371094,221.33804321289062],[208.67784118652344,221.47518920898438],[209.0397491455078,221.60855102539062],[209.40309143066406,221.7378692626953],[209.76771545410156,221.86338806152344],[210.1337890625,221.9851531982422],[210.50096130371094,222.10269165039062],[210.86962890625,222.21629333496094],[211.2393798828125,222.32595825195312],[211.61033630371094,222.4314422607422],[211.98239135742188,222.53271484375],[212.3556365966797,222.6300506591797],[212.72998046875,222.7230224609375],[213.1053009033203,222.81175231933594],[213.48155212402344,222.89645385742188],[213.85879516601562,222.97650146484375],[214.2369384765625,223.05242919921875],[214.6160125732422,223.1240234375],[214.99566650390625,223.19102478027344],[215.37623596191406,223.2539825439453],[215.75747680664062,223.3120880126953],[216.13941955566406,223.36599731445312],[216.52197265625,223.41531372070312],[216.90501403808594,223.4601287841797],[217.28860473632812,223.50051879882812],[217.67257690429688,223.5362091064453],[218.05711364746094,223.56756591796875],[218.44178771972656,223.5940704345703],[218.8268280029297,223.61630249023438],[219.2120819091797,223.63365173339844],[219.5976104736328,223.64674377441406],[219.98313903808594,223.6549072265625],[220.368896484375,223.6587677001953],[220.75445556640625,223.65777587890625],[221.14010620117188,223.65240478515625],[221.5255889892578,223.642333984375],[221.9111328125,223.62771606445312],[222.29620361328125,223.60861206054688],[222.6811981201172,223.58474731445312],[223.06578063964844,223.55673217773438],[223.4501953125,223.52389526367188],[223.83395385742188,223.48646545410156],[224.2174072265625,223.44476318359375],[224.60025024414062,223.39854431152344],[224.98272705078125,223.34786987304688],[225.36444091796875,223.29269409179688],[225.7454071044922,223.2332000732422],[226.12588500976562,223.1693572998047],[226.50546264648438,223.10118103027344],[226.88424682617188,223.0286865234375],[227.26222229003906,222.95199584960938],[227.63937377929688,222.87103271484375],[228.01547241210938,222.785888671875],[228.39071655273438,222.69667053222656],[228.76478576660156,222.60328674316406],[229.1381072998047,222.50582885742188],[229.51011657714844,222.40435791015625],[229.881103515625,222.2989044189453],[230.2509307861328,222.18959045410156],[230.61962890625,222.07626342773438],[230.98704528808594,221.959228515625],[231.3533477783203,221.83828735351562],[231.71823120117188,221.71368408203125],[232.08201599121094,221.58529663085938],[232.44432067871094,221.4533233642578],[232.80551147460938,221.31773376464844],[233.16526794433594,221.17848205566406],[233.52346801757812,221.03591918945312],[233.88055419921875,220.88973999023438],[234.23594665527344,220.74020385742188],[234.59007263183594,220.58734130859375],[234.9427032470703,220.43116760253906],[235.29388427734375,220.27166748046875],[235.64352416992188,220.10906982421875],[235.9918975830078,219.94326782226562],[236.3384552001953,219.77432250976562],[236.68373107910156,219.60227966308594],[237.0273895263672,219.4272918701172],[237.36964416503906,219.2493438720703],[237.71018981933594,219.06851196289062],[238.0492706298828,218.88473510742188],[238.3867645263672,218.6981658935547],[238.7228240966797,218.5087890625],[239.05731201171875,218.31671142578125],[239.3901824951172,218.1219940185547],[239.7214813232422,217.92465209960938],[240.05140686035156,217.72459411621094],[240.3795166015625,217.52212524414062],[240.70620727539062,217.31704711914062],[241.03134155273438,217.10951232910156],[241.32252502441406,216.86065673828125],[241.58924865722656,216.58200073242188],[241.85589599609375,216.3034210205078],[242.12261962890625,216.02474975585938],[242.38925170898438,215.7461700439453],[242.65597534179688,215.46751403808594],[242.92262268066406,215.18893432617188],[243.18934631347656,214.91026306152344],[243.45599365234375,214.63168334960938],[243.72271728515625,214.35302734375],[243.98936462402344,214.07444763183594],[244.25608825683594,213.79579162597656],[244.52273559570312,213.5172119140625],[244.78945922851562,213.23854064941406],[245.05609130859375,212.9599609375],[245.3228302001953,212.68130493164062],[245.58946228027344,212.40272521972656],[245.856201171875,212.12405395507812],[246.12283325195312,211.84548950195312],[246.38955688476562,211.5668182373047],[246.65628051757812,211.2881622314453],[246.9229278564453,211.00958251953125],[247.1896514892578,210.7309112548828],[247.456298828125,210.45233154296875],[247.7230224609375,210.17367553710938],[247.9896697998047,209.8950958251953],[248.2563934326172,209.61642456054688],[248.52304077148438,209.33786010742188],[248.78976440429688,209.05918884277344],[249.05641174316406,208.78060913085938],[249.32313537597656,208.501953125],[249.5897674560547,208.22337341308594],[249.85650634765625,207.9447021484375],[250.12313842773438,207.6661376953125],[250.38986206054688,207.38746643066406],[250.65650939941406,207.10888671875],[250.92323303222656,206.83023071289062],[251.18988037109375,206.55165100097656],[251.45660400390625,206.27297973632812],[251.72325134277344,205.99441528320312],[251.98997497558594,205.7157440185547],[252.25662231445312,205.43716430664062],[252.52334594726562,205.15850830078125],[252.79006958007812,204.8798370361328],[253.0567169189453,204.60125732421875],[253.3234405517578,204.32260131835938],[253.590087890625,204.0440216064453],[253.8568115234375,203.76535034179688],[254.12344360351562,203.48678588867188],[254.39016723632812,203.20811462402344],[254.6568145751953,202.92953491210938],[254.9235382080078,202.65087890625],[255.190185546875,202.37229919433594],[255.4569091796875,202.0936279296875],[255.7235565185547,201.8150634765625],[255.9902801513672,201.53639221191406],[256.2569274902344,201.2578125],[256.5236511230469,200.97915649414062],[256.790283203125,200.70057678222656],[257.0570068359375,200.42190551757812],[257.32366943359375,200.14332580566406],[257.59039306640625,199.8646697998047],[257.8570251464844,199.58609008789062],[258.1237487792969,199.3074188232422],[258.3904724121094,199.0287628173828],[258.6571350097656,198.75018310546875],[258.9238586425781,198.47152709960938],[259.19049072265625,198.1929473876953],[259.45721435546875,197.91427612304688],[259.7238464355469,197.6356964111328],[259.9906005859375,197.35704040527344],[260.2572326660156,197.07846069335938],[260.5239562988281,196.79978942871094],[260.79058837890625,196.52122497558594],[261.05731201171875,196.2425537109375],[261.323974609375,195.96397399902344],[261.5906982421875,195.68531799316406],[261.8573303222656,195.40673828125],[262.1240539550781,195.12806701660156],[262.3907165527344,194.84950256347656],[262.6574401855469,194.57083129882812],[262.924072265625,194.29225158691406],[263.1907958984375,194.0135955810547],[263.4574279785156,193.73501586914062],[263.72418212890625,193.4563446044922],[263.9908142089844,193.17776489257812],[264.2575378417969,192.89910888671875],[264.5242614746094,192.6204376220703],[264.7908935546875,192.34185791015625],[265.0576171875,192.06320190429688],[265.32427978515625,191.7846221923828],[265.59100341796875,191.50596618652344],[265.8576354980469,191.22738647460938],[266.1243591308594,190.94871520996094],[266.3910217285156,190.67013549804688],[266.6577453613281,190.3914794921875],[266.92437744140625,190.11289978027344],[267.19110107421875,189.834228515625],[267.4577331542969,189.5556640625],[267.7244873046875,189.27699279785156],[267.9911193847656,188.9984130859375],[268.2578430175781,188.71975708007812],[268.52447509765625,188.44117736816406],[268.79119873046875,188.16250610351562],[269.057861328125,187.88394165039062],[269.3245849609375,187.6052703857422],[269.5912170410156,187.32669067382812],[269.8579406738281,187.04803466796875],[270.1246643066406,186.7693634033203],[270.3913269042969,186.49078369140625],[270.6580505371094,186.21212768554688],[270.9246826171875,185.9335479736328],[271.19140625,185.65487670898438],[271.4580383300781,185.37631225585938],[271.72479248046875,185.09764099121094],[271.9914245605469,184.81906127929688],[272.2581481933594,184.5404052734375],[272.5247802734375,184.26182556152344],[272.79150390625,183.983154296875],[273.05816650390625,183.70458984375],[273.32489013671875,183.42591857910156],[273.5915222167969,183.1473388671875],[273.8582458496094,182.86868286132812],[274.1249084472656,182.59010314941406],[274.3916320800781,182.31143188476562],[274.694091796875,182.074462890625],[275.01202392578125,181.8558807373047],[275.33209228515625,181.6408233642578],[275.654052734375,181.42845153808594],[275.9775390625,181.2186279296875],[276.3026428222656,181.01083374023438],[276.6289367675781,180.80520629882812],[276.95648193359375,180.60165405273438],[277.2853088378906,180.40003967285156],[277.6152648925781,180.20034790039062],[277.9463806152344,180.00250244140625],[278.2784423828125,179.80648803710938],[278.6116027832031,179.61207580566406],[278.94561767578125,179.41934204101562],[279.2806701660156,179.22816467285156],[279.61663818359375,179.03897094726562],[279.9536437988281,178.85121154785156],[280.2914733886719,178.66529846191406],[280.6302795410156,178.48089599609375],[280.9698181152344,178.29811096191406],[281.3103942871094,178.11703491210938],[281.6516418457031,177.93753051757812],[281.993896484375,177.75942993164062],[282.33685302734375,177.58314514160156],[282.6806945800781,177.4084014892578],[283.02520751953125,177.2352294921875],[283.37060546875,177.0635223388672],[283.7167053222656,176.8934783935547],[284.063720703125,176.72503662109375],[284.4115905761719,176.55813598632812],[284.75994873046875,176.39288330078125],[285.10919189453125,176.22914123535156],[285.4591064453125,176.06700134277344],[285.8097839355469,175.90638732910156],[286.1611022949219,175.7473907470703],[286.51324462890625,175.58995056152344],[286.8660583496094,175.4342041015625],[287.2196960449219,175.28005981445312],[287.5738830566406,175.12753295898438],[287.9288330078125,174.97657775878906],[288.2843017578125,174.8273162841797],[288.640625,174.67958068847656],[288.9975280761719,174.53350830078125],[289.35516357421875,174.38902282714844],[289.71337890625,174.24623107910156],[290.0723571777344,174.10501098632812],[290.431884765625,173.9654998779297],[290.79217529296875,173.82757568359375],[291.1528625488281,173.69140625],[291.514404296875,173.5568389892578],[291.8765563964844,173.42396545410156],[292.23919677734375,173.2929229736328],[292.6026611328125,173.16351318359375],[292.96649169921875,173.03585815429688],[293.33111572265625,172.90988159179688],[293.6961364746094,172.7856903076172],[294.0618896484375,172.66314697265625],[294.4281311035156,172.54238891601562],[294.7950744628906,172.42332458496094],[295.162353515625,172.30606079101562],[295.5303649902344,172.1905059814453],[295.8988952636719,172.0767059326172],[296.2680358886719,171.96484375],[296.6376037597656,171.85487365722656],[297.00787353515625,171.7466583251953],[297.3785400390625,171.6402587890625],[297.7497863769531,171.53562927246094],[298.12152099609375,171.43283081054688],[298.49371337890625,171.33181762695312],[298.86639404296875,171.232666015625],[299.23974609375,171.13568115234375],[299.6134948730469,171.04052734375],[299.9876708984375,170.94723510742188],[300.3625183105469,170.8557586669922],[300.73748779296875,170.7661895751953],[301.1131286621094,170.67845153808594],[301.4891357421875,170.59291076660156],[301.8657531738281,170.50936889648438],[302.24261474609375,170.42776489257812],[302.62005615234375,170.3480224609375],[302.9977722167969,170.2700653076172],[303.3758850097656,170.1942901611328],[303.7544250488281,170.1207275390625],[304.13348388671875,170.0490264892578],[304.5127868652344,169.97940063476562],[304.8925476074219,169.9119110107422],[305.2725524902344,169.84637451171875],[305.65301513671875,169.7830047607422],[306.03375244140625,169.72169494628906],[306.4149475097656,169.6624298095703],[306.7963562011719,169.6053924560547],[307.1781311035156,169.5503692626953],[307.5601501464844,169.49757385253906],[307.9425048828125,169.44688415527344],[308.3252258300781,169.3983154296875],[308.7079772949219,169.35202026367188],[309.0911560058594,169.30776977539062],[309.4745788574219,169.26589965820312],[309.8582458496094,169.22605895996094],[310.24200439453125,169.1885986328125],[310.6261291503906,169.15322875976562],[311.0103454589844,169.1201934814453],[311.3948059082031,169.08938598632812],[311.7794189453125,169.06080627441406],[312.16448974609375,169.04017639160156],[312.55010986328125,169.04104614257812],[312.93585205078125,169.04190063476562],[313.32147216796875,169.04275512695312],[313.70721435546875,169.0436248779297],[314.09283447265625,169.0444793701172],[314.47857666015625,169.0453338623047],[314.86419677734375,169.04620361328125],[315.24993896484375,169.04705810546875],[315.63555908203125,169.04791259765625],[316.02130126953125,169.0487823486328],[316.40692138671875,169.0496368408203],[316.7926330566406,169.0504913330078],[317.1783752441406,169.05136108398438],[317.5639953613281,169.05221557617188],[317.9497375488281,169.05307006835938],[318.3353576660156,169.05392456054688],[318.7210998535156,169.05479431152344],[319.1067199707031,169.05564880371094],[319.4924621582031,169.05650329589844],[319.8780822753906,169.057373046875],[320.2638244628906,169.0582275390625],[320.6494445800781,169.05908203125],[321.0351867675781,169.05995178222656],[321.4208068847656,169.06080627441406],[321.8065490722656,169.06166076660156],[322.1921691894531,169.06253051757812],[322.5779113769531,169.06338500976562],[322.9635009765625,169.06423950195312],[323.3492431640625,169.0651092529297],[323.73486328125,169.0659637451172],[324.12060546875,169.0668182373047],[324.5062255859375,169.06768798828125],[324.8919677734375,169.06854248046875],[325.2777099609375,169.06939697265625],[325.663330078125,169.0702667236328],[326.049072265625,169.0711212158203],[326.4346923828125,169.0719757080078],[326.8204345703125,169.07284545898438],[327.2060546875,169.07369995117188],[327.591796875,169.07455444335938],[327.9774169921875,169.07542419433594],[328.3631591796875,169.07627868652344],[328.748779296875,169.07713317871094],[329.134521484375,169.0780029296875],[329.5201416015625,169.078857421875],[329.9058837890625,169.0797119140625],[330.29150390625,169.08058166503906],[330.67724609375,169.08143615722656],[331.0628662109375,169.08229064941406],[331.4486083984375,169.08314514160156],[331.834228515625,169.08401489257812],[332.219970703125,169.08486938476562],[332.6055908203125,169.08572387695312],[332.9913330078125,169.0865936279297],[333.376953125,169.0874481201172],[333.7626953125,169.0883026123047],[334.1484375,169.08917236328125],[334.5340576171875,169.09002685546875],[334.9197998046875,169.09088134765625],[335.305419921875,169.0917510986328],[335.691162109375,169.0926055908203],[336.0767822265625,169.0934600830078],[336.4625244140625,169.09432983398438],[336.84814453125,169.09518432617188],[337.23388671875,169.09603881835938],[337.6195068359375,169.09690856933594],[338.0052490234375,169.09776306152344],[338.390869140625,169.09861755371094],[338.776611328125,169.0994873046875],[339.1622314453125,169.100341796875],[339.5479736328125,169.1011962890625],[339.93359375,169.10206604003906],[340.3193359375,169.10292053222656],[340.7049560546875,169.10377502441406],[341.0906677246094,169.10464477539062],[341.4762878417969,169.10549926757812],[341.8620300292969,169.10635375976562],[342.2476501464844,169.1072235107422],[342.6333923339844,169.1080780029297],[343.0191345214844,169.1089324951172],[343.4047546386719,169.1097869873047],[343.7904968261719,169.11065673828125],[344.1761169433594,169.11151123046875],[344.5618591308594,169.11236572265625],[344.9474792480469,169.1132354736328],[345.3332214355469,169.1140899658203],[345.7188415527344,169.1149444580078],[346.1045837402344,169.11581420898438],[346.4902038574219,169.11666870117188],[346.8759460449219,169.11752319335938],[347.26153564453125,169.11839294433594],[347.64727783203125,169.11924743652344],[348.03289794921875,169.12010192871094],[348.41864013671875,169.1209716796875],[348.80426025390625,169.121826171875],[349.19000244140625,169.1226806640625],[349.57562255859375,169.12355041503906],[349.96136474609375,169.12440490722656],[350.34698486328125,169.12525939941406],[350.73272705078125,169.12612915039062],[351.11846923828125,169.12698364257812],[351.50408935546875,169.12783813476562],[351.88983154296875,169.1287078857422],[352.27545166015625,169.1295623779297],[352.66119384765625,169.1304168701172],[353.04681396484375,169.13128662109375],[353.43255615234375,169.13214111328125],[353.81817626953125,169.13299560546875],[354.20391845703125,169.1338653564453],[354.58953857421875,169.1347198486328],[354.97528076171875,169.1355743408203],[355.36090087890625,169.1364288330078],[355.74664306640625,169.13729858398438],[356.13226318359375,169.13815307617188],[356.51800537109375,169.13900756835938],[356.90362548828125,169.13987731933594],[357.28936767578125,169.14073181152344],[357.67498779296875,169.14158630371094],[358.06072998046875,169.1424560546875],[358.44635009765625,169.143310546875],[358.83209228515625,169.1441650390625],[359.21771240234375,169.14503479003906],[359.60345458984375,169.14588928222656],[359.98919677734375,169.14674377441406],[360.37481689453125,169.14761352539062],[360.76055908203125,169.14846801757812],[361.14617919921875,169.14932250976562],[361.53192138671875,169.1501922607422],[361.91754150390625,169.1510467529297],[362.30328369140625,169.1519012451172],[362.68890380859375,169.15277099609375],[363.07464599609375,169.15362548828125],[363.46026611328125,169.15447998046875],[363.8459777832031,169.1553497314453],[364.2315979003906,169.1562042236328],[364.6173400878906,169.1570587158203],[365.0029602050781,169.15792846679688],[365.3887023925781,169.15878295898438],[365.7743225097656,169.15963745117188],[366.1600646972656,169.16050720214844],[366.5456848144531,169.16136169433594],[366.9314270019531,169.16221618652344],[367.3170471191406,169.1630859375],[367.7027893066406,169.1639404296875],[368.0885314941406,169.164794921875],[368.4741516113281,169.1656494140625],[368.8598937988281,169.16651916503906],[369.2455139160156,169.16737365722656],[369.6312561035156,169.16822814941406],[370.0168762207031,169.16909790039062],[370.4026184082031,169.16995239257812],[370.7882385253906,169.17080688476562],[371.1739807128906,169.1716766357422],[371.5596008300781,169.1725311279297],[371.9453430175781,169.1733856201172],[372.3309631347656,169.17425537109375],[372.7167053222656,169.17510986328125],[373.102294921875,169.17596435546875],[373.488037109375,169.1768341064453],[373.8736572265625,169.1776885986328],[374.2593994140625,169.1785430908203],[374.64501953125,169.17941284179688],[375.03076171875,169.18026733398438],[375.4163818359375,169.18112182617188],[375.8021240234375,169.18199157714844],[376.187744140625,169.18284606933594],[376.573486328125,169.18370056152344],[376.959228515625,169.1845703125],[377.3448486328125,169.1854248046875],[377.7305908203125,169.186279296875],[378.1162109375,169.18714904785156],[378.501953125,169.18800354003906],[378.8875732421875,169.18885803222656],[379.2733154296875,169.18972778320312],[379.658935546875,169.19058227539062],[380.044677734375,169.19143676757812],[380.4302978515625,169.19229125976562],[380.8160400390625,169.1931610107422],[381.20166015625,169.1940155029297],[381.58740234375,169.1948699951172],[381.9730224609375,169.19573974609375],[382.3587646484375,169.19659423828125],[382.744384765625,169.19744873046875],[383.130126953125,169.1983184814453],[383.5157470703125,169.1991729736328],[383.9014892578125,169.2000274658203],[384.287109375,169.20089721679688],[384.6728515625,169.20175170898438],[385.05859375,169.20260620117188],[385.4442138671875,169.20347595214844],[385.8299560546875,169.20433044433594],[386.215576171875,169.20518493652344],[386.601318359375,169.2060546875],[386.9869384765625,169.2069091796875],[387.3726806640625,169.207763671875],[387.75830078125,169.20863342285156],[388.14404296875,169.20948791503906],[388.5296325683594,169.21034240722656],[388.9153747558594,169.21121215820312],[389.3009948730469,169.21206665039062],[389.6867370605469,169.21292114257812],[390.0723571777344,169.2137908935547],[390.4580993652344,169.2146453857422],[390.8437194824219,169.2154998779297],[391.2294616699219,169.21636962890625],[391.6150817871094,169.21722412109375],[392.0008239746094,169.21807861328125],[392.3864440917969,169.21893310546875],[392.7721862792969,169.2198028564453],[393.1578063964844,169.2206573486328],[393.5435485839844,169.2215118408203],[393.9292907714844,169.22238159179688],[394.3149108886719,169.22323608398438],[394.7006530761719,169.22409057617188],[395.0862731933594,169.22496032714844],[395.4720153808594,169.22581481933594],[395.8576354980469,169.22666931152344],[396.2433776855469,169.2275390625],[396.6289978027344,169.2283935546875],[397.0147399902344,169.229248046875],[397.40032958984375,169.23011779785156],[397.78607177734375,169.23097229003906],[398.17169189453125,169.23182678222656],[398.55743408203125,169.23269653320312],[398.94305419921875,169.23355102539062],[399.32879638671875,169.23440551757812],[399.71441650390625,169.2352752685547],[400.10015869140625,169.2361297607422],[400.48577880859375,169.2369842529297],[400.87152099609375,169.23785400390625],[401.25714111328125,169.23870849609375],[401.64288330078125,169.23956298828125],[402.02862548828125,169.2404327392578],[402.41424560546875,169.2412872314453],[402.79998779296875,169.2421417236328],[403.18560791015625,169.24301147460938],[403.57135009765625,169.24386596679688],[403.95697021484375,169.24472045898438],[404.34271240234375,169.24559020996094],[404.72833251953125,169.24644470214844],[405.11407470703125,169.24729919433594],[405.49969482421875,169.24815368652344],[405.88543701171875,169.2490234375],[406.27105712890625,169.2498779296875],[406.65679931640625,169.250732421875],[407.04241943359375,169.25160217285156],[407.42816162109375,169.25245666503906],[407.81378173828125,169.25331115722656],[408.19952392578125,169.25418090820312],[408.58514404296875,169.25503540039062],[408.97088623046875,169.25588989257812],[409.35650634765625,169.2567596435547],[409.74224853515625,169.2576141357422],[410.12786865234375,169.2584686279297],[410.51361083984375,169.25933837890625],[410.89935302734375,169.26019287109375],[411.28497314453125,169.26104736328125],[411.67071533203125,169.2619171142578],[412.05633544921875,169.2627716064453],[412.44207763671875,169.2636260986328],[412.8276672363281,169.26449584960938],[413.2134094238281,169.26535034179688],[413.5990295410156,169.26620483398438],[413.9847717285156,169.26707458496094],[414.3703918457031,169.26792907714844],[414.7561340332031,169.26878356933594],[415.1417541503906,169.2696533203125],[415.5274963378906,169.2705078125],[415.9131164550781,169.2713623046875],[416.2988586425781,169.27223205566406],[416.6844787597656,169.27308654785156],[417.0702209472656,169.27394104003906],[417.4558410644531,169.27479553222656],[417.8415832519531,169.27566528320312],[418.2272033691406,169.27651977539062],[418.6129455566406,169.27737426757812],[418.9985656738281,169.2782440185547],[419.3843078613281,169.2790985107422],[419.7700500488281,169.2799530029297],[420.1556701660156,169.28082275390625],[420.5414123535156,169.28167724609375],[420.9270324707031,169.28253173828125],[421.3127746582031,169.2834014892578],[421.6983947753906,169.2842559814453],[422.0841369628906,169.2851104736328],[422.4697570800781,169.28598022460938],[422.85546875,169.28683471679688],[423.2410888671875,169.28768920898438],[423.6268310546875,169.28855895996094],[424.012451171875,169.28941345214844],[424.398193359375,169.29026794433594],[424.7838134765625,169.2911376953125],[425.1695556640625,169.2919921875],[425.55517578125,169.2928466796875],[425.94091796875,169.29371643066406],[426.3265380859375,169.29457092285156],[426.7122802734375,169.29542541503906],[427.097900390625,169.29629516601562],[427.483642578125,169.29714965820312],[427.869384765625,169.29800415039062],[428.2550048828125,169.2988739013672],[428.6407470703125,169.2997283935547],[429.0263671875,169.3005828857422],[429.412109375,169.30145263671875],[429.7977294921875,169.30230712890625],[430.1834716796875,169.30316162109375],[430.569091796875,169.30401611328125],[430.954833984375,169.3048858642578],[431.3404541015625,169.3057403564453],[431.7261962890625,169.3065948486328],[432.11181640625,169.30746459960938],[432.49755859375,169.30831909179688],[432.8831787109375,169.30917358398438],[433.2689208984375,169.31004333496094],[433.654541015625,169.31089782714844],[434.040283203125,169.31175231933594],[434.4259033203125,169.3126220703125],[434.8116455078125,169.3134765625],[435.197265625,169.3143310546875],[435.5830078125,169.31520080566406],[435.9686279296875,169.31605529785156],[436.3543395996094,169.31690979003906],[436.7400817871094,169.31777954101562],[437.1257019042969,169.31863403320312],[437.5114440917969,169.31948852539062],[437.8970642089844,169.3203582763672],[438.2828063964844,169.3212127685547],[438.6684265136719,169.3220672607422],[439.0541687011719,169.32293701171875],[439.4397888183594,169.32379150390625],[439.8255310058594,169.32464599609375],[440.2111511230469,169.3255157470703],[440.5968933105469,169.3263702392578],[440.9825134277344,169.3272247314453],[441.3682556152344,169.32809448242188],[441.7538757324219,169.32894897460938],[442.1396179199219,169.32980346679688],[442.5252380371094,169.33065795898438],[442.9109802246094,169.33152770996094],[443.2966003417969,169.33238220214844],[443.6823425292969,169.33323669433594],[444.0679626464844,169.3341064453125],[444.4537048339844,169.3349609375],[444.8394470214844,169.3358154296875],[445.2250671386719,169.33668518066406],[445.6108093261719,169.33753967285156],[445.9964294433594,169.33839416503906],[446.3821716308594,169.33926391601562],[446.7677917480469,169.34011840820312],[447.1535339355469,169.34097290039062],[447.53912353515625,169.3418426513672],[447.92486572265625,169.3426971435547],[448.31048583984375,169.3435516357422],[448.69622802734375,169.34442138671875],[449.08184814453125,169.34527587890625],[449.46759033203125,169.34613037109375],[449.85321044921875,169.3470001220703],[450.23895263671875,169.3478546142578],[450.62457275390625,169.3487091064453],[451.01031494140625,169.34957885742188],[451.39593505859375,169.35043334960938],[451.78167724609375,169.35128784179688],[452.16729736328125,169.35215759277344],[452.55303955078125,169.35301208496094],[452.93865966796875,169.35386657714844],[453.32440185546875,169.354736328125],[453.71014404296875,169.3555908203125],[454.09576416015625,169.3564453125],[454.48150634765625,169.35731506347656],[454.86712646484375,169.35816955566406],[455.25286865234375,169.35902404785156],[455.63848876953125,169.35987854003906],[456.02423095703125,169.36074829101562],[456.40985107421875,169.36160278320312],[456.79559326171875,169.36245727539062],[457.18121337890625,169.3633270263672],[457.56695556640625,169.3641815185547],[457.95257568359375,169.3650360107422],[458.33831787109375,169.36590576171875],[458.72393798828125,169.36676025390625],[459.10968017578125,169.36761474609375],[459.49530029296875,169.3684844970703],[459.88104248046875,169.3693389892578],[460.2666320800781,169.3701934814453],[460.6523742675781,169.37106323242188],[461.0379943847656,169.37191772460938],[461.4237365722656,169.37277221679688],[461.8094787597656,169.37364196777344],[462.1950988769531,169.37449645996094],[462.5808410644531,169.37535095214844],[462.9664611816406,169.376220703125],[463.3522033691406,169.3770751953125],[463.7378234863281,169.3779296875],[464.1235656738281,169.37879943847656],[464.5091857910156,169.37965393066406],[464.8949279785156,169.38050842285156],[465.2805480957031,169.38137817382812],[465.6662902832031,169.38223266601562],[466.0519104003906,169.38308715820312],[466.4376525878906,169.3839569091797],[466.8232727050781,169.3848114013672],[467.2090148925781,169.3856658935547],[467.5946350097656,169.3865203857422],[467.9803771972656,169.38739013671875],[468.3659973144531,169.38824462890625],[468.7517395019531,169.38909912109375],[469.1373596191406,169.3899688720703],[469.5231018066406,169.3908233642578],[469.9087219238281,169.3916778564453],[470.2944641113281,169.39254760742188],[470.6802062988281,169.39340209960938],[471.0658264160156,169.39425659179688],[471.4515686035156,169.39512634277344],[471.8371887207031,169.39598083496094],[472.222900390625,169.39683532714844],[472.6085205078125,169.397705078125],[472.9942626953125,169.3985595703125],[473.3798828125,169.3994140625],[473.765625,169.40028381347656],[474.1512451171875,169.40113830566406],[474.5369873046875,169.40199279785156],[474.922607421875,169.40286254882812],[475.308349609375,169.40371704101562],[475.6939697265625,169.40457153320312],[476.0797119140625,169.4054412841797],[476.46533203125,169.4062957763672],[476.85107421875,169.4071502685547],[477.2366943359375,169.40802001953125],[477.6224365234375,169.40887451171875],[478.008056640625,169.40972900390625],[478.39373779296875,169.41014099121094],[478.77935791015625,169.4103240966797],[479.16510009765625,169.4105224609375],[479.55084228515625,169.4107208251953],[479.93646240234375,169.41090393066406],[480.32220458984375,169.41110229492188],[480.70782470703125,169.4113006591797],[481.09356689453125,169.41148376464844],[481.47918701171875,169.41168212890625],[481.86492919921875,169.41188049316406],[482.25054931640625,169.4120635986328],[482.63629150390625,169.41226196289062],[483.02191162109375,169.41246032714844],[483.40765380859375,169.4126434326172],[483.79327392578125,169.412841796875],[484.17901611328125,169.4130401611328],[484.56463623046875,169.41322326660156],[484.95037841796875,169.41342163085938],[485.33599853515625,169.4136199951172],[485.72174072265625,169.41380310058594],[486.10736083984375,169.41400146484375],[486.49310302734375,169.41419982910156],[486.87872314453125,169.4143829345703],[487.26446533203125,169.41458129882812],[487.65020751953125,169.41476440429688],[488.03582763671875,169.4149627685547],[488.42156982421875,169.4151611328125],[488.80718994140625,169.41534423828125],[489.19293212890625,169.41554260253906],[489.57855224609375,169.41574096679688],[489.96429443359375,169.41592407226562],[490.34991455078125,169.41612243652344],[490.73565673828125,169.41632080078125],[491.12127685546875,169.41650390625],[491.50701904296875,169.4167022705078],[491.89263916015625,169.41690063476562],[492.27838134765625,169.41708374023438],[492.66400146484375,169.4172821044922],[493.04974365234375,169.41748046875],[493.43536376953125,169.41766357421875],[493.82110595703125,169.41786193847656],[494.20672607421875,169.41806030273438],[494.59246826171875,169.41824340820312],[494.97808837890625,169.41844177246094],[495.36383056640625,169.41864013671875],[495.74945068359375,169.4188232421875],[496.13519287109375,169.4190216064453],[496.52093505859375,169.41921997070312],[496.90655517578125,169.41940307617188],[497.29229736328125,169.4196014404297],[497.67791748046875,169.4197998046875],[498.06365966796875,169.41998291015625],[498.44927978515625,169.42018127441406],[498.83502197265625,169.42037963867188],[499.22064208984375,169.42056274414062],[499.60638427734375,169.42076110839844],[499.99200439453125,169.42095947265625],[500.37774658203125,169.421142578125],[500.76336669921875,169.4213409423828],[501.14910888671875,169.42153930664062],[501.53472900390625,169.42172241210938],[501.92047119140625,169.4219207763672],[502.30609130859375,169.422119140625],[502.69183349609375,169.42230224609375],[503.07745361328125,169.42250061035156],[503.46319580078125,169.42269897460938],[503.84881591796875,169.42288208007812],[504.23455810546875,169.42308044433594],[504.62030029296875,169.42327880859375],[505.00592041015625,169.4234619140625],[505.39166259765625,169.4236602783203],[505.77728271484375,169.42384338378906],[506.16302490234375,169.42404174804688],[506.54864501953125,169.4242401123047],[506.93438720703125,169.42442321777344],[507.32000732421875,169.42462158203125],[507.70574951171875,169.42481994628906],[508.09136962890625,169.4250030517578],[508.47711181640625,169.42520141601562],[508.86273193359375,169.42539978027344],[509.24847412109375,169.4255828857422],[509.63409423828125,169.42578125],[510.01983642578125,169.4259796142578],[510.40545654296875,169.42616271972656],[510.79119873046875,169.42636108398438],[511.17681884765625,169.4265594482422],[511.56256103515625,169.42674255371094],[511.94818115234375,169.42694091796875],[512.3339233398438,169.42713928222656],[512.7195434570312,169.4273223876953],[513.1052856445312,169.42752075195312],[513.4910278320312,169.42771911621094],[513.8766479492188,169.4279022216797],[514.2623901367188,169.4281005859375],[514.6480102539062,169.4282989501953],[515.0337524414062,169.42848205566406],[515.4193725585938,169.42868041992188],[515.8051147460938,169.4288787841797],[516.1907348632812,169.42906188964844],[516.5764770507812,169.42926025390625],[516.9620971679688,169.42945861816406],[517.3478393554688,169.4296417236328],[517.7334594726562,169.42984008789062],[518.119140625,169.43296813964844],[518.5040893554688,169.45571899414062],[518.8884887695312,169.48779296875],[519.2720336914062,169.52734375],[519.6549682617188,169.573486328125],[520.0371704101562,169.6251678466797],[520.4185791015625,169.68272399902344],[520.7989501953125,169.74578857421875],[521.1786499023438,169.81402587890625],[521.557373046875,169.88754272460938],[521.9347534179688,169.96609497070312],[522.3114013671875,170.04966735839844],[522.6867065429688,170.1382293701172],[523.0609130859375,170.2317352294922],[523.4337768554688,170.3302001953125],[523.805419921875,170.43357849121094],[524.175537109375,170.5418701171875],[524.5442504882812,170.655029296875],[524.9114379882812,170.77308654785156],[525.2769165039062,170.89634704589844],[525.6406860351562,171.02438354492188],[526.0028076171875,171.1573028564453],[526.36279296875,171.2952880859375],[526.7210693359375,171.4384002685547],[527.0772094726562,171.586181640625],[527.43115234375,171.73944091796875],[527.7828369140625,171.89743041992188],[528.1324462890625,172.06069946289062],[528.4794311523438,172.2289581298828],[528.823974609375,172.40225219726562],[529.1657104492188,172.58079528808594],[529.5050048828125,172.76438903808594],[529.8413696289062,172.95330810546875],[530.1747436523438,173.14712524414062],[530.5050659179688,173.34616088867188],[530.8322143554688,173.5504608154297],[531.15625,173.7595977783203],[531.4767456054688,173.97402954101562],[531.7937622070312,174.19375610351562],[532.1071166992188,174.41848754882812],[532.4168701171875,174.64840698242188],[532.7227172851562,174.8832244873047],[533.0247192382812,175.12330627441406],[533.322509765625,175.3683319091797],[533.6161499023438,175.6182861328125],[533.9056396484375,175.87318420410156],[534.190673828125,176.13307189941406],[534.47119140625,176.39761352539062],[534.7471923828125,176.66705322265625],[535.0184936523438,176.94114685058594],[535.2852172851562,177.21983337402344],[535.5468139648438,177.50308227539062],[535.8037109375,177.7908477783203],[536.0554809570312,178.0831298828125],[536.3021850585938,178.37942504882812],[536.543701171875,178.68014526367188],[536.7800903320312,178.98489379882812],[537.0111694335938,179.2936553955078],[537.2369384765625,179.6062774658203],[537.4573974609375,179.92274475097656],[537.6723022460938,180.2429656982422],[537.8819580078125,180.56678771972656],[538.0861206054688,180.89389038085938],[538.2847290039062,181.22463989257812],[538.477783203125,181.5584259033203],[538.66552734375,181.89532470703125],[538.84765625,182.2353057861328],[539.0242309570312,182.57818603515625],[539.1953125,182.92384338378906],[539.3610229492188,183.27207946777344],[539.5213012695312,183.62283325195312],[539.6762084960938,183.9761962890625],[539.8004150390625,184.3402099609375],[539.899169921875,184.71310424804688],[539.9979248046875,185.0858612060547],[540.0966796875,185.458740234375],[540.1954345703125,185.83163452148438],[540.294189453125,186.20437622070312],[540.3929443359375,186.5772705078125],[540.49169921875,186.95004272460938],[540.5905151367188,187.32290649414062],[540.689208984375,187.6956787109375],[540.7880249023438,188.0685577392578],[540.88671875,188.44131469726562],[540.9855346679688,188.814208984375],[541.0842895507812,189.1869659423828],[541.1830444335938,189.55984497070312],[541.2817993164062,189.9326171875],[541.3805541992188,190.3054962158203],[541.4793090820312,190.67825317382812],[541.5780639648438,191.0511474609375],[541.6768188476562,191.4239044189453],[541.7755737304688,191.79678344726562],[541.8743286132812,192.1695556640625],[541.9730834960938,192.5424346923828],[542.0718383789062,192.91519165039062],[542.1705932617188,193.2880859375],[542.2693481445312,193.6608428955078],[542.3681640625,194.03372192382812],[542.4669189453125,194.40660095214844],[542.565673828125,194.7793731689453],[542.6644287109375,195.15225219726562],[542.76318359375,195.52500915527344],[542.8619384765625,195.89788818359375],[542.960693359375,196.27066040039062],[543.0594482421875,196.64353942871094],[543.158203125,197.01629638671875],[543.2569580078125,197.38919067382812],[543.355712890625,197.76194763183594],[543.4544677734375,198.13482666015625],[543.55322265625,198.50759887695312],[543.6519775390625,198.88047790527344],[543.750732421875,199.25323486328125],[543.8495483398438,199.62612915039062],[543.9482421875,199.99888610839844],[544.0470581054688,200.37176513671875],[544.145751953125,200.74453735351562],[544.2445678710938,201.11741638183594],[544.3433227539062,201.49017333984375],[544.4420776367188,201.86306762695312],[544.5408325195312,202.23594665527344],[544.6395874023438,202.60870361328125],[544.7383422851562,202.98158264160156],[544.8370971679688,203.35435485839844],[544.9358520507812,203.72723388671875],[545.0346069335938,204.09999084472656],[545.1334228515625,204.47286987304688],[545.2321166992188,204.84564208984375],[545.3309326171875,205.21852111816406],[545.4296264648438,205.59127807617188],[545.5284423828125,205.96417236328125],[545.627197265625,206.33692932128906],[545.7259521484375,206.70980834960938],[545.82470703125,207.08258056640625],[545.9234619140625,207.45545959472656],[546.022216796875,207.82821655273438],[546.1209716796875,208.20111083984375],[546.2197265625,208.57386779785156],[546.3184814453125,208.94674682617188],[546.417236328125,209.31951904296875],[546.5159912109375,209.69239807128906],[546.61474609375,210.06515502929688],[546.7135009765625,210.43804931640625],[546.8123168945312,210.8109130859375],[546.9110107421875,211.18368530273438],[547.0098266601562,211.5565643310547],[547.1085815429688,211.92933654785156],[547.2073364257812,212.30221557617188],[547.3060913085938,212.6749725341797],[547.4048461914062,213.0478515625],[547.5036010742188,213.42062377929688],[547.6023559570312,213.7935028076172],[547.7011108398438,214.166259765625],[547.7998657226562,214.53915405273438],[547.8986206054688,214.9119110107422],[547.9973754882812,215.2847900390625],[548.0961303710938,215.65756225585938],[548.1948852539062,216.0304412841797],[548.2936401367188,216.4031982421875],[548.3924560546875,216.77609252929688],[548.4911499023438,217.1488494873047],[548.5899658203125,217.521728515625],[548.6886596679688,217.89450073242188],[548.7874755859375,218.2673797607422],[548.88623046875,218.6402587890625],[548.9849853515625,219.01303100585938],[549.083740234375,219.38589477539062],[549.1824951171875,219.7586669921875],[549.28125,220.1315460205078],[549.3800048828125,220.5043182373047],[549.478759765625,220.877197265625],[549.5775146484375,221.2499542236328],[549.67626953125,221.62283325195312],[549.7750244140625,221.99560546875],[549.8738403320312,222.3684844970703],[549.9725341796875,222.74124145507812],[550.0713500976562,223.1141357421875],[550.1701049804688,223.4868927001953],[550.2688598632812,223.85977172851562],[550.3676147460938,224.2325439453125],[550.4663696289062,224.6054229736328],[550.5651245117188,224.97817993164062],[550.6638793945312,225.35107421875],[550.7626342773438,225.7238311767578],[550.8613891601562,226.09671020507812],[550.9601440429688,226.469482421875],[551.0588989257812,226.8423614501953],[551.15771484375,227.21524047851562],[551.2564086914062,227.58799743652344],[551.355224609375,227.9608917236328],[551.4539184570312,228.33364868164062],[551.552734375,228.70652770996094],[551.6514892578125,229.0792999267578],[551.750244140625,229.45217895507812],[551.8489990234375,229.82493591308594],[551.94775390625,230.19781494140625],[552.0465087890625,230.57058715820312],[552.145263671875,230.94346618652344],[552.2440185546875,231.31622314453125],[552.3427734375,231.68911743164062],[552.4415283203125,232.06187438964844],[552.540283203125,232.43475341796875],[552.6390380859375,232.80752563476562],[552.73779296875,233.18040466308594],[552.8365478515625,233.55316162109375],[552.9353637695312,233.92605590820312],[553.0340576171875,234.29881286621094],[553.1328735351562,234.67169189453125],[553.2316284179688,235.04457092285156],[553.3303833007812,235.41734313964844],[553.4291381835938,235.79022216796875],[553.5278930664062,236.16297912597656],[553.6266479492188,236.53585815429688],[553.7254028320312,236.90863037109375],[553.8241577148438,237.28150939941406],[553.9229125976562,237.65428161621094],[554.0216674804688,238.02716064453125],[554.1204223632812,238.39991760253906],[554.2191772460938,238.77279663085938],[554.3179321289062,239.14556884765625],[554.416748046875,239.51844787597656],[554.5154418945312,239.89120483398438],[554.6142578125,240.26409912109375],[554.7129516601562,240.63685607910156],[554.811767578125,241.00973510742188],[554.9105224609375,241.38250732421875],[555.00927734375,241.75538635253906],[555.1080322265625,242.12814331054688],[555.206787109375,242.50103759765625],[555.3055419921875,242.87379455566406],[555.404296875,243.24667358398438],[555.5030517578125,243.6195526123047],[555.601806640625,243.99232482910156],[555.7006225585938,244.36520385742188],[555.79931640625,244.7379608154297],[555.8981323242188,245.11083984375],[555.996826171875,245.48361206054688],[556.0956420898438,245.8564910888672],[556.1943969726562,246.22926330566406],[556.2931518554688,246.60214233398438],[556.3919067382812,246.9748992919922],[556.4906616210938,247.3477783203125],[556.5894165039062,247.72055053710938],[556.6881713867188,248.0934295654297],[556.7869262695312,248.4661865234375],[556.8856811523438,248.83908081054688],[556.9844360351562,249.2118377685547],[557.0831909179688,249.584716796875],[557.1819458007812,249.95748901367188],[557.2807006835938,250.3303680419922],[557.3794555664062,250.703125],[557.4782104492188,251.0760040283203],[557.5769653320312,251.4487762451172],[557.67578125,251.8216552734375],[557.7745361328125,252.1945343017578],[557.873291015625,252.5673065185547],[557.9720458984375,252.940185546875],[558.0709838867188,253.31285095214844],[558.1871948242188,253.6806640625],[558.2890014648438,254.05259704589844],[558.3798828125,254.42745971679688],[558.4607543945312,254.80450439453125],[558.5325927734375,255.1834259033203],[558.5950927734375,255.5639190673828],[558.648681640625,255.9458770751953],[558.6934204101562,256.3289794921875],[558.7291870117188,256.7130432128906],[558.7560424804688,257.09765625],[558.7740478515625,257.4830017089844],[558.7825927734375,257.86846923828125],[558.7822875976562,258.25421142578125],[558.7723999023438,258.63970947265625],[558.753173828125,259.0249328613281],[558.7244262695312,259.4095153808594],[558.6860961914062,259.79327392578125],[558.637939453125,260.176025390625],[558.5796508789062,260.55718994140625],[558.5114135742188,260.93682861328125],[558.4332885742188,261.314453125],[558.3449096679688,261.68988037109375],[558.246337890625,262.0626220703125],[558.1373291015625,262.4327087402344],[558.0182495117188,262.7994384765625],[557.8887939453125,263.162841796875],[557.7491455078125,263.5222473144531],[557.5993041992188,263.8777160644531],[557.4395751953125,264.2286071777344],[557.2697143554688,264.5749206542969],[557.0901489257812,264.9161682128906],[556.90087890625,265.2523498535156],[556.7023315429688,265.58282470703125],[556.4944458007812,265.90777587890625],[556.27783203125,266.2266845703125],[556.0521850585938,266.5395812988281],[555.8182373046875,266.8460998535156],[555.5761108398438,267.1463623046875],[555.326171875,267.4399719238281],[555.0685424804688,267.7271423339844],[554.8037109375,268.007568359375],[554.5320434570312,268.2812194824219],[554.2536010742188,268.5481262207031],[553.9688720703125,268.80828857421875],[553.6781005859375,269.06170654296875],[553.3817138671875,269.308349609375],[553.079833984375,269.5484313964844],[552.7728881835938,269.7818908691406],[552.4608764648438,270.0087585449219],[552.14453125,270.22918701171875],[551.82373046875,270.4432373046875],[551.498779296875,270.6510925292969],[551.1700439453125,270.852783203125],[550.8377075195312,271.04833984375],[550.5018310546875,271.2380065917969],[550.1629028320312,271.4219055175781],[549.8206787109375,271.6000061035156],[549.475830078125,271.77252197265625],[549.1281127929688,271.9393615722656],[548.7801513671875,272.10552978515625],[548.4320678710938,272.2717590332031],[548.083984375,272.43798828125],[547.7359619140625,272.6041564941406],[547.3878784179688,272.7703857421875],[547.0399169921875,272.9365539550781],[546.6918334960938,273.102783203125],[546.3438720703125,273.2689514160156],[545.9957885742188,273.4351806640625],[545.6477661132812,273.6013488769531],[545.2996826171875,273.767578125],[544.9517211914062,273.9337463378906],[544.6036376953125,274.0999755859375],[544.255615234375,274.2661437988281],[543.9075317382812,274.432373046875],[543.5595703125,274.5985412597656],[543.2114868164062,274.7647705078125],[542.863525390625,274.9309387207031],[542.5154418945312,275.09716796875],[542.1674194335938,275.2633361816406],[541.8193359375,275.4295654296875],[541.4713745117188,275.5957336425781],[541.123291015625,275.761962890625],[540.7753295898438,275.9281311035156],[540.42724609375,276.0943603515625],[540.0791015625,276.2605895996094],[539.7311401367188,276.4267578125],[539.383056640625,276.5929870605469],[539.0350952148438,276.7591552734375],[538.68701171875,276.9253845214844],[538.3389892578125,277.091552734375],[537.9909057617188,277.2577819824219],[537.6429443359375,277.4239501953125],[537.2948608398438,277.5901794433594],[536.9468994140625,277.75634765625],[536.5987548828125,277.9225769042969],[536.2507934570312,278.0887451171875],[535.9027099609375,278.2549743652344],[535.5547485351562,278.421142578125],[535.2066650390625,278.5873718261719],[534.858642578125,278.7535400390625],[534.5105590820312,278.9197692871094],[534.16259765625,279.0859375],[533.8145141601562,279.2521667480469],[533.466552734375,279.4183654785156],[533.1184692382812,279.5845642089844],[532.7703247070312,279.75079345703125],[532.42236328125,279.9169616699219],[532.0742797851562,280.08319091796875],[531.726318359375,280.2493591308594],[531.3782348632812,280.41558837890625],[531.0302124023438,280.581787109375],[530.68212890625,280.74798583984375],[530.3341674804688,280.9141845703125],[529.986083984375,281.08038330078125],[529.6381225585938,281.24658203125],[529.2900390625,281.41278076171875],[528.9420166015625,281.5789794921875],[528.5939331054688,281.74517822265625],[528.2459716796875,281.911376953125],[527.8978881835938,282.07757568359375],[527.5499267578125,282.2437744140625],[527.2017822265625,282.40997314453125],[526.8538208007812,282.576171875],[526.5057373046875,282.7424011230469],[526.1577758789062,282.9085693359375],[525.8096923828125,283.0747985839844],[525.461669921875,283.240966796875],[525.1135864257812,283.4071960449219],[524.7655029296875,283.5733947753906],[524.4175415039062,283.7395935058594],[524.0694580078125,283.90582275390625],[523.721435546875,284.0719909667969],[523.3733520507812,284.23822021484375],[523.025390625,284.4043884277344],[522.6773071289062,284.57061767578125],[522.329345703125,284.7367858886719],[521.9812622070312,284.90301513671875],[521.6332397460938,285.0691833496094],[521.28515625,285.23541259765625],[520.9371948242188,285.4015808105469],[520.589111328125,285.56781005859375],[520.2411499023438,285.7339782714844],[519.8930053710938,285.90020751953125],[519.5450439453125,286.0663757324219],[519.1969604492188,286.23260498046875],[518.8489990234375,286.3987731933594],[518.5009155273438,286.56500244140625],[518.1528930664062,286.7311706542969],[517.8048095703125,286.89739990234375],[517.4567260742188,287.0636291503906],[517.1087646484375,287.22979736328125],[516.7606811523438,287.3960266113281],[516.4127197265625,287.56219482421875],[516.0645751953125,287.7284240722656],[515.7166137695312,287.89459228515625],[515.3685302734375,288.0608215332031],[515.0205688476562,288.22698974609375],[514.6724853515625,288.3932189941406],[514.324462890625,288.55938720703125],[513.9763793945312,288.7256164550781],[513.62841796875,288.89178466796875],[513.2803344726562,289.0580139160156],[512.932373046875,289.22418212890625],[512.5842895507812,289.3904113769531],[512.2362670898438,289.55657958984375],[511.88818359375,289.7228088378906],[511.54022216796875,289.88897705078125],[511.192138671875,290.0552062988281],[510.8441467285156,290.22137451171875],[510.4960632324219,290.3876037597656],[510.1480712890625,290.55377197265625]],
	bounds=3000,
	full_zoom=0.25,
	max_episode_steps=1500
)

Portugal = RaceTrack(
	name='Portugal',
	xy=[[446.6735015869141,299.1495071411133],[446.12645263671874,299.1492889404297],[445.57936401367186,299.1490509033203],[445.0323150634766,299.14883270263675],[444.4852661132813,299.14859466552736],[443.93821716308594,299.14837646484375],[443.39112854003906,299.1481384277344],[442.8440795898438,299.1479202270508],[442.2970306396484,299.1476821899414],[441.74994201660155,299.1474639892578],[441.20289306640626,299.14724578857425],[440.655844116211,299.14700775146486],[440.1087554931641,299.14678955078125],[439.56170654296875,299.1465515136719],[439.01465759277346,299.1463333129883],[438.4676086425781,299.1460952758789],[437.92052001953124,299.1458770751953],[437.37347106933595,299.14563903808596],[436.82642211914066,299.14542083740236],[436.2793334960938,299.14520263671875],[435.73228454589844,299.1449645996094],[435.18523559570315,299.1447463989258],[434.6381866455078,299.1445083618164],[434.0910980224609,299.1442901611328],[433.54404907226564,299.14405212402346],[432.99700012207035,299.14383392333986],[432.4499114990235,299.14359588623046],[431.9028625488281,299.1433776855469],[431.35581359863284,299.1431594848633],[430.8087646484375,299.1425247192383],[430.2616760253906,299.1418701171875],[429.7146270751953,299.1412155151367],[429.16757812500003,299.14056091308595],[428.62048950195316,299.1399261474609],[428.0734405517578,299.13927154541017],[427.5263916015625,299.1386169433594],[426.9793426513672,299.1379623413086],[426.4322540283203,299.13730773925784],[425.885205078125,299.1366729736328],[425.3381561279297,299.13601837158205],[424.79106750488285,299.13536376953124],[424.2440185546875,299.1347091674805],[423.6969696044922,299.13407440185546],[423.14992065429686,299.1334197998047],[422.60283203125,299.13276519775394],[422.0557830810547,299.1321105957031],[421.5087341308594,299.13145599365237],[420.96164550781253,299.13082122802734],[420.4145965576172,299.1301666259766],[419.8675476074219,299.12951202392577],[419.32049865722655,299.128857421875],[418.7734100341797,299.12820281982425],[418.2263610839844,299.12756805419923],[417.6793121337891,299.1269134521485],[417.1322235107422,299.12625885009766],[416.5851745605469,299.1256042480469],[416.0381256103516,299.1249496459961],[415.49107666015624,299.1241760253906],[414.94398803710936,299.12314453125003],[414.3969390869141,299.1221130371094],[413.8498901367188,299.12108154296874],[413.30284118652344,299.12003021240236],[412.75575256347656,299.1189987182617],[412.2087036132813,299.1179672241211],[411.6616546630859,299.11693572998047],[411.11460571289064,299.1159042358399],[410.56751708984376,299.11487274169923],[410.0204681396485,299.1138412475586],[409.4734191894531,299.1127899169922],[408.92633056640625,299.11175842285155],[408.37928161621096,299.11072692871096],[407.8322326660156,299.1096954345703],[407.2851837158203,299.1086639404297],[406.73809509277345,299.1076324462891],[406.19104614257816,299.1066009521484],[405.6439971923828,299.10556945800784],[405.0969482421875,299.1045181274414],[404.54985961914065,299.1034866333008],[404.0028106689453,299.10245513916016],[403.45576171875,299.10142364501957],[402.90867309570314,299.1003921508789],[402.36162414550785,299.09936065673827],[401.8145751953125,299.0983291625977],[401.2675262451172,299.09727783203124],[400.72043762207034,299.09624633789065],[400.173388671875,299.09521484375],[399.6263397216797,299.0940841674805],[399.0792907714844,299.09271545410155],[398.53220214843753,299.09132690429686],[397.9851531982422,299.0899383544922],[397.4381042480469,299.0885696411133],[396.89105529785155,299.0871810913086],[396.3439666748047,299.0857925415039],[395.7969177246094,299.084423828125],[395.2498687744141,299.0830352783203],[394.70281982421875,299.08164672851564],[394.1557312011719,299.08025817871095],[393.6086822509766,299.07888946533205],[393.06163330078124,299.07750091552737],[392.51458435058595,299.0761123657227],[391.9674957275391,299.0747436523438],[391.4204467773438,299.0733551025391],[390.87339782714844,299.0719665527344],[390.32634887695315,299.07059783935546],[389.7792602539063,299.06920928955077],[389.2322113037109,299.0678207397461],[388.68516235351564,299.0664520263672],[388.13811340332035,299.0650634765625],[387.5910247802735,299.0636749267578],[387.0439758300781,299.0622863769531],[386.49692687988284,299.06091766357423],[385.9498779296875,299.05952911376954],[385.4027893066406,299.05814056396486],[384.8557403564453,299.05677185058596],[384.30869140625003,299.0553833007813],[383.7616424560547,299.0539947509766],[383.2145538330078,299.0523681640625],[382.6675048828125,299.0506622314453],[382.1204559326172,299.04895629882816],[381.5734069824219,299.04725036621096],[381.026318359375,299.04556427001955],[380.4792694091797,299.04385833740236],[379.9322204589844,299.04215240478516],[379.3851715087891,299.04046630859375],[378.83812255859374,299.03876037597655],[378.29103393554686,299.0370544433594],[377.7439849853516,299.0353485107422],[377.1969360351563,299.0336624145508],[376.64988708496094,299.0319564819336],[376.10279846191406,299.0302505493164],[375.5557495117188,299.0285446166992],[375.0087005615234,299.0268585205078],[374.46165161132814,299.02515258789066],[373.91460266113285,299.02344665527346],[373.367514038086,299.02176055908205],[372.8204650878906,299.02005462646486],[372.27341613769534,299.01834869384766],[371.7263671875,299.01664276123046],[371.1792785644531,299.01495666503905],[370.6322296142578,299.0132507324219],[370.08518066406253,299.0115447998047],[369.5381317138672,299.0098388671875],[368.9910827636719,299.0081527709961],[368.443994140625,299.0064468383789],[367.8969451904297,299.0047409057617],[367.3498962402344,299.00303497314457],[366.8028472900391,299.00103149414065],[366.2557586669922,298.9990478515625],[365.7087097167969,298.9970443725586],[365.1616607666016,298.9950607299805],[364.61461181640624,298.99307708740236],[364.06756286621095,298.99107360839844],[363.5204742431641,298.9890899658203],[362.9734252929688,298.9870864868164],[362.42637634277344,298.98510284423827],[361.87932739257815,298.9830993652344],[361.3322784423828,298.9811157226563],[360.7851898193359,298.97913208007816],[360.23814086914064,298.97712860107424],[359.69109191894535,298.9751449584961],[359.14404296875,298.9731414794922],[358.5969543457031,298.9711578369141],[358.04990539550784,298.96915435791016],[357.5028564453125,298.96717071533203],[356.9558074951172,298.9651870727539],[356.4087585449219,298.96318359375],[355.86170959472656,298.96119995117186],[355.3146209716797,298.959196472168],[354.7675720214844,298.9572128295899],[354.22052307128905,298.95522918701175],[353.67347412109376,298.95322570800784],[353.1264251708985,298.9512420654297],[352.5793365478516,298.9492385864258],[352.03228759765625,298.94725494384767],[351.48523864746096,298.94525146484375],[350.9381896972656,298.9432281494141],[350.3911407470703,298.9409866333008],[349.84405212402345,298.93872528076173],[349.29700317382816,298.9364639282227],[348.7499542236328,298.9342025756836],[348.2029052734375,298.9319412231445],[347.6558563232422,298.92967987060547],[347.1088073730469,298.9274185180664],[346.56171875,298.92515716552737],[346.0146697998047,298.9228958129883],[345.4676208496094,298.9206344604492],[344.9205718994141,298.91837310791016],[344.37352294921874,298.9161315917969],[343.82647399902345,298.91387023925785],[343.2793853759766,298.91160888671874],[342.7323364257813,298.9093475341797],[342.18528747558594,298.90708618164064],[341.63823852539065,298.9048248291016],[341.0911895751953,298.90256347656253],[340.5441009521484,298.9003021240234],[339.99705200195314,298.8980407714844],[339.45000305175785,298.8957794189453],[338.9029541015625,298.8935180664063],[338.3559051513672,298.89127655029296],[337.80885620117186,298.8890151977539],[337.261767578125,298.88675384521486],[336.7147186279297,298.8844924926758],[336.1676696777344,298.88223114013675],[335.62062072753906,298.87996978759764],[335.0735717773438,298.8777084350586],[334.5264831542969,298.87542724609375],[333.97943420410155,298.8729278564453],[333.43238525390626,298.8704086303711],[332.885336303711,298.86790924072267],[332.3382873535156,298.8654098510742],[331.79121856689454,298.86289062500003],[331.24416961669925,298.8603912353516],[330.6971008300781,298.85787200927734],[330.1500518798828,298.8553726196289],[329.60300292968753,298.8528732299805],[329.0559539794922,298.85035400390626],[328.5089050292969,298.8478546142578],[327.9618362426758,298.8453353881836],[327.41478729248047,298.8428359985352],[326.8677185058594,298.84033660888673],[326.3206695556641,298.8378173828125],[325.77362060546875,298.8353179931641],[325.22657165527346,298.83279876708986],[324.6795028686524,298.8302993774414],[324.13245391845703,298.8277801513672],[323.58540496826174,298.8252807617188],[323.03833618164066,298.8227813720703],[322.4912872314453,298.8202621459961],[321.94423828125,298.8177627563477],[321.39716949462894,298.81524353027345],[320.8501205444336,298.812744140625],[320.3030715942383,298.81024475097655],[319.75602264404296,298.80772552490237],[319.2089538574219,298.8052261352539],[318.6619049072266,298.8027069091797],[318.11485595703124,298.8002075195313],[317.56780700683595,298.79747009277344],[317.02073822021487,298.79473266601565],[316.4736892700195,298.7919952392578],[315.92664031982423,298.7892578125],[315.37957153320315,298.7865203857422],[314.8325225830078,298.7837829589844],[314.2854736328125,298.7810455322266],[313.7384246826172,298.77830810546874],[313.1913757324219,298.77557067871095],[312.6443069458008,298.77283325195316],[312.0972579956055,298.7700958251953],[311.55020904541016,298.7673583984375],[311.00316009521487,298.7646209716797],[310.4560913085938,298.7618835449219],[309.90904235839844,298.7591461181641],[309.36199340820315,298.75642852783204],[308.8149444580078,298.75369110107425],[308.2678756713867,298.7509536743164],[307.72082672119143,298.7482162475586],[307.1737777709961,298.74547882080077],[306.6267288208008,298.742741394043],[306.0796600341797,298.7400039672852],[305.53261108398436,298.73726654052734],[304.9855621337891,298.73452911376955],[304.4385131835938,298.7317916870117],[303.89146423339844,298.7290542602539],[303.34439544677736,298.7263168334961],[302.79734649658207,298.7235794067383],[302.2502975463867,298.7208419799805],[301.70324859619143,298.71810455322264],[301.15617980957035,298.71514892578125],[300.609130859375,298.71219329833986],[300.0620819091797,298.70925750732425],[299.51503295898436,298.7063018798828],[298.9679840087891,298.7033462524414],[298.420915222168,298.7004104614258],[297.87386627197264,298.6974548339844],[297.32681732177736,298.69449920654296],[296.77976837158207,298.69154357910156],[296.2327194213867,298.68860778808596],[295.68565063476564,298.68565216064457],[295.13860168457035,298.6826965332031],[294.591552734375,298.6797607421875],[294.0445037841797,298.6768051147461],[293.49745483398436,298.6738494873047],[292.9503860473633,298.67089385986327],[292.403337097168,298.66795806884767],[291.85628814697264,298.6650024414063],[291.30923919677736,298.6620468139649],[290.76219024658207,298.6591110229492],[290.2151214599609,298.6561553955078],[289.66807250976564,298.65319976806643],[289.12102355957035,298.65024414062503],[288.573974609375,298.6473083496094],[288.0269256591797,298.644352722168],[287.4798568725586,298.6413970947266],[286.9328079223633,298.6384613037109],[286.385758972168,298.63550567626953],[285.83871002197264,298.63255004882814],[285.29166107177736,298.62957458496095],[284.7445922851563,298.62642059326174],[284.1975433349609,298.62326660156253],[283.65049438476564,298.62013244628906],[283.10344543457035,298.61697845458986],[282.556396484375,298.61382446289065],[282.0093475341797,298.61067047119144],[281.46229858398436,298.60753631591797],[280.9152496337891,298.60438232421876],[280.3682006835938,298.60122833251955],[279.82113189697264,298.5980941772461],[279.27410278320315,298.5949401855469],[278.72703399658207,298.59178619384767],[278.1800048828125,298.58865203857425],[277.63293609619143,298.585498046875],[277.08586730957035,298.5823440551758],[276.5388381958008,298.5791900634766],[275.9917694091797,298.57605590820316],[275.44474029541016,298.5729019165039],[274.8976715087891,298.5697479248047],[274.3506423950195,298.5666137695313],[273.80357360839844,298.56345977783207],[273.25652465820315,298.5603057861328],[272.7094757080078,298.5571716308594],[272.1624267578125,298.5540176391602],[271.6153778076172,298.550863647461],[271.0683090209961,298.5477096557617],[270.5212600708008,298.5445755004883],[269.9742111206055,298.5414215087891],[269.42716217041016,298.5382675170899],[268.88011322021487,298.5350143432617],[268.3330642700195,298.5316818237305],[267.78599548339844,298.52834930419925],[267.23896636962894,298.52501678466797],[266.6918975830078,298.52168426513674],[266.1448684692383,298.51835174560546],[265.5977996826172,298.51501922607423],[265.05077056884767,298.511686706543],[264.5037017822266,298.5083541870117],[263.95665283203124,298.5050216674805],[263.40960388183595,298.5016891479492],[262.86255493164066,298.498356628418],[262.3155059814453,298.49502410888675],[261.76845703125,298.49169158935547],[261.2214080810547,298.48835906982424],[260.6743591308594,298.48502655029296],[260.1273101806641,298.48167419433594],[259.58026123046875,298.4783416748047],[259.03321228027346,298.4750091552734],[258.4861434936524,298.4716766357422],[257.9391143798828,298.468344116211],[257.39204559326174,298.4650115966797],[256.8450164794922,298.46167907714846],[256.2979476928711,298.4583465576172],[255.75091857910158,298.45501403808595],[255.20384979248047,298.4516815185547],[254.65680084228518,298.44834899902344],[254.10975189208986,298.4450164794922],[253.56270294189454,298.4416839599609],[253.01565399169922,298.4382919311524],[252.46858520507814,298.4347808837891],[251.92153625488282,298.43126983642577],[251.3745071411133,298.4277587890625],[250.8274383544922,298.4242477416992],[250.28040924072266,298.4207565307617],[249.73334045410158,298.41724548339846],[249.18629150390626,298.41373443603516],[248.63924255371094,298.4102233886719],[248.09219360351562,298.4067321777344],[247.5451644897461,298.4032211303711],[246.99809570312502,298.39971008300785],[246.4510467529297,298.39619903564454],[245.90399780273438,298.39270782470703],[245.35694885253906,298.3891967773438],[244.80989990234374,298.3856857299805],[244.26285095214845,298.3821746826172],[243.7158218383789,298.37866363525393],[243.16875305175782,298.3751724243164],[242.6217041015625,298.3716613769531],[242.07465515136718,298.36815032958987],[241.5276062011719,298.36463928222656],[240.98055725097657,298.36114807128905],[240.43350830078126,298.3576370239258],[239.88645935058594,298.3541259765625],[239.33941040039062,298.35061492919925],[238.79236145019533,298.34712371826174],[238.2453125,298.34361267089844],[237.6982635498047,298.3401016235352],[237.1511947631836,298.336491394043],[236.60416564941406,298.33282165527345],[236.05709686279297,298.3291519165039],[235.51006774902345,298.3254821777344],[234.96299896240234,298.32181243896486],[234.4159698486328,298.3181427001953],[233.8689208984375,298.3144927978516],[233.3218521118164,298.31082305908205],[232.7748229980469,298.3071533203125],[232.22775421142578,298.303483581543],[231.68072509765625,298.29981384277346],[231.13367614746093,298.29614410400393],[230.58660736083985,298.2924743652344],[230.03957824707032,298.28880462646487],[229.492529296875,298.28513488769534],[228.9454803466797,298.2814651489258],[228.39843139648437,298.2777954101563],[227.8513626098633,298.27412567138674],[227.30433349609376,298.2704559326172],[226.75728454589844,298.2667861938477],[226.21023559570312,298.26311645507815],[225.6631866455078,298.2594467163086],[225.11613769531252,298.2557769775391],[224.5690887451172,298.25210723876955],[224.02203979492188,298.2484375],[223.47499084472656,298.2447677612305],[222.92794189453124,298.24109802246096],[222.38091278076172,298.23742828369143],[221.8338638305664,298.2337188720703],[221.28679504394532,298.22989044189455],[220.7397659301758,298.22608184814453],[220.19271697998047,298.2222534179688],[219.64566802978516,298.21842498779296],[219.09861907958984,298.2145965576172],[218.55157012939455,298.2107879638672],[218.00452117919923,298.2069595336914],[217.4574722290039,298.20313110351566],[216.9104431152344,298.19932250976564],[216.36337432861328,298.1954940795899],[215.81634521484375,298.19166564941406],[215.26929626464843,298.1878570556641],[214.72222747802735,298.1840286254883],[214.17519836425782,298.1802001953125],[213.6281494140625,298.1763916015625],[213.0811004638672,298.17256317138674],[212.53405151367187,298.1687347412109],[211.98700256347658,298.16492614746096],[211.43995361328126,298.16109771728514],[210.89290466308594,298.1572692871094],[210.34587554931642,298.15346069335936],[209.7988067626953,298.1496322631836],[209.25175781250002,298.14580383300785],[208.70472869873046,298.1419952392578],[208.15765991210938,298.13816680908207],[207.61063079833986,298.13433837890625],[207.06358184814454,298.1305099487305],[206.516552734375,298.12660217285156],[205.9695037841797,298.1226348876953],[205.4224349975586,298.11866760253906],[204.87540588378906,298.1147003173828],[204.32835693359377,298.11073303222656],[203.7813278198242,298.1067657470703],[203.23425903320313,298.10281829833986],[202.6872100830078,298.0988510131836],[202.1401809692383,298.09488372802736],[201.5931121826172,298.0909164428711],[201.04608306884765,298.08694915771486],[200.49903411865236,298.0829818725586],[199.95198516845704,298.07901458740236],[199.40493621826172,298.0750473022461],[198.8578872680664,298.07109985351565],[198.31085815429688,298.0671325683594],[197.76380920410156,298.06316528320315],[197.21676025390624,298.0591979980469],[196.66971130371095,298.05523071289065],[196.12266235351564,298.0512634277344],[195.57561340332032,298.04729614257815],[195.028564453125,298.0433288574219],[194.48153533935547,298.03938140869144],[193.93448638916016,298.0354141235352],[193.38741760253907,298.03144683837894],[192.84038848876955,298.0274795532227],[192.29333953857423,298.02351226806644],[191.7463104248047,298.0194061279297],[191.1992614746094,298.01524047851564],[190.65221252441407,298.0110748291016],[190.10516357421875,298.0069091796875],[189.55811462402343,298.00274353027345],[189.0110855102539,297.9985778808594],[188.4640365600586,297.9944122314453],[187.9169876098633,297.99024658203126],[187.36995849609374,297.986100769043],[186.82288970947266,297.98193511962893],[186.27586059570314,297.97776947021487],[185.72881164550782,297.9736038208008],[185.1817825317383,297.96943817138674],[184.63471374511718,297.9652725219727],[184.0876647949219,297.9611068725586],[183.54063568115234,297.95696105957035],[182.99358673095705,297.9527954101563],[182.4465576171875,297.9486297607422],[181.8994888305664,297.94446411132816],[181.3524398803711,297.9402984619141],[180.80541076660157,297.93613281250003],[180.25836181640625,297.931967163086],[179.71133270263672,297.92782135009764],[179.16426391601564,297.9236557006836],[178.61721496582032,297.9194900512695],[178.0701858520508,297.91532440185546],[177.52313690185548,297.9111587524414],[176.97610778808595,297.90699310302733],[176.42903900146484,297.90282745361327],[175.88200988769532,297.8986618041992],[175.3349609375,297.89451599121094],[174.78791198730468,297.8903503417969],[174.24088287353516,297.8861846923828],[173.69381408691407,297.88201904296875],[173.14678497314455,297.8778533935547],[172.59973602294923,297.8736877441406],[172.0526870727539,297.86952209472656],[171.5056579589844,297.8653762817383],[170.95858917236328,297.86121063232423],[170.41156005859375,297.85704498291017],[169.86451110839843,297.8528793334961],[169.31746215820314,297.84871368408204],[168.7704330444336,297.844548034668],[168.2233642578125,297.8403823852539],[167.67633514404298,297.83623657226565],[167.12928619384766,297.8320709228516],[166.58225708007814,297.8279052734375],[166.03519821166992,297.82373962402346],[165.4881492614746,297.8195739746094],[164.94111022949218,297.81540832519534],[164.3940612792969,297.8112426757813],[163.84702224731447,297.80701751708983],[163.29997329711915,297.80267333984375],[162.75292434692383,297.7983093261719],[162.2058952331543,297.7939651489258],[161.6588363647461,297.7896209716797],[161.11180725097657,297.78525695800784],[160.56475830078125,297.78091278076175],[160.01770935058593,297.7765686035156],[159.4706703186035,297.77222442626953],[158.92362136840822,297.76786041259766],[158.37659225463867,297.7635162353516],[157.82954330444338,297.7591720581055],[157.28250427246095,297.7548278808594],[156.73545532226564,297.75046386718753],[156.18840637207032,297.7461196899414],[155.6413772583008,297.7417755126953],[155.09431838989258,297.73743133544923],[154.54728927612305,297.73306732177736],[154.00024032592773,297.7287231445313],[153.45318145751955,297.7243789672852],[152.90615234375,297.7200149536133],[152.3591033935547,297.7156707763672],[151.81207427978515,297.7113265991211],[151.26501541137696,297.706982421875],[150.71797637939454,297.70261840820314],[150.17094726562502,297.69815521240236],[149.6238883972168,297.6936920166016],[149.07685928344728,297.6892288208008],[148.52981033325196,297.684765625],[147.98278121948243,297.68030242919923],[147.43573226928712,297.67583923339845],[146.8886833190918,297.67137603759767],[146.34164428710938,297.6669128417969],[145.79459533691406,297.6624496459961],[145.24756622314453,297.6579864501953],[144.7005172729492,297.65352325439454],[144.15346832275392,297.64904022216797],[143.60643920898437,297.6445770263672],[143.05938034057618,297.6401138305664],[142.51235122680666,297.6356506347656],[141.96530227661134,297.63118743896484],[141.41825332641602,297.62672424316406],[140.8712242126465,297.6222610473633],[140.32417526245118,297.6177978515625],[139.77713623046876,297.6133346557617],[139.23008728027344,297.60887145996094],[138.6830581665039,297.60440826416016],[138.1360092163086,297.5999450683594],[137.58896026611328,297.59534301757816],[137.04193115234375,297.5907211303711],[136.49488220214843,297.5860992431641],[135.9478530883789,297.581477355957],[135.4008041381836,297.57685546875],[134.8537551879883,297.572233581543],[134.30671615600588,297.56761169433594],[133.75966720581056,297.56298980712893],[133.21263809204103,297.55836791992186],[132.66558914184571,297.55374603271486],[132.1185401916504,297.54912414550785],[131.57151107788087,297.5445022583008],[131.02446212768555,297.5398803710938],[130.47743301391603,297.5352584838867],[129.9303840637207,297.5306365966797],[129.3833351135254,297.5260147094727],[128.83630599975587,297.5213928222656],[128.28925704956055,297.5167709350586],[127.74222793579102,297.51214904785155],[127.1951789855957,297.50752716064454],[126.64814987182618,297.50290527343753],[126.10110092163086,297.49828338623047],[125.55405197143556,297.49366149902346],[125.00702285766602,297.4890396118164],[124.45997390747071,297.4844177246094],[123.91294479370117,297.4797958374024],[123.36589584350587,297.4751739501953],[122.81884689331055,297.4705520629883],[122.27181777954102,297.46593017578124],[121.7247688293457,297.46130828857423],[121.17773971557618,297.4566864013672],[120.63069076538086,297.45206451416016],[120.08364181518554,297.44744262695315],[119.53661270141602,297.4428405761719],[118.9895637512207,297.43821868896487],[118.44253463745117,297.4335968017578],[117.89547576904297,297.4289749145508],[117.34844665527343,297.4243530273438],[116.80139770507813,297.4197311401367],[116.25434875488281,297.4151092529297],[115.70731964111329,297.41048736572264],[115.16027069091797,297.40586547851564],[114.61326141357422,297.40120391845704],[114.0662124633789,297.3963836669922],[113.51919326782227,297.39156341552734],[112.97212448120118,297.3867630004883],[112.42509536743164,297.38194274902344],[111.87806625366211,297.3771224975586],[111.33103713989259,297.37230224609374],[110.78396835327149,297.3674819946289],[110.23694915771485,297.3626617431641],[109.68992004394532,297.357861328125],[109.14285125732422,297.3530410766602],[108.59582214355468,297.3482208251953],[108.04879302978516,297.3434005737305],[107.50172424316406,297.3385803222656],[106.95469512939454,297.3337600708008],[106.407666015625,297.328939819336],[105.86064682006837,297.3241394042969],[105.31357803344727,297.31931915283207],[104.76654891967773,297.3144989013672],[104.2195198059082,297.30967864990237],[103.67245101928711,297.3048583984375],[103.12542190551758,297.30003814697267],[102.57839279174804,297.29521789550785],[102.03137359619141,297.29041748046876],[101.48430480957032,297.28559722900394],[100.93727569580078,297.28077697753906],[100.39024658203125,297.27595672607424],[99.84317779541016,297.27113647460936],[99.29614868164063,297.26631622314454],[98.74911956787109,297.2614959716797],[98.20205078125001,297.25669555664064],[97.65503158569337,297.2518753051758],[97.10800247192383,297.24705505371094],[96.5609733581543,297.2422348022461],[96.0139045715332,297.23741455078124],[95.46687545776368,297.2325942993164],[94.91984634399414,297.22779388427733],[94.37277755737306,297.2229736328125],[93.8257682800293,297.2179550170899],[93.27873916625977,297.21289672851566],[92.73171997070312,297.20783843994144],[92.18465118408203,297.20276031494143],[91.6376220703125,297.1977020263672],[91.09060287475586,297.192643737793],[90.54353408813476,297.1875854492188],[89.99651489257813,297.18250732421876],[89.4494857788086,297.17744903564454],[88.9024169921875,297.1723907470703],[88.35538787841797,297.1673126220703],[87.80836868286133,297.1622543334961],[87.2613395690918,297.1571960449219],[86.7142807006836,297.15211791992186],[86.16725158691406,297.14705963134764],[85.62022247314454,297.1420013427734],[85.07316360473634,297.1369232177735],[84.5261344909668,297.13186492919925],[83.97911529541015,297.12680664062503],[83.43208618164063,297.1217483520508],[82.88501739501953,297.1166702270508],[82.33799324035645,297.1116119384766],[81.79096908569336,297.10655364990237],[81.24390029907227,297.10147552490236],[80.69687614440919,297.09641723632814],[80.1498519897461,297.0913589477539],[79.60278816223145,297.0862808227539],[79.05576400756836,297.0812225341797],[78.50873489379883,297.07616424560547],[77.96171073913574,297.07108612060546],[77.41464691162109,297.06602783203124],[76.86761779785157,297.060969543457],[76.32059364318847,297.05589141845707],[75.77352981567383,297.05083312988285],[75.2265007019043,297.0457748413086],[74.67947654724121,297.0407165527344],[74.13245239257813,297.0356384277344],[73.58538856506348,297.0305801391602],[73.03836441040039,297.02552185058596],[72.49133529663087,297.02044372558595],[71.94427146911622,297.01538543701173],[71.39724731445312,297.0103271484375],[70.8502182006836,297.0052490234375],[70.30315437316895,297.0001907348633],[69.75613021850586,296.99513244628906],[69.20910606384278,296.99005432128905],[68.66207695007324,296.98499603271483],[68.1150131225586,296.9799377441406],[67.56798896789552,296.9748794555664],[67.02096481323242,296.96980133056644],[66.47389602661133,296.9647430419922],[65.92687187194825,296.959684753418],[65.37984771728516,296.954606628418],[64.83281860351563,296.9495483398438],[64.28575477600099,296.94449005126955],[63.73873062133789,296.93941192626954],[63.191721343994146,296.9340957641602],[62.6446575164795,296.928759765625],[62.097633361816406,296.92342376708984],[61.55061416625977,296.9180877685547],[61.00355033874512,296.91275177001955],[60.45652618408203,296.9074157714844],[59.90950698852539,296.9020797729492],[59.36248283386231,296.89674377441406],[58.81541900634766,296.8914077758789],[58.26839485168457,296.8860717773438],[57.721370697021484,296.8807357788086],[57.174311828613284,296.8753997802734],[56.6272876739502,296.8700637817383],[56.08026351928711,296.86472778320314],[55.53324432373047,296.859391784668],[54.98618049621582,296.85405578613285],[54.43915634155274,296.84871978759764],[53.89213218688965,296.8433837890625],[53.345068359375,296.83804779052736],[52.79804916381836,296.8327117919922],[52.25102500915528,296.82737579345707],[51.70396118164063,296.82203979492186],[51.156941986083986,296.8167037963867],[50.6099178314209,296.8113677978516],[50.06289367675782,296.80603179931643],[49.51726799011231,296.828923034668],[48.972852325439455,296.88244171142577],[48.427588653564456,296.92681579589845],[47.88166542053223,296.9618865966797],[47.335211563110356,296.98741607666017],[46.788400650024414,297.0037612915039],[46.24137649536133,297.0106643676758],[45.6943473815918,297.00891876220703],[45.147392654418944,296.9990600585938],[44.60066108703614,296.98065185546875],[44.054276657104495,296.9533172607422],[43.508452606201175,296.9168975830078],[42.963278198242186,296.8715316772461],[42.41894683837891,296.81698150634764],[41.87568168640137,296.75269165039066],[41.33363151550293,296.6789001464844],[40.79300708770752,296.59548797607425],[40.25397205352783,296.5019195556641],[39.716851234436035,296.3983139038086],[39.18174629211426,296.2846908569336],[38.649006843566895,296.16023712158204],[38.11879901885987,296.02556762695315],[37.5915096282959,295.8800277709961],[37.067205619812015,295.72373657226564],[36.54639034271241,295.5564758300781],[36.02924976348877,295.37812652587894],[35.51610126495361,295.1886291503906],[35.00714817047119,294.98790435791017],[34.50300045013428,294.7755950927735],[34.00371761322022,294.5521377563477],[33.509748458862305,294.316976928711],[33.021479797363284,294.07035064697266],[32.53926868438721,293.812060546875],[32.06343002319336,293.5422058105469],[31.59429111480713,293.2607666015625],[31.1322660446167,292.9678421020508],[30.677781295776366,292.6633926391602],[30.231126976013183,292.3474975585938],[29.792702293395998,292.0203552246094],[29.3628568649292,291.68204498291016],[28.94194278717041,291.3325866699219],[28.530299758911134,290.97229766845703],[28.128255081176757,290.60137634277345],[27.736180686950686,290.2198822021484],[27.354277420043946,289.8281524658203],[26.98288745880127,289.42652435302733],[26.622375297546387,289.01513671875],[26.27280788421631,288.594287109375],[25.93450508117676,288.1644317626953],[25.607719802856447,287.72570953369143],[25.2925537109375,287.27859649658205],[24.989130783081055,286.8233901977539],[24.697644424438476,286.3604675292969],[24.418258285522462,285.89014587402346],[24.150937652587892,285.412841796875],[23.89578170776367,284.9289916992188],[23.652815246582033,284.4388732910156],[23.422033309936523,283.94286346435547],[23.197363471984865,283.4440368652344],[23.0338493347168,282.9236282348633],[22.894694328308105,282.3945709228516],[22.755529403686523,281.86549377441406],[22.616374397277834,281.33643646240233],[22.47721939086914,280.80737915039066],[22.33805446624756,280.27828216552734],[22.198899459838866,279.7492248535156],[22.059744453430177,279.2201873779297],[21.920589447021484,278.6911102294922],[21.781424522399902,278.1620330810547],[21.642269515991213,277.63297576904296],[21.50311450958252,277.1039184570313],[21.363949584960938,276.57482147216797],[21.224794578552245,276.04576416015624],[21.085639572143556,275.5167266845703],[20.946474647521974,274.98762969970704],[20.80731964111328,274.4585723876953],[20.6681658744812,273.9295150756836],[20.52901086807251,273.4004577636719],[20.38984594345093,272.8713806152344],[20.250690937042236,272.34232330322266],[20.111535930633547,271.8132659912109],[19.972371006011965,271.28416900634767],[19.833215999603272,270.75511169433594],[19.69406099319458,270.2260543823242],[19.554907226562502,269.69699707031253],[19.41574230194092,269.167919921875],[19.276587295532227,268.6388626098633],[19.137432289123534,268.10980529785155],[18.998267364501952,267.5807083129883],[18.859112358093263,267.05165100097656],[18.71995735168457,266.5226135253906],[18.58079242706299,265.99351654052737],[18.4416374206543,265.46445922851564],[18.302482414245606,264.9354019165039],[18.163327407836913,264.4063446044922],[18.02416248321533,263.8772674560547],[17.885007476806642,263.3481903076172],[17.74585371017456,262.81915283203125],[17.606687545776367,262.290055847168],[17.467533779144286,261.76099853515626],[17.328378772735597,261.23194122314453],[17.189223766326904,260.7028839111328],[17.050058841705322,260.17380676269534],[16.910903835296633,259.6447494506836],[16.77174882888794,259.1156921386719],[16.632583904266358,258.5865951538086],[16.493428897857665,258.0575378417969],[16.354273891448976,257.52850036621095],[16.215108966827394,256.9994033813477],[16.0759539604187,256.47034606933596],[15.93679895401001,255.94128875732423],[15.797645187377931,255.4122314453125],[15.658480262756349,254.88313446044924],[15.519325256347656,254.3540771484375],[15.380170249938965,253.82503967285157],[15.241005325317383,253.2959426879883],[15.101850318908692,252.76688537597659],[14.962695312500001,252.23782806396486],[14.823540306091308,251.70877075195312],[14.684375381469726,251.17969360351563],[14.545220375061035,250.65063629150393],[14.406065368652344,250.1215789794922],[14.266900444030762,249.5924819946289],[14.127745437622071,249.06342468261718],[13.98859043121338,248.53436737060548],[13.849425506591798,248.0052703857422],[13.710271739959717,247.47623291015626],[13.571116733551026,246.94717559814453],[13.431961727142335,246.41811828613282],[13.292796802520753,245.88902130126954],[13.15364179611206,245.3599639892578],[13.01448678970337,244.83092651367187],[12.875321865081787,244.3018295288086],[12.736166858673096,243.77277221679688],[12.597011852264405,243.24371490478515],[12.457856845855714,242.71465759277345],[12.318691921234132,242.18558044433595],[12.179536914825439,241.65650329589843],[12.04038314819336,241.1274658203125],[11.901216983795166,240.59836883544924],[11.762063217163087,240.0693115234375],[11.622908210754394,239.54025421142578],[11.483743286132812,239.01115722656252],[11.344588279724121,238.48211975097658],[11.20543327331543,237.95306243896485],[11.066278266906739,237.42400512695312],[10.927113342285157,236.89490814208986],[10.787958335876466,236.36585083007813],[10.648803329467773,235.8367935180664],[10.509638404846191,235.3077163696289],[10.370484018325806,234.7786590576172],[10.231329011917115,234.24960174560547],[10.092174005508424,233.72054443359374],[9.953009080886842,233.1914474487305],[9.813854074478149,232.66239013671876],[9.674699068069458,232.13335266113282],[9.535534143447876,231.60425567626953],[9.396379756927491,231.07519836425783],[9.2572247505188,230.5461410522461],[9.118059825897218,230.0170440673828],[8.978904819488525,229.48800659179688],[8.839749813079834,228.95894927978517],[8.700595426559449,228.42989196777344],[8.561429882049561,227.90079498291016],[8.422275495529176,227.37173767089845],[8.283120489120483,226.84268035888672],[8.143955564498901,226.31358337402344],[8.00480055809021,225.7845458984375],[7.865645551681519,225.2554885864258],[7.726491165161133,224.72643127441407],[7.587325620651245,224.19733428955078],[7.44817123413086,223.66827697753908],[7.309016227722168,223.13923950195314],[7.169851303100586,222.61014251708986],[7.030696296691895,222.08108520507812],[6.891541290283203,221.55202789306642],[6.752376365661621,221.02293090820314],[6.613221979141236,220.4938735961914],[6.474066972732544,219.9648162841797],[6.334911966323853,219.43577880859377],[6.195747041702271,218.90668182373048],[6.056592035293579,218.37762451171875],[5.917437028884888,217.84856719970705],[5.778272104263306,217.31947021484376],[5.63911771774292,216.79043273925782],[5.499962711334229,216.2613754272461],[5.360807704925537,215.7323181152344],[5.221642780303955,215.2032211303711],[5.082487773895264,214.67416381835938],[4.943333077430725,214.14510650634767],[4.804168152809143,213.61602935791015],[4.665013146400452,213.08697204589845],[4.525858449935913,212.55791473388672],[4.386693525314331,212.02881774902343],[4.24753851890564,211.49976043701173],[4.108383512496949,210.970703125],[3.96922881603241,210.44166564941406],[3.830063891410828,209.91256866455078],[3.6909088850021363,209.38351135253907],[3.551754188537598,208.85445404052734],[3.412589263916016,208.32535705566406],[3.2734342575073243,207.79629974365236],[3.134279561042786,207.26726226806642],[2.9951245546340943,206.7382049560547],[2.8559596300125123,206.2091079711914],[2.716804623603821,205.6800506591797],[2.5776499271392823,205.15099334716797],[2.438484847545624,204.62189636230468],[2.299329996109009,204.09285888671874],[2.160175144672394,203.56380157470704],[2.0210102200508118,203.03470458984376],[1.8818553686141968,202.50564727783203],[1.7427005171775818,201.97658996582032],[1.6035456657409668,201.4475326538086],[1.4643807411193848,200.9184555053711],[1.3252257347106935,200.38939819335937],[1.1860709607601165,199.86034088134767],[1.0469059586524965,199.33124389648438],[0.9077511072158814,198.80218658447265],[0.7685962557792664,198.2731491088867],[0.6294312924146652,197.74405212402345],[0.49027644097805023,197.21499481201172],[0.35112155079841617,196.6859375],[0.21196669936180115,196.1568801879883],[0.0728017408400774,195.627783203125],[2.894478701165326e-8,195.09017639160157],[5.032518757275284e-9,194.54312744140626],[0.004389762645587325,193.99607849121094],[0.020156209450215103,193.44926757812502],[0.04546490386128426,192.90281372070314],[0.07918339408934116,192.35681610107423],[0.12096481025218964,191.81133422851562],[0.17034147083759307,191.26650695800782],[0.22742072790861131,190.7224334716797],[0.2917009174823761,190.1791534423828],[0.3635675132274628,189.63684539794923],[0.4429171681404114,189.09560852050782],[0.5297764599323272,188.5554428100586],[0.624154531955719,188.01660614013673],[0.7262997269630432,187.47917785644532],[0.836156564950943,186.94327697753906],[0.9540863633155823,186.40904235839844],[1.0800137281417848,185.87671203613283],[1.214172124862671,185.34636535644532],[1.3569080710411072,184.8182601928711],[1.5082607746124268,184.2925552368164],[1.668443787097931,183.76948852539064],[1.8376794934272767,183.24929809570312],[2.0162352204322818,182.73216247558594],[2.2042916655540465,182.2184783935547],[2.402136301994324,181.70844421386718],[2.610018014907837,181.2024169921875],[2.8281582593917847,180.70077362060547],[3.056841254234314,180.2038314819336],[3.2963223934173587,179.7119873046875],[3.5466655254364015,179.22557830810547],[3.808446216583252,178.7452590942383],[4.081755900382996,178.27136688232423],[4.366691279411316,177.80433807373046],[4.653297877311707,177.3384201049805],[4.936250543594361,176.87022094726564],[5.217279386520386,176.40079193115236],[5.496783924102783,175.93054962158203],[5.775464010238648,175.4598114013672],[6.053484535217286,174.98869628906252],[6.3309601783752445,174.5171844482422],[6.60796160697937,174.0454345703125],[6.884499359130859,173.57342681884765],[7.160866641998291,173.10130004882814],[7.4366816043853765,172.62887573242188],[7.712497186660767,172.15645141601564],[7.987895584106446,171.68370971679687],[8.263132190704345,171.21094818115236],[8.538291931152344,170.73814697265627],[8.812850379943848,170.2649887084961],[9.087428045272828,169.7917907714844],[9.36198649406433,169.31863250732422],[9.636544322967529,168.84547424316406],[9.911122608184815,168.37227630615234],[10.1855149269104,167.89903869628907],[10.459390258789062,167.42548370361328],[10.733265590667726,166.9519287109375],[11.007160758972168,166.47833404541015],[11.281037330627441,166.0047790527344],[11.554912662506103,165.5312240600586],[11.828807830810547,165.05763931274416],[12.102303791046143,164.58386611938477],[12.375667095184326,164.11001358032226],[12.64904899597168,163.6361312866211],[12.922412300109864,163.1622787475586],[13.195775604248047,162.6884262084961],[13.46913766860962,162.2145736694336],[13.742520809173584,161.74068145751954],[14.015590286254882,161.26664047241212],[14.288550662994385,160.79255981445314],[14.561530876159669,160.31843948364258],[14.83449125289917,159.8443588256836],[15.107451629638673,159.37027816772462],[15.380412006378174,158.89619750976564],[15.653392219543457,158.42207717895508],[15.92617530822754,157.9478874206543],[16.19866828918457,157.4735290527344],[16.471181106567382,156.9991409301758],[16.743672847747803,156.52479248046876],[