
from w import *

%matplotlib inline




f1_sgd_mom0 = np.load('Recs/test_acc << ResNet50-SGD+cos $ 0.1 ^ 0.0.npy')
f1_sgd = np.load('Recs/test_acc << ResNet50-SGD $ 0.1.npy')
f1_sgd_mom999 = np.load('Recs/test_acc << ResNet50-SGD+cos $ 0.1 ^ 0.999.npy')
f1_adam = np.load('Recs/test_acc << ResNet50-Adam $ 0.1.npy')
f1_sgd_cos = np.load('Recs/test_acc << ResNet50-SGD+cos $ 0.1 ^ 0.5.npy')
f1_sr = np.load('Recs/test_acc << ResNet50-sr.npy')





f2_sr = np.load('Recs/ResNet152_sr.npy')
f2_sgd_cos_mom0 = np.load('Recs/test_acc << ResNet152-SGD+cos $ 0.1 ^ 0.0.npy')
f2_sgd_cos = np.load('Recs/test_acc << ResNet152-SGD+cos $ 0.1.npy')
f2_sgd_nest = np.load('Recs/test_acc << ResNet152-SGD+cos+nesterov $ 0.1 ^ 0.9.npy')
f2_adam_01 = np.load('Recs/test_acc << ResNet152-Adam $ 0.01.npy')




f3_sgd_cos_mom0 = np.load('Recs/test_acc << MobileNetV2-SGD+cos $ 0.1 ^ 0.0.npy')
f3_sr = np.load('Recs/MobileNetV2_sr.npy')
f3_sgd_cos_nest = np.load('Recs/test_acc << MobileNetV2-SGD+cos+nesterov $ 0.1 ^ 0.9.npy')
f3_sgd_cos = np.load('Recs/test_acc << MobileNetV2-SGD+cos $ 0.1.npy')
f3_sgd_lr001 = np.load('Recs/test_acc << MobileNetV2-SGD $ 0.001.npy')
f3_adam_cos = np.load('Recs/test_acc << MobileNetV2-Adam+cos+0.1.npy')








spacing = 0.8
L = 0.68
L2 = 0.5


ft1 = 17
ftlabel = 14
linewidth = 2
markersize = 4






plt.axes([0,0,L,L2])
plt.title('ResNet50 on Cifar10', fontsize=ft1)
plt.xlabel('Epochs', fontsize=ftlabel)
plt.ylabel('Test Acc.', fontsize=ftlabel)



arr = f1_sr
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | Symbolic L2O')
plt.text(len(arr)-35,arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f1_sgd_cos
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+cos')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f1_sgd_mom0
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+mom(0)')
plt.text(len(arr)-12,arr[-1]-12, f'{arr[-1]:.2f}%',ha='right')

arr = f1_sgd
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f1_sgd_mom999
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+mom(0.999)')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f1_adam
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | Adam')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')








plt.legend(loc='lower right')










plt.axes([spacing,0,L,L2])
plt.title('ResNet152 on Cifar100', fontsize=ft1)
plt.xlabel('Epochs', fontsize=ftlabel)
plt.ylabel('Test Acc.', fontsize=ftlabel)


arr = f2_sr
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | Symbolic L2O')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f2_sgd_cos_mom0
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+cos+mom(0)')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f2_sgd_cos
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+cos')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f2_sgd_nest
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+nest')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f2_adam_01
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | Adam+lr(0.01)')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')









plt.legend(loc='lower right')




plt.axes([spacing*2,0,L,L2])
plt.title('MobileNetV2 on Cifar100', fontsize=ft1)
plt.xlabel('Epochs', fontsize=ftlabel)
plt.ylabel('Test Acc.', fontsize=ftlabel)


arr = f3_sr
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | Symbolic L2O')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f3_sgd_cos_mom0
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+cos+mom(0)')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f3_sgd_cos_nest
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+cos+nest')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f3_sgd_cos
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+cos')
plt.text(len(arr)-25,arr[-1]-5, f'{arr[-1]:.2f}%',ha='right')

arr = f3_sgd_lr001
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | SGD+lr(0.001)')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')

arr = f3_adam_cos
plot(arr, random_line_marker(), linewidth = linewidth, markersize=markersize, label=f'Acc {arr[-1]:.2f} | Adam+cos')
plt.text(len(arr),arr[-1], f'{arr[-1]:.2f}%',ha='right')







plt.legend(loc='lower right')

plt.savefig('nipslarge.pdf', bbox_inches='tight')
