# Adversarially Slicing Generative Network

## Usage
This repository provides the code to train Slicing Adversarial Network (SAN) on vision dataset.
This repository is based on the PyTorch implementation of BigGAN by the authors: https://github.com/ajbrock/BigGAN-PyTorch.

## How to train
Example 1. SAN on CIFAR10 (unconditional):
```
sh scripts/launch_cifar10U_SAN.sh
```
Example 2. SAN on CIFAR10 (conditional):
```
sh scripts/launch_cifar10_SAN.sh
```
You can change experimental settings by editing the bash files.

## Modification of the original code for SAN
| Filename | Description |
| ---- | ---- |
| BigSAN.py | Created to modify the last linear layer of discriminator. The model size has not been changed from BigGAN.py. |
| loss.py | Added lines for maximization objectives of SAN  |

## Evaluation
1. Sample images and save them into npz file (e.g., by excuting "scripts/sample_cifar10U_SAN.sh").
2. Save Inception moments of generated samples and calculate Inception Score by excuting "inception_tf13.py".
3. Calculate FID score by excuting fid_score.py.


## Acknowledgement
- PyTorch BigGAN implementation from https://github.com/ajbrock/BigGAN-PyTorch
- TensorFlow Inception Score code from https://github.com/openai/improved-gan